var BarcodeView = Backbone.View.extend({
    events: {
        'click .save-button': 'saveChanges',
        'click #embeddedPrice': 'embeddedPrice',
        'click #embeddedWeight': 'embeddedWeight',
        'click .search-items-button': 'pullItems',
        'keyup #print': 'changePrintQuantity',
        'click #clearBarcodeCount' : 'clearBarcodeCount',
        'click #saveBarcodeCounts' : 'saveBarcodeCount',
        'click .pagination-trigger': 'handlePageClickEvent',
        'click #pagination-back': 'handlePageBackEvent',
        'click #pagination-forward': 'handlePageForwardEvent',
    },
    data: {},
    breadcrumb: {},
    itemsStyleMapping: {},
    styles: [
        'ap-blue',
    ],
    itemsRows: 3,
    itemsColumns: 4,
    pages: 0,
    itemTypesTotal: 0,
    advancedOptionSwitch: 0,
    sort: 0,
    cards: true,
    itemsCollectionCut: {},
    currentPageIndex: null,
    selectedPageIndex: 1,
    canAddDelete: false,
    changeItems: false,
    addedItem: false,
    shownItems: [],
    appendItem: false,
    initialLoad: 0,
    lastSearchState: { searchText: '', isInactiveOnly: false, searchField: '' },
    lastSearchText: '',
    isNewSearch: true,
    searchItemsTotal: 0,
    offset: 1,


    initialize: function (options) {
        this.offset = this.itemsColumns * this.itemsRows;
        this.options = options;
        this.template = _.template(options.template);
        this.breadcrumb = options.breadcrumb;
        this.collection = options.collection;
        this.model = options.model;
        // this.getItemBarcodes();
    },

    render: function () {   
        App.breadCrumbToolTip = "{Literal}Set/print barcodes for your items{/Literal}";
        App.setBreadcrumbs(this.breadcrumb);
        this.renderItems([]);
        var that = this;
        $(document).ready(function () {
            $('.tooltipped').tooltip();
            $('select').formSelect();
            $('.fixed-action-btn').floatingActionButton();
            that.$el.find('select').formSelect();
        });

        $(document).on('keydown', 'input, select', function(e) {
            var self = $(this)
              , form = self.parents('form:eq(0)')
              , focusable
              , next
              ;
            if (e.keyCode == 13) {
                focusable = form.find('input,a,select,button,select').filter(':visible');
                next = focusable.eq(focusable.index(this)+1);
                if (next.length) {
                    next.focus();
                } else {
                    form.submit();
                }
                return false;
            }
        });
        return this;
    },

    pullItems: function(e) {
        var that = this;
        if(e != undefined)
            that.isNewSearch = $(e.currentTarget).attr("id") === 'searchText' || $(e.currentTarget).closest(".search").length === 1;
        if(that.isNewSearch)
            that.selectedPageIndex = 1;

        var searchText = this.isNewSearch ? this.$el.find('#searchText').val() :  this.lastSearchState.searchText;
        var showInactiveOnly = this.isNewSearch ? this.$el.find('#showInactiveOnly input:checked').length > 0 : this.lastSearchState.isInactiveOnly;
        var searchField = this.isNewSearch ? this.$el.find('#searchField').val() : this.lastSearchState.searchField;

       
        var sessionToken = this.getCookie();
        document.getElementById("searchText").blur();

        $.ajax({
            url: '/data/search-items',
            data: {
                token: sessionToken,
                searchBy: searchField,
                searchText: searchText,
                showInactiveOnly: showInactiveOnly,
                offset: this.offset,
                pageNumber: this.selectedPageIndex
            },
            dataType: 'json',
            type: 'POST',
            success: function (data) {
                that.lastSearchState.searchText = searchText;
                that.lastSearchState.isInactiveOnly = showInactiveOnly;
                that.lastSearchState.searchField = searchField;
                that.searchItemsTotal = data.results[1].searchItemsTotal;
                that.renderItems(data.results[0]);
                that.showSearchItems(data.results[0]);
                that.searchItems();
            },
            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else {
                    M.toast({ html: '{Literal}There was a problem fetching item types from the server{/Literal}' });
                }
            }
        });
    },

    showSearchItems: function (filteredItems) {
        var that = this;
        var searchText = this.isNewSearch ? this.$el.find('#searchText').val() : this.lastSearchState.searchText;
        this.shownItems = filteredItems;
        if(searchText === '' && this.isNewSearch)
            M.toast({ html: '{Literal}Showing all items{/Literal}...' });
            
        if (filteredItems.length > 0) {
            this.collection.reset(filteredItems);
            if(this.isNewSearch)
                that.renderPaginator();
            else
                this.renderPaginationChange();

            that.cards = false;
            $('#itemBlock').fadeIn();
            $("select").formSelect();

            $('#itemBlock').fadeIn();
            $('#paginationBlock').fadeIn();
        }
        else {
            this.collection.reset();
            $('#paginationBlock').hide();
            M.toast({ html: '{Literal}No search results found{/Literal}' }); 
        }
    },

    searchItems: function () {
        $('#resultsBlock').html("");
        var that = this;
        var searchText = this.$el.find('#searchText').val();
        var searchField = this.$el.find('#searchField').val();

        if (searchText == '') {
            
                for (var i = 0; i < that.collection.length; i++) {
                    var html = '<div id = "itemCards" class="card">';
                    html += '<div class="col s12 m3">';
                    html += '<div class="card card-panel z-depth-1 sequence-card hoverable waves-effect waves-light" style="background-color: #ffffff" data-id="' + that.collection.models[i].attributes.id + '">';
                    html += '<div class="description truncate" style="color: #3970b7; font-size: 1rem; margin-bottom: 0px;">' + that.collection.models[i].attributes.id + '</div>';
                    html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray;">{Literal}Description{/Literal}:' + that.collection.models[i].attributes.description + '</div>';
                    html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray; padding-bottom: 10px">{Literal}Price{/Literal}: ' + that.collection.models[i].attributes.price + '</div>';
                    html += '<div class="card-action" style="padding: 0px 0px 0px 0px !important;">';
                    html += '<div class="input-field" style="margin-top: 0rem; margin-bottom: 0rem; width: 100%;">'
                    html += '<input id="print"  type="number" data-id="' + that.collection.models[i].attributes.id + '" value="' + that.collection.models[i].attributes.barcodeCount + '" maxlength="50" class = "barCodeInput">';
                    html += '</div></div></div></div></div>'

                    $('#resultsBlock').append(html);
                }
        }

        else if (searchField == 'byIdDescription') {
            var filtered = this.collection.byItemDescription(searchText);
            if (filtered.models.length > 0) {
                var delayInMilliseconds = 100;
                    for (var i = 0; i < filtered.length; i++) {
                        var html = '<div id = "itemCards" class="card">';
                        html += '<div class="col s12 m3">';
                        html += '<div class="card card-panel z-depth-1 sequence-card hoverable waves-effect waves-light" style="background-color: #ffffff" data-id="' + filtered.models[i].attributes.id + '">';
                        html += '<div class="description truncate" style="color: #3970b7; font-size: 1rem; margin-bottom: 0px;">' + filtered.models[i].attributes.id + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray;">{Literal}Description{/Literal}:' + filtered.models[i].attributes.description + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray; padding-bottom: 10px">{Literal}Price{/Literal}: ' + filtered.models[i].attributes.price + '</div>';
                        html += '<div class="card-action" style="padding: 0px 0px 0px 0px !important;">';
                        html += '<div class="input-field" style="margin-top: 0rem; margin-bottom: 0rem; width: 100%;">'
                        html += '<input id="print"  type="number" data-id="' + filtered.models[i].attributes.id + '" value="' + filtered.models[i].attributes.barcodeCount + '" maxlength="50" class = "barCodeInput">';
                        html += '</div></div></div></div></div>'

                        $('#resultsBlock').append(html);
                    }
            }
            else {
                M.toast({ html: '{Literal}No search results found{/Literal}' }); 
            }
        }

        else if (searchField == 1) {
            var filtered = this.collection.byItemId(searchText);

            if (filtered.models.length > 0) {
                    for (var i = 0; i < filtered.length; i++) {
                        var html = '<div id = "itemCards" class="card">';
                        html += '<div class="col s12 m3">';
                        html += '<div class="card card-panel z-depth-1 sequence-card hoverable waves-effect waves-light" style="background-color: #ffffff" data-id="' + filtered.models[i].attributes.id + '">';
                        html += '<div class="description truncate" style="color: #3970b7; font-size: 1rem; margin-bottom: 0px;">' + filtered.models[i].attributes.id + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray;">{Literal}Description{/Literal}:' + filtered.models[i].attributes.description + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray; padding-bottom: 10px">{Literal}Price{/Literal}: ' + filtered.models[i].attributes.price + '</div>';
                        html += '<div class="card-action" style="padding: 0px 0px 0px 0px !important;">';
                        html += '<div class="input-field" style="margin-top: 0rem; margin-bottom: 0rem; width: 100%;">'
                        html += '<input id="print"  type="number" data-id="' + filtered.models[i].attributes.id + '" value="' + filtered.models[i].attributes.barcodeCount + '" maxlength="50" class = "barCodeInput">';
                        html += '</div></div></div></div></div>'

                        $('#resultsBlock').append(html);
                    }
            }
            else {
                M.toast({ html: '{Literal}No search results found{/Literal}' });
            }
        }

        else if (searchField == 'byType') {
            var filtered = this.collection.byItemType(searchText);
            if (filtered.models.length > 0) {
                    for (var i = 0; i < filtered.length; i++) {
                        var html = '<div id = "itemCards" class="card">';
                        html += '<div class="col s12 m3">';
                        html += '<div class="card card-panel z-depth-1 sequence-card hoverable waves-effect waves-light" style="background-color: #ffffff" data-id="' + filtered.models[i].attributes.id + '">';
                        html += '<div class="description truncate" style="color: #3970b7; font-size: 1rem; margin-bottom: 0px;">' + filtered.models[i].attributes.id + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray;">{Literal}Description{/Literal}:' + filtered.models[i].attributes.description + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray; padding-bottom: 10px">{Literal}Price{/Literal}: ' + filtered.models[i].attributes.price + '</div>';
                        html += '<div class="card-action" style="padding: 0px 0px 0px 0px !important;">';
                        html += '<div class="input-field" style="margin-top: 0rem; margin-bottom: 0rem; width: 100%;">'
                        html += '<input id="print"  type="number"data-id="' + filtered.models[i].attributes.id + '" value="' + filtered.models[i].attributes.barcodeCount + '" maxlength="50" class = "barCodeInput">';
                        html += '</div></div></div></div></div>'

                        $('#resultsBlock').append(html);
                    }
            }
            else {
                M.toast({ html: '{Literal}No search results found{/Literal}' }); 
            }
        }

        else if (searchField == 'byAltDesctription') {
            var filtered = this.collection.byAltDescription(searchText);
            if (filtered.models.length > 0) {
                    for (var i = 0; i < filtered.length; i++) {
                        var html = '<div id = "itemCards" class="card">';
                        html += '<div class="col s12 m3">';
                        html += '<div class="card card-panel z-depth-1 sequence-card hoverable waves-effect waves-light" style="background-color: #ffffff" data-id="' + filtered.models[i].attributes.id + '">';
                        html += '<div class="description truncate" style="color: #3970b7; font-size: 1rem; margin-bottom: 0px;">' + filtered.models[i].attributes.id + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray;">{Literal}Description{/Literal}:' + filtered.models[i].attributes.description + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray; padding-bottom: 10px">{Literal}Price{/Literal}: ' + filtered.models[i].attributes.price + '</div>';
                        html += '<div class="card-action" style="padding: 0px 0px 0px 0px !important;">';
                        html += '<div class="input-field" style="margin-top: 0rem; margin-bottom: 0rem; width: 100%;">'
                        html += '<input id="print"  type="number" data-id="' + filtered.models[i].attributes.id + '" value="' + filtered.models[i].attributes.barcodeCount + '" maxlength="50" class = "barCodeInput">';
                        html += '</div></div></div></div></div>'

                        $('#resultsBlock').append(html);
                    }
            }
            else {
                M.toast({ html: '{Literal}No search results found{/Literal}' });
            }
        }

        else if (searchField == 'byCategory') {
            var filtered = this.collection.byCategory(searchText);
            if (filtered.models.length > 0) {
                    for (var i = 0; i < filtered.length; i++) {
                        var html = '<div id = "itemCards" class="card">';
                        html += '<div class="col s12 m3">';
                        html += '<div class="card card-panel z-depth-1 sequence-card hoverable waves-effect waves-light" style="background-color: #ffffff" data-id="' + filtered.models[i].attributes.id + '">';
                        html += '<div class="description truncate" style="color: #3970b7; font-size: 1rem; margin-bottom: 0px;">' + filtered.models[i].attributes.id + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray;">{Literal}Description{/Literal}:' + filtered.models[i].attributes.description + '</div>';
                        html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray; padding-bottom: 10px">{Literal}Price{/Literal}: ' + filtered.models[i].attributes.price + '</div>';
                        html += '<div class="card-action" style="padding: 0px 0px 0px 0px !important;">';
                        html += '<div class="input-field" style="margin-top: 0rem; margin-bottom: 0rem; width: 100%;">'
                        html += '<input id="print"  type="number" data-id="' + filtered.models[i].attributes.id + '" value="' + filtered.models[i].attributes.barcodeCount + '" maxlength="50" class = "barCodeInput">';
                        html += '</div></div></div></div></div>'

                        $('#resultsBlock').append(html);
                    }
            }
            else {
                M.toast({ html: '{Literal}No search results found{/Literal}' });
            }
        }
    },

    changePrintQuantity: function (e) {
        var element = $(e.currentTarget);
        var id = $(element).attr('data-id');

        for (var i = 0; i < this.collection.models.length; i++) {
            if (this.collection.models[i].attributes.id == id) {
                this.collection.models[i].attributes.barcodeCount = element[0].value;
                this.collection.models[i].attributes.isChanged = true;
                break;
            }
        }
    },

    getCookie: function() {
        var nameEQ = "sessionCookie" + "=";
        var ca = document.cookie.split(';');
        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
        }
    },

    getItemBarcodes: function () {
        var that = this;
        var sessionToken = this.getCookie();
        $.ajax({
            url: '/data/get-item-barcodes',
            data: {
                token: sessionToken
            },
            dataType: 'json',
            type: 'POST',
            success: function (data) {
                that.renderItems(data.results);
            },
            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else {
                    M.toast({ html: '{Literal}There was a problem retrieving all items{/Literal}.' });
                }
            }
        });
    },

    renderItems: function (data) {
        var that = this;
        this.generateItemsStyleMapping(data);

        data.sort(function (a, b) {
            return a.id < b.id ? -1 : (a.id > b.id ? 1 : 0);
        });
        
        barcodeCollection = new BarcodeCollection();
        for (var i = 0; i < data.length; i++) {
            var currentItems = data[i];
            if (currentItems.barcodeCount > 0) {
            }
            currentItems.cardStyleClass = that.itemsStyleMapping[data[i].id];
            barcodeCollection.add(new Barcode(currentItems));
        }
        this.collection = barcodeCollection;
      
        this.$el.html(this.template({
            items: this.collection.toJSON(),
        })); 
        $('.fixed-action-btn').floatingActionButton();
        $('select').formSelect();
        $('.tooltipped').tooltip();
    },

    generateItemsStyleMapping: function (data) {
        var items = [];
        var totalStyles = this.styles.length;
        var currentStyle = 0;
        for (var i = 0; i < data.length; i++) {
            if (items.indexOf(data[i].id) < 0) {
                items.push(data[i].id);
                this.itemsStyleMapping[data[i].id] = this.styles[currentStyle];
                if (currentStyle < totalStyles - 1) {
                    currentStyle++;
                } else {
                    currentStyle = 0;
                }
            }
        }
    },

    clearBarcodeCount: function () {
        var that = this;
        var sessionToken = this.getCookie();

        $.ajax({
            url: '/data/clear-barcode-counts',
            data: {
                token: sessionToken
            },
            dataType: 'json',
            type: 'POST',
            
            success: function (data) {
                $('#resultsBlock').html("");
                $('#barcodeBlock').html("");

                for (var i = 0; i < that.collection.models.length; i++) {
                    if (that.collection.models[i].attributes.barcodeCount > 0) {
                        that.collection.models[i].attributes.barcodeCount = 0;
                    }
                }
                M.toast({ html: '{Literal}Barcodes Cleared successfully{/Literal}' });
            },

            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else {
                    M.toast({ html: '{Literal}There was a problem clearing barcode settings{/Literal}' });
                }
            }
        });
    },

    saveBarcodeCount: function () {
        var that = this;
        var sessionToken = this.getCookie();

        var updatedPageModels = {};

        $('#barcodeBlock').html("");
        $('#resultsBlock').html("");

        Object.size = function(obj) {
            var size = 0, key;
            for (key in obj) {
                if (obj.hasOwnProperty(key)) size++;
            }
            return size;
        };

        for (var i =0; i < this.collection.models.length; i++) {
            if (this.collection.models[i].attributes.barcodeCount > 0) {
                updatedPageModels[Object.size(updatedPageModels)] = this.collection.models[i].attributes;
            }
        }
        
        var keysSent = 0;

        for (var t = 0; t < Object.size(updatedPageModels); t++) {
            $.ajax({
                url: '/data/save-barcode-count',
                data: {
                    token: sessionToken,
                    item: JSON.stringify(updatedPageModels[t]),
                },
                dataType: 'json',
                type: 'POST',
                
                success: function (data) {
                    keysSent++;

                   

                    if (keysSent == Object.size(updatedPageModels) - 1) {
                        M.toast({ html: '{Literal}Barcode Counts saved successfully{/Literal}' });
                    }
                },

                error: function (e) {
                    if (e.status == 523) {
                        window.location.href = "#/log-in";
                        location.reload();
                    }
                    else {
                        M.toast({ html: '{Literal}There was a problem adding this Barcode Count{/Literal}.' });
                    }
                }
            });

            
            var html = '<div id = "itemCards" class="card">';
            html += '<div class="col s12 m3">';
            html += '<div class="card card-panel z-depth-1 sequence-card hoverable waves-effect waves-light" style="background-color: #ffffff" data-id="' + updatedPageModels[t].id + '">';
            html += '<div class="description truncate" style="color: #3970b7; font-size: 1rem; margin-bottom: 0px;">' + updatedPageModels[t].id + '</div>';
            html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray;">{Literal}Description{/Literal}:' + updatedPageModels[t].description + '</div>';
            html += '<div class="type truncate" style="font-size: .95rem; margin-bottom: 0px; color: gray; padding-bottom: 10px">{Literal}Price{/Literal}: ' + updatedPageModels[t].price + '</div>';
            html += '<div class="card-action" style="padding: 0px 0px 0px 0px !important;">';
            html += '<div class="input-field" style="margin-top: 0rem; margin-bottom: 0rem; width: 100%;">'
            html += '<input id="print"  type="number" data-id="' + updatedPageModels[t].id + '" value="' + updatedPageModels[t].barcodeCount + '" maxlength="50" class = "barCodeInput">';
            html += '</div></div></div></div></div>'
            $('#barcodeBlock').append(html);
        }
    },

    renderPaginator: function () {
        $('.pagination-trigger').remove();

        this.pages = Math.ceil(1.0 * this.searchItemsTotal / (this.itemsRows * this.itemsColumns));
        if(this.pages == 1) {
            $("#items-pagination").hide();
            return;
        }
        
        if (this.pages > 10 & this.selectedPageIndex > 5) {
            if (this.pages < this.selectedPageIndex + 6) {
                var start = this.selectedPageIndex - 4;
                var currentPageElement = $('<li class="waves-effect pagination-trigger" data-page="' + start + '"><a href="javascript:void(0)">' + start + '</a></li>');
                $("#pagination-back").after(currentPageElement);
                for (var i = this.selectedPageIndex - 3; i <= this.pages; i++) {
                    var lastElement = currentPageElement;
                    currentPageElement = $('<li class="waves-effect pagination-trigger" data-page="' + i + '"><a href="javascript:void(0)">' + i + '</a></li>');
                    if (this.selectedPageIndex === i) {
                        $(currentPageElement).addClass('active').addClass('ap-blue');
                    }
                    $(lastElement).after(currentPageElement);
                }
            }
            else {
                var start = this.selectedPageIndex - 4;
                var currentPageElement = $('<li class="waves-effect pagination-trigger" data-page="' + start + '"><a href="javascript:void(0)">' + start + '</a></li>');
                $("#pagination-back").after(currentPageElement);
                for (var i = this.selectedPageIndex - 3; i <= this.selectedPageIndex + 5; i++) {
                    var lastElement = currentPageElement;
                    currentPageElement = $('<li class="waves-effect pagination-trigger" data-page="' + i + '"><a href="javascript:void(0)">' + i + '</a></li>');
                    if (this.selectedPageIndex === i) {
                        $(currentPageElement).addClass('active').addClass('ap-blue');
                    }
                    $(lastElement).after(currentPageElement);
                }
            }
        } 
        else if (this.pages > 10 & this.selectedPageIndex < 6) {
            var currentPageElement = $('<li class="pagination-trigger" data-page="1"><a href="javascript:void(0)">1</a></li>');
            if (this.selectedPageIndex === 1) {
                $(currentPageElement).addClass('active').addClass('ap-blue');
            }
            $("#pagination-back").after(currentPageElement);
            for (var i = 2; i <= 10; i++) {
                var lastElement = currentPageElement;
                currentPageElement = $('<li class="waves-effect pagination-trigger" data-page="' + i + '"><a href="javascript:void(0)">' + i + '</a></li>');
                if (this.selectedPageIndex === i) {
                    $(currentPageElement).addClass('active').addClass('ap-blue');
                }
                $(lastElement).after(currentPageElement);
            }
        }
        else {
            var currentPageElement = $('<li class="pagination-trigger" data-page="1"><a href="javascript:void(0)">1</a></li>');
            if (this.selectedPageIndex === 1) {
                $(currentPageElement).addClass('active').addClass('ap-blue');
            }
            $("#pagination-back").after(currentPageElement);
            for (var i = 2; i <= this.pages; i++) {
                var lastElement = currentPageElement;
                currentPageElement = $('<li class="waves-effect pagination-trigger" data-page="' + i + '"><a href="javascript:void(0)">' + i + '</a></li>');
                if (this.selectedPageIndex === i) {
                    $(currentPageElement).addClass('active').addClass('ap-blue');
                }
                $(lastElement).after(currentPageElement);
            }
        }
        
        if (this.initialLoad <= 1 ) {
            this.initialLoad++;
        }
        else {
            $('#searchText').attr('readonly', 'readonly'); // Force keyboard to hide on input field.
            $('#searchText').attr('disabled', 'true'); // Force keyboard to hide on textarea field.
            setTimeout(function() {
                $('#searchText').blur();  //actually close the keyboard
                // Remove readonly attribute after keyboard is hidden.
                $('#searchText').removeAttr('readonly');
                $('#searchText').removeAttr('disabled');
            }, 100);
        }
        
        $("#items-pagination").show();
    },

    handlePageBackEvent: function (e) {
        var element = $(e.currentTarget);
        if (!$(element).hasClass('disabled')) {
            var currentPage = parseInt($("#items-pagination").attr("data-current-page"));
            this.isNewSearch = false;
            this.selectedPageIndex--;
            this.pullItems();
            // this.goToItemsPage(this.selectedPageIndex, -1);

        }
    },

    handlePageForwardEvent: function (e) {
        var element = $(e.currentTarget);
        if (!$(element).hasClass('disabled')) {
            var currentPage = parseInt($("#items-pagination").attr("data-current-page"));
            this.isNewSearch = false;
            this.selectedPageIndex++;
            this.pullItems();
    }
        
    },

    handlePageClickEvent: function (e) {
        var element = $(e.currentTarget);
        var selectedPage = parseInt($(element).attr('data-page'));
        this.selectedPageIndex = parseInt($(element).attr('data-page'));
        var currentPage = parseInt($("#items-pagination").attr("data-current-page"));
        this.isNewSearch = false;
        this.pullItems();
    },

    goToItemsPage: function (selectedPage, currentPage) {
        var element = $(".pagination-trigger[data-page=" + selectedPage + "]");
        var offset = this.itemsColumns * this.itemsRows;
        var args = {
            selectedPage: selectedPage,
            element: element,
            parentView: this
        };       
    },
    
    renderPaginationChange: function (items, args) {
        this.cards = true;
        this.renderPaginator();

        $('.modal').modal();
        $('select').formSelect();
        $("#items-pagination").attr("data-current-page", this.selectedPageIndex);
        
        if (this.selectedPageIndex === 1) {
            $('#itemBlock').fadeIn();
            $('#paginationBlock').show();
            $("#pagination-back").addClass('disabled').removeClass('waves-effect');
            $("#pagination-forward").removeClass('disabled').addClass('waves-effect');
        } else if (this.selectedPageIndex === 1) {
            $("#pagination-back").addClass('disabled').removeClass('waves-effect');
            $("#pagination-forward").removeClass('disabled').addClass('waves-effect');
        } else if (this.selectedPageIndex === this.pages) {
            $('#itemBlock').fadeIn();
            $('#paginationBlock').show();
            $("#pagination-back").removeClass('disabled').addClass('waves-effect');
            $("#pagination-forward").addClass('disabled').removeClass('waves-effect');
        } else {
            $('#itemBlock').fadeIn();
            $('#paginationBlock').show();
            $("#pagination-back").removeClass('disabled').addClass('waves-effect');
            $("#pagination-forward").removeClass('disabled').addClass('waves-effect');
        }

        $("#items-modal-preloader").hide();
    },
});
