var AppRouter = Backbone.Router.extend({
    literals: [],
    breadCrumbToolTip: '',
    rtl: false,
    foodService: false,
    accuShift: false,
    vatTax: false,
    accounting: false,
    israCardBuild: false,
    loadedPages: [],
    IDS_SALE: "Make Sales",
    IDS_VOID: "Make Voids",
    IDS_VOID_CF: "Annulez une Transaction",
    IDS_RETURN: "Make Returns",
    IDS_MANAGE: "Manage",
    IDS_X: "Read Cash Tills",
    IDS_Z: "Reset Cash Tills",
    IDS_Z_CURRENT_TILL: "Reset Current Till",
    IDS_SETTINGS: "Change System Settings",
    IDS_USERS: "Add/Edit Users",
    IDS_GROUPS: "Add/Edit User Groups",
    IDS_TAXES: "Add/Edit Taxing Authorities",
    IDS_IMPORT: "Import Files",
    IDS_EXPORT: "Export Files",
    IDS_TILLS: "Add/Edit Cash Tills",
    IDS_CLEAR: "Clear Cash Tills",
    IDS_CLEAR_FILES: "Clear Data Files",
    IDS_ADD_DEL_ITEMS: "Add/Delete Items",
    IDS_QUIT: "Exit Point of Sale Program",
    IDS_CHANGE_PRICE: "Change Prices",
    IDS_CHANGE_PRICE_CF: "Modifiez un Prix",
    IDS_MODIFY_ITEMS: "Change Items",
    IDS_MODIFY_CUSTOMERS: "Change Customer Information",
    IDS_SETTLE: "Settle (Close) Credit Card Batches",
    IDS_NOSALE: "No Sale",
    IDS_COMPS: "Food Service Comps",
    IDS_REOPEN: "Reopen closed sales",
    IDS_CANCEL_SALE: "Cancel sales",
    IDS_TILL_INUSE: "Log in till in use",
    IDS_LOAD_ALL_ORDERS: "Load All Orders",
    IDS_CHANGE_SERVER: "Change Server",
    IDS_REFUND: "Make Refund",
    IDS_CARDS_SETUP: "Cards/Merchant Setup",
    IDS_ADJUST_INVENTORY: "Adjust Inventory",
    IDS_RECEIVE_INVENTORY: "Receive Inventory",
    IDS_ACCUSHIFT_MGMT: "AccuShift Management",
    IDS_OVERRIDE_CREDIT_LIMIT: "Override Credit Limit",
    IDS_EDIT_REOPENED_ORDER: "Edit Reopened Orders",
    IDS_OVERRIDE_FORCE_GUEST_COUNT: "Override Required Guest Count",
    IDS_CHANGE_CONVERSION_RATE: "Change Currency Conversion Rate",
    IDS_CHANGE_ITEM_DESCRIPTIONS: "Change Item Descriptions",
    IDS_ALLOW_SPLITTING_CHECKS: "Allow Splitting Checks",
    IDS_CHANGE_SALES_REP: "Change Sales Rep",
    IDS_ISRACARD_DASHBOARD: "IsraCard Dashboard",
    IDS_CLOUD_REPORTING: "Cloud Reporting",
    IDS_DELETE_TENDER_CODE: "Delete Tender Code",
    IDS_ACCUSERVER_HOST_SETUP: "AccuServer Host Setup",

    serverInfo: {
        isFoodService: false,
        hasAccuShift: false,
        isRightToLeft: false,
        hasVatTax: false,
        hasIntegratedRemoteDisplay: false,
        hasSageLiveIntegration: false,
        hasQBOIntegration: false,
        hasAccounting: false,
        hasRemoteDisplay: false,
        israCardBuild: false,
        isMobileServer: false,
        hasCloudReporting: false
    },

    routes: {
        "": "forwardToLogin",
        "advanced-items" : "advancedItems",
        "advanced-settings" : "advancedSettings",
        "alternative-taxes" : "alternativeTaxes",
        "backup-restore" : "backupRestore",
        "barcode" : "barcode",
        "breaks" : "breaks",
        "card-setup": "cardSetup",
        "choice-keys": "choiceKeys",
        "choice-keys-mobile": "choiceKeysMobile",
        "clear-data" : "clearData",
        "comp-reasons": "compReasons",
        "company-info": "companyInfo",
        "customer-terms": "customerTerms",
        "customers": "customers",
        "dashboard": "dashboard",
        "deli-scale":"deliScale",
        "discount-reasons": "discountReasons",
        "course-names": "courseNames",
        "e-conduit": "eConduit",
        "tripos": "triPOS",
        "employees":"employees",
        "flex-groups": "flexGroups",
        "follow-on": "followOn",
        "group-items" : "groupItems",
        "home": "home",
        "import-export": "importExport",
        "import-export-data": "importExportData",
        "integrations": "integrations",
        "inventory": "inventory",
        "inventory-adjustments": "inventoryAdjustments",
        "items": "items",
        "item-attributes": "itemAttributes",
        "log-in": "logIn",
        "no-partial": "noPartial",
        "operator-messages": "operatorMessages",
        "pay-period":"payPeriod",
        "pay-types": "payTypes",
        "pos-keys": "posKeys",
        "pos-keys-mobile": "posKeysMobile",
        "pos-users": "posUsers",
        "price-level-times": "priceLevelTimes",
        "product-lines": "productLines",
        "qbo": "qbo",
        "receipt-settings": "receiptSettings",
        "recipes": "recipes",
        "remote-display" : "remoteDevices",
        "remote-printing": "remotePrinting",
        "reports": "reports",
        "rooms-tables": "roomsTables",
        "sales" : "sales",
        "sales-taxes" : "salesTaxes",
        "session-expired": "sessionExpired",
        "snap-ebt": "snapEBT",
        "taxes" : "taxes",
        "tender-types" : "tenderTypes",
        "tills" : "tills",
        "units-of-measure": "unitsOfMeasure",
        "user-groups": "userGroups",
        "scheduled-email-reports": "scheduledEmailReports",
        "server-configuration": "serverConfiguration",
        "pos-stations": "posStations",
        // this route MUST be the last one:
        "*invalidRoute": "pageNotFound"
    },
    
    i18n: {
        cancel: '{Literal}Cancel{/Literal}',
        clear: '{Literal}Clear{/Literal}',
        done: '{Literal}Done{/Literal}',
        previousMonth: this.rtl ? '›' : '‹',
        nextMonth: this.rtl ? '‹' : '›',
        months: [
            '{Literal}January{/Literal}',
            '{Literal}February{/Literal}',
            '{Literal}March{/Literal}',
            '{Literal}April{/Literal}',
            '{Literal}May{/Literal}',
            '{Literal}June{/Literal}',
            '{Literal}July{/Literal}',
            '{Literal}August{/Literal}',
            '{Literal}September{/Literal}',
            '{Literal}October{/Literal}',
            '{Literal}November{/Literal}',
            '{Literal}December{/Literal}'
        ],
        monthsShort: [
            '{Literal}Jan{/Literal}',
            '{Literal}Feb{/Literal}',
            '{Literal}Mar{/Literal}',
            '{Literal}Apr{/Literal}',
            '{Literal}May{/Literal}',
            '{Literal}Jun{/Literal}',
            '{Literal}Jul{/Literal}',
            '{Literal}Aug{/Literal}',
            '{Literal}Sep{/Literal}',
            '{Literal}Oct{/Literal}',
            '{Literal}Nov{/Literal}',
            '{Literal}Dec{/Literal}'
        ],
        weekdays: [
            '{Literal}Sunday{/Literal}',
            '{Literal}Monday{/Literal}',
            '{Literal}Tuesday{/Literal}',
            '{Literal}Wednesday{/Literal}',
            '{Literal}Thursday{/Literal}',
            '{Literal}Friday{/Literal}',
            '{Literal}Saturday{/Literal}'
        ],
        weekdaysShort: [
            '{Literal}Sun{/Literal}',
            '{Literal}Mon{/Literal}',
            '{Literal}Tue{/Literal}',
            '{Literal}Wed{/Literal}',
            '{Literal}Thu{/Literal}',
            '{Literal}Fri{/Literal}',
            '{Literal}Sat{/Literal}'
        ],
        weekdaysAbbrev: [
            '{Literal}Su{/Literal}',
            '{Literal}M{/Literal}',
            '{Literal}T{/Literal}',
            '{Literal}W{/Literal}',
            '{Literal}T{/Literal}',
            '{Literal}F{/Literal}',
            '{Literal}S{/Literal}'
        ]
    },

    timepickerOptions: {
        autoClose: true,
        container: 'body',
    },

    historyStarted: false,

    showToast: function (message) {
        M.Toast.dismissAll();
        M.toast({
            html: message
        });
    },

    isMobileDevice: async function() {
        try {
            var isMobile = false;
            var deviceWidth = (window.innerWidth > 0) ? window.innerWidth : screen.width;
            if (deviceWidth < 600 || deviceWidth == 1280) {
                isMobile = true;
            }
            return isMobile;
        } catch (e) {
            return false;
        }
    },

    forwardToLogin: function() {
        window.location.href = "/#/log-in";
    },

    setBreadcrumbs: function (breadcrumbs) {
        var breadcrumbsHtml = "";
        for (var i = 0; i < breadcrumbs.length; i ++) {
            if (!this.isMobileDevice() || (i === breadcrumbs.length - 1)) {
                if (breadcrumbs.length == 1) {
                    breadcrumbsHtml += '<a href="' + breadcrumbs[i].path + '" class="breadcrumb blue-text darken-2">' + breadcrumbs[i].label + '</a>';
                    breadcrumbsHtml += '<a href="javascript:void(0)" id="infoIcon" class="blue-text waves-effect waves-light"> <i class="blue-text material-icons tooltipped" data-position="bottom" data-tooltip="{Literal}' + this.breadCrumbToolTip + '{/Literal}">info_outline</i></a>'
                }
                else {
                    breadcrumbsHtml += '<a href="' + breadcrumbs[i].path + '" class="breadcrumb blue-text darken-2">' + breadcrumbs[i].label + '</a>';
                    if (i > 0) {
                        breadcrumbsHtml += '<a href="javascript:void(0)" id="infoIcon" class="blue-text waves-effect waves-light"> <i class="blue-text material-icons tooltipped" data-position="bottom" data-tooltip="{Literal}' + this.breadCrumbToolTip + '{/Literal}">info_outline</i></a>'
                    }
                }
                
            }
        }
        $("#breadcrumbs").html(breadcrumbsHtml);
    },

    initGlobalAjaxHandlers: function () {
        var that = this;
        $(document).ajaxComplete(function(request, response, meta) {
            var payload = {};
            if (typeof response !== 'undefined') {
                if (typeof response.responseJSON !== 'undefined') {
                    payload = response.responseJSON;
                } else if (typeof response.responseText !== 'undefined') {
                    try {
                        payload = JSON.parse(response.responseText);
                    } catch (e) { }
                }
            }
            if (typeof payload.error !== 'undefined' && payload.error === 'SESSION_EXPIRED') {
                that.navigate('session-expired', {trigger: true});
            }
        });
    },

    initialize: async function () {

        this.isTokenValid();
        var isIE = /*@cc_on!@*/false || !!document.documentMode;
        var isEdge = !isIE && !!window.StyleMedia;
        this.initGlobalAjaxHandlers();
        var that = this;

        if(this.i18n.weekdaysAbbrev[2] == 'ה') 
            this.i18n.weekdaysAbbrev[2] = 'ג';
            
        window.onhashchange = function () {
            if (location.hash === '#/log-in')
                $('.sidenav, .nav-wrapper, .white').hide();
            else
                $('.sidenav, .nav-wrapper, .white').show();
          }
          

        var initSideNavAndScrollbars = function () {
            document.getElementById('nav-company-name').innerText = that.serverInfo.companyName;
            document.title += ' - ' + that.serverInfo.companyName;
            if(that.serverInfo.companyName) {   
                document.getElementById('nav-company-name').innerText = that.serverInfo.companyName;
                document.title += ' - ' + that.serverInfo.companyName;
            }
            if (that.serverInfo.isMobileServer ) {
                $("#compactBlock").hide();
            }

            if (!that.serverInfo.isFoodService) {
                $("#itemFoodServiceBlock1").hide();
                $("#itemFoodServiceBlock2").hide();
                $("#itemFoodServiceBlock3").hide();
                $("#rooms-and-tables-menu-item").hide();
                $("#choice-keys-menu-item").hide();
                $('#CompReasonsBlock').hide();
            }
            if (!that.serverInfo.hasAccounting) {
                $('#AccountingIndexBlock').hide();
            }
            if(!that.serverInfo.hasQBOIntegration)
                $('#quickBooksOnline').hide();
            if (!that.serverInfo.hasVatTax) {
                $('#VatTaxBlock').hide();
            }
            else {
                $('#TaxBlock1').hide();
                $('#TaxBlock2').hide();
            }

            if (!that.serverInfo.hasIntegratedRemoteDisplay || !that.serverInfo.hasRemoteDisplay) {
                $("#remoteDisplayBlock").hide();
            }
            else {
                $("#remoteDisplayBlock").show();
            }

            if (!that.serverInfo.hasAccuShift) {
                $('#EmployeesBlock1').hide();
                $('#EmployeesBlock2').hide();
            }
            try {
                if (!that.serverInfo.isRightToLeft) {
                    $('#auditBlock').hide();
                }
                if (that.serverInfo.isRightToLeft === true) {
                    $("#rtl-supprt-css").removeAttr("disabled");
                }
            } catch (e) {
                
            }
            $('.navigationDropdown-content .tooltipped').attr('data-tooltip', "{Literal}Version{/Literal} " +  that.serverInfo.serverVersion);
            $('.navigationDropdown-content .tooltipped').attr('data-position', that.rtl ? 'right' : 'left');
            if (that.serverInfo.israCardBuild) {
                $("#dashboardSideNav").show();
            }

            var elems = document.querySelectorAll('.sidenav');
            var instances = M.Sidenav.init(elems, {
                edge: that.serverInfo.isRightToLeft ? 'right' : 'left',
                draggable: true
            });
            $('.collapsible').collapsible();
            /*$("main").mCustomScrollbar({
                axis: 'y',
                scrollInertia: 1000,
                autoHideScrollbar: true
            }); */
            if (that.serverInfo.isRightToLeft) {
                var linkElement = this.document.createElement('link');
                linkElement.setAttribute('rel', 'stylesheet');
                linkElement.setAttribute('type', 'text/css');
                linkElement.setAttribute('href', 'lib/materialize-css-rtl/materialize.rtl.css');
                
                $("#slide-out").css('direction', 'rtl');
                $("body").css('direction', 'rtl');
                $("main").css('direction', 'rtl');
                $("#global-wrapper").css('direction', 'rtl');

                $('.dropdown-icon').each(function() { 
                    $(this).removeClass('right');
                    $(this).addClass('left');
                });

            } else {
                $("#slide-out").css('direction', 'ltr');
                //$("#slide-out").mCustomScrollbar();
            }
            if (that.serverInfo.israCardBuild) { 
                $('#logo-img').hide();
                $('#israSideNavImg').show();
                $("#logo-wrapper").removeClass('ap-blue');
                $("#logo-wrapper").addClass('grey lighten-4');
                document.title = 'IsraPOS Management'
                var link = document.querySelector("link[rel*='icon']") || document.createElement('link');
                document.getElementsByTagName('head')[0].appendChild(link);
                link.type = 'image/x-icon';
                link.rel = 'shortcut icon';
                link.href = 'img/isracard-logo.png';
            }
            
            // $("#slide-out").show();
            
        };
        await $.ajax({
            url: '/data/get-server-info',
            data: {token: this.getCookie()},
            dataType: 'json',
            type: 'POST',
            success: function (data) {
                if (typeof data.serverInfo !== 'undefined') {
                    that.serverInfo = data.serverInfo;
                    that.israCardBuild = data.serverInfo.israCardBuild;
                    that.rtl = data.serverInfo.isRightToLeft;
                    var twelveHour = true;
                    if(that.serverInfo.country == 'IL' || that.serverInfo.country == 'UK')
                        twelveHour = false;
                    if(that.serverInfo.country == 'IL')
                        document.getElementById('updatesLink').style.display = 'block';
                    that.timepickerOptions.twelveHour = twelveHour;
                    that.i18n = that.i18n
                } else {
                    M.toast({
                        html: '{Literal}There was a problem fetching data from the server{/Literal}'
                    });
                }
                

                
                
            },
            error: function (e) {
                M.toast({
                    html: '{Literal}There was a problem fetching data from the server{/Literal}'
                });
            }
        });
        
        
        $(document).ready(function(){
            initSideNavAndScrollbars();
            if(!that.historyStarted){
                Backbone.history.start();
                that.historyStarted = true;
            }
                
            if(location.hash != "#/log-in")
                $('.sidenav, .nav-wrapper, .white').show();

            $('.tooltipped').tooltip();
            $(window).scroll(function() {
                var scrollBottom = $(window).scrollTop() + $(window).height();
                var y = $(window).scrollTop();
                if( y > 0 ){
                    $("#top-shadow").show();
                } else {
                    $("#top-shadow").hide();
                }

                if (scrollBottom > $(window).height()) {
                    $("#bottom-shadow").show();
                }
                else {
                    $("#bottom-shadow").hide();
                }
            });
        });
    },

    sessionExpired: function() {
        $('main').children().detach();
        var message = '<div class="row"><div class="col s12" style="padding-top: 20px">Your session has expired. Please click <a href="/isracard/isracardlogin.html">here</a> to go to the IsraCard login page.</div></div>';
        $('main').html(message);
        this.setBreadcrumbs([{
            path: 'javascript:void(0)',
            label: '{Literal}Your Session Has Expired{/Literal}'
        }]);
    },

    pageNotFound: function () {
        $('main').children().detach();
        $('main').html('<div class="row"><div class="col s12" style="padding-top: 20px">{Literal}The page you are looking for does not exist{/Literal}</div></div>');
        this.setBreadcrumbs([{
            path: 'javascript:void(0)',
            label: '{Literal}Page Not Found{/Literal}'
        }]);
    },

    home: async function () {
        var that = this;
        // var isLoaded =  this.loadedPages.includes("home");
        // if(!isLoaded) {
        //     await getScript('js/views/home.js');
        //     this.loadedPages.push("home");
        // }
        await getScript('js/models/sequence.js');
        await getScript('js/collections/sequenceCollection.js');
        $.get("templates/home.html").done(function (template) {
            that.homeView = new HomeView({
                template: template,
                breadcrumb: [{
                    path: '#/home',
                    label: '{Literal}Dashboard{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.homeView.render().el);
        });
    },

    posKeys: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("posKeys");
        if(!isLoaded) {
            await getScript('js/views/posKeys.js');
            this.loadedPages.push("posKeys");
        }

        $.get("templates/posKeys.html").done(function (template) {
            that.posKeysView = new PosKeysView({
                template: template,
                breadcrumb: [{
                    path: '#/pos-keys',
                    label: '{Literal}POS Keys{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.posKeysView.render().el);
            $('select').formSelect();
            $(document).ready(function () {
                $('.modal').modal();
            });
        })
    },

    posKeysMobile: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("posKeysMobile");
        if(!isLoaded) {
            await getScript('js/views/posKeysMobile.js');
            this.loadedPages.push("posKeysMobile");
        }

        $.get("templates/posKeysMobile.html").done(function (template) {
            that.posKeysMobileView = new PosKeysMobileView({
                template: template,
                breadcrumb: [{
                    path: '#/pos-keys-mobile',
                    label: '{Literal}POS Keys Mobile{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.posKeysMobileView.render().el);
            $('select').formSelect();
            $(document).ready(function () {
                $('.modal').modal();
            });
        })
    },

    choiceKeys: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("choiceKeys");
        if(!isLoaded) {
            await getScript('js/views/choiceKeys.js');
            this.loadedPages.push("choiceKeys");
        }

        $.get("templates/choiceKeys.html").done(function (template) {
            that.choiceKeysView = new ChoiceKeysView({
                template: template,
                breadcrumb: [{
                    path: '#/choice-keys',
                    label: '{Literal}Choice Keys{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.choiceKeysView.render().el);
            $('select').formSelect();
            $(document).ready(function () {
                $('.modal').modal();
            });
        })

    },
    choiceKeysMobile: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("choiceKeysMobile");
        if(!isLoaded) {
            await getScript('js/views/choiceKeysMobile.js');
            this.loadedPages.push("choiceKeysMobile");
        }

        $.get("templates/choiceKeysMobile.html").done(function (template) {
            that.choiceKeysMobileView = new ChoiceKeysMobileView({
                template: template,
                breadcrumb: [{
                    path: '#/choice-keys-mobile',
                    label: '{Literal}Choice Keys Mobile{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.choiceKeysMobileView.render().el);
            $('select').formSelect();
            $(document).ready(function () {
                $('.modal').modal();
            });
        })

    },

    roomsTables: async function() {
        var that = this;
        
        var that = this;
        var isLoaded =  this.loadedPages.includes("roomsTables");
        if(!isLoaded) {
            await getScript('js/models/roomsTables.js');
            await getScript('js/collections/roomsTablesCollection.js');
            await getScript('js/views/roomsTables.js');
            await getScript('js/views/roomsTablesForm.js');
            this.loadedPages.push("roomsTables");
        }

        $.get("templates/roomsTables.html").done(function (template) {
            $.get("templates/roomsTablesForm.html").done(function (roomsTablesFormTemplate) {
                that.roomsTablesView = new RoomsTablesView({
                template: template,
                roomsTablesFormTemplate: roomsTablesFormTemplate,
                collection: new RoomsTablesCollection(),
                breadcrumb: [{
                    path: '#/rooms-tables',
                    label: '{Literal}Rooms & Tables{/Literal}'
                }]
            });
                $('main').children().detach();
                $('main').html(that.roomsTablesView.render().el);
                $('select').formSelect();
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    productLines: async function () {
        var that = this;

        var isLoaded =  this.loadedPages.includes("productLine");
        if(!isLoaded) {
            await getScript('js/models/productLine.js');
            await getScript('js/collections/productLineCollection.js');
            await getScript('js/views/productLines.js');
            await getScript('js/views/productLineForm.js');
            this.loadedPages.push("productLine");
        }
        
        $.get("templates/productLines.html").done(function (template) {
            $.get("templates/productLineForm.html").done(function (productLineFormTemplate) {
                that.productLinesView = new ProductLinesView({
                    template: template,
                    //israCardBuild: that.israCardBuild,
                    productLineFormTemplate: productLineFormTemplate,
                    collection: new ProductLineCollection(),
                    breadcrumb: [{
                        path: '#/product-lines',
                        label: '{Literal}Product Lines{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.productLinesView.render().el);
                $('select').formSelect();
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },
    
    items: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("items");
        if(!isLoaded) {
            await getScript('js/models/items.js');
            await getScript('js/collections/itemsCollection.js');
            await getScript('js/views/items.js');
            await getScript('js/views/itemsForm.js');
            this.loadedPages.push("items");
        }
       
        $.get("templates/items.html").done(function (template) {
            $.get("templates/itemsForm.html").done(function (itemsFormTemplate) {
                that.itemsView = new ItemsView({
                    template: template,
                    itemsFormTemplate: itemsFormTemplate,
                    collection: new ItemsCollection(),
                    breadcrumb: [{
                    path: '#/items',
                    label: '{Literal}Item List{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.itemsView.render().el);
                $('select').formSelect();
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    remoteDevices: async function ()  {
        var that = this;
        var isLoaded =  this.loadedPages.includes("remoteDevices");
        if(!isLoaded) {
            await getScript('js/models/remoteDisplay.js');
            await getScript('js/views/remoteDisplay.js');
            await getScript('js/views/remoteDisplayForm.js');
            this.loadedPages.push("remoteDevices");
        }

        $.get("templates/remoteDisplay.html").done(function (template) {
            $.get("templates/remoteDisplayForm.html").done(function (remoteDisplayFormTemplate) {
                that.remoteDisplayView = new RemoteDisplayView({
                    template: template,
                    remoteDisplayFormTemplate: remoteDisplayFormTemplate,
                    breadcrumb: [{
                        path: '#/advanced-settings',
                        label: '{Literal}Advanced Settings{/Literal}'
                    }, {
                        path: '#/remote-display',
                        label: '{Literal}Remote Display Devices{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.remoteDisplayView.render().el);
                $('select').formSelect();
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    remotePrinting: async function()  {
        var that = this;
        
        var isLoaded =  this.loadedPages.includes("remotePrinting");
        if(!isLoaded) {
            await getScript('js/models/remotePrinting.js');
            await getScript('js/views/remotePrinting.js');
            await getScript('js/views/remotePrintingForm.js');
            this.loadedPages.push("remotePrinting");
        }

        $.get("templates/remotePrinting.html").done(function (template) {
            $.get("templates/remotePrintingForm.html").done(function (remotePrintingFormTemplate) {
                that.remotePrintingView = new RemotePrintingView({
                    template: template,
                    remotePrintingFormTemplate: remotePrintingFormTemplate,
                    breadcrumb: [{
                    path: '#/remote-printing',
                    label: '{Literal}Remote Printing{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.remotePrintingView.render().el);
                $('select').formSelect();
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    posUsers: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("posUsers");
        if(!isLoaded) {
            await getScript('js/views/posUsers.js');
            this.loadedPages.push("posUsers");
        }
       
        $.get("templates/posUsers.html").done(function (template) {
            $.get("templates/posUserForm.html").done(function (posUserFormTemplate) {
                that.posUsersView = new POSUsersView({
                    template: template,
                    posUserFormTemplate: posUserFormTemplate,
                    collection: new POSUserCollection(),
                    breadcrumb: [{
                        path: '#/pos-users',
                        label: '{Literal}POS Users{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.posUsersView.render().el);
                $('select').formSelect();
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    userGroups: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("userGroups");
        if(!isLoaded) {
            await getScript('js/models/userGroup.js');
            await getScript('js/collections/userGroupCollection.js');
            await getScript('js/views/userGroups.js');
            await getScript('js/views/userGroupForm.js');
            this.loadedPages.push("userGroups");
        }

        $.get("templates/userGroups.html").done(function (template) {
            $.get("templates/userGroupForm.html").done(function (userGroupFormTemplate) {
                that.userGroupsView = new UserGroupsView({
                    template: template,
                    userGroupFormTemplate: userGroupFormTemplate,
                    collection: new UserGroupCollection(),
                    breadcrumb: [{
                        path: '#/user-groups',
                        label: '{Literal}User Groups{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.userGroupsView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    companyInfo: async function() {
        var that = this;
        
        var isLoaded =  this.loadedPages.includes("companyInfo");
        if(!isLoaded) {
            await getScript('js/models/companyInfo.js');
            await getScript('js/views/companyInfo.js');
            this.loadedPages.push("companyInfo");
        }

        $.get("templates/companyInfo.html").done(function (template) {
            that.companyInfoView = new CompanyInfoView({
                template: template,
                hasAccounting: that.serverInfo.hasAccounting,
                model: new CompanyInfo(),
                breadcrumb: [{
                    path: '#/company-info',
                    label: '{Literal}Company Information{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.companyInfoView.render().el);
            //$('select').formSelect();
        });
    },

    receiptSettings: async function() {
        var that = this;
        
        var isLoaded =  this.loadedPages.includes("receiptSettings");
        if(!isLoaded) {
            await getScript('js/models/receiptSettings.js');
            await getScript('js/views/receiptSettings.js');
        }
        this.loadedPages.push("receiptSettings");

        $.get("templates/receiptSettings.html").done(function (template) {
            that.receiptSettingsView = new ReceiptSettingsView({
                template: template,
                model: new ReceiptSettings(),
                breadcrumb: [{
                    path: '#/receipt-settings',
                    label: '{Literal}Receipt Settings{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.receiptSettingsView.render().el);
            $('select').formSelect();
        });
    },

    tills: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("tills");
        if(!isLoaded) {
            await getScript('js/models/tills.js');
            await getScript('js/collections/tillsCollection.js');
            await getScript('js/views/tills.js');
            await getScript('js/views/tillsForm.js');
            this.loadedPages.push("tills");
        }
        $.get("templates/tills.html").done(function (template) {
            $.get("templates/tillsForm.html").done(function (tillsFormTemplate) {
                that.tillsView = new TillsView({
                    template: template,
                    tillsFormTemplate: tillsFormTemplate,
                    collection: new TillsCollection(),
                    breadcrumb: [{
                        path: '#/tills',
                        label: '{Literal}Tills{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.tillsView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })

        });
    },

    deliScale: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("deliScale");
        if(!isLoaded) {
            await getScript('js/models/deliScale.js');
            await getScript('js/views/deliScale.js');
            this.loadedPages.push("deliScale");
        }
        $.get("templates/deliScale.html").done(function (template) {
            that.deliScaleView = new DeliScaleView({
                template: template,
                model: new DeliScale(),
                breadcrumb: [{
                    path: '#/advanced-settings',
                    label: '{Literal}Advanced Settings{/Literal}'
                }, {
                    path: '#/deli-scale',
                    label: '{Literal}Deli Scales{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.deliScaleView.render().el);
            //$('select').formSelect();
        });
    },

    customers: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("customers");
        if(!isLoaded) {
            await getScript('js/models/customers.js');
            await getScript('js/collections/customersCollection.js');
            await getScript('js/views/customers.js');
            await getScript('js/views/customersForm.js');
		    this.loadedPages.push("customers");
        }

        $.get("templates/customers.html").done(function (template) {
            $.get("templates/customersForm.html").done(function (customersFormTemplate) {
                that.customersView = new CustomersView({
                    template: template,
                    customersFormTemplate: customersFormTemplate,
                    collection: new CustomersCollection(),
                    israCardBuild: that.israCardBuild,
                    breadcrumb: [{
                        path: '#/customers',
                        label: '{Literal}Customers{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.customersView.render().el);
            });
        });
    },

    sales: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("sales");
        if(!isLoaded) {
            await getScript('js/models/sales.js');
            await getScript('js/collections/salesCollection.js');
            await getScript('js/views/sales.js');
            await getScript('js/views/salesForm.js');
		    this.loadedPages.push("sales");
        }

        if (this.israCardBuild) {
            $.get("templates/sales.html").done(function (template) {
                $.get("templates/salesForm.html").done(function (salesFormTemplate) {
                    that.salesView = new SalesView({
                        template: template,
                        salesFormTemplate: salesFormTemplate,
                        collection: new SalesCollection(),
    
                        breadcrumb: [{
                            path: '#/advanced-items',
                            label: '{Literal}Advanced Items{/Literal}'
                        }, {
                            path: '#/sales',
                            label: '{Literal}Sales & Promotions{/Literal}'
                        }]
                    });
                    $('main').children().detach();
                    $('main').html(that.salesView.render().el);
                    $(document).ready(function () {
                        $('.modal').modal();
                    });
                });
            });
        }
        else {
            $.get("templates/sales.html").done(function (template) {
                $.get("templates/salesForm.html").done(function (salesFormTemplate) {
                    that.salesView = new SalesView({
                        template: template,
                        salesFormTemplate: salesFormTemplate,
                        collection: new SalesCollection(),
                        breadcrumb: [{
                            path: '#/advanced-items',
                            label: '{Literal}Advanced Items{/Literal}'
                        }, {
                            path: '#/sales',
                            label: '{Literal}Sales & Promotions{/Literal}'
                        }]
                    });
                    $('main').children().detach();
                    $('main').html(that.salesView.render().el);
                    $(document).ready(function () {
                        $('.modal').modal();
                    });
                });
            });
        }
    },
      

    tenderTypes: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("tenderTypes");
        if(!isLoaded) {
            await getScript('js/models/tenderTypes.js');
            await getScript('js/collections/tenderTypesCollection.js');
            await getScript('js/views/tenderTypes.js');
            await getScript('js/views/tenderTypesForm.js');
		    this.loadedPages.push("tenderTypes");
        }

        $.get("templates/tenderTypes.html").done(function (template) {
            $.get("templates/tenderTypesForm.html").done(function (tenderTypesFormTemplate) {
                that.tenderTypesView = new TenderTypesView({
                    template: template,
                    tenderTypesFormTemplate: tenderTypesFormTemplate,
                    collection: new TenderTypesCollection(),
                    breadcrumb: [{
                        path: '#/tender-types',
                        label: '{Literal}Tender Types{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.tenderTypesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    advancedSettings: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("advancedSettings");
        if(!isLoaded) {
		    await getScript('js/views/advancedSettings.js');
		    this.loadedPages.push("advancedSettings");
        }

        $.get("templates/advancedSettings.html").done(function (template) {
            that.advancedSettingsView = new AdvancedSettingsView({
                template: template,
                breadcrumb: [{
                    path: '#/advanced-settings',
                    label: '{Literal}Advanced Settings{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.advancedSettingsView.render().el);
        });
    },

    advancedItems: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("advancedItems");
        if(!isLoaded) {
		    await getScript('js/views/advancedItems.js');
		    this.loadedPages.push("advancedItems");
        }

        $.get("templates/advancedItems.html").done(function (template) {
            that.advancedItemsView = new AdvancedItemsView({
                template: template,
                breadcrumb: [{
                    path: '#/advanced-items',
                    label: '{Literal}Advanced Items{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.advancedItemsView.render().el);
        });
    },

    qbo: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("qbo");
        if(!isLoaded) {
		    await getScript('js/views/qbo.js');
		    this.loadedPages.push("qbo");
        }

        $.get("templates/qbo.html").done(function (template) {
            that.qboView = new QBOView({
                template: template,
                breadcrumb: [{
                    path: '#/qbo',
                    label: '{Literal}QuickBooks Online{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.qboView.render().el);
        });
    },

    clearData: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("clearData");
        if(!isLoaded) {
		    await getScript('js/views/clearData.js');
		    this.loadedPages.push("clearData");
        }

        if (this.israCardBuild) {
            $.get("templates/clearData.html").done(function (template) {
                that.clearDataView = new ClearDataView({
                    template: template,
                    breadcrumb: [{
                        path: '#/advanced-settings',
                        label: '{Literal}Advanced Settings{/Literal}'
                    }, {
                        path: '#/clear-data',
                        label: '{Literal}Clear Data{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.clearDataView.render().el);
            });
        }
        else {
            $.get("templates/clearData.html").done(function (template) {
                that.clearDataView = new ClearDataView({
                    template: template,
                    breadcrumb: [{
                        path: '#/advanced-settings',
                        label: '{Literal}Advanced Settings{/Literal}'
                    }, {
                        path: '#/clear-data',
                        label: '{Literal}Clear Data{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.clearDataView.render().el);
            });
        }
    },

    backupRestore: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("backupRestore");
        if(!isLoaded) {
            await getScript('js/models/backup.js');
            await getScript('js/views/backupRestore.js');
		    this.loadedPages.push("backupRestore");
        }

        if (this.israCardBuild) {
            $.get("templates/backupRestore.html").done(function (template) {
                that.backupRestoreView = new BackupRestoreView({
                    template: template,
                    model: new Backup(),
                    breadcrumb: [{
                        path: '#/backup-restore',
                        label: '{Literal}Backup / Restore{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.backupRestoreView.render().el);
            }); 
        }
        else {
            $.get("templates/backupRestore.html").done(function (template) {
                that.backupRestoreView = new BackupRestoreView({
                    template: template,
                    model: new Backup(),
                    breadcrumb: [{
                        path: '#/advanced-settings',
                        label: '{Literal}Advanced Settings{/Literal}'
                    }, {
                        path: '#/backup-restore',
                        label: '{Literal}Backup / Restore{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.backupRestoreView.render().el);
            });
        }
    },

    groupItems: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("groupItems");
        if(!isLoaded) {
            await getScript('js/models/groupItems.js');
            await getScript('js/collections/groupItemsCollection.js');
            await getScript('js/views/groupItems.js');
            await getScript('js/views/groupItemsForm.js');
		    this.loadedPages.push("groupItems");
        }

        if (this.israCardBuild) {
            $.get("templates/groupItems.html").done(function (template) {
                $.get("templates/groupItemsForm.html").done(function (groupItemsFormTemplate) {
                    that.groupItemsView = new GroupItemsView({
                        template: template,
                        groupItemsFormTemplate: groupItemsFormTemplate,
                        collection: new GroupItemsCollection(),
                        breadcrumb: [{
                            path: '#/advanced-items',
                            label: '{Literal}Advanced Items{/Literal}'
                        }, {
                            path: '#/group-items',
                            label: '{Literal}Group Items{/Literal}'
                        }]
                    });
                    $('main').children().detach();
                    $('main').html(that.groupItemsView.render().el);
                    $(document).ready(function () {
                        $('.modal').modal();
                    });
                })
            });
        }
        else {
            $.get("templates/groupItems.html").done(function (template) {
                $.get("templates/groupItemsForm.html").done(function (groupItemsFormTemplate) {
                    that.groupItemsView = new GroupItemsView({
                        template: template,
                        groupItemsFormTemplate: groupItemsFormTemplate,
                        collection: new GroupItemsCollection(),
                        breadcrumb: [{
                            path: '#/advanced-items',
                            label: '{Literal}Advanced Items{/Literal}'
                        }, {
                            path: '#/group-items',
                            label: '{Literal}Group Items{/Literal}'
                        }]
                    });
                    $('main').children().detach();
                    $('main').html(that.groupItemsView.render().el);
                    $(document).ready(function () {
                        $('.modal').modal();
                    });
                })
            });
        }
    },

    taxes: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("taxes");
        if(!isLoaded) {
            await getScript('js/models/taxes.js');
            await getScript('js/collections/taxesCollection.js');
            await getScript('js/views/taxes.js');
            await getScript('js/views/taxesForm.js');
		    this.loadedPages.push("taxes");
        }

        $.get("templates/taxes.html").done(function (template) {
            $.get("templates/taxesForm.html").done(function (taxesFormTemplate) {
                that.taxesView = new TaxesView({
                    template: template,
                    taxesFormTemplate: taxesFormTemplate,
                    collection: new TaxesCollection(),
                    breadcrumb: [{
                        path: '#/taxes',
                        label: '{Literal}VAT Taxes{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.taxesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    salesTaxes: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("salesTaxes");
        if(!isLoaded) {
            await getScript('js/models/salesTaxes.js');
            await getScript('js/collections/salesTaxesCollection.js');
            await getScript('js/views/salesTaxes.js');
            await getScript('js/views/salesTaxesForm.js');
		    this.loadedPages.push("salesTaxes");
        }

        $.get("templates/salesTaxes.html").done(function (template) {
            $.get("templates/salesTaxesForm.html").done(function (salesTaxesFormTemplate) {
                that.salesTaxesView = new SalesTaxesView({
                    template: template,
                    salesTaxesFormTemplate: salesTaxesFormTemplate,
                    collection: new SalesTaxesCollection(),
                    breadcrumb: [{
                        path: '#/sales-taxes',
                        label: '{Literal}Sales Taxes{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.salesTaxesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },
 
    inventory: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("inventory");
        if(!isLoaded) {
            await getScript('js/models/inventory.js');
            await getScript('js/collections/inventoryCollection.js');
            await getScript('js/views/inventory.js');
            await getScript('js/views/inventoryForm.js');
		    this.loadedPages.push("inventory");
        }
 
        $.get("templates/inventory.html").done(function (template) {
            $.get("templates/inventoryForm.html").done(function (inventoryFormTemplate) {
                that.inventoryView = new InventoryView({
                    template: template,
                    inventoryFormTemplate: inventoryFormTemplate,
                    collection: new InventoryCollection(),
                    breadcrumb: [{
                        path: '#/advanced-items',
                        label: '{Literal}Advanced Items{/Literal}'
                    }, {
                        path: '#/inventory',
                        label: '{Literal}Inventory-Receive{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.inventoryView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
        
    },

    inventoryAdjustments: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("inventoryAdjustments");
        if(!isLoaded) {
            await getScript('js/models/inventoryAdjustments.js');
            await getScript('js/collections/inventoryAdjustmentsCollection.js');
            await getScript('js/views/inventoryAdjustments.js');
            await getScript('js/views/inventoryAdjustmentsForm.js');
		    this.loadedPages.push("inventoryAdjustments");
        }

        if (this.israCardBuild) {
            $.get("templates/inventoryAdjustments.html").done(function (template) {
                $.get("templates/inventoryAdjustmentsForm.html").done(function (inventoryAdjustmentsFormTemplate) {
                    that.inventoryAdjustmentsView = new InventoryAdjustmentsView({
                        template: template,
                        inventoryAdjustmentsFormTemplate: inventoryAdjustmentsFormTemplate,
                        collection: new InventoryAdjustmentsCollection(),
                        breadcrumb: [{
                            path: '#/advanced-items',
                            label: '{Literal}Advanced Items{/Literal}'
                        }, {
                            path: '#/advanced-items',
                            label: '{Literal}Advanced Items{/Literal}'
                        }]
                    });
                    $('main').children().detach();
                    $('main').html(that.inventoryAdjustmentsView.render().el);
                    $(document).ready(function () {
                        $('.modal').modal();
                    });
                })
            });
        }
        else {
            $.get("templates/inventoryAdjustments.html").done(function (template) {
                $.get("templates/inventoryAdjustmentsForm.html").done(function (inventoryAdjustmentsFormTemplate) {
                    that.inventoryAdjustmentsView = new InventoryAdjustmentsView({
                        template: template,
                        inventoryAdjustmentsFormTemplate: inventoryAdjustmentsFormTemplate,
                        collection: new InventoryAdjustmentsCollection(),
                        breadcrumb: [{
                            path: '#/advanced-items',
                            label: '{Literal}Advanced Items{/Literal}'
                        }, {
                            path: '#/inventory-adjustments',
                            label: '{Literal}Inventory-Adjust{/Literal}'
                        }]
                    });
                    $('main').children().detach();
                    $('main').html(that.inventoryAdjustmentsView.render().el);
                    $(document).ready(function () {
                        $('.modal').modal();
                    });
                })
            });
        }
    },

    reports: async function() {
        var that = this;
        var isLoaded =  this.loadedPages.includes("reports");
        if(!isLoaded) {
            await getScript('js/views/reports.js');
            await getScript('js/models/sequence.js');
            await getScript('js/collections/sequenceCollection.js');
            await getScript('js/views/sequenceTiles.js');
		    this.loadedPages.push("reports");
        }

        $.get("templates/reports.html").done(function (reportsTemplate) {
            $.get("templates/sequenceTiles.html").done(function (sequenceTilesTemplate) {
                that.reportsView = new ReportsView({
                    template: reportsTemplate,
                    sequenceTilesTemplate: sequenceTilesTemplate,
                    sequenceTilesView: new SequenceTilesView({
                        template: sequenceTilesTemplate,
                        collection: new SequenceCollection()
                    }),
                    breadcrumb: [{
                        path: '#/reports',
                        label: '{Literal}Generate Reports{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.reportsView.render().el);
                $('select').formSelect();

                $(document).ready(function () {
                    $('.modal').modal();
                });
            });
        });
    },
//when something goes wrong within the POS make them play peggle and break the last highscore to fix the issue; is this not real code i dont understand why this isnt implemented yet
//Connect to classic doom 
//hey google; how do i put classic doom on a java based platform
//^^jeremiah do this for me its too hard https://codegym.cc/groups/posts/182-java-game-programming-for-beginners-where-to-start
    logIn: function () {
        var that = this;
        localStorage.setItem('timeoutCounter', 5);
        if(this.isTokenValid()){
            window.location.href = "#/home";
        }
        else
         {
            $.get("templates/logIn.html").done(function (template) {
                that.logInView = new LogInView({
                    israCardBuild: that.israCardBuild,
                    template: template,
                    model: new LogIn(),
                    breadcrumb: [{
                        path: '#/log-in',
                        label: '{Literal}Log In{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.logInView.render().el);
            });
        }
    },

    dashboard: function () {
        var that = this;
        $.get("templates/dashboard.html").done(function (template) {
            that.dashboardView = new DashboardView({
                template: template,
                model: new Dashboard(),
                breadcrumb: [{
                    path: '#/dashboard',
                    label: '{Literal}Dashboard{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.dashboardView.render().el);
        });
    },

    cardSetup: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("cardSetup");
        if(!isLoaded) {
            await getScript('js/models/cardSetup.js');
            await getScript('js/views/cardSetup.js');
		    this.loadedPages.push("cardSetup");
        }

        $.get("templates/cardSetup.html").done(function (template) {
            that.cardSetupView = new CardSetupView({
                template: template,
                model: new CardSetup(),
                breadcrumb: [{
                    path: '#/advanced-settings',
                    label: '{Literal}Advanced Settings{/Literal}'
                }, {
                    path: '#/card-setup',
                    label: '{Literal}Cards & Merchant Services{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.cardSetupView.render().el);
            //$('select').formSelect();
        });
    },

    integrations: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("integrations");
        if(!isLoaded) {
            await getScript('js/models/integrations.js');
            await getScript('js/views/integrations.js');
		    this.loadedPages.push("integrations");
        }
        
        $.get("templates/integrations.html").done(function (template) {
            that.integrationsView = new IntegrationsView({
                template: template,
                model: new Integrations(),
                breadcrumb: [{
                    path: '#/advanced-settings',
                    label: '{Literal}Advanced Settings{/Literal}'
                }, {
                    path: '#/integrations',
                    label: '{Literal}Integrations{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.integrationsView.render().el);
            //$('select').formSelect();
        });
    },

    importExport: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("importExport");
        if(!isLoaded) {
            await getScript('js/views/importExport.js');
            await getScript('js/models/sequence.js');
            await getScript('js/collections/sequenceCollection.js');
            await getScript('js/views/sequenceTiles.js');
            this.loadedPages.push("importExport");
        }

        $.get("templates/importExport.html").done(function (template) {
            $.get("templates/sequenceTiles.html").done(function (sequenceTilesTemplate) {
                that.importExportView = new ImportExportView({
                    template: template,
                    sequenceTilesTemplate: sequenceTilesTemplate,
                    sequenceTilesView: new SequenceTilesView({
                        template: sequenceTilesTemplate,
                        collection: new SequenceCollection()
                    }),
                    breadcrumb: [{
                        path: '#/import-export',
                        label: '{Literal}Import/Export{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.importExportView.el);
            });
        });
    },

    compReasons: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("compReasons");
        if(!isLoaded) {
            await getScript('js/models/compReasons.js');
            await getScript('js/collections/compReasonsCollection.js');
            await getScript('js/views/compReasons.js');
            await getScript('js/views/compReasonsForm.js');
		    this.loadedPages.push("compReasons");
        }

        $.get("templates/compReasons.html").done(function (template) {
            $.get("templates/compReasonsForm.html").done(function (compReasonsFormTemplate) {
                that.compReasonsView = new CompReasonsView({
                    template: template,
                    compReasonsFormTemplate: compReasonsFormTemplate,
                    collection: new CompReasonsCollection(),
                    breadcrumb: [{
                        path: '#/comp-reasons',
                        label: '{Literal}Comp Reasons{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.compReasonsView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },
    discountReasons: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("discountReasons");
        if(!isLoaded) {
            await getScript('js/models/discountReasons.js');
            await getScript('js/collections/discountReasonsCollection.js');
            await getScript('js/views/discountReasons.js');
            await getScript('js/views/discountReasonsForm.js');
		    this.loadedPages.push("discountReasons");
        }

        $.get("templates/discountReasons.html").done(function (template) {
            $.get("templates/discountReasonsForm.html").done(function (discountReasonsFormTemplate) {
                that.discountReasonsView = new DiscountReasonsView({
                    template: template,
                    discountReasonsFormTemplate: discountReasonsFormTemplate,
                    collection: new DiscountReasonsCollection(),
                    breadcrumb: [{
                        path: '#/discount-reasons',
                        label: '{Literal}Discount Reasons{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.discountReasonsView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    courseNames: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("courseNames");
        if(!isLoaded) {
            await getScript('js/models/courseNames.js');
            await getScript('js/collections/courseNamesCollection.js');
            await getScript('js/views/courseNames.js');
            await getScript('js/views/courseNamesForm.js');
		    this.loadedPages.push("courseNames");
        }

        $.get("templates/courseNames.html").done(function (template) {
            $.get("templates/courseNamesForm.html").done(function (courseNamesFormTemplate) {
                that.courseNamesView = new CourseNamesView({
                    template: template,
                    courseNamesFormTemplate: courseNamesFormTemplate,
                    collection: new CourseNamesCollection(),
                    breadcrumb: [{
                        path: '#/course-names',
                        label: '{Literal}Course Names{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.courseNamesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    itemAttributes: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("itemAttributes");
        if(!isLoaded) {
            await getScript('js/models/itemAttributes.js');
            await getScript('js/collections/itemAttributesCollection.js');
            await getScript('js/views/itemAttributes.js');
            await getScript('js/views/itemAttributesForm.js');
		    this.loadedPages.push("itemAttributes");
        }

        $.get("templates/itemAttributes.html").done(function (template) {
            $.get("templates/itemAttributesForm.html").done(function (itemAttributesFormTemplate) {
                that.itemAttributesView = new ItemAttributesView({
                    template: template,
                    itemAttributesFormTemplate: itemAttributesFormTemplate,
                    collection: new ItemAttributesCollection(),
                    breadcrumb: [{
                        path: '#/item-attributes',
                        label: '{Literal}Item Attributes{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.itemAttributesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    posStations: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("posStations");
        if(!isLoaded) {
            await getScript('js/models/posStations.js');
            await getScript('js/collections/posStationsCollection.js');
            await getScript('js/views/posStations.js');
            await getScript('js/views/posStationsForm.js');
		    this.loadedPages.push("posStations");
        }

        $.get("templates/posStations.html").done(function (template) {
            $.get("templates/posStationsForm.html").done(function (posStationsFormTemplate) {
                that.posStationsView = new POSStationsView({
                    template: template,
                    posStationsFormTemplate: posStationsFormTemplate,
                    collection: new POSStationsCollection(),
                    breadcrumb: [{
                        path: '#/pos-stations',
                        label: '{Literal}POS Stations{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.posStationsView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    alternativeTaxes: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("alternativeTaxes");
        if(!isLoaded) {
            await getScript('js/models/alternativeTaxes.js');
            await getScript('js/collections/alternativeTaxesCollection.js');
            await getScript('js/views/alternativeTaxes.js');
            await getScript('js/views/alternativeTaxesForm.js');
		    this.loadedPages.push("alternativeTaxes");
        }

        $.get("templates/alternativeTaxes.html").done(function (template) {
            $.get("templates/alternativeTaxesForm.html").done(function (alternativeTaxesFormTemplate) {
                that.alternativeTaxesView = new AlternativeTaxesView({
                    template: template,
                    alternativeTaxesFormTemplate: alternativeTaxesFormTemplate,
                    collection: new AlternativeTaxesCollection(),
                    breadcrumb: [{
                        path: '#/advanced-settings',
                        label: '{Literal}Advanced Settings{/Literal}'
                    }, {
                        path: '#alternative-taxes',
                        label: '{Literal}Alternative Taxes{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.alternativeTaxesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    priceLevelTimes: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("priceLevelTimes");
        if(!isLoaded) {
            await getScript('js/models/priceLevelTimes.js');
            await getScript('js/collections/priceLevelTimesCollection.js');
            await getScript('js/views/priceLevelTimes.js');
            await getScript('js/views/priceLevelTimesForm.js');
		    this.loadedPages.push("priceLevelTimes");
        }

        $.get("templates/priceLevelTimes.html").done(function (template) {
            $.get("templates/priceLevelTimesForm.html").done(function (priceLevelTimesFormTemplate) {
                that.priceLevelTimesView = new PriceLevelTimesView({
                    template: template,
                    priceLevelTimesFormTemplate: priceLevelTimesFormTemplate,
                    collection: new PriceLevelTimesCollection(),
                    breadcrumb: [{
                        path: '#/advanced-items',
                        label: '{Literal}Advanced Items{/Literal}'
                    }, {
                        path: '#price-level-times',
                        label: '{Literal}Price Level Times{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.priceLevelTimesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    followOn: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("followOn");
        if(!isLoaded) {
            await getScript('js/models/followOn.js');
            await getScript('js/collections/followOnCollection.js');
            await getScript('js/views/followOn.js');
            await getScript('js/views/followOnForm.js');
		    this.loadedPages.push("followOn");
        }

        $.get("templates/followOn.html").done(function (template) {
            $.get("templates/followOnForm.html").done(function (followOnFormTemplate) {
                that.followOnView = new FollowOnView({
                    template: template,
                    followOnFormTemplate: followOnFormTemplate,
                    collection: new FollowOnCollection(),
                    breadcrumb: [{
                        path: '#/advanced-items',
                        label: '{Literal}Advanced Items{/Literal}'
                    }, {
                        path: '#follow-on',
                        label: '{Literal}Follow On Items{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.followOnView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    operatorMessages: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("operatorMessages");
        if(!isLoaded) {
            await getScript('js/models/operatorMessages.js');
            await getScript('js/collections/operatorMessagesCollection.js');
            await getScript('js/views/operatorMessages.js');
            await getScript('js/views/operatorMessagesForm.js');
		    this.loadedPages.push("operatorMessages");
        }

        $.get("templates/operatorMessages.html").done(function (template) {
            $.get("templates/operatorMessagesForm.html").done(function (operatorMessagesFormTemplate) {
                that.operatorMessagesView = new OperatorMessagesView({
                    template: template,
                    operatorMessagesFormTemplate: operatorMessagesFormTemplate,
                    collection: new OperatorMessagesCollection(),
                    breadcrumb: [{
                        path: '#/advanced-items',
                        label: '{Literal}Advanced Items{/Literal}'
                    }, {
                        path: '#operator-messages',
                        label: '{Literal}Operator Messages{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.operatorMessagesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    noPartial: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("noPartial");
        if(!isLoaded) {
            await getScript('js/models/noPartial.js');
            await getScript('js/collections/noPartialCollection.js');
            await getScript('js/views/noPartial.js');
		    this.loadedPages.push("noPartial");
        }

        $.get("templates/noPartial.html").done(async function (template) {
             that.noPartialView = await new NoPartialView({
                template: template,
                collection: new NoPartialCollection(),
                breadcrumb: [{
                    path: '#/advanced-items',
                    label: '{Literal}Advanced Items{/Literal}'
                }, {
                    path: '#/no-partial',
                    label: '{Literal}No Partial Quantities{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.noPartialView.render().el);
            //$('select').formSelect();
        });
    },

    barcode: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("barcode");
        if(!isLoaded) {
            await getScript('js/models/barcode.js');
            await getScript('js/collections/barcodeCollection.js');
            await getScript('js/views/barcode.js');
		    this.loadedPages.push("barcode");
        }

        $.get("templates/barcode.html").done(function (template) {
            that.barcodeView = new BarcodeView({
                template: template,
                collection: new BarcodeCollection(),
                breadcrumb: [{
                    path: '#/advanced-items',
                    label: '{Literal}Advanced Items{/Literal}'
                }, {
                    path: '#/barcode',
                    label: '{Literal}Barcode Labels{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.barcodeView.render().el);
            $('select').formSelect();
        });
    },

    snapEBT: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("snapEBT");
        if(!isLoaded) {
            await getScript('js/models/snapEBT.js');
            await getScript('js/collections/snapEBTCollection.js');
            await getScript('js/views/snapEBT.js');
		    this.loadedPages.push("snapEBT");
        }

        $.get("templates/snapEBT.html").done(function (template) {
            that.snapEBTView = new SnapEBTView({
                template: template,
                collection: new SnapEBTCollection(),
                breadcrumb: [{
                    path: '#/snap-ebt',
                    label: '{Literal}SNAP / EBT{/Literal}'
                }]
            });
            $('main').children().detach();
            $('main').html(that.snapEBTView.render().el);
        });
    },

    customerTerms: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("delcustomerTermsiScale");
        if(!isLoaded) {
            await getScript('js/models/customerTerms.js');
            await getScript('js/collections/customerTermsCollection.js');
            await getScript('js/views/customerTerms.js');
            await getScript('js/views/customerTermsForm.js');
		    this.loadedPages.push("customerTerms");
        }

        $.get("templates/customerTerms.html").done(function (template) {
            $.get("templates/customerTermsForm.html").done(function (customerTermsFormTemplate) {
                that.customerTermsView = new CustomerTermsView({
                    template: template,
                    customerTermsFormTemplate: customerTermsFormTemplate,
                    collection: new CustomerTermsCollection(),
                    breadcrumb: [{
                        path: '#/customer-terms',
                        label: '{Literal}Customer Account Terms{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.customerTermsView.render().el);
            })
        });
    },

    unitsOfMeasure: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("unitsOfMeasure");
        if(!isLoaded) {
            await getScript('js/models/unitsOfMeasure.js');
            await getScript('js/collections/unitsOfMeasureCollection.js');
            await getScript('js/views/unitsOfMeasure.js');
            await getScript('js/views/unitsOfMeasureForm.js');
		    this.loadedPages.push("unitsOfMeasure");
        }

        $.get("templates/unitsOfMeasure.html").done(function (template) {
            $.get("templates/unitsOfMeasureForm.html").done(function (unitsOfMeasureFormTemplate) {
                that.unitsOfMeasuresView = new UnitsOfMeasureView({
                    template: template,
                    unitsOfMeasureFormTemplate: unitsOfMeasureFormTemplate,
                    collection: new UnitsOfMeasureCollection(),
                    breadcrumb: [{
                        path: '#/advanced-items',
                        label: '{Literal}Advanced Items{/Literal}'
                    }, {
                        path: '#/units-of-measure',
                        label: '{Literal}Units of Measure{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.unitsOfMeasuresView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    payTypes: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("payTypes");
        if(!isLoaded) {
            await getScript('js/models/payTypes.js');
            await getScript('js/collections/payTypesCollection.js');
            await getScript('js/views/payTypes.js');
            await getScript('js/views/payTypesForm.js');
		    this.loadedPages.push("payTypes");
        }

        $.get("templates/payTypes.html").done(function (template) {
            $.get("templates/payTypesForm.html").done(function (payTypesFormTemplate) {
                that.payTypesView = new PayTypesView({
                    template: template,
                    payTypesFormTemplate: payTypesFormTemplate,
                    collection: new PayTypesCollection(),
                    breadcrumb: [{
                        path: '#/pay-types',
                        label: '{Literal}Add/Edit Pay Types{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.payTypesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    payPeriod: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("payPeriod");
        if(!isLoaded) {
            await getScript('js/models/payPeriods.js');
            await getScript('js/collections/payPeriodsCollection.js');
            await getScript('js/views/payPeriods.js');
            await getScript('js/views/payPeriodsForm.js');
		    this.loadedPages.push("payPeriod");
        }

        $.get("templates/payPeriod.html").done(function (template) {
            $.get("templates/payPeriodForm.html").done(function (payPeriodsFormTemplate) {
                that.payPeriodsView = new PayPeriodsView({
                    template: template,
                    payPeriodsFormTemplate: payPeriodsFormTemplate,
                    collection: new PayPeriodsCollection(),
                    breadcrumb: [{
                        path: '#/pay-period',
                        label: '{Literal}View/Edit Pay Periods{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.payPeriodsView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    recipes: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("recipes");
        if(!isLoaded) {
            await getScript('js/models/recipes.js');
            await getScript('js/collections/recipesCollection.js');
            await getScript('js/views/recipes.js');
            await getScript('js/views/recipesForm.js');
		    this.loadedPages.push("delrecipesiScale");
        }

        $.get("templates/recipes.html").done(function (template) {
            $.get("templates/recipesForm.html").done(function (recipesFormTemplate) {
                that.recipesView = new RecipesView({
                    template: template,
                    recipesFormTemplate: recipesFormTemplate,
                    collection: new RecipesCollection(),
                    breadcrumb: [{
                        path: '#/advanced-items',
                        label: '{Literal}Advanced Items{/Literal}'
                    }, {
                        path: '#/recipes',
                        label: '{Literal}Item Recipes{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.recipesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },
    
    flexGroups: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("flexGroups");
        if(!isLoaded) {
            await getScript('js/models/flexGroups.js');
            await getScript('js/collections/flexGroupsCollection.js');
            await getScript('js/views/flexGroups.js');
            await getScript('js/views/flexGroupsForm.js');
		    this.loadedPages.push("flexGroups");
        }

        $.get("templates/flexGroups.html").done(function (template) {
            $.get("templates/flexGroupsForm.html").done(function (flexGroupsFormTemplate) {
                that.flexGroupsView = new FlexGroupsView({
                    template: template,
                    flexGroupsFormTemplate: flexGroupsFormTemplate,
                    collection: new FlexGroupsCollection(),
                    breadcrumb: [{
                        path: '#/advanced-items',
                        label: '{Literal}Advanced Items{/Literal}'
                    }, {
                        path: '#flex-groups',
                        label: '{Literal}Flex Group Items{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.flexGroupsView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    employees: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("employees");
        if(!isLoaded) {
            await getScript('js/models/employee.js');
            await getScript('js/collections/employeeCollection.js');
            await getScript('js/views/employees.js');
            await getScript('js/views/employeesForm.js');
		    this.loadedPages.push("employees");
        }

        $.get("templates/employees.html").done(function (template) {
            $.get("templates/employeesForm.html").done(function (employeesFormTemplate) {
                that.employeesView = new EmployeesView({
                    template: template,
                    employeesFormTemplate: employeesFormTemplate,
                    collection: new EmployeeCollection(),
                    breadcrumb: [{
                        path: '#employees',
                        label: '{Literal}Employees{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.employeesView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    breaks: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("breaks");
        if(!isLoaded) {
            await getScript('js/models/breaks.js');
            await getScript('js/collections/breaksCollection.js');
            await getScript('js/views/breaks.js');
            await getScript('js/views/breaksForm.js');
		    this.loadedPages.push("breaks");
        }

        $.get("templates/breaks.html").done(function (template) {
            $.get("templates/breaksForm.html").done(function (breaksFormTemplate) {
                that.breaksView = new BreaksView({
                    template: template,
                    breaksFormTemplate: breaksFormTemplate,
                    collection: new BreaksCollection(),
                    breadcrumb: [{
                        path: '#/breaks',
                        label: '{Literal}Breaks{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.breaksView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });
    },

    eConduit: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("eConduit");
        if(!isLoaded) {
            await getScript('js/models/eConduit.js');
            await getScript('js/collections/eConduitCollection.js');
            await getScript('js/views/eConduit.js');
            await getScript('js/views/eConduitForm.js');
		    this.loadedPages.push("eConduit");
        }

        $.get("templates/eConduit.html").done(function (template) {
            $.get("templates/eConduitForm.html").done(function (eConduitFormTemplate) {
                that.eConduitView = new EConduitView({
                    template: template,
                    eConduitFormTemplate: eConduitFormTemplate,
                    collection: new EConduitCollection(),
                    breadcrumb: [{
                        path: '#/advanced-settings',
                        label: '{Literal}Advanced Settings{/Literal}'
                    }, {
                        path: '#/e-conduit',
                        label: '{Literal}eConduit Setup{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.eConduitView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });  
    },
    triPOS: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("triPOS");
        if(!isLoaded) {
            await getScript('js/models/triPOS.js');
            await getScript('js/collections/triPOSCollection.js');
            await getScript('js/views/triPOS.js');
            await getScript('js/views/triPOSForm.js');
		    this.loadedPages.push("triPOS");
        }

        $.get("templates/triPOS.html").done(function (template) {
            $.get("templates/triPOSForm.html").done(function (triPOSFormTemplate) {
                that.triPOSView = new TriPOSView({
                    template: template,
                    triPOSFormTemplate: triPOSFormTemplate,
                    collection: new TriPOSCollection(),
                    breadcrumb: [{
                        path: '#/advanced-settings',
                        label: '{Literal}Advanced Settings{/Literal}'
                    }, {
                        path: '#/triPOS',
                        label: '{Literal}triPOS Setup{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.triPOSView.render().el);
                $(document).ready(function () {
                    $('.modal').modal();
                });
            })
        });  
    },

    importExportData: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("importExportData");
        if(!isLoaded) {
            await getScript('js/views/importExportData.js');
            this.loadedPages.push("importExportData");
        }

        $.get("templates/importExportData.html").done(function (template) {
                that.importExportDataView = new ImportExportDataView({
                    template: template,
                    breadcrumb: [{
                            path: '#/advanced-settings',
                            label: '{Literal}Advanced Settings{/Literal}'
                        },{
                        path: '#/import-export-data',
                        label: '{Literal}Import / Export Data{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.importExportDataView.render().el);
        });
    },
    serverConfiguration: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("serverConfiguration");
        if(!isLoaded) {
            await getScript('js/views/serverConfiguration.js');
            this.loadedPages.push("serverConfiguration");
        }

        $.get("templates/serverConfiguration.html").done(function (template) {
                that.serverConfiguration = new ServerConfigurationView({
                    template: template,
                    breadcrumb: [{
                            path: '#/advanced-settings',
                            label: '{Literal}Advanced Settings{/Literal}'
                        },{
                        path: '#/server-configuration',
                        label: '{Literal}Server Configuration{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.serverConfiguration.render().el);
        });
    },

    scheduledEmailReports: async function () {
        var that = this;
        var isLoaded =  this.loadedPages.includes("scheduledEmailReports");
        if(!isLoaded) {
            await getScript('js/views/scheduledEmailReports.js');
            await getScript('js/views/ScheduledEmailReportsForm.js');
            this.loadedPages.push("scheduledEmailReports");
        }

        $.get("templates/scheduledEmailReports.html").done(function (template) {
            $.get("templates/scheduledEmailReportsForm.html").done(function (formTemplate) {
                that.scheduledEmailReports = new ScheduledEmailReportsView({
                    template: template,
                    formTemplate: formTemplate,
                    breadcrumb: [{
                        path: '#/scheduled-email-reports',
                        label: '{Literal}Scheduled Email Reports{/Literal}'
                    }]
                });
                $('main').children().detach();
                $('main').html(that.scheduledEmailReports.render().el);
            })
        });
    },
    
    isTokenValid: function() {
        var isValid = true;
        var expireationDate = this.getCookieExpirationDate();
        expireationDate = Number.parseInt(expireationDate);
        var now = (new Date()).getTime();
        if( isNaN(expireationDate) || expireationDate <= now){
            isValid = false;
            document.cookie = "sessionCookie=";
            document.cookie = "expiration-date=";
        }

        var sessionToken = this.getCookie();

        if(isValid) {
        	$.ajax({
        		url: '/data/check-token',
        		data: {
                    token: sessionToken,
        		},
        		dataType: 'json',
        		type: 'POST',
                async: false,
        		success: function (data) {
        			if(!data.isSessionValid){
                        document.cookie = "sessionCookie=";
                        document.cookie = "expiration-date=";
                    }
        		},

        		error: function (e) {
        			if (e.status == 523) {
        				window.location.href = "#/log-in";
        				location.reload();
        			}
        		}
            });
        }
        return isValid;
    },
    getCookieExpirationDate: function  () {
        var nameEQ = "expiration-date" + "=";
        var ca = document.cookie.split(';');
        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
        }
    },
    getCookie: function() {
        var nameEQ = "sessionCookie" + "=";
        var ca = document.cookie.split(';');
        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
        }
    }

});

App = new AppRouter();
// $(function () {
    // if (!Backbone.history.start()) App.trigger('404');
// });