/*
 * Decompiled with CFR 0.152.
 */
package AccuServerDataAccess;

import AccuCountDataObjects.AdjustmentSession;
import AccuCountDataObjects.PriceChangeSession;
import AccuCountDataObjects.ReceivingSession;
import AccuCountDataObjects.Vendor;
import AccuServerBase.CloudDataBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import AccuShiftDataObjects.BreakInfo;
import AccuShiftDataObjects.Employee;
import POSDataObjects.AlternateTax;
import POSDataObjects.BackupInfo;
import POSDataObjects.BarCodeInfo;
import POSDataObjects.ChoiceGroup;
import POSDataObjects.CompanySetupInfo;
import POSDataObjects.Customer;
import POSDataObjects.CustomerTerm;
import POSDataObjects.DisplayPrinter;
import POSDataObjects.EConduitTerminal;
import POSDataObjects.FlexGroup;
import POSDataObjects.FlexGroupDetail;
import POSDataObjects.GratuitySetup;
import POSDataObjects.Item;
import POSDataObjects.ItemCategory;
import POSDataObjects.ItemGroup;
import POSDataObjects.ItemType;
import POSDataObjects.ItemTypeSummary;
import POSDataObjects.LineItem;
import POSDataObjects.MenuKey;
import POSDataObjects.NoPartialQuantity;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.PriceLevelTime;
import POSDataObjects.PricingSetup;
import POSDataObjects.ProductLine;
import POSDataObjects.ReceiptPrintSetup;
import POSDataObjects.Reset;
import POSDataObjects.SalePrice;
import POSDataObjects.ServerLocation;
import POSDataObjects.Table;
import POSDataObjects.TaxAuthority;
import POSDataObjects.TaxCode;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Till;
import POSDataObjects.TransactionReportOptions;
import POSDataObjects.UnitOfMeasure;
import POSDataObjects.User;
import POSDataObjects.UserGroupInfo;
import POSDataObjects.ValueAddedTax;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;

public class HostDataAccess
implements ServerObject,
CloudDataBase {
    ServerCore core = null;
    String locationCode = "";
    String cloudHost = "";
    String cloudUser = "";
    String cloudPswd = "";
    String cloudInfo = "";
    String siteTaxCode = "";
    Timestamp syncStartDate = null;
    boolean isSyncing = false;
    boolean showSyncTime = false;
    boolean forceSync = false;

    public void initialize(ServerCore core, Hashtable parameters) {
        try {
            this.core = core;
            if (parameters != null) {
                String forceSyncString;
                String syncStartDateString;
                String taxCode;
                String showSyncTimeString = (String)parameters.get("ShowSyncTime");
                if (showSyncTimeString != null && !showSyncTimeString.isEmpty()) {
                    this.showSyncTime = Boolean.parseBoolean(showSyncTimeString);
                }
                if ((taxCode = core.getSiteTaxCode()) != null && !taxCode.isEmpty()) {
                    this.siteTaxCode = taxCode;
                }
                if ((syncStartDateString = (String)parameters.get("SyncStartDate")) != null && !syncStartDateString.isEmpty() && syncStartDateString.length() == 8) {
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("MMddyyyy");
                        Date startDate = dateFormat.parse(syncStartDateString);
                        this.syncStartDate = new Timestamp(startDate.getTime());
                    }
                    catch (Exception e) {
                        this.syncStartDate = null;
                    }
                }
                if ((forceSyncString = (String)parameters.get("ForceSync")) != null && !forceSyncString.isEmpty()) {
                    this.forceSync = Boolean.parseBoolean(forceSyncString);
                    if (this.forceSync) {
                        core.forceHostSync(false);
                        core.input("HostDataAccess has been set to Force Sync all Tables");
                    }
                }
            }
            core.setCloudDataHandler(this);
        }
        catch (Exception ex) {
            core.raiseException(ex);
        }
    }

    public void setSyncStartDate(Timestamp syncStartTimestamp) {
        if (syncStartTimestamp != null) {
            this.syncStartDate = syncStartTimestamp;
        }
    }

    public int getType() {
        return 0;
    }

    public void output(String output) {
    }

    public void shutDown() {
    }

    public void checkDatabase() {
    }

    private void syncOrders() {
        this.isSyncing = true;
        Timestamp startTime = new Timestamp(new GregorianCalendar().getTimeInMillis());
        POSDataContainer orders = this.core.getSyncOrders(this.syncStartDate);
        boolean good = true;
        if (orders != null && orders.size() > 0) {
            TimeZone timeZone = TimeZone.getDefault();
            String timeZoneString = timeZone.getID();
            int numOrders = orders.size();
            this.core.input(this.core.getLiteral("Syncing " + numOrders + " " + "Order(s) with the AccuPOS Cloud"));
            this.core.addToLog(this.core.getLiteral("Syncing " + numOrders + " " + "Order(s) with the AccuPOS Cloud"));
            for (int i = 0; i < numOrders; ++i) {
                Order thisSyncOrder = (Order)orders.get(i);
                String thisSyncOrderXml = thisSyncOrder.toXml();
                String request = "<Request>SyncOrders</Request><ConnectionTimeZone>" + timeZoneString + "</ConnectionTimeZone>" + thisSyncOrderXml + "\r\n";
                this.core.sendToHost(request);
                boolean waiting = true;
                int timeout = 1000;
                do {
                    String reply;
                    if ((reply = this.core.getHostReply("SyncedOrders")) != null && !reply.isEmpty()) {
                        Timestamp lastUpdateTimeStamp = new Timestamp(new GregorianCalendar().getTimeInMillis());
                        Vector ordersList = Utility.getElementList("SyncedOrders", reply);
                        int len = ordersList.size();
                        for (int o = 0; o < len; ++o) {
                            String thisOrderXml = (String)ordersList.get(o);
                            int thisOrderNumber = Utility.getIntElement("OrderNumber", thisOrderXml);
                            this.core.updateOrderCloudTimeStamp(thisOrderNumber, lastUpdateTimeStamp);
                        }
                        waiting = false;
                        continue;
                    }
                    if (--timeout <= 0) {
                        waiting = false;
                        this.core.addToLog(this.core.getLiteral("Syncing " + numOrders + " " + "Order(s) Aborted!!! Timeout waiting for Host Reply Exceeded"));
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (waiting);
            }
            this.core.input(this.core.getLiteral("AccuPOS Cloud Sync Completed for") + " " + numOrders + " " + "Order(s)");
            this.core.addToLog(this.core.getLiteral("AccuPOS Cloud Sync Completed for") + " " + numOrders + " " + "Order(s)");
            Timestamp endTime = new Timestamp(new GregorianCalendar().getTimeInMillis());
            if (this.showSyncTime) {
                DecimalFormat formatter = new DecimalFormat("#0.00000");
                this.core.input(numOrders + " " + this.core.getLiteral("Order(s) sync'd in") + " " + formatter.format((double)(endTime.getTime() - startTime.getTime()) / 1000.0) + " " + this.core.getLiteral("seconds"));
                this.core.addToLog(numOrders + " " + this.core.getLiteral("Order(s) sync'd in") + " " + formatter.format((double)(endTime.getTime() - startTime.getTime()) / 1000.0) + " " + this.core.getLiteral("seconds"));
            }
        }
        this.isSyncing = false;
    }

    public void syncData() {
        if (!this.core.hostSyncActive()) {
            return;
        }
        SyncThread syncThread = new SyncThread(10000);
        syncThread.start();
    }

    public void syncCloudItems() {
        POSDataContainer itemSync = null;
        StringBuilder itemsXml = new StringBuilder();
        final StringBuilder followOnsXml = new StringBuilder();
        final StringBuilder uomXml = new StringBuilder();
        final StringBuilder itemGroupsXml = new StringBuilder();
        final StringBuilder salePricesXml = new StringBuilder();
        final StringBuilder flexGroupsXml = new StringBuilder();
        final StringBuilder flexGroupDetailXml = new StringBuilder();
        final StringBuilder noPartialQuantityXml = new StringBuilder();
        Timestamp syncTime = null;
        final Timestamp lastSyncTime = syncTime = this.core.getLastCloudSyncTime();
        final Hashtable segmentsStatus = new Hashtable();
        int numSegments = 0;
        itemSync = this.core.getItemsSync(lastSyncTime);
        if (itemSync != null && itemSync.size() > 0) {
            int numItems = itemSync.size();
            int currentSegment = 1;
            int numCurrentSegment = 0;
            numSegments = 1;
            if (numItems > 500) {
                numSegments = numItems / 500;
            }
            for (int k = 0; k < numItems; ++k) {
                POSDataContainer theseItemGroups;
                String[] split;
                Item thisItem = (Item)itemSync.get(k);
                itemsXml.append(thisItem.toXml());
                if (thisItem.followOns != null) {
                    followOnsXml.append(thisItem.followOns.toXml());
                }
                if (!thisItem.UOM.isEmpty() && (split = thisItem.UOM.split(" - ")).length == 2) {
                    UnitOfMeasure thisUOM = new UnitOfMeasure();
                    thisUOM.code = thisItem.code;
                    if (split[0] != null && !split[0].isEmpty()) {
                        try {
                            thisUOM.quantity = Double.parseDouble(split[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (split[1] != null && !split[1].isEmpty()) {
                        try {
                            thisUOM.stockingItem = split[1];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    uomXml.append(thisUOM.toXml());
                }
                if ((thisItem.isGroup || thisItem.isBundle) && thisItem.detailItems != null && thisItem.detailItems.size() > 0 && (theseItemGroups = this.core.getItemGroup(thisItem.code)) != null && theseItemGroups.size() > 0) {
                    int numGroups = theseItemGroups.size();
                    for (int i = 0; i < numGroups; ++i) {
                        ItemGroup thisGroup = (ItemGroup)theseItemGroups.get(i);
                        itemGroupsXml.append(thisGroup.toXml());
                    }
                }
                if (thisItem.salePrices != null && thisItem.salePrices.size() > 0) {
                    int numsalePrices = thisItem.salePrices.size();
                    for (int i = 0; i < numsalePrices; ++i) {
                        SalePrice thisSalePrice = (SalePrice)thisItem.salePrices.get(i);
                        salePricesXml.append(thisSalePrice.toXml());
                    }
                }
                if (numSegments > 1 && numCurrentSegment < 500 && k < numItems - 1) {
                    ++numCurrentSegment;
                    continue;
                }
                if (numCurrentSegment >= 500 || k == numItems - 1) {
                    final String sendItemsXml = new String(itemsXml);
                    String finalSyncedResponse = "SyncedItems";
                    String finalSyncCommand = "SyncItems";
                    final int syncSegment = currentSegment++;
                    new Thread(new Runnable(){

                        public void run() {
                            StringBuilder commandXml = new StringBuilder();
                            commandXml.append("<Request>SyncItems</Request>");
                            commandXml.append("<ItemsSegment>" + syncSegment + "</ItemsSegment>");
                            commandXml.append("<Items>" + sendItemsXml + "</Items>");
                            HostDataAccess.this.core.sendToHost(commandXml.toString());
                            segmentsStatus.put(syncSegment, "");
                            boolean waiting = true;
                            int timeout = 1000;
                            do {
                                String reply;
                                if ((reply = HostDataAccess.this.core.getHostReply("SyncedItems-" + syncSegment)) != null && !reply.isEmpty()) {
                                    int itemsSegment = Utility.getIntElement("SyncedItemsSegment", reply);
                                    boolean success = Utility.getBooleanElement("SyncedItemsStatus", reply);
                                    if (!success) {
                                        HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("Items Sync was Not Successful for Segment " + itemsSegment));
                                    } else {
                                        HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("Items Sync was Successful for Segment " + itemsSegment));
                                        Vector itemCodes = Utility.getElementList("ItemCode", reply);
                                        HostDataAccess.this.core.updateSyncedItemsLastChanged(itemCodes);
                                    }
                                    segmentsStatus.put(itemsSegment, "" + success);
                                    continue;
                                }
                                if (--timeout <= 0) break;
                                try {
                                    Thread.sleep(30000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            } while (waiting);
                        }
                    }).start();
                    itemsXml = new StringBuilder();
                    numCurrentSegment = 0;
                    continue;
                }
                if (numCurrentSegment < numItems - 1) {
                    ++numCurrentSegment;
                    continue;
                }
                final String sendItemsXml = new String(itemsXml);
                new Thread(new Runnable(){

                    public void run() {
                        StringBuilder commandXml = new StringBuilder();
                        commandXml.append("<Request>SyncItems</Request>");
                        commandXml.append("<Items>" + sendItemsXml + "</Items>");
                        HostDataAccess.this.core.sendToHost(commandXml.toString());
                        segmentsStatus.put(1, "");
                        boolean waiting = true;
                        int timeout = 1000;
                        do {
                            String reply;
                            if ((reply = HostDataAccess.this.core.getHostReply("SyncedItems-1")) != null && !reply.isEmpty()) {
                                int itemsSegment = Utility.getIntElement("SyncedItemsSegment", reply);
                                boolean success = Utility.getBooleanElement("SyncedItemsStatus", reply);
                                if (!success) {
                                    HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("Items Sync was Not Successful"));
                                } else {
                                    HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("Items Sync was Successful"));
                                }
                                segmentsStatus.put(itemsSegment, "" + success);
                                continue;
                            }
                            if (--timeout <= 0) break;
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        } while (waiting);
                    }
                }).start();
            }
            new Thread(new Runnable(){

                public void run() {
                    StringBuilder commandXml = new StringBuilder();
                    commandXml.append("<Request>SyncFollowOns</Request>");
                    commandXml.append("<FollowOns>" + followOnsXml + "</FollowOns>");
                    HostDataAccess.this.core.sendToHost(commandXml.toString());
                }
            }).start();
            new Thread(new Runnable(){

                public void run() {
                    StringBuilder commandXml = new StringBuilder();
                    commandXml.append("<Request>SyncUOMs</Request>");
                    commandXml.append("<UOMs>" + uomXml + "</UOMs>");
                    HostDataAccess.this.core.sendToHost(commandXml.toString());
                }
            }).start();
            new Thread(new Runnable(){

                public void run() {
                    StringBuilder commandXml = new StringBuilder();
                    commandXml.append("<Request>SyncItemGroups</Request>");
                    commandXml.append("<ItemGroups>" + itemGroupsXml + "</ItemGroups>");
                    HostDataAccess.this.core.sendToHost(commandXml.toString());
                }
            }).start();
            new Thread(new Runnable(){

                public void run() {
                    StringBuilder commandXml = new StringBuilder();
                    commandXml.append("<Request>SyncSalePrices</Request>");
                    commandXml.append("<SalePricesXml>" + salePricesXml + "</SalePricesXml>");
                    HostDataAccess.this.core.sendToHost(commandXml.toString());
                }
            }).start();
            new Thread(new Runnable(){

                public void run() {
                    POSDataContainer flexGroups = HostDataAccess.this.core.getAllFlexGroups();
                    if (flexGroups != null && flexGroups.size() > 0) {
                        int numFlexGroups = flexGroups.size();
                        for (int i = 0; i < numFlexGroups; ++i) {
                            FlexGroup thisFlexGroup = (FlexGroup)flexGroups.get(i);
                            flexGroupsXml.append(thisFlexGroup.toXml());
                        }
                    }
                    StringBuilder commandXml = new StringBuilder();
                    commandXml.append("<Request>SyncFlexGroups</Request>");
                    commandXml.append("<FlexGroups>" + flexGroupsXml + "</FlexGroups>");
                    HostDataAccess.this.core.sendToHost(commandXml.toString());
                    commandXml = new StringBuilder();
                }
            }).start();
            new Thread(new Runnable(){

                public void run() {
                    POSDataContainer flexGroupDetail = HostDataAccess.this.core.getAllFlexGroupDetail();
                    if (flexGroupDetail != null && flexGroupDetail.size() > 0) {
                        int numFlexGroupDetail = flexGroupDetail.size();
                        for (int i = 0; i < numFlexGroupDetail; ++i) {
                            FlexGroupDetail thisFlexGroupDetail = (FlexGroupDetail)flexGroupDetail.get(i);
                            flexGroupDetailXml.append(thisFlexGroupDetail.toXml());
                        }
                        StringBuilder commandXml = new StringBuilder();
                        commandXml.append("<Request>SyncFlexGroupDetails</Request>");
                        commandXml.append("<FlexGroupDetails>" + flexGroupDetailXml + "</FlexGroupDetails>");
                        HostDataAccess.this.core.sendToHost(commandXml.toString());
                    }
                }
            }).start();
            new Thread(new Runnable(){

                public void run() {
                    POSDataContainer noPartialQuantities = HostDataAccess.this.core.getNoPartialQuantityItemsSync(lastSyncTime);
                    if (noPartialQuantities != null && noPartialQuantities.size() > 0) {
                        int numNoPartialQuantities = noPartialQuantities.size();
                        for (int i = 0; i < numNoPartialQuantities; ++i) {
                            NoPartialQuantity thisNoPartialQuantity = (NoPartialQuantity)noPartialQuantities.get(i);
                            noPartialQuantityXml.append(thisNoPartialQuantity.toXml());
                        }
                        StringBuilder commandXml = new StringBuilder();
                        commandXml.append("<Request>SyncNoPartialQtys</Request>");
                        commandXml.append("<NoPartialQtys>" + noPartialQuantityXml + "</NoPartialQtys>");
                        HostDataAccess.this.core.sendToHost(commandXml.toString());
                    }
                }
            }).start();
        }
        new Thread(new Runnable(){

            public void run() {
                boolean waiting = true;
                int timeout = 1000;
                do {
                    boolean success;
                    String reply;
                    if ((reply = HostDataAccess.this.core.getHostReply("SyncedFollowOnItems")) != null && !reply.isEmpty()) {
                        success = Utility.getBooleanElement("SyncedFollowOnItems", reply);
                        if (success) {
                            HostDataAccess.this.core.updateHostSyncStatus("FollowOnItems");
                        } else {
                            HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("FollowOnItems Sync was Not Completed Successfully"));
                        }
                    }
                    if ((reply = HostDataAccess.this.core.getHostReply("SyncedUnitOfMeasures")) != null && !reply.isEmpty()) {
                        success = Utility.getBooleanElement("SyncedUnitOfMeasures", reply);
                        if (success) {
                            HostDataAccess.this.core.updateHostSyncStatus("UnitOfMeasure");
                        } else {
                            HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("UnitOfMeasures Sync was Not Completed Successfully"));
                        }
                    }
                    if ((reply = HostDataAccess.this.core.getHostReply("SyncedItemGroups")) != null && !reply.isEmpty()) {
                        success = Utility.getBooleanElement("SyncedItemGroups", reply);
                        if (success) {
                            HostDataAccess.this.core.updateHostSyncStatus("ItemGroups");
                        } else {
                            HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("ItemGroups Sync was Not Completed Successfully"));
                        }
                    }
                    if ((reply = HostDataAccess.this.core.getHostReply("SyncedSalePrices")) != null && !reply.isEmpty()) {
                        success = Utility.getBooleanElement("SyncedSalePrices", reply);
                        if (success) {
                            HostDataAccess.this.core.updateHostSyncStatus("SalePrice");
                        } else {
                            HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("SalePrices Sync was Not Completed Successfully"));
                        }
                    }
                    if ((reply = HostDataAccess.this.core.getHostReply("SyncedFlexGroups")) != null && !reply.isEmpty()) {
                        success = Utility.getBooleanElement("SyncedFlexGroups", reply);
                        if (success) {
                            HostDataAccess.this.core.updateHostSyncStatus("FlexGroups");
                        } else {
                            HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("FlexGroups Sync was Not Completed Successfully"));
                        }
                    }
                    if ((reply = HostDataAccess.this.core.getHostReply("SyncedFlexGroupDetails")) != null && !reply.isEmpty()) {
                        success = Utility.getBooleanElement("SyncedFlexGroupDetails", reply);
                        if (success) {
                            HostDataAccess.this.core.updateHostSyncStatus("FlexGroupDetail");
                        } else {
                            HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("FlexGroupDetails Sync was Not Completed Successfully"));
                        }
                    }
                    if ((reply = HostDataAccess.this.core.getHostReply("SyncedNoPartialQtys")) != null && !reply.isEmpty()) {
                        success = Utility.getBooleanElement("SyncedNoPartialQtys", reply);
                        if (success) {
                            HostDataAccess.this.core.updateHostSyncStatus("NoPartialQuantityItems");
                            continue;
                        }
                        HostDataAccess.this.core.input(HostDataAccess.this.core.getLiteral("NoPartialQtys Sync was Not Completed Successfully"));
                        continue;
                    }
                    if (--timeout <= 0) {
                        waiting = false;
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (waiting);
            }
        }).start();
        final int numberOfSegments = numSegments;
        new Thread(new Runnable(){

            public void run() {
                boolean allItemsSynced = false;
                int timeout = 1000;
                do {
                    if (allItemsSynced = HostDataAccess.this.checkAllItemsSynced(numberOfSegments, segmentsStatus)) {
                        HostDataAccess.this.core.updateHostSyncStatus("apinms");
                        continue;
                    }
                    if (--timeout <= 0) break;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (!allItemsSynced);
            }
        }).start();
    }

    public boolean checkAllItemsSynced(int numSegments, Hashtable segmentsStatus) {
        boolean itemsSynced = true;
        for (int i = 1; i < numSegments; ++i) {
            String syncStatus = (String)segmentsStatus.get(i);
            if (syncStatus == null || syncStatus.isEmpty()) {
                itemsSynced = false;
                break;
            }
            if (syncStatus.compareToIgnoreCase("false") == 0) {
                itemsSynced = false;
                break;
            }
            this.output(this.core.getLiteral("Items Sync Completed Successfully for Segment ") + i);
        }
        if (!itemsSynced) {
            System.out.println("Items Sync not Yet Completed");
        }
        return itemsSynced;
    }

    public void syncCompanyInfo() {
        StringBuilder companyInfoXml = new StringBuilder();
        TimeZone timeZone = TimeZone.getDefault();
        String timeZoneString = timeZone.getID();
        CompanySetupInfo companySetupInfo = this.core.getCompanySetup();
        PricingSetup pricingSetup = this.core.getPricingSetup();
        ReceiptPrintSetup receiptPrintSetup = this.core.getReceiptPrintSetup();
        GratuitySetup gratuitySetup = this.core.getGratuitySetup();
        BarCodeInfo barCodeInfo = this.core.getBarCodeSetup();
        BackupInfo backupInfo = this.core.getBackupInfo();
        String centralInfo = this.core.getCentralInfo();
        companySetupInfo.smsAuth1 = "";
        companySetupInfo.smsAuth2 = "";
        companySetupInfo.smsAuth3 = "";
        companySetupInfo.smsPhone = "";
        companySetupInfo.timeZone = timeZoneString;
        if (centralInfo != null) {
            companyInfoXml.append(centralInfo);
        }
        if (companySetupInfo != null) {
            companyInfoXml.append(companySetupInfo.toXml());
        }
        if (pricingSetup != null) {
            companyInfoXml.append(pricingSetup.toXml());
        }
        if (receiptPrintSetup != null) {
            companyInfoXml.append(receiptPrintSetup.toXml());
        }
        if (gratuitySetup != null) {
            companyInfoXml.append(gratuitySetup.toXml());
        }
        if (barCodeInfo != null) {
            companyInfoXml.append(barCodeInfo.toXml());
        }
        if (backupInfo != null) {
            companyInfoXml.append(backupInfo.toXml());
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncCompanyInfo</Request>");
        commandXml.append("<CompanyInfo>" + companyInfoXml.toString() + "</CompanyInfo>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedCompanyInfo")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedCompanyInfo", reply);
                if (success) {
                    this.core.updateHostSyncStatus("apcscent");
                    this.core.updateHostSyncStatus("Control");
                    continue;
                }
                this.core.input(this.core.getLiteral("Company Info Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncCustomers() {
        POSDataContainer customersSync = null;
        StringBuilder customersXml = new StringBuilder();
        customersSync = this.core.getCustomers();
        if (customersSync != null && customersSync.size() > 0) {
            int numCustomers = customersSync.size();
            for (int k = 0; k < numCustomers; ++k) {
                Customer thisCustomer = (Customer)customersSync.get(k);
                if (thisCustomer.extendedData != null && !thisCustomer.extendedData.isEmpty()) {
                    try {
                        String newExtendedData;
                        String encryptKey = new String(this.core.getEncodedKey2(), "UTF-8");
                        byte[] encryptedExtendedData = this.core.encrypt(encryptKey, thisCustomer.extendedData);
                        thisCustomer.extendedData = newExtendedData = new String(Base64.encode(encryptedExtendedData));
                    }
                    catch (Exception encryptKey) {
                        // empty catch block
                    }
                }
                customersXml.append(thisCustomer.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncCustomers</Request>");
        commandXml.append("<Customers>" + customersXml + "</Customers>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedCustomers")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedCustomers", reply);
                if (success) {
                    this.core.updateHostSyncStatus("Customers");
                    continue;
                }
                this.core.input(this.core.getLiteral("Customers Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncEmployees(Timestamp lastChanged) {
        Timestamp startDate = null;
        Timestamp endDate = new Timestamp(new Date().getTime());
        startDate = lastChanged == null ? new Timestamp(103, 0, 1, 0, 0, 0, 0) : lastChanged;
        ArrayList employeesSync = null;
        StringBuilder employeesXml = new StringBuilder();
        employeesSync = this.core.getEmployees();
        if (employeesSync != null && employeesSync.size() > 0) {
            int numEmployees = employeesSync.size();
            for (int k = 0; k < numEmployees; ++k) {
                Employee thisEmployee = (Employee)employeesSync.get(k);
                thisEmployee = this.core.getEmployeePeriodDetailFromTimeRange(thisEmployee, startDate, endDate);
                employeesXml.append(thisEmployee.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncEmployees</Request>");
        commandXml.append("<Employees>" + employeesXml + "</Employees>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedEmployees")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedEmployees", reply);
                if (success) {
                    this.core.updateHostSyncStatus("Employees");
                    continue;
                }
                this.core.input(this.core.getLiteral("Employees Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncUserGroups() {
        POSDataContainer userGroupsSync = null;
        StringBuilder userGroupsXml = new StringBuilder();
        userGroupsSync = this.core.getUserGroups();
        if (userGroupsSync != null && userGroupsSync.size() > 0) {
            int numUserGroups = userGroupsSync.size();
            for (int k = 0; k < numUserGroups; ++k) {
                UserGroupInfo thisUserGroup = (UserGroupInfo)userGroupsSync.get(k);
                userGroupsXml.append(thisUserGroup.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncUserGroups</Request>");
        commandXml.append("<UserGroups>" + userGroupsXml + "</UserGroups>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedUserGroups")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedUserGroups", reply);
                if (success) {
                    this.core.updateHostSyncStatus("apusrgrp");
                    continue;
                }
                this.core.input(this.core.getLiteral("User Groups Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncUsers() {
        POSDataContainer usersSync = null;
        StringBuilder usersXml = new StringBuilder();
        usersSync = this.core.getUserList();
        if (usersSync != null && usersSync.size() > 0) {
            int numUsers = usersSync.size();
            for (int k = 0; k < numUsers; ++k) {
                User thisUser = (User)usersSync.get(k);
                usersXml.append(thisUser.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncUsers</Request>");
        commandXml.append("<Users>" + usersXml + "</Users>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedUsers")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedUsers", reply);
                if (success) {
                    this.core.updateHostSyncStatus("apuser");
                    continue;
                }
                this.core.input(this.core.getLiteral("Users Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncTaxCodes() {
        POSDataContainer taxCodesSync = null;
        StringBuilder taxCodesXml = new StringBuilder();
        taxCodesSync = this.core.getTaxCodes();
        if (taxCodesSync != null && taxCodesSync.size() > 0) {
            int numUsers = taxCodesSync.size();
            for (int k = 0; k < numUsers; ++k) {
                TaxCode thisTaxCode = (TaxCode)taxCodesSync.get(k);
                taxCodesXml.append(thisTaxCode.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncTaxCodes</Request>");
        commandXml.append("<TaxCodes>" + taxCodesXml + "</TaxCodes>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedTaxCodes")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedTaxCodes", reply);
                if (success) {
                    this.core.updateHostSyncStatus("aptxcode");
                    continue;
                }
                this.core.input(this.core.getLiteral("Tax Codes Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncTaxAuthorities() {
        POSDataContainer taxAuthoritiesSync = null;
        StringBuilder taxAuthoritiesXml = new StringBuilder();
        taxAuthoritiesSync = this.core.getTaxAuthoritiesList();
        if (taxAuthoritiesSync != null && taxAuthoritiesSync.size() > 0) {
            int numTaxAuthorities = taxAuthoritiesSync.size();
            for (int k = 0; k < numTaxAuthorities; ++k) {
                TaxAuthority thisTaxAuthority = (TaxAuthority)taxAuthoritiesSync.get(k);
                taxAuthoritiesXml.append(thisTaxAuthority.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        taxAuthoritiesXml.append("<Request>SyncTaxAuthorities</Request>");
        commandXml.append("<TaxAuthorities>" + taxAuthoritiesXml + "</TaxAuthorities>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedTaxAuthorities")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedTaxAuthorities", reply);
                if (success) {
                    this.core.updateHostSyncStatus("aptxauth");
                    continue;
                }
                this.core.input(this.core.getLiteral("Tax Authorities Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncTenderCodes() {
        POSDataContainer tenderCodesSync = null;
        StringBuilder tenderCodesXml = new StringBuilder();
        tenderCodesSync = this.core.getTenderCodesList();
        if (tenderCodesSync != null && tenderCodesSync.size() > 0) {
            int numTenderCodes = tenderCodesSync.size();
            for (int k = 0; k < numTenderCodes; ++k) {
                TenderCode thisTenderCode = (TenderCode)tenderCodesSync.get(k);
                tenderCodesXml.append(thisTenderCode.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncTenderCodes</Request>");
        commandXml.append("<TenderCodes>" + tenderCodesXml + "</TenderCodes>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedTenderCodes")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedTenderCodes", reply);
                if (success) {
                    this.core.updateHostSyncStatus("aptndcd");
                    continue;
                }
                this.core.input(this.core.getLiteral("Tender Codes Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncTills() {
        POSDataContainer tillsSync = null;
        StringBuilder tillsXml = new StringBuilder();
        tillsSync = this.core.getTillsList();
        if (tillsSync != null && tillsSync.size() > 0) {
            int numTills = tillsSync.size();
            for (int k = 0; k < numTills; ++k) {
                Till thisTill = (Till)tillsSync.get(k);
                tillsXml.append(thisTill.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncTills</Request>");
        commandXml.append("<Tills>" + tillsXml + "</Tills>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedTills")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedTills", reply);
                if (success) {
                    this.core.updateHostSyncStatus("aptill");
                    continue;
                }
                this.core.input(this.core.getLiteral("Tills Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncMenuKeys() {
        POSDataContainer menuKeysSync = null;
        StringBuilder menuKeysXml = new StringBuilder();
        menuKeysSync = this.core.getMenuKeysList();
        if (menuKeysSync != null && menuKeysSync.size() > 0) {
            int numMenuKeys = menuKeysSync.size();
            for (int k = 0; k < numMenuKeys; ++k) {
                MenuKey thisMenuKey = (MenuKey)menuKeysSync.get(k);
                menuKeysXml.append(thisMenuKey.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncMenuKeys</Request>");
        commandXml.append("<MenuKeys>" + menuKeysXml + "</MenuKeys>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedMenuKeys")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedMenuKeys", reply);
                if (success) {
                    this.core.updateHostSyncStatus("apcskeys");
                    continue;
                }
                this.core.input(this.core.getLiteral("Menu Keys Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncChoiceKeys() {
        POSDataContainer choiceKeysSync = null;
        StringBuilder choiceKeysXml = new StringBuilder();
        choiceKeysSync = this.core.getChoicesSync(null);
        if (choiceKeysSync != null && choiceKeysSync.size() > 0) {
            int numChoiceKeys = choiceKeysSync.size();
            for (int k = 0; k < numChoiceKeys; ++k) {
                ChoiceGroup thisChoiceGroup = (ChoiceGroup)choiceKeysSync.get(k);
                choiceKeysXml.append(thisChoiceGroup.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncChoiceKeys</Request>");
        commandXml.append("<ChoiceGroups>" + choiceKeysXml + "</ChoiceGroups>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedChoiceKeys")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedChoiceKeys", reply);
                if (success) {
                    this.core.updateHostSyncStatus("ChoiceKeys");
                    continue;
                }
                this.core.input(this.core.getLiteral("Choice Keys Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncVendors() {
        POSDataContainer vendorsSync = null;
        StringBuilder vendorsXml = new StringBuilder();
        vendorsSync = this.core.getAllVendors();
        if (vendorsSync != null && vendorsSync.size() > 0) {
            int numMenuKeys = vendorsSync.size();
            for (int k = 0; k < numMenuKeys; ++k) {
                Vendor thisVendor = (Vendor)vendorsSync.get(k);
                vendorsXml.append(thisVendor.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncVendors</Request>");
        commandXml.append("<Vendors>" + vendorsXml + "</Vendor>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedVendors")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedVendors", reply);
                if (success) {
                    this.core.updateHostSyncStatus("Vendors");
                    continue;
                }
                this.core.input(this.core.getLiteral("Vendors Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncVatCodes() {
        POSDataContainer vatCodesSync = null;
        StringBuilder vatCodesXml = new StringBuilder();
        vatCodesSync = this.core.getVatRecords();
        if (vatCodesSync != null && vatCodesSync.size() > 0) {
            int numVatCodes = vatCodesSync.size();
            for (int k = 0; k < numVatCodes; ++k) {
                ValueAddedTax thisVatCode = (ValueAddedTax)vatCodesSync.get(k);
                vatCodesXml.append(thisVatCode.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncVatCodes</Request>");
        commandXml.append("<VatCodes>" + vatCodesXml + "</VatCodes>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedVatCodes")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedVatCodes", reply);
                if (success) {
                    this.core.updateHostSyncStatus("VatCode");
                    continue;
                }
                this.core.input(this.core.getLiteral("VatCodes Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncAdjustmentSessions() {
        POSDataContainer adjustmentSessionsSync = null;
        StringBuilder adjustmentSessionsXml = new StringBuilder();
        adjustmentSessionsSync = this.core.getAdjustmentSessions();
        if (adjustmentSessionsSync != null && adjustmentSessionsSync.size() > 0) {
            int numAdjustmentSessions = adjustmentSessionsSync.size();
            for (int k = 0; k < numAdjustmentSessions; ++k) {
                AdjustmentSession thisAdjustmentSession = (AdjustmentSession)adjustmentSessionsSync.get(k);
                adjustmentSessionsXml.append(thisAdjustmentSession.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncAdjustmentSessions</Request>");
        commandXml.append("<AdjustmentSessions>" + adjustmentSessionsXml + "</AdjustmentSessions>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedAdjustmentSessions")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedAdjustmentSessions", reply);
                if (success) {
                    this.core.updateHostSyncStatus("AdjustmentSessions");
                    this.core.updateHostSyncStatus("InventoryCounts");
                    continue;
                }
                this.core.input(this.core.getLiteral("Adjustment Sessions was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncReceivingSessions() {
        POSDataContainer receivingSessionsSync = null;
        StringBuilder receivingSessionsXml = new StringBuilder();
        receivingSessionsSync = this.core.getReceivingSessions();
        if (receivingSessionsSync != null && receivingSessionsSync.size() > 0) {
            int numReceivingSessions = receivingSessionsSync.size();
            for (int k = 0; k < numReceivingSessions; ++k) {
                ReceivingSession thisReceivingSession = (ReceivingSession)receivingSessionsSync.get(k);
                receivingSessionsXml.append(thisReceivingSession.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncReceivingSessions</Request>");
        commandXml.append("<ReceivingSessions>" + receivingSessionsXml + "</ReceivingSessions>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 1000;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedReceivingSessions")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedReceivingSessions", reply);
                if (success) {
                    this.core.updateHostSyncStatus("ReceivingSessions");
                    this.core.updateHostSyncStatus("ReceivingCounts");
                    continue;
                }
                this.core.input(this.core.getLiteral("Receiving Sessions was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncPriceChangeSessions() {
        POSDataContainer priceChangeSessionsSync = null;
        StringBuilder priceChangeSessionsXml = new StringBuilder();
        priceChangeSessionsSync = this.core.getPriceChangeSessions();
        if (priceChangeSessionsSync != null && priceChangeSessionsSync.size() > 0) {
            int numPriceChangeSessions = priceChangeSessionsSync.size();
            for (int k = 0; k < numPriceChangeSessions; ++k) {
                PriceChangeSession thisPriceChangeSession = (PriceChangeSession)priceChangeSessionsSync.get(k);
                priceChangeSessionsXml.append(thisPriceChangeSession.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncPriceChangeSessions</Request>");
        commandXml.append("<PriceChangeSessions>" + priceChangeSessionsXml + "</PriceChangeSessions>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedPriceChangeSessions")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedPriceChangeSessions", reply);
                if (success) {
                    this.core.updateHostSyncStatus("PriceChangeSessions");
                    this.core.updateHostSyncStatus("PriceChanges");
                    continue;
                }
                this.core.input(this.core.getLiteral("Price Change Sessions was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncAlternateTaxes() {
        POSDataContainer alternateTaxesSync = null;
        StringBuilder alternateTaxesXml = new StringBuilder();
        alternateTaxesSync = this.core.getAlternateTaxesList();
        if (alternateTaxesSync != null && alternateTaxesSync.size() > 0) {
            int numAlternateTaxeSessions = alternateTaxesSync.size();
            for (int k = 0; k < numAlternateTaxeSessions; ++k) {
                AlternateTax thisAlternateTax = (AlternateTax)alternateTaxesSync.get(k);
                alternateTaxesXml.append(thisAlternateTax.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncAlternateTaxes</Request>");
        commandXml.append("<AlternateTaxes>" + alternateTaxesXml + "</AlternateTaxes>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedAlternateTaxes")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedAlternateTaxes", reply);
                if (success) {
                    this.core.updateHostSyncStatus("ApAltTax");
                    continue;
                }
                this.core.input(this.core.getLiteral("Alternate Taxes was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncCompReasons() {
        POSDataContainer compReasonsSync = null;
        StringBuilder compReasonsXml = new StringBuilder();
        compReasonsSync = this.core.getCompReasons();
        if (compReasonsSync != null && compReasonsSync.size() > 0) {
            int numCompReasons = compReasonsSync.size();
            for (int k = 0; k < numCompReasons; ++k) {
                String thisCompReason = (String)compReasonsSync.get(k);
                compReasonsXml.append("<CompReason>" + thisCompReason + "</CompReason>");
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncCompReasons</Request>");
        commandXml.append("<CompReasons>" + compReasonsXml + "</CompReasons>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedCompReasons")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedCompReasons", reply);
                if (success) {
                    this.core.updateHostSyncStatus("CompReasons");
                    continue;
                }
                this.core.input(this.core.getLiteral("Comp Reasons was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncFoodStampTypes() {
        POSDataContainer foodStampTypesSync = null;
        StringBuilder foodStampTypesXml = new StringBuilder();
        foodStampTypesSync = this.core.getFoodStampTypes();
        if (foodStampTypesSync != null && foodStampTypesSync.size() > 0) {
            int numCompReasons = foodStampTypesSync.size();
            for (int k = 0; k < numCompReasons; ++k) {
                String thisFoodStampType = (String)foodStampTypesSync.get(k);
                foodStampTypesXml.append("<FoodStampType>" + thisFoodStampType + "</FoodStampType>");
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncFoodStampTypes</Request>");
        commandXml.append("<FoodStampTypes>" + foodStampTypesXml + "</FoodStampTypes>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedFoodStampTypes")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedFoodStampTypes", reply);
                if (success) {
                    this.core.updateHostSyncStatus("FoodStampTypes");
                    continue;
                }
                this.core.input(this.core.getLiteral("FoodStampTypes was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncItemCategories() {
        POSDataContainer itemCategoriesSync = null;
        StringBuilder itemCategoriesXml = new StringBuilder();
        itemCategoriesSync = this.core.getAllItemCategories();
        if (itemCategoriesSync != null && itemCategoriesSync.size() > 0) {
            int numCompReasons = itemCategoriesSync.size();
            for (int k = 0; k < numCompReasons; ++k) {
                ItemCategory itemCategory = (ItemCategory)itemCategoriesSync.get(k);
                itemCategoriesXml.append(itemCategory.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncItemCategories</Request>");
        commandXml.append("<ItemCategories>" + itemCategoriesXml + "</ItemCategories>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedItemCategories")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedItemCategories", reply);
                if (success) {
                    this.core.updateHostSyncStatus("ItemCategories");
                    continue;
                }
                this.core.input(this.core.getLiteral("ItemCategories was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncOperatorMessages() {
        POSDataContainer operatorMessagesSync = null;
        StringBuilder operatorMessagesXml = new StringBuilder();
        operatorMessagesSync = this.core.getAllOperatorMessages();
        if (operatorMessagesSync != null && operatorMessagesSync.size() > 0) {
            int numOperatorMessages = operatorMessagesSync.size();
            for (int k = 0; k < numOperatorMessages; ++k) {
                String messageType = (String)operatorMessagesSync.get(k);
                String operatorMessage = this.core.getOperatorMessage(messageType);
                operatorMessagesXml.append("<OperatorMessage><ItemType>" + messageType + "</ItemType><Message>" + operatorMessage + "</Message>" + "</OperatorMessage>");
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncOperatorMessages</Request>");
        commandXml.append("<OperatorMessages>" + operatorMessagesXml + "</OperatorMessages>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedOperatorMessages")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedOperatorMessages", reply);
                if (success) {
                    this.core.updateHostSyncStatus("OperatorMessages");
                    continue;
                }
                this.core.input(this.core.getLiteral("OperatorMessages was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncServerLocations() {
        POSDataContainer serverLocationsSync = null;
        StringBuilder serverLocationsXml = new StringBuilder();
        serverLocationsSync = this.core.getRegionalServers();
        if (serverLocationsSync != null && serverLocationsSync.size() > 0) {
            int numServerLocations = serverLocationsSync.size();
            for (int k = 0; k < numServerLocations; ++k) {
                ServerLocation thisServerLocation = (ServerLocation)serverLocationsSync.get(k);
                serverLocationsXml.append(thisServerLocation.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncServerLocations</Request>");
        commandXml.append("<ServerLocations>" + serverLocationsXml + "</ServerLocations>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedServerLocations")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedServerLocations", reply);
                if (success) {
                    this.core.updateHostSyncStatus("ServerLocations");
                    continue;
                }
                this.core.input(this.core.getLiteral("ServerLocations was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncBreaks() {
        if (!this.core.hasAccuShift()) {
            return;
        }
        ArrayList breaksSync = null;
        StringBuilder breaksXml = new StringBuilder();
        breaksSync = this.core.getBreaks();
        if (breaksSync != null && breaksSync.size() > 0) {
            int numServerLocations = breaksSync.size();
            for (int k = 0; k < numServerLocations; ++k) {
                BreakInfo thisBreak = (BreakInfo)breaksSync.get(k);
                breaksXml.append(thisBreak.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncBreaks</Request>");
        commandXml.append("BreakInfos>" + breaksXml + "</BreakInfos>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedBreaks")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedBreaks", reply);
                if (success) {
                    this.core.updateHostSyncStatus("Breaks");
                    continue;
                }
                this.core.input(this.core.getLiteral("Breaks was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncEConduitTerminals() {
        POSDataContainer eConduitTerminalsSync = null;
        StringBuilder eConduitTerminalsXml = new StringBuilder();
        eConduitTerminalsSync = this.core.getEConduitTerminals();
        if (eConduitTerminalsSync != null && eConduitTerminalsSync.size() > 0) {
            int numServerLocations = eConduitTerminalsSync.size();
            for (int i = 0; i < numServerLocations; ++i) {
                EConduitTerminal thisEConduitTerminal = (EConduitTerminal)eConduitTerminalsSync.get(i);
                eConduitTerminalsXml.append(thisEConduitTerminal.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncEConduitTerminals</Request>");
        commandXml.append("<EConduitTerminals>" + eConduitTerminalsXml + "</EConduitTerminals>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedEConduitTerminals")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedEConduitTerminals", reply);
                if (success) {
                    this.core.updateHostSyncStatus("EConduitTerminals");
                    continue;
                }
                this.core.input(this.core.getLiteral("EConduitTerminals was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncPriceLevelTimes() {
        POSDataContainer priceLevelTimesSync = null;
        StringBuilder priceLevelTimesXml = new StringBuilder();
        priceLevelTimesSync = this.core.getPriceLevelTimes();
        if (priceLevelTimesSync != null && priceLevelTimesSync.size() > 0) {
            int numPriceLevels = priceLevelTimesSync.size();
            for (int i = 0; i < numPriceLevels; ++i) {
                PriceLevelTime thisPriceLevelTime = (PriceLevelTime)priceLevelTimesSync.get(i);
                priceLevelTimesXml.append(thisPriceLevelTime.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncPriceLevelTimes</Request>");
        commandXml.append("<PriceLevelTimes>" + priceLevelTimesXml + "</PriceLevelTimes>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedPriceLevelTimes")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedPriceLevelTimes", reply);
                if (success) {
                    this.core.updateHostSyncStatus("PriceLevelTimes");
                    continue;
                }
                this.core.input(this.core.getLiteral("PriceLevelTimes was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncProductLines() {
        POSDataContainer productLinesSync = null;
        StringBuilder productLinesXml = new StringBuilder();
        productLinesSync = this.core.getProductLines();
        if (productLinesSync != null && productLinesSync.size() > 0) {
            int numServerLocations = productLinesSync.size();
            for (int i = 0; i < numServerLocations; ++i) {
                ProductLine thisProductLine = (ProductLine)productLinesSync.get(i);
                productLinesXml.append(thisProductLine.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncProductLines</Request>");
        commandXml.append("<ProductLines>" + productLinesXml + "</ProductLines>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedProductLines")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedProductLines", reply);
                if (success) {
                    this.core.updateHostSyncStatus("ProductLines");
                    continue;
                }
                this.core.input(this.core.getLiteral("ProductLines was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncRemoteDisplays() {
        POSDataContainer remoteDisplaysSync = null;
        StringBuilder remoteDisplaysXml = new StringBuilder();
        remoteDisplaysSync = this.core.getRemoteDisplays();
        if (remoteDisplaysSync != null && remoteDisplaysSync.size() > 0) {
            int numRemoteDisplays = remoteDisplaysSync.size();
            for (int i = 0; i < numRemoteDisplays; ++i) {
                DisplayPrinter thisRemoteDisplay = (DisplayPrinter)remoteDisplaysSync.get(i);
                remoteDisplaysXml.append(thisRemoteDisplay.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncRemoteDisplays</Request>");
        commandXml.append("<RemoteDisplays>" + remoteDisplaysXml + "</RemoteDisplays>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 1000;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedRemoteDisplays")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedRemoteDisplays", reply);
                if (success) {
                    this.core.updateHostSyncStatus("RemoteDisplays");
                    this.core.updateHostSyncStatus("RemoteDisplayItems");
                    continue;
                }
                this.core.input(this.core.getLiteral("RemoteDisplays was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncResets() {
        POSDataContainer resetsSync = null;
        StringBuilder resetsXml = new StringBuilder();
        resetsSync = this.core.getResets();
        if (resetsSync != null && resetsSync.size() > 0) {
            int numResets = resetsSync.size();
            for (int i = 0; i < numResets; ++i) {
                Reset thisReset = (Reset)resetsSync.get(i);
                resetsXml.append(thisReset.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncResets</Request>");
        commandXml.append("<Resets>" + resetsXml + "</Resets>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 1000;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedResets")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedResets", reply);
                if (success) {
                    this.core.updateHostSyncStatus("Resets");
                    continue;
                }
                this.core.input(this.core.getLiteral("Resets was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncTables() {
        POSDataContainer tablesSync = null;
        StringBuilder tablesXml = new StringBuilder();
        tablesSync = this.core.getAllTables();
        if (tablesSync != null && tablesSync.size() > 0) {
            int numTables = tablesSync.size();
            for (int i = 0; i < numTables; ++i) {
                Table thisTable = (Table)tablesSync.get(i);
                tablesXml.append(thisTable.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncTables</Request>");
        commandXml.append("<Tables>" + tablesXml + "</Tables>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedTables")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedTables", reply);
                if (success) {
                    this.core.updateHostSyncStatus("Tables");
                    continue;
                }
                this.core.input(this.core.getLiteral("Tables was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncTCControl() {
        if (!this.core.hasAccuShift()) {
            return;
        }
        String tcControlXml = this.core.getTCControlXml();
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncTCControl</Request>");
        commandXml.append(tcControlXml);
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 1000;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedTCControl")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedTCControl", reply);
                if (success) {
                    this.core.updateHostSyncStatus("TCControl");
                    continue;
                }
                this.core.input(this.core.getLiteral("TCControl was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncTerms() {
        POSDataContainer termsSync = null;
        StringBuilder termsXml = new StringBuilder();
        termsSync = this.core.getCustomerTerms();
        if (termsSync != null && termsSync.size() > 0) {
            int numTerms = termsSync.size();
            for (int i = 0; i < numTerms; ++i) {
                CustomerTerm thisTerm = (CustomerTerm)termsSync.get(i);
                termsXml.append(thisTerm.toXml());
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncTerms</Request>");
        commandXml.append("<CustomerTerms>" + termsXml + "</CustomerTerms>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedTerms")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedTerms", reply);
                if (success) {
                    this.core.updateHostSyncStatus("Terms");
                    continue;
                }
                this.core.input(this.core.getLiteral("Terms was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncDiscountReasons() {
        POSDataContainer discountReasonsSync = null;
        StringBuilder discountReasonsXml = new StringBuilder();
        discountReasonsSync = this.core.getDiscountReasons();
        if (discountReasonsSync != null && discountReasonsSync.size() > 0) {
            int numDiscountReasons = discountReasonsSync.size();
            for (int k = 0; k < numDiscountReasons; ++k) {
                String thisDiscountReason = (String)discountReasonsSync.get(k);
                discountReasonsXml.append("<DiscountReason>" + thisDiscountReason + "</DiscountReason>");
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncDiscountReasons</Request>");
        commandXml.append("<DiscountReasons>" + discountReasonsXml + "</DiscountReasons>");
        String commandString = commandXml.toString();
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedDiscountReasons")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedDiscountReasons", reply);
                if (success) {
                    this.core.updateHostSyncStatus("DiscountReasons");
                    continue;
                }
                this.core.input(this.core.getLiteral("DiscountReasons Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncQualifyingQtyTypes() {
        POSDataContainer qualifyingQtyTypesSync = null;
        StringBuilder qualifyingQtyTypesXml = new StringBuilder();
        qualifyingQtyTypesSync = this.core.getQualifyingQtyTypes();
        if (qualifyingQtyTypesSync != null && qualifyingQtyTypesSync.size() > 0) {
            int numQualifyingQtyTypes = qualifyingQtyTypesSync.size();
            for (int k = 0; k < numQualifyingQtyTypes; ++k) {
                String thisQualifyingQtyType = (String)qualifyingQtyTypesSync.get(k);
                qualifyingQtyTypesXml.append("<QualifyingQtyTypes>" + thisQualifyingQtyType + "</QualifyingQtyTypes>");
            }
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncQualifyingQtyTypes</Request>");
        commandXml.append("<QualifyingQtyTypes>" + qualifyingQtyTypesXml + "</QualifyingQtyTypes>");
        String commandString = commandXml.toString();
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedQualifyingQtyTypes")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedQualifyingQtyTypes", reply);
                if (success) {
                    this.core.updateHostSyncStatus("QualifyingQtyTypes");
                    continue;
                }
                this.core.input(this.core.getLiteral("QualifyingQtyTypes Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncPOSStations() {
        String posStationsSync = "";
        posStationsSync = this.core.getAllPOSStations();
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncPOSStations</Request>");
        commandXml.append("<POSStations>" + posStationsSync + "</POSStations>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedPOSStations")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedPOSStations", reply);
                if (success) {
                    this.core.updateHostSyncStatus("POSStations");
                    continue;
                }
                this.core.input(this.core.getLiteral("POSStations Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncCourseNames() {
        Hashtable courseNamesHashtable = null;
        String courseNamesSync = "";
        courseNamesHashtable = this.core.getCourseNamesHashtable();
        for (Map.Entry pair : courseNamesHashtable.entrySet()) {
            int courseNumber = (Integer)pair.getKey();
            String courseName = (String)pair.getValue();
            courseNamesSync = courseNamesSync + "<CourseName><Name>" + courseName + "</Name><CourseNumber>" + courseNumber + "</CourseNumber></CourseName>";
        }
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncCourseNames</Request>");
        commandXml.append("<CourseNames>" + courseNamesSync + "</CourseNames>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedCourseNames")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedCourseNames", reply);
                if (success) {
                    this.core.updateHostSyncStatus("CourseNames");
                    continue;
                }
                this.core.input(this.core.getLiteral("CourseNames Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncItemAttributes() {
        POSDataContainer itemAttributesSync = null;
        itemAttributesSync = this.core.getItemAttributes();
        StringBuilder commandXml = new StringBuilder();
        commandXml.append("<Request>SyncItemAttributes</Request>");
        commandXml.append("<ItemAttributes>" + itemAttributesSync + "</ItemAttributes>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedItemAttributes")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedItemAttributes", reply);
                if (success) {
                    this.core.updateHostSyncStatus("ItemAttributes");
                    continue;
                }
                this.core.input(this.core.getLiteral("ItemAttributes Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncCustomerDiscounts() {
        POSDataContainer customerDiscountsSync = null;
        StringBuilder customerDiscountsXml = new StringBuilder();
        customerDiscountsSync = this.core.getCustomerDiscounts();
        StringBuilder commandXml = new StringBuilder();
        customerDiscountsXml.append("<Request>SyncCustomerDiscounts</Request>");
        commandXml.append("<CustomerDiscounts>" + customerDiscountsSync + "</CustomerDiscounts>");
        this.core.sendToHost(commandXml.toString());
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("SyncedCustomerDiscounts")) != null && !reply.isEmpty()) {
                waiting = false;
                boolean success = Utility.getBooleanElement("SyncedCustomerDiscounts", reply);
                if (success) {
                    this.core.updateHostSyncStatus("CustomerDiscounts");
                    continue;
                }
                this.core.input(this.core.getLiteral("CustomerDiscounts Sync was Not Completed Successfully"));
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (waiting);
    }

    public void syncLogo() {
        File file = null;
        FileInputStream fis = null;
        byte[] bytes = null;
        String encodedfile = "";
        try {
            file = new File(System.getProperty("user.dir") + "/images/" + "logo.png");
            if (file != null && (file.length() == 15659L || file.length() == 34511L)) {
                return;
            }
            if (file.exists()) {
                fis = new FileInputStream(file);
            }
            if (fis != null) {
                int readNum;
                ByteArrayOutputStream bos = null;
                byte[] buf = new byte[4096];
                bos = new ByteArrayOutputStream();
                while ((readNum = fis.read(buf)) != -1) {
                    bos.write(buf, 0, readNum);
                }
                bytes = bos.toByteArray();
            }
            if (bytes != null && bytes.length > 0) {
                encodedfile = new String(Base64.encode(bytes).getBytes(), "UTF-8");
            }
        }
        catch (Exception ex) {
            this.core.raiseException(ex);
        }
        if (!encodedfile.isEmpty()) {
            StringBuilder commandXml = new StringBuilder();
            commandXml.append("<Request>SyncLogo</Request>");
            commandXml.append("<Logo>" + encodedfile + "</Logo>");
            this.core.sendToHost(commandXml.toString());
            boolean waiting = true;
            int timeout = 100;
            do {
                String reply;
                if ((reply = this.core.getHostReply("SyncedLogo")) != null && !reply.isEmpty()) {
                    waiting = false;
                    boolean success = Utility.getBooleanElement("SyncedLogo", reply);
                    if (success) {
                        this.core.updateHostSyncStatus("Logo");
                        continue;
                    }
                    this.core.input(this.core.getLiteral("Logo Sync was Not Completed Successfully"));
                    continue;
                }
                if (--timeout <= 0) {
                    waiting = false;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (waiting);
        }
    }

    public POSDataContainer getAllLocations() throws Exception {
        POSDataContainer locations = null;
        boolean good = false;
        String request = "<Request>GetLocations</Request>\r\n";
        this.core.sendToHost(request);
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("AllLocations")) != null && !reply.isEmpty()) {
                locations = new POSDataContainer();
                Vector locationList = Utility.getElementList("Location", reply);
                locations.addAll((Collection)locationList);
                waiting = false;
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            Thread.sleep(1000L);
        } while (waiting);
        return locations;
    }

    public POSDataContainer getCloudTransactionData(String selectedLocations, TransactionReportOptions reportOptions) throws Exception {
        POSDataContainer result = new POSDataContainer();
        String request = "<Request>GetTransactions</Request><Locations>" + selectedLocations + "</Locations>" + reportOptions.toXml() + "\r\n";
        this.core.sendToHost(request);
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("Transactions")) != null && !reply.isEmpty()) {
                waiting = false;
                Vector transactions = Utility.getElementList("Order", reply);
                int len = transactions.size();
                for (int i = 0; i < len; ++i) {
                    String thisTransactionXML = (String)transactions.get(i);
                    Order thisTransaction = new Order(thisTransactionXML, true);
                    int linesLen = thisTransaction.lineItems.size();
                    for (int l = 0; l < linesLen; ++l) {
                        LineItem lineItem = (LineItem)thisTransaction.lineItems.get(l);
                        Item itemDetail = this.core.getItemByCode(lineItem.itemId);
                        if (itemDetail != null) {
                            lineItem.itemDescription = itemDetail.description;
                            lineItem.itemName = itemDetail.name;
                            lineItem.itemCategory = itemDetail.itemCategory;
                            continue;
                        }
                        lineItem.itemDescription = "Not Found";
                        lineItem.itemName = "_";
                        lineItem.itemId = "";
                    }
                    result.add((Object)thisTransaction);
                }
            } else {
                if (--timeout <= 0) {
                    waiting = false;
                    continue;
                }
                Thread.sleep(1000L);
            }
        } while (waiting);
        return result;
    }

    public POSDataContainer getCloudItemTypeSummaryData(String selectedLocations, TransactionReportOptions reportOptions) throws Exception {
        POSDataContainer result = new POSDataContainer();
        String request = "<Request>GetItemTypeSummary</Request><Locations>" + selectedLocations + "</Locations>" + reportOptions.toXml() + "\r\n";
        this.core.sendToHost(request);
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("ItemTypeSummary")) != null && !reply.isEmpty()) {
                waiting = false;
                Vector summaryList = Utility.getElementList("ItemTypeSummary", reply);
                int len = summaryList.size();
                for (int i = 0; i < len; ++i) {
                    String thisSummaryXML = (String)summaryList.get(i);
                    ItemTypeSummary thisSummary = new ItemTypeSummary(thisSummaryXML);
                    result.add((Object)thisSummary);
                }
            } else {
                if (--timeout <= 0) {
                    waiting = false;
                    continue;
                }
                Thread.sleep(1000L);
            }
        } while (waiting);
        return result;
    }

    public POSDataContainer getCloudItemTypes(String selectedLocations) throws Exception {
        POSDataContainer result = new POSDataContainer();
        String request = "<Request>GetItemTypes</Request><Locations>" + selectedLocations + "</Locations>\r\n";
        this.core.sendToHost(request);
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("ItemTypes")) != null && !reply.isEmpty()) {
                waiting = false;
                Vector itemTypesXml = Utility.getElementList("ItemType", reply);
                int len = itemTypesXml.size();
                for (int i = 0; i < len; ++i) {
                    String thisItemTypeXml = (String)itemTypesXml.get(i);
                    ItemType thisItemType = new ItemType(thisItemTypeXml);
                    result.add((Object)thisItemType);
                }
            } else {
                if (--timeout <= 0) {
                    waiting = false;
                    continue;
                }
                Thread.sleep(1000L);
            }
        } while (waiting);
        return result;
    }

    public POSDataContainer getCloudItemCategories(String selectedLocations) throws Exception {
        POSDataContainer result = new POSDataContainer();
        String request = "<Request>GetItemCategories</Request><Locations>" + selectedLocations + "</Locations>\r\n";
        this.core.sendToHost(request);
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("ItemCategories")) != null && !reply.isEmpty()) {
                waiting = false;
                Vector categories = Utility.getElementList("Category", reply);
                int len = categories.size();
                for (int i = 0; i < len; ++i) {
                    String thisCategoryXml = (String)categories.get(i);
                    String thisCategory = Utility.getElement("Category", thisCategoryXml);
                    result.add((Object)thisCategory);
                }
            } else {
                if (--timeout <= 0) {
                    waiting = false;
                    continue;
                }
                Thread.sleep(1000L);
            }
        } while (waiting);
        return result;
    }

    public POSDataContainer getCloudSalesByItem(String selectedLocations, TransactionReportOptions reportOptions) throws Exception {
        return null;
    }

    public POSDataContainer getCloudSalesByHour(String selectedLocations, TransactionReportOptions reportOptions) throws Exception {
        return null;
    }

    public POSDataContainer getCloudTenderSummaryData(String selectedLocations, TransactionReportOptions reportOptions) throws Exception {
        Hashtable tenderTypes = this.core.getTenderTypesTable();
        Hashtable tenderDescriptions = this.core.getTenderDescriptionsTable();
        POSDataContainer tenders = new POSDataContainer();
        String request = "<Request>GetTenderSummary</Request><Locations>" + selectedLocations + "</Locations>" + reportOptions.toXml() + "\r\n";
        this.core.sendToHost(request);
        boolean waiting = true;
        int timeout = 100;
        do {
            String reply;
            if ((reply = this.core.getHostReply("TenderSummary")) != null && !reply.isEmpty()) {
                waiting = false;
                Vector tenderings = Utility.getElementList("Tender", reply);
                int len = tenderings.size();
                for (int i = 0; i < len; ++i) {
                    String thisTenderXML = (String)tenderings.get(i);
                    Tender thisTender = new Tender(thisTenderXML);
                    String type = (String)tenderTypes.get(thisTender.code);
                    thisTender.type = type == null ? "Not Found" : type;
                    String description = thisTender.description;
                    thisTender.description = description == null ? ((description = (String)tenderDescriptions.get(thisTender.code)) == null ? "Not Found" : description) : description;
                    tenders.add((Object)thisTender);
                }
            } else {
                if (--timeout <= 0) {
                    waiting = false;
                    continue;
                }
                Thread.sleep(1000L);
            }
        } while (waiting);
        return tenders;
    }

    class SyncThread
    extends Thread {
        int threadSleep = 5000;
        Hashtable syncControlData = null;

        public SyncThread(int sleep) {
            if (sleep > 0) {
                this.threadSleep = sleep;
            }
        }

        public void run() {
            if (HostDataAccess.this.isSyncing) {
                return;
            }
            HostDataAccess.this.core.input("Sync Started " + new Date().toString());
            try {
                HostDataAccess.this.syncOrders();
                HostDataAccess.this.isSyncing = false;
                this.syncControlData = HostDataAccess.this.core.getHostSyncControlData();
                if (this.syncControlData == null || this.syncControlData.isEmpty()) {
                    return;
                }
                HostDataAccess.this.syncCompanyInfo();
                if (this.syncTable("apinms") || this.syncTable("FlexGroups") || this.syncTable("FlexGroupDetail") || this.syncTable("UnitOfMeasure") || this.syncTable("FollowOnItems") || this.syncTable("NoPartialQuantityItems") || this.syncTable("ItemGroups") || this.syncTable("SalePrice")) {
                    HostDataAccess.this.syncCloudItems();
                }
                if (this.syncTable("Customers")) {
                    HostDataAccess.this.syncCustomers();
                }
                if (HostDataAccess.this.core.hasAccuShift() && this.syncTable("Employees")) {
                    Timestamp employeesLastChanged = this.getLastChanged("Employees");
                    HostDataAccess.this.syncEmployees(employeesLastChanged);
                }
                if (this.syncTable("apusrgrp")) {
                    HostDataAccess.this.syncUserGroups();
                }
                if (this.syncTable("apuser")) {
                    HostDataAccess.this.syncUsers();
                }
                if (this.syncTable("aptxcode")) {
                    HostDataAccess.this.syncTaxCodes();
                }
                if (this.syncTable("aptxauth")) {
                    HostDataAccess.this.syncTaxAuthorities();
                }
                if (this.syncTable("aptndcd")) {
                    HostDataAccess.this.syncTenderCodes();
                }
                if (this.syncTable("aptill")) {
                    HostDataAccess.this.syncTills();
                }
                if (this.syncTable("apcskeys")) {
                    HostDataAccess.this.syncMenuKeys();
                }
                if (this.syncTable("ChoiceKeys")) {
                    HostDataAccess.this.syncChoiceKeys();
                }
                if (this.syncTable("Vendors")) {
                    HostDataAccess.this.syncVendors();
                }
                if (this.syncTable("VatCode")) {
                    HostDataAccess.this.syncVatCodes();
                }
                if (this.syncTable("AdjustmentSessions")) {
                    HostDataAccess.this.syncAdjustmentSessions();
                }
                if (this.syncTable("ReceivingSessions")) {
                    HostDataAccess.this.syncReceivingSessions();
                }
                if (this.syncTable("PriceChangeSessions")) {
                    HostDataAccess.this.syncPriceChangeSessions();
                }
                if (this.syncTable("ApAltTax")) {
                    HostDataAccess.this.syncAlternateTaxes();
                }
                if (this.syncTable("CompReasons")) {
                    HostDataAccess.this.syncCompReasons();
                }
                if (this.syncTable("FoodStampTypes")) {
                    HostDataAccess.this.syncFoodStampTypes();
                }
                if (this.syncTable("ItemCategories")) {
                    HostDataAccess.this.syncItemCategories();
                }
                if (this.syncTable("OperatorMessages")) {
                    HostDataAccess.this.syncOperatorMessages();
                }
                if (this.syncTable("ServerLocations")) {
                    HostDataAccess.this.syncServerLocations();
                }
                if (HostDataAccess.this.core.hasAccuShift() && this.syncTable("Breaks")) {
                    HostDataAccess.this.syncBreaks();
                }
                if (this.syncTable("EConduitTerminals")) {
                    HostDataAccess.this.syncEConduitTerminals();
                }
                if (this.syncTable("ProductLines")) {
                    HostDataAccess.this.syncProductLines();
                }
                if (this.syncTable("PriceLevelTimes")) {
                    HostDataAccess.this.syncPriceLevelTimes();
                }
                if (this.syncTable("RemoteDisplays")) {
                    HostDataAccess.this.syncRemoteDisplays();
                }
                if (this.syncTable("Resets")) {
                    HostDataAccess.this.syncResets();
                }
                if (this.syncTable("Tables")) {
                    HostDataAccess.this.syncTables();
                }
                if (this.syncTable("Terms")) {
                    HostDataAccess.this.syncTerms();
                }
                if (HostDataAccess.this.core.hasAccuShift() && this.syncTable("TCcontrol")) {
                    HostDataAccess.this.syncTCControl();
                }
                if (this.syncTable("DiscountReasons")) {
                    HostDataAccess.this.syncDiscountReasons();
                }
                if (this.syncTable("QualifyingQtyTypes")) {
                    HostDataAccess.this.syncQualifyingQtyTypes();
                }
                if (this.syncTable("POSStations")) {
                    HostDataAccess.this.syncPOSStations();
                }
                if (this.syncTable("CourseNames")) {
                    HostDataAccess.this.syncCourseNames();
                }
                if (this.syncTable("ItemAttributes")) {
                    HostDataAccess.this.syncItemAttributes();
                }
                if (this.syncTable("Logo")) {
                    HostDataAccess.this.syncLogo();
                }
                HostDataAccess.this.core.input("Sync Completed " + new Date().toString());
            }
            catch (Exception e) {
                HostDataAccess.this.isSyncing = false;
                HostDataAccess.this.core.raiseException(e);
            }
        }

        private boolean syncTable(String tableName) {
            if (this.syncControlData == null) {
                System.out.println("Sync Control is Null");
                return false;
            }
            HostDataAccess.this.core.input(new Date().toString() + " " + "Checking Sync Control Status for Table: " + tableName);
            System.out.println("Checking Sync Control Table Name: " + tableName);
            Vector tableData = (Vector)this.syncControlData.get(tableName);
            boolean tableChanged = (Boolean)tableData.get(0);
            Timestamp tableLastChanged = (Timestamp)tableData.get(1);
            if (tableLastChanged == null) {
                tableChanged = true;
            }
            if (!tableChanged) {
                HostDataAccess.this.core.input(new Date().toString() + " " + "Sync Control Status for Table: " + tableName + " Sync not Required");
            } else {
                HostDataAccess.this.core.input(new Date().toString() + " " + "Sync Control Status for Table: " + tableName + " Sync is Required");
                HostDataAccess.this.core.updateHostSyncStatus(tableName, tableChanged, true);
            }
            return tableChanged;
        }

        private Timestamp getLastChanged(String tableName) {
            if (this.syncControlData == null) {
                System.out.println("Sync Control is Null");
                return null;
            }
            System.out.println("Checking Sync Control Table Name: " + tableName);
            Vector tableData = (Vector)this.syncControlData.get(tableName);
            Timestamp tableLastChanged = (Timestamp)tableData.get(1);
            return tableLastChanged;
        }
    }
}

