/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftDataAccess;

import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import AccuShiftBase.AccuShiftData;
import AccuShiftDataObjects.BreakInfo;
import AccuShiftDataObjects.CompanyInfo;
import AccuShiftDataObjects.Employee;
import AccuShiftDataObjects.Holiday;
import AccuShiftDataObjects.PayPeriodInfo;
import AccuShiftDataObjects.TimeDetail;
import POSDataObjects.POSDataContainer;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class AccuShiftDataAccessNG
implements AccuShiftData,
ServerObject,
Runnable {
    private String path;
    ServerCore core = null;
    private String command = "";
    static int c;
    String dbDriver;
    String host = "localhost";
    String user = "";
    String password = "";
    String databaseName = "AccuPOS";
    Connection oneConnection = null;
    boolean isResetting = false;
    boolean blockConnection = false;

    @Override
    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public void run() {
        String employeeId;
        String employeeXml;
        String action = Utility.getElement("Action", this.command);
        if (action.compareToIgnoreCase("GetEmployeeInfo") == 0) {
            try {
                employeeXml = Utility.getElement("Employee", this.command);
                employeeId = Utility.getElement("EmployeeId", employeeXml);
                this.getEmployeeInfo(employeeId);
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        }
        if (action.compareToIgnoreCase("EmployeeClockIn") == 0) {
            try {
                employeeXml = Utility.getElement("Employee", this.command);
                employeeId = Utility.getElement("EmployeeId", employeeXml);
                String payLevelNumber = Utility.getElement("PayLevelNumber", employeeXml);
                int breakId = Utility.getIntElement("BreakId", employeeXml);
                this.setEmployeeClockIn(employeeId, Integer.parseInt(payLevelNumber), breakId);
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        }
        if (action.compareToIgnoreCase("EmployeeClockOut") == 0) {
            try {
                employeeXml = Utility.getElement("Employee", this.command);
                employeeId = Utility.getElement("EmployeeId", employeeXml);
                this.setEmployeeClockOut(employeeId);
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        }
        this.command = "";
    }

    @Override
    public void shutDown() {
        if (this.oneConnection != null) {
            try {
                this.blockConnection = true;
                this.oneConnection.close();
                this.oneConnection = null;
            }
            catch (SQLException ex) {
                this.core.raiseException(ex);
            }
        }
    }

    public Connection getOneConnection() throws Exception {
        Connection thisConnection = null;
        if (this.dbDriver.equalsIgnoreCase("jadoZoom")) {
            Class.forName("com.inzoom.jdbcado.Driver");
            String url = "jdbc:izmado:Provider=MSDASQL;Driver={Microsoft Access Driver (*.mdb)};IzmRoyaltyFree=643120950;Dbq=" + this.path;
            thisConnection = DriverManager.getConnection(url);
        } else if (this.dbDriver.equalsIgnoreCase("sqlexpress")) {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            String url = "jdbc:sqlserver://" + this.host + ";databaseName=" + this.databaseName;
            thisConnection = DriverManager.getConnection(url, this.user, this.password);
        } else {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + this.path;
            thisConnection = DriverManager.getConnection(url);
        }
        return thisConnection;
    }

    public Connection getDatabaseConnection() throws Exception {
        if (this.blockConnection) {
            return null;
        }
        if (this.isResetting) {
            for (int trys = 10; this.isResetting && trys > 0; --trys) {
                Thread.sleep(500L);
            }
        }
        this.isResetting = false;
        int mainTrys = 3;
        do {
            if (this.oneConnection == null) {
                this.oneConnection = this.getOneConnection();
                continue;
            }
            if (this.databaseConnectionIsValid(this.oneConnection)) continue;
            this.isResetting = true;
            try {
                this.oneConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Thread.sleep(500L);
            this.oneConnection = null;
            this.oneConnection = this.getOneConnection();
            this.isResetting = false;
        } while (this.oneConnection == null && --mainTrys > 0);
        return this.oneConnection;
    }

    public boolean databaseConnectionIsValid(Connection connection) {
        boolean result = true;
        if (connection == null) {
            return false;
        }
        try {
            if (connection.isClosed()) {
                return false;
            }
            Statement thisStatement = connection.createStatement();
            thisStatement.close();
            result = true;
        }
        catch (SQLException ex) {
            result = false;
        }
        return result;
    }

    @Override
    public void initialize(ServerCore core, Hashtable parameters) {
        this.core = core;
        if (parameters != null && parameters.size() > 0) {
            String dbName;
            this.path = (String)parameters.get("path");
            core.input("AccuShift DB: " + this.path);
            this.dbDriver = (String)parameters.get("dbDriver");
            if (this.dbDriver == null || this.dbDriver.isEmpty()) {
                this.dbDriver = "Standard";
            }
            this.host = (String)parameters.get("Host");
            if (this.host == null || this.host.isEmpty()) {
                this.host = "localhost";
            }
            String userText = (String)parameters.get("User");
            String passwordText = (String)parameters.get("Password");
            if (userText != null && !userText.isEmpty()) {
                this.user = userText;
            }
            if (passwordText != null && !passwordText.isEmpty()) {
                this.password = passwordText;
            }
            if ((dbName = (String)parameters.get("DatabaseName")) != null && !dbName.isEmpty()) {
                this.databaseName = dbName;
            }
            if (this.checkDatabase()) {
                this.path = core.getDatabasePath();
                core.setLocalDataHandler(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean checkDatabase() {
        isSqlExpress = this.dbDriver.equalsIgnoreCase("sqlexpress");
        updated = false;
        converting = false;
        con = null;
        versionStmt = null;
        insertStmt = null;
        stmt = null;
        rs = null;
        posConnection = null;
        insertStatement = null;
        updateStatement = null;
        selectStmt = null;
        resultSet = null;
        if (!isSqlExpress && !(db = new File(this.path)).exists()) {
            this.core.input("Could not find database at " + this.path);
        }
        try {
            con = this.getOneConnection();
            if (con == null) {
                this.core.input("Could not connect to the database at " + this.path);
                db = false;
                return db;
            }
            try {
                stmt = con.createStatement();
                versionStmt = con.createStatement();
                rs = versionStmt.executeQuery("Select * from TCcontrol");
                ** GOTO lbl74
            }
            catch (SQLException ex) {
                posPath = this.core.getDatabasePath();
                posDriverName = this.core.getDatabaseDriverName();
                this.core.input("TCcontrol table does not exist, checking POS database");
                posConnection = this.core.getDatabaseConnection();
                if (posConnection == null) {
                    this.core.input("Connection to POS database failed, new tables cannot be created");
                    if (rs != null) {
                        rs.close();
                    }
                    if (versionStmt != null) {
                        versionStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    var17_25 = false;
                    try {
                        if (insertStmt != null) {
                            insertStmt.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        if (insertStatement != null) {
                            insertStatement.close();
                        }
                        if (updateStatement != null) {
                            updateStatement.close();
                        }
                        if (con != null) {
                            con.close();
                        }
                        if (this.oneConnection != null) {
                            this.oneConnection.close();
                        }
                        this.oneConnection = null;
                    }
                    catch (Exception ex) {
                        this.core.raiseException(ex);
                    }
                    return var17_25;
                }
                try {
                    block71: {
                        block70: {
                            try {
                                stmt = posConnection.createStatement();
                                versionStmt = posConnection.createStatement();
                                rs = versionStmt.executeQuery("Select * from TCcontrol");
                            }
                            catch (SQLException e) {
                                if (posDriverName.compareToIgnoreCase("sqlexpress") == 0) {
                                    this.core.input("Converting database " + this.core.getDatabaseName() + " for AccuShift");
                                    break block70;
                                }
                                this.core.input("Converting database at " + posPath + " for AccuShift");
                            }
                        }
                        version = "0.0";
                        if (rs != null && rs.next()) {
                            version = rs.getString("databaseVersion");
                            rs.close();
                            versionStmt.close();
                        }
                        if (version.compareToIgnoreCase("1.0") < 0) {
                            command = "";
                            command = isSqlExpress != false ? "CREATE TABLE employees (id NVARCHAR(50), accountingId NVARCHAR(50), name NVARCHAR(255), payLevel1 BIT, payLevel2 BIT, payLevel3 BIT, payLevel4 BIT, payLevel5 BIT, payLevel6 BIT, payLevel7 BIT, payLevel8 BIT, payLevel9 BIT, payLevel10 BIT, payLevel11 BIT, payLevel12 BIT, payLevel13 BIT, payLevel14 BIT, payLevel15 BIT, payLevel16 BIT, payLevel17 BIT, payLevel18 BIT, payLevel19 BIT, payLevel20 BIT, manager BIT)" : "CREATE TABLE employees (id text(50), accountingId text(50), name text(255), payLevel1 YESNO, payLevel2 YESNO, payLevel3 YESNO, payLevel4 YESNO, payLevel5 YESNO, payLevel6 YESNO, payLevel7 YESNO, payLevel8 YESNO, payLevel9 YESNO, payLevel10 YESNO, payLevel11 YESNO, payLevel12 YESNO, payLevel13 YESNO, payLevel14 YESNO, payLevel15 YESNO, payLevel16 YESNO, payLevel17 YESNO, payLevel18 YESNO, payLevel19 YESNO, payLevel20 YESNO, manager YESNO)";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "CREATE UNIQUE INDEX idIndex on employees (id)" : "CREATE INDEX idIndex on employees (id) with primary";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "CREATE TABLE times (id int IDENTITY, employeeId NVARCHAR(45), payLevel int, [in] DATETIME, [out] DATETIME, total bigint)" : "CREATE TABLE times (id counter, employeeId text(45), payLevel int, in date, out date, total long)";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "CREATE UNIQUE INDEX idIndex on times (id)" : "CREATE INDEX idIndex on times (id) with primary";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "CREATE TABLE TCcontrol (companyCode NVARCHAR(255), databaseVersion NVARCHAR(15), siteName NVARCHAR(50), payLevel1 NVARCHAR(50), payLevel2 NVARCHAR(50), payLevel3 NVARCHAR(50), payLevel4 NVARCHAR(50), payLevel5 NVARCHAR(50), payLevel6 NVARCHAR(50), payLevel7 NVARCHAR(50), payLevel8 NVARCHAR(50), payLevel9 NVARCHAR(50), payLevel10 NVARCHAR(50), payLevel11 NVARCHAR(50), payLevel12 NVARCHAR(50), payLevel13 NVARCHAR(50), payLevel14 NVARCHAR(50), payLevel15 NVARCHAR(50), payLevel16 NVARCHAR(50), payLevel17 NVARCHAR(50), payLevel18 NVARCHAR(50), payLevel19 NVARCHAR(50), payLevel20 NVARCHAR(50))" : "CREATE TABLE TCcontrol (companyCode text(255), databaseVersion text(15), siteName text(50), payLevel1 text(50), payLevel2 text(50), payLevel3 text(50), payLevel4 text(50), payLevel5 text(50), payLevel6 text(50), payLevel7 text(50), payLevel8 text(50), payLevel9 text(50), payLevel10 text(50), payLevel11 text(50), payLevel12 text(50), payLevel13 text(50), payLevel14 text(50), payLevel15 text(50), payLevel16 text(50), payLevel17 text(50), payLevel18 text(50), payLevel19 text(50), payLevel20 text(50))";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "CREATE UNIQUE INDEX idIndex on TCcontrol (companyCode)" : "CREATE INDEX idIndex on TCcontrol (companyCode) with primary";
                            stmt.executeUpdate(command);
                            insertStmt = posConnection.createStatement();
                            command = "INSERT INTO TCcontrol (companyCode, databaseVersion) values ('', '1.1')";
                            insertStmt.executeUpdate(command);
                            updated = true;
                            converting = true;
                            version = "1.1";
                        }
                        if (version.compareToIgnoreCase("1.1") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "Alter TABLE TCcontrol ADD periodEnd DATETIME, periodDuration bigint " : "Alter TABLE TCcontrol ADD COLUMN periodEnd date, periodDuration long ";
                            stmt.executeUpdate(command);
                            command = "Update TCcontrol set databaseVersion = '1.2', periodEnd = '01/01/2015 12:00:00 PM', periodDuration = 14";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "1.2";
                        }
                        if (version.compareToIgnoreCase("1.2") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "Alter TABLE times add [sent] DATETIME " : "Alter TABLE times add column sent date ";
                            stmt.executeUpdate(command);
                            command = "Update TCcontrol set databaseVersion = '1.3'";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "1.3";
                        }
                        if (version.compareToIgnoreCase("1.3") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "Alter TABLE times add canceled BIT " : "Alter TABLE times add column canceled YESNO ";
                            stmt.executeUpdate(command);
                            command = "Update TCcontrol set databaseVersion = '1.4'";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "1.4";
                        }
                        if (version.compareToIgnoreCase("1.4") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "Alter TABLE TCcontrol add access NVARCHAR(50) " : "Alter TABLE TCcontrol add column access text(50) ";
                            stmt.executeUpdate(command);
                            command = "Update TCcontrol set databaseVersion = '1.5'";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "1.5";
                        }
                        if (version.compareToIgnoreCase("1.5") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "Alter TABLE TCcontrol add serialNumber NVARCHAR(50), companyName NVARCHAR(50), companyAddress1 NVARCHAR(50), companyAddress2 NVARCHAR(50), companyCity NVARCHAR(50),  companyState NVARCHAR(50),  companyZip NVARCHAR(50),  companyPhone NVARCHAR(50),  companyEmail NVARCHAR(50), registration NVARCHAR(50) " : "Alter TABLE TCcontrol add column serialNumber text(50), companyName text(50), companyAddress1 text(50), companyAddress2 text(50), companyCity text(50),  companyState text(50),  companyZip text(50),  companyPhone text(50),  companyEmail text(50), registration text(50) ";
                            stmt.executeUpdate(command);
                            command = "Update TCcontrol set databaseVersion = '1.6'";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "1.6";
                        }
                        if (version.compareToIgnoreCase("1.6") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "Alter TABLE employees add employeeClass NVARCHAR(50) " : "Alter TABLE employees add column employeeClass text(50) ";
                            stmt.executeUpdate(command);
                            command = "Update TCcontrol set databaseVersion = '1.7'";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "1.7";
                        }
                        if (version.compareToIgnoreCase("1.7") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "Alter TABLE TCcontrol add weekStartDay NVARCHAR(20), weekEndDay NVARCHAR(20)" : "Alter TABLE TCcontrol add column weekStartDay text(20), weekEndDay text(20)";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "Alter TABLE employees add overtimeOver8 BIT" : "Alter TABLE employees add column overtimeOver8 YESNO";
                            stmt.executeUpdate(command);
                            try {
                                selectStmt = con.createStatement();
                                insertStatement = posConnection.prepareStatement("INSERT INTO times (\"EmployeeId\",\"PayLevel\",\"In\",\"Out\",\"Total\",\"Sent\",\"Canceled\") Values (?,?,?,?,?,?,?)");
                                resultSet = selectStmt.executeQuery("Select * from times");
                                while (resultSet.next()) {
                                    insertStatement.setString(1, resultSet.getString("EmployeeId"));
                                    insertStatement.setInt(2, resultSet.getInt("PayLevel"));
                                    insertStatement.setTimestamp(3, resultSet.getTimestamp("in"));
                                    insertStatement.setTimestamp(4, resultSet.getTimestamp("out"));
                                    insertStatement.setInt(5, resultSet.getInt("Total"));
                                    insertStatement.setTimestamp(6, resultSet.getTimestamp("Sent"));
                                    insertStatement.setBoolean(7, resultSet.getBoolean("Canceled"));
                                    insertStatement.executeUpdate();
                                }
                                insertStatement = posConnection.prepareStatement("INSERT INTO employees (\"Id\",\"AccountingId\",\"Name\",\"PayLevel1\",\"PayLevel2\",\"PayLevel3\",\"PayLevel4\",\"PayLevel5\",\"PayLevel6\",\"PayLevel7\",\"PayLevel8\",\"PayLevel9\",\"PayLevel10\",\"PayLevel11\",\"PayLevel12\",\"PayLevel13\",\"PayLevel14\",\"PayLevel15\",\"PayLevel16\",\"PayLevel17\",\"PayLevel18\",\"PayLevel19\",\"PayLevel20\",\"Manager\",\"EmployeeClass\") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                resultSet = selectStmt.executeQuery("Select * from employees");
                                while (resultSet.next()) {
                                    insertStatement.setString(1, resultSet.getString("Id"));
                                    insertStatement.setString(2, resultSet.getString("AccountingId"));
                                    insertStatement.setString(3, resultSet.getString("Name"));
                                    insertStatement.setBoolean(4, resultSet.getBoolean("PayLevel1"));
                                    insertStatement.setBoolean(5, resultSet.getBoolean("PayLevel2"));
                                    insertStatement.setBoolean(6, resultSet.getBoolean("PayLevel3"));
                                    insertStatement.setBoolean(7, resultSet.getBoolean("PayLevel4"));
                                    insertStatement.setBoolean(8, resultSet.getBoolean("PayLevel5"));
                                    insertStatement.setBoolean(9, resultSet.getBoolean("PayLevel6"));
                                    insertStatement.setBoolean(10, resultSet.getBoolean("PayLevel7"));
                                    insertStatement.setBoolean(11, resultSet.getBoolean("PayLevel8"));
                                    insertStatement.setBoolean(12, resultSet.getBoolean("PayLevel9"));
                                    insertStatement.setBoolean(13, resultSet.getBoolean("PayLevel10"));
                                    insertStatement.setBoolean(14, resultSet.getBoolean("PayLevel11"));
                                    insertStatement.setBoolean(15, resultSet.getBoolean("PayLevel12"));
                                    insertStatement.setBoolean(16, resultSet.getBoolean("PayLevel13"));
                                    insertStatement.setBoolean(17, resultSet.getBoolean("PayLevel14"));
                                    insertStatement.setBoolean(18, resultSet.getBoolean("PayLevel15"));
                                    insertStatement.setBoolean(19, resultSet.getBoolean("PayLevel16"));
                                    insertStatement.setBoolean(20, resultSet.getBoolean("PayLevel17"));
                                    insertStatement.setBoolean(21, resultSet.getBoolean("PayLevel18"));
                                    insertStatement.setBoolean(22, resultSet.getBoolean("PayLevel19"));
                                    insertStatement.setBoolean(23, resultSet.getBoolean("PayLevel20"));
                                    insertStatement.setBoolean(24, resultSet.getBoolean("Manager"));
                                    insertStatement.setString(25, resultSet.getString("EmployeeClass"));
                                    insertStatement.executeUpdate();
                                }
                                updateStatement = posConnection.prepareStatement("Update TCcontrol set companyCode = ?, siteName = ?, paylevel1 = ?, paylevel2 = ?, paylevel3 = ?, paylevel4 = ?, paylevel5 = ?, paylevel6 = ?, paylevel7 = ?, paylevel8 = ?, paylevel9 = ?, paylevel10 = ?, paylevel11 = ?, paylevel12 = ?, paylevel13 = ?, paylevel14 = ?, paylevel15 = ?, paylevel16 = ?, paylevel17 = ?, paylevel18 = ?, paylevel19 = ?, paylevel20 = ?, periodEnd = ?, periodDuration = ?, access = ?, serialNumber = ?, companyName = ?, companyAddress1 = ?, companyAddress2 = ?, companyCity = ?, companyState = ?, companyZip = ?, companyPhone = ?, companyEmail = ?, registration = ?");
                                resultSet = selectStmt.executeQuery("Select * from control");
                                if (resultSet.next()) {
                                    updateStatement.setString(1, resultSet.getString("companyCode"));
                                    updateStatement.setString(2, resultSet.getString("siteName"));
                                    updateStatement.setString(3, resultSet.getString("PayLevel1"));
                                    updateStatement.setString(4, resultSet.getString("PayLevel2"));
                                    updateStatement.setString(5, resultSet.getString("PayLevel3"));
                                    updateStatement.setString(6, resultSet.getString("PayLevel4"));
                                    updateStatement.setString(7, resultSet.getString("PayLevel5"));
                                    updateStatement.setString(8, resultSet.getString("PayLevel6"));
                                    updateStatement.setString(9, resultSet.getString("PayLevel7"));
                                    updateStatement.setString(10, resultSet.getString("PayLevel8"));
                                    updateStatement.setString(11, resultSet.getString("PayLevel9"));
                                    updateStatement.setString(12, resultSet.getString("PayLevel10"));
                                    updateStatement.setString(13, resultSet.getString("PayLevel11"));
                                    updateStatement.setString(14, resultSet.getString("PayLevel12"));
                                    updateStatement.setString(15, resultSet.getString("PayLevel13"));
                                    updateStatement.setString(16, resultSet.getString("PayLevel14"));
                                    updateStatement.setString(17, resultSet.getString("PayLevel15"));
                                    updateStatement.setString(18, resultSet.getString("PayLevel16"));
                                    updateStatement.setString(19, resultSet.getString("PayLevel17"));
                                    updateStatement.setString(20, resultSet.getString("PayLevel18"));
                                    updateStatement.setString(21, resultSet.getString("PayLevel19"));
                                    updateStatement.setString(22, resultSet.getString("PayLevel20"));
                                    updateStatement.setTimestamp(23, resultSet.getTimestamp("periodEnd"));
                                    updateStatement.setInt(24, resultSet.getInt("periodDuration"));
                                    updateStatement.setString(25, resultSet.getString("access"));
                                    updateStatement.setString(26, resultSet.getString("serialNumber"));
                                    updateStatement.setString(27, resultSet.getString("companyName"));
                                    updateStatement.setString(28, resultSet.getString("companyAddress1"));
                                    updateStatement.setString(29, resultSet.getString("companyAddress2"));
                                    updateStatement.setString(30, resultSet.getString("companyCity"));
                                    updateStatement.setString(31, resultSet.getString("companyState"));
                                    updateStatement.setString(32, resultSet.getString("companyZip"));
                                    updateStatement.setString(33, resultSet.getString("companyPhone"));
                                    updateStatement.setString(34, resultSet.getString("companyEmail"));
                                    updateStatement.setString(35, resultSet.getString("registration"));
                                    updateStatement.executeUpdate();
                                }
                            }
                            catch (Exception ex) {
                                this.core.input("Source copy tables do not exist, new tables will be blank");
                            }
                            command = "Update TCcontrol set databaseVersion = '1.8'";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "1.8";
                        }
                        if (version.compareToIgnoreCase("1.8") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "CREATE TABLE Breaks (Id int IDENTITY, breakType NVARCHAR(20), appliesAfter int, breakTime int, breakMinimum int, breakPaid BIT, textColor NVARCHAR(10))" : "CREATE TABLE Breaks (Id counter, breakType text(20), appliesAfter int, breakTime int, breakMinimum int, breakPaid YESNO, textColor text(10))";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "Alter TABLE times add breakTypeId int" : "Alter TABLE times add column breakTypeId NUMBER";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "Alter TABLE TCcontrol add hoursBeforeOT Numeric(6,2)" : "Alter TABLE TCcontrol add column hoursBeforeOT Double";
                            stmt.executeUpdate(command);
                            command = "Update TCcontrol set databaseVersion = '1.9', hoursBeforeOT = 40";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "1.9";
                        }
                        if (version.compareToIgnoreCase("1.9") == 0) {
                            command = "";
                            command = isSqlExpress != false ? "CREATE TABLE Holidays ([Id] int IDENTITY, [Description] NVARCHAR(50), [Start] DATETIME, [End] DATETIME, [Type] NVARCHAR(50), [Group] NVARCHAR(20))" : "CREATE TABLE Holidays ([Id] counter, [Description] text(50), [Start] datetime, [End] datetime, [Type] text(50), [Group] text(20))";
                            stmt.executeUpdate(command);
                            command = isSqlExpress != false ? "Alter TABLE Employees add HolidayGroup NVARCHAR(20)" : "Alter TABLE Employees add HolidayGroup text(20)";
                            stmt.executeUpdate(command);
                            command = "Update TCcontrol set databaseVersion = '2.0'";
                            stmt.executeUpdate(command);
                            updated = true;
                            version = "2.0";
                        }
                        if (version.compareToIgnoreCase("2.0") == 0) {
                            try {
                                command = "";
                                command = isSqlExpress != false ? "Alter TABLE Employees add IsActive BIT" : "Alter TABLE Employees add column IsActive YESNO";
                                stmt.executeUpdate(command);
                                updateStatement = con.prepareStatement("Update Employees set IsActive = ?");
                                updateStatement.setBoolean(1, true);
                                updateStatement.executeUpdate();
                                command = "Update TCcontrol set databaseVersion = '2.1'";
                                stmt.executeUpdate(command);
                                updated = true;
                                version = "2.1";
                            }
                            catch (SQLException sQLException) {
                                text = Utility.getExceptionText(sQLException);
                                if (text.contains("already exists")) {
                                    this.command = "Update TCcontrol set databaseVersion = '2.1'";
                                    stmt.executeUpdate(this.command);
                                    updated = true;
                                    version = "2.1";
                                    break block71;
                                }
                                this.core.raiseException(sQLException);
                            }
                        }
                    }
                    if (version.compareToIgnoreCase("2.1") == 0) {
                        this.command = "Update TCcontrol set databaseVersion = '2.2'";
                        stmt.executeUpdate(this.command);
                        updated = true;
                        version = "2.2";
                    }
                    if (version.compareToIgnoreCase("2.2") == 0) {
                        this.command = "Update TCcontrol set databaseVersion = '2.3'";
                        stmt.executeUpdate(this.command);
                        updated = true;
                        version = "2.3";
                    }
                    if (updated) {
                        this.core.input("AccuShiftDataAccess tables updated to version " + version);
                    }
                    this.blockConnection = false;
                }
                catch (Exception e) {
                    this.core.raiseException(e);
                }
                catch (Throwable var19_28) {
                    throw var19_28;
                }
            }
        }
        finally {
            try {
                if (insertStmt != null) {
                    insertStmt.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (insertStatement != null) {
                    insertStatement.close();
                }
                if (updateStatement != null) {
                    updateStatement.close();
                }
                if (con != null) {
                    con.close();
                }
                if (this.oneConnection != null) {
                    this.oneConnection.close();
                }
                this.oneConnection = null;
            }
            catch (Exception ex) {
                this.core.raiseException(ex);
            }
        }
        if (converting) {
            this.core.convertAccuShiftConfigurationToNG();
            this.dbDriver = this.core.getDatabaseDriverName();
            if (this.dbDriver.compareToIgnoreCase("sqlexpress") == 0) {
                this.host = this.core.getDatabaseHost();
                this.databaseName = this.core.getDatabaseName();
                this.user = this.core.getDatabaseUser();
                this.password = this.core.getDatabasePswd();
            } else {
                this.path = this.core.getDatabasePath();
            }
        }
        this.blockConnection = false;
        return true;
    }

    public int getType() {
        return 4;
    }

    @Override
    public void output(String output) {
    }

    private ArrayList getAllPayLevelNames() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = this.getDatabaseConnection();
        if (conn == null) {
            return result;
        }
        String query = "Select * from TCcontrol";
        stmt = conn.createStatement();
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            result.add(rs.getString("payLevel1"));
            result.add(rs.getString("payLevel2"));
            result.add(rs.getString("payLevel3"));
            result.add(rs.getString("payLevel4"));
            result.add(rs.getString("payLevel5"));
            result.add(rs.getString("payLevel6"));
            result.add(rs.getString("payLevel7"));
            result.add(rs.getString("payLevel8"));
            result.add(rs.getString("payLevel9"));
            result.add(rs.getString("payLevel10"));
            result.add(rs.getString("payLevel11"));
            result.add(rs.getString("payLevel12"));
            result.add(rs.getString("payLevel13"));
            result.add(rs.getString("payLevel14"));
            result.add(rs.getString("payLevel15"));
            result.add(rs.getString("payLevel16"));
            result.add(rs.getString("payLevel17"));
            result.add(rs.getString("payLevel18"));
            result.add(rs.getString("payLevel19"));
            result.add(rs.getString("payLevel20"));
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return result;
    }

    @Override
    public Employee getEmployeeInfo(String employeeId) throws Exception {
        return this.getEmployeeInfo(employeeId, false);
    }

    @Override
    public Employee getEmployeeInfo(String employeeId, boolean findByAccountingId) throws Exception {
        String accountingId = "";
        Employee result = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection conn = this.getDatabaseConnection();
        if (conn == null) {
            return result;
        }
        ArrayList payLevelNames = new ArrayList();
        payLevelNames = this.getAllPayLevelNames();
        stmt = findByAccountingId ? conn.prepareStatement("Select * from Employees where accountingId = ?") : conn.prepareStatement("Select * from Employees where Id = ?");
        stmt.setString(1, employeeId);
        rs = stmt.executeQuery();
        if (rs.next()) {
            accountingId = rs.getString("accountingId");
            String nameText = rs.getString("name");
            boolean payLevelFlag = false;
            String payLevel1 = "";
            String payLevel2 = "";
            String payLevel3 = "";
            String payLevel4 = "";
            String payLevel5 = "";
            String payLevel6 = "";
            String payLevel7 = "";
            String payLevel8 = "";
            String payLevel9 = "";
            String payLevel10 = "";
            String payLevel11 = "";
            String payLevel12 = "";
            String payLevel13 = "";
            String payLevel14 = "";
            String payLevel15 = "";
            String payLevel16 = "";
            String payLevel17 = "";
            String payLevel18 = "";
            String payLevel19 = "";
            String payLevel20 = "";
            payLevelFlag = rs.getBoolean("PayLevel1");
            if (payLevelFlag) {
                payLevel1 = (String)payLevelNames.get(0);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel2")) {
                payLevel2 = (String)payLevelNames.get(1);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel3")) {
                payLevel3 = (String)payLevelNames.get(2);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel4")) {
                payLevel4 = (String)payLevelNames.get(3);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel5")) {
                payLevel5 = (String)payLevelNames.get(4);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel6")) {
                payLevel6 = (String)payLevelNames.get(5);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel7")) {
                payLevel7 = (String)payLevelNames.get(6);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel8")) {
                payLevel8 = (String)payLevelNames.get(7);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel9")) {
                payLevel9 = (String)payLevelNames.get(8);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel10")) {
                payLevel10 = (String)payLevelNames.get(9);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel11")) {
                payLevel11 = (String)payLevelNames.get(10);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel12")) {
                payLevel12 = (String)payLevelNames.get(11);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel13")) {
                payLevel13 = (String)payLevelNames.get(12);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel14")) {
                payLevel14 = (String)payLevelNames.get(13);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel15")) {
                payLevel15 = (String)payLevelNames.get(14);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel16")) {
                payLevel16 = (String)payLevelNames.get(15);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel17")) {
                payLevel17 = (String)payLevelNames.get(16);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel18")) {
                payLevel18 = (String)payLevelNames.get(17);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel19")) {
                payLevel19 = (String)payLevelNames.get(18);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel20")) {
                payLevel20 = (String)payLevelNames.get(19);
            }
            boolean manager = rs.getBoolean("Manager");
            boolean overtimeOver8 = rs.getBoolean("overtimeOver8");
            String holidayGroup = rs.getString("HolidayGroup");
            boolean isActive = rs.getBoolean("IsActive");
            Employee employee = new Employee(accountingId, nameText, payLevel1, payLevel2, payLevel3, payLevel4, payLevel5, payLevel6, payLevel7, payLevel8, payLevel9, payLevel10, payLevel11, payLevel12, payLevel13, payLevel14, payLevel15, payLevel16, payLevel17, payLevel18, payLevel19, payLevel20, manager, false);
            employee.overtimeOver8 = overtimeOver8;
            employee.currentHours = this.getEmployeePayPeriodTime(employeeId);
            employee.holidayGroup = holidayGroup;
            employee.isActive = isActive;
            result = employee;
        }
        stmt = conn.prepareStatement("Select * from times where [in] IS NOT NULL AND [out] IS Null AND employeeId = ?");
        stmt.setString(1, accountingId);
        rs = stmt.executeQuery();
        if (rs.next()) {
            int breakTypeId = rs.getInt("BreakTypeId");
            result.isClockedIn = breakTypeId == 0;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return result;
    }

    @Override
    public boolean setEmployeeClockIn(String employeeId, int payLevelNumber, int breakId) throws Exception {
        boolean success = false;
        Employee employee = this.getEmployeeInfo(employeeId, false);
        if (employee == null) {
            employee = this.getEmployeeInfo(employeeId, true);
        }
        if (employee != null && employee.isActive) {
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            GregorianCalendar nowCalendar = new GregorianCalendar();
            nowCalendar.set(13, 0);
            Timestamp now = new Timestamp(nowCalendar.getTime().getTime());
            conn = this.getDatabaseConnection();
            if (conn != null) {
                stmt = conn.prepareStatement("INSERT into times (\"EmployeeId\",\"PayLevel\",\"In\",\"BreakTypeId\") Values (?,?,?,?)");
                stmt.setString(1, employeeId);
                stmt.setInt(2, payLevelNumber);
                stmt.setTimestamp(3, now);
                stmt.setInt(4, breakId);
                int rowsChanged = stmt.executeUpdate();
                if (rowsChanged == 1) {
                    success = true;
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return success;
    }

    @Override
    public boolean setEmployeeClockOut(String employeeId) throws Exception {
        return this.setEmployeeClockOut(employeeId, 0);
    }

    public boolean setEmployeeClockOut(String employeeId, int breakId) throws Exception {
        boolean success = false;
        Employee employee = this.getEmployeeInfo(employeeId, false);
        if (employee == null) {
            employee = this.getEmployeeInfo(employeeId, true);
        }
        if (employee != null && employee.isActive) {
            Timestamp outTime;
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            GregorianCalendar nowCalendar = new GregorianCalendar();
            nowCalendar.set(13, 0);
            Timestamp now = new Timestamp(nowCalendar.getTime().getTime());
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return false;
            }
            boolean logOutTimeSet = false;
            stmt = this.dbDriver.equalsIgnoreCase("sqlexpress") ? conn.prepareStatement("Select * from times where ([in] IS NOT NULL OR [in] = '') AND (canceled = 'False' OR canceled IS NULL) AND employeeId = ? order by [in] DESC ") : conn.prepareStatement("Select * from times where [in] IS NOT NULL AND [out] IS NULL AND (canceled = 0 OR canceled IS NULL) AND employeeId = ? order by [in] DESC ");
            stmt.setString(1, employeeId);
            rs = stmt.executeQuery();
            if (rs.next() && ((outTime = rs.getTimestamp("out")) == null || outTime.getTime() < 100000L)) {
                Timestamp inTime = rs.getTimestamp("in");
                long elapsed = now.getTime() - inTime.getTime();
                int id = rs.getInt("id");
                stmt = conn.prepareStatement("UPDATE times set out = ?, total = ? where id = ?");
                stmt.setTimestamp(1, now);
                stmt.setInt(2, (int)elapsed);
                stmt.setInt(3, id);
                stmt.executeUpdate();
                logOutTimeSet = true;
            }
            if (!logOutTimeSet) {
                stmt = conn.prepareStatement("INSERT into times (\"EmployeeId\",\"PayLevel\",\"In\",\"Out\",\"Total\",\"BreakTypeId\") Values (?,?,?,?,?,?)");
                stmt.setString(1, employeeId);
                stmt.setInt(2, 1);
                stmt.setTimestamp(3, null);
                stmt.setTimestamp(4, now);
                stmt.setInt(5, 0);
                stmt.setInt(6, 0);
                stmt.executeUpdate();
                logOutTimeSet = true;
            }
            success = logOutTimeSet;
            this.core.updateHostSyncStatus("Times", true);
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return success;
    }

    @Override
    public Timestamp getClockInTime(String employeeId, int payLevel) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return null;
        }
        stmt = conn.prepareStatement("Select * from times where employeeId = ? AND payLevel = ? AND [out] Is Null AND [in] Is Not Null Order By [in] DESC");
        stmt.setString(1, employeeId);
        stmt.setInt(2, payLevel);
        rs = stmt.executeQuery();
        Timestamp clockIn = null;
        if (rs.next()) {
            clockIn = rs.getTimestamp("in");
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return clockIn;
    }

    @Override
    public boolean isClockedIntoBreak(String employeeId) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return false;
        }
        boolean isClockedIntoBreak = false;
        stmt = conn.prepareStatement("Select * from times where employeeId = ? AND [out] Is Null AND [in] Is Not Null AND breakTypeId <> 0 Order By [in] DESC");
        stmt.setString(1, employeeId);
        rs = stmt.executeQuery();
        if (rs.next()) {
            isClockedIntoBreak = true;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return isClockedIntoBreak;
    }

    @Override
    public int getClockInPayLevel(String employeeId) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return 0;
        }
        stmt = conn.prepareStatement("Select * from times where employeeId = ? AND out Is Null");
        stmt.setString(1, employeeId);
        rs = stmt.executeQuery();
        int payLevel = 0;
        if (rs.next()) {
            payLevel = rs.getInt("payLevel");
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return payLevel;
    }

    @Override
    public long getEmployeePayPeriodTime(String employeeId) throws Exception {
        Connection conn = null;
        PreparedStatement controlStmt = null;
        PreparedStatement timesStmt = null;
        ResultSet rs = null;
        Timestamp payPeriodEnd = null;
        int periodDays = 0;
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return 0L;
        }
        ArrayList breaksList = this.getBreaks();
        controlStmt = conn.prepareStatement("Select * from TCcontrol");
        rs = controlStmt.executeQuery();
        if (rs.next()) {
            payPeriodEnd = rs.getTimestamp("periodEnd");
            periodDays = rs.getInt("periodDuration");
        }
        long periodMilliSec = (long)periodDays * 24L * 60L * 60L * 1000L;
        Timestamp payPeriodStart = new Timestamp(payPeriodEnd.getTime() - periodMilliSec);
        timesStmt = conn.prepareStatement("Select * from times WHERE employeeId = ? AND (out >= ? AND out <= ?)");
        timesStmt.setString(1, employeeId);
        timesStmt.setTimestamp(2, payPeriodStart);
        timesStmt.setTimestamp(3, payPeriodEnd);
        rs = timesStmt.executeQuery();
        long payPeriodTime = 0L;
        while (rs.next()) {
            boolean timeIsPaid = true;
            int breakType = rs.getInt("BreakTypeId");
            if (breakType > 0 && breaksList != null && !breaksList.isEmpty()) {
                int len = breaksList.size();
                for (int i = 0; i < len; ++i) {
                    BreakInfo breakInfo = (BreakInfo)breaksList.get(i);
                    if (breakType != breakInfo.id) continue;
                    timeIsPaid = breakInfo.isPaid;
                    break;
                }
            }
            boolean canceled = rs.getBoolean("canceled");
            if (!timeIsPaid || canceled) continue;
            payPeriodTime += rs.getLong("total");
        }
        if (rs != null) {
            rs.close();
        }
        if (controlStmt != null) {
            controlStmt.close();
        }
        if (timesStmt != null) {
            timesStmt.close();
        }
        return payPeriodTime;
    }

    @Override
    public String[] getPaytypes() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String[] result = new String[20];
        try {
            conn = this.getDatabaseConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("Select * from TCcontrol");
            if (rs.next()) {
                String payLevel = rs.getString("payLevel1");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[0] = payLevel;
                payLevel = rs.getString("payLevel2");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[1] = payLevel;
                payLevel = rs.getString("payLevel3");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[2] = payLevel;
                payLevel = rs.getString("payLevel4");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[3] = payLevel;
                payLevel = rs.getString("payLevel5");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[4] = payLevel;
                payLevel = rs.getString("payLevel6");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[5] = payLevel;
                payLevel = rs.getString("payLevel7");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[6] = payLevel;
                payLevel = rs.getString("payLevel8");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[7] = payLevel;
                payLevel = rs.getString("payLevel9");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[8] = payLevel;
                payLevel = rs.getString("payLevel10");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[9] = payLevel;
                payLevel = rs.getString("payLevel11");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[10] = payLevel;
                payLevel = rs.getString("payLevel12");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[11] = payLevel;
                payLevel = rs.getString("payLevel13");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[12] = payLevel;
                payLevel = rs.getString("payLevel14");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[13] = payLevel;
                payLevel = rs.getString("payLevel15");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[14] = payLevel;
                payLevel = rs.getString("payLevel16");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[15] = payLevel;
                payLevel = rs.getString("payLevel17");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[16] = payLevel;
                payLevel = rs.getString("payLevel18");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[17] = payLevel;
                payLevel = rs.getString("payLevel19");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[18] = payLevel;
                payLevel = rs.getString("payLevel20");
                if (rs.wasNull()) {
                    payLevel = "";
                }
                result[19] = payLevel;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    @Override
    public void removeEmployee(String employeeId) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        Statement detailStmt = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            detailStmt = conn.prepareStatement("Delete from times where employeeId = ?");
            detailStmt.setString(1, employeeId);
            detailStmt.executeUpdate();
            stmt = conn.prepareStatement("Delete from employees where accountingId = ?");
            stmt.setString(1, employeeId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement("Delete from times where id = ?");
            stmt.setString(1, employeeId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (detailStmt != null) {
                detailStmt.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public POSDataContainer getTimesExports() throws Exception {
        Vector result = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        GregorianCalendar start = new GregorianCalendar();
        start.set(2, 0);
        start.set(5, 1);
        start.set(1, 2000);
        long startMiliseconds = start.getTime().getTime();
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                Vector vector = result;
                return vector;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("Select DISTINCT sent from times order by sent DESC ");
            while (rs.next()) {
                Timestamp thisTime = rs.getTimestamp("sent");
                if (thisTime == null || thisTime.getTime() <= startMiliseconds) continue;
                result.add(thisTime);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    @Override
    public ArrayList getEmployees() throws Exception {
        ArrayList<Employee> employees = new ArrayList<Employee>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                ArrayList<Employee> arrayList = employees;
                return arrayList;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("Select * from employees order by name");
            String[] payLevel = this.getPaytypes();
            while (rs.next()) {
                String id = rs.getString("Id");
                String accountingId = rs.getString("AccountingId");
                String name = rs.getString("Name");
                boolean payLevel1 = rs.getBoolean("PayLevel1") && payLevel[0].length() > 0;
                boolean payLevel2 = rs.getBoolean("PayLevel2") && payLevel[1].length() > 0;
                boolean payLevel3 = rs.getBoolean("PayLevel3") && payLevel[2].length() > 0;
                boolean payLevel4 = rs.getBoolean("PayLevel4") && payLevel[3].length() > 0;
                boolean payLevel5 = rs.getBoolean("PayLevel5") && payLevel[4].length() > 0;
                boolean payLevel6 = rs.getBoolean("PayLevel6") && payLevel[5].length() > 0;
                boolean payLevel7 = rs.getBoolean("PayLevel7") && payLevel[6].length() > 0;
                boolean payLevel8 = rs.getBoolean("PayLevel8") && payLevel[7].length() > 0;
                boolean payLevel9 = rs.getBoolean("PayLevel9") && payLevel[8].length() > 0;
                boolean payLevel10 = rs.getBoolean("PayLevel10") && payLevel[9].length() > 0;
                boolean payLevel11 = rs.getBoolean("PayLevel11") && payLevel[10].length() > 0;
                boolean payLevel12 = rs.getBoolean("PayLevel12") && payLevel[11].length() > 0;
                boolean payLevel13 = rs.getBoolean("PayLevel13") && payLevel[12].length() > 0;
                boolean payLevel14 = rs.getBoolean("PayLevel14") && payLevel[13].length() > 0;
                boolean payLevel15 = rs.getBoolean("PayLevel15") && payLevel[14].length() > 0;
                boolean payLevel16 = rs.getBoolean("PayLevel16") && payLevel[15].length() > 0;
                boolean payLevel17 = rs.getBoolean("PayLevel17") && payLevel[16].length() > 0;
                boolean payLevel18 = rs.getBoolean("PayLevel18") && payLevel[17].length() > 0;
                boolean payLevel19 = rs.getBoolean("PayLevel19") && payLevel[18].length() > 0;
                boolean payLevel20 = rs.getBoolean("PayLevel20") && payLevel[19].length() > 0;
                boolean manager = rs.getBoolean("Manager");
                String employeeClass = rs.getString("EmployeeClass");
                boolean overtimeOver8 = rs.getBoolean("overtimeOver8");
                String holidayGroup = rs.getString("HolidayGroup");
                boolean isActive = rs.getBoolean("IsActive");
                Employee employee = new Employee();
                employee.id = id;
                employee.accountingId = accountingId;
                employee.name = name;
                employee.manager = manager;
                employee.employeeClass = employeeClass;
                employee.overtimeOver8 = overtimeOver8;
                if (payLevel1) {
                    employee.payLevel1 = payLevel[0];
                }
                if (payLevel2) {
                    employee.payLevel2 = payLevel[1];
                }
                if (payLevel3) {
                    employee.payLevel3 = payLevel[2];
                }
                if (payLevel4) {
                    employee.payLevel4 = payLevel[3];
                }
                if (payLevel5) {
                    employee.payLevel5 = payLevel[4];
                }
                if (payLevel6) {
                    employee.payLevel6 = payLevel[5];
                }
                if (payLevel7) {
                    employee.payLevel7 = payLevel[6];
                }
                if (payLevel8) {
                    employee.payLevel8 = payLevel[7];
                }
                if (payLevel9) {
                    employee.payLevel9 = payLevel[8];
                }
                if (payLevel10) {
                    employee.payLevel10 = payLevel[9];
                }
                if (payLevel11) {
                    employee.payLevel11 = payLevel[10];
                }
                if (payLevel12) {
                    employee.payLevel12 = payLevel[11];
                }
                if (payLevel13) {
                    employee.payLevel13 = payLevel[12];
                }
                if (payLevel14) {
                    employee.payLevel14 = payLevel[13];
                }
                if (payLevel15) {
                    employee.payLevel15 = payLevel[14];
                }
                if (payLevel16) {
                    employee.payLevel16 = payLevel[15];
                }
                if (payLevel17) {
                    employee.payLevel17 = payLevel[16];
                }
                if (payLevel18) {
                    employee.payLevel18 = payLevel[17];
                }
                if (payLevel19) {
                    employee.payLevel19 = payLevel[18];
                }
                if (payLevel20) {
                    employee.payLevel20 = payLevel[19];
                }
                employee.currentHours = this.getEmployeePayPeriodTime(employee.accountingId);
                employee.holidayGroup = holidayGroup;
                employee.isActive = isActive;
                employees.add(employee);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return employees;
    }

    @Override
    public CompanyInfo getCompanyInformation() throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        CompanyInfo companyInfo = null;
        try {
            Connection conn = this.getDatabaseConnection();
            if (conn == null) {
                CompanyInfo companyInfo2 = null;
                return companyInfo2;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM TCcontrol");
            if (rs.next()) {
                companyInfo = new CompanyInfo();
                companyInfo.serialNumber = rs.getString("serialNumber");
                companyInfo.companyName = rs.getString("companyName");
                companyInfo.companyAddress1 = rs.getString("companyAddress1");
                companyInfo.companyAddress2 = rs.getString("companyAddress2");
                companyInfo.companyCity = rs.getString("companyCity");
                companyInfo.companyState = rs.getString("companyState");
                companyInfo.companyZip = rs.getString("companyZip");
                companyInfo.companyPhone = rs.getString("companyPhone");
                companyInfo.companyEmail = rs.getString("companyEmail");
                companyInfo.registrationKey = rs.getString("registration");
                companyInfo.siteName = rs.getString("siteName");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return companyInfo;
    }

    @Override
    public void saveCompanyInformation(CompanyInfo companyInfo) throws Exception {
        try (Statement stmt = null;){
            Connection conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.prepareStatement("UPDATE TCcontrol set serialNumber = ?, companyName = ?, companyAddress1 = ?, companyAddress2 = ?, companyCity = ?, companyState = ?, companyZip = ?, companyPhone = ?, companyEmail = ?, registration = ?, sitename = ?");
            stmt.setString(1, companyInfo.serialNumber);
            stmt.setString(2, companyInfo.companyName);
            stmt.setString(3, companyInfo.companyAddress1);
            stmt.setString(4, companyInfo.companyAddress2);
            stmt.setString(5, companyInfo.companyCity);
            stmt.setString(6, companyInfo.companyState);
            stmt.setString(7, companyInfo.companyZip);
            stmt.setString(8, companyInfo.companyPhone);
            stmt.setString(9, companyInfo.companyEmail);
            stmt.setString(10, companyInfo.registrationKey);
            stmt.setString(11, companyInfo.siteName);
            stmt.executeUpdate();
            this.core.updateHostSyncStatus("TCcontrol", true);
        }
    }

    @Override
    public String getSiteName() throws Exception {
        String result = "";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Connection conn = this.getDatabaseConnection();
            if (conn == null) {
                String string = result;
                return string;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM TCcontrol");
            if (rs.next()) {
                result = rs.getString("SiteName");
                if (rs.wasNull()) {
                    result = "";
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    @Override
    public void advancePeriodEnd() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        Statement updateStmt = null;
        ResultSet rs = null;
        Timestamp end = null;
        long duration = 0L;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT PeriodEnd, PeriodDuration  FROM TCcontrol");
            if (rs.next()) {
                end = rs.getTimestamp("PeriodEnd");
                duration = rs.getInt("PeriodDuration");
            }
            if (end != null && duration > 0L) {
                end.setTime(end.getTime() + duration * 86400000L);
                updateStmt = conn.prepareStatement("UPDATE TCcontrol SET periodEnd = ?");
                updateStmt.setTimestamp(1, end);
                updateStmt.executeUpdate();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (updateStmt != null) {
                updateStmt.close();
            }
        }
    }

    @Override
    public PayPeriodInfo getPayPeriodInfo() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        PayPeriodInfo result = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                PayPeriodInfo payPeriodInfo = result;
                return payPeriodInfo;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM TCcontrol");
            if (rs.next()) {
                result = new PayPeriodInfo();
                result.periodEnd = rs.getTimestamp("PeriodEnd");
                result.periodDuration = rs.getInt("PeriodDuration");
                result.weekStartDay = rs.getString("WeekStartDay");
                result.weekEndDay = rs.getString("WeekEndDay");
                result.hoursBeforeOT = rs.getDouble("hoursBeforeOT");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    @Override
    public void savePayTypes(String[] payTypes) throws Exception {
        Connection conn = null;
        try (Statement stmt = null;){
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            String update = "Update TCcontrol set paylevel1 = ?, paylevel2 = ?, paylevel3 = ?, paylevel4 = ?, paylevel5 = ?, paylevel6 = ?, paylevel7 = ?, paylevel8 = ?, paylevel9 = ?, paylevel10 = ?,";
            update = update + "paylevel11 = ?, paylevel12 = ?, paylevel13 = ?, paylevel14 = ?, paylevel15 = ?, paylevel16 = ?, paylevel17 = ?, paylevel18 = ?, paylevel19 = ?, paylevel20 = ?";
            stmt = conn.prepareStatement(update);
            stmt.setString(1, payTypes[0]);
            stmt.setString(2, payTypes[1]);
            stmt.setString(3, payTypes[2]);
            stmt.setString(4, payTypes[3]);
            stmt.setString(5, payTypes[4]);
            stmt.setString(6, payTypes[5]);
            stmt.setString(7, payTypes[6]);
            stmt.setString(8, payTypes[7]);
            stmt.setString(9, payTypes[8]);
            stmt.setString(10, payTypes[9]);
            stmt.setString(11, payTypes[10]);
            stmt.setString(12, payTypes[11]);
            stmt.setString(13, payTypes[12]);
            stmt.setString(14, payTypes[13]);
            stmt.setString(15, payTypes[14]);
            stmt.setString(16, payTypes[15]);
            stmt.setString(17, payTypes[16]);
            stmt.setString(18, payTypes[17]);
            stmt.setString(19, payTypes[18]);
            stmt.setString(20, payTypes[19]);
            stmt.executeUpdate();
            this.core.updateHostSyncStatus("TCcontrol", true);
        }
    }

    @Override
    public void savePayPeriod(PayPeriodInfo payPeriodInfo) throws Exception {
        Connection conn = null;
        try (Statement stmt = null;){
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            String update = "Update TCcontrol set periodEnd = ?, periodDuration = ?, weekStartDay = ?, weekEndDay = ?, hoursBeforeOT = ?";
            stmt = conn.prepareStatement(update);
            stmt.setTimestamp(1, payPeriodInfo.periodEnd);
            stmt.setInt(2, payPeriodInfo.periodDuration);
            stmt.setString(3, payPeriodInfo.weekStartDay);
            stmt.setString(4, payPeriodInfo.weekEndDay);
            stmt.setDouble(5, payPeriodInfo.hoursBeforeOT);
            stmt.executeUpdate();
            this.core.updateHostSyncStatus("TCcontrol", true);
        }
    }

    @Override
    public void removeEmployeeData() throws Exception {
        Connection conn = null;
        try (Statement stmt = null;){
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.createStatement();
            stmt.executeUpdate("DELETE from employees");
        }
    }

    @Override
    public void removeTimesData() throws Exception {
        Connection conn = null;
        try (Statement stmt = null;){
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.createStatement();
            stmt.executeUpdate("DELETE from times");
        }
    }

    @Override
    public void updateEmployee(Employee employee) throws Exception {
        Connection conn = this.getDatabaseConnection();
        PreparedStatement insertStmt = null;
        PreparedStatement updateStmt = null;
        PreparedStatement updateTimesStmt = null;
        Statement searchStmt = null;
        Statement deleteStmt = null;
        ResultSet rs = null;
        try {
            insertStmt = conn.prepareStatement("INSERT INTO EMPLOYEES (\"Id\",\"AccountingId\",\"Name\",\"PayLevel1\",\"PayLevel2\",\"PayLevel3\",\"PayLevel4\",\"PayLevel5\",\"PayLevel6\",\"PayLevel7\",\"PayLevel8\",\"PayLevel9\",\"PayLevel10\",\"PayLevel11\",\"PayLevel12\",\"PayLevel13\",\"PayLevel14\",\"PayLevel15\",\"PayLevel16\",\"PayLevel17\",\"PayLevel18\",\"PayLevel19\",\"PayLevel20\",\"Manager\",\"EmployeeClass\",\"OvertimeOver8\",\"HolidayGroup\", \"IsActive\") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            updateStmt = conn.prepareStatement("UPDATE EMPLOYEES SET [Name] = ?,[PayLevel1] = ?,[PayLevel2] = ?,[PayLevel3] = ?,[PayLevel4] = ?,[PayLevel5] = ?,[PayLevel6] = ?,[PayLevel7] = ?,[PayLevel8] = ?,[PayLevel9] = ?,[PayLevel10] = ?,[PayLevel11] = ?,[PayLevel12] = ?,[PayLevel13] = ?,[PayLevel14] = ?,[PayLevel15] = ?,[PayLevel16] = ?,[PayLevel17] = ?,[PayLevel18] = ?,[PayLevel19] = ?,[PayLevel20] = ?,[Manager] = ?,[EmployeeClass] = ?,[AccountingId] = ?,[OvertimeOver8] = ?,[HolidayGroup] = ?,[IsActive] = ? WHERE [Id] = ?");
            updateTimesStmt = conn.prepareStatement("UPDATE TIMES SET [employeeId] = ? WHERE [employeeId] = ?");
            searchStmt = conn.prepareStatement("SELECT * from EMPLOYEES WHERE [AccountingId] = ? or [Id] = ?");
            deleteStmt = conn.prepareStatement("Delete from EMPLOYEES where [Id] = ?");
            String employeeId = employee.id;
            String accountingId = employee.accountingId;
            if (accountingId.trim().length() == 0) {
                accountingId = employeeId;
            }
            String employeeClass = "";
            employeeClass = employee.employeeClass;
            searchStmt.clearParameters();
            searchStmt.setString(1, accountingId);
            searchStmt.setString(2, employeeId);
            rs = searchStmt.executeQuery();
            boolean update = false;
            String currentAccountingId = "";
            if (rs.next()) {
                employeeId = rs.getString("Id");
                currentAccountingId = rs.getString("AccountingId");
                if (employeeId.compareToIgnoreCase(employee.id) == 0) {
                    update = true;
                } else {
                    deleteStmt.setString(1, employeeId);
                    deleteStmt.executeUpdate();
                    update = false;
                }
            }
            if (update) {
                updateStmt.setString(1, employee.name);
                updateStmt.setBoolean(2, !employee.payLevel1.isEmpty());
                updateStmt.setBoolean(3, !employee.payLevel2.isEmpty());
                updateStmt.setBoolean(4, !employee.payLevel3.isEmpty());
                updateStmt.setBoolean(5, !employee.payLevel4.isEmpty());
                updateStmt.setBoolean(6, !employee.payLevel5.isEmpty());
                updateStmt.setBoolean(7, !employee.payLevel6.isEmpty());
                updateStmt.setBoolean(8, !employee.payLevel7.isEmpty());
                updateStmt.setBoolean(9, !employee.payLevel8.isEmpty());
                updateStmt.setBoolean(10, !employee.payLevel9.isEmpty());
                updateStmt.setBoolean(11, !employee.payLevel10.isEmpty());
                updateStmt.setBoolean(12, !employee.payLevel11.isEmpty());
                updateStmt.setBoolean(13, !employee.payLevel12.isEmpty());
                updateStmt.setBoolean(14, !employee.payLevel13.isEmpty());
                updateStmt.setBoolean(15, !employee.payLevel14.isEmpty());
                updateStmt.setBoolean(16, !employee.payLevel15.isEmpty());
                updateStmt.setBoolean(17, !employee.payLevel16.isEmpty());
                updateStmt.setBoolean(18, !employee.payLevel17.isEmpty());
                updateStmt.setBoolean(19, !employee.payLevel18.isEmpty());
                updateStmt.setBoolean(20, !employee.payLevel19.isEmpty());
                updateStmt.setBoolean(21, !employee.payLevel20.isEmpty());
                updateStmt.setBoolean(22, employee.manager);
                updateStmt.setString(23, employeeClass);
                updateStmt.setString(24, accountingId);
                updateStmt.setBoolean(25, employee.overtimeOver8);
                updateStmt.setString(26, employee.holidayGroup);
                updateStmt.setBoolean(27, employee.isActive);
                updateStmt.setString(28, employeeId);
                updateStmt.executeUpdate();
                if (accountingId.compareToIgnoreCase(currentAccountingId) != 0) {
                    updateTimesStmt.setString(1, accountingId);
                    updateTimesStmt.setString(2, currentAccountingId);
                    updateTimesStmt.executeUpdate();
                }
            } else {
                insertStmt.clearParameters();
                String id = employee.id;
                insertStmt.setString(1, id);
                accountingId = employee.accountingId;
                if (accountingId.trim().length() == 0) {
                    accountingId = id;
                }
                insertStmt.setString(2, accountingId);
                insertStmt.setString(3, employee.name);
                insertStmt.setBoolean(4, !employee.payLevel1.isEmpty());
                insertStmt.setBoolean(5, !employee.payLevel2.isEmpty());
                insertStmt.setBoolean(6, !employee.payLevel3.isEmpty());
                insertStmt.setBoolean(7, !employee.payLevel4.isEmpty());
                insertStmt.setBoolean(8, !employee.payLevel5.isEmpty());
                insertStmt.setBoolean(9, !employee.payLevel6.isEmpty());
                insertStmt.setBoolean(10, !employee.payLevel7.isEmpty());
                insertStmt.setBoolean(11, !employee.payLevel8.isEmpty());
                insertStmt.setBoolean(12, !employee.payLevel9.isEmpty());
                insertStmt.setBoolean(13, !employee.payLevel10.isEmpty());
                insertStmt.setBoolean(14, !employee.payLevel11.isEmpty());
                insertStmt.setBoolean(15, !employee.payLevel12.isEmpty());
                insertStmt.setBoolean(16, !employee.payLevel13.isEmpty());
                insertStmt.setBoolean(17, !employee.payLevel14.isEmpty());
                insertStmt.setBoolean(18, !employee.payLevel15.isEmpty());
                insertStmt.setBoolean(19, !employee.payLevel16.isEmpty());
                insertStmt.setBoolean(20, !employee.payLevel17.isEmpty());
                insertStmt.setBoolean(21, !employee.payLevel18.isEmpty());
                insertStmt.setBoolean(22, !employee.payLevel19.isEmpty());
                insertStmt.setBoolean(23, !employee.payLevel20.isEmpty());
                insertStmt.setBoolean(24, employee.manager);
                insertStmt.setString(25, employeeClass);
                insertStmt.setBoolean(26, employee.overtimeOver8);
                insertStmt.setString(27, employee.holidayGroup);
                insertStmt.setBoolean(28, employee.isActive);
                insertStmt.executeUpdate();
            }
            if (employee.times != null) {
                int len = employee.times.size();
                for (int i = 0; i < len; ++i) {
                    TimeDetail thisTime = (TimeDetail)employee.times.get(i);
                    this.updateEmployeeTime(employee.accountingId, thisTime);
                }
            }
            this.core.updateHostSyncStatus("Employees", true);
            this.core.updateHostSyncStatus("Times", true);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (searchStmt != null) {
                searchStmt.close();
            }
            if (insertStmt != null) {
                insertStmt.close();
            }
            if (updateStmt != null) {
                updateStmt.close();
            }
            if (updateTimesStmt != null) {
                updateTimesStmt.close();
            }
            if (deleteStmt != null) {
                deleteStmt.close();
            }
        }
    }

    @Override
    public void updateEmployees(ArrayList updatedEmployeeList, boolean updatePaytypes) throws Exception {
        boolean foundUser;
        int i;
        Connection conn = this.getDatabaseConnection();
        PreparedStatement insertStmt = null;
        PreparedStatement updateStmt = null;
        PreparedStatement update2Stmt = null;
        PreparedStatement updateTimesStmt = null;
        PreparedStatement searchStmt = null;
        PreparedStatement deleteStatement = null;
        ArrayList allEmployees = this.core.getEmployees();
        insertStmt = conn.prepareStatement("INSERT INTO EMPLOYEES (\"Id\",\"AccountingId\",\"Name\",\"PayLevel1\",\"PayLevel2\",\"PayLevel3\",\"PayLevel4\",\"PayLevel5\",\"PayLevel6\",\"PayLevel7\",\"PayLevel8\",\"PayLevel9\",\"PayLevel10\",\"PayLevel11\",\"PayLevel12\",\"PayLevel13\",\"PayLevel14\",\"PayLevel15\",\"PayLevel16\",\"PayLevel17\",\"PayLevel18\",\"PayLevel19\",\"PayLevel20\",\"Manager\",\"EmployeeClass\",\"OvertimeOver8\",\"HolidayGroup\", \"IsActive\") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        updateStmt = conn.prepareStatement("UPDATE EMPLOYEES SET [Name] = ?,[PayLevel1] = ?,[PayLevel2] = ?,[PayLevel3] = ?,[PayLevel4] = ?,[PayLevel5] = ?,[PayLevel6] = ?,[PayLevel7] = ?,[PayLevel8] = ?,[PayLevel9] = ?,[PayLevel10] = ?,[PayLevel11] = ?,[PayLevel12] = ?,[PayLevel13] = ?,[PayLevel14] = ?,[PayLevel15] = ?,[PayLevel16] = ?,[PayLevel17] = ?,[PayLevel18] = ?,[PayLevel19] = ?,[PayLevel20] = ?,[Manager] = ?,[EmployeeClass] = ?,[AccountingId] = ?,[OvertimeOver8] = ?,[HolidayGroup] = ?,[IsActive] = ? WHERE [Id] = ?");
        update2Stmt = conn.prepareStatement("UPDATE EMPLOYEES SET [Name] = ?,[Manager] = ?,[EmployeeClass] = ?,[AccountingId] = ?,[OvertimeOver8] = ?,[HolidayGroup] = ? WHERE [Id] = ?");
        deleteStatement = conn.prepareStatement("Delete from EMPLOYEES where [Id] = ?");
        updateTimesStmt = conn.prepareStatement("UPDATE TIMES SET [employeeId] = ? WHERE [employeeId] = ?");
        searchStmt = conn.prepareStatement("SELECT * from EMPLOYEES WHERE [AccountingId] = ? or [Id] = ?");
        int employeesLen = updatedEmployeeList.size();
        int currentLen = allEmployees.size();
        for (i = 0; i < currentLen; ++i) {
            foundUser = false;
            Employee currentEmployee = (Employee)allEmployees.get(i);
            for (int j = 0; j < employeesLen; ++j) {
                Employee user = (Employee)updatedEmployeeList.get(j);
                if (!currentEmployee.id.equalsIgnoreCase(user.id)) continue;
                foundUser = true;
                break;
            }
            if (foundUser) continue;
            deleteStatement.setString(1, currentEmployee.id);
            deleteStatement.executeUpdate();
        }
        for (i = 0; i < employeesLen; ++i) {
            foundUser = false;
            Employee employee = (Employee)updatedEmployeeList.get(i);
            for (int j = 0; j < currentLen; ++j) {
                Employee currentEmployee = (Employee)allEmployees.get(j);
                if (!employee.id.equalsIgnoreCase(currentEmployee.id)) continue;
                foundUser = true;
                break;
            }
            if (!foundUser) {
                String accountingId;
                insertStmt.clearParameters();
                String id = employee.id;
                insertStmt.setString(1, id);
                String currentAccountingId = accountingId = employee.accountingId;
                String employeeClass = employee.employeeClass;
                if (accountingId.trim().length() == 0) {
                    accountingId = id;
                }
                insertStmt.setString(2, accountingId);
                insertStmt.setString(3, employee.name);
                insertStmt.setBoolean(4, !employee.payLevel1.isEmpty());
                insertStmt.setBoolean(5, !employee.payLevel2.isEmpty());
                insertStmt.setBoolean(6, !employee.payLevel3.isEmpty());
                insertStmt.setBoolean(7, !employee.payLevel4.isEmpty());
                insertStmt.setBoolean(8, !employee.payLevel5.isEmpty());
                insertStmt.setBoolean(9, !employee.payLevel6.isEmpty());
                insertStmt.setBoolean(10, !employee.payLevel7.isEmpty());
                insertStmt.setBoolean(11, !employee.payLevel8.isEmpty());
                insertStmt.setBoolean(12, !employee.payLevel9.isEmpty());
                insertStmt.setBoolean(13, !employee.payLevel10.isEmpty());
                insertStmt.setBoolean(14, !employee.payLevel11.isEmpty());
                insertStmt.setBoolean(15, !employee.payLevel12.isEmpty());
                insertStmt.setBoolean(16, !employee.payLevel13.isEmpty());
                insertStmt.setBoolean(17, !employee.payLevel14.isEmpty());
                insertStmt.setBoolean(18, !employee.payLevel15.isEmpty());
                insertStmt.setBoolean(19, !employee.payLevel16.isEmpty());
                insertStmt.setBoolean(20, !employee.payLevel17.isEmpty());
                insertStmt.setBoolean(21, !employee.payLevel18.isEmpty());
                insertStmt.setBoolean(22, !employee.payLevel19.isEmpty());
                insertStmt.setBoolean(23, !employee.payLevel20.isEmpty());
                insertStmt.setBoolean(24, employee.manager);
                insertStmt.setString(25, employeeClass);
                insertStmt.setBoolean(26, employee.overtimeOver8);
                insertStmt.setString(27, employee.holidayGroup);
                insertStmt.setBoolean(28, employee.isActive);
                insertStmt.executeUpdate();
                updateTimesStmt.setString(1, id);
                updateTimesStmt.setString(2, currentAccountingId);
                updateTimesStmt.executeUpdate();
                continue;
            }
            String accountingId = employee.accountingId;
            String employeeClass = employee.employeeClass;
            String employeeId = employee.id;
            if (updatePaytypes) {
                updateStmt.setString(1, employee.name);
                updateStmt.setBoolean(2, !employee.payLevel1.isEmpty());
                updateStmt.setBoolean(3, !employee.payLevel2.isEmpty());
                updateStmt.setBoolean(4, !employee.payLevel3.isEmpty());
                updateStmt.setBoolean(5, !employee.payLevel4.isEmpty());
                updateStmt.setBoolean(6, !employee.payLevel5.isEmpty());
                updateStmt.setBoolean(7, !employee.payLevel6.isEmpty());
                updateStmt.setBoolean(8, !employee.payLevel7.isEmpty());
                updateStmt.setBoolean(9, !employee.payLevel8.isEmpty());
                updateStmt.setBoolean(10, !employee.payLevel9.isEmpty());
                updateStmt.setBoolean(11, !employee.payLevel10.isEmpty());
                updateStmt.setBoolean(12, !employee.payLevel11.isEmpty());
                updateStmt.setBoolean(13, !employee.payLevel12.isEmpty());
                updateStmt.setBoolean(14, !employee.payLevel13.isEmpty());
                updateStmt.setBoolean(15, !employee.payLevel14.isEmpty());
                updateStmt.setBoolean(16, !employee.payLevel15.isEmpty());
                updateStmt.setBoolean(17, !employee.payLevel16.isEmpty());
                updateStmt.setBoolean(18, !employee.payLevel17.isEmpty());
                updateStmt.setBoolean(19, !employee.payLevel18.isEmpty());
                updateStmt.setBoolean(20, !employee.payLevel19.isEmpty());
                updateStmt.setBoolean(21, !employee.payLevel20.isEmpty());
                updateStmt.setBoolean(22, employee.manager);
                updateStmt.setString(23, employeeClass);
                updateStmt.setString(24, accountingId);
                updateStmt.setBoolean(25, employee.overtimeOver8);
                updateStmt.setString(26, employee.holidayGroup);
                updateStmt.setBoolean(27, employee.isActive);
                updateStmt.setString(28, employeeId);
                updateStmt.executeUpdate();
            } else {
                update2Stmt.setString(1, employee.name);
                update2Stmt.setBoolean(2, employee.manager);
                update2Stmt.setString(3, employeeClass);
                update2Stmt.setString(4, accountingId);
                update2Stmt.setBoolean(5, employee.overtimeOver8);
                update2Stmt.setString(6, employee.holidayGroup);
                update2Stmt.setString(7, employeeId);
                update2Stmt.executeUpdate();
            }
            updateTimesStmt.setString(1, accountingId);
            String currentAccountingId = accountingId;
            updateTimesStmt.setString(2, currentAccountingId);
            updateTimesStmt.executeUpdate();
        }
        this.core.updateHostSyncStatus("Times", true);
        this.core.updateHostSyncStatus("Employees", true);
        if (searchStmt != null) {
            searchStmt.close();
        }
        if (deleteStatement != null) {
            deleteStatement.close();
        }
        if (insertStmt != null) {
            insertStmt.close();
        }
        if (update2Stmt != null) {
            update2Stmt.close();
        }
        if (updateStmt != null) {
            updateStmt.close();
        }
        if (updateTimesStmt != null) {
            updateTimesStmt.close();
        }
    }

    @Override
    public void updatePayTypeNames(String payTypeNamesXml) throws Exception {
        Connection conn = null;
        PreparedStatement updateStmt = null;
        String[] payTypes = this.getPaytypes();
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return;
        }
        updateStmt = conn.prepareStatement("UPDATE TCcontrol SET [PayLevel1] = ?,[PayLevel2] = ?,[PayLevel3] = ?,[PayLevel4] = ?,[PayLevel5] = ?,[PayLevel6] = ?,[PayLevel7] = ?,[PayLevel8] = ?,[PayLevel9] = ?,[PayLevel10] = ?,[PayLevel11] = ?,[PayLevel12] = ?,[PayLevel13] = ?,[PayLevel14] = ?,[PayLevel15] = ?,[PayLevel16] = ?,[PayLevel17] = ?,[PayLevel18] = ?,[PayLevel19] = ?,[PayLevel20] = ?");
        String names = payTypeNamesXml;
        Vector payTypeNames = Utility.getElementList("PayType", names);
        int len = payTypeNames.size();
        if (len > 20) {
            len = 20;
        }
        try {
            int i;
            for (i = 0; i < len; ++i) {
                boolean skip;
                String thisPayTypeName = (String)payTypeNames.get(i);
                boolean bl = skip = thisPayTypeName.compareToIgnoreCase("Empty") == 0;
                if (skip) continue;
                payTypes[i] = thisPayTypeName;
            }
            for (i = 0; i < len; ++i) {
                updateStmt.setString(i + 1, payTypes[i]);
            }
            updateStmt.executeUpdate();
            this.core.updateHostSyncStatus("TCcontrol", true);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (updateStmt != null) {
                updateStmt.close();
            }
        }
    }

    @Override
    public String getPassword() throws Exception {
        String password = "";
        Connection conn = null;
        ResultSet rs = null;
        try (Statement stmt = null;){
            conn = this.getDatabaseConnection();
            if (conn == null) {
                String string = password;
                return string;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("Select access from TCcontrol");
            if (rs.next()) {
                password = rs.getString("access");
                if (rs.wasNull()) {
                    password = "";
                }
            }
        }
        return password;
    }

    @Override
    public void updatePassword(String password) throws Exception {
        Connection conn = null;
        try (Statement stmt = null;){
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.prepareStatement("Update TCcontrol set access = ?");
            stmt.setString(1, password);
            stmt.executeUpdate();
            this.core.updateHostSyncStatus("TCcontrol", true);
        }
    }

    @Override
    public void getEmployeePeriodDetail(Employee employee) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        PreparedStatement controlStmt = null;
        ResultSet rs = null;
        int periodDays = 0;
        Timestamp payPeriodEnd = null;
        employee.currentHours = 0L;
        employee.times = new ArrayList();
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return;
        }
        controlStmt = conn.prepareStatement("Select * from TCcontrol");
        rs = controlStmt.executeQuery();
        if (rs.next()) {
            payPeriodEnd = rs.getTimestamp("periodEnd");
            periodDays = rs.getInt("periodDuration");
        }
        long periodMilliSec = (long)periodDays * 24L * 60L * 60L * 1000L;
        Timestamp payPeriodStart = new Timestamp(payPeriodEnd.getTime() - periodMilliSec);
        try {
            stmt = this.dbDriver.equalsIgnoreCase("sqlexpress") ? conn.prepareStatement("Select * from times where employeeId = ? and ((out <= ? and out >= ?) OR (out IS NULL OR out = '')) and (([in] <= ?) OR [in] IS Null OR [in] = '' OR (out IS NOT NULL)) order by ISNULL([in], [out]),[in]") : conn.prepareStatement("Select * from times where employeeId = ? and ((out <= ? and out >= ?) OR isNull(out)) and (([in] <= ?) OR isNull([in]) OR (not isNull(out))) order by IIf([in] Is Null, [out], [in])");
            stmt.setString(1, employee.accountingId);
            stmt.setTimestamp(2, payPeriodEnd);
            stmt.setTimestamp(3, payPeriodStart);
            stmt.setTimestamp(4, payPeriodEnd);
            rs = stmt.executeQuery();
            boolean goodTimes = true;
            while (rs.next()) {
                long id = rs.getInt("id");
                boolean canceled = rs.getBoolean("canceled");
                int payLevel = rs.getInt("payLevel");
                if (rs.wasNull()) {
                    payLevel = 0;
                    if (!canceled) {
                        goodTimes = false;
                    }
                }
                if (!canceled && payLevel < 0) {
                    goodTimes = false;
                }
                Timestamp in = rs.getTimestamp("in");
                Timestamp out = rs.getTimestamp("out");
                Timestamp sent = rs.getTimestamp("sent");
                long total = rs.getInt("total");
                if (in == null || out == null) {
                    if (!canceled) {
                        goodTimes = false;
                    }
                } else {
                    long elapsed = out.getTime() - in.getTime();
                    if (out.getTime() <= payPeriodEnd.getTime()) {
                        if (!canceled && elapsed > 59000L && elapsed < 86400000L) {
                            employee.currentHours += total;
                        } else if (!canceled) {
                            goodTimes = false;
                        }
                    }
                }
                TimeDetail thisTime = new TimeDetail(id, payLevel, in, out, total, sent);
                thisTime.canceled = canceled;
                thisTime.breakTypeId = rs.getInt("breakTypeId");
                employee.times.add(thisTime);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (controlStmt != null) {
                controlStmt.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public Employee getEmployeePeriodDetailFromTimeRange(Employee employee, Timestamp startDate, Timestamp endDate) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Employee returnEmployee = new Employee(employee.toXml());
        returnEmployee.currentHours = 0L;
        returnEmployee.times = new ArrayList();
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return returnEmployee;
        }
        try {
            stmt = this.dbDriver.equalsIgnoreCase("sqlexpress") ? conn.prepareStatement("Select * from times where employeeId = ? and ((out <= ? and out >= ?) OR (out IS NULL OR out = '')) and (([in] <= ?) OR [in] IS Null OR [in] = '' OR (out IS NOT NULL)) order by ISNULL([in], [out]),[in]") : conn.prepareStatement("Select * from times where employeeId = ? and ((out <= ? and out >= ?) OR isNull(out)) and (([in] <= ?) OR isNull([in]) OR (not isNull(out))) order by IIf([in] Is Null, [out], [in])");
            stmt.setString(1, returnEmployee.accountingId);
            stmt.setTimestamp(2, endDate);
            stmt.setTimestamp(3, startDate);
            stmt.setTimestamp(4, endDate);
            rs = stmt.executeQuery();
            boolean goodTimes = true;
            while (rs.next()) {
                long id = rs.getInt("id");
                boolean canceled = rs.getBoolean("canceled");
                int payLevel = rs.getInt("payLevel");
                if (rs.wasNull()) {
                    payLevel = 0;
                    if (!canceled) {
                        goodTimes = false;
                    }
                }
                if (!canceled && payLevel < 0) {
                    goodTimes = false;
                }
                Timestamp in = rs.getTimestamp("in");
                Timestamp out = rs.getTimestamp("out");
                Timestamp sent = rs.getTimestamp("sent");
                long total = rs.getInt("total");
                if (in == null || out == null) {
                    if (!canceled) {
                        goodTimes = false;
                    }
                } else {
                    long elapsed = out.getTime() - in.getTime();
                    if (out.getTime() <= endDate.getTime()) {
                        if (!canceled && elapsed > 59000L && elapsed < 86400000L) {
                            returnEmployee.currentHours += total;
                        } else if (!canceled) {
                            goodTimes = false;
                        }
                    }
                }
                TimeDetail thisTime = new TimeDetail(id, payLevel, in, out, total, sent);
                thisTime.canceled = canceled;
                thisTime.breakTypeId = rs.getInt("breakTypeId");
                returnEmployee.times.add(thisTime);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return returnEmployee;
    }

    @Override
    public void updateEmployeeTime(String accountingId, TimeDetail detail) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        if (detail.out != null) {
            GregorianCalendar calendar = new GregorianCalendar(2000, 1, 1);
            if (detail.out.getTime() < calendar.getTime().getTime()) {
                detail.out = null;
            }
        }
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            if (detail.id == 0L) {
                stmt = conn.prepareStatement("INSERT into times (\"EmployeeId\",\"PayLevel\",\"In\",\"Out\",\"Total\",\"Sent\",\"Canceled\",\"BreakTypeId\") Values (?,?,?,?,?,?,?,?)");
                stmt.setString(1, accountingId);
                stmt.setInt(2, detail.payLevel);
                stmt.setTimestamp(3, detail.in);
                stmt.setTimestamp(4, detail.out);
                stmt.setInt(5, (int)detail.total);
                stmt.setTimestamp(6, detail.sent);
                stmt.setBoolean(7, detail.canceled);
                stmt.setInt(8, detail.breakTypeId);
                stmt.executeUpdate();
            } else {
                stmt = conn.prepareStatement("UPDATE times set EmployeeId = ?, PayLevel = ?, [In] = ?, Out = ?, Total = ?, Sent = ?, Canceled = ?, BreakTypeId = ? Where id = ?");
                stmt.setString(1, accountingId);
                stmt.setInt(2, detail.payLevel);
                stmt.setTimestamp(3, detail.in);
                stmt.setTimestamp(4, detail.out);
                stmt.setInt(5, (int)detail.total);
                stmt.setTimestamp(6, detail.sent);
                stmt.setBoolean(7, detail.canceled);
                stmt.setInt(8, detail.breakTypeId);
                stmt.setInt(9, (int)detail.id);
                stmt.executeUpdate();
            }
            this.core.updateHostSyncStatus("Times", true);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public ArrayList getEmployeesWithOpenDetail() throws Exception {
        return this.getEmployeesWithOpenDetail(true);
    }

    @Override
    public ArrayList getEmployeesWithOpenDetail(boolean includeBreaks) throws Exception {
        ArrayList<Employee> employeeList = new ArrayList<Employee>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            stmt = conn.createStatement();
            String query = "Select * from employees";
            rs = stmt.executeQuery(query);
            String[] payLevel = this.getPaytypes();
            while (rs.next()) {
                String id = rs.getString("Id");
                String accountingId = rs.getString("AccountingId");
                String name = rs.getString("Name");
                String payLevel1 = rs.getBoolean("PayLevel1") ? payLevel[0] : "";
                String payLevel2 = rs.getBoolean("PayLevel2") ? payLevel[1] : "";
                String payLevel3 = rs.getBoolean("PayLevel3") ? payLevel[2] : "";
                String payLevel4 = rs.getBoolean("PayLevel4") ? payLevel[3] : "";
                String payLevel5 = rs.getBoolean("PayLevel5") ? payLevel[4] : "";
                String payLevel6 = rs.getBoolean("PayLevel6") ? payLevel[5] : "";
                String payLevel7 = rs.getBoolean("PayLevel7") ? payLevel[6] : "";
                String payLevel8 = rs.getBoolean("PayLevel8") ? payLevel[7] : "";
                String payLevel9 = rs.getBoolean("PayLevel9") ? payLevel[8] : "";
                String payLevel10 = rs.getBoolean("PayLevel10") ? payLevel[9] : "";
                String payLevel11 = rs.getBoolean("PayLevel11") ? payLevel[10] : "";
                String payLevel12 = rs.getBoolean("PayLevel12") ? payLevel[11] : "";
                String payLevel13 = rs.getBoolean("PayLevel13") ? payLevel[12] : "";
                String payLevel14 = rs.getBoolean("PayLevel14") ? payLevel[13] : "";
                String payLevel15 = rs.getBoolean("PayLevel15") ? payLevel[14] : "";
                String payLevel16 = rs.getBoolean("PayLevel16") ? payLevel[15] : "";
                String payLevel17 = rs.getBoolean("PayLevel17") ? payLevel[16] : "";
                String payLevel18 = rs.getBoolean("PayLevel18") ? payLevel[17] : "";
                String payLevel19 = rs.getBoolean("PayLevel19") ? payLevel[18] : "";
                String payLevel20 = rs.getBoolean("PayLevel20") ? payLevel[19] : "";
                boolean manager = rs.getBoolean("Manager");
                String employeeClass = rs.getString("EmployeeClass");
                String holidayGroup = rs.getString("HolidayGroup");
                boolean isActive = rs.getBoolean("IsActive");
                Employee employee = new Employee(id, name, payLevel1, payLevel2, payLevel3, payLevel4, payLevel5, payLevel6, payLevel7, payLevel8, payLevel9, payLevel10, payLevel11, payLevel12, payLevel13, payLevel14, payLevel15, payLevel16, payLevel17, payLevel18, payLevel19, payLevel20, manager, false);
                employee.accountingId = accountingId;
                employee.employeeClass = employeeClass;
                employee.overtimeOver8 = rs.getBoolean("overtimeOver8");
                employee.holidayGroup = holidayGroup;
                employee.isActive = isActive;
                this.getCurrentPeriodCompletedDetail(employee, includeBreaks);
                employeeList.add(employee);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return employeeList;
    }

    @Override
    public ArrayList getEmployeesWithOpenDetailFromTimeRange(Timestamp startDate, Timestamp endDate) throws Exception {
        ArrayList<Employee> employeeList = new ArrayList<Employee>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            stmt = conn.createStatement();
            String query = "Select * from employees";
            rs = stmt.executeQuery(query);
            String[] payLevel = this.getPaytypes();
            while (rs.next()) {
                String id = rs.getString("Id");
                String accountingId = rs.getString("AccountingId");
                String name = rs.getString("Name");
                String payLevel1 = rs.getBoolean("PayLevel1") ? payLevel[0] : "";
                String payLevel2 = rs.getBoolean("PayLevel2") ? payLevel[1] : "";
                String payLevel3 = rs.getBoolean("PayLevel3") ? payLevel[2] : "";
                String payLevel4 = rs.getBoolean("PayLevel4") ? payLevel[3] : "";
                String payLevel5 = rs.getBoolean("PayLevel5") ? payLevel[4] : "";
                String payLevel6 = rs.getBoolean("PayLevel6") ? payLevel[5] : "";
                String payLevel7 = rs.getBoolean("PayLevel7") ? payLevel[6] : "";
                String payLevel8 = rs.getBoolean("PayLevel8") ? payLevel[7] : "";
                String payLevel9 = rs.getBoolean("PayLevel9") ? payLevel[8] : "";
                String payLevel10 = rs.getBoolean("PayLevel10") ? payLevel[9] : "";
                String payLevel11 = rs.getBoolean("PayLevel11") ? payLevel[10] : "";
                String payLevel12 = rs.getBoolean("PayLevel12") ? payLevel[11] : "";
                String payLevel13 = rs.getBoolean("PayLevel13") ? payLevel[12] : "";
                String payLevel14 = rs.getBoolean("PayLevel14") ? payLevel[13] : "";
                String payLevel15 = rs.getBoolean("PayLevel15") ? payLevel[14] : "";
                String payLevel16 = rs.getBoolean("PayLevel16") ? payLevel[15] : "";
                String payLevel17 = rs.getBoolean("PayLevel17") ? payLevel[16] : "";
                String payLevel18 = rs.getBoolean("PayLevel18") ? payLevel[17] : "";
                String payLevel19 = rs.getBoolean("PayLevel19") ? payLevel[18] : "";
                String payLevel20 = rs.getBoolean("PayLevel20") ? payLevel[19] : "";
                boolean manager = rs.getBoolean("Manager");
                String employeeClass = rs.getString("EmployeeClass");
                String holidayGroup = rs.getString("HolidayGroup");
                boolean isActive = rs.getBoolean("IsActive");
                Employee employee = new Employee(id, name, payLevel1, payLevel2, payLevel3, payLevel4, payLevel5, payLevel6, payLevel7, payLevel8, payLevel9, payLevel10, payLevel11, payLevel12, payLevel13, payLevel14, payLevel15, payLevel16, payLevel17, payLevel18, payLevel19, payLevel20, manager, false);
                employee.accountingId = accountingId;
                employee.employeeClass = employeeClass;
                employee.overtimeOver8 = rs.getBoolean("overtimeOver8");
                employee.holidayGroup = holidayGroup;
                employee.isActive = isActive;
                this.getTimeRangeCompletedDetail(employee, startDate, endDate);
                employeeList.add(employee);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return employeeList;
    }

    @Override
    public void getCurrentPeriodCompletedDetail(Employee employee) throws Exception {
        this.getCurrentPeriodCompletedDetail(employee, true);
    }

    public void getCurrentPeriodCompletedDetail(Employee employee, boolean includeBreaks) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        employee.currentHours = 0L;
        employee.times = new ArrayList();
        PayPeriodInfo payPeriodInfo = this.getPayPeriodInfo();
        long miliseconds = (long)payPeriodInfo.periodDuration * 24L * 60L * 60L * 1000L;
        Timestamp periodStart = new Timestamp(payPeriodInfo.periodEnd.getTime() - miliseconds);
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.prepareStatement("Select * from times where employeeId = ? and (out <= ? and out >= ?) order by out");
            stmt.setString(1, employee.accountingId);
            stmt.setTimestamp(2, payPeriodInfo.periodEnd);
            stmt.setTimestamp(3, periodStart);
            rs = stmt.executeQuery();
            boolean goodTimes = true;
            while (rs.next()) {
                int breakTypeId = rs.getInt("breakTypeId");
                if (!includeBreaks && breakTypeId != 0) continue;
                long id = rs.getInt("id");
                boolean canceled = rs.getBoolean("canceled");
                int payLevel = rs.getInt("payLevel");
                if (rs.wasNull()) {
                    payLevel = 0;
                    if (!canceled) {
                        goodTimes = false;
                    }
                }
                if (!canceled && payLevel < 0) {
                    goodTimes = false;
                }
                Timestamp in = rs.getTimestamp("in");
                Timestamp out = rs.getTimestamp("out");
                Timestamp sent = rs.getTimestamp("sent");
                long total = rs.getInt("total");
                if (in == null || out == null) {
                    if (!canceled) {
                        goodTimes = false;
                    }
                } else {
                    long elapsed = out.getTime() - in.getTime();
                    if (out.getTime() <= payPeriodInfo.periodEnd.getTime()) {
                        if (!canceled && elapsed > 59000L && elapsed < 86400000L) {
                            employee.currentHours += total;
                        } else if (!canceled) {
                            goodTimes = false;
                        }
                    }
                }
                TimeDetail thisTime = new TimeDetail(id, payLevel, in, out, total, sent);
                thisTime.canceled = canceled;
                thisTime.breakTypeId = breakTypeId;
                employee.times.add(thisTime);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void getTimeRangeCompletedDetail(Employee employee, Timestamp startDate, Timestamp endDate) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        employee.currentHours = 0L;
        employee.times = new ArrayList();
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.prepareStatement("SELECT * FROM times WHERE  employeeId = ? and ((out <= ? and out >= ?) or ([in] <=  ? and [in] >= ? )) ORDER BY IIf([in] Is Null, [out], [in])");
            stmt.setString(1, employee.accountingId);
            stmt.setTimestamp(2, endDate);
            stmt.setTimestamp(3, startDate);
            stmt.setTimestamp(4, endDate);
            stmt.setTimestamp(5, startDate);
            rs = stmt.executeQuery();
            boolean goodTimes = true;
            while (rs.next()) {
                long id = rs.getInt("id");
                boolean canceled = rs.getBoolean("canceled");
                int payLevel = rs.getInt("payLevel");
                if (rs.wasNull()) {
                    payLevel = 0;
                    if (!canceled) {
                        goodTimes = false;
                    }
                }
                if (!canceled && payLevel < 0) {
                    goodTimes = false;
                }
                Timestamp in = rs.getTimestamp("in");
                Timestamp out = rs.getTimestamp("out");
                Timestamp sent = rs.getTimestamp("sent");
                long total = rs.getInt("total");
                if (in == null || out == null) {
                    if (!canceled) {
                        goodTimes = false;
                    }
                } else {
                    long elapsed = out.getTime() - in.getTime();
                    if (out.getTime() <= endDate.getTime()) {
                        if (!canceled && elapsed > 59000L && elapsed < 86400000L) {
                            employee.currentHours += total;
                        } else if (!canceled) {
                            goodTimes = false;
                        }
                    }
                }
                TimeDetail thisTime = new TimeDetail(id, payLevel, in, out, total, sent);
                thisTime.canceled = canceled;
                thisTime.breakTypeId = rs.getInt("breakTypeId");
                employee.times.add(thisTime);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public ArrayList getTimesSent() throws Exception {
        ArrayList<Timestamp> timesList = new ArrayList<Timestamp>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            GregorianCalendar start = new GregorianCalendar();
            start.set(2, 0);
            start.set(5, 1);
            start.set(1, 2000);
            long startMiliseconds = start.getTime().getTime();
            stmt = conn.createStatement();
            String query = "Select DISTINCT sent from times order by sent DESC ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                Timestamp thisTime = rs.getTimestamp("sent");
                if (thisTime == null || thisTime.getTime() <= startMiliseconds) continue;
                timesList.add(thisTime);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return timesList;
    }

    @Override
    public ArrayList getEmployeeTimesSent(ArrayList timesSent) throws Exception {
        ArrayList employeeList = new ArrayList();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            employeeList = this.getEmployees();
            stmt = conn.prepareStatement("Select * from times where employeeId = ? and sent = ?");
            int len = employeeList.size();
            for (int i = len - 1; i >= 0; --i) {
                Employee employee = (Employee)employeeList.get(i);
                employee.currentHours = 0L;
                int timesLen = timesSent.size();
                for (int j = 0; j < timesLen; ++j) {
                    Timestamp timeSent = (Timestamp)timesSent.get(j);
                    stmt.setString(1, employee.accountingId);
                    stmt.setTimestamp(2, timeSent);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        long id = rs.getInt("id");
                        int payLevel = rs.getInt("payLevel");
                        if (rs.wasNull()) {
                            payLevel = 0;
                        }
                        Timestamp in = rs.getTimestamp("in");
                        Timestamp out = rs.getTimestamp("out");
                        long total = rs.getInt("total");
                        boolean canceled = rs.getBoolean("canceled");
                        if (!canceled) {
                            employee.currentHours += total;
                        }
                        TimeDetail thisTime = new TimeDetail(id, payLevel, in, out, total, null);
                        thisTime.canceled = canceled;
                        thisTime.breakTypeId = rs.getInt("breakTypeId");
                        if (employee.times == null) {
                            employee.times = new ArrayList();
                        }
                        employee.times.add(thisTime);
                    }
                }
                if (employee.times != null && !employee.times.isEmpty()) continue;
                employeeList.remove(employee);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return employeeList;
    }

    @Override
    public ArrayList getEmployeesTimeFromDateRange(Timestamp startDate, Timestamp endDate) throws Exception {
        ArrayList employeeList = new ArrayList();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Timestamp startTime = startDate;
        Timestamp endTime = endDate;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            employeeList = this.getEmployees();
            stmt = conn.prepareStatement("Select * from times where employeeId = ? and out <= ? and out >= ?");
            int len = employeeList.size();
            for (int i = len - 1; i >= 0; --i) {
                Employee employee = (Employee)employeeList.get(i);
                employee.currentHours = 0L;
                this.core.getEmployeePeriodDetail(employee);
                stmt.setString(1, employee.accountingId);
                stmt.setTimestamp(2, endTime);
                stmt.setTimestamp(3, startTime);
                rs = stmt.executeQuery();
                employee.times = new ArrayList();
                while (rs.next()) {
                    long id = rs.getInt("id");
                    int payLevel = rs.getInt("payLevel");
                    if (rs.wasNull()) {
                        payLevel = 0;
                    }
                    Timestamp in = rs.getTimestamp("in");
                    Timestamp out = rs.getTimestamp("out");
                    long total = rs.getInt("total");
                    boolean canceled = rs.getBoolean("canceled");
                    if (!canceled) {
                        employee.currentHours += total;
                    }
                    TimeDetail thisTime = new TimeDetail(id, payLevel, in, out, total, null);
                    thisTime.canceled = canceled;
                    thisTime.breakTypeId = rs.getInt("breakTypeId");
                    if (employee.times == null) {
                        employee.times = new ArrayList();
                    }
                    if (in == null || out == null || !in.after(startTime) || !in.before(endTime) || !out.after(startTime) || !out.before(endTime)) continue;
                    employee.times.add(thisTime);
                }
                if (employee.times != null && !employee.times.isEmpty()) continue;
                employeeList.remove(employee);
            }
        }
        catch (Exception e) {
            String test = e.toString();
            System.out.println(test);
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return employeeList;
    }

    @Override
    public void getEmployeeTimesSent(Employee employee) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.prepareStatement("Select * from times where employeeId = ? and sent IS NOT NULL");
            stmt.setString(1, employee.accountingId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long id = rs.getInt("id");
                int payLevel = rs.getInt("payLevel");
                if (rs.wasNull()) {
                    payLevel = 0;
                }
                Timestamp in = rs.getTimestamp("in");
                Timestamp out = rs.getTimestamp("out");
                long total = rs.getInt("total");
                boolean canceled = rs.getBoolean("canceled");
                if (!canceled) {
                    employee.currentHours += total;
                }
                TimeDetail thisTime = new TimeDetail(id, payLevel, in, out, total, null);
                thisTime.canceled = canceled;
                thisTime.breakTypeId = rs.getInt("breakTypeId");
                if (employee.times == null) {
                    employee.times = new ArrayList();
                }
                employee.times.add(thisTime);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public ArrayList getBreaks() throws Exception {
        ArrayList<BreakInfo> breaks = new ArrayList<BreakInfo>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                ArrayList<BreakInfo> arrayList = breaks;
                return arrayList;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("Select * from Breaks order by id");
            while (rs.next()) {
                BreakInfo breakInfo = new BreakInfo();
                breakInfo.id = rs.getInt("Id");
                breakInfo.type = rs.getString("breakType");
                breakInfo.appliesAfter = rs.getInt("appliesAfter");
                breakInfo.breakTime = rs.getInt("breakTime");
                breakInfo.minimumTime = rs.getInt("breakMinimum");
                breakInfo.isPaid = rs.getBoolean("breakPaid");
                breakInfo.textColor = rs.getString("textColor");
                breaks.add(breakInfo);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return breaks;
    }

    @Override
    public void removeBreak(int id) throws Exception {
        Connection conn = null;
        try (Statement stmt = null;){
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.prepareStatement("Delete from Breaks where Id = ?");
            stmt.setInt(1, id);
            stmt.executeUpdate();
        }
    }

    @Override
    public void updateBreaks(ArrayList breaksList) throws Exception {
        Connection conn = this.getDatabaseConnection();
        PreparedStatement insertStmt = null;
        PreparedStatement updateStmt = null;
        PreparedStatement searchStmt = null;
        ResultSet rs = null;
        insertStmt = conn.prepareStatement("INSERT INTO Breaks (\"breakType\",\"appliesAfter\",\"breakTime\",\"breakMinimum\",\"breakPaid\",\"textColor\") values (?, ?, ?, ?, ?, ?)");
        updateStmt = conn.prepareStatement("UPDATE Breaks SET breakType = ?, appliesAfter = ? ,breakTime = ?, breakMinimum = ?, breakPaid = ?, textColor = ? WHERE [Id] = ?");
        searchStmt = conn.prepareStatement("SELECT * from Breaks WHERE [Id] = ?");
        int len = breaksList.size();
        for (int i = 0; i < len; ++i) {
            BreakInfo breakInfo = (BreakInfo)breaksList.get(i);
            searchStmt.clearParameters();
            searchStmt.setInt(1, breakInfo.id);
            rs = searchStmt.executeQuery();
            if (rs.next()) {
                updateStmt.setString(1, breakInfo.type);
                updateStmt.setInt(2, breakInfo.appliesAfter);
                updateStmt.setInt(3, breakInfo.breakTime);
                updateStmt.setInt(4, breakInfo.minimumTime);
                updateStmt.setBoolean(5, breakInfo.isPaid);
                updateStmt.setString(6, breakInfo.textColor);
                updateStmt.setInt(7, breakInfo.id);
                updateStmt.executeUpdate();
            } else {
                insertStmt.clearParameters();
                insertStmt.setString(1, breakInfo.type);
                insertStmt.setInt(2, breakInfo.appliesAfter);
                insertStmt.setInt(3, breakInfo.breakTime);
                insertStmt.setInt(4, breakInfo.minimumTime);
                insertStmt.setBoolean(5, breakInfo.isPaid);
                insertStmt.setString(6, breakInfo.textColor);
                insertStmt.executeUpdate();
            }
            this.core.updateHostSyncStatus("Breaks", true);
            continue;
        }
        if (rs != null) {
            rs.close();
        }
        if (searchStmt != null) {
            searchStmt.close();
        }
        if (insertStmt != null) {
            insertStmt.close();
        }
        if (updateStmt != null) {
            updateStmt.close();
        }
    }

    @Override
    public void deleteEmployeeTime(long timeId) throws Exception {
        Connection conn = null;
        try (Statement stmt = null;){
            conn = this.getDatabaseConnection();
            if (conn == null) {
                return;
            }
            stmt = conn.prepareStatement("Delete from times where Id = ?");
            stmt.setInt(1, (int)timeId);
            stmt.executeUpdate();
        }
    }

    @Override
    public POSDataContainer getHolidays(Timestamp startDate, Timestamp endDate) throws Exception {
        POSDataContainer holidays = new POSDataContainer();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                POSDataContainer pOSDataContainer = holidays;
                return pOSDataContainer;
            }
            stmt = conn.prepareStatement("SELECT * FROM Holidays WHERE [Start] >= ? AND [End] <= ?");
            stmt.setTimestamp(1, startDate);
            stmt.setTimestamp(2, endDate);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Holiday holyday = new Holiday();
                holyday.id = rs.getInt("Id");
                holyday.description = rs.getString("Description");
                holyday.type = rs.getString("Type");
                holyday.group = rs.getString("Group");
                holyday.start = rs.getTimestamp("Start");
                holyday.end = rs.getTimestamp("End");
                holidays.add(holyday);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return holidays;
    }

    @Override
    public boolean updateHolidays(POSDataContainer holidays) throws Exception {
        Connection conn = null;
        Statement insertStmt = null;
        Statement updateStmt = null;
        ResultSet rs = null;
        boolean success = true;
        try {
            conn = this.getDatabaseConnection();
            if (conn == null) {
                boolean bl = false;
                return bl;
            }
            int size = holidays.size();
            insertStmt = conn.prepareStatement("INSERT INTO Holidays ([Description], [Start], [End], [Type], [Group]) values (?, ?, ?, ?, ?)");
            updateStmt = conn.prepareStatement("UPDATE Holidays SET [Description] = ?, [Start] = ? ,[End] = ?, [Type] = ?, [Group] = ? WHERE [Id] = ?");
            for (int i = 0; i < size; ++i) {
                Holiday holiday = (Holiday)holidays.get(i);
                if (holiday.id > 0) {
                    updateStmt.clearParameters();
                    updateStmt.setString(1, holiday.description);
                    updateStmt.setTimestamp(2, holiday.start);
                    updateStmt.setTimestamp(3, holiday.end);
                    updateStmt.setString(4, holiday.type);
                    updateStmt.setString(5, holiday.group);
                    updateStmt.setInt(6, holiday.id);
                    success = success && updateStmt.executeUpdate() == 1;
                    continue;
                }
                insertStmt.clearParameters();
                insertStmt.setString(1, holiday.description);
                insertStmt.setTimestamp(2, holiday.start);
                insertStmt.setTimestamp(3, holiday.end);
                insertStmt.setString(4, holiday.type);
                insertStmt.setString(5, holiday.group);
                success = success && insertStmt.executeUpdate() == 1;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (insertStmt != null) {
                insertStmt.close();
            }
            if (updateStmt != null) {
                updateStmt.close();
            }
        }
        return success;
    }

    @Override
    public boolean deleteHolidaysByIds(int[] ids) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        boolean success = false;
        if (ids.length > 0) {
            try {
                conn = this.getDatabaseConnection();
                if (conn == null) {
                    boolean bl = success;
                    return bl;
                }
                int len = ids.length;
                String idsString = "?";
                for (int i = 0; i < len - 1; ++i) {
                    idsString = idsString + ",?";
                }
                String deleteIdsStmt = "DELETE FROM Holidays WHERE [Id] IN (" + idsString + ")";
                stmt = conn.prepareStatement(deleteIdsStmt);
                for (int i = 0; i < len; ++i) {
                    stmt.setInt(i + 1, ids[i]);
                }
                int deletedCount = stmt.executeUpdate();
                success = deletedCount == len;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return success;
    }

    @Override
    public String getTCControlXml() throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        String result = "";
        try {
            Connection conn = this.getDatabaseConnection();
            if (conn == null) {
                String string = null;
                return string;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM TCcontrol");
            if (rs.next()) {
                String companyCode = rs.getString("companyCode");
                if (rs.wasNull()) {
                    companyCode = "";
                }
                String databaseVersion = rs.getString("databaseVersion");
                if (rs.wasNull()) {
                    databaseVersion = "";
                }
                String serialNumber = rs.getString("serialNumber");
                if (rs.wasNull()) {
                    serialNumber = "";
                }
                String companyName = rs.getString("companyName");
                if (rs.wasNull()) {
                    companyName = "";
                }
                String companyAddress1 = rs.getString("companyAddress1");
                if (rs.wasNull()) {
                    companyAddress1 = "";
                }
                String companyAddress2 = rs.getString("companyAddress2");
                if (rs.wasNull()) {
                    companyAddress2 = "";
                }
                String companyCity = rs.getString("companyCity");
                if (rs.wasNull()) {
                    companyCity = "";
                }
                String companyState = rs.getString("companyState");
                if (rs.wasNull()) {
                    companyState = "";
                }
                String companyZip = rs.getString("companyZip");
                if (rs.wasNull()) {
                    companyZip = "";
                }
                String companyPhone = rs.getString("companyPhone");
                if (rs.wasNull()) {
                    companyPhone = "";
                }
                String companyEmail = rs.getString("companyEmail");
                if (rs.wasNull()) {
                    companyEmail = "";
                }
                String registrationKey = rs.getString("registration");
                if (rs.wasNull()) {
                    registrationKey = "";
                }
                String siteName = rs.getString("siteName");
                if (rs.wasNull()) {
                    siteName = "";
                }
                Timestamp periodEnd = rs.getTimestamp("PeriodEnd");
                if (rs.wasNull()) {
                    periodEnd = null;
                }
                int periodDuration = rs.getInt("PeriodDuration");
                String weekStartDay = rs.getString("WeekStartDay");
                if (rs.wasNull()) {
                    weekStartDay = "";
                }
                String weekEndDay = rs.getString("WeekEndDay");
                if (rs.wasNull()) {
                    weekEndDay = "";
                }
                double hoursBeforeOT = rs.getDouble("hoursBeforeOT");
                String password = rs.getString("access");
                if (rs.wasNull()) {
                    password = "";
                }
                String payLevel1 = rs.getString("payLevel1");
                if (rs.wasNull()) {
                    payLevel1 = "";
                }
                String payLevel2 = rs.getString("payLevel2");
                if (rs.wasNull()) {
                    payLevel2 = "";
                }
                String payLevel3 = rs.getString("payLevel3");
                if (rs.wasNull()) {
                    payLevel3 = "";
                }
                String payLevel4 = rs.getString("payLevel4");
                if (rs.wasNull()) {
                    payLevel4 = "";
                }
                String payLevel5 = rs.getString("payLevel5");
                if (rs.wasNull()) {
                    payLevel5 = "";
                }
                String payLevel6 = rs.getString("payLevel6");
                if (rs.wasNull()) {
                    payLevel6 = "";
                }
                String payLevel7 = rs.getString("payLevel7");
                if (rs.wasNull()) {
                    payLevel7 = "";
                }
                String payLevel8 = rs.getString("payLevel8");
                if (rs.wasNull()) {
                    payLevel8 = "";
                }
                String payLevel9 = rs.getString("payLevel9");
                if (rs.wasNull()) {
                    payLevel9 = "";
                }
                String payLevel10 = rs.getString("payLevel10");
                if (rs.wasNull()) {
                    payLevel10 = "";
                }
                String payLevel11 = rs.getString("payLevel11");
                if (rs.wasNull()) {
                    payLevel11 = "";
                }
                String payLevel12 = rs.getString("payLevel12");
                if (rs.wasNull()) {
                    payLevel12 = "";
                }
                String payLevel13 = rs.getString("payLevel13");
                if (rs.wasNull()) {
                    payLevel13 = "";
                }
                String payLevel14 = rs.getString("payLevel14");
                if (rs.wasNull()) {
                    payLevel14 = "";
                }
                String payLevel15 = rs.getString("payLevel15");
                if (rs.wasNull()) {
                    payLevel15 = "";
                }
                String payLevel16 = rs.getString("payLevel16");
                if (rs.wasNull()) {
                    payLevel16 = "";
                }
                String payLevel17 = rs.getString("payLevel17");
                if (rs.wasNull()) {
                    payLevel17 = "";
                }
                String payLevel18 = rs.getString("payLevel18");
                if (rs.wasNull()) {
                    payLevel18 = "";
                }
                String payLevel19 = rs.getString("payLevel19");
                if (rs.wasNull()) {
                    payLevel19 = "";
                }
                String payLevel20 = rs.getString("payLevel20");
                if (rs.wasNull()) {
                    payLevel20 = "";
                }
                result = "<TCControl>";
                result = result + "<CompanyCode>" + companyCode + "</CompanyCode>";
                result = result + "<DatabaseVersion>" + databaseVersion + "</DatabaseVersion>>";
                result = result + "<SerialNumber>" + serialNumber + "</SerialNumber>";
                result = result + "<CompanyName>" + companyName + "</CompanyName>";
                result = result + "<CompanyAddress1>" + companyAddress1 + "</CompanyAddress1>";
                result = result + "<CompanyAddress2>" + companyAddress2 + "</CompanyAddress2>";
                result = result + "<CompanyCity>" + companyCity + "</CompanyCity>";
                result = result + "<CompanyState>" + companyState + "</CompanyState>";
                result = result + "<CompanyZip>" + companyZip + "</CompanyZip>";
                result = result + "<CompanyPhone>" + companyPhone + "</CompanyPhone>";
                result = result + "<CompanyEmail>" + companyEmail + "</CompanyEmail>";
                result = result + "<Registration>" + registrationKey + "</Registration>";
                result = result + "<SiteName>" + siteName + "</SiteName>";
                if (periodEnd != null) {
                    result = result + "<PeriodEnd>" + periodEnd.getTime() + "</PeriodEnd>";
                }
                result = result + "<PeriodDuration>" + periodDuration + "</PeriodDuration>";
                result = result + "<WeekStartDay>" + weekStartDay + "</WeekStartDay>";
                result = result + "<WeekEndDay>" + weekEndDay + "</WeekEndDay>";
                result = result + "<HoursBeforeOT>" + hoursBeforeOT + "</HoursBeforeOT>";
                result = result + "<Password>" + password + "</Password>";
                result = result + "<PayLevel1>" + payLevel1 + "</PayLevel1>";
                result = result + "<PayLevel2>" + payLevel2 + "</PayLevel2>";
                result = result + "<PayLevel3>" + payLevel3 + "</PayLevel3>";
                result = result + "<PayLevel4>" + payLevel4 + "</PayLevel4>";
                result = result + "<PayLevel5>" + payLevel5 + "</PayLevel5>";
                result = result + "<PayLevel6>" + payLevel6 + "</PayLevel6>";
                result = result + "<PayLevel7>" + payLevel7 + "</PayLevel7>";
                result = result + "<PayLevel8>" + payLevel8 + "</PayLevel8>";
                result = result + "<PayLevel9>" + payLevel9 + "</PayLevel9>";
                result = result + "<PayLevel10>" + payLevel10 + "</PayLevel10>";
                result = result + "<PayLevel11>" + payLevel11 + "</PayLevel11>";
                result = result + "<PayLevel12>" + payLevel12 + "</PayLevel12>";
                result = result + "<PayLevel13>" + payLevel13 + "</PayLevel13>";
                result = result + "<PayLevel14>" + payLevel14 + "</PayLevel14>";
                result = result + "<PayLevel15>" + payLevel15 + "</PayLevel15>";
                result = result + "<PayLevel16>" + payLevel16 + "</PayLevel16>";
                result = result + "<PayLevel17>" + payLevel17 + "</PayLevel17>";
                result = result + "<PayLevel18>" + payLevel18 + "</PayLevel18>";
                result = result + "<PayLevel19>" + payLevel19 + "</PayLevel19>";
                result = result + "<PayLevel20>" + payLevel20 + "</PayLevel20>";
                result = result + "</TCControl>";
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }
}

