/*
 * Decompiled with CFR 0.152.
 */
package AccuServerWebServers;

import AccuServerBase.ReportObject;
import AccuServerBase.ServerCore;
import AccuServerBase.Utility;
import AccuServerBase.WebServerBase;
import POSDataObjects.LineItem;
import POSDataObjects.POSDataContainer;
import POSDataObjects.ReceiptPrintSetup;
import POSDataObjects.Reset;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Till;
import POSDataObjects.Transaction;
import POSDataObjects.TransactionReportOptions;
import POSDataObjects.ValueAddedTax;
import java.net.Socket;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class ZOutPeriodic
implements ReportObject {
    ServerCore core = null;
    Socket socket = null;
    ReceiptPrintSetup companyInfo = null;
    Vector tills = null;
    private String countryCode;
    boolean byReset = false;
    Timestamp fromDate = null;
    Timestamp thruDate = null;
    Reset reset = null;
    String html = "";
    boolean export = true;
    String reportFileName = "";
    boolean hasCompReasons = false;
    boolean showGraphs = false;
    SimpleDateFormat dateFormat = null;
    SimpleDateFormat timeFormat = null;
    DecimalFormat priceFormat = new DecimalFormat("#####0.00;-#####0.00");
    String[] weekDays = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    Till till = null;
    int noSaleCount = 0;
    Vector transactions = null;
    POSDataContainer tenderCodesList;
    String reportLineBlock;
    String tenderDataBlock;
    WebServerBase webserver;
    ReportLine summaryLine;
    ArrayList<ReportLine> reportLines;
    static final String template = "z_out_periodic";
    Comparator<Transaction> compareBySequence = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction trans1, Transaction trans2) {
            if (trans1.sequence > trans2.sequence) {
                return 1;
            }
            if (trans1.sequence < trans2.sequence) {
                return -1;
            }
            return 0;
        }
    };
    Comparator<ReportLine> compareReportLineByDate = new Comparator<ReportLine>(){

        @Override
        public int compare(ReportLine rl1, ReportLine rl2) {
            long date2;
            long date1 = rl1.endDate.getTime();
            if (date1 < (date2 = rl2.endDate.getTime())) {
                return 1;
            }
            if (date1 > date2) {
                return -1;
            }
            return 0;
        }
    };

    public void initialize(ServerCore core, Socket socket, boolean export) {
        this.core = core;
        this.socket = socket;
        this.export = export;
        this.webserver = core.getWebServer();
        this.countryCode = core.getCountry();
    }

    public void setByReset(Reset reset) {
    }

    public void setByDates(Timestamp fromDate, Timestamp thruDate) {
        this.fromDate = fromDate;
        this.thruDate = thruDate;
    }

    public void loadData() {
        TransactionReportOptions reportOptions = new TransactionReportOptions();
        reportOptions.fromDate = this.fromDate;
        reportOptions.thruDate = this.thruDate;
        reportOptions.reset = this.reset;
        this.transactions = this.core.getTransactionData(reportOptions);
        Collections.sort(this.transactions, this.compareBySequence);
        this.companyInfo = this.core.getReceiptPrintSetup();
        this.dateFormat = new SimpleDateFormat(this.webserver.getDateTimeFormat());
        this.timeFormat = new SimpleDateFormat("HH:mm");
        if (this.export) {
            this.html = this.webserver.getTemplateHtml("z_out_periodic.tml");
            this.reportFileName = this.webserver.getReportPath() + template + ".xml";
        } else {
            this.html = this.webserver.getTemplateHtml("z_out_periodic.tmpl");
            this.reportFileName = this.webserver.getReportPath() + template + ".html";
        }
        this.tenderCodesList = new POSDataContainer();
        this.tenderCodesList.addAll((Collection)this.core.getTenderCodesList());
        this.tenderCodesList.add((Object)new TenderCode("cct", this.core.getLiteral("Credit Card Total"), "", "", "", false, 0.0, "", "", "", ""));
        this.tenderCodesList.add((Object)new TenderCode(this.core.getTipsTenderCode(), this.core.getLiteral("Tip"), "", "", "", false, 0.0, "", "", "", ""));
    }

    public boolean getReportHtml() {
        if (this.transactions == null) {
            this.transactions = new Vector();
        }
        String headerBlock = Utility.getDataBlockContents((String)"HeaderBlock", (String)this.html);
        String footerBlock = Utility.getDataBlockContents((String)"FooterBlock", (String)this.html);
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"DateRun", (String)this.dateFormat.format(new Timestamp(System.currentTimeMillis())));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"StartDate", (String)this.dateFormat.format(this.fromDate));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"EndDate", (String)this.dateFormat.format(this.thruDate));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"From", (String)this.core.getLiteral("From"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Through", (String)this.core.getLiteral("Through"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Company Name", (String)this.core.getLiteral("Company Name"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Start Time", (String)this.core.getLiteral("Start Time"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"End Time", (String)this.core.getLiteral("End Time"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Sequence", (String)this.core.getLiteral("Sequence"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Till", (String)this.core.getLiteral("Till"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Subtotal", (String)this.core.getLiteral("Subtotal"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Vat Tax", (String)this.core.getLiteral("Vat Tax"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Check Count", (String)this.core.getLiteral("Check Count"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Avg Check Amount", (String)this.core.getLiteral("Avg Check Amount"));
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Total", (String)this.core.getLiteral("Total"));
        String tenderNameBlock = Utility.getDataBlockContents((String)"TenderNameBlock", (String)headerBlock);
        String reportBlock = Utility.getDataBlockContents((String)"ReportBlock", (String)this.html);
        this.reportLineBlock = Utility.getDataBlockContents((String)"ReportLine", (String)reportBlock);
        this.tenderDataBlock = Utility.getDataBlockContents((String)"TenderDataBlock", (String)this.reportLineBlock);
        String summaryBlock = Utility.getDataBlockContents((String)"SummaryBlock", (String)this.html);
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"Total", (String)this.core.getLiteral("Total"));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"Avg Check Amount", (String)this.core.getLiteral("Avg Check Amount"));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"Check Count", (String)this.core.getLiteral("Check Count"));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"Subtotal", (String)this.core.getLiteral("Subtotal"));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"Vat Tax", (String)this.core.getLiteral("Vat Tax"));
        if (this.companyInfo != null) {
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyName", (String)this.companyInfo.companyName);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyAddress1", (String)this.companyInfo.companyAddress1);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyAddress2", (String)this.companyInfo.companyAddress2);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyCity", (String)this.companyInfo.companyCity);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyState", (String)this.companyInfo.companyState);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyZip", (String)this.companyInfo.companyZip);
        } else {
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyName", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyAddress1", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyAddress2", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyCity", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyState", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyZip", (String)"");
        }
        StringBuilder tenderNamesToWrite = new StringBuilder();
        int tenderCodesSize = this.tenderCodesList.size() - 1;
        if (this.export) {
            for (int i = tenderCodesSize; i > 0; --i) {
                String block = tenderNameBlock;
                String tenderDescription = ((TenderCode)this.tenderCodesList.get((int)i)).description;
                tenderNamesToWrite.append(Utility.replaceDataTag((String)block, (String)"TenderName", (String)tenderDescription));
            }
        }
        headerBlock = Utility.replaceBlock((String)headerBlock, (String)"TenderNameBlock", (String)tenderNamesToWrite.toString());
        summaryBlock = Utility.replaceBlock((String)summaryBlock, (String)"TenderNameBlock", (String)tenderNamesToWrite.toString());
        this.webserver.writeFileNoAppend(this.reportFileName, headerBlock);
        this.tills = this.core.getTillsList();
        int tSize = this.transactions.size();
        ReportLine reportLine = null;
        this.summaryLine = new ReportLine();
        this.summaryLine.vatTaxes = new Hashtable();
        boolean isSecondSequence = false;
        int previousSequence = 0;
        HashMap<String, ReportLine> linesByTill = new HashMap<String, ReportLine>();
        this.reportLines = new ArrayList();
        POSDataContainer vatRecords = this.core.getVatRecords();
        double vatRateIL = 0.0;
        if (this.countryCode.equalsIgnoreCase("IL")) {
            int len = vatRecords.size();
            for (int i = 0; i < len; ++i) {
                ValueAddedTax tax = (ValueAddedTax)vatRecords.get(i);
                if (!tax.code.equals("\u05de\u05e2\u05de")) continue;
                vatRateIL = tax.rate;
            }
        }
        double creditCardsTotal = 0.0;
        double tipsTotal = 0.0;
        double tipsPaid = 0.0;
        boolean hasTransactions = false;
        for (int t = 0; t < tSize; ++t) {
            double taxable = 0.0;
            double nonTaxable = 0.0;
            double vatTax = 0.0;
            double vat1Total = 0.0;
            double vat2Total = 0.0;
            double vatGrossTotal = 0.0;
            Transaction thisTransaction = (Transaction)this.transactions.get(t);
            int thisSequence = thisTransaction.sequence;
            if (thisSequence == 0) continue;
            hasTransactions = true;
            if (!isSecondSequence) {
                previousSequence = thisSequence;
                isSecondSequence = true;
            }
            if (previousSequence != thisSequence) {
                TenderTotal tenderTotal = (TenderTotal)reportLine.tenderTotals.get("cct");
                tenderTotal.total = creditCardsTotal;
                reportLine.tenderTotals.put("cct", tenderTotal);
                creditCardsTotal = 0.0;
                tipsPaid = 0.0;
                tipsTotal = 0.0;
                this.addLinesToList(linesByTill);
            }
            if ((reportLine = (ReportLine)linesByTill.get(thisTransaction.till)) == null) {
                reportLine = new ReportLine();
                linesByTill.put(thisTransaction.till, reportLine);
            }
            reportLine.subtotal += thisTransaction.total;
            ++reportLine.checkCount;
            reportLine.till = thisTransaction.till;
            reportLine.sequence = thisSequence;
            if (reportLine.vatTaxes == null) {
                reportLine.vatTaxes = new Hashtable();
            }
            int tenderLen = thisTransaction.tendering.size();
            int lineItemsSize = thisTransaction.lineItems.size();
            boolean tipsAlreadyIncluded = false;
            for (int n = 0; n < tenderLen; ++n) {
                Tender thisTender = (Tender)thisTransaction.tendering.get(n);
                if (thisTender.status.equalsIgnoreCase("V")) continue;
                TenderTotal tenderTotal = (TenderTotal)reportLine.tenderTotals.get(thisTender.code);
                tenderTotal.total += thisTender.amount;
                if (thisTender.type.equalsIgnoreCase("D")) {
                    creditCardsTotal += thisTender.amount;
                }
                if (this.countryCode.equalsIgnoreCase("IL") && thisTender.status.equalsIgnoreCase("T")) {
                    boolean hasCashTender = false;
                    for (int tt = 0; tt < tenderLen; ++tt) {
                        Tender thisOtherTender = (Tender)thisTransaction.tendering.get(tt);
                        if (thisOtherTender.status.equalsIgnoreCase("T") || !thisOtherTender.type.equalsIgnoreCase("P")) continue;
                        hasCashTender = true;
                        break;
                    }
                    tipsTotal += thisTender.amount * -1.0;
                    if (!hasCashTender) {
                        tipsPaid += thisTender.amount * -1.0;
                    }
                }
                if (!thisTender.type.equalsIgnoreCase("H") && !thisTender.type.equalsIgnoreCase("U") && !thisTender.type.equalsIgnoreCase("T") && !thisTender.type.equalsIgnoreCase("W")) continue;
                double tip = 0.0;
                boolean hasCashTip = false;
                OrdersSummary thisOrdersSummary = (OrdersSummary)reportLine.orders.get(thisTender.code);
                if (thisOrdersSummary == null) {
                    thisOrdersSummary = new OrdersSummary();
                }
                if (tenderLen > 1 && !tipsAlreadyIncluded) {
                    Tender thisTender2;
                    int i;
                    for (i = 0; i < tenderLen; ++i) {
                        thisTender2 = (Tender)thisTransaction.tendering.get(i);
                        if (!thisTender2.status.equals("T")) continue;
                        tip = Math.abs(thisTender2.amount);
                    }
                    if (tip > 0.0) {
                        for (i = 0; i < tenderLen; ++i) {
                            thisTender2 = (Tender)thisTransaction.tendering.get(i);
                            if (thisTender2.type.equals("U") || thisTender2.type.equals("T") || thisTender2.type.equals("W") || thisTender2.type.equalsIgnoreCase("H") || !(thisTender2.amount > tip)) continue;
                            hasCashTip = true;
                        }
                    }
                }
                double amount = hasCashTip ? thisTender.amount : thisTender.amount - tip;
                double subTotal = amount * 100.0 / (100.0 + vatRateIL);
                double vatAmount = amount - subTotal;
                thisOrdersSummary.subTotal += subTotal;
                thisOrdersSummary.vatAmount += vatAmount;
                thisOrdersSummary.description = thisTender.description;
                thisOrdersSummary.total += amount;
                if (tip > 0.0 && !hasCashTip && !tipsAlreadyIncluded) {
                    thisOrdersSummary.tips += tip;
                }
                reportLine.orders.put(thisTender.code, thisOrdersSummary);
                reportLine.orderSummary.subTotal += subTotal;
                reportLine.orderSummary.vatAmount += vatAmount;
                reportLine.orderSummary.total += amount;
                if (tip > 0.0 && !hasCashTip && !tipsAlreadyIncluded) {
                    reportLine.orderSummary.tips += tip;
                }
                if (!(tip > 0.0)) continue;
                tipsAlreadyIncluded = true;
            }
            for (int i = 0; i < lineItemsSize; ++i) {
                ValueAddedTax thisVat;
                ValueAddedTax search;
                int pos;
                LineItem thisLineItem = (LineItem)thisTransaction.lineItems.get(i);
                LineItem thisLine = (LineItem)thisTransaction.lineItems.get(i);
                if (thisLine.status.equalsIgnoreCase("V")) continue;
                VatSummary vatSummary = (VatSummary)reportLine.vatTaxes.get(thisLine.taxCode);
                if (vatSummary == null) {
                    vatSummary = new VatSummary();
                }
                vatSummary.vatCode = thisLine.taxCode;
                vatSummary.vatAmount += thisLine.vatTax1;
                vatSummary.total += thisLine.vatGross;
                vatSummary.subTotal += thisLine.vatGross - thisLine.vatTax1;
                if (vatRecords != null && (pos = vatRecords.indexOf((Object)(search = new ValueAddedTax(0, thisLine.taxCode, "", 0.0, 0.0, false)))) >= 0 && (thisVat = (ValueAddedTax)vatRecords.get(pos)) != null) {
                    vatSummary.vatDescription = thisVat.description;
                }
                reportLine.vatTaxes.put(thisLine.taxCode, vatSummary);
                if (this.countryCode.equals("IL")) {
                    if (thisLine.taxCode.equals("\u05de\u05e2\u05de")) {
                        taxable += thisLineItem.total;
                    } else {
                        nonTaxable += thisLineItem.total;
                    }
                } else if (thisLine.taxable) {
                    taxable += thisLineItem.total;
                } else {
                    nonTaxable += thisLineItem.total;
                }
                vat1Total += thisLineItem.vatTax1;
                vat2Total += thisLineItem.vatTax2;
                vatGrossTotal += thisLineItem.vatGross;
                if (thisLineItem.vatGross < -1.0E-4 || thisLineItem.vatGross > 1.0E-4) {
                    vatTax += thisLineItem.vatGross - thisLineItem.total;
                    continue;
                }
                vatTax += thisLineItem.vatTax1 + thisLineItem.vatTax2;
            }
            reportLine.vatTax += vatTax;
            previousSequence = thisSequence;
        }
        if (hasTransactions) {
            TenderTotal tenderTotal = (TenderTotal)reportLine.tenderTotals.get("cct");
            tenderTotal.total = creditCardsTotal;
            reportLine.tenderTotals.put("cct", tenderTotal);
            this.addLinesToList(linesByTill);
            Collections.sort(this.reportLines, this.compareReportLineByDate);
            for (int i = 0; i < this.reportLines.size(); ++i) {
                ReportLine thisReportLine = this.reportLines.get(i);
                this.writeDayLines(thisReportLine, this.reportLineBlock);
                this.calculateSummary(thisReportLine);
            }
            this.writeSummaryLine(this.summaryLine, summaryBlock);
            this.webserver.writeFileAppend(this.reportFileName, footerBlock);
            return true;
        }
        return false;
    }

    private void calculateSummary(ReportLine reportLine) {
        this.summaryLine.checkCount += reportLine.checkCount;
        for (int tc = this.tenderCodesList.size() - 1; tc > 0; --tc) {
            TenderCode tenderCode = (TenderCode)this.tenderCodesList.get(tc);
            String code = tenderCode.code;
            TenderTotal tenderTotalObject = (TenderTotal)reportLine.tenderTotals.get(code);
            TenderTotal tenderTotalSummary = (TenderTotal)this.summaryLine.tenderTotals.get(code);
            if (tenderTotalObject.total == 0.0) continue;
            if (tenderTotalSummary == null) {
                tenderTotalSummary = new TenderTotal(tenderTotalObject.description);
                this.summaryLine.tenderTotals.put(code, tenderTotalSummary);
            }
            tenderTotalSummary.total += tenderTotalObject.total;
        }
        ArrayList taxList = new ArrayList(reportLine.vatTaxes.values());
        int taxesLen = taxList.size();
        for (int x = 0; x < taxesLen; ++x) {
            VatSummary thisVatDetail = (VatSummary)taxList.get(x);
            VatSummary vatSummary = (VatSummary)this.summaryLine.vatTaxes.get(thisVatDetail.vatCode);
            if (vatSummary == null) {
                vatSummary = new VatSummary();
                vatSummary.vatDescription = thisVatDetail.vatDescription;
                vatSummary.vatCode = thisVatDetail.vatCode;
                this.summaryLine.vatTaxes.put(thisVatDetail.vatCode, vatSummary);
            }
            if (thisVatDetail.vatCode.equals("\u05de\u05e2\u05de")) {
                vatSummary.subTotal += thisVatDetail.subTotal - reportLine.orderSummary.subTotal;
                vatSummary.vatAmount += thisVatDetail.vatAmount - reportLine.orderSummary.vatAmount;
                vatSummary.total += thisVatDetail.total - reportLine.orderSummary.total;
                continue;
            }
            vatSummary.subTotal += thisVatDetail.subTotal;
            vatSummary.vatAmount += thisVatDetail.vatAmount;
            vatSummary.total += thisVatDetail.total;
        }
        ArrayList orderDescriptions = new ArrayList(reportLine.orders.values());
        int orderDescriptionsLen = orderDescriptions.size();
        for (int i = 0; i < orderDescriptionsLen; ++i) {
            OrdersSummary thisOrderDetail = (OrdersSummary)orderDescriptions.get(i);
            OrdersSummary orderSummary = (OrdersSummary)this.summaryLine.orders.get(thisOrderDetail.description);
            if (orderSummary == null) {
                orderSummary = new OrdersSummary();
                orderSummary.description = thisOrderDetail.description;
                this.summaryLine.orders.put(thisOrderDetail.description, orderSummary);
            }
            orderSummary.subTotal += thisOrderDetail.subTotal;
            orderSummary.vatAmount += thisOrderDetail.vatAmount;
            orderSummary.total += thisOrderDetail.total;
        }
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    private void addLinesToList(Map<String, ReportLine> linesByTill) {
        for (int i = 0; i < this.tills.size(); ++i) {
            String tillName = ((Till)this.tills.get((int)i)).name;
            ReportLine rl = linesByTill.get(tillName);
            if (rl == null) continue;
            Reset reset = this.core.getReset(rl.till, rl.sequence);
            if (reset.sequence == 0) continue;
            rl.startDate = reset.start;
            rl.endDate = reset.end;
            this.reportLines.add(rl);
            linesByTill.remove(tillName);
        }
    }

    private void writeDayLines(ReportLine reportLine, String lineBlock) {
        String line = lineBlock;
        line = Utility.replaceDataTag((String)line, (String)"Till", (String)reportLine.till);
        line = Utility.replaceDataTag((String)line, (String)"Sequence", (String)String.valueOf(reportLine.sequence));
        line = Utility.replaceDataTag((String)line, (String)"StartSequence", (String)this.dateFormat.format(reportLine.startDate));
        line = Utility.replaceDataTag((String)line, (String)"EndSequence", (String)this.dateFormat.format(reportLine.endDate));
        line = Utility.replaceDataTag((String)line, (String)"CheckCount", (String)String.valueOf(reportLine.checkCount));
        line = Utility.replaceDataTag((String)line, (String)"AvgCheckAmount", (String)this.priceFormat.format(reportLine.subtotal / (double)reportLine.checkCount));
        StringBuilder sb = new StringBuilder();
        for (int tc = this.tenderCodesList.size() - 1; tc > 0; --tc) {
            String code = ((TenderCode)this.tenderCodesList.get((int)tc)).code;
            TenderTotal tenderTotalObject = (TenderTotal)reportLine.tenderTotals.get(code);
            if (tenderTotalObject.total == 0.0 && !this.export) continue;
            double tenderTotal = tenderTotalObject.total;
            String dataBlock = this.tenderDataBlock;
            if (!this.export) {
                String tenderName = ((TenderCode)this.tenderCodesList.get((int)tc)).description;
                dataBlock = Utility.replaceDataTag((String)dataBlock, (String)"TenderName", (String)tenderName);
            }
            dataBlock = Utility.replaceDataTag((String)dataBlock, (String)"TotalTender", (String)this.priceFormat.format(tenderTotal));
            sb.append(dataBlock);
        }
        String vatDetailBlock = Utility.getDataBlockContents((String)"VATDetailBlock", (String)line);
        ArrayList taxList = new ArrayList(reportLine.vatTaxes.values());
        StringBuilder taxesText = new StringBuilder();
        int taxesLen = taxList.size();
        double total = 0.0;
        double subTotal = 0.0;
        double vatTotal = 0.0;
        for (int x = 0; x < taxesLen; ++x) {
            String thisDetailBlock = vatDetailBlock;
            VatSummary thisVatDetail = (VatSummary)taxList.get(x);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatCode", (String)thisVatDetail.vatCode);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatDescription", (String)thisVatDetail.vatDescription);
            if (thisVatDetail.vatCode.equals("\u05de\u05e2\u05de")) {
                total += thisVatDetail.vatAmount + thisVatDetail.subTotal - reportLine.orderSummary.total;
                subTotal += thisVatDetail.subTotal - reportLine.orderSummary.subTotal;
                vatTotal += thisVatDetail.vatAmount - reportLine.orderSummary.vatAmount;
                thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatTotal", (String)this.priceFormat.format(thisVatDetail.subTotal - reportLine.orderSummary.subTotal));
                thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatAmount", (String)this.priceFormat.format(thisVatDetail.vatAmount - reportLine.orderSummary.vatAmount));
                thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"Total", (String)this.priceFormat.format(thisVatDetail.vatAmount + thisVatDetail.subTotal - reportLine.orderSummary.total));
            } else {
                total += thisVatDetail.vatAmount + thisVatDetail.subTotal;
                subTotal += thisVatDetail.subTotal;
                vatTotal += thisVatDetail.vatAmount;
                thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatTotal", (String)this.priceFormat.format(thisVatDetail.subTotal));
                thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatAmount", (String)this.priceFormat.format(thisVatDetail.vatAmount));
                thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"Total", (String)this.priceFormat.format(thisVatDetail.vatAmount + thisVatDetail.subTotal));
            }
            taxesText.append(thisDetailBlock);
        }
        line = Utility.replaceBlock((String)line, (String)"VATDetailBlock", (String)taxesText.toString());
        line = Utility.replaceDataTag((String)line, (String)"Total", (String)this.priceFormat.format(total));
        line = Utility.replaceDataTag((String)line, (String)"SubTotal", (String)this.priceFormat.format(subTotal));
        line = Utility.replaceDataTag((String)line, (String)"VATTotal", (String)this.priceFormat.format(vatTotal));
        if (this.export) {
            line = Utility.replaceDataTag((String)line, (String)"VatTax", (String)this.priceFormat.format(vatTotal));
        }
        String orderDetailBlock = Utility.getDataBlockContents((String)"OrdersDetailBlock", (String)line);
        ArrayList orderDescription = new ArrayList(reportLine.orders.values());
        StringBuilder ordersText = new StringBuilder();
        int ordersLen = orderDescription.size();
        for (int x = 0; x < ordersLen; ++x) {
            String thisDetailBlock = orderDetailBlock;
            OrdersSummary thisOrderDetail = (OrdersSummary)orderDescription.get(x);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderTips", (String)this.priceFormat.format(thisOrderDetail.tips));
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderDescription", (String)thisOrderDetail.description);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderVatTotal", (String)this.priceFormat.format(thisOrderDetail.subTotal));
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderVatAmount", (String)this.priceFormat.format(thisOrderDetail.vatAmount));
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderTotal", (String)this.priceFormat.format(thisOrderDetail.total + thisOrderDetail.tips));
            ordersText.append(thisDetailBlock);
        }
        line = Utility.replaceBlock((String)line, (String)"OrdersDetailBlock", (String)ordersText.toString());
        line = Utility.replaceDataTag((String)line, (String)"OrdersTotal", (String)this.priceFormat.format(reportLine.orderSummary.total + reportLine.orderSummary.tips));
        line = Utility.replaceDataTag((String)line, (String)"OrdersSubTotal", (String)this.priceFormat.format(reportLine.orderSummary.subTotal));
        line = Utility.replaceDataTag((String)line, (String)"OrdersVATTotal", (String)this.priceFormat.format(reportLine.orderSummary.vatAmount));
        line = Utility.replaceDataTag((String)line, (String)"OrdersTips", (String)this.priceFormat.format(reportLine.orderSummary.tips));
        line = Utility.replaceBlock((String)line, (String)"TenderDataBlock", (String)sb.toString());
        this.webserver.writeFileAppend(this.reportFileName, line);
    }

    private void writeSummaryLine(ReportLine summaryLine, String summaryBlock) {
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"CheckCount", (String)String.valueOf(summaryLine.checkCount));
        summaryBlock = summaryLine.subtotal == 0.0 || summaryLine.checkCount == 0 ? Utility.replaceDataTag((String)summaryBlock, (String)"AvgCheckAmount", (String)"0") : Utility.replaceDataTag((String)summaryBlock, (String)"AvgCheckAmount", (String)this.priceFormat.format(summaryLine.subtotal / (double)summaryLine.checkCount));
        String tenderDataBlock = Utility.getDataBlockContents((String)"TenderDataBlock", (String)summaryBlock);
        StringBuilder sb = new StringBuilder();
        for (int tc = this.tenderCodesList.size() - 1; tc > 0; --tc) {
            String code = ((TenderCode)this.tenderCodesList.get((int)tc)).code;
            TenderTotal tenderTotalObject = (TenderTotal)summaryLine.tenderTotals.get(code);
            if (tenderTotalObject.total == 0.0 && !this.export) continue;
            double tenderTotal = tenderTotalObject.total;
            String dataBlock = tenderDataBlock;
            if (!this.export) {
                String tenderName = ((TenderCode)this.tenderCodesList.get((int)tc)).description;
                dataBlock = Utility.replaceDataTag((String)dataBlock, (String)"TenderName", (String)tenderName);
            }
            sb.append(Utility.replaceDataTag((String)dataBlock, (String)"TotalTender", (String)this.priceFormat.format(tenderTotal)));
        }
        double subTotal = 0.0;
        double vatAmount = 0.0;
        double total = 0.0;
        String vatDetailBlock = Utility.getDataBlockContents((String)"VATDetailBlock", (String)summaryBlock);
        ArrayList taxList = new ArrayList(summaryLine.vatTaxes.values());
        StringBuilder taxesText = new StringBuilder();
        int taxesLen = taxList.size();
        for (int x = 0; x < taxesLen; ++x) {
            String thisDetailBlock = vatDetailBlock;
            VatSummary thisVatDetail = (VatSummary)taxList.get(x);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatCode", (String)thisVatDetail.vatCode);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatDescription", (String)thisVatDetail.vatDescription);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatTotal", (String)this.priceFormat.format(thisVatDetail.subTotal));
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"VatAmount", (String)this.priceFormat.format(thisVatDetail.vatAmount));
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"Total1", (String)this.priceFormat.format(thisVatDetail.total));
            taxesText.append(thisDetailBlock);
            subTotal += thisVatDetail.subTotal;
            vatAmount += thisVatDetail.vatAmount;
            total += thisVatDetail.total;
        }
        summaryBlock = Utility.replaceBlock((String)summaryBlock, (String)"VATDetailBlock", (String)taxesText.toString());
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"Total1", (String)this.priceFormat.format(total));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"Total_", (String)this.priceFormat.format(total));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"SubTotal", (String)this.priceFormat.format(subTotal));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"VATTotal", (String)this.priceFormat.format(vatAmount));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"VatTax", (String)this.priceFormat.format(vatAmount));
        summaryBlock = Utility.replaceBlock((String)summaryBlock, (String)"TenderDataBlock", (String)sb.toString());
        double ordersSubTotal = 0.0;
        double ordersVatAmount = 0.0;
        double ordersTotal = 0.0;
        double ordersTips = 0.0;
        String ordersDetailBlock = Utility.getDataBlockContents((String)"OrdersDetailBlock", (String)summaryBlock);
        ArrayList orderDetails = new ArrayList(summaryLine.orders.values());
        StringBuilder ordersText = new StringBuilder();
        int ordersLen = orderDetails.size();
        for (int x = 0; x < ordersLen; ++x) {
            String thisDetailBlock = ordersDetailBlock;
            OrdersSummary thisVatDetail = (OrdersSummary)orderDetails.get(x);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderDescription", (String)thisVatDetail.description);
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderSubTotal", (String)this.priceFormat.format(thisVatDetail.subTotal));
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderVatAmount", (String)this.priceFormat.format(thisVatDetail.vatAmount));
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderTotal", (String)this.priceFormat.format(thisVatDetail.total));
            thisDetailBlock = Utility.replaceDataTag((String)thisDetailBlock, (String)"OrderTips", (String)this.priceFormat.format(thisVatDetail.tips));
            ordersText.append(thisDetailBlock);
            ordersSubTotal += thisVatDetail.subTotal;
            ordersVatAmount += thisVatDetail.vatAmount;
            ordersTotal += thisVatDetail.total;
            ordersTips += thisVatDetail.tips;
        }
        summaryBlock = Utility.replaceBlock((String)summaryBlock, (String)"VATDetailBlock", (String)ordersText.toString());
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"OrdersTotal", (String)this.priceFormat.format(ordersTotal));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"OrdersSubTotal", (String)this.priceFormat.format(ordersSubTotal));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"OrdersVATTotal", (String)this.priceFormat.format(ordersVatAmount));
        summaryBlock = Utility.replaceDataTag((String)summaryBlock, (String)"OrdersTips", (String)this.priceFormat.format(ordersTips));
        summaryBlock = Utility.replaceBlock((String)summaryBlock, (String)"OrdersDetailBlock", (String)ordersText.toString());
        this.webserver.writeFileAppend(this.reportFileName, summaryBlock);
    }

    private void addToSummary(Map<String, ReportLine> linesByTill, ReportLine summaryLine) {
        for (Map.Entry<String, ReportLine> lineByTill : linesByTill.entrySet()) {
            if (lineByTill.getValue().sequence == 0) continue;
            summaryLine.checkCount += lineByTill.getValue().checkCount;
            int tenderCodesSize = this.tenderCodesList.size();
            for (int i = 0; i < tenderCodesSize; ++i) {
                String tenderCode = ((TenderCode)this.tenderCodesList.get((int)i)).code;
                TenderTotal summaryTenderTotal = (TenderTotal)summaryLine.tenderTotals.get(tenderCode);
                TenderTotal lineTender = (TenderTotal)lineByTill.getValue().tenderTotals.get(tenderCode);
                summaryTenderTotal.total += lineTender.total;
            }
            Hashtable vatTaxes = lineByTill.getValue().vatTaxes;
            ArrayList vatCodes = new ArrayList(vatTaxes.keySet());
            for (int i = 0; i < vatCodes.size(); ++i) {
                String thisVatCode = (String)vatCodes.get(i);
                VatSummary thisVatSummary = (VatSummary)vatTaxes.get(thisVatCode);
                VatSummary vatSummary = (VatSummary)summaryLine.vatTaxes.get(thisVatSummary.vatCode);
                if (vatSummary == null) {
                    vatSummary = new VatSummary();
                    vatSummary.vatCode = thisVatSummary.vatCode;
                    vatSummary.vatDescription = thisVatSummary.vatDescription;
                    summaryLine.vatTaxes.put(thisVatCode, vatSummary);
                }
                vatSummary.subTotal += thisVatSummary.subTotal;
                vatSummary.total += thisVatSummary.total;
                vatSummary.vatAmount += thisVatSummary.vatAmount;
            }
        }
    }

    class OrdersSummary {
        public String description = "";
        public double total = 0.0;
        public double subTotal = 0.0;
        public double vatAmount = 0.0;
        public double tips = 0.0;

        OrdersSummary() {
        }
    }

    private class VatSummary {
        public String vatCode = "";
        public String vatDescription = "";
        public double subTotal = 0.0;
        public double vatAmount = 0.0;
        public double total = 0.0;

        private VatSummary() {
        }
    }

    class TenderTotal {
        public String description;
        public double total;

        public TenderTotal(String tenderDescription) {
            this.description = tenderDescription;
        }
    }

    private class ReportLine
    implements Cloneable {
        public double subtotal;
        public double total;
        public int checkCount;
        public double vatTax;
        public Hashtable tenderTotals = new Hashtable();
        public int sequence;
        public String till;
        private Timestamp startDate;
        private Timestamp endDate;
        Hashtable vatTaxes;
        Hashtable orders = new Hashtable();
        OrdersSummary orderSummary = new OrdersSummary();

        public ReportLine() {
            int tenderCodesSize = ZOutPeriodic.this.tenderCodesList.size();
            for (int i = 0; i < tenderCodesSize; ++i) {
                TenderCode tender = (TenderCode)ZOutPeriodic.this.tenderCodesList.get(i);
                this.tenderTotals.put(tender.code, new TenderTotal(tender.description));
            }
        }
    }
}

