/*
 * Decompiled with CFR 0.152.
 */
package AccuServerWebServers;

import AccuServerBase.CustomerReportObject;
import AccuServerBase.ServerCore;
import AccuServerBase.Utility;
import POSDataObjects.Customer;
import POSDataObjects.ReceiptPrintSetup;
import POSDataObjects.Reset;
import POSDataObjects.Tender;
import POSDataObjects.Transaction;
import POSDataObjects.TransactionReportOptions;
import java.io.IOException;
import java.net.Socket;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class AccountReceivablesByDateRange
implements CustomerReportObject {
    ServerCore core = null;
    Socket socket = null;
    ReceiptPrintSetup companyInfo = null;
    Vector transactions = null;
    boolean byReset = false;
    Timestamp fromDate = null;
    Timestamp thruDate = null;
    Reset reset = null;
    String html = "";
    boolean export = false;
    String reportFileName = "";
    String customerCode = "";
    static final String template = "account_receivables_by_date_range";

    public void initialize(ServerCore core, Socket socket, boolean export) {
        this.core = core;
        this.socket = socket;
        this.export = export;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setByReset(Reset thisReset) {
        this.reset = thisReset;
        this.byReset = true;
    }

    public void setByDates(Timestamp fromDate, Timestamp thruDate) {
        this.fromDate = fromDate;
        this.thruDate = thruDate;
        this.byReset = false;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void loadData() {
        this.companyInfo = this.core.getReceiptPrintSetup();
        TransactionReportOptions reportOptions = new TransactionReportOptions();
        reportOptions.fromDate = this.fromDate;
        reportOptions.thruDate = this.thruDate;
        reportOptions.reset = this.reset;
        this.transactions = this.core.getTransactionData(reportOptions);
    }

    public boolean getReportHtml() {
        DecimalFormat priceFormat = null;
        String errors = "";
        if (this.transactions == null || this.transactions.isEmpty()) {
            this.transactions = new Vector();
        }
        if (this.export) {
            this.html = this.core.getWebServer().getTemplateHtml("account_receivables_by_date_range.tml");
            String reportStylesXml = this.core.getWebServer().getReportStylesXml();
            this.html = Utility.replaceDataTag((String)this.html, (String)"ReportStylesBlock", (String)reportStylesXml);
        } else {
            this.html = this.core.getWebServer().getTemplateHtml("account_receivables_by_date_range.tmpl");
        }
        if (this.html == null) {
            return false;
        }
        this.companyInfo = this.core.getReceiptPrintSetup();
        if (this.companyInfo != null) {
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyName", (String)this.companyInfo.companyName);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress1", (String)this.companyInfo.companyAddress1);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress2", (String)this.companyInfo.companyAddress2);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyCity", (String)this.companyInfo.companyCity);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyState", (String)this.companyInfo.companyState);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyZip", (String)this.companyInfo.companyZip);
        } else {
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyName", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress1", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress2", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyCity", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyState", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyZip", (String)"");
        }
        SimpleDateFormat titleFormat = new SimpleDateFormat(this.core.getWebServer().getDateFormat());
        String runTime = titleFormat.format(new Date());
        this.html = Utility.replaceDataTag((String)this.html, (String)"DateRun", (String)runTime);
        String ranges = "";
        SimpleDateFormat rangeDate = new SimpleDateFormat(this.core.getWebServer().getDateTimeFormat());
        ranges = this.core.getLiteral("From") + " " + rangeDate.format(this.fromDate) + " " + this.core.getLiteral("Through") + " " + rangeDate.format(this.thruDate);
        this.html = Utility.replaceDataTag((String)this.html, (String)"Range", (String)ranges);
        String customerBlock = Utility.getDataBlockContents((String)"CustomerBlock", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"DateFormat", (String)"");
        this.html = Utility.replaceBlock((String)this.html, (String)"CurrencyFormat", (String)"");
        String priceFormatString = Utility.getDataBlockContents((String)"PriceFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"PriceFormat", (String)"");
        this.html = Utility.replaceBlock((String)this.html, (String)"QuantityFormat", (String)"");
        this.html = Utility.replaceBlock((String)this.html, (String)"TaxableText", (String)"");
        this.html = Utility.replaceBlock((String)this.html, (String)"NontaxableText", (String)"");
        int len = this.transactions.size();
        priceFormat = new DecimalFormat(priceFormatString);
        HashMap<String, CustomerBalance> customersTable = new HashMap<String, CustomerBalance>();
        for (int i = 0; i < len; ++i) {
            Transaction thisTransaction = (Transaction)this.transactions.get(i);
            if (thisTransaction.dateInvoiced == null || thisTransaction.tendering == null || thisTransaction.tendering.size() <= 0) continue;
            for (int t = 0; t < thisTransaction.tendering.size(); ++t) {
                Tender thisTender = (Tender)thisTransaction.tendering.get(t);
                if (!thisTender.type.equals("A")) continue;
                CustomerBalance thisCustomerBalance = (CustomerBalance)customersTable.get(thisTransaction.customerCode);
                if (thisCustomerBalance == null) {
                    thisCustomerBalance = new CustomerBalance(thisTransaction.customerCode);
                }
                thisCustomerBalance.amount += thisTender.amount;
                customersTable.put(thisTransaction.customerCode, thisCustomerBalance);
            }
        }
        StringBuilder sb = new StringBuilder();
        ArrayList customersList = new ArrayList(customersTable.values());
        int len2 = customersList.size();
        for (int i = 0; i < len2; ++i) {
            String thisCustomerBlock = customerBlock;
            CustomerBalance thisCustomerBalance = (CustomerBalance)customersList.get(i);
            thisCustomerBlock = Utility.replaceDataTag((String)thisCustomerBlock, (String)"Code", (String)thisCustomerBalance.customerCode);
            Customer customer = this.core.getCustomerByCode(thisCustomerBalance.customerCode);
            thisCustomerBlock = Utility.replaceDataTag((String)thisCustomerBlock, (String)"Name", (String)(customer.first + " " + customer.last));
            thisCustomerBlock = Utility.replaceDataTag((String)thisCustomerBlock, (String)"Balance", (String)priceFormat.format(thisCustomerBalance.amount));
            sb.append(thisCustomerBlock);
        }
        this.html = Utility.replaceBlock((String)this.html, (String)"CustomerBlock", (String)sb.toString());
        this.html = Utility.replaceDataTag((String)this.html, (String)"Errors", (String)errors);
        if (!this.export) {
            this.core.getWebServer().sendHtmlResponse(this.socket, this.html, true, true);
        }
        this.reportFileName = this.core.getWebServer().getReportPath() + template + ".html";
        if (this.export) {
            this.reportFileName = this.core.getWebServer().getReportPath() + template + ".xml";
        }
        try {
            Utility.writeXml((String)this.reportFileName, (String)this.html);
        }
        catch (IOException ex) {
            this.core.raiseException((Exception)ex);
        }
        return true;
    }

    class CustomerBalance {
        String customerCode;
        double amount;

        public CustomerBalance(String customerCode) {
            this.customerCode = customerCode;
        }
    }
}

