/*
 * Decompiled with CFR 0.152.
 */
package AccuServerMonitor;

import AccuServerBase.ServerCore;
import AccuServerBase.Utility;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SetupDataReceiverScreen
extends JDialog {
    ServerCore core = null;
    int width = 540;
    int height = 360;
    JDialog setupDataDialog = null;
    JPanel downloadPanel = null;
    JTextField inputField1 = null;
    JTextField inputField2 = null;
    private JPanel mainPanel;

    public SetupDataReceiverScreen(ServerCore core) {
        super((Frame)new JFrame(), true);
        this.initComponents();
        this.core = core;
        this.setSize(new Dimension(this.width, this.height));
    }

    public void displayScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Image iconImage = Utility.readImageFromJar((String)"accupos-icon-server.png");
        this.setupDataDialog = new JDialog();
        this.setupDataDialog.setModal(true);
        this.setupDataDialog.setLocationRelativeTo(this);
        this.setupDataDialog.setSize(this.width, this.height);
        this.setupDataDialog.setLocation((screenSize.width - this.width) / 2, (screenSize.height - this.height) / 2);
        this.setupDataDialog.setIconImage(iconImage);
        this.setupDataDialog.setTitle(this.core.getLiteral("AccuServer/AccuPOS Setup"));
        int dialogWidth = this.setupDataDialog.getWidth();
        int dialogHeight = this.setupDataDialog.getHeight();
        int lineHeight = dialogHeight / 10;
        this.downloadPanel = new JPanel();
        this.downloadPanel.setLayout(null);
        this.downloadPanel.setBackground(new Color(43, 43, 43));
        this.setupDataDialog.add(this.downloadPanel);
        JLabel label1 = new JLabel();
        label1.setBounds(0, lineHeight, dialogWidth, lineHeight);
        label1.setHorizontalAlignment(0);
        label1.setFont(new Font("Arial", 1, 20));
        label1.setText(this.core.getLiteral("Your current AccuServer is a Demo version"));
        label1.setForeground(Color.white);
        this.downloadPanel.add(label1);
        JLabel label2 = new JLabel();
        label2.setBounds(0, (int)((double)lineHeight * 2.5), dialogWidth, lineHeight);
        label2.setHorizontalAlignment(0);
        label2.setFont(new Font("Arial", 1, 16));
        label2.setText(this.core.getLiteral("Would you like to download and create your"));
        label2.setForeground(Color.white);
        this.downloadPanel.add(label2);
        JLabel label3 = new JLabel();
        label3.setBounds(0, (int)((double)lineHeight * 3.25), dialogWidth, lineHeight);
        label3.setHorizontalAlignment(0);
        label3.setFont(new Font("Arial", 1, 16));
        label3.setText(this.core.getLiteral("AccuPOS configuration based on Setup Wizard"));
        label3.setForeground(Color.white);
        this.downloadPanel.add(label3);
        JLabel label4 = new JLabel();
        label4.setBounds(0, (int)((double)lineHeight * 4.0), dialogWidth, lineHeight);
        label4.setHorizontalAlignment(0);
        label4.setFont(new Font("Arial", 1, 16));
        label4.setText(this.core.getLiteral("data you have completed?"));
        label4.setForeground(Color.white);
        this.downloadPanel.add(label4);
        try {
            JLabel noButton = new JLabel();
            byte[] imageBytes = this.core.getImage("No.png");
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            noButton.setIcon(new ImageIcon(image));
            noButton.setBounds((int)((double)dialogWidth * 0.15), (int)((double)lineHeight * 6.0), 160, 50);
            this.downloadPanel.add(noButton);
            noButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SetupDataReceiverScreen.this.closeSetupDialog();
                }
            });
            JLabel yesButton = new JLabel();
            imageBytes = this.core.getImage("Yes.png");
            image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            yesButton.setIcon(new ImageIcon(image));
            yesButton.setBounds((int)((double)dialogWidth * 0.55), (int)((double)lineHeight * 6.0), 160, 50);
            this.downloadPanel.add(yesButton);
            yesButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SetupDataReceiverScreen.this.getSetupInputs();
                }
            });
            this.setupDataDialog.setVisible(true);
        }
        catch (IOException ex) {
            this.core.raiseException((Exception)ex);
        }
    }

    private void getSetupInputs() {
        int dialogWidth = this.setupDataDialog.getWidth();
        int dialogHeight = this.setupDataDialog.getHeight();
        int lineHeight = dialogHeight / 10;
        this.downloadPanel.removeAll();
        this.downloadPanel.repaint();
        JLabel title = new JLabel();
        title.setBounds(0, (int)((double)lineHeight * 1.0), dialogWidth, lineHeight);
        title.setHorizontalAlignment(0);
        title.setFont(new Font("Arial", 1, 20));
        title.setText(this.core.getLiteral("Enter your Setup Wizard login info"));
        title.setForeground(Color.white);
        this.downloadPanel.add(title);
        JLabel label1 = new JLabel();
        label1.setBounds(0, (int)((double)lineHeight * 2.75), (int)((double)dialogWidth * 0.4), (int)((double)lineHeight * 0.75));
        label1.setHorizontalAlignment(4);
        label1.setFont(new Font("Arial", 1, 16));
        label1.setText(this.core.getLiteral("Serial Number:"));
        label1.setForeground(Color.white);
        this.downloadPanel.add(label1);
        JLabel label2 = new JLabel();
        label2.setBounds(0, (int)((double)lineHeight * 4.0), (int)((double)dialogWidth * 0.4), (int)((double)lineHeight * 0.75));
        label2.setHorizontalAlignment(4);
        label2.setFont(new Font("Arial", 1, 16));
        label2.setText(this.core.getLiteral("Password:"));
        label2.setForeground(Color.white);
        this.downloadPanel.add(label2);
        this.inputField1 = new JTextField();
        this.inputField1.setBounds((int)((double)dialogWidth * 0.45), (int)((double)lineHeight * 2.75), (int)((double)dialogWidth * 0.35), (int)((double)lineHeight * 0.75));
        this.inputField1.setForeground(Color.black);
        this.inputField1.setMargin(new Insets(0, 5, 0, 0));
        this.inputField1.setFont(new Font("Arial", 1, 16));
        this.downloadPanel.add(this.inputField1);
        this.inputField2 = new JTextField();
        this.inputField2.setBounds((int)((double)dialogWidth * 0.45), (int)((double)lineHeight * 4.0), (int)((double)dialogWidth * 0.35), (int)((double)lineHeight * 0.75));
        this.inputField2.setForeground(Color.black);
        this.inputField2.setMargin(new Insets(0, 5, 0, 0));
        this.inputField2.setFont(new Font("Arial", 1, 16));
        this.downloadPanel.add(this.inputField2);
        try {
            JLabel cancelButton = new JLabel();
            byte[] imageBytes = this.core.getImage("Cancel.png");
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            cancelButton.setIcon(new ImageIcon(image));
            cancelButton.setBounds((int)((double)dialogWidth * 0.15), (int)((double)lineHeight * 6.0), 160, 50);
            this.downloadPanel.add(cancelButton);
            cancelButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SetupDataReceiverScreen.this.closeSetupDialog();
                }
            });
            JLabel acceptButton = new JLabel();
            imageBytes = this.core.getImage("Accept.png");
            image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            acceptButton.setIcon(new ImageIcon(image));
            acceptButton.setBounds((int)((double)dialogWidth * 0.55), (int)((double)lineHeight * 6.0), 160, 50);
            this.downloadPanel.add(acceptButton);
            acceptButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SetupDataReceiverScreen.this.showLoadingData();
                }
            });
        }
        catch (IOException ex) {
            this.core.raiseException((Exception)ex);
        }
        this.inputField1.requestFocusInWindow();
    }

    private void showLoadingData() {
        String serialNumber = this.inputField1.getText().trim();
        String encryptedSerialNumber = new String(Base64.encode(serialNumber.getBytes()));
        String password = this.inputField2.getText().trim();
        String encryptedPassword = new String(Base64.encode(password.getBytes()));
        int dialogWidth = this.setupDataDialog.getWidth();
        int dialogHeight = this.setupDataDialog.getHeight();
        int lineHeight = dialogHeight / 10;
        this.downloadPanel.removeAll();
        this.downloadPanel.repaint();
        JLabel label1 = new JLabel();
        label1.setBounds(0, (int)((double)lineHeight * 2.0), dialogWidth, lineHeight);
        label1.setHorizontalAlignment(0);
        label1.setFont(new Font("Arial", 1, 20));
        label1.setText(this.core.getLiteral("Loading Setup Wizard Data"));
        label1.setForeground(Color.white);
        this.downloadPanel.add(label1);
        JLabel label2 = new JLabel();
        label2.setBounds(0, (int)((double)lineHeight * 4.0), dialogWidth, lineHeight);
        label2.setHorizontalAlignment(0);
        label2.setFont(new Font("Arial", 1, 20));
        label2.setText(this.core.getLiteral("Please wait ..."));
        label2.setForeground(Color.white);
        this.downloadPanel.add(label2);
        this.downloadPanel.repaint();
        SwingUtilities.invokeLater(new LoadSetupData(encryptedSerialNumber, encryptedPassword));
    }

    private void showErrorMessage(String errorType) {
        JLabel label1;
        JLabel title2;
        JLabel title1;
        int dialogWidth = this.setupDataDialog.getWidth();
        int dialogHeight = this.setupDataDialog.getHeight();
        int lineHeight = dialogHeight / 10;
        this.downloadPanel.removeAll();
        this.downloadPanel.repaint();
        if (errorType.equalsIgnoreCase("ConnectError")) {
            title1 = new JLabel();
            title1.setBounds(0, lineHeight, dialogWidth, lineHeight);
            title1.setHorizontalAlignment(0);
            title1.setFont(new Font("Arial", 1, 20));
            title1.setText(this.core.getLiteral("FAILED"));
            title1.setForeground(new Color(240, 130, 160));
            this.downloadPanel.add(title1);
            title2 = new JLabel();
            title2.setBounds(0, lineHeight * 2, dialogWidth, lineHeight);
            title2.setHorizontalAlignment(0);
            title2.setFont(new Font("Arial", 1, 20));
            title2.setText(this.core.getLiteral("to connect to Setup server"));
            title2.setForeground(Color.white);
            this.downloadPanel.add(title2);
            label1 = new JLabel();
            label1.setBounds(0, (int)((double)lineHeight * 3.5), dialogWidth, lineHeight);
            label1.setHorizontalAlignment(0);
            label1.setFont(new Font("Arial", 1, 16));
            label1.setText(this.core.getLiteral("Please contact Tech Support"));
            label1.setForeground(Color.white);
            this.downloadPanel.add(label1);
            JLabel label2 = new JLabel();
            label2.setBounds(0, (int)((double)lineHeight * 4.25), dialogWidth, lineHeight);
            label2.setHorizontalAlignment(0);
            label2.setFont(new Font("Arial", 1, 16));
            label2.setText(this.core.getLiteral("(888) 265-4767"));
            label2.setForeground(Color.white);
            this.downloadPanel.add(label2);
        } else if (errorType.equalsIgnoreCase("SerialNumberError")) {
            title1 = new JLabel();
            title1.setBounds(0, lineHeight, dialogWidth, lineHeight);
            title1.setHorizontalAlignment(0);
            title1.setFont(new Font("Arial", 1, 20));
            title1.setText(this.core.getLiteral("NO SETUP DATA"));
            title1.setForeground(new Color(240, 130, 160));
            this.downloadPanel.add(title1);
            title2 = new JLabel();
            title2.setBounds(0, lineHeight * 2, dialogWidth, lineHeight);
            title2.setHorizontalAlignment(0);
            title2.setFont(new Font("Arial", 1, 20));
            title2.setText(this.core.getLiteral("found for the serial number entered"));
            title2.setForeground(Color.WHITE);
            this.downloadPanel.add(title2);
            label1 = new JLabel();
            label1.setBounds(0, (int)((double)lineHeight * 3.5), dialogWidth, lineHeight);
            label1.setHorizontalAlignment(0);
            label1.setFont(new Font("Arial", 1, 16));
            label1.setText(this.core.getLiteral("Please check the number and enter it again,"));
            label1.setForeground(Color.white);
            this.downloadPanel.add(label1);
            JLabel label2 = new JLabel();
            label2.setBounds(0, (int)((double)lineHeight * 4.25), dialogWidth, lineHeight);
            label2.setHorizontalAlignment(0);
            label2.setFont(new Font("Arial", 1, 16));
            label2.setText(this.core.getLiteral("or contact Tech Support"));
            label2.setForeground(Color.white);
            this.downloadPanel.add(label2);
            JLabel label3 = new JLabel();
            label3.setBounds(0, (int)((double)lineHeight * 5.0), dialogWidth, lineHeight);
            label3.setHorizontalAlignment(0);
            label3.setFont(new Font("Arial", 1, 16));
            label3.setText(this.core.getLiteral("(888) 265-4767"));
            label3.setForeground(Color.white);
            this.downloadPanel.add(label3);
        } else if (errorType.equalsIgnoreCase("PasswordError")) {
            title1 = new JLabel();
            title1.setBounds(0, lineHeight, dialogWidth, lineHeight);
            title1.setHorizontalAlignment(0);
            title1.setFont(new Font("Arial", 1, 20));
            title1.setText(this.core.getLiteral("INCORRECT PASSWORD"));
            title1.setForeground(new Color(240, 130, 160));
            this.downloadPanel.add(title1);
            title2 = new JLabel();
            title2.setBounds(0, lineHeight * 2, dialogWidth, lineHeight);
            title2.setHorizontalAlignment(0);
            title2.setFont(new Font("Arial", 1, 20));
            title2.setText(this.core.getLiteral("for the serial number entered"));
            title2.setForeground(Color.WHITE);
            this.downloadPanel.add(title2);
            label1 = new JLabel();
            label1.setBounds(0, (int)((double)lineHeight * 3.5), dialogWidth, lineHeight);
            label1.setHorizontalAlignment(0);
            label1.setFont(new Font("Arial", 1, 16));
            label1.setText(this.core.getLiteral("Please try entering your password again,"));
            label1.setForeground(Color.white);
            this.downloadPanel.add(label1);
            JLabel label2 = new JLabel();
            label2.setBounds(0, (int)((double)lineHeight * 4.25), dialogWidth, lineHeight);
            label2.setHorizontalAlignment(0);
            label2.setFont(new Font("Arial", 1, 16));
            label2.setText(this.core.getLiteral("or contact Tech Support"));
            label2.setForeground(Color.white);
            this.downloadPanel.add(label2);
            JLabel label3 = new JLabel();
            label3.setBounds(0, (int)((double)lineHeight * 5.0), dialogWidth, lineHeight);
            label3.setHorizontalAlignment(0);
            label3.setFont(new Font("Arial", 1, 16));
            label3.setText(this.core.getLiteral("(888) 265-4767"));
            label3.setForeground(Color.white);
            this.downloadPanel.add(label3);
        } else {
            title1 = new JLabel();
            title1.setBounds(0, lineHeight * 3, dialogWidth, lineHeight);
            title1.setHorizontalAlignment(0);
            title1.setFont(new Font("Arial", 1, 20));
            title1.setText(errorType);
            title1.setForeground(new Color(240, 130, 160));
            this.downloadPanel.add(title1);
        }
        try {
            JLabel okButton = new JLabel();
            byte[] imageBytes = this.core.getImage("Okay.png");
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            okButton.setIcon(new ImageIcon(image));
            okButton.setBounds(dialogWidth / 2 - 80, (int)((double)lineHeight * 6.5), 160, 50);
            this.downloadPanel.add(okButton);
            okButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SetupDataReceiverScreen.this.closeSetupDialog();
                }
            });
        }
        catch (IOException ex) {
            this.core.raiseException((Exception)ex);
        }
    }

    private void showRestartMessage() {
        int dialogWidth = this.setupDataDialog.getWidth();
        int dialogHeight = this.setupDataDialog.getHeight();
        int lineHeight = dialogHeight / 10;
        this.downloadPanel.removeAll();
        this.downloadPanel.repaint();
        JLabel title = new JLabel();
        title.setBounds(0, lineHeight, dialogWidth, lineHeight);
        title.setHorizontalAlignment(0);
        title.setFont(new Font("Arial", 1, 20));
        title.setText(this.core.getLiteral("Import Successful!!!"));
        title.setForeground(Color.white);
        this.downloadPanel.add(title);
        JLabel title1 = new JLabel();
        title1.setBounds(0, (int)((double)lineHeight * 2.5), dialogWidth, lineHeight);
        title1.setHorizontalAlignment(0);
        title1.setFont(new Font("Arial", 1, 16));
        title1.setText(this.core.getLiteral("All Setup configuration data was downloaded successfully."));
        title1.setForeground(Color.white);
        this.downloadPanel.add(title1);
        JLabel title2 = new JLabel();
        title2.setBounds(0, lineHeight * 4, dialogWidth, lineHeight);
        title2.setHorizontalAlignment(0);
        title2.setFont(new Font("Arial", 1, 16));
        title2.setText(this.core.getLiteral("Would you like to restart AccuServer?"));
        title2.setForeground(Color.white);
        this.downloadPanel.add(title2);
        try {
            JLabel noButton = new JLabel();
            byte[] imageBytes = this.core.getImage("No.png");
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            noButton.setIcon(new ImageIcon(image));
            noButton.setBounds((int)((double)dialogWidth * 0.15), (int)((double)lineHeight * 6.0), 160, 50);
            this.downloadPanel.add(noButton);
            noButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SetupDataReceiverScreen.this.closeSetupDialog();
                }
            });
            JLabel yesButton = new JLabel();
            imageBytes = this.core.getImage("Yes.png");
            image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            yesButton.setIcon(new ImageIcon(image));
            yesButton.setBounds((int)((double)dialogWidth * 0.55), (int)((double)lineHeight * 6.0), 160, 50);
            this.downloadPanel.add(yesButton);
            yesButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SetupDataReceiverScreen.this.closeSetupDialog();
                    SetupDataReceiverScreen.this.core.restartAccuServer();
                }
            });
        }
        catch (IOException ex) {
            this.core.raiseException((Exception)ex);
        }
        this.setupDataDialog.setVisible(true);
    }

    private void closeSetupDialog() {
        this.setupDataDialog.setVisible(false);
        this.mainPanel.repaint();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.mainPanel.setPreferredSize(new Dimension(0, 0));
        this.mainPanel.setLayout(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SetupDataReceiverScreen dialog = new SetupDataReceiverScreen(null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class LoadSetupData
    implements Runnable {
        String serialNumber = "";
        String password = "";

        public LoadSetupData(String encryptedSerialNumber, String encryptedPassword) {
            this.serialNumber = encryptedSerialNumber;
            this.password = encryptedPassword;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                SetupDataReceiverScreen.this.core.createSetupData(this.serialNumber, this.password);
                Thread.sleep(1000L);
                String errorMsg = SetupDataReceiverScreen.this.core.getSetupDataMessage();
                if (!errorMsg.isEmpty()) {
                    SetupDataReceiverScreen.this.showErrorMessage(errorMsg);
                } else {
                    SetupDataReceiverScreen.this.showRestartMessage();
                }
            }
            catch (InterruptedException ex) {
                SetupDataReceiverScreen.this.core.raiseException((Exception)ex);
            }
        }
    }
}

