/*
 * Decompiled with CFR 0.152.
 */
package AccuServerMonitor;

import AccuServerBase.ServerCore;
import AccuServerBase.Utility;
import AccuServerMonitor.EditPrinterSetupScreen;
import AccuServerMonitor.PrinterSetupPanel;
import POSDataObjects.POSDataContainer;
import POSDataObjects.PrinterConfigSetup;
import POSDataObjects.TenderCode;
import POSDataObjects.User;
import POSDataObjects.ValueAddedTax;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class ServerConfigScreen
extends JDialog {
    ServerCore core = null;
    BufferedImage backgroundImage = null;
    String configXml = "";
    CompoundBorder editBorder = null;
    Font labelFont = null;
    Font titleFont = null;
    Font editFont = null;
    Font boldFont = null;
    FontMetrics fontMetrics = null;
    JTabbedPane tabbedPane = null;
    boolean loadingData = false;
    boolean restartRequired = false;
    JPanel settingsPanel = null;
    JPanel databasePanel = null;
    JPanel serverOptionsPanel = null;
    JPanel printersPanel = null;
    JPanel outputsPanel = null;
    JPanel cardHandlerPanel = null;
    JPanel optionalPanel = null;
    JPanel accuShiftPanel = null;
    JComboBox countryCodeBox = null;
    JCheckBox autoUpdatesCheckBox = null;
    JCheckBox debugLogCheckBox = null;
    JCheckBox removeFoodServiceCheckBox = null;
    JCheckBox secureLoginCheckBox = null;
    JCheckBox rightToLeftCheckBox = null;
    JCheckBox poweredByAccuPOSCheckBox = null;
    JLabel tipTenderCodeLabel = null;
    JComboBox tipsGLAccountBox = null;
    JButton tipTenderButton = null;
    JPanel tipsTenderPanel = null;
    boolean resetToCashTender = false;
    String tipsTenderCode = "";
    TenderCode currentTipsTender = null;
    JTextField socketPortEdit = null;
    JComboBox taxCalculatorTypeBox = null;
    JCheckBox carryOutNotTaxableCheckBox = null;
    JLabel carryOutTaxCodeLabel = null;
    JComboBox carryOutTaxCodeBox = null;
    JLabel maximumTaxableAmountLabel = null;
    JTextField maximumTaxableAmountEdit = null;
    JComboBox databaseDriverBox = null;
    JTextField databasePathEdit = null;
    JTextField backupPathEdit = null;
    JTextField msAccessPathEdit = null;
    JPanel sqlExpressPanel = null;
    JTextField databaseNameEdit = null;
    JTextField databaseUserEdit = null;
    JTextField databasePasswordEdit = null;
    JTextField databaseHostEdit = null;
    JCheckBox verifyOrdersCheckBox = null;
    JCheckBox clearClosedSalesCustomersCheckBox = null;
    JCheckBox hasCloudDatabaseCheckBox = null;
    JCheckBox oneConnectionCheckBox = null;
    JTextField webServerPortEdit = null;
    JCheckBox webServerSecureCheckBox = null;
    JCheckBox webServerTimeDecimalCheckBox = null;
    JCheckBox webServerShowGraphsCheckBox = null;
    JTextField webServerSessionTimeoutEdit = null;
    JComboBox dateFormatBox = null;
    JComboBox dateTimeFormatBox = null;
    JCheckBox hasNetReportServerCheckBox = null;
    JTextField reportCompanyIdEdit = null;
    JTextField reportStationIdEdit = null;
    JCheckBox hasAd2POSServiceCheckBox = null;
    JTextField ad2MerchantIdEdit = null;
    JCheckBox hasRegionalServersCheckBox = null;
    JCheckBox regionalServerSecureCheckBox = null;
    JTextField regionalServerSyncIntervalEdit = null;
    JCheckBox hasRemoteDisplayCheckBox = null;
    JCheckBox showRemoteDisplayCheckBox = null;
    JTextField remoteDisplayHostEdit = null;
    JCheckBox hasIntegratedRemoteDisplayCheckBox = null;
    JCheckBox logIntegratedRemoteDisplayCheckBox = null;
    JTextField emailSubjectEdit = null;
    JCheckBox emailSignatureCheckBox = null;
    JCheckBox emailExceptionsCheckBox = null;
    JTextField[] emailExceptionsEdit = null;
    JPanel emailExceptionsPanel = null;
    JCheckBox hasCardHandlerCheckBox = null;
    JCheckBox hasGiftCardHandlerCheckBox = null;
    JCheckBox hasCardPostAuthHandlerCheckBox = null;
    JPanel postAuthEmailPanel = null;
    JTextField[] postAuthEmailEdit = null;
    JCheckBox hasCibusCardHandlerCheckBox = null;
    JTextField cibusResIdEdit = null;
    JTextField cibusPosIdEdit = null;
    JCheckBox cibusDebugCheckBox = null;
    JCheckBox hasTenbisCardHandlerCheckBox = null;
    JTextField tenbisUserNameEdit = null;
    JTextField tenbisUserPasswordEdit = null;
    JTextField tenbisResIdEdit = null;
    JTextField tenbisVendorEdit = null;
    JCheckBox tenbisDebugCheckBox = null;
    JCheckBox hasEConduitCardHandlerCheckBox = null;
    JCheckBox eConduitDebugCheckBox = null;
    JCheckBox hasAccountingCheckBox = null;
    JComboBox integratorTypeBox = null;
    JLabel integratorPathLabel = null;
    JTextField integratorPathEdit = null;
    JCheckBox updateItemPricesCheckBox = null;
    JCheckBox skipItemsover20CheckBox = null;
    JCheckBox summarizeCashSalesCheckBox = null;
    JCheckBox updateItemTypesCheckBox = null;
    JCheckBox useAutomatedTaxCheckBox = null;
    JCheckBox hasLoyaltyHandlerCheckBox = null;
    JTextField loyaltyMerchantIdEdit = null;
    JTextField loyaltyLocationEdit = null;
    JTextField loyaltyCompReasonEdit = null;
    JCheckBox hasComoLoyaltyCheckBox = null;
    JTextField comoLoyaltyMerchantIdEdit = null;
    JTextField comoLoyaltyLocationEdit = null;
    JCheckBox useComoCreditsCheckBox = null;
    JCheckBox useComoPointsCheckBox = null;
    JCheckBox hasAccuShiftCheckBox = null;
    JCheckBox accuShiftNGCheckBox = null;
    JComboBox accuShiftDriverBox = null;
    JPanel accuShiftPathPanel = null;
    JTextField accuShiftPathEdit = null;
    JTextField clockPOSPrinterNameEdit = null;
    JTextField clockPrinterNameEdit = null;
    JComboBox clockPrinterPOSTypeBox = null;
    JTextField clockPrinterTemplateEdit = null;
    JTextField clockPrintWidthEdit = null;
    JTextField clockPrintLengthEdit = null;
    JList printerList = null;
    Vector printerSetups = null;
    JList shiftPrinterList = null;
    Vector shiftPrinterSetups = null;
    Vector removePrinterList = null;
    boolean showPoweredByAccuPOS = true;
    boolean poweredByAccuPOSChanged = false;
    static final String[] integratorValues = new String[]{"AccuServerIntegrator", "AccuServerQBOIntegrator", "AccuServerSageLiveIntegrator"};
    private JPanel mainPanel;

    public ServerConfigScreen(Frame parent, boolean modal, ServerCore core) {
        super((Frame)new JFrame(), modal);
        this.initComponents();
        this.core = core;
        try {
            byte[] imageBytes = core.getImage("Server-Config-BACK.jpg");
            this.backgroundImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
            this.setIconImage(this.backgroundImage);
        }
        catch (Exception ex) {
            core.raiseException(ex);
        }
        this.configXml = Utility.getXml((String)"AccuServer.cfg");
    }

    public void displayScreen() {
        final JPasswordField pwdField = new JPasswordField();
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{this.core.getLiteral("Enter Password"), pwdField});
        optionPane.setMessageType(3);
        optionPane.setOptionType(2);
        optionPane.setInitialValue(pwdField);
        JDialog dialog = optionPane.createDialog(this, this.core.getLiteral("User Access"));
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                pwdField.requestFocusInWindow();
            }
        });
        dialog.setVisible(true);
        Integer result = (Integer)optionPane.getValue();
        if (result == 0) {
            String userPwd = new String(pwdField.getPassword());
            User user = this.core.login(userPwd, "", "", "");
            if (user.access > 0L) {
                int IDS_SETTINGS = 64;
                if (((long)IDS_SETTINGS & user.access) == 0L) {
                    JOptionPane.showMessageDialog(this, this.core.getLiteral("You do not have access to update Server Settings"), this.core.getLiteral("User Access"), 2);
                } else {
                    this.loadFields();
                    this.loadData();
                    this.toFront();
                    this.setLocationRelativeTo(null);
                    this.setAlwaysOnTop(true);
                    this.setVisible(true);
                }
            } else {
                JOptionPane.showMessageDialog(this, this.core.getLiteral("Invalid User Login"), this.core.getLiteral("User Access"), 0);
            }
        }
    }

    private void loadFields() {
        this.labelFont = new Font("Arial", 1, 16);
        this.titleFont = new Font("Arial", 1, 20);
        this.editFont = new Font("Arial", 1, 12);
        this.boldFont = new Font("Arial", 1, 12);
        this.editBorder = new CompoundBorder(new LineBorder(Color.darkGray, 1), new EmptyBorder(0, 5, 0, 0));
        int width = this.backgroundImage.getWidth(this);
        int height = this.backgroundImage.getHeight(this);
        this.setSize(new Dimension(width, height));
        this.mainPanel = new BackgroundPanel(this.backgroundImage);
        this.mainPanel.setBounds(0, 0, width, height);
        this.mainPanel.setBorder(new LineBorder(Color.blue, 2));
        this.mainPanel.setLayout(null);
        this.add(this.mainPanel);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBounds(25, (int)((double)height * 0.125), width - 50, (int)((double)height * 0.8));
        this.tabbedPane.setFont(this.labelFont);
        this.mainPanel.add(this.tabbedPane);
        this.settingsPanel = new JPanel();
        this.tabbedPane.addTab("Main Settings", this.settingsPanel);
        this.settingsPanel.setOpaque(true);
        this.settingsPanel.setLayout(null);
        this.databasePanel = new JPanel();
        this.tabbedPane.addTab("Database", this.databasePanel);
        this.databasePanel.setOpaque(true);
        this.databasePanel.setLayout(null);
        this.serverOptionsPanel = new JPanel();
        this.tabbedPane.addTab("Server Options", this.serverOptionsPanel);
        this.serverOptionsPanel.setOpaque(true);
        this.serverOptionsPanel.setLayout(null);
        this.printersPanel = new JPanel();
        this.tabbedPane.addTab("Printers", this.printersPanel);
        this.printersPanel.setOpaque(true);
        this.printersPanel.setLayout(null);
        this.outputsPanel = new JPanel();
        this.tabbedPane.addTab("Outputs", this.outputsPanel);
        this.outputsPanel.setOpaque(true);
        this.outputsPanel.setLayout(null);
        this.cardHandlerPanel = new JPanel();
        this.tabbedPane.addTab("Card Handler", this.cardHandlerPanel);
        this.cardHandlerPanel.setOpaque(true);
        this.cardHandlerPanel.setLayout(null);
        this.optionalPanel = new JPanel();
        this.tabbedPane.addTab("Optional", this.optionalPanel);
        this.optionalPanel.setOpaque(true);
        this.optionalPanel.setLayout(null);
        this.loadSettingsPanel();
        this.loadDatabasePanel();
        this.loadServerOptionsPanel();
        this.loadPrinterPanel();
        this.loadOutputsPanel();
        this.loadCardHandlerPanel();
        this.loadOptionalPanel();
        if (this.core.hasLicenseFor("AccuSHIFT")) {
            this.accuShiftPanel = new JPanel();
            this.tabbedPane.addTab("AccuShift", this.accuShiftPanel);
            this.accuShiftPanel.setOpaque(true);
            this.accuShiftPanel.setLayout(null);
            this.loadAccuShiftPanel();
        }
        ImageIcon buttonImage = new ImageIcon(this.core.getImage("exit-rect-106-but.aci"));
        JButton exitButton = new JButton(buttonImage);
        this.mainPanel.add(exitButton);
        exitButton.setEnabled(true);
        exitButton.setBounds((int)((double)width * 0.85), (int)((double)height * 0.95), 106, 20);
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigScreen.this.saveData();
                ServerConfigScreen.this.exitScreen();
            }
        });
        buttonImage = new ImageIcon(this.core.getImage("cancel-button-106x20.aci"));
        JButton cancelButton = new JButton(buttonImage);
        this.mainPanel.add(cancelButton);
        cancelButton.setEnabled(true);
        cancelButton.setBounds((int)((double)width * 0.7), (int)((double)height * 0.95), 106, 20);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigScreen.this.exitScreen();
            }
        });
        this.invalidate();
        this.repaint();
    }

    private void loadSettingsPanel() {
        int panelWidth = this.tabbedPane.getWidth();
        int panelHeight = this.tabbedPane.getHeight();
        int xOffset = (int)((double)panelWidth * 0.025);
        int yOffset = (int)((double)panelHeight * 0.05);
        JLabel sectionLabel = new JLabel();
        this.settingsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Settings Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        JLabel label = new JLabel();
        this.settingsPanel.add(label);
        label.setText(this.core.getLiteral("Country Code:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        int labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.countryCodeBox = new JComboBox();
        this.settingsPanel.add(this.countryCodeBox);
        this.countryCodeBox.setFont(this.editFont);
        this.countryCodeBox.setBorder(null);
        this.countryCodeBox.setBounds(xOffset + labelWidth + 5, yOffset, 50, 20);
        this.countryCodeBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.35);
        this.autoUpdatesCheckBox = new JCheckBox();
        this.autoUpdatesCheckBox.setContentAreaFilled(false);
        this.autoUpdatesCheckBox.setText(this.core.getLiteral("Auto Updates"));
        this.autoUpdatesCheckBox.setFont(this.editFont);
        this.autoUpdatesCheckBox.setBorder(null);
        this.autoUpdatesCheckBox.setForeground(Color.gray);
        int boxWidth = this.fontMetrics.stringWidth(this.autoUpdatesCheckBox.getText()) + 20;
        this.autoUpdatesCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.settingsPanel.add(this.autoUpdatesCheckBox);
        this.autoUpdatesCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.55);
        this.debugLogCheckBox = new JCheckBox();
        this.debugLogCheckBox.setContentAreaFilled(false);
        this.debugLogCheckBox.setText(this.core.getLiteral("Debug Log"));
        this.debugLogCheckBox.setFont(this.editFont);
        this.debugLogCheckBox.setBorder(null);
        this.debugLogCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.debugLogCheckBox.getText()) + 20;
        this.debugLogCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.settingsPanel.add(this.debugLogCheckBox);
        xOffset = (int)((double)panelWidth * 0.75);
        this.removeFoodServiceCheckBox = new JCheckBox();
        this.removeFoodServiceCheckBox.setContentAreaFilled(false);
        this.removeFoodServiceCheckBox.setText(this.core.getLiteral("Remove FoodService"));
        this.removeFoodServiceCheckBox.setFont(this.editFont);
        this.removeFoodServiceCheckBox.setBorder(null);
        this.removeFoodServiceCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.removeFoodServiceCheckBox.getText()) + 20;
        this.removeFoodServiceCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.settingsPanel.add(this.removeFoodServiceCheckBox);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.secureLoginCheckBox = new JCheckBox();
        this.secureLoginCheckBox.setContentAreaFilled(false);
        this.secureLoginCheckBox.setText(this.core.getLiteral("Has Secure Login"));
        this.secureLoginCheckBox.setFont(this.editFont);
        this.secureLoginCheckBox.setBorder(null);
        this.secureLoginCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.secureLoginCheckBox.getText()) + 20;
        this.secureLoginCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.settingsPanel.add(this.secureLoginCheckBox);
        this.secureLoginCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.35);
        label = new JLabel();
        this.settingsPanel.add(label);
        label.setText(this.core.getLiteral("Tips Tender Code:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.tipTenderCodeLabel = new JLabel();
        this.settingsPanel.add(this.tipTenderCodeLabel);
        this.tipsTenderCode = this.core.getTipsTenderCode();
        if (this.tipsTenderCode == null || this.tipsTenderCode.isEmpty()) {
            this.tipTenderCodeLabel.setText(this.core.getLiteral("Cash"));
        } else {
            TenderCode tenderCode = this.core.getTenderCode(this.tipsTenderCode);
            this.tipTenderCodeLabel.setText(tenderCode.description);
        }
        this.tipTenderCodeLabel.setForeground(Color.gray);
        this.tipTenderCodeLabel.setFont(this.editFont);
        this.tipTenderCodeLabel.setVerticalAlignment(0);
        this.fontMetrics = this.tipTenderCodeLabel.getFontMetrics(this.editFont);
        labelWidth = (int)((double)panelWidth * 0.15);
        this.tipTenderCodeLabel.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset = (int)((double)panelWidth * 0.6);
        this.tipTenderButton = new JButton();
        if (this.tipsTenderCode == null || this.tipsTenderCode.isEmpty()) {
            this.tipTenderButton.setText(this.core.getLiteral("Set Tips Tender Other than Cash"));
        } else {
            this.resetToCashTender = true;
            this.tipTenderButton.setText(this.core.getLiteral("Reset Tips Tender Back to Cash"));
        }
        this.settingsPanel.add(this.tipTenderButton);
        this.tipTenderButton.setBorder(new LineBorder(Color.darkGray, 1));
        this.tipTenderButton.setForeground(Color.black);
        this.tipTenderButton.setFont(this.editFont);
        this.tipTenderButton.setVerticalAlignment(0);
        this.fontMetrics = this.tipTenderButton.getFontMetrics(this.editFont);
        int buttonWidth = (int)((double)panelWidth * 0.3);
        this.tipTenderButton.setBounds(xOffset, yOffset, buttonWidth, 25);
        this.tipTenderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!ServerConfigScreen.this.resetToCashTender) {
                    ServerConfigScreen.this.tipTenderButton.setVisible(false);
                    ServerConfigScreen.this.tipsTenderPanel.setVisible(true);
                } else {
                    ServerConfigScreen.this.tipsTenderCode = "";
                    ServerConfigScreen.this.tipTenderButton.setText(ServerConfigScreen.this.core.getLiteral("Set Tips Tender Other than Cash"));
                    ServerConfigScreen.this.tipTenderCodeLabel.setText(ServerConfigScreen.this.core.getLiteral("Cash"));
                    ServerConfigScreen.this.resetToCashTender = false;
                }
            }
        });
        this.tipsTenderPanel = new JPanel();
        this.tipsTenderPanel.setLayout(null);
        Border grayline = BorderFactory.createLineBorder(Color.gray);
        TitledBorder title = BorderFactory.createTitledBorder(grayline, "Tender GL Account");
        title.setTitleJustification(2);
        title.setTitleFont(this.editFont);
        title.setTitleColor(Color.gray);
        this.tipsTenderPanel.setBorder(title);
        boxWidth = (int)((double)panelWidth * 0.375);
        int boxHeight = (int)((double)panelHeight * 0.2);
        this.tipsTenderPanel.setBounds(xOffset, yOffset - 10, boxWidth, boxHeight);
        this.settingsPanel.add(this.tipsTenderPanel);
        this.tipsTenderPanel.setVisible(false);
        label = new JLabel();
        this.tipsTenderPanel.add(label);
        label.setText(this.core.getLiteral("Select or define a new GL Account and press OK"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(0);
        label.setBounds(0, 20, boxWidth, 20);
        this.tipsGLAccountBox = new JComboBox();
        this.tipsTenderPanel.add(this.tipsGLAccountBox);
        this.tipsGLAccountBox.setFont(this.editFont);
        this.tipsGLAccountBox.setEditable(true);
        this.tipsGLAccountBox.setBorder(null);
        this.tipsGLAccountBox.setBounds((int)((double)boxWidth * 0.15), (int)((double)boxHeight * 0.4), (int)((double)boxWidth * 0.7), 20);
        JButton okButton = new JButton(this.core.getLiteral("OK"));
        this.tipsTenderPanel.add(okButton);
        okButton.setBorder(new LineBorder(Color.darkGray, 1));
        okButton.setForeground(Color.black);
        okButton.setFont(this.editFont);
        okButton.setVerticalAlignment(0);
        buttonWidth = (int)((double)boxWidth * 0.2);
        okButton.setBounds((int)((double)boxWidth * 0.25), (int)((double)boxHeight * 0.675), buttonWidth, 25);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigScreen.this.setTipsTenderCode();
            }
        });
        JButton cancelButton = new JButton(this.core.getLiteral("Cancel"));
        this.tipsTenderPanel.add(cancelButton);
        cancelButton.setBorder(new LineBorder(Color.darkGray, 1));
        cancelButton.setForeground(Color.black);
        cancelButton.setFont(this.editFont);
        cancelButton.setVerticalAlignment(0);
        buttonWidth = (int)((double)boxWidth * 0.2);
        cancelButton.setBounds((int)((double)boxWidth * 0.6), (int)((double)boxHeight * 0.675), buttonWidth, 25);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigScreen.this.tipsTenderPanel.setVisible(false);
                ServerConfigScreen.this.tipTenderButton.setVisible(true);
            }
        });
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.rightToLeftCheckBox = new JCheckBox();
        this.rightToLeftCheckBox.setContentAreaFilled(false);
        this.rightToLeftCheckBox.setText(this.core.getLiteral("Print Reports Right to Left"));
        this.rightToLeftCheckBox.setFont(this.editFont);
        this.rightToLeftCheckBox.setBorder(null);
        this.rightToLeftCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.rightToLeftCheckBox.getText()) + 20;
        this.rightToLeftCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.settingsPanel.add(this.rightToLeftCheckBox);
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.15);
        sectionLabel = new JLabel();
        this.settingsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Socket Settings Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.settingsPanel.add(label);
        label.setText(this.core.getLiteral("Socket Port:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.socketPortEdit = new JTextField();
        this.socketPortEdit.setHorizontalAlignment(2);
        this.settingsPanel.add(this.socketPortEdit);
        this.socketPortEdit.setFont(this.editFont);
        this.socketPortEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.1);
        this.socketPortEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.socketPortEdit.addKeyListener(new MyKeyListener());
        this.socketPortEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.15);
        sectionLabel = new JLabel();
        this.settingsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Tax Calculator Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.settingsPanel.add(label);
        label.setText(this.core.getLiteral("Tax Calculator Type:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        int xOffset2 = xOffset + labelWidth + 5;
        this.taxCalculatorTypeBox = new JComboBox();
        this.settingsPanel.add(this.taxCalculatorTypeBox);
        this.taxCalculatorTypeBox.setFont(this.editFont);
        this.taxCalculatorTypeBox.setBorder(null);
        this.taxCalculatorTypeBox.setBounds(xOffset2, yOffset, 270, 20);
        this.taxCalculatorTypeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (ServerConfigScreen.this.carryOutNotTaxableCheckBox != null && ServerConfigScreen.this.carryOutTaxCodeLabel != null && ServerConfigScreen.this.carryOutTaxCodeBox != null) {
                    String taxCalculator;
                    if (!ServerConfigScreen.this.loadingData) {
                        ServerConfigScreen.this.restartRequired = true;
                    }
                    if ((taxCalculator = (String)ServerConfigScreen.this.taxCalculatorTypeBox.getSelectedItem()).equals("AccuServerTaxCalculator") || taxCalculator.equals("AccuServerTaxCalculatorWithAlternates") || taxCalculator.equals("AccuServerTaxCalculatorWithMaximum")) {
                        ServerConfigScreen.this.carryOutNotTaxableCheckBox.setVisible(true);
                        ServerConfigScreen.this.carryOutTaxCodeLabel.setVisible(false);
                        ServerConfigScreen.this.carryOutTaxCodeBox.setVisible(false);
                        ServerConfigScreen.this.carryOutTaxCodeBox.setSelectedIndex(-1);
                        if (taxCalculator.equals("AccuServerTaxCalculatorWithMaximum")) {
                            ServerConfigScreen.this.maximumTaxableAmountLabel.setVisible(true);
                            ServerConfigScreen.this.maximumTaxableAmountEdit.setVisible(true);
                        } else {
                            ServerConfigScreen.this.maximumTaxableAmountLabel.setVisible(false);
                            ServerConfigScreen.this.maximumTaxableAmountEdit.setVisible(false);
                        }
                    } else {
                        ServerConfigScreen.this.carryOutNotTaxableCheckBox.setVisible(false);
                        ServerConfigScreen.this.carryOutTaxCodeLabel.setVisible(true);
                        ServerConfigScreen.this.carryOutTaxCodeBox.setVisible(true);
                        ServerConfigScreen.this.maximumTaxableAmountLabel.setVisible(false);
                        ServerConfigScreen.this.maximumTaxableAmountEdit.setVisible(false);
                    }
                }
            }
        });
        xOffset = (int)((double)panelWidth * 0.575);
        this.carryOutNotTaxableCheckBox = new JCheckBox();
        this.carryOutNotTaxableCheckBox.setContentAreaFilled(false);
        this.carryOutNotTaxableCheckBox.setText(this.core.getLiteral("Carry Out Not Taxable"));
        this.carryOutNotTaxableCheckBox.setFont(this.editFont);
        this.carryOutNotTaxableCheckBox.setBorder(null);
        this.carryOutNotTaxableCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.carryOutNotTaxableCheckBox.getText()) + 20;
        this.carryOutNotTaxableCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.settingsPanel.add(this.carryOutNotTaxableCheckBox);
        this.carryOutNotTaxableCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.carryOutTaxCodeLabel = new JLabel();
        this.settingsPanel.add(this.carryOutTaxCodeLabel);
        this.carryOutTaxCodeLabel.setText(this.core.getLiteral("Carry Out Tax Code:"));
        this.carryOutTaxCodeLabel.setForeground(Color.gray);
        this.carryOutTaxCodeLabel.setFont(this.editFont);
        this.carryOutTaxCodeLabel.setVerticalAlignment(0);
        this.carryOutTaxCodeLabel.setHorizontalAlignment(4);
        this.fontMetrics = this.carryOutTaxCodeLabel.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(this.carryOutTaxCodeLabel.getText());
        this.carryOutTaxCodeLabel.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.carryOutTaxCodeBox = new JComboBox();
        this.settingsPanel.add(this.carryOutTaxCodeBox);
        this.carryOutTaxCodeBox.setFont(this.editFont);
        this.carryOutTaxCodeBox.setBorder(null);
        this.carryOutTaxCodeBox.setBounds(xOffset, yOffset, 50, 20);
        this.carryOutTaxCodeBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.05);
        this.maximumTaxableAmountLabel = new JLabel();
        this.settingsPanel.add(this.maximumTaxableAmountLabel);
        this.maximumTaxableAmountLabel.setText(this.core.getLiteral("Max Taxable Amount:"));
        this.maximumTaxableAmountLabel.setForeground(Color.gray);
        this.maximumTaxableAmountLabel.setFont(this.editFont);
        this.maximumTaxableAmountLabel.setVerticalAlignment(0);
        this.maximumTaxableAmountLabel.setHorizontalAlignment(4);
        this.fontMetrics = this.maximumTaxableAmountLabel.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(this.maximumTaxableAmountLabel.getText());
        this.maximumTaxableAmountLabel.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.maximumTaxableAmountEdit = new JTextField();
        this.maximumTaxableAmountEdit.setDocument(new JNumberFieldLimit(7));
        this.maximumTaxableAmountEdit.setHorizontalAlignment(2);
        this.settingsPanel.add(this.maximumTaxableAmountEdit);
        this.maximumTaxableAmountEdit.setFont(this.editFont);
        this.maximumTaxableAmountEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.1);
        this.maximumTaxableAmountEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.maximumTaxableAmountEdit.addKeyListener(new MyKeyListener());
        this.maximumTaxableAmountEdit.addFocusListener(new MyFocusListener());
    }

    private void loadDatabasePanel() {
        int panelWidth = this.tabbedPane.getWidth();
        int panelHeight = this.tabbedPane.getHeight();
        int xOffset = (int)((double)panelWidth * 0.025);
        int yOffset = (int)((double)panelHeight * 0.05);
        JLabel sectionLabel = new JLabel();
        this.databasePanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Database Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        JLabel label = new JLabel();
        this.databasePanel.add(label);
        label.setText(this.core.getLiteral("Database Driver:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        int labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        int xOffset2 = xOffset + labelWidth + 5;
        this.databaseDriverBox = new JComboBox();
        this.databasePanel.add(this.databaseDriverBox);
        this.databaseDriverBox.setFont(this.editFont);
        this.databaseDriverBox.setBorder(null);
        this.databaseDriverBox.setBounds(xOffset2, yOffset, 120, 20);
        this.databaseDriverBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (ServerConfigScreen.this.sqlExpressPanel != null) {
                    if (!ServerConfigScreen.this.loadingData) {
                        ServerConfigScreen.this.restartRequired = true;
                    }
                    if (ServerConfigScreen.this.databaseDriverBox.getSelectedItem().equals("SQLExpress")) {
                        ServerConfigScreen.this.sqlExpressPanel.setVisible(true);
                    } else {
                        ServerConfigScreen.this.sqlExpressPanel.setVisible(false);
                    }
                }
            }
        });
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.databasePanel.add(label);
        label.setText(this.core.getLiteral("Database Path:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.databasePathEdit = new JTextField();
        this.databasePathEdit.setHorizontalAlignment(2);
        this.databasePanel.add(this.databasePathEdit);
        this.databasePathEdit.setFont(this.editFont);
        this.databasePathEdit.setBorder(this.editBorder);
        int boxWidth = (int)((double)panelWidth * 0.3);
        this.databasePathEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
        this.databasePathEdit.addKeyListener(new MyKeyListener());
        this.databasePathEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.databasePanel.add(label);
        label.setText(this.core.getLiteral("Backup Path:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.backupPathEdit = new JTextField();
        this.backupPathEdit.setHorizontalAlignment(2);
        this.databasePanel.add(this.backupPathEdit);
        this.backupPathEdit.setFont(this.editFont);
        this.backupPathEdit.setBorder(this.editBorder);
        this.backupPathEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
        this.backupPathEdit.addKeyListener(new MyKeyListener());
        this.backupPathEdit.addFocusListener(new MyFocusListener());
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.databasePanel.add(label);
        label.setText(this.core.getLiteral("MsAccess Path:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.msAccessPathEdit = new JTextField();
        this.msAccessPathEdit.setHorizontalAlignment(2);
        this.databasePanel.add(this.msAccessPathEdit);
        this.msAccessPathEdit.setFont(this.editFont);
        this.msAccessPathEdit.setBorder(this.editBorder);
        this.msAccessPathEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
        this.msAccessPathEdit.addKeyListener(new MyKeyListener());
        this.msAccessPathEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.5);
        yOffset = (int)((double)panelHeight * 0.11);
        this.sqlExpressPanel = new JPanel();
        this.sqlExpressPanel.setLayout(null);
        Border grayline = BorderFactory.createLineBorder(Color.gray);
        TitledBorder title = BorderFactory.createTitledBorder(grayline, "SQL Express Options");
        title.setTitleJustification(2);
        title.setTitleFont(this.editFont);
        title.setTitleColor(Color.gray);
        this.sqlExpressPanel.setBorder(title);
        boxWidth = (int)((double)panelWidth * 0.45);
        int boxHeight = (int)((double)panelHeight * 0.27);
        this.sqlExpressPanel.setBounds(xOffset, yOffset, boxWidth, boxHeight);
        this.databasePanel.add(this.sqlExpressPanel);
        int x = 10;
        int y = 30;
        boxWidth = (int)((double)panelWidth * 0.3);
        label = new JLabel();
        this.sqlExpressPanel.add(label);
        label.setText(this.core.getLiteral("Host:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(x, y, labelWidth, 20);
        label = new JLabel();
        this.sqlExpressPanel.add(label);
        label.setText(this.core.getLiteral("DB Name:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(x, y + 30, labelWidth, 20);
        label = new JLabel();
        this.sqlExpressPanel.add(label);
        label.setText(this.core.getLiteral("User:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(x, y + 60, labelWidth, 20);
        xOffset2 = x + labelWidth + 5;
        label = new JLabel();
        this.sqlExpressPanel.add(label);
        label.setText(this.core.getLiteral("Password:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(x, y + 90, labelWidth, 20);
        xOffset2 = x + labelWidth + 5;
        this.databaseHostEdit = new JTextField();
        this.databaseHostEdit.setHorizontalAlignment(2);
        this.sqlExpressPanel.add(this.databaseHostEdit);
        this.databaseHostEdit.setFont(this.editFont);
        this.databaseHostEdit.setBorder(this.editBorder);
        this.databaseHostEdit.setBounds(xOffset2, y, boxWidth, 20);
        this.databaseHostEdit.addKeyListener(new MyKeyListener());
        this.databaseHostEdit.addFocusListener(new MyFocusListener());
        this.databaseNameEdit = new JTextField();
        this.databaseNameEdit.setHorizontalAlignment(2);
        this.sqlExpressPanel.add(this.databaseNameEdit);
        this.databaseNameEdit.setFont(this.editFont);
        this.databaseNameEdit.setBorder(this.editBorder);
        this.databaseNameEdit.setBounds(xOffset2, y + 30, boxWidth, 20);
        this.databaseNameEdit.addKeyListener(new MyKeyListener());
        this.databaseNameEdit.addFocusListener(new MyFocusListener());
        this.databaseUserEdit = new JTextField();
        this.databaseUserEdit.setHorizontalAlignment(2);
        this.sqlExpressPanel.add(this.databaseUserEdit);
        this.databaseUserEdit.setFont(this.editFont);
        this.databaseUserEdit.setBorder(this.editBorder);
        this.databaseUserEdit.setBounds(xOffset2, y + 60, boxWidth, 20);
        this.databaseUserEdit.addKeyListener(new MyKeyListener());
        this.databaseUserEdit.addFocusListener(new MyFocusListener());
        this.databasePasswordEdit = new JTextField();
        this.databasePasswordEdit.setHorizontalAlignment(2);
        this.sqlExpressPanel.add(this.databasePasswordEdit);
        this.databasePasswordEdit.setFont(this.editFont);
        this.databasePasswordEdit.setBorder(this.editBorder);
        this.databasePasswordEdit.setBounds(xOffset2, y + 90, boxWidth, 20);
        this.databasePasswordEdit.addKeyListener(new MyKeyListener());
        this.databasePasswordEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset = (int)((double)panelHeight * 0.425);
        this.verifyOrdersCheckBox = new JCheckBox();
        this.verifyOrdersCheckBox.setContentAreaFilled(false);
        this.verifyOrdersCheckBox.setText(this.core.getLiteral("Verify Orders"));
        this.verifyOrdersCheckBox.setFont(this.editFont);
        this.verifyOrdersCheckBox.setBorder(null);
        this.verifyOrdersCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.verifyOrdersCheckBox.getText()) + 20;
        this.verifyOrdersCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.databasePanel.add(this.verifyOrdersCheckBox);
        this.verifyOrdersCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.35);
        this.clearClosedSalesCustomersCheckBox = new JCheckBox();
        this.clearClosedSalesCustomersCheckBox.setContentAreaFilled(false);
        this.clearClosedSalesCustomersCheckBox.setText(this.core.getLiteral("Clear Customers On Closed Sales"));
        this.clearClosedSalesCustomersCheckBox.setFont(this.editFont);
        this.clearClosedSalesCustomersCheckBox.setBorder(null);
        this.clearClosedSalesCustomersCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.clearClosedSalesCustomersCheckBox.getText()) + 20;
        this.clearClosedSalesCustomersCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.databasePanel.add(this.clearClosedSalesCustomersCheckBox);
        this.clearClosedSalesCustomersCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.15);
        sectionLabel = new JLabel();
        this.databasePanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Cloud Database Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasCloudDatabaseCheckBox = new JCheckBox();
        this.hasCloudDatabaseCheckBox.setContentAreaFilled(false);
        this.hasCloudDatabaseCheckBox.setText(this.core.getLiteral("Has Cloud Database"));
        this.hasCloudDatabaseCheckBox.setFont(this.editFont);
        this.hasCloudDatabaseCheckBox.setBorder(null);
        this.hasCloudDatabaseCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasCloudDatabaseCheckBox.getText()) + 20;
        this.hasCloudDatabaseCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.databasePanel.add(this.hasCloudDatabaseCheckBox);
        this.hasCloudDatabaseCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.35);
        this.oneConnectionCheckBox = new JCheckBox();
        this.oneConnectionCheckBox.setContentAreaFilled(false);
        this.oneConnectionCheckBox.setText(this.core.getLiteral("Use One Connection"));
        this.oneConnectionCheckBox.setFont(this.editFont);
        this.oneConnectionCheckBox.setBorder(null);
        this.oneConnectionCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.oneConnectionCheckBox.getText()) + 20;
        this.oneConnectionCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.databasePanel.add(this.oneConnectionCheckBox);
        this.oneConnectionCheckBox.addActionListener(new MyActionListener());
    }

    private void loadServerOptionsPanel() {
        int panelWidth = this.tabbedPane.getWidth();
        int panelHeight = this.tabbedPane.getHeight();
        int xOffset = (int)((double)panelWidth * 0.025);
        int yOffset = (int)((double)panelHeight * 0.05);
        JLabel sectionLabel = new JLabel();
        sectionLabel = new JLabel();
        this.serverOptionsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Web Server Management Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        JLabel label = new JLabel();
        this.serverOptionsPanel.add(label);
        label.setText(this.core.getLiteral("Port:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        int labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.webServerPortEdit = new JTextField();
        this.webServerPortEdit.setHorizontalAlignment(2);
        this.serverOptionsPanel.add(this.webServerPortEdit);
        this.webServerPortEdit.setFont(this.editFont);
        this.webServerPortEdit.setBorder(this.editBorder);
        int boxWidth = (int)((double)panelWidth * 0.05);
        this.webServerPortEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.webServerPortEdit.addKeyListener(new MyKeyListener());
        this.webServerPortEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.25);
        this.webServerSecureCheckBox = new JCheckBox();
        this.webServerSecureCheckBox.setContentAreaFilled(false);
        this.webServerSecureCheckBox.setText(this.core.getLiteral("Secure"));
        this.webServerSecureCheckBox.setFont(this.editFont);
        this.webServerSecureCheckBox.setBorder(null);
        this.webServerSecureCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.webServerSecureCheckBox.getText()) + 20;
        this.webServerSecureCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.serverOptionsPanel.add(this.webServerSecureCheckBox);
        this.webServerSecureCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.5);
        this.webServerTimeDecimalCheckBox = new JCheckBox();
        this.webServerTimeDecimalCheckBox.setContentAreaFilled(false);
        this.webServerTimeDecimalCheckBox.setText(this.core.getLiteral("Time Format Decimal"));
        this.webServerTimeDecimalCheckBox.setFont(this.editFont);
        this.webServerTimeDecimalCheckBox.setBorder(null);
        this.webServerTimeDecimalCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.webServerTimeDecimalCheckBox.getText()) + 20;
        this.webServerTimeDecimalCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.serverOptionsPanel.add(this.webServerTimeDecimalCheckBox);
        this.webServerTimeDecimalCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.75);
        this.webServerShowGraphsCheckBox = new JCheckBox();
        this.webServerShowGraphsCheckBox.setContentAreaFilled(false);
        this.webServerShowGraphsCheckBox.setText(this.core.getLiteral("Show Graphs"));
        this.webServerShowGraphsCheckBox.setFont(this.editFont);
        this.webServerShowGraphsCheckBox.setBorder(null);
        this.webServerShowGraphsCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.webServerShowGraphsCheckBox.getText()) + 20;
        this.webServerShowGraphsCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.serverOptionsPanel.add(this.webServerShowGraphsCheckBox);
        this.webServerShowGraphsCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.serverOptionsPanel.add(label);
        label.setText(this.core.getLiteral("Session Timeout (min):"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.webServerSessionTimeoutEdit = new JTextField();
        this.webServerSessionTimeoutEdit.setHorizontalAlignment(2);
        this.serverOptionsPanel.add(this.webServerSessionTimeoutEdit);
        this.webServerSessionTimeoutEdit.setFont(this.editFont);
        this.webServerSessionTimeoutEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.05);
        this.webServerSessionTimeoutEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.webServerSessionTimeoutEdit.addKeyListener(new MyKeyListener());
        this.webServerSessionTimeoutEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.35);
        label = new JLabel();
        this.serverOptionsPanel.add(label);
        label.setText(this.core.getLiteral("Date Format:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.dateFormatBox = new JComboBox();
        this.serverOptionsPanel.add(this.dateFormatBox);
        this.dateFormatBox.setFont(this.editFont);
        this.dateFormatBox.setBorder(null);
        this.dateFormatBox.setBounds(xOffset, yOffset, 120, 20);
        this.dateFormatBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.65);
        label = new JLabel();
        this.serverOptionsPanel.add(label);
        label.setText(this.core.getLiteral("Date/Time Format:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.dateTimeFormatBox = new JComboBox();
        this.serverOptionsPanel.add(this.dateTimeFormatBox);
        this.dateTimeFormatBox.setFont(this.editFont);
        this.dateTimeFormatBox.setBorder(null);
        this.dateTimeFormatBox.setBounds(xOffset, yOffset, 160, 20);
        this.dateTimeFormatBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.125);
        sectionLabel = new JLabel();
        this.serverOptionsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Net Report Server Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasNetReportServerCheckBox = new JCheckBox();
        this.hasNetReportServerCheckBox.setContentAreaFilled(false);
        this.hasNetReportServerCheckBox.setText(this.core.getLiteral("Has Net Report Server"));
        this.hasNetReportServerCheckBox.setFont(this.editFont);
        this.hasNetReportServerCheckBox.setBorder(null);
        this.hasNetReportServerCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasNetReportServerCheckBox.getText()) + 20;
        this.hasNetReportServerCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.serverOptionsPanel.add(this.hasNetReportServerCheckBox);
        this.hasNetReportServerCheckBox.addActionListener(new MyActionListener());
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.serverOptionsPanel.add(label);
        label.setText(this.core.getLiteral("Company ID:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.reportCompanyIdEdit = new JTextField();
        this.reportCompanyIdEdit.setHorizontalAlignment(2);
        this.serverOptionsPanel.add(this.reportCompanyIdEdit);
        this.reportCompanyIdEdit.setFont(this.editFont);
        this.reportCompanyIdEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.25);
        this.reportCompanyIdEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.reportCompanyIdEdit.addKeyListener(new MyKeyListener());
        this.reportCompanyIdEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.5);
        label = new JLabel();
        this.serverOptionsPanel.add(label);
        label.setText(this.core.getLiteral("Station ID:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.reportStationIdEdit = new JTextField();
        this.reportStationIdEdit.setHorizontalAlignment(2);
        this.serverOptionsPanel.add(this.reportStationIdEdit);
        this.reportStationIdEdit.setFont(this.editFont);
        this.reportStationIdEdit.setBorder(this.editBorder);
        this.reportStationIdEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.reportStationIdEdit.addKeyListener(new MyKeyListener());
        this.reportStationIdEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.125);
        sectionLabel = new JLabel();
        this.serverOptionsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("AD2 POS Service Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasAd2POSServiceCheckBox = new JCheckBox();
        this.hasAd2POSServiceCheckBox.setContentAreaFilled(false);
        this.hasAd2POSServiceCheckBox.setText(this.core.getLiteral("Has AD2 POS Service"));
        this.hasAd2POSServiceCheckBox.setFont(this.editFont);
        this.hasAd2POSServiceCheckBox.setBorder(null);
        this.hasAd2POSServiceCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasAd2POSServiceCheckBox.getText()) + 20;
        this.hasAd2POSServiceCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.serverOptionsPanel.add(this.hasAd2POSServiceCheckBox);
        this.hasAd2POSServiceCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.35);
        label = new JLabel();
        this.serverOptionsPanel.add(label);
        label.setText(this.core.getLiteral("Merchant ID:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.ad2MerchantIdEdit = new JTextField();
        this.ad2MerchantIdEdit.setHorizontalAlignment(2);
        this.serverOptionsPanel.add(this.ad2MerchantIdEdit);
        this.ad2MerchantIdEdit.setFont(this.editFont);
        this.ad2MerchantIdEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.15);
        this.ad2MerchantIdEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.ad2MerchantIdEdit.addKeyListener(new MyKeyListener());
        this.ad2MerchantIdEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.125);
        sectionLabel = new JLabel();
        this.serverOptionsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Regional Servers Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasRegionalServersCheckBox = new JCheckBox();
        this.hasRegionalServersCheckBox.setContentAreaFilled(false);
        this.hasRegionalServersCheckBox.setText(this.core.getLiteral("Has Regional Servers"));
        this.hasRegionalServersCheckBox.setFont(this.editFont);
        this.hasRegionalServersCheckBox.setBorder(null);
        this.hasRegionalServersCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasRegionalServersCheckBox.getText()) + 20;
        this.hasRegionalServersCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.serverOptionsPanel.add(this.hasRegionalServersCheckBox);
        this.hasRegionalServersCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.35);
        this.regionalServerSecureCheckBox = new JCheckBox();
        this.regionalServerSecureCheckBox.setContentAreaFilled(false);
        this.regionalServerSecureCheckBox.setText(this.core.getLiteral("Secure"));
        this.regionalServerSecureCheckBox.setFont(this.editFont);
        this.regionalServerSecureCheckBox.setBorder(null);
        this.regionalServerSecureCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.regionalServerSecureCheckBox.getText()) + 20;
        this.regionalServerSecureCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.serverOptionsPanel.add(this.regionalServerSecureCheckBox);
        this.regionalServerSecureCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.55);
        label = new JLabel();
        this.serverOptionsPanel.add(label);
        label.setText(this.core.getLiteral("Sync Interval:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.regionalServerSyncIntervalEdit = new JTextField();
        this.regionalServerSyncIntervalEdit.setHorizontalAlignment(2);
        this.serverOptionsPanel.add(this.regionalServerSyncIntervalEdit);
        this.regionalServerSyncIntervalEdit.setFont(this.editFont);
        this.regionalServerSyncIntervalEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.05);
        this.regionalServerSyncIntervalEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.regionalServerSyncIntervalEdit.addKeyListener(new MyKeyListener());
        this.regionalServerSyncIntervalEdit.addFocusListener(new MyFocusListener());
    }

    private void loadPrinterPanel() {
        int panelWidth = this.tabbedPane.getWidth();
        int panelHeight = this.tabbedPane.getHeight();
        int xOffset = (int)((double)panelWidth * 0.025);
        int yOffset = (int)((double)panelHeight * 0.025);
        JLabel sectionLabel = new JLabel();
        sectionLabel = new JLabel();
        this.printersPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Order Printer Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        JButton newPrinterButton = new JButton("Add New Order Printer");
        this.printersPanel.add(newPrinterButton);
        newPrinterButton.setEnabled(true);
        newPrinterButton.setBounds(xOffset, yOffset += (int)((double)panelHeight * 0.075), (int)((double)panelWidth * 0.2), 25);
        newPrinterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigScreen.this.editOrderPrinterSetup(true);
            }
        });
        xOffset = (int)((double)panelWidth * 0.35);
        this.poweredByAccuPOSCheckBox = new JCheckBox();
        this.poweredByAccuPOSCheckBox.setContentAreaFilled(false);
        this.poweredByAccuPOSCheckBox.setText(this.core.getLiteral("Show Powered By AccuPOS"));
        this.poweredByAccuPOSCheckBox.setFont(this.editFont);
        this.poweredByAccuPOSCheckBox.setBorder(null);
        this.poweredByAccuPOSCheckBox.setForeground(Color.black);
        int boxWidth = this.fontMetrics.stringWidth(this.poweredByAccuPOSCheckBox.getText()) + 20;
        this.poweredByAccuPOSCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.printersPanel.add(this.poweredByAccuPOSCheckBox);
        this.poweredByAccuPOSCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!ServerConfigScreen.this.loadingData) {
                    ServerConfigScreen.this.restartRequired = true;
                }
                ServerConfigScreen.this.showPoweredByAccuPOS = ServerConfigScreen.this.poweredByAccuPOSCheckBox.isSelected();
                ServerConfigScreen.this.poweredByAccuPOSChanged = true;
            }
        });
        xOffset = (int)((double)panelWidth * 0.05);
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(null);
        headerPanel.setBackground(Color.DARK_GRAY);
        headerPanel.setBounds(xOffset, yOffset += (int)((double)panelHeight * 0.05), (int)((double)panelWidth * 0.9), 30);
        headerPanel.setBorder(new LineBorder(Color.BLACK, 1));
        this.printersPanel.add(headerPanel);
        JLabel label = new JLabel();
        headerPanel.add(label);
        label.setText(this.core.getLiteral("Printer Type"));
        label.setForeground(Color.white);
        label.setFont(this.editFont);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        int labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(10, 0, labelWidth, 25);
        xOffset = (int)((double)panelWidth * 0.25);
        label = new JLabel();
        headerPanel.add(label);
        label.setText(this.core.getLiteral("POS Printer Name"));
        label.setForeground(Color.white);
        label.setFont(this.editFont);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset + 10, 0, labelWidth, 25);
        xOffset = (int)((double)panelWidth * 0.5);
        label = new JLabel();
        headerPanel.add(label);
        label.setText(this.core.getLiteral("Printer Name"));
        label.setForeground(Color.white);
        label.setFont(this.editFont);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset + 10, 0, labelWidth, 25);
        label = new JLabel();
        headerPanel.add(label);
        label.setText(this.core.getLiteral("(click on a printer below to edit)"));
        label.setForeground(Color.white);
        label.setFont(this.editFont);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds((int)((double)panelWidth * 0.875) - labelWidth, 0, labelWidth, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BorderLayout());
        borderPanel.setBackground(Color.LIGHT_GRAY);
        borderPanel.setBounds(xOffset, yOffset += (int)((double)panelHeight * 0.05), (int)((double)panelWidth * 0.9), (int)((double)panelHeight * 0.25));
        this.printerList = new JList();
        borderPanel.add((Component)this.printerList, "North");
        this.printerList.setFont(this.editFont);
        this.printerList.setBackground(Color.LIGHT_GRAY);
        this.printerList.setForeground(Color.BLACK);
        this.printerList.setSelectionBackground(Color.yellow);
        this.printerList.setCellRenderer(new MyListCellRenderer(borderPanel.getWidth() - 20));
        this.printerList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ServerConfigScreen.this.editOrderPrinterSetup(false);
            }
        });
        JScrollPane scrollPanel = new JScrollPane(borderPanel);
        scrollPanel.setVerticalScrollBarPolicy(20);
        this.printersPanel.add(scrollPanel);
        scrollPanel.setBounds(xOffset, yOffset, (int)((double)panelWidth * 0.9), (int)((double)panelHeight * 0.25));
        this.setPrinterList();
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset = (int)((double)panelHeight * 0.5);
        sectionLabel = new JLabel();
        sectionLabel = new JLabel();
        this.printersPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Shift Printer Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        JButton newShiftPrinterButton = new JButton("Add New Shift Printer");
        this.printersPanel.add(newShiftPrinterButton);
        newShiftPrinterButton.setEnabled(true);
        newShiftPrinterButton.setBounds(xOffset, yOffset += (int)((double)panelHeight * 0.075), (int)((double)panelWidth * 0.2), 25);
        newShiftPrinterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerConfigScreen.this.editShiftPrinterSetup(true);
            }
        });
        xOffset = (int)((double)panelWidth * 0.05);
        JPanel headerPanel2 = new JPanel();
        headerPanel2.setLayout(null);
        headerPanel2.setBackground(Color.darkGray);
        headerPanel2.setBounds(xOffset, yOffset += (int)((double)panelHeight * 0.05), (int)((double)panelWidth * 0.9), 30);
        headerPanel2.setBorder(new LineBorder(Color.BLACK, 1));
        this.printersPanel.add(headerPanel2);
        label = new JLabel();
        headerPanel2.add(label);
        label.setText(this.core.getLiteral("Printer Type"));
        label.setForeground(Color.white);
        label.setFont(this.editFont);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(10, 0, labelWidth, 25);
        xOffset = (int)((double)panelWidth * 0.25);
        label = new JLabel();
        headerPanel2.add(label);
        label.setText(this.core.getLiteral("POS Printer Name"));
        label.setForeground(Color.white);
        label.setFont(this.editFont);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset + 10, 0, labelWidth, 25);
        xOffset = (int)((double)panelWidth * 0.5);
        label = new JLabel();
        headerPanel2.add(label);
        label.setText(this.core.getLiteral("Printer Name"));
        label.setForeground(Color.white);
        label.setFont(this.editFont);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset + 10, 0, labelWidth, 25);
        label = new JLabel();
        headerPanel2.add(label);
        label.setText(this.core.getLiteral("(click on a printer below to edit)"));
        label.setForeground(Color.white);
        label.setFont(this.editFont);
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(3);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds((int)((double)panelWidth * 0.875) - labelWidth, 0, labelWidth, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        JPanel borderPanel2 = new JPanel();
        borderPanel2.setLayout(new BorderLayout());
        borderPanel2.setBackground(Color.LIGHT_GRAY);
        borderPanel2.setBounds(xOffset, yOffset += (int)((double)panelHeight * 0.05), (int)((double)panelWidth * 0.9), (int)((double)panelHeight * 0.25));
        this.shiftPrinterList = new JList();
        borderPanel2.add((Component)this.shiftPrinterList, "North");
        this.shiftPrinterList.setFont(this.editFont);
        this.shiftPrinterList.setBackground(Color.LIGHT_GRAY);
        this.shiftPrinterList.setForeground(Color.BLACK);
        this.shiftPrinterList.setSelectionBackground(Color.yellow);
        this.shiftPrinterList.setCellRenderer(new MyListCellRenderer(borderPanel2.getWidth() - 20));
        this.shiftPrinterList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ServerConfigScreen.this.editShiftPrinterSetup(false);
            }
        });
        JScrollPane scrollPanel2 = new JScrollPane(borderPanel2);
        scrollPanel2.setVerticalScrollBarPolicy(20);
        this.printersPanel.add(scrollPanel2);
        scrollPanel2.setBounds(xOffset, yOffset, (int)((double)panelWidth * 0.9), (int)((double)panelHeight * 0.25));
        this.setShiftPrinterList();
    }

    private void loadOutputsPanel() {
        JLabel sectionLabel;
        int panelWidth = this.tabbedPane.getWidth();
        int panelHeight = this.tabbedPane.getHeight();
        int xOffset = (int)((double)panelWidth * 0.025);
        int yOffset = (int)((double)panelHeight * 0.025);
        if (this.core.hasLicenseFor("RemoteDisplay")) {
            sectionLabel = new JLabel();
            sectionLabel = new JLabel();
            this.outputsPanel.add(sectionLabel);
            sectionLabel.setText(this.core.getLiteral("Remote Display Options"));
            sectionLabel.setForeground(Color.gray);
            sectionLabel.setFont(this.titleFont);
            sectionLabel.setHorizontalAlignment(2);
            sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
            xOffset = (int)((double)panelWidth * 0.05);
            yOffset += (int)((double)panelHeight * 0.05);
            this.hasRemoteDisplayCheckBox = new JCheckBox();
            this.hasRemoteDisplayCheckBox.setContentAreaFilled(false);
            this.hasRemoteDisplayCheckBox.setText(this.core.getLiteral("Has Remote Display"));
            this.hasRemoteDisplayCheckBox.setFont(this.editFont);
            this.hasRemoteDisplayCheckBox.setBorder(null);
            this.hasRemoteDisplayCheckBox.setForeground(Color.gray);
            int boxWidth = this.fontMetrics.stringWidth(this.hasRemoteDisplayCheckBox.getText()) + 20;
            this.hasRemoteDisplayCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.outputsPanel.add(this.hasRemoteDisplayCheckBox);
            this.hasRemoteDisplayCheckBox.addActionListener(new MyActionListener());
            this.hasRemoteDisplayCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!ServerConfigScreen.this.loadingData) {
                        ServerConfigScreen.this.restartRequired = true;
                    }
                    if (ServerConfigScreen.this.hasIntegratedRemoteDisplayCheckBox != null && ServerConfigScreen.this.hasRemoteDisplayCheckBox.isSelected()) {
                        ServerConfigScreen.this.hasIntegratedRemoteDisplayCheckBox.setSelected(false);
                    }
                }
            });
            xOffset = (int)((double)panelWidth * 0.35);
            this.showRemoteDisplayCheckBox = new JCheckBox();
            this.showRemoteDisplayCheckBox.setContentAreaFilled(false);
            this.showRemoteDisplayCheckBox.setText(this.core.getLiteral("Show Remote Display"));
            this.showRemoteDisplayCheckBox.setFont(this.editFont);
            this.showRemoteDisplayCheckBox.setBorder(null);
            this.showRemoteDisplayCheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.showRemoteDisplayCheckBox.getText()) + 20;
            this.showRemoteDisplayCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.outputsPanel.add(this.showRemoteDisplayCheckBox);
            this.showRemoteDisplayCheckBox.addActionListener(new MyActionListener());
            xOffset = (int)((double)panelWidth * 0.55);
            JLabel label = new JLabel();
            this.outputsPanel.add(label);
            label.setText(this.core.getLiteral("Host:"));
            label.setForeground(Color.gray);
            label.setFont(this.editFont);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(4);
            int labelWidth = this.fontMetrics.stringWidth(label.getText());
            label.setBounds(xOffset, yOffset, labelWidth, 20);
            xOffset += labelWidth + 5;
            this.remoteDisplayHostEdit = new JTextField();
            this.remoteDisplayHostEdit.setHorizontalAlignment(2);
            this.outputsPanel.add(this.remoteDisplayHostEdit);
            this.remoteDisplayHostEdit.setFont(this.editFont);
            this.remoteDisplayHostEdit.setBorder(this.editBorder);
            boxWidth = (int)((double)panelWidth * 0.25);
            this.remoteDisplayHostEdit.setBounds(xOffset, yOffset, boxWidth, 20);
            this.remoteDisplayHostEdit.addKeyListener(new MyKeyListener());
            this.remoteDisplayHostEdit.addFocusListener(new MyFocusListener());
            xOffset = (int)((double)panelWidth * 0.025);
            yOffset += (int)((double)panelHeight * 0.125);
            sectionLabel = new JLabel();
            this.outputsPanel.add(sectionLabel);
            sectionLabel.setText(this.core.getLiteral("Integrated Remote Display Options"));
            sectionLabel.setForeground(Color.gray);
            sectionLabel.setFont(this.titleFont);
            sectionLabel.setHorizontalAlignment(2);
            sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
            xOffset = (int)((double)panelWidth * 0.05);
            yOffset += (int)((double)panelHeight * 0.05);
            this.hasIntegratedRemoteDisplayCheckBox = new JCheckBox();
            this.hasIntegratedRemoteDisplayCheckBox.setContentAreaFilled(false);
            this.hasIntegratedRemoteDisplayCheckBox.setText(this.core.getLiteral("Has Integrated Remote Display"));
            this.hasIntegratedRemoteDisplayCheckBox.setFont(this.editFont);
            this.hasIntegratedRemoteDisplayCheckBox.setBorder(null);
            this.hasIntegratedRemoteDisplayCheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.hasIntegratedRemoteDisplayCheckBox.getText()) + 20;
            this.hasIntegratedRemoteDisplayCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.outputsPanel.add(this.hasIntegratedRemoteDisplayCheckBox);
            this.hasIntegratedRemoteDisplayCheckBox.addActionListener(new MyActionListener());
            this.hasIntegratedRemoteDisplayCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!ServerConfigScreen.this.loadingData) {
                        ServerConfigScreen.this.restartRequired = true;
                    }
                    if (ServerConfigScreen.this.hasRemoteDisplayCheckBox != null && ServerConfigScreen.this.hasIntegratedRemoteDisplayCheckBox.isSelected()) {
                        ServerConfigScreen.this.hasRemoteDisplayCheckBox.setSelected(false);
                    }
                }
            });
            xOffset = (int)((double)panelWidth * 0.35);
            this.logIntegratedRemoteDisplayCheckBox = new JCheckBox();
            this.logIntegratedRemoteDisplayCheckBox.setContentAreaFilled(false);
            this.logIntegratedRemoteDisplayCheckBox.setText(this.core.getLiteral("Log Remote Display Data"));
            this.logIntegratedRemoteDisplayCheckBox.setFont(this.editFont);
            this.logIntegratedRemoteDisplayCheckBox.setBorder(null);
            this.logIntegratedRemoteDisplayCheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.logIntegratedRemoteDisplayCheckBox.getText()) + 20;
            this.logIntegratedRemoteDisplayCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.outputsPanel.add(this.logIntegratedRemoteDisplayCheckBox);
            this.logIntegratedRemoteDisplayCheckBox.addActionListener(new MyActionListener());
            yOffset += (int)((double)panelHeight * 0.125);
        }
        xOffset = (int)((double)panelWidth * 0.025);
        sectionLabel = new JLabel();
        this.outputsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Email Receipt Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        JLabel label = new JLabel();
        this.outputsPanel.add(label);
        label.setText(this.core.getLiteral("Email Receipt Subject Line:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        int labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.emailSubjectEdit = new JTextField();
        this.emailSubjectEdit.setHorizontalAlignment(2);
        this.outputsPanel.add(this.emailSubjectEdit);
        this.emailSubjectEdit.setFont(this.editFont);
        this.emailSubjectEdit.setBorder(this.editBorder);
        int boxWidth = (int)((double)panelWidth * 0.25);
        this.emailSubjectEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.emailSubjectEdit.addKeyListener(new MyKeyListener());
        this.emailSubjectEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.55);
        this.emailSignatureCheckBox = new JCheckBox();
        this.emailSignatureCheckBox.setContentAreaFilled(false);
        this.emailSignatureCheckBox.setText(this.core.getLiteral("Email Signature"));
        this.emailSignatureCheckBox.setFont(this.editFont);
        this.emailSignatureCheckBox.setBorder(null);
        this.emailSignatureCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.emailSignatureCheckBox.getText()) + 20;
        this.emailSignatureCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.outputsPanel.add(this.emailSignatureCheckBox);
        this.emailSignatureCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.125);
        sectionLabel = new JLabel();
        this.outputsPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Email Exception Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.emailExceptionsCheckBox = new JCheckBox();
        this.emailExceptionsCheckBox.setContentAreaFilled(false);
        this.emailExceptionsCheckBox.setText(this.core.getLiteral("Email Exceptions"));
        this.emailExceptionsCheckBox.setFont(this.editFont);
        this.emailExceptionsCheckBox.setBorder(null);
        this.emailExceptionsCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.emailExceptionsCheckBox.getText()) + 20;
        this.emailExceptionsCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.outputsPanel.add(this.emailExceptionsCheckBox);
        this.emailExceptionsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ServerConfigScreen.this.emailExceptionsPanel != null) {
                    if (!ServerConfigScreen.this.loadingData) {
                        ServerConfigScreen.this.restartRequired = true;
                    }
                    if (ServerConfigScreen.this.emailExceptionsCheckBox.isSelected()) {
                        ServerConfigScreen.this.emailExceptionsPanel.setVisible(true);
                    } else {
                        ServerConfigScreen.this.emailExceptionsPanel.setVisible(false);
                    }
                }
            }
        });
        xOffset = (int)((double)panelWidth * 0.35);
        this.emailExceptionsPanel = new JPanel();
        this.emailExceptionsPanel.setLayout(null);
        Border grayline = BorderFactory.createLineBorder(Color.gray);
        TitledBorder title = BorderFactory.createTitledBorder(grayline, "Email Exception Addresses");
        title.setTitleJustification(2);
        title.setTitleFont(this.editFont);
        title.setTitleColor(Color.gray);
        this.emailExceptionsPanel.setBorder(title);
        boxWidth = (int)((double)panelWidth * 0.5);
        int boxHeight = (int)((double)panelHeight * 0.3);
        this.emailExceptionsPanel.setBounds(xOffset, yOffset, boxWidth, boxHeight);
        this.outputsPanel.add(this.emailExceptionsPanel);
        this.emailExceptionsEdit = new JTextField[]{new JTextField(), new JTextField(), new JTextField(), new JTextField(), new JTextField()};
        for (int i = 0; i < 5; ++i) {
            JLabel emailLabel = new JLabel();
            this.emailExceptionsPanel.add(emailLabel);
            emailLabel.setText("" + (i + 1) + ":");
            emailLabel.setForeground(Color.gray);
            emailLabel.setFont(this.editFont);
            emailLabel.setHorizontalAlignment(2);
            emailLabel.setBounds(10, (i + 1) * 30, 10, 25);
            this.emailExceptionsEdit[i].setHorizontalAlignment(2);
            this.emailExceptionsEdit[i].setFont(this.editFont);
            this.emailExceptionsEdit[i].setBorder(this.editBorder);
            boxWidth = (int)((double)panelWidth * 0.45);
            this.emailExceptionsEdit[i].setBounds(25, (i + 1) * 30, boxWidth, 20);
            this.emailExceptionsPanel.add(this.emailExceptionsEdit[i]);
            this.emailExceptionsEdit[i].addFocusListener(new MyFocusListener());
        }
    }

    private void loadCardHandlerPanel() {
        int panelWidth = this.tabbedPane.getWidth();
        int panelHeight = this.tabbedPane.getHeight();
        int xOffset = (int)((double)panelWidth * 0.025);
        int yOffset = (int)((double)panelHeight * 0.025);
        JLabel sectionLabel = new JLabel();
        this.cardHandlerPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Card Handler Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasCardHandlerCheckBox = new JCheckBox();
        this.hasCardHandlerCheckBox.setContentAreaFilled(false);
        this.hasCardHandlerCheckBox.setText(this.core.getLiteral("Has Card Handler"));
        this.hasCardHandlerCheckBox.setFont(this.editFont);
        this.hasCardHandlerCheckBox.setBorder(null);
        this.hasCardHandlerCheckBox.setForeground(Color.gray);
        int boxWidth = this.fontMetrics.stringWidth(this.hasCardHandlerCheckBox.getText()) + 20;
        this.hasCardHandlerCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.hasCardHandlerCheckBox);
        this.hasCardHandlerCheckBox.addActionListener(new MyActionListener());
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasGiftCardHandlerCheckBox = new JCheckBox();
        this.hasGiftCardHandlerCheckBox.setContentAreaFilled(false);
        this.hasGiftCardHandlerCheckBox.setText(this.core.getLiteral("Has Gift Card Handler"));
        this.hasGiftCardHandlerCheckBox.setFont(this.editFont);
        this.hasGiftCardHandlerCheckBox.setBorder(null);
        this.hasGiftCardHandlerCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasGiftCardHandlerCheckBox.getText()) + 20;
        this.hasGiftCardHandlerCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.hasGiftCardHandlerCheckBox);
        this.hasGiftCardHandlerCheckBox.addActionListener(new MyActionListener());
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasCardPostAuthHandlerCheckBox = new JCheckBox();
        this.hasCardPostAuthHandlerCheckBox.setContentAreaFilled(false);
        this.hasCardPostAuthHandlerCheckBox.setText(this.core.getLiteral("Has Card Post Auth Handler"));
        this.hasCardPostAuthHandlerCheckBox.setFont(this.editFont);
        this.hasCardPostAuthHandlerCheckBox.setBorder(null);
        this.hasCardPostAuthHandlerCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasCardPostAuthHandlerCheckBox.getText()) + 20;
        this.hasCardPostAuthHandlerCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.hasCardPostAuthHandlerCheckBox);
        this.hasCardPostAuthHandlerCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ServerConfigScreen.this.postAuthEmailPanel != null) {
                    if (!ServerConfigScreen.this.loadingData) {
                        ServerConfigScreen.this.restartRequired = true;
                    }
                    if (ServerConfigScreen.this.hasCardPostAuthHandlerCheckBox.isSelected()) {
                        ServerConfigScreen.this.postAuthEmailPanel.setVisible(true);
                    } else {
                        ServerConfigScreen.this.postAuthEmailPanel.setVisible(false);
                    }
                }
            }
        });
        xOffset = (int)((double)panelWidth * 0.35);
        yOffset = (int)((double)panelHeight * 0.05);
        this.postAuthEmailPanel = new JPanel();
        this.postAuthEmailPanel.setLayout(null);
        Border grayline = BorderFactory.createLineBorder(Color.gray);
        TitledBorder title = BorderFactory.createTitledBorder(grayline, "Post Auth Email Addresses");
        title.setTitleJustification(2);
        title.setTitleFont(this.editFont);
        title.setTitleColor(Color.gray);
        this.postAuthEmailPanel.setBorder(title);
        boxWidth = (int)((double)panelWidth * 0.5);
        int boxHeight = (int)((double)panelHeight * 0.3);
        this.postAuthEmailPanel.setBounds(xOffset, yOffset, boxWidth, boxHeight);
        this.postAuthEmailPanel.setVisible(false);
        this.cardHandlerPanel.add(this.postAuthEmailPanel);
        this.postAuthEmailEdit = new JTextField[]{new JTextField(), new JTextField(), new JTextField(), new JTextField(), new JTextField()};
        for (int i = 0; i < 5; ++i) {
            JLabel emailLabel = new JLabel();
            this.postAuthEmailPanel.add(emailLabel);
            emailLabel.setText("" + (i + 1) + ":");
            emailLabel.setForeground(Color.gray);
            emailLabel.setFont(this.editFont);
            emailLabel.setHorizontalAlignment(2);
            emailLabel.setBounds(10, (i + 1) * 30, 10, 25);
            this.postAuthEmailEdit[i].setHorizontalAlignment(2);
            this.postAuthEmailEdit[i].setFont(this.editFont);
            this.postAuthEmailEdit[i].setBorder(this.editBorder);
            boxWidth = (int)((double)panelWidth * 0.45);
            this.postAuthEmailEdit[i].setBounds(25, (i + 1) * 30, boxWidth, 20);
            this.postAuthEmailPanel.add(this.postAuthEmailEdit[i]);
            this.postAuthEmailEdit[i].addFocusListener(new MyFocusListener());
        }
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset = (int)((double)panelHeight * 0.375);
        sectionLabel = new JLabel();
        this.cardHandlerPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Cibus Card Handler Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasCibusCardHandlerCheckBox = new JCheckBox();
        this.hasCibusCardHandlerCheckBox.setContentAreaFilled(false);
        this.hasCibusCardHandlerCheckBox.setText(this.core.getLiteral("Has Cibus Card Handler"));
        this.hasCibusCardHandlerCheckBox.setFont(this.editFont);
        this.hasCibusCardHandlerCheckBox.setBorder(null);
        this.hasCibusCardHandlerCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasCibusCardHandlerCheckBox.getText()) + 20;
        this.hasCibusCardHandlerCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.hasCibusCardHandlerCheckBox);
        this.hasCibusCardHandlerCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.275);
        JLabel label = new JLabel();
        this.cardHandlerPanel.add(label);
        label.setText(this.core.getLiteral("Restaurant Id:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        int labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.cibusResIdEdit = new JTextField();
        this.cibusResIdEdit.setHorizontalAlignment(2);
        this.cardHandlerPanel.add(this.cibusResIdEdit);
        this.cibusResIdEdit.setFont(this.editFont);
        this.cibusResIdEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.2);
        this.cibusResIdEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cibusResIdEdit.addKeyListener(new MyKeyListener());
        this.cibusResIdEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.6);
        label = new JLabel();
        this.cardHandlerPanel.add(label);
        label.setText(this.core.getLiteral("Device Id:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.cibusPosIdEdit = new JTextField();
        this.cibusPosIdEdit.setHorizontalAlignment(2);
        this.cardHandlerPanel.add(this.cibusPosIdEdit);
        this.cibusPosIdEdit.setFont(this.editFont);
        this.cibusPosIdEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.2);
        this.cibusPosIdEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cibusPosIdEdit.addKeyListener(new MyKeyListener());
        this.cibusPosIdEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.9);
        this.cibusDebugCheckBox = new JCheckBox();
        this.cibusDebugCheckBox.setContentAreaFilled(false);
        this.cibusDebugCheckBox.setText(this.core.getLiteral("Debug"));
        this.cibusDebugCheckBox.setFont(this.editFont);
        this.cibusDebugCheckBox.setBorder(null);
        this.cibusDebugCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.cibusDebugCheckBox.getText()) + 20;
        this.cibusDebugCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.cibusDebugCheckBox);
        this.cibusDebugCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.1);
        sectionLabel = new JLabel();
        this.cardHandlerPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Tenbis Card Handler Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasTenbisCardHandlerCheckBox = new JCheckBox();
        this.hasTenbisCardHandlerCheckBox.setContentAreaFilled(false);
        this.hasTenbisCardHandlerCheckBox.setText(this.core.getLiteral("Has Tenbis Card Handler"));
        this.hasTenbisCardHandlerCheckBox.setFont(this.editFont);
        this.hasTenbisCardHandlerCheckBox.setBorder(null);
        this.hasTenbisCardHandlerCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasTenbisCardHandlerCheckBox.getText()) + 20;
        this.hasTenbisCardHandlerCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.hasTenbisCardHandlerCheckBox);
        this.hasTenbisCardHandlerCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.275);
        label = new JLabel();
        this.cardHandlerPanel.add(label);
        label.setText(this.core.getLiteral("User Name:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.tenbisUserNameEdit = new JTextField();
        this.tenbisUserNameEdit.setHorizontalAlignment(2);
        this.cardHandlerPanel.add(this.tenbisUserNameEdit);
        this.tenbisUserNameEdit.setFont(this.editFont);
        this.tenbisUserNameEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.2);
        this.tenbisUserNameEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.tenbisUserNameEdit.addKeyListener(new MyKeyListener());
        this.tenbisUserNameEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.6);
        label = new JLabel();
        this.cardHandlerPanel.add(label);
        label.setText(this.core.getLiteral("User Password:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.tenbisUserPasswordEdit = new JTextField();
        this.tenbisUserPasswordEdit.setHorizontalAlignment(2);
        this.cardHandlerPanel.add(this.tenbisUserPasswordEdit);
        this.tenbisUserPasswordEdit.setFont(this.editFont);
        this.tenbisUserPasswordEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.2);
        this.tenbisUserPasswordEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.tenbisUserPasswordEdit.addKeyListener(new MyKeyListener());
        this.tenbisUserPasswordEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.cardHandlerPanel.add(label);
        label.setText(this.core.getLiteral("Restaurant Id:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.tenbisResIdEdit = new JTextField();
        this.tenbisResIdEdit.setHorizontalAlignment(2);
        this.cardHandlerPanel.add(this.tenbisResIdEdit);
        this.tenbisResIdEdit.setFont(this.editFont);
        this.tenbisResIdEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.2);
        this.tenbisResIdEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.tenbisResIdEdit.addKeyListener(new MyKeyListener());
        this.tenbisResIdEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.4);
        label = new JLabel();
        this.cardHandlerPanel.add(label);
        label.setText(this.core.getLiteral("Vendor:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.tenbisVendorEdit = new JTextField();
        this.tenbisVendorEdit.setHorizontalAlignment(2);
        this.cardHandlerPanel.add(this.tenbisVendorEdit);
        this.tenbisVendorEdit.setFont(this.editFont);
        this.tenbisVendorEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.2);
        this.tenbisVendorEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.tenbisVendorEdit.addKeyListener(new MyKeyListener());
        this.tenbisVendorEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.725);
        this.tenbisDebugCheckBox = new JCheckBox();
        this.tenbisDebugCheckBox.setContentAreaFilled(false);
        this.tenbisDebugCheckBox.setText(this.core.getLiteral("Debug"));
        this.tenbisDebugCheckBox.setFont(this.editFont);
        this.tenbisDebugCheckBox.setBorder(null);
        this.tenbisDebugCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.tenbisDebugCheckBox.getText()) + 20;
        this.tenbisDebugCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.tenbisDebugCheckBox);
        this.tenbisDebugCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.1);
        sectionLabel = new JLabel();
        this.cardHandlerPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("EConduit Card Handler Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasEConduitCardHandlerCheckBox = new JCheckBox();
        this.hasEConduitCardHandlerCheckBox.setContentAreaFilled(false);
        this.hasEConduitCardHandlerCheckBox.setText(this.core.getLiteral("Has EConduit Card Handler"));
        this.hasEConduitCardHandlerCheckBox.setFont(this.editFont);
        this.hasEConduitCardHandlerCheckBox.setBorder(null);
        this.hasEConduitCardHandlerCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasEConduitCardHandlerCheckBox.getText()) + 20;
        this.hasEConduitCardHandlerCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.hasEConduitCardHandlerCheckBox);
        this.hasEConduitCardHandlerCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.35);
        this.eConduitDebugCheckBox = new JCheckBox();
        this.eConduitDebugCheckBox.setContentAreaFilled(false);
        this.eConduitDebugCheckBox.setText(this.core.getLiteral("Debug"));
        this.eConduitDebugCheckBox.setFont(this.editFont);
        this.eConduitDebugCheckBox.setBorder(null);
        this.eConduitDebugCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.eConduitDebugCheckBox.getText()) + 20;
        this.eConduitDebugCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.cardHandlerPanel.add(this.eConduitDebugCheckBox);
        this.eConduitDebugCheckBox.addActionListener(new MyActionListener());
    }

    private void loadOptionalPanel() {
        int labelWidth;
        JLabel label;
        int boxWidth;
        JLabel sectionLabel;
        int panelWidth = this.tabbedPane.getWidth();
        int panelHeight = this.tabbedPane.getHeight();
        int xOffset = (int)((double)panelWidth * 0.025);
        int yOffset = (int)((double)panelHeight * 0.05);
        if (this.core.hasLicenseFor("AccountingIntegration")) {
            sectionLabel = new JLabel();
            sectionLabel = new JLabel();
            this.optionalPanel.add(sectionLabel);
            sectionLabel.setText(this.core.getLiteral("Integrator Options"));
            sectionLabel.setForeground(Color.gray);
            sectionLabel.setFont(this.titleFont);
            sectionLabel.setHorizontalAlignment(2);
            sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
            xOffset = (int)((double)panelWidth * 0.05);
            yOffset += (int)((double)panelHeight * 0.075);
            this.hasAccountingCheckBox = new JCheckBox();
            this.hasAccountingCheckBox.setContentAreaFilled(false);
            this.hasAccountingCheckBox.setText(this.core.getLiteral("Has Accounting"));
            this.hasAccountingCheckBox.setFont(this.editFont);
            this.hasAccountingCheckBox.setBorder(null);
            this.hasAccountingCheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.hasAccountingCheckBox.getText()) + 20;
            this.hasAccountingCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.optionalPanel.add(this.hasAccountingCheckBox);
            this.hasAccountingCheckBox.addActionListener(new MyActionListener());
            xOffset = (int)((double)panelWidth * 0.25);
            label = new JLabel();
            this.optionalPanel.add(label);
            label.setText(this.core.getLiteral("Integrator Type:"));
            label.setForeground(Color.gray);
            label.setFont(this.editFont);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(4);
            this.fontMetrics = label.getFontMetrics(this.editFont);
            labelWidth = this.fontMetrics.stringWidth(label.getText());
            label.setBounds(xOffset, yOffset, labelWidth, 20);
            xOffset += labelWidth + 5;
            this.integratorTypeBox = new JComboBox();
            this.optionalPanel.add(this.integratorTypeBox);
            this.integratorTypeBox.setFont(this.editFont);
            this.integratorTypeBox.setBorder(null);
            boxWidth = (int)((double)panelWidth * 0.25);
            this.integratorTypeBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.integratorTypeBox.addActionListener(new MyActionListener());
            this.integratorTypeBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String integratorType;
                    if (!ServerConfigScreen.this.loadingData) {
                        ServerConfigScreen.this.restartRequired = true;
                    }
                    if ((integratorType = (String)ServerConfigScreen.this.integratorTypeBox.getSelectedItem()).equalsIgnoreCase("Sage Live")) {
                        if (ServerConfigScreen.this.skipItemsover20CheckBox != null) {
                            ServerConfigScreen.this.skipItemsover20CheckBox.setVisible(false);
                        }
                        if (ServerConfigScreen.this.summarizeCashSalesCheckBox != null) {
                            ServerConfigScreen.this.summarizeCashSalesCheckBox.setVisible(false);
                        }
                        if (ServerConfigScreen.this.updateItemTypesCheckBox != null) {
                            ServerConfigScreen.this.updateItemTypesCheckBox.setVisible(false);
                        }
                        if (ServerConfigScreen.this.useAutomatedTaxCheckBox != null) {
                            ServerConfigScreen.this.useAutomatedTaxCheckBox.setVisible(false);
                        }
                        if (ServerConfigScreen.this.integratorPathLabel != null) {
                            ServerConfigScreen.this.integratorPathLabel.setVisible(false);
                        }
                        if (ServerConfigScreen.this.integratorPathEdit != null) {
                            ServerConfigScreen.this.integratorPathEdit.setVisible(false);
                        }
                    } else if (integratorType.equalsIgnoreCase("QuickBooks Online")) {
                        if (ServerConfigScreen.this.skipItemsover20CheckBox != null) {
                            ServerConfigScreen.this.skipItemsover20CheckBox.setVisible(false);
                        }
                        if (ServerConfigScreen.this.summarizeCashSalesCheckBox != null) {
                            ServerConfigScreen.this.summarizeCashSalesCheckBox.setVisible(true);
                        }
                        if (ServerConfigScreen.this.updateItemTypesCheckBox != null) {
                            ServerConfigScreen.this.updateItemTypesCheckBox.setVisible(true);
                        }
                        if (ServerConfigScreen.this.useAutomatedTaxCheckBox != null) {
                            ServerConfigScreen.this.useAutomatedTaxCheckBox.setVisible(true);
                        }
                        if (ServerConfigScreen.this.integratorPathLabel != null) {
                            ServerConfigScreen.this.integratorPathLabel.setVisible(false);
                        }
                        if (ServerConfigScreen.this.integratorPathEdit != null) {
                            ServerConfigScreen.this.integratorPathEdit.setVisible(false);
                        }
                    } else {
                        if (ServerConfigScreen.this.skipItemsover20CheckBox != null) {
                            ServerConfigScreen.this.skipItemsover20CheckBox.setVisible(true);
                        }
                        if (ServerConfigScreen.this.summarizeCashSalesCheckBox != null) {
                            ServerConfigScreen.this.summarizeCashSalesCheckBox.setVisible(true);
                        }
                        if (ServerConfigScreen.this.updateItemTypesCheckBox != null) {
                            ServerConfigScreen.this.updateItemTypesCheckBox.setVisible(false);
                        }
                        if (ServerConfigScreen.this.useAutomatedTaxCheckBox != null) {
                            ServerConfigScreen.this.useAutomatedTaxCheckBox.setVisible(false);
                        }
                        if (ServerConfigScreen.this.integratorPathLabel != null) {
                            ServerConfigScreen.this.integratorPathLabel.setVisible(true);
                        }
                        if (ServerConfigScreen.this.integratorPathEdit != null) {
                            ServerConfigScreen.this.integratorPathEdit.setVisible(true);
                        }
                    }
                }
            });
            xOffset = (int)((double)panelWidth * 0.65);
            this.updateItemTypesCheckBox = new JCheckBox();
            this.updateItemTypesCheckBox.setContentAreaFilled(false);
            this.updateItemTypesCheckBox.setText(this.core.getLiteral("Do Not Update Item Types"));
            this.updateItemTypesCheckBox.setFont(this.editFont);
            this.updateItemTypesCheckBox.setBorder(null);
            this.updateItemTypesCheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.updateItemTypesCheckBox.getText()) + 20;
            this.updateItemTypesCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.optionalPanel.add(this.updateItemTypesCheckBox);
            this.updateItemTypesCheckBox.addActionListener(new MyActionListener());
            xOffset = (int)((double)panelWidth * 0.05);
            yOffset += (int)((double)panelHeight * 0.075);
            this.updateItemPricesCheckBox = new JCheckBox();
            this.updateItemPricesCheckBox.setContentAreaFilled(false);
            this.updateItemPricesCheckBox.setText(this.core.getLiteral("Update Item Prices"));
            this.updateItemPricesCheckBox.setFont(this.editFont);
            this.updateItemPricesCheckBox.setBorder(null);
            this.updateItemPricesCheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.updateItemPricesCheckBox.getText()) + 20;
            this.updateItemPricesCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.optionalPanel.add(this.updateItemPricesCheckBox);
            this.updateItemPricesCheckBox.addActionListener(new MyActionListener());
            xOffset = (int)((double)panelWidth * 0.35);
            this.summarizeCashSalesCheckBox = new JCheckBox();
            this.summarizeCashSalesCheckBox.setContentAreaFilled(false);
            this.summarizeCashSalesCheckBox.setText(this.core.getLiteral("Summarize All Cash Sales"));
            this.summarizeCashSalesCheckBox.setFont(this.editFont);
            this.summarizeCashSalesCheckBox.setBorder(null);
            this.summarizeCashSalesCheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.summarizeCashSalesCheckBox.getText()) + 20;
            this.summarizeCashSalesCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.optionalPanel.add(this.summarizeCashSalesCheckBox);
            this.summarizeCashSalesCheckBox.addActionListener(new MyActionListener());
            xOffset = (int)((double)panelWidth * 0.65);
            this.useAutomatedTaxCheckBox = new JCheckBox();
            this.useAutomatedTaxCheckBox.setContentAreaFilled(false);
            this.useAutomatedTaxCheckBox.setText(this.core.getLiteral("Use Automated Tax"));
            this.useAutomatedTaxCheckBox.setFont(this.editFont);
            this.useAutomatedTaxCheckBox.setBorder(null);
            this.useAutomatedTaxCheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.useAutomatedTaxCheckBox.getText()) + 20;
            this.useAutomatedTaxCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.optionalPanel.add(this.useAutomatedTaxCheckBox);
            this.useAutomatedTaxCheckBox.addActionListener(new MyActionListener());
            xOffset = (int)((double)panelWidth * 0.65);
            this.skipItemsover20CheckBox = new JCheckBox();
            this.skipItemsover20CheckBox.setContentAreaFilled(false);
            this.skipItemsover20CheckBox.setText(this.core.getLiteral("Skip Items over 20"));
            this.skipItemsover20CheckBox.setFont(this.editFont);
            this.skipItemsover20CheckBox.setBorder(null);
            this.skipItemsover20CheckBox.setForeground(Color.gray);
            boxWidth = this.fontMetrics.stringWidth(this.skipItemsover20CheckBox.getText()) + 20;
            this.skipItemsover20CheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
            this.optionalPanel.add(this.skipItemsover20CheckBox);
            this.skipItemsover20CheckBox.addActionListener(new MyActionListener());
            xOffset = (int)((double)panelWidth * 0.05);
            yOffset += (int)((double)panelHeight * 0.075);
            this.integratorPathLabel = new JLabel();
            this.optionalPanel.add(this.integratorPathLabel);
            this.integratorPathLabel.setText(this.core.getLiteral("Path:"));
            this.integratorPathLabel.setForeground(Color.gray);
            this.integratorPathLabel.setFont(this.editFont);
            this.integratorPathLabel.setVerticalAlignment(0);
            this.integratorPathLabel.setHorizontalAlignment(4);
            labelWidth = this.fontMetrics.stringWidth(this.integratorPathLabel.getText());
            this.integratorPathLabel.setBounds(xOffset, yOffset, labelWidth, 20);
            xOffset += labelWidth + 5;
            this.integratorPathEdit = new JTextField();
            this.integratorPathEdit.setHorizontalAlignment(2);
            this.optionalPanel.add(this.integratorPathEdit);
            this.integratorPathEdit.setFont(this.editFont);
            this.integratorPathEdit.setBorder(this.editBorder);
            boxWidth = (int)((double)panelWidth * 0.25);
            this.integratorPathEdit.setBounds(xOffset, yOffset, boxWidth, 20);
            this.integratorPathEdit.addKeyListener(new MyKeyListener());
            this.integratorPathEdit.addFocusListener(new MyFocusListener());
            this.integratorPathEdit.setText("C:\\accupos");
            yOffset += (int)((double)panelHeight * 0.15);
        }
        xOffset = (int)((double)panelWidth * 0.025);
        sectionLabel = new JLabel();
        sectionLabel = new JLabel();
        this.optionalPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Loyalty Handler Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasLoyaltyHandlerCheckBox = new JCheckBox();
        this.hasLoyaltyHandlerCheckBox.setContentAreaFilled(false);
        this.hasLoyaltyHandlerCheckBox.setText(this.core.getLiteral("Has Loyalty Handler"));
        this.hasLoyaltyHandlerCheckBox.setFont(this.editFont);
        this.hasLoyaltyHandlerCheckBox.setBorder(null);
        this.hasLoyaltyHandlerCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasLoyaltyHandlerCheckBox.getText()) + 20;
        this.hasLoyaltyHandlerCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.optionalPanel.add(this.hasLoyaltyHandlerCheckBox);
        this.hasLoyaltyHandlerCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.5);
        label = new JLabel();
        this.optionalPanel.add(label);
        label.setText(this.core.getLiteral("Merchant ID:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.loyaltyMerchantIdEdit = new JTextField();
        this.loyaltyMerchantIdEdit.setHorizontalAlignment(2);
        this.optionalPanel.add(this.loyaltyMerchantIdEdit);
        this.loyaltyMerchantIdEdit.setFont(this.editFont);
        this.loyaltyMerchantIdEdit.setBorder(this.editBorder);
        this.loyaltyMerchantIdEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.loyaltyMerchantIdEdit.addKeyListener(new MyKeyListener());
        this.loyaltyMerchantIdEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.optionalPanel.add(label);
        label.setText(this.core.getLiteral("Location:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.loyaltyLocationEdit = new JTextField();
        this.loyaltyLocationEdit.setHorizontalAlignment(2);
        this.optionalPanel.add(this.loyaltyLocationEdit);
        this.loyaltyLocationEdit.setFont(this.editFont);
        this.loyaltyLocationEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.25);
        this.loyaltyLocationEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.loyaltyLocationEdit.addKeyListener(new MyKeyListener());
        this.loyaltyLocationEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.5);
        label = new JLabel();
        this.optionalPanel.add(label);
        label.setText(this.core.getLiteral("Comp Reason:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.loyaltyCompReasonEdit = new JTextField();
        this.loyaltyCompReasonEdit.setHorizontalAlignment(2);
        this.optionalPanel.add(this.loyaltyCompReasonEdit);
        this.loyaltyCompReasonEdit.setFont(this.editFont);
        this.loyaltyCompReasonEdit.setBorder(this.editBorder);
        this.loyaltyCompReasonEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.loyaltyCompReasonEdit.addKeyListener(new MyKeyListener());
        this.loyaltyCompReasonEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.15);
        sectionLabel = new JLabel();
        sectionLabel = new JLabel();
        this.optionalPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("Como Loyalty Handler Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasComoLoyaltyCheckBox = new JCheckBox();
        this.hasComoLoyaltyCheckBox.setContentAreaFilled(false);
        this.hasComoLoyaltyCheckBox.setText(this.core.getLiteral("Has Como Loyalty Handler"));
        this.hasComoLoyaltyCheckBox.setFont(this.editFont);
        this.hasComoLoyaltyCheckBox.setBorder(null);
        this.hasComoLoyaltyCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.hasComoLoyaltyCheckBox.getText()) + 20;
        this.hasComoLoyaltyCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.optionalPanel.add(this.hasComoLoyaltyCheckBox);
        this.hasComoLoyaltyCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.5);
        label = new JLabel();
        this.optionalPanel.add(label);
        label.setText(this.core.getLiteral("Merchant ID:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.comoLoyaltyMerchantIdEdit = new JTextField();
        this.comoLoyaltyMerchantIdEdit.setHorizontalAlignment(2);
        this.optionalPanel.add(this.comoLoyaltyMerchantIdEdit);
        this.comoLoyaltyMerchantIdEdit.setFont(this.editFont);
        this.comoLoyaltyMerchantIdEdit.setBorder(this.editBorder);
        this.comoLoyaltyMerchantIdEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.comoLoyaltyMerchantIdEdit.addKeyListener(new MyKeyListener());
        this.comoLoyaltyMerchantIdEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.optionalPanel.add(label);
        label.setText(this.core.getLiteral("Location:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.comoLoyaltyLocationEdit = new JTextField();
        this.comoLoyaltyLocationEdit.setHorizontalAlignment(2);
        this.optionalPanel.add(this.comoLoyaltyLocationEdit);
        this.comoLoyaltyLocationEdit.setFont(this.editFont);
        this.comoLoyaltyLocationEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.25);
        this.comoLoyaltyLocationEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.comoLoyaltyLocationEdit.addKeyListener(new MyKeyListener());
        this.comoLoyaltyLocationEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.5);
        this.useComoCreditsCheckBox = new JCheckBox();
        this.useComoCreditsCheckBox.setContentAreaFilled(false);
        this.useComoCreditsCheckBox.setText(this.core.getLiteral("Use Credits"));
        this.useComoCreditsCheckBox.setFont(this.editFont);
        this.useComoCreditsCheckBox.setBorder(null);
        this.useComoCreditsCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.useComoCreditsCheckBox.getText()) + 20;
        this.useComoCreditsCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.optionalPanel.add(this.useComoCreditsCheckBox);
        this.useComoCreditsCheckBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.75);
        this.useComoPointsCheckBox = new JCheckBox();
        this.useComoPointsCheckBox.setContentAreaFilled(false);
        this.useComoPointsCheckBox.setText(this.core.getLiteral("Use Points"));
        this.useComoPointsCheckBox.setFont(this.editFont);
        this.useComoPointsCheckBox.setBorder(null);
        this.useComoPointsCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.useComoPointsCheckBox.getText()) + 20;
        this.useComoPointsCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.optionalPanel.add(this.useComoPointsCheckBox);
        this.useComoPointsCheckBox.addActionListener(new MyActionListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useComoCreditsCheckBox);
        buttonGroup.add(this.useComoPointsCheckBox);
    }

    private void loadAccuShiftPanel() {
        int panelWidth = this.tabbedPane.getWidth();
        int panelHeight = this.tabbedPane.getHeight();
        int xOffset = (int)((double)panelWidth * 0.025);
        int yOffset = (int)((double)panelHeight * 0.05);
        JLabel sectionLabel = new JLabel();
        this.accuShiftPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("AccuShift Database Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        this.hasAccuShiftCheckBox = new JCheckBox();
        this.hasAccuShiftCheckBox.setContentAreaFilled(false);
        this.hasAccuShiftCheckBox.setText(this.core.getLiteral("Has AccuShift"));
        this.hasAccuShiftCheckBox.setFont(this.editFont);
        this.hasAccuShiftCheckBox.setBorder(null);
        this.hasAccuShiftCheckBox.setForeground(Color.gray);
        int boxWidth = this.fontMetrics.stringWidth(this.hasAccuShiftCheckBox.getText()) + 20;
        this.hasAccuShiftCheckBox.setBounds(xOffset, yOffset, boxWidth, 20);
        this.accuShiftPanel.add(this.hasAccuShiftCheckBox);
        this.hasAccuShiftCheckBox.addActionListener(new MyActionListener());
        this.hasAccuShiftCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ServerConfigScreen.this.hasAccuShiftCheckBox.isSelected()) {
                    ServerConfigScreen.this.accuShiftPathPanel.setVisible(true);
                } else {
                    ServerConfigScreen.this.accuShiftPathPanel.setVisible(false);
                }
            }
        });
        xOffset = (int)((double)panelWidth * 0.35);
        this.accuShiftPathPanel = new JPanel();
        this.accuShiftPathPanel.setOpaque(true);
        this.accuShiftPathPanel.setLayout(null);
        this.accuShiftPathPanel.setVisible(false);
        this.accuShiftPathPanel.setBounds(xOffset, yOffset, (int)((double)panelWidth * 0.9), (int)((double)panelHeight * 0.2));
        this.accuShiftPanel.add(this.accuShiftPathPanel);
        this.accuShiftNGCheckBox = new JCheckBox();
        this.accuShiftNGCheckBox.setContentAreaFilled(false);
        this.accuShiftNGCheckBox.setText(this.core.getLiteral("New Generation"));
        this.accuShiftNGCheckBox.setFont(this.editFont);
        this.accuShiftNGCheckBox.setBorder(null);
        this.accuShiftNGCheckBox.setForeground(Color.gray);
        boxWidth = this.fontMetrics.stringWidth(this.accuShiftNGCheckBox.getText()) + 20;
        this.accuShiftNGCheckBox.setBounds(10, 0, boxWidth, 20);
        this.accuShiftPathPanel.add(this.accuShiftNGCheckBox);
        this.accuShiftNGCheckBox.addActionListener(new MyActionListener());
        this.accuShiftNGCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ServerConfigScreen.this.accuShiftNGCheckBox.isSelected()) {
                    ServerConfigScreen.this.showAccuShiftNote();
                    if (ServerConfigScreen.this.accuShiftPathEdit != null) {
                        ServerConfigScreen.this.accuShiftPathEdit.setEnabled(false);
                        if (ServerConfigScreen.this.accuShiftPathEdit.getText().trim().isEmpty()) {
                            if (ServerConfigScreen.this.databasePathEdit != null) {
                                ServerConfigScreen.this.accuShiftPathEdit.setText(ServerConfigScreen.this.databasePathEdit.getText());
                            }
                            if (ServerConfigScreen.this.databaseDriverBox != null) {
                                ServerConfigScreen.this.accuShiftDriverBox.setSelectedItem(ServerConfigScreen.this.databaseDriverBox.getSelectedItem());
                            }
                        }
                    }
                    if (ServerConfigScreen.this.accuShiftDriverBox != null) {
                        ServerConfigScreen.this.accuShiftDriverBox.setEnabled(false);
                    }
                } else {
                    if (ServerConfigScreen.this.accuShiftPathEdit != null) {
                        ServerConfigScreen.this.accuShiftPathEdit.setEnabled(true);
                    }
                    if (ServerConfigScreen.this.accuShiftDriverBox != null) {
                        ServerConfigScreen.this.accuShiftDriverBox.setEnabled(true);
                    }
                }
            }
        });
        xOffset = (int)((double)panelWidth * 0.25);
        JLabel label = new JLabel();
        this.accuShiftPathPanel.add(label);
        label.setText(this.core.getLiteral("Database Driver:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        this.fontMetrics = label.getFontMetrics(this.editFont);
        int labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, 0, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.accuShiftDriverBox = new JComboBox();
        this.accuShiftPathPanel.add(this.accuShiftDriverBox);
        this.accuShiftDriverBox.setFont(this.editFont);
        this.accuShiftDriverBox.setBorder(null);
        this.accuShiftDriverBox.setBounds(xOffset, 0, 120, 20);
        this.accuShiftDriverBox.addActionListener(new MyActionListener());
        label = new JLabel();
        this.accuShiftPathPanel.add(label);
        label.setText(this.core.getLiteral("Database Path:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(10, (int)((double)panelHeight * 0.065), labelWidth, 20);
        this.accuShiftPathEdit = new JTextField();
        this.accuShiftPathEdit.setHorizontalAlignment(2);
        this.accuShiftPathPanel.add(this.accuShiftPathEdit);
        this.accuShiftPathEdit.setFont(this.editFont);
        this.accuShiftPathEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.35);
        this.accuShiftPathEdit.setBounds(labelWidth + 15, (int)((double)panelHeight * 0.065), boxWidth, 20);
        this.accuShiftPathEdit.addKeyListener(new MyKeyListener());
        this.accuShiftPathEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.025);
        yOffset += (int)((double)panelHeight * 0.2);
        sectionLabel = new JLabel();
        this.accuShiftPanel.add(sectionLabel);
        sectionLabel.setText(this.core.getLiteral("TimeClock Printer Options"));
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, panelWidth - xOffset, 25);
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.accuShiftPanel.add(label);
        label.setText(this.core.getLiteral("Name (POS name):"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.clockPOSPrinterNameEdit = new JTextField();
        this.clockPOSPrinterNameEdit.setHorizontalAlignment(2);
        this.accuShiftPanel.add(this.clockPOSPrinterNameEdit);
        this.clockPOSPrinterNameEdit.setFont(this.editFont);
        this.clockPOSPrinterNameEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.15);
        this.clockPOSPrinterNameEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.clockPOSPrinterNameEdit.addKeyListener(new MyKeyListener());
        this.clockPOSPrinterNameEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.4);
        label = new JLabel();
        this.accuShiftPanel.add(label);
        label.setText(this.core.getLiteral("Printer Name:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.clockPrinterNameEdit = new JTextField();
        this.clockPrinterNameEdit.setHorizontalAlignment(2);
        this.accuShiftPanel.add(this.clockPrinterNameEdit);
        this.clockPrinterNameEdit.setFont(this.editFont);
        this.clockPrinterNameEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.15);
        this.clockPrinterNameEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.clockPrinterNameEdit.addKeyListener(new MyKeyListener());
        this.clockPrinterNameEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.7);
        label = new JLabel();
        this.accuShiftPanel.add(label);
        label.setText(this.core.getLiteral("POS Type:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.clockPrinterPOSTypeBox = new JComboBox();
        this.accuShiftPanel.add(this.clockPrinterPOSTypeBox);
        this.clockPrinterPOSTypeBox.setFont(this.editFont);
        this.clockPrinterPOSTypeBox.setBorder(null);
        this.clockPrinterPOSTypeBox.setBounds(xOffset, yOffset, 100, 20);
        this.clockPrinterPOSTypeBox.addActionListener(new MyActionListener());
        xOffset = (int)((double)panelWidth * 0.05);
        yOffset += (int)((double)panelHeight * 0.075);
        label = new JLabel();
        this.accuShiftPanel.add(label);
        label.setText(this.core.getLiteral("Template:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.clockPrinterTemplateEdit = new JTextField();
        this.clockPrinterTemplateEdit.setHorizontalAlignment(2);
        this.accuShiftPanel.add(this.clockPrinterTemplateEdit);
        this.clockPrinterTemplateEdit.setFont(this.editFont);
        this.clockPrinterTemplateEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.25);
        this.clockPrinterTemplateEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.clockPrinterTemplateEdit.addKeyListener(new MyKeyListener());
        this.clockPrinterTemplateEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.4);
        label = new JLabel();
        this.accuShiftPanel.add(label);
        label.setText(this.core.getLiteral("Report Width:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.clockPrintWidthEdit = new JTextField();
        this.clockPrintWidthEdit.setHorizontalAlignment(2);
        this.accuShiftPanel.add(this.clockPrintWidthEdit);
        this.clockPrintWidthEdit.setFont(this.editFont);
        this.clockPrintWidthEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.05);
        this.clockPrintWidthEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.clockPrintWidthEdit.addKeyListener(new MyKeyListener());
        this.clockPrintWidthEdit.addFocusListener(new MyFocusListener());
        xOffset = (int)((double)panelWidth * 0.7);
        label = new JLabel();
        this.accuShiftPanel.add(label);
        label.setText(this.core.getLiteral("Report Length:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        labelWidth = this.fontMetrics.stringWidth(label.getText());
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        xOffset += labelWidth + 5;
        this.clockPrintLengthEdit = new JTextField();
        this.clockPrintLengthEdit.setHorizontalAlignment(2);
        this.accuShiftPanel.add(this.clockPrintLengthEdit);
        this.clockPrintLengthEdit.setFont(this.editFont);
        this.clockPrintLengthEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)panelWidth * 0.05);
        this.clockPrintLengthEdit.setBounds(xOffset, yOffset, boxWidth, 20);
        this.clockPrintLengthEdit.addKeyListener(new MyKeyListener());
        this.clockPrintLengthEdit.addFocusListener(new MyFocusListener());
    }

    private void loadData() {
        int i;
        POSDataContainer vatRecords;
        int i2;
        int len;
        POSDataContainer salesAccounts;
        this.loadingData = true;
        if (this.countryCodeBox != null) {
            this.countryCodeBox.addItem("US");
            this.countryCodeBox.addItem("CA");
            this.countryCodeBox.addItem("FR");
            this.countryCodeBox.addItem("IL");
            this.countryCodeBox.addItem("UK");
        }
        if (this.databaseDriverBox != null) {
            this.databaseDriverBox.addItem("Standard");
            this.databaseDriverBox.addItem("JadoZoom");
            this.databaseDriverBox.addItem("SQLExpress");
        }
        if (this.accuShiftDriverBox != null) {
            this.accuShiftDriverBox.addItem("Standard");
            this.accuShiftDriverBox.addItem("JadoZoom");
            this.accuShiftDriverBox.addItem("SQLExpress");
        }
        if (this.tipsGLAccountBox != null && (salesAccounts = this.core.getSalesAccounts()) != null) {
            Collections.sort(salesAccounts);
            len = salesAccounts.size();
            for (i2 = 0; i2 < len; ++i2) {
                String glAccount = (String)salesAccounts.get(i2);
                this.tipsGLAccountBox.addItem(glAccount);
            }
        }
        if (this.taxCalculatorTypeBox != null) {
            this.taxCalculatorTypeBox.addItem("AccuServerTaxCalculator");
            this.taxCalculatorTypeBox.addItem("AccuServerTaxCalculatorOntario");
            this.taxCalculatorTypeBox.addItem("AccuServerTaxCalculatorWithAlternates");
            this.taxCalculatorTypeBox.addItem("AccuServerTaxCalculatorWithMaximum");
            this.taxCalculatorTypeBox.addItem("AccuServerTaxCalculatorWithVat2");
            this.taxCalculatorTypeBox.addItem("AccuServerTaxCalculatorWithVatIncluded");
        }
        if (this.carryOutTaxCodeBox != null && (vatRecords = this.core.getVatRecords()) != null) {
            len = vatRecords.size();
            for (i2 = 0; i2 < len; ++i2) {
                ValueAddedTax vat = (ValueAddedTax)vatRecords.get(i2);
                this.carryOutTaxCodeBox.addItem(vat.code);
            }
        }
        if (this.clockPrinterPOSTypeBox != null) {
            this.clockPrinterPOSTypeBox.addItem("PC");
            this.clockPrinterPOSTypeBox.addItem("Mobile");
            this.clockPrinterPOSTypeBox.addItem("Server");
        }
        if (this.integratorTypeBox != null) {
            this.integratorTypeBox.addItem("Standard Integrator");
            this.integratorTypeBox.addItem("QuickBooks Online");
            this.integratorTypeBox.addItem("Sage Live");
        }
        if (this.dateFormatBox != null) {
            String[] dateFormats = new String[]{"MMM dd, yyyy", "dd-MM-yyyy", "dd/MM/yyyy", "MM-dd-yyyy", "MM/dd/yyyy", "yyyy-MM-dd", "yyyy/MM/dd"};
            for (i = 0; i < dateFormats.length; ++i) {
                this.dateFormatBox.addItem(dateFormats[i]);
            }
        }
        if (this.dateTimeFormatBox != null) {
            String[] dateTimeFormats = new String[]{"MMM dd, yyyy HH:mm", "dd/MM/yyyy HH:mm", "MM/dd/yyyy HH:mm", "yyyy/MM/dd HH:mm"};
            for (i = 0; i < dateTimeFormats.length; ++i) {
                this.dateTimeFormatBox.addItem(dateTimeFormats[i]);
            }
        }
        Hashtable settingsParams = new Hashtable();
        String systemSettings = Utility.getElement((String)"Settings", (String)this.configXml, settingsParams);
        if (!settingsParams.isEmpty()) {
            String country = (String)settingsParams.get("Country");
            if (country != null && !country.isEmpty()) {
                this.countryCodeBox.setSelectedItem(country.trim());
            } else {
                this.countryCodeBox.setSelectedItem("US");
            }
            String autoUpdates = (String)settingsParams.get("AutoUpdates");
            if (autoUpdates != null && autoUpdates.equalsIgnoreCase("true")) {
                this.autoUpdatesCheckBox.setSelected(true);
            } else {
                this.autoUpdatesCheckBox.setSelected(false);
            }
            String debugLog = (String)settingsParams.get("DebugLog");
            if (debugLog != null && debugLog.equalsIgnoreCase("true")) {
                this.debugLogCheckBox.setSelected(true);
            } else {
                this.debugLogCheckBox.setSelected(false);
            }
            String removeFoodService = (String)settingsParams.get("RemoveFoodService");
            if (removeFoodService != null && removeFoodService.equalsIgnoreCase("true")) {
                this.removeFoodServiceCheckBox.setSelected(true);
            } else {
                this.removeFoodServiceCheckBox.setSelected(false);
            }
            String printReportsRTL = (String)settingsParams.get("PrintReportsRTL");
            if (printReportsRTL != null && printReportsRTL.equalsIgnoreCase("true")) {
                this.rightToLeftCheckBox.setSelected(true);
            } else {
                this.rightToLeftCheckBox.setSelected(false);
            }
        }
        try {
            Vector moduleParms = new Vector();
            Vector modules = Utility.getElementList((String)"Module", (String)this.configXml, moduleParms);
            int len2 = modules.size();
            for (int i3 = 0; i3 < len2; ++i3) {
                String usePoints;
                String location;
                String merchantId;
                String port;
                String thisModule = (String)modules.get(i3);
                Hashtable parameters = (Hashtable)moduleParms.get(i3);
                if (thisModule.contains("AccuServerConnector.AccuServerSocketConnector")) {
                    port = (String)parameters.get("port");
                    if (port == null || port.isEmpty()) continue;
                    this.socketPortEdit.setText(port);
                    continue;
                }
                if (thisModule.contains("Security.UserSecurityHandler")) {
                    this.secureLoginCheckBox.setSelected(true);
                    continue;
                }
                if (thisModule.contains("AccuServerDataAccess.POSDataAccess")) {
                    String verifyOrders;
                    String password;
                    String user;
                    String databaseName;
                    String host;
                    String backupPath;
                    String msAccessPath;
                    String databaseDriver = (String)parameters.get("dbDriver");
                    if (databaseDriver != null && !databaseDriver.isEmpty()) {
                        this.databaseDriverBox.setSelectedItem(databaseDriver);
                        if (databaseDriver.equalsIgnoreCase("SQLExpress")) {
                            this.sqlExpressPanel.setVisible(true);
                        } else {
                            this.sqlExpressPanel.setVisible(false);
                        }
                    } else {
                        this.databaseDriverBox.setSelectedItem("Standard");
                        this.sqlExpressPanel.setVisible(false);
                    }
                    String databasePath = (String)parameters.get("path");
                    if (databasePath != null && !databasePath.isEmpty()) {
                        this.databasePathEdit.setText(databasePath);
                    }
                    if ((msAccessPath = (String)parameters.get("MsAccessPath")) != null && !msAccessPath.isEmpty()) {
                        this.msAccessPathEdit.setText(msAccessPath);
                    }
                    if ((backupPath = (String)parameters.get("backupPath")) != null && !backupPath.isEmpty()) {
                        this.backupPathEdit.setText(backupPath);
                    }
                    if ((host = (String)parameters.get("Host")) != null && !host.isEmpty()) {
                        this.databaseHostEdit.setText(host);
                    }
                    if ((databaseName = (String)parameters.get("DatabaseName")) != null && !databaseName.isEmpty()) {
                        this.databaseNameEdit.setText(databaseName);
                    }
                    if ((user = (String)parameters.get("User")) != null && !user.isEmpty()) {
                        this.databaseUserEdit.setText(user);
                    }
                    if ((password = (String)parameters.get("Password")) != null && !password.isEmpty()) {
                        this.databasePasswordEdit.setText(password);
                    }
                    if ((verifyOrders = (String)parameters.get("VerifyOrders")) != null && verifyOrders.equalsIgnoreCase("true")) {
                        this.verifyOrdersCheckBox.setSelected(true);
                    } else {
                        this.verifyOrdersCheckBox.setSelected(false);
                    }
                    String clearCustomersOnClosedSales = (String)parameters.get("ClearCustomersOnClosedSales");
                    if (clearCustomersOnClosedSales != null && clearCustomersOnClosedSales.equalsIgnoreCase("true")) {
                        this.clearClosedSalesCustomersCheckBox.setSelected(true);
                        continue;
                    }
                    this.clearClosedSalesCustomersCheckBox.setSelected(false);
                    continue;
                }
                if (thisModule.contains("AccuServerDataAccess.CloudDataAccess")) {
                    this.hasCloudDatabaseCheckBox.setSelected(true);
                    String oneConnection = (String)parameters.get("OneConnection");
                    if (oneConnection != null && oneConnection.equalsIgnoreCase("true")) {
                        this.oneConnectionCheckBox.setSelected(true);
                        continue;
                    }
                    this.oneConnectionCheckBox.setSelected(false);
                    continue;
                }
                if ((thisModule.contains("AccuShiftDataAccess.AccuShiftDataAccess") || thisModule.contains("AccuShiftDataAccess.AccuShiftDataAccessNG")) && this.core.hasLicenseFor("AccuSHIFT")) {
                    this.hasAccuShiftCheckBox.setSelected(true);
                    this.accuShiftPathPanel.setVisible(true);
                    if (thisModule.contains("AccuShiftDataAccess.AccuShiftDataAccessNG")) {
                        this.accuShiftNGCheckBox.setSelected(true);
                    } else {
                        this.accuShiftNGCheckBox.setSelected(false);
                    }
                    String dbDriver = (String)parameters.get("dbDriver");
                    if (dbDriver != null && !dbDriver.isEmpty()) {
                        this.accuShiftDriverBox.setSelectedItem(dbDriver);
                    } else {
                        this.accuShiftDriverBox.setSelectedItem("Standard");
                    }
                    String path = (String)parameters.get("path");
                    if (path == null || path.isEmpty()) continue;
                    this.accuShiftPathEdit.setText(path);
                    continue;
                }
                if (thisModule.contains("AccuServerTaxCalculator.")) {
                    String taxCalculator = thisModule.substring(24);
                    this.taxCalculatorTypeBox.setSelectedItem(taxCalculator);
                    String carryOutNontaxable = (String)parameters.get("CarryOutNontaxable");
                    if (carryOutNontaxable != null && carryOutNontaxable.equalsIgnoreCase("true")) {
                        this.carryOutNotTaxableCheckBox.setSelected(true);
                    } else {
                        this.carryOutNotTaxableCheckBox.setSelected(false);
                    }
                    String carryOutTaxCode = (String)parameters.get("CarryOutTaxCode");
                    if (carryOutTaxCode != null && !carryOutTaxCode.isEmpty()) {
                        this.carryOutTaxCodeBox.setSelectedItem(carryOutTaxCode);
                    }
                    if (taxCalculator.equals("AccuServerTaxCalculator") || taxCalculator.equals("AccuServerTaxCalculatorWithAlternates") || taxCalculator.equals("AccuServerTaxCalculatorWithMaximum")) {
                        this.carryOutNotTaxableCheckBox.setVisible(true);
                        this.carryOutTaxCodeLabel.setVisible(false);
                        this.carryOutTaxCodeBox.setVisible(false);
                        this.carryOutTaxCodeBox.setSelectedIndex(-1);
                        if (taxCalculator.equals("AccuServerTaxCalculatorWithMaximum")) {
                            this.maximumTaxableAmountLabel.setVisible(true);
                            this.maximumTaxableAmountEdit.setVisible(true);
                            String maximumTaxableAmount = (String)parameters.get("MaximumTaxableAmount");
                            if (maximumTaxableAmount == null || maximumTaxableAmount.isEmpty()) continue;
                            this.maximumTaxableAmountEdit.setText(maximumTaxableAmount);
                            continue;
                        }
                        this.maximumTaxableAmountLabel.setVisible(false);
                        this.maximumTaxableAmountEdit.setVisible(false);
                        continue;
                    }
                    this.carryOutNotTaxableCheckBox.setVisible(false);
                    this.carryOutTaxCodeLabel.setVisible(true);
                    this.carryOutTaxCodeBox.setVisible(true);
                    this.maximumTaxableAmountLabel.setVisible(false);
                    this.maximumTaxableAmountEdit.setVisible(false);
                    continue;
                }
                if (thisModule.contains("AccuServerWebServers.AccuServerWebServer")) {
                    String dateTimeFormat;
                    String secure;
                    port = (String)parameters.get("Port");
                    if (port != null && !port.isEmpty()) {
                        this.webServerPortEdit.setText(port);
                    }
                    if ((secure = (String)parameters.get("Secure")) != null && secure.equalsIgnoreCase("true")) {
                        this.webServerSecureCheckBox.setSelected(true);
                    } else {
                        this.webServerSecureCheckBox.setSelected(false);
                    }
                    String timeFormatDecimal = (String)parameters.get("TimeFormatDecimal");
                    if (timeFormatDecimal != null && timeFormatDecimal.equalsIgnoreCase("true")) {
                        this.webServerTimeDecimalCheckBox.setSelected(true);
                    } else {
                        this.webServerTimeDecimalCheckBox.setSelected(false);
                    }
                    String showGraphs = (String)parameters.get("ShowGraphs");
                    if (showGraphs == null) {
                        this.webServerShowGraphsCheckBox.setSelected(true);
                    } else if (showGraphs.equalsIgnoreCase("true")) {
                        this.webServerShowGraphsCheckBox.setSelected(true);
                    } else {
                        this.webServerShowGraphsCheckBox.setSelected(false);
                    }
                    String sessionTimeout = (String)parameters.get("SessionTimeout");
                    if (sessionTimeout != null && !sessionTimeout.isEmpty()) {
                        this.webServerSessionTimeoutEdit.setText(sessionTimeout);
                    } else {
                        this.webServerSessionTimeoutEdit.setText("15");
                    }
                    String dateFormat = (String)parameters.get("DateFormat");
                    if (dateFormat != null && !dateFormat.isEmpty()) {
                        this.dateFormatBox.setSelectedItem(dateFormat);
                    }
                    if ((dateTimeFormat = (String)parameters.get("DateTimeFormat")) == null || dateTimeFormat.isEmpty()) continue;
                    this.dateTimeFormatBox.setSelectedItem(dateTimeFormat);
                    continue;
                }
                if (thisModule.contains("DataHandlers.NetReportServer")) {
                    String stationId;
                    this.hasNetReportServerCheckBox.setSelected(true);
                    String companyId = (String)parameters.get("CompanyId");
                    if (companyId != null && !companyId.isEmpty()) {
                        this.reportCompanyIdEdit.setText(companyId);
                    }
                    if ((stationId = (String)parameters.get("StationId")) == null || stationId.isEmpty()) continue;
                    this.reportStationIdEdit.setText(stationId);
                    continue;
                }
                if (thisModule.contains("DataHandlers.Ad2POSWebServiceClient")) {
                    this.hasAd2POSServiceCheckBox.setSelected(true);
                    merchantId = (String)parameters.get("MerchantId");
                    if (merchantId == null || merchantId.isEmpty()) continue;
                    this.ad2MerchantIdEdit.setText(merchantId);
                    continue;
                }
                if (thisModule.contains("DataHandlers.AccuServerRegionalSyncHandler")) {
                    this.hasRegionalServersCheckBox.setSelected(true);
                    String secure = (String)parameters.get("Secure");
                    if (secure != null && secure.equalsIgnoreCase("true")) {
                        this.regionalServerSecureCheckBox.setSelected(true);
                    } else {
                        this.regionalServerSecureCheckBox.setSelected(false);
                    }
                    String syncInterval = (String)parameters.get("SyncInterval");
                    if (syncInterval == null || syncInterval.isEmpty()) continue;
                    this.regionalServerSyncIntervalEdit.setText(syncInterval);
                    continue;
                }
                if (thisModule.contains("Outputs.TimeClockPrinter")) {
                    String pageLength;
                    String pageWidth;
                    String template;
                    String posType;
                    String printer;
                    String name = (String)parameters.get("Name");
                    if (name != null && !name.isEmpty()) {
                        this.clockPOSPrinterNameEdit.setText(name);
                    }
                    if ((printer = (String)parameters.get("Printer")) != null && !printer.isEmpty()) {
                        this.clockPrinterNameEdit.setText(printer);
                    }
                    if ((posType = (String)parameters.get("POSType")) != null && !posType.isEmpty()) {
                        this.clockPrinterPOSTypeBox.setSelectedItem(posType);
                    }
                    if ((template = (String)parameters.get("Template")) != null && !template.isEmpty()) {
                        this.clockPrinterTemplateEdit.setText(template);
                    }
                    if ((pageWidth = (String)parameters.get("PageWidth")) != null && !pageWidth.isEmpty()) {
                        this.clockPrintWidthEdit.setText(pageWidth);
                    }
                    if ((pageLength = (String)parameters.get("PageLength")) == null || pageLength.isEmpty()) continue;
                    this.clockPrintLengthEdit.setText(pageLength);
                    continue;
                }
                if (thisModule.contains("Outputs.RemoteDisplay")) {
                    if (!this.core.hasLicenseFor("RemoteDisplay")) continue;
                    if (thisModule.contains("Outputs.RemoteDisplayHandler")) {
                        this.hasIntegratedRemoteDisplayCheckBox.setSelected(true);
                        String logRemoteDisplay = (String)parameters.get("Log");
                        if (logRemoteDisplay != null && logRemoteDisplay.equalsIgnoreCase("true")) {
                            this.logIntegratedRemoteDisplayCheckBox.setSelected(true);
                            continue;
                        }
                        this.logIntegratedRemoteDisplayCheckBox.setSelected(false);
                        continue;
                    }
                    this.hasRemoteDisplayCheckBox.setSelected(true);
                    String showRemoteDisplay = (String)parameters.get("Show");
                    if (showRemoteDisplay != null && showRemoteDisplay.equalsIgnoreCase("true")) {
                        this.showRemoteDisplayCheckBox.setSelected(true);
                    } else {
                        this.showRemoteDisplayCheckBox.setSelected(false);
                    }
                    String host = (String)parameters.get("Host");
                    if (host == null || host.isEmpty()) continue;
                    this.remoteDisplayHostEdit.setText(host);
                    continue;
                }
                if (thisModule.contains("Outputs.EmailReceipt")) {
                    String emailSignature;
                    String emailSubject = (String)parameters.get("EmailSubject");
                    if (emailSubject != null && !emailSubject.isEmpty()) {
                        this.emailSubjectEdit.setText(emailSubject);
                    }
                    if ((emailSignature = (String)parameters.get("EmailSignature")) != null && emailSignature.equalsIgnoreCase("true")) {
                        this.emailSignatureCheckBox.setSelected(true);
                    } else {
                        this.emailSignatureCheckBox.setSelected(false);
                    }
                    String poweredByAccuPOS = (String)parameters.get("PoweredByAccuPOS");
                    this.showPoweredByAccuPOS = poweredByAccuPOS == null || poweredByAccuPOS.equalsIgnoreCase("true");
                    if (this.poweredByAccuPOSCheckBox == null) continue;
                    this.poweredByAccuPOSCheckBox.setSelected(this.showPoweredByAccuPOS);
                    continue;
                }
                if (thisModule.contains("Outputs.EmailException")) {
                    String email = (String)parameters.get("Email");
                    if (email != null && !email.isEmpty()) {
                        this.emailExceptionsCheckBox.setSelected(true);
                        this.emailExceptionsPanel.setVisible(true);
                        String[] emails = email.split(";");
                        for (int j = 0; j < emails.length; ++j) {
                            this.emailExceptionsEdit[j].setText(emails[j]);
                        }
                        continue;
                    }
                    this.emailExceptionsCheckBox.setSelected(false);
                    this.emailExceptionsPanel.setVisible(false);
                    for (int j = 0; j < 5; ++j) {
                        this.emailExceptionsEdit[j].setText("");
                    }
                    continue;
                }
                if (thisModule.contains("CardHandlers.")) {
                    String cardHandler = thisModule.substring(13);
                    if (cardHandler.equalsIgnoreCase("CardHandler")) {
                        this.hasCardHandlerCheckBox.setSelected(true);
                        continue;
                    }
                    if (cardHandler.equalsIgnoreCase("GiftCardHandler")) {
                        this.hasGiftCardHandlerCheckBox.setSelected(true);
                        continue;
                    }
                    if (cardHandler.equalsIgnoreCase("CardPostAuthProcessor")) {
                        this.hasCardPostAuthHandlerCheckBox.setSelected(true);
                        this.postAuthEmailPanel.setVisible(true);
                        String email = (String)parameters.get("Email");
                        if (email == null || email.isEmpty()) continue;
                        String[] emails = email.split(";");
                        for (int j = 0; j < emails.length; ++j) {
                            this.postAuthEmailEdit[j].setText(emails[j]);
                        }
                        continue;
                    }
                    if (cardHandler.equalsIgnoreCase("CibusCardHandler")) {
                        String debug;
                        String posId;
                        this.hasCibusCardHandlerCheckBox.setSelected(true);
                        String resId = (String)parameters.get("ResId");
                        if (resId != null && !resId.isEmpty()) {
                            this.cibusResIdEdit.setText(resId);
                        }
                        if ((posId = (String)parameters.get("PosId")) != null && !posId.isEmpty()) {
                            this.cibusPosIdEdit.setText(posId);
                        }
                        if ((debug = (String)parameters.get("Debug")) != null && debug.equalsIgnoreCase("true")) {
                            this.cibusDebugCheckBox.setSelected(true);
                            continue;
                        }
                        this.cibusDebugCheckBox.setSelected(false);
                        continue;
                    }
                    if (cardHandler.equalsIgnoreCase("TenbisCardHandler")) {
                        String debug;
                        String vendor;
                        String resId;
                        String userPassword;
                        this.hasTenbisCardHandlerCheckBox.setSelected(true);
                        String userName = (String)parameters.get("UserName");
                        if (userName != null && !userName.isEmpty()) {
                            this.tenbisUserNameEdit.setText(userName);
                        }
                        if ((userPassword = (String)parameters.get("UserPassword")) != null && !userPassword.isEmpty()) {
                            this.tenbisUserPasswordEdit.setText(userPassword);
                        }
                        if ((resId = (String)parameters.get("ResId")) != null && !resId.isEmpty()) {
                            this.tenbisResIdEdit.setText(resId);
                        }
                        if ((vendor = (String)parameters.get("Vendor")) != null && !vendor.isEmpty()) {
                            this.tenbisVendorEdit.setText(vendor);
                        }
                        if ((debug = (String)parameters.get("Debug")) != null && debug.equalsIgnoreCase("true")) {
                            this.tenbisDebugCheckBox.setSelected(true);
                            continue;
                        }
                        this.tenbisDebugCheckBox.setSelected(false);
                        continue;
                    }
                    if (!cardHandler.equalsIgnoreCase("EConduitCardHandler")) continue;
                    this.hasEConduitCardHandlerCheckBox.setSelected(true);
                    String debug = (String)parameters.get("Debug");
                    if (debug != null && debug.equalsIgnoreCase("true")) {
                        this.eConduitDebugCheckBox.setSelected(true);
                        continue;
                    }
                    this.eConduitDebugCheckBox.setSelected(false);
                    continue;
                }
                if (thisModule.contains("AccuServerIntegrator.")) {
                    if (!this.core.hasLicenseFor("AccountingIntegration")) continue;
                    this.hasAccountingCheckBox.setSelected(true);
                    String integrator = thisModule.substring(21);
                    for (int j = 0; j < integratorValues.length; ++j) {
                        if (!integrator.equalsIgnoreCase(integratorValues[j])) continue;
                        this.integratorTypeBox.setSelectedIndex(j);
                    }
                    String integrationPath = (String)parameters.get("integrationPath");
                    if (integrationPath != null && !integrationPath.isEmpty()) {
                        this.integratorPathEdit.setText(integrationPath);
                    } else {
                        integrationPath = (String)parameters.get("IntegrationPath");
                        if (integrationPath != null && !integrationPath.isEmpty()) {
                            this.integratorPathEdit.setText(integrationPath);
                        } else {
                            integrationPath = (String)parameters.get("AdapterFolder");
                            if (integrationPath != null && !integrationPath.isEmpty()) {
                                this.integratorPathEdit.setText(integrationPath);
                            } else {
                                integrationPath = (String)parameters.get("AdapterPath");
                                if (integrationPath != null && !integrationPath.isEmpty()) {
                                    this.integratorPathEdit.setText(integrationPath);
                                }
                            }
                        }
                    }
                    String itemUpdate = (String)parameters.get("itemUpdate");
                    if (itemUpdate != null && itemUpdate.equalsIgnoreCase("true")) {
                        this.updateItemPricesCheckBox.setSelected(true);
                    } else {
                        this.updateItemPricesCheckBox.setSelected(false);
                    }
                    String skipItemsOver20 = (String)parameters.get("SkipItemsOver20");
                    if (skipItemsOver20 != null && skipItemsOver20.equalsIgnoreCase("true")) {
                        this.skipItemsover20CheckBox.setSelected(true);
                    } else {
                        this.skipItemsover20CheckBox.setSelected(false);
                    }
                    String summarizeAllCashSales = (String)parameters.get("SummarizeAllCashSales");
                    if (summarizeAllCashSales != null && summarizeAllCashSales.equalsIgnoreCase("true")) {
                        this.summarizeCashSalesCheckBox.setSelected(true);
                    } else {
                        this.summarizeCashSalesCheckBox.setSelected(false);
                    }
                    String updateItemTypes = (String)parameters.get("UpdateItemTypes");
                    if (updateItemTypes != null && updateItemTypes.equalsIgnoreCase("true")) {
                        this.updateItemTypesCheckBox.setSelected(false);
                    } else {
                        this.updateItemTypesCheckBox.setSelected(true);
                    }
                    String useAutomatedTax = (String)parameters.get("AutomatedTax");
                    if (useAutomatedTax != null && useAutomatedTax.equalsIgnoreCase("true")) {
                        this.useAutomatedTaxCheckBox.setSelected(true);
                    } else {
                        this.useAutomatedTaxCheckBox.setSelected(false);
                    }
                    if (integrator.equalsIgnoreCase("AccuServerSageLiveIntegrator")) {
                        this.skipItemsover20CheckBox.setVisible(false);
                        this.summarizeCashSalesCheckBox.setVisible(true);
                        this.updateItemTypesCheckBox.setVisible(false);
                        this.useAutomatedTaxCheckBox.setVisible(false);
                        continue;
                    }
                    if (integrator.equalsIgnoreCase("AccuServerQBOIntegrator")) {
                        this.skipItemsover20CheckBox.setVisible(false);
                        this.summarizeCashSalesCheckBox.setVisible(true);
                        this.updateItemTypesCheckBox.setVisible(true);
                        this.useAutomatedTaxCheckBox.setVisible(true);
                        continue;
                    }
                    this.skipItemsover20CheckBox.setVisible(true);
                    this.summarizeCashSalesCheckBox.setVisible(true);
                    this.updateItemTypesCheckBox.setVisible(false);
                    this.useAutomatedTaxCheckBox.setVisible(false);
                    continue;
                }
                if (thisModule.contains("CustomerHandlers.LoyaltyHandler")) {
                    String compReason;
                    String location2;
                    this.hasLoyaltyHandlerCheckBox.setSelected(true);
                    merchantId = (String)parameters.get("MerchantId");
                    if (merchantId != null && !merchantId.isEmpty()) {
                        this.loyaltyMerchantIdEdit.setText(merchantId);
                    }
                    if ((location2 = (String)parameters.get("Location")) != null && !location2.isEmpty()) {
                        this.loyaltyLocationEdit.setText(location2);
                    }
                    if ((compReason = (String)parameters.get("CompReason")) == null || compReason.isEmpty()) continue;
                    this.loyaltyCompReasonEdit.setText(compReason);
                    continue;
                }
                if (!thisModule.contains("CustomerHandlers.ComoLoyaltyHandler")) continue;
                this.hasComoLoyaltyCheckBox.setSelected(true);
                merchantId = (String)parameters.get("MerchantId");
                if (merchantId != null && !merchantId.isEmpty()) {
                    this.comoLoyaltyMerchantIdEdit.setText(merchantId);
                }
                if ((location = (String)parameters.get("Location")) != null && !location.isEmpty()) {
                    this.comoLoyaltyLocationEdit.setText(location);
                }
                if ((usePoints = (String)parameters.get("UsePoints")) != null && usePoints.equalsIgnoreCase("true")) {
                    this.useComoPointsCheckBox.setSelected(true);
                    this.useComoCreditsCheckBox.setSelected(false);
                    continue;
                }
                this.useComoPointsCheckBox.setSelected(false);
                this.useComoCreditsCheckBox.setSelected(true);
            }
        }
        catch (Exception e) {
            String em = e.toString();
            this.core.raiseException(e);
        }
        this.loadingData = false;
    }

    private void saveData() {
        int i;
        PrinterConfigSetup printerSetup;
        int i2;
        int len;
        String moduleName = "";
        String parmString = "";
        boolean parmChecked = false;
        Vector modules = Utility.getElementList((String)"Module", (String)this.configXml);
        moduleName = "Settings";
        parmString = (String)this.countryCodeBox.getSelectedItem();
        this.editModuleLine(moduleName, "Country", parmString.trim());
        this.core.setCountry(parmString.trim());
        parmChecked = this.autoUpdatesCheckBox.isSelected();
        this.editModuleLine(moduleName, "AutoUpdates", "" + parmChecked);
        parmChecked = this.debugLogCheckBox.isSelected();
        this.editModuleLine(moduleName, "DebugLog", "" + parmChecked);
        this.core.setDebugLogging(parmChecked);
        parmChecked = this.removeFoodServiceCheckBox.isSelected();
        this.editModuleLine(moduleName, "RemoveFoodService", "" + parmChecked);
        this.core.setRemoveFoodService(parmChecked);
        parmChecked = this.rightToLeftCheckBox.isSelected();
        this.editModuleLine(moduleName, "PrintReportsRTL", "" + parmChecked);
        this.core.setPrintReportsRTL(parmChecked);
        if (this.currentTipsTender != null) {
            this.core.updateTenderCode(this.currentTipsTender);
        }
        this.editModuleLine(moduleName, "TipsTenderCode", this.tipsTenderCode);
        this.core.setTipsTenderCode(this.tipsTenderCode);
        moduleName = "Security.UserSecurityHandler";
        parmChecked = this.secureLoginCheckBox.isSelected();
        if (parmChecked && !modules.contains(moduleName)) {
            this.addModuleLine(moduleName);
        } else if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        }
        moduleName = "AccuServerConnector.AccuServerSocketConnector";
        this.editModuleLine(moduleName, "secure", "true");
        parmString = this.socketPortEdit.getText().trim();
        this.editModuleLine(moduleName, "port", parmString);
        moduleName = "AccuServerTaxCalculator." + (String)this.taxCalculatorTypeBox.getSelectedItem();
        if (!modules.contains(moduleName)) {
            this.addModuleLine(moduleName);
            len = this.taxCalculatorTypeBox.getItemCount();
            for (i2 = 0; i2 < len; ++i2) {
                String otherModule = "AccuServerTaxCalculator." + (String)this.taxCalculatorTypeBox.getItemAt(i2);
                if (otherModule.equalsIgnoreCase(moduleName) || !modules.contains(otherModule)) continue;
                this.removeModuleLine(otherModule);
            }
        }
        if (this.carryOutNotTaxableCheckBox.isVisible()) {
            parmChecked = this.carryOutNotTaxableCheckBox.isSelected();
            this.editModuleLine(moduleName, "CarryOutNontaxable", "" + parmChecked);
        } else {
            this.editModuleLine(moduleName, "CarryOutNontaxable", "");
        }
        parmString = "";
        if (this.carryOutTaxCodeBox.isVisible()) {
            parmString = (String)this.carryOutTaxCodeBox.getSelectedItem();
        }
        this.editModuleLine(moduleName, "CarryOutTaxCode", parmString);
        parmString = "";
        if (this.maximumTaxableAmountEdit.isVisible()) {
            parmString = this.maximumTaxableAmountEdit.getText();
        }
        this.editModuleLine(moduleName, "MaximumTaxableAmount", parmString);
        moduleName = "AccuServerDataAccess.POSDataAccess";
        parmString = (String)this.databaseDriverBox.getSelectedItem();
        this.editModuleLine(moduleName, "dbDriver", parmString);
        parmString = this.databasePathEdit.getText().trim();
        this.editModuleLine(moduleName, "path", parmString);
        parmString = this.msAccessPathEdit.getText().trim();
        this.editModuleLine(moduleName, "MsAccessPath", parmString);
        parmString = this.backupPathEdit.getText().trim();
        this.editModuleLine(moduleName, "backupPath", parmString);
        parmString = this.databaseHostEdit.getText().trim();
        this.editModuleLine(moduleName, "Host", parmString);
        parmString = this.databaseNameEdit.getText().trim();
        this.editModuleLine(moduleName, "DatabaseName", parmString);
        parmString = this.databaseUserEdit.getText().trim();
        this.editModuleLine(moduleName, "User", parmString);
        parmString = this.databasePasswordEdit.getText().trim();
        this.editModuleLine(moduleName, "Password", parmString);
        parmChecked = this.verifyOrdersCheckBox.isSelected();
        this.editModuleLine(moduleName, "VerifyOrders", "" + parmChecked);
        parmChecked = this.clearClosedSalesCustomersCheckBox.isSelected();
        this.editModuleLine(moduleName, "ClearCustomersOnClosedSales", "" + parmChecked);
        moduleName = "AccuServerDataAccess.CloudDataAccess";
        boolean bl = parmChecked = this.hasCloudDatabaseCheckBox != null && this.hasCloudDatabaseCheckBox.isSelected();
        if (!parmChecked || this.core.isMobileServer() && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
                Date today = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMddyyyy");
                this.editModuleLine(moduleName, "SyncStartDate", dateFormat.format(today));
            }
            parmChecked = this.oneConnectionCheckBox.isSelected();
            this.editModuleLine(moduleName, "OneConnection", "" + parmChecked);
        }
        moduleName = "AccuServerWebServers.AccuServerWebServer";
        parmString = this.webServerPortEdit.getText().trim();
        this.editModuleLine(moduleName, "Port", parmString);
        parmChecked = this.webServerSecureCheckBox.isSelected();
        this.editModuleLine(moduleName, "Secure", "" + parmChecked);
        parmChecked = this.webServerTimeDecimalCheckBox.isSelected();
        this.editModuleLine(moduleName, "TimeFormatDecimal", "" + parmChecked);
        parmChecked = this.webServerShowGraphsCheckBox.isSelected();
        this.editModuleLine(moduleName, "ShowGraphs", "" + parmChecked);
        parmString = this.webServerSessionTimeoutEdit.getText().trim();
        this.editModuleLine(moduleName, "SessionTimeout", parmString);
        parmString = (String)this.dateFormatBox.getSelectedItem();
        this.editModuleLine(moduleName, "DateFormat", parmString);
        parmString = (String)this.dateTimeFormatBox.getSelectedItem();
        this.editModuleLine(moduleName, "DateTimeFormat", parmString);
        moduleName = "DataHandlers.NetReportServer";
        boolean bl2 = parmChecked = this.hasNetReportServerCheckBox != null && this.hasNetReportServerCheckBox.isSelected();
        if (!parmChecked || this.core.isMobileServer() && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmString = this.reportCompanyIdEdit.getText().trim();
            this.editModuleLine(moduleName, "CompanyId", parmString);
            parmString = this.reportStationIdEdit.getText().trim();
            this.editModuleLine(moduleName, "StationId", "" + parmString);
        }
        moduleName = "DataHandlers.Ad2POSWebServiceClient";
        parmChecked = this.hasAd2POSServiceCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmString = this.ad2MerchantIdEdit.getText().trim();
            this.editModuleLine(moduleName, "MerchantId", parmString);
        }
        moduleName = "DataHandlers.AccuServerRegionalSyncHandler";
        parmChecked = this.hasRegionalServersCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmChecked = this.regionalServerSecureCheckBox.isSelected();
            this.editModuleLine(moduleName, "Secure", "" + parmChecked);
            parmString = this.regionalServerSyncIntervalEdit.getText().trim();
            this.editModuleLine(moduleName, "SyncInterval", parmString);
        }
        if (this.printerSetups != null && !this.printerSetups.isEmpty()) {
            len = this.printerSetups.size();
            for (i2 = 0; i2 < len; ++i2) {
                printerSetup = (PrinterConfigSetup)this.printerSetups.get(i2);
                if (!printerSetup.changed && !this.poweredByAccuPOSChanged) continue;
                this.restartRequired = true;
                moduleName = "Outputs." + printerSetup.printerType;
                this.removePrinterModuleLine(moduleName, printerSetup.printerPOSName);
                this.addPrinterModuleLine(moduleName, printerSetup.printerPOSName);
                parmString = printerSetup.printerPOSName;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "Name", parmString);
                parmString = printerSetup.printerName;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "Printer", parmString);
                parmString = printerSetup.printerPOSType;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "POSType", parmString);
                parmString = printerSetup.printerReceiptTemplate;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "Template", parmString);
                parmChecked = printerSetup.printerSummarizeItems;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "SummarizeItems", "" + parmChecked);
                parmChecked = printerSetup.printerSummarizeTaxes;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "SummarizeTaxes", "" + parmChecked);
                if (printerSetup.printerPrintWidth > 0) {
                    parmString = "" + printerSetup.printerPrintWidth;
                    this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "PageWidth", parmString);
                }
                if (printerSetup.printerPrintLength > 0) {
                    parmString = "" + printerSetup.printerPrintLength;
                    this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "PageLength", parmString);
                }
                if (printerSetup.printerAdDelay > 0) {
                    parmString = "" + printerSetup.printerAdDelay;
                    this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "AdDelay", parmString);
                }
                for (int j = 0; j < 5; ++j) {
                    parmString = printerSetup.printerTipPercentage[j];
                    if (parmString == null || parmString.isEmpty()) continue;
                    this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "TipPercent" + (j + 1), parmString);
                }
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "PoweredByAccuPOS", "" + this.showPoweredByAccuPOS);
            }
        }
        if (this.shiftPrinterSetups != null && !this.shiftPrinterSetups.isEmpty()) {
            len = this.shiftPrinterSetups.size();
            for (i2 = 0; i2 < len; ++i2) {
                printerSetup = (PrinterConfigSetup)this.shiftPrinterSetups.get(i2);
                if (!printerSetup.changed) continue;
                this.restartRequired = true;
                moduleName = "Outputs." + printerSetup.printerType;
                this.removePrinterModuleLine(moduleName, printerSetup.printerPOSName);
                this.addPrinterModuleLine(moduleName, printerSetup.printerPOSName);
                parmString = printerSetup.printerPOSName;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "Name", parmString);
                parmString = printerSetup.printerName;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "Printer", parmString);
                parmString = printerSetup.printerPOSType;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "POSType", parmString);
                parmString = printerSetup.printerServerReportTemplate;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "ServerTemplate", parmString);
                parmString = printerSetup.printerResetReportTemplate;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "ReadResetTemplate", parmString);
                if (printerSetup.printerPrintWidth > 0) {
                    parmString = "" + printerSetup.printerPrintWidth;
                    this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "PageWidth", parmString);
                }
                if (printerSetup.printerPrintLength <= 0) continue;
                parmString = "" + printerSetup.printerPrintLength;
                this.editPrinterModuleLine(moduleName, printerSetup.printerPOSName, "PageLength", parmString);
            }
        }
        if (this.removePrinterList != null && !this.removePrinterList.isEmpty()) {
            len = this.removePrinterList.size();
            for (i2 = 0; i2 < len; ++i2) {
                printerSetup = (PrinterConfigSetup)this.removePrinterList.get(i2);
                if (!printerSetup.changed || !printerSetup.remove) continue;
                this.restartRequired = true;
                moduleName = "Outputs." + printerSetup.printerType;
                this.removePrinterModuleLine(moduleName, printerSetup.printerPOSName);
            }
        }
        moduleName = "Outputs.RemoteDisplay";
        boolean bl3 = parmChecked = this.hasRemoteDisplayCheckBox != null && this.hasRemoteDisplayCheckBox.isSelected();
        if (!parmChecked || !this.core.hasLicenseFor("RemoteDisplay") || this.core.isMobileServer() && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmChecked = this.showRemoteDisplayCheckBox.isSelected();
            this.editModuleLine(moduleName, "Show", "" + parmChecked);
            parmString = this.remoteDisplayHostEdit.getText().trim();
            this.editModuleLine(moduleName, "Host", parmString);
        }
        moduleName = "Outputs.RemoteDisplayHandler";
        boolean bl4 = parmChecked = this.hasIntegratedRemoteDisplayCheckBox != null && this.hasIntegratedRemoteDisplayCheckBox.isSelected();
        if (!parmChecked || !this.core.hasLicenseFor("RemoteDisplay") && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmChecked = this.logIntegratedRemoteDisplayCheckBox.isSelected();
            this.editModuleLine(moduleName, "Log", "" + parmChecked);
        }
        moduleName = "Outputs.EmailReceipt";
        if (!modules.contains(moduleName)) {
            this.addModuleLine(moduleName);
        }
        parmString = this.emailSubjectEdit.getText().trim();
        this.editModuleLine(moduleName, "EmailSubject", parmString);
        parmChecked = this.emailSignatureCheckBox.isSelected();
        this.editModuleLine(moduleName, "EmailSignature", "" + parmChecked);
        this.editModuleLine(moduleName, "PoweredByAccuPOS", "" + this.showPoweredByAccuPOS);
        moduleName = "Outputs.EmailException";
        parmChecked = this.emailExceptionsCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmString = "";
            for (i = 0; i < 5; ++i) {
                String emailString = this.emailExceptionsEdit[i].getText().trim();
                if (emailString == null || emailString.isEmpty()) continue;
                parmString = !parmString.isEmpty() ? parmString + ";" + emailString : parmString + emailString;
            }
            this.editModuleLine(moduleName, "Email", parmString);
        }
        moduleName = "CardHandlers.CardHandler";
        parmChecked = this.hasCardHandlerCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked && !modules.contains(moduleName)) {
            this.addModuleLine(moduleName);
        }
        moduleName = "CardHandlers.GiftCardHandler";
        parmChecked = this.hasGiftCardHandlerCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked && !modules.contains(moduleName)) {
            this.addModuleLine(moduleName);
        }
        moduleName = "CardHandlers.CardPostAuthProcessor";
        parmChecked = this.hasCardPostAuthHandlerCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmString = "";
            for (i = 0; i < 5; ++i) {
                String emailString = this.postAuthEmailEdit[i].getText().trim();
                if (emailString == null || emailString.isEmpty()) continue;
                parmString = !parmString.isEmpty() ? parmString + ";" + emailString : parmString + emailString;
            }
            this.editModuleLine(moduleName, "Email", parmString);
        }
        moduleName = "CardHandlers.CibusCardHandler";
        parmChecked = this.hasCibusCardHandlerCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmString = this.cibusResIdEdit.getText().trim();
            this.editModuleLine(moduleName, "ResId", parmString);
            parmString = this.cibusPosIdEdit.getText().trim();
            this.editModuleLine(moduleName, "PosId", parmString);
            parmChecked = this.cibusDebugCheckBox.isSelected();
            this.editModuleLine(moduleName, "Debug", "" + parmChecked);
        }
        moduleName = "CardHandlers.TenbisCardHandler";
        parmChecked = this.hasTenbisCardHandlerCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmString = this.tenbisUserNameEdit.getText().trim();
            this.editModuleLine(moduleName, "UserName", parmString);
            parmString = this.tenbisUserPasswordEdit.getText().trim();
            this.editModuleLine(moduleName, "UserPassword", parmString);
            parmString = this.tenbisResIdEdit.getText().trim();
            this.editModuleLine(moduleName, "ResId", parmString);
            parmString = this.tenbisVendorEdit.getText().trim();
            this.editModuleLine(moduleName, "Vendor", parmString);
            parmChecked = this.tenbisDebugCheckBox.isSelected();
            this.editModuleLine(moduleName, "Debug", "" + parmChecked);
        }
        moduleName = "CardHandlers.EConduitCardHandler";
        parmChecked = this.hasEConduitCardHandlerCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmChecked = this.eConduitDebugCheckBox.isSelected();
            this.editModuleLine(moduleName, "Debug", "" + parmChecked);
        }
        boolean bl5 = parmChecked = this.hasAccountingCheckBox != null && this.hasAccountingCheckBox.isSelected();
        if (!parmChecked || !this.core.hasLicenseFor("AccountingIntegration")) {
            for (i = 0; i < integratorValues.length; ++i) {
                moduleName = "AccuServerIntegrator." + integratorValues[i];
                if (!modules.contains(moduleName)) continue;
                this.removeModuleLine(moduleName);
            }
        } else if (parmChecked) {
            int integratorSelectedIndex = this.integratorTypeBox.getSelectedIndex();
            String integrator = integratorValues[integratorSelectedIndex];
            moduleName = "AccuServerIntegrator." + integrator;
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
                for (int i3 = 0; i3 < integratorValues.length; ++i3) {
                    String otherModule = "AccuServerIntegrator." + integratorValues[i3];
                    if (otherModule.equalsIgnoreCase(moduleName) || !modules.contains(otherModule)) continue;
                    this.removeModuleLine(otherModule);
                }
            }
            parmString = this.integratorPathEdit.getText().trim();
            this.editModuleLine(moduleName, "integrationPath", parmString);
            parmChecked = this.updateItemPricesCheckBox.isSelected();
            this.editModuleLine(moduleName, "itemUpdate", "" + parmChecked);
            if (!integrator.equalsIgnoreCase("AccuServerSageLiveIntegrator")) {
                parmChecked = this.summarizeCashSalesCheckBox.isSelected();
                this.editModuleLine(moduleName, "SummarizeAllCashSales", "" + parmChecked);
            }
            if (integrator.equalsIgnoreCase("AccuServerQBOIntegrator")) {
                parmChecked = this.updateItemTypesCheckBox.isSelected();
                this.editModuleLine(moduleName, "UpdateItemTypes", "" + !parmChecked);
                parmChecked = this.useAutomatedTaxCheckBox.isSelected();
                this.editModuleLine(moduleName, "AutomatedTax", "" + parmChecked);
            }
        }
        moduleName = "CustomerHandlers.LoyaltyHandler";
        parmChecked = this.hasLoyaltyHandlerCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmString = this.loyaltyMerchantIdEdit.getText().trim();
            this.editModuleLine(moduleName, "MerchantId", parmString);
            parmString = this.loyaltyLocationEdit.getText().trim();
            this.editModuleLine(moduleName, "Location", parmString);
            parmString = this.loyaltyCompReasonEdit.getText().trim();
            this.editModuleLine(moduleName, "CompReason", parmString);
        }
        moduleName = "CustomerHandlers.ComoLoyaltyHandler";
        parmChecked = this.hasComoLoyaltyCheckBox.isSelected();
        if (!parmChecked && modules.contains(moduleName)) {
            this.removeModuleLine(moduleName);
        } else if (parmChecked) {
            if (!modules.contains(moduleName)) {
                this.addModuleLine(moduleName);
            }
            parmString = this.comoLoyaltyMerchantIdEdit.getText().trim();
            this.editModuleLine(moduleName, "MerchantId", parmString);
            parmString = this.comoLoyaltyLocationEdit.getText().trim();
            this.editModuleLine(moduleName, "Location", parmString);
            parmChecked = this.useComoPointsCheckBox.isSelected();
            this.editModuleLine(moduleName, "UsePoints", "" + parmChecked);
        }
        boolean bl6 = parmChecked = this.hasAccuShiftCheckBox != null && this.hasAccuShiftCheckBox.isSelected();
        if (!parmChecked || !this.core.hasLicenseFor("AccuSHIFT")) {
            moduleName = "AccuShiftDataAccess.AccuShiftDataAccess";
            if (modules.contains(moduleName)) {
                this.removeModuleLine(moduleName);
            }
            if (modules.contains(moduleName = "AccuShiftDataAccess.AccuShiftDataAccessNG")) {
                this.removeModuleLine(moduleName);
            }
            if (modules.contains(moduleName = "Outputs.TimeClockPrinter")) {
                this.removeModuleLine(moduleName);
            }
        } else if (parmChecked) {
            if (!this.accuShiftNGCheckBox.isSelected()) {
                moduleName = "AccuShiftDataAccess.AccuShiftDataAccessNG";
                if (modules.contains(moduleName)) {
                    this.removeModuleLine(moduleName);
                }
                if (!modules.contains(moduleName = "AccuShiftDataAccess.AccuShiftDataAccess")) {
                    this.addModuleLine(moduleName);
                }
            } else {
                moduleName = "AccuShiftDataAccess.AccuShiftDataAccess";
                if (modules.contains(moduleName)) {
                    this.removeModuleLine(moduleName);
                }
                if (!modules.contains(moduleName = "AccuShiftDataAccess.AccuShiftDataAccessNG")) {
                    this.addModuleLine(moduleName);
                }
            }
            parmString = (String)this.accuShiftDriverBox.getSelectedItem();
            this.editModuleLine(moduleName, "dbDriver", parmString);
            if (parmString.equalsIgnoreCase("sqlexpress")) {
                parmString = this.databaseHostEdit.getText().trim();
                this.editModuleLine(moduleName, "Host", parmString);
                parmString = this.databaseNameEdit.getText().trim();
                this.editModuleLine(moduleName, "DatabaseName", parmString);
                parmString = this.databaseUserEdit.getText().trim();
                this.editModuleLine(moduleName, "User", parmString);
                parmString = this.databasePasswordEdit.getText().trim();
                this.editModuleLine(moduleName, "Password", parmString);
            } else {
                parmString = this.accuShiftPathEdit.getText().trim();
                this.editModuleLine(moduleName, "path", parmString);
            }
            moduleName = "Outputs.TimeClockPrinter";
            String timeClockPrinter = this.clockPOSPrinterNameEdit.getText().trim();
            if (timeClockPrinter != null && !timeClockPrinter.isEmpty()) {
                if (!modules.contains(moduleName)) {
                    this.addModuleLine(moduleName);
                }
                parmString = this.clockPOSPrinterNameEdit.getText().trim();
                this.editModuleLine(moduleName, "Name", parmString);
                parmString = this.clockPrinterNameEdit.getText().trim();
                this.editModuleLine(moduleName, "Printer", parmString);
                parmString = (String)this.clockPrinterPOSTypeBox.getSelectedItem();
                this.editModuleLine(moduleName, "POSType", parmString);
                parmString = this.clockPrinterTemplateEdit.getText().trim();
                this.editModuleLine(moduleName, "Template", parmString);
                parmString = this.clockPrintWidthEdit.getText().trim();
                this.editModuleLine(moduleName, "PageWidth", parmString);
                parmString = this.clockPrintLengthEdit.getText().trim();
                this.editModuleLine(moduleName, "PageLength", parmString);
            } else if (modules.contains(moduleName)) {
                this.removeModuleLine(moduleName);
            }
        }
        this.core.updateAccuServerConfigFile(this.configXml);
        if (this.restartRequired) {
            Object[] buttons = new String[]{this.core.getLiteral("Cancel"), this.core.getLiteral("Confirm Restart")};
            String configTitle = this.core.getLiteral("AccuServer Config");
            String configMsg1 = this.core.getLiteral("For changes to AccuServer configuration to become effective, the server must be restarted.");
            String configMsg2 = this.core.getLiteral("Before restarting AccuServer make sure all POS units are not in use.");
            String configMsg3 = this.core.getLiteral("Restart AccuServer?");
            int response = JOptionPane.showOptionDialog(this, configMsg1 + "\n\n" + configMsg2 + "\n\n" + configMsg3 + "\n\n", configTitle, 1, 1, null, buttons, buttons[0]);
            if (response == 1) {
                this.core.restartAccuServer();
            }
        }
    }

    private void addModuleLine(String module) {
        StringBuilder xml = new StringBuilder();
        xml.append(this.configXml);
        xml.append("\r\n<Module>");
        xml.append(module);
        xml.append("</Module>\r\n");
        this.configXml = xml.toString();
    }

    private void addPrinterModuleLine(String module, String printerPOSName) {
        StringBuilder xml = new StringBuilder();
        xml.append(this.configXml);
        xml.append("\n<Module ");
        xml.append("Name=");
        xml.append(printerPOSName);
        xml.append(">");
        xml.append(module);
        xml.append("</Module>");
        this.configXml = xml.toString();
    }

    public void removeModuleLine(String module) {
        String moduleLine = this.getModuleLine(module);
        this.configXml = this.configXml.replace(moduleLine, "");
    }

    public void removePrinterModuleLine(String module, String printerPOSName) {
        String moduleLine = this.getPrinterModuleLine(module, printerPOSName);
        this.configXml = this.configXml.replace(moduleLine, "");
    }

    private void editModuleLine(String module, String parameter, String value) {
        String moduleLine = this.getModuleLine(module);
        if (!moduleLine.isEmpty()) {
            this.setParameterTag(moduleLine, parameter, value);
        }
    }

    private void editPrinterModuleLine(String module, String printerPOSName, String parameter, String value) {
        String moduleLine = this.getPrinterModuleLine(module, printerPOSName);
        if (!moduleLine.isEmpty()) {
            this.setParameterTag(moduleLine, parameter, value);
        }
    }

    private void setParameterTag(String moduleLine, String parameter, String value) {
        StringBuilder moduleString = new StringBuilder(moduleLine);
        if (!parameter.isEmpty()) {
            String oldParm = "";
            String newParm = "";
            int startPos = moduleLine.indexOf(parameter + "=");
            int endPos = moduleLine.indexOf(">");
            if (startPos > -1) {
                String parameterLine = moduleLine.substring(startPos, endPos);
                String[] pairs = parameterLine.split(" ");
                boolean foundParameter = false;
                for (int i = 0; !(i >= pairs.length || foundParameter && pairs[i].contains("=")); ++i) {
                    String[] thisPair = pairs[i].split("=");
                    if (!foundParameter && thisPair[0].compareToIgnoreCase(parameter) == 0) {
                        foundParameter = true;
                    }
                    oldParm = thisPair.length > 1 ? thisPair[0].trim() + "=" + thisPair[1] : oldParm + " " + thisPair[0];
                }
                if (foundParameter) {
                    endPos = startPos + oldParm.length();
                }
            }
            if (startPos > -1 && endPos > startPos) {
                if (!value.isEmpty()) {
                    newParm = parameter + "=" + value;
                } else {
                    newParm = "";
                    if (startPos > 0 && moduleLine.substring(startPos - 1, startPos).compareTo(" ") == 0) {
                        --startPos;
                    }
                }
                moduleString.replace(startPos, endPos, newParm);
            } else if (value != null && !value.isEmpty()) {
                int insertPos = moduleLine.indexOf(">");
                newParm = " " + parameter + "=" + value;
                moduleString.insert(insertPos, newParm);
            }
            this.configXml = this.configXml.replace(moduleLine, moduleString.toString());
        }
    }

    private String getModuleLine(String module) {
        String moduleLine = "";
        String startTag = "<";
        String bodyEndTag = ">";
        String endTag = "";
        endTag = module.compareToIgnoreCase("Settings") == 0 ? "</Settings>" : module + "</Module>";
        int endPos = this.configXml.indexOf(endTag);
        while (endPos >= 0) {
            int bodyEndPos = this.configXml.lastIndexOf(bodyEndTag, endPos);
            int startPos = this.configXml.lastIndexOf(startTag, bodyEndPos);
            if (endPos > startPos) {
                moduleLine = this.configXml.substring(startPos, endPos + endTag.length());
            }
            if (moduleLine.startsWith("<Module") || moduleLine.startsWith("<Settings")) break;
            moduleLine = "";
            endPos = this.configXml.indexOf(endTag, endPos + 1);
        }
        return moduleLine;
    }

    private String getPrinterModuleLine(String module, String printerPOSName) {
        String moduleLine = "";
        String startTag = "<";
        String bodyEndTag = ">";
        String endTag = module + "</Module>";
        String printerNameParameter = "Name=" + printerPOSName;
        int endPos = this.configXml.indexOf(endTag);
        while (endPos >= 0) {
            int bodyEndPos = this.configXml.lastIndexOf(bodyEndTag, endPos);
            int startPos = this.configXml.lastIndexOf(startTag, bodyEndPos);
            if (endPos > startPos) {
                moduleLine = this.configXml.substring(startPos, endPos + endTag.length());
            }
            if (moduleLine.startsWith("<Module") && moduleLine.contains(printerNameParameter)) break;
            moduleLine = "";
            endPos = this.configXml.indexOf(endTag, endPos + 1);
        }
        return moduleLine;
    }

    private void setTipsTenderCode() {
        String tipsTenderGLAccount = (String)this.tipsGLAccountBox.getSelectedItem();
        if (tipsTenderGLAccount != null && !tipsTenderGLAccount.trim().isEmpty()) {
            String currentTipsTenderCode = this.core.getTipsTenderCode();
            if (!currentTipsTenderCode.isEmpty()) {
                this.currentTipsTender = this.core.getTenderCode(currentTipsTenderCode);
                this.currentTipsTender.glAccount = tipsTenderGLAccount;
                this.tipsTenderCode = currentTipsTenderCode;
            } else {
                this.tipsTenderCode = this.core.createTenderCode();
                this.currentTipsTender = new TenderCode(this.tipsTenderCode, this.core.getLiteral("Tips Tender"), "O", tipsTenderGLAccount, this.core.getLiteral("Tips Tender"), false, 0.0, "", "", "", "");
            }
            this.tipsTenderPanel.setVisible(false);
            this.tipTenderButton.setVisible(true);
            if (this.tipsTenderCode == null || this.tipsTenderCode.isEmpty()) {
                this.tipTenderButton.setText(this.core.getLiteral("Set Tips Tender Other than Cash"));
                this.tipTenderCodeLabel.setText(this.core.getLiteral("Cash"));
            } else {
                this.resetToCashTender = true;
                this.tipTenderButton.setText(this.core.getLiteral("Reset Tips Tender Back to Cash"));
                this.tipTenderCodeLabel.setText(this.core.getLiteral("Tips Tender"));
            }
        }
    }

    private void setPrinterList() {
        Vector moduleParms;
        Vector modules;
        this.printerSetups = new Vector();
        this.printerList.removeAll();
        if (this.configXml != null && (modules = Utility.getElementList((String)"Module", (String)this.configXml, moduleParms = new Vector())) != null && !modules.isEmpty()) {
            int len = modules.size();
            for (int i = 0; i < len; ++i) {
                String adDelay;
                String pageLength;
                String summarizeItems;
                String template;
                String posType;
                String printer;
                String thisModule = (String)modules.get(i);
                if (!thisModule.contains("Outputs.ClientOrderPrinter") && !thisModule.contains("Outputs.ClientOrderPrinterVat")) continue;
                PrinterConfigSetup printerSetup = new PrinterConfigSetup();
                printerSetup.printerType = thisModule.substring(8);
                Hashtable parameters = (Hashtable)moduleParms.get(i);
                String name = (String)parameters.get("Name");
                if (name != null && !name.isEmpty()) {
                    printerSetup.printerPOSName = name;
                }
                if ((printer = (String)parameters.get("Printer")) != null && !printer.isEmpty()) {
                    printerSetup.printerName = printer;
                }
                if ((posType = (String)parameters.get("POSType")) != null && !posType.isEmpty()) {
                    printerSetup.printerPOSType = posType;
                }
                if ((template = (String)parameters.get("Template")) != null && !template.isEmpty()) {
                    printerSetup.printerReceiptTemplate = template;
                }
                printerSetup.printerSummarizeItems = (summarizeItems = (String)parameters.get("SummarizeItems")) != null && summarizeItems.equalsIgnoreCase("true");
                String summarizeTaxes = (String)parameters.get("SummarizeTaxes");
                printerSetup.printerSummarizeTaxes = summarizeTaxes != null && summarizeTaxes.equalsIgnoreCase("true");
                String pageWidth = (String)parameters.get("PageWidth");
                if (pageWidth != null && !pageWidth.isEmpty()) {
                    printerSetup.printerPrintWidth = Integer.valueOf(pageWidth);
                }
                if ((pageLength = (String)parameters.get("PageLength")) != null && !pageLength.isEmpty()) {
                    printerSetup.printerPrintLength = Integer.valueOf(pageLength);
                }
                if ((adDelay = (String)parameters.get("AdDelay")) != null && !adDelay.isEmpty()) {
                    printerSetup.printerAdDelay = Integer.valueOf(adDelay);
                }
                for (int j = 0; j < 5; ++j) {
                    String tipPercent = (String)parameters.get("TipPercent" + (j + 1));
                    if (tipPercent == null || tipPercent.length() <= 0) continue;
                    printerSetup.printerTipPercentage[j] = tipPercent;
                }
                this.printerSetups.add(printerSetup);
            }
        }
        this.printerList.setListData(this.printerSetups);
    }

    private void setShiftPrinterList() {
        Vector moduleParms;
        Vector modules;
        this.shiftPrinterSetups = new Vector();
        this.shiftPrinterList.removeAll();
        if (this.configXml != null && (modules = Utility.getElementList((String)"Module", (String)this.configXml, moduleParms = new Vector())) != null && !modules.isEmpty()) {
            int len = modules.size();
            for (int i = 0; i < len; ++i) {
                String pageLength;
                String pageWidth;
                String resetTemplate;
                String serverTemplate;
                String posType;
                String printer;
                String thisModule = (String)modules.get(i);
                if (!thisModule.contains("Outputs.ShiftReportPrinter") && !thisModule.contains("Outputs.ShiftReportPrinterVat")) continue;
                PrinterConfigSetup printerSetup = new PrinterConfigSetup();
                printerSetup.printerType = thisModule.substring(8);
                Hashtable parameters = (Hashtable)moduleParms.get(i);
                String name = (String)parameters.get("Name");
                if (name != null && !name.isEmpty()) {
                    printerSetup.printerPOSName = name;
                }
                if ((printer = (String)parameters.get("Printer")) != null && !printer.isEmpty()) {
                    printerSetup.printerName = printer;
                }
                if ((posType = (String)parameters.get("POSType")) != null && !posType.isEmpty()) {
                    printerSetup.printerPOSType = posType;
                }
                if ((serverTemplate = (String)parameters.get("ServerTemplate")) != null && !serverTemplate.isEmpty()) {
                    printerSetup.printerServerReportTemplate = serverTemplate;
                }
                if ((resetTemplate = (String)parameters.get("ReadResetTemplate")) != null && !resetTemplate.isEmpty()) {
                    printerSetup.printerResetReportTemplate = resetTemplate;
                }
                if ((pageWidth = (String)parameters.get("PageWidth")) != null && !pageWidth.isEmpty()) {
                    printerSetup.printerPrintWidth = Integer.valueOf(pageWidth);
                }
                if ((pageLength = (String)parameters.get("PageLength")) != null && !pageLength.isEmpty()) {
                    printerSetup.printerPrintLength = Integer.valueOf(pageLength);
                }
                this.shiftPrinterSetups.add(printerSetup);
            }
        }
        this.shiftPrinterList.setListData(this.shiftPrinterSetups);
    }

    private void editOrderPrinterSetup(boolean newPrinter) {
        int selectedPrinter = 0;
        PrinterConfigSetup printerSetup = null;
        if (!newPrinter) {
            selectedPrinter = this.printerList.getSelectedIndex();
            printerSetup = (PrinterConfigSetup)this.printerSetups.get(selectedPrinter);
        }
        EditPrinterSetupScreen editPrinterSetupScreen = new EditPrinterSetupScreen(null, true, this.core, this.printersPanel.getWidth(), this.printersPanel.getHeight());
        editPrinterSetupScreen.setPrinterConfigSetup(printerSetup);
        editPrinterSetupScreen.isOrderPrinter(true);
        editPrinterSetupScreen.displayScreen();
        printerSetup = editPrinterSetupScreen.getPrinterConfigSetup();
        if (printerSetup.changed && printerSetup.remove) {
            if (this.removePrinterList == null) {
                this.removePrinterList = new Vector();
            }
            this.removePrinterList.add(printerSetup);
            this.printerSetups.remove(printerSetup);
        } else if (!newPrinter) {
            this.printerSetups.setElementAt(printerSetup, selectedPrinter);
        } else {
            this.printerSetups.add(printerSetup);
        }
        editPrinterSetupScreen.dispose();
        this.printerList.setListData(this.printerSetups);
    }

    private void editShiftPrinterSetup(boolean newPrinter) {
        int selectedPrinter = 0;
        PrinterConfigSetup printerSetup = null;
        if (!newPrinter) {
            selectedPrinter = this.shiftPrinterList.getSelectedIndex();
            printerSetup = (PrinterConfigSetup)this.shiftPrinterSetups.get(selectedPrinter);
        }
        EditPrinterSetupScreen editPrinterSetupScreen = new EditPrinterSetupScreen(null, true, this.core, this.printersPanel.getWidth(), this.printersPanel.getHeight());
        editPrinterSetupScreen.setPrinterConfigSetup(printerSetup);
        editPrinterSetupScreen.isOrderPrinter(false);
        editPrinterSetupScreen.displayScreen();
        printerSetup = editPrinterSetupScreen.getPrinterConfigSetup();
        if (printerSetup.changed && printerSetup.remove) {
            if (this.removePrinterList == null) {
                this.removePrinterList = new Vector();
            }
            this.removePrinterList.add(printerSetup);
            this.shiftPrinterSetups.remove(printerSetup);
        } else if (!newPrinter) {
            this.shiftPrinterSetups.setElementAt(printerSetup, selectedPrinter);
        } else {
            this.shiftPrinterSetups.add(printerSetup);
        }
        editPrinterSetupScreen.dispose();
        this.shiftPrinterList.setListData(this.shiftPrinterSetups);
    }

    private void exitScreen() {
        this.dispose();
    }

    private void showAccuShiftNote() {
        String noteTitle = this.core.getLiteral("Note");
        String noteText1 = this.core.getLiteral("If converting old generation AccuShift database to the New Generation AccuShift, the old AccuShift database driver and path must be defined.");
        String noteText2 = this.core.getLiteral("If starting with New Generation AccuShift initially, the AccuShift database driver and path will be the same as the main database values.");
        JOptionPane.showMessageDialog(this, noteText1 + "\n\n" + noteText2 + "\n\n", noteTitle, 1);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.mainPanel.setPreferredSize(new Dimension(0, 0));
        this.mainPanel.setLayout(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerConfigScreen dialog = new ServerConfigScreen((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public class JNumberFieldLimit
    extends PlainDocument {
        private int limit;

        JNumberFieldLimit(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null || str.equals("")) {
                return;
            }
            if (str.length() == 1 && !str.matches("[0-9]")) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        int panelWidth = 0;

        MyListCellRenderer(int panelWidth) {
            this.panelWidth = panelWidth;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Color background = null;
            PrinterConfigSetup printerSetup = (PrinterConfigSetup)value;
            PrinterSetupPanel printerPanel = new PrinterSetupPanel(printerSetup.printerType, printerSetup.printerPOSName, printerSetup.printerName, this.panelWidth);
            background = isSelected ? Color.yellow : Color.white;
            printerPanel.setBackground(background);
            return printerPanel;
        }
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ServerConfigScreen.this.loadingData) {
                ServerConfigScreen.this.restartRequired = true;
            }
        }
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ServerConfigScreen.this.restartRequired = true;
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    class MyFocusListener
    extends FocusAdapter {
        MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            JTextComponent textField = (JTextComponent)evt.getSource();
            textField.requestFocus();
            textField.selectAll();
        }
    }

    class BackgroundPanel
    extends JPanel {
        Image backgroundImage = null;

        public BackgroundPanel(Image backgroundImage) {
            this.backgroundImage = backgroundImage;
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle area = this.getBounds();
            int imageWidth = this.backgroundImage.getWidth(this);
            int imageHeight = this.backgroundImage.getHeight(this);
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this.backgroundImage, 0, 0, area.width, area.height, 0, 0, Math.round(imageWidth), Math.round(imageHeight), this);
        }
    }
}

