/*
 * Decompiled with CFR 0.152.
 */
package AccuServerLogger;

import AccuServerBase.ServerCore;
import AccuServerLogger.DebugFormatter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public class AccuServerDebugLogger {
    private Logger logger;
    private static AccuServerDebugLogger thisInstance = null;
    private static ServerCore core = null;
    private static String version = "";
    SimpleDateFormat dateFormat = null;

    public static AccuServerDebugLogger getInstance(ServerCore core) {
        if (thisInstance == null) {
            thisInstance = new AccuServerDebugLogger(core);
        }
        return thisInstance;
    }

    public AccuServerDebugLogger(ServerCore core) {
        try {
            AccuServerDebugLogger.core = core;
            version = core.getVersion();
            this.dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss.SSS");
            boolean append = true;
            FileHandler handler = new FileHandler("accuServerDebugLog.xml", 0x40000000, 200, append);
            handler.setFormatter(new DebugFormatter());
            this.logger = Logger.getLogger("accuPOSDebugLog");
            this.logger.addHandler(handler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void log(String text) {
        this.logDebug("Local", "AccuPOS.DebugLogger", text);
    }

    public void logDebug(String from, String who, String what) {
        Date now = new Date();
        StringBuilder msg = new StringBuilder();
        msg.append(this.dateFormat.format(now) + "\t" + what + "\n");
        this.logger.info(msg.toString());
    }
}

