/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import org.json.JSONException;
import org.json.JSONObject;

public class VatSummaryData {
    public String vatCode = "";
    public String vatDescription = "";
    public double subTotal = 0.0;
    public double vatAmount = 0.0;
    public double total = 0.0;

    public VatSummaryData() {
    }

    public VatSummaryData(String xml) {
        this.vatCode = Utility.getElement("VatCode", xml);
        this.vatDescription = Utility.getElement("VatDescription", xml);
        this.subTotal = Utility.getDoubleElement("SubTotal", xml);
        this.vatAmount = Utility.getDoubleElement("VatAmount", xml);
        this.total = Utility.getDoubleElement("Total", xml);
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<VatSummary>");
        xml.append("<VatCode>" + this.vatCode + "</VatCode>");
        xml.append("<VatDescription>" + this.vatDescription + "</VatDescription>");
        xml.append("<SubTotal>" + this.subTotal + "</SubTotal>");
        xml.append("<VatAmount>" + this.vatAmount + "</VatAmount>");
        xml.append("<Total>" + this.total + "</Total>");
        xml.append("</VatSummary>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("vatCode", (Object)this.vatCode);
            jsonObject.put("vatDescription", (Object)this.vatDescription);
            jsonObject.put("subTotal", this.subTotal);
            jsonObject.put("vatAmount", this.vatAmount);
            jsonObject.put("total", this.total);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

