/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.Reset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class TransactionReportOptions {
    public Timestamp fromDate = null;
    public Timestamp thruDate = null;
    public Reset reset = null;
    public boolean voidsOnly = false;
    public boolean reopenedOnly = false;
    public boolean discountsOnly = false;
    public boolean cancelledOnly = false;
    public boolean creditCardOnly = false;
    public boolean compReasonsOnly = false;
    public boolean accountsReceivableOnly = false;
    public boolean showChanges = false;
    public String serverId = "";
    public String customerCode = "";
    public ArrayList itemTypes = null;
    public ArrayList itemCategories = null;
    public String userName = "";
    public boolean includeOpenSales = false;
    public ArrayList customerTypes = null;
    public String tenderType = "";
    public String itemType = "";
    public List employees = null;
    public String transactionAmountFilter = "";
    public double transactionFromAmount = 0.0;
    public double transactionToAmount = 0.0;
    public double transactionAmountCompare = 0.0;
    public String itemAmountFilter = "";
    public double itemFromAmount = 0.0;
    public double itemToAmount = 0.0;
    public double itemAmountCompare = 0.0;
    public boolean allTransactions = true;
    public long invoiceNumber = 0L;

    public TransactionReportOptions() {
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<ReportOptions>");
        xml.append("<FromDate>" + this.fromDate.getTime() + "</FromDate>");
        xml.append("<ThruDate>" + this.thruDate.getTime() + "</ThruDate>");
        if (this.reset != null) {
            xml.append(this.reset.toXml());
        }
        xml.append("<VoidsOnly>" + this.voidsOnly + "</VoidsOnly>");
        xml.append("<ReopenedOnly>" + this.reopenedOnly + "</ReopenedOnly>");
        xml.append("<DiscountsOnly>" + this.discountsOnly + "</DiscountsOnly>");
        xml.append("<CancelledOnly>" + this.cancelledOnly + "</CancelledOnly>");
        xml.append("<CreditCardOnly>" + this.creditCardOnly + "</CreditCardOnly>");
        xml.append("<CompReasonsOnly>" + this.compReasonsOnly + "</CompReasonsOnly>");
        xml.append("<AccountsReceivableOnly>" + this.accountsReceivableOnly + "</AccountsReceivableOnly>");
        xml.append("<ServerId>" + this.serverId + "</ServerId>");
        xml.append("<ShowChanges>" + this.showChanges + "</ShowChanges>");
        xml.append("</ReportOptions>");
        return xml.toString();
    }

    public TransactionReportOptions(String optionsXml) {
        String resetXml;
        long thru;
        long from = Utility.getLongElement("FromDate", optionsXml);
        if (from > 0L) {
            this.fromDate = new Timestamp(from);
        }
        if ((thru = Utility.getLongElement("ThruDate", optionsXml)) > 0L) {
            this.thruDate = new Timestamp(thru);
        }
        if ((resetXml = Utility.getElement("Reset", optionsXml)) != null && resetXml.length() > 0) {
            this.reset = new Reset(resetXml);
        }
        this.voidsOnly = Utility.getBooleanElement("VoidsOnly", optionsXml);
        this.reopenedOnly = Utility.getBooleanElement("ReopenedOnly", optionsXml);
        this.discountsOnly = Utility.getBooleanElement("DiscountsOnly", optionsXml);
        this.cancelledOnly = Utility.getBooleanElement("CancelledOnly", optionsXml);
        this.creditCardOnly = Utility.getBooleanElement("CreditCardOnly", optionsXml);
        this.compReasonsOnly = Utility.getBooleanElement("CompReasonsOnly", optionsXml);
        this.accountsReceivableOnly = Utility.getBooleanElement("AccountsReceivableOnly", optionsXml);
        this.serverId = Utility.getElement("ServerId", optionsXml);
        this.showChanges = Utility.getBooleanElement("ShowChangess", optionsXml);
    }
}

