/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class TenderCode {
    public String code = "";
    public String description;
    public String displayText;
    public String tenderType;
    public String glAccount;
    public boolean openCd;
    public double maxChange;
    public String cardType;
    public String processor;
    public String merchantId;
    public String password;
    public double conversionRate = 1.0;

    public TenderCode(String code, String description, String tenderType, String glAccount, String displayText, boolean openCd, double maxChange, String cardType, String processor, String merchantId, String password) {
        this.code = code;
        this.description = description;
        this.tenderType = tenderType;
        this.glAccount = glAccount;
        this.displayText = displayText;
        this.openCd = openCd;
        this.maxChange = maxChange;
        this.cardType = cardType;
        this.processor = processor;
        this.merchantId = merchantId;
        this.password = password;
    }

    public TenderCode(String xml) {
        this.code = Utility.getElement("Code", xml);
        this.description = Utility.getElement("Description", xml);
        this.displayText = Utility.getElement("DisplayText", xml);
        this.openCd = Utility.getBooleanElement("OpenCd", xml);
        this.maxChange = Utility.getDoubleElement("MaxChange", xml);
        this.cardType = Utility.getElement("CardType", xml);
        this.tenderType = Utility.getElement("TenderType", xml);
        this.glAccount = Utility.getElement("GLAccount", xml);
        this.processor = Utility.getElement("Processor", xml);
        this.merchantId = Utility.getElement("MerchantId", xml);
        this.password = Utility.getElement("Password", xml);
        this.conversionRate = Utility.getDoubleElement("ConversionRate", xml);
    }

    public TenderCode(JSONString jsonString) {
        this.displayText = Utility.getJSONString(jsonString.toString(), "buttonText");
        this.glAccount = Utility.getJSONString(jsonString.toString(), "glAccount");
        this.code = Utility.getJSONString(jsonString.toString(), "id");
        this.maxChange = Utility.getJSONDouble(jsonString.toString(), "maxChange");
        this.openCd = Utility.getJSONBoolean(jsonString.toString(), "openCash");
        this.tenderType = Utility.getJSONString(jsonString.toString(), "paymentType");
        this.description = Utility.getJSONString(jsonString.toString(), "tenderName");
        this.cardType = Utility.getJSONString(jsonString.toString(), "cardType");
        this.conversionRate = Utility.getJSONDouble(jsonString.toString(), "conversionRate");
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00;-####0.00");
        DecimalFormat conversionDecimal = new DecimalFormat("####0.00000;-####0.00000");
        StringBuffer xml = new StringBuffer();
        xml.append("<TenderCode>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<DisplayText>" + this.displayText + "</DisplayText>");
        xml.append("<OpenCd>" + Boolean.toString(this.openCd) + "</OpenCd>");
        xml.append("<MaxChange>" + decimal.format(this.maxChange) + "</MaxChange>");
        xml.append("<CardType>" + this.cardType + "</CardType>");
        xml.append("<TenderType>" + this.tenderType + "</TenderType>");
        xml.append("<GLAccount>" + this.glAccount + "</GLAccount>");
        xml.append("<Processor>" + this.processor + "</Processor>");
        xml.append("<MerchantId>" + this.merchantId + "</MerchantId>");
        xml.append("<Password>" + this.password + "</Password>");
        xml.append("<ConversionRate>" + conversionDecimal.format(this.conversionRate) + "</ConversionRate>");
        xml.append("</TenderCode>\n");
        return xml.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != TenderCode.class) {
            return false;
        }
        return ((TenderCode)obj).code.compareToIgnoreCase(this.code) == 0;
    }

    public JSONObject toJson() {
        JSONObject output = new JSONObject();
        try {
            output.put("buttonText", (Object)this.displayText);
            output.put("glAccount", (Object)this.glAccount);
            output.put("id", (Object)this.code);
            output.put("maxChange", this.maxChange);
            output.put("openCash", this.openCd);
            output.put("paymentType", (Object)this.tenderType);
            output.put("tenderName", (Object)this.description);
            output.put("conversionRate", this.conversionRate);
            output.put("cardType", (Object)this.cardType);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return output;
    }
}

