/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class TaxAuthority {
    public String id = "";
    public String name = "";
    public double rate = 0.0;
    public double tax = 0.0;
    public String glAccount = "";
    public double taxableSubTotal = 0.0;

    public TaxAuthority(String id, String name, double rate) {
        this.id = id;
        this.name = name;
        this.rate = rate;
        this.tax = 0.0;
    }

    public TaxAuthority(String id, String name, double rate, String glAccount) {
        this.id = id;
        this.name = name;
        this.rate = rate;
        this.tax = 0.0;
        this.glAccount = glAccount;
    }

    public TaxAuthority(String xml) {
        this.id = Utility.getElement("Id", xml);
        this.name = Utility.getElement("Name", xml);
        this.tax = Utility.getDoubleElement("TaxAmount", xml);
        this.rate = Utility.getDoubleElement("Rate", xml);
        this.glAccount = Utility.getElement("GlAccount", xml);
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        if (this.name == null || this.name.isEmpty()) {
            this.name = this.id;
        }
        xml.append("\n<TaxAuthority>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<TaxAmount>" + decimal.format(this.tax) + "</TaxAmount>");
        xml.append("<Rate>" + decimal.format(this.rate) + "</Rate>");
        xml.append("<GlAccount>" + this.glAccount + "</GlAccount>");
        xml.append("</TaxAuthority>");
        return xml.toString();
    }

    public String toString() {
        return this.id + ", name=" + this.name + ", rate=" + this.rate + ", tax=" + this.tax;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == null || obj.getClass() != this.getClass()) {
            return result;
        }
        result = this.id.equalsIgnoreCase(((TaxAuthority)obj).id) && this.rate == ((TaxAuthority)obj).rate;
        return result;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.id);
            jsonObject.put("name", (Object)this.name);
            jsonObject.put("rate", this.rate);
            jsonObject.put("tax", this.tax);
            jsonObject.put("glAccount", (Object)this.glAccount);
            jsonObject.put("taxableSubTotal", this.taxableSubTotal);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

