/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.TaxAuthority;
import java.util.Vector;

public class Tax {
    public boolean taxable = true;
    public Vector taxAuthorities = null;

    public Tax() {
    }

    public Tax(String xml) {
        String taxXml = Utility.getElement("Taxable", xml);
        this.taxable = taxXml.compareToIgnoreCase("True") == 0;
        Vector taxes = Utility.getElementList("TaxAuthority", xml);
        int len = taxes.size();
        if (len > 0) {
            this.taxAuthorities = new Vector();
        }
        for (int i = 0; i < len; ++i) {
            String thisAuthorityText = (String)taxes.get(i);
            TaxAuthority thisTax = new TaxAuthority(thisAuthorityText);
            this.taxAuthorities.add(thisTax);
        }
    }

    public String toXml() {
        String taxText = "FALSE";
        if (this.taxable) {
            taxText = "TRUE";
        }
        String xml = "<Tax><Taxable>" + taxText + "</Taxable>";
        if (this.taxAuthorities != null) {
            int len = this.taxAuthorities.size();
            for (int i = 0; i < len; ++i) {
                TaxAuthority thisTax = (TaxAuthority)this.taxAuthorities.get(i);
                xml = xml + thisTax.toXml();
            }
        }
        xml = xml + "</Tax>";
        return xml;
    }
}

