/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class SalePrice {
    public int id = 0;
    public String group = "";
    public String item = "";
    public Timestamp start = null;
    public Timestamp end = null;
    public double discount = 0.0;
    public double quantity = 0.0;
    public double forPrice = 0.0;
    public int fromMinutes = 0;
    public int thruMinutes = 0;
    public boolean sunday = false;
    public boolean monday = false;
    public boolean tuesday = false;
    public boolean wednesday = false;
    public boolean thursday = false;
    public boolean friday = false;
    public boolean saturday = false;
    public double quantityLevel = 0.0;
    public double quantityPrice = 0.0;
    public int initialQuantity = 0;
    public double nextDiscountPct = 0.0;
    public double nextDiscountPrice = 0.0;
    public boolean groupIsCategory = false;
    public boolean quantityPriceIsPct = false;

    public SalePrice(String group, String item, Timestamp start, Timestamp end, double discount, double quantity, double forPrice) {
        this.group = group;
        this.item = item;
        this.start = start;
        this.end = end;
        this.discount = discount;
        this.quantity = quantity;
        this.forPrice = forPrice;
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("<SalePrice>");
        xml.append("<SalePriceId>" + this.id + "</SalePriceId>");
        xml.append("<Group>" + this.group + "</Group>");
        xml.append("<SalePriceItem>" + this.item + "</SalePriceItem>");
        xml.append("<Start>" + this.start + "</Start>");
        xml.append("<End>" + this.end + "</End>");
        xml.append("<Discount>" + decimal.format(this.discount) + "</Discount>");
        xml.append("<Quantity>" + decimal.format(this.quantity) + "</Quantity>");
        xml.append("<ForPrice>" + decimal.format(this.forPrice) + "</ForPrice>");
        xml.append("<FromMinutes>" + this.fromMinutes + "</FromMinutes>");
        xml.append("<ThruMinutes>" + this.thruMinutes + "</ThruMinutes>");
        xml.append("<Sunday>" + this.sunday + "</Sunday>");
        xml.append("<Monday>" + this.monday + "</Monday>");
        xml.append("<Tuesday>" + this.tuesday + "</Tuesday>");
        xml.append("<Wednesday>" + this.wednesday + "</Wednesday>");
        xml.append("<Thursday>" + this.thursday + "</Thursday>");
        xml.append("<Friday>" + this.friday + "</Friday>");
        xml.append("<Saturday>" + this.saturday + "</Saturday>");
        xml.append("<QuantityLevel>" + decimal.format(this.quantityLevel) + "</QuantityLevel>");
        xml.append("<QuantityPrice>" + decimal.format(this.quantityPrice) + "</QuantityPrice>");
        xml.append("<InitialQuantity>" + this.initialQuantity + "</InitialQuantity>");
        xml.append("<NextDiscountPct>" + this.nextDiscountPct + "</NextDiscountPct>");
        xml.append("<NextDiscountPrice>" + this.nextDiscountPrice + "</NextDiscountPrice>");
        xml.append("<GroupIsCategory>" + this.groupIsCategory + "</GroupIsCategory>");
        xml.append("<QuantityPriceIsPct>" + this.quantityPriceIsPct + "</QuantityPriceIsPct>");
        xml.append("</SalePrice>");
        return xml.toString();
    }

    public JSONObject toJson() {
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm a");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("group", (Object)this.group);
            jsonObject.put("item", (Object)this.item);
            jsonObject.put("start", (Object)this.start);
            jsonObject.put("end", (Object)this.end);
            jsonObject.put("fromMinutes", this.fromMinutes);
            jsonObject.put("thruMinutes", this.thruMinutes);
            jsonObject.put("discount", this.discount);
            jsonObject.put("quantity", this.quantity);
            jsonObject.put("forPrice", this.forPrice);
            jsonObject.put("sunday", this.sunday);
            jsonObject.put("monday", this.monday);
            jsonObject.put("tuesday", this.tuesday);
            jsonObject.put("wednesday", this.wednesday);
            jsonObject.put("thursday", this.thursday);
            jsonObject.put("friday", this.friday);
            jsonObject.put("saturday", this.saturday);
            jsonObject.put("quantityLevel", this.quantityLevel);
            jsonObject.put("quantityPrice", this.quantityPrice);
            jsonObject.put("initialQuantity", this.initialQuantity);
            jsonObject.put("nextDiscountPct", this.nextDiscountPct);
            jsonObject.put("nextDiscountPrice", this.nextDiscountPrice);
            jsonObject.put("groupIsCategory", this.groupIsCategory);
            jsonObject.put("quantityPriceIsPct", this.quantityPriceIsPct);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public SalePrice(String salePriceXml) {
        this.id = Utility.getIntElement("SalePriceId", salePriceXml);
        this.group = Utility.getElement("Group", salePriceXml);
        this.item = Utility.getElement("SalePriceItem", salePriceXml);
        String startTime = Utility.getElement("Start", salePriceXml);
        this.start = !startTime.equals("null") ? Timestamp.valueOf(startTime) : null;
        String endTime = Utility.getElement("End", salePriceXml);
        this.end = !endTime.equals("null") ? Timestamp.valueOf(endTime) : null;
        this.discount = Utility.getDoubleElement("Discount", salePriceXml);
        this.quantity = Utility.getDoubleElement("Quantity", salePriceXml);
        this.forPrice = Utility.getDoubleElement("ForPrice", salePriceXml);
        this.fromMinutes = Utility.getIntElement("FromMinutes", salePriceXml);
        this.thruMinutes = Utility.getIntElement("ThruMinutes", salePriceXml);
        this.sunday = Utility.getBooleanElement("Sunday", salePriceXml);
        this.monday = Utility.getBooleanElement("Monday", salePriceXml);
        this.tuesday = Utility.getBooleanElement("Tuesday", salePriceXml);
        this.wednesday = Utility.getBooleanElement("Wednesday", salePriceXml);
        this.thursday = Utility.getBooleanElement("Thursday", salePriceXml);
        this.friday = Utility.getBooleanElement("Friday", salePriceXml);
        this.saturday = Utility.getBooleanElement("Saturday", salePriceXml);
        this.quantityLevel = Utility.getDoubleElement("QuantityLevel", salePriceXml);
        this.quantityPrice = Utility.getDoubleElement("QuantityPrice", salePriceXml);
        this.initialQuantity = Utility.getIntElement("InitialQuantity", salePriceXml);
        this.nextDiscountPct = Utility.getDoubleElement("NextDiscountPct", salePriceXml);
        this.nextDiscountPrice = Utility.getDoubleElement("NextDiscountPrice", salePriceXml);
        this.groupIsCategory = Utility.getBooleanElement("GroupIsCategory", salePriceXml);
        this.quantityPriceIsPct = Utility.getBooleanElement("QuantityPriceIsPct", salePriceXml);
    }

    public SalePrice(JSONString jsonString) {
        try {
            this.id = Utility.getJSONInt(jsonString.toString(), "id");
            this.group = Utility.getJSONString(jsonString.toString(), "group");
            this.item = Utility.getJSONString(jsonString.toString(), "item");
            String startString = Utility.getJSONString(jsonString.toString(), "start");
            String endString = Utility.getJSONString(jsonString.toString(), "end");
            try {
                this.start = Timestamp.valueOf(startString);
            }
            catch (Exception e) {
                this.start = null;
            }
            try {
                this.end = Timestamp.valueOf(endString);
            }
            catch (Exception e) {
                this.end = null;
            }
            this.fromMinutes = Utility.getJSONInt(jsonString.toString(), "fromMinutes");
            this.thruMinutes = Utility.getJSONInt(jsonString.toString(), "thruMinutes");
            this.discount = Utility.getJSONDouble(jsonString.toString(), "discount");
            this.quantity = Utility.getJSONDouble(jsonString.toString(), "quantity");
            this.forPrice = Utility.getJSONDouble(jsonString.toString(), "forPrice");
            this.sunday = Utility.getJSONBoolean(jsonString.toString(), "sunday");
            this.monday = Utility.getJSONBoolean(jsonString.toString(), "monday");
            this.tuesday = Utility.getJSONBoolean(jsonString.toString(), "tuesday");
            this.wednesday = Utility.getJSONBoolean(jsonString.toString(), "wednesday");
            this.thursday = Utility.getJSONBoolean(jsonString.toString(), "thursday");
            this.friday = Utility.getJSONBoolean(jsonString.toString(), "friday");
            this.saturday = Utility.getJSONBoolean(jsonString.toString(), "saturday");
            this.quantityLevel = Utility.getJSONDouble(jsonString.toString(), "quantityLevel");
            this.quantityPrice = Utility.getJSONDouble(jsonString.toString(), "quantityPrice");
            this.initialQuantity = Utility.getJSONInt(jsonString.toString(), "initialQuantity");
            this.nextDiscountPct = Utility.getJSONDouble(jsonString.toString(), "nextDiscountPct");
            this.nextDiscountPrice = Utility.getJSONDouble(jsonString.toString(), "nextDiscountPrice");
            this.groupIsCategory = Utility.getJSONBoolean(jsonString.toString(), "groupIsCategory");
            this.quantityPriceIsPct = Utility.getJSONBoolean(jsonString.toString(), "quantityPriceIsPct");
        }
        catch (Exception e) {
            String message = e.getMessage();
            String string = e.toString();
        }
    }

    public boolean equals(Object obj) {
        int source = ((SalePrice)obj).id;
        return source == this.id;
    }
}

