/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.util.Date;

public class SageAuth {
    public String token = "";
    public String refreshToken = "";
    public long created;
    public String sageInstanceUrl = "";
    protected String accuposDevKey = "3MVG9HxRZv05HarRWHU8YqQf9AoZJjSf2ONIyeQMFyM3RLledmRsHPszOiUdRK_rP1HCk6M1w2fX72m1SXvCc";
    protected String accuposDevSecret = "7236110553345983003";
    protected String consumerKey = "";
    protected String consumerSecret = "";
    public boolean usingSandbox = false;

    public SageAuth() {
    }

    public SageAuth(String xml) {
        this.token = Utility.getElement("Token", xml);
        this.refreshToken = Utility.getElement("RefreshToken", xml);
        this.created = Utility.getLongElement("Created", xml);
        this.sageInstanceUrl = Utility.getElement("SageInstanceUrl", xml);
        String applicationKey = Utility.getElement("ApplicationKey", xml);
        if (!applicationKey.isEmpty()) {
            if (applicationKey.compareToIgnoreCase("SandBox") == 0) {
                this.consumerKey = this.accuposDevKey;
                this.consumerSecret = this.accuposDevSecret;
                this.usingSandbox = true;
            }
        } else {
            this.consumerKey = Utility.getElement("SageKey", xml);
            this.consumerSecret = Utility.getElement("SageSecret", xml);
        }
    }

    public SageAuth(String token, String refreshToken, String sageInstanceUrl) {
        this.token = token;
        this.refreshToken = refreshToken;
        this.sageInstanceUrl = sageInstanceUrl;
    }

    public SageAuth Copy() {
        SageAuth newAuth = new SageAuth();
        newAuth.token = this.token;
        newAuth.refreshToken = this.refreshToken;
        newAuth.created = this.created;
        newAuth.sageInstanceUrl = this.sageInstanceUrl;
        newAuth.consumerKey = this.consumerKey;
        newAuth.consumerSecret = this.consumerSecret;
        newAuth.usingSandbox = this.usingSandbox;
        return newAuth;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getSageInstanceUrl() {
        return this.sageInstanceUrl;
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<SageAuth>\r\n");
        xml.append("<Token>" + this.token + "</Token>" + "\r\n");
        xml.append("<RefreshToken>" + this.refreshToken + "</RefreshToken>" + "\r\n");
        xml.append("<Created>" + this.created + "</Created>" + "\r\n");
        xml.append("<SageInstanceUrl>" + this.sageInstanceUrl + "</SageInstanceUrl>" + "\r\n");
        String applicationKey = "";
        if (this.usingSandbox && this.consumerKey.compareTo(this.accuposDevKey) == 0) {
            applicationKey = "SandBox";
        }
        xml.append("<SageKey>" + this.consumerKey + "</SageKey>" + "\r\n");
        xml.append("<SageSecret>" + this.consumerSecret + "</SageSecret>" + "\r\n");
        if (!applicationKey.isEmpty()) {
            xml.append("<ApplicationKey>" + applicationKey + "</ApplicationKey>" + "\r\n");
        }
        xml.append("</SageAuth>");
        return xml.toString();
    }

    public boolean isValid() {
        boolean isValid = false;
        Date issuedTime = new Date(this.created);
        Date now = new Date();
        long timeout = 900000L;
        Date expireTime = new Date(issuedTime.getTime() + timeout);
        if (now.before(expireTime)) {
            isValid = true;
        }
        return isValid;
    }
}

