/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class ReceiptPrintSetup {
    public String companyName = "";
    public String companyAddress1 = "";
    public String companyAddress2 = "";
    public String companyCity = "";
    public String companyState = "";
    public String companyZip = "";
    public String companyPhone = "";
    public String companyFax = "";
    public String companyEmail = "";
    public String savingsMessage = "";
    public String invoiceMessage = "";
    public boolean printSKU = false;
    public boolean printCompanyName = false;
    public boolean printCustomerCode = false;
    public boolean printCustomerName = false;
    public boolean printCustomerContact = false;
    public boolean printCustomerAddress = false;
    public boolean printCustomerPhone = false;
    public boolean receiptEmailFlag = false;
    public String receiptEmailAccount = "";
    public String receiptEmailSMTPServer = "";
    public String receiptEmailSMTPPort = "";
    public String receiptEmailPassword = "";
    public String receiptEmailSubject = "";
    public int receiptCurrencyDecimalNumber = 2;
    public int receiptQuantityDecimalNumber = 1;
    public String receiptDateTimeFormat = "MM-dd-yy HH:mm";
    public boolean printCustomerBalance = false;

    public ReceiptPrintSetup(String companyName, String companyAddress1, String companyAddress2, String companyCity, String companyState, String companyZip, String companyPhone, String companyFax, String companyEmail, String savingsMessage, String invoiceMessage, boolean printSKU, boolean printCompanyName, boolean printCustomerCode, boolean printCustomerName, boolean printCustomerContact, boolean printCustomerAddress, boolean printCustomerBalance, boolean printCustomerPhone, boolean receiptEmailFlag, String receiptEmailAccount, String receiptEmailSMTPServer, String receiptEmailSMTPPort, String receiptEmailPassword, String receiptEmailSubject) {
        this.companyName = companyName;
        this.companyAddress1 = companyAddress1;
        this.companyAddress2 = companyAddress2;
        this.companyCity = companyCity;
        this.companyState = companyState;
        this.companyZip = companyZip;
        this.companyPhone = companyPhone;
        this.companyFax = companyFax;
        this.companyEmail = companyEmail;
        this.savingsMessage = savingsMessage;
        this.invoiceMessage = invoiceMessage;
        this.printSKU = printSKU;
        this.printCustomerCode = printCustomerCode;
        this.printCompanyName = printCompanyName;
        this.printCustomerName = printCustomerName;
        this.printCustomerContact = printCustomerContact;
        this.printCustomerAddress = printCustomerAddress;
        this.printCustomerBalance = printCustomerBalance;
        this.printCustomerPhone = printCustomerPhone;
        this.receiptEmailFlag = receiptEmailFlag;
        this.receiptEmailAccount = receiptEmailAccount;
        this.receiptEmailSMTPServer = receiptEmailSMTPServer;
        this.receiptEmailSMTPPort = receiptEmailSMTPPort;
        this.receiptEmailPassword = receiptEmailPassword;
        this.receiptEmailSubject = receiptEmailSubject;
    }

    public ReceiptPrintSetup(String xml) {
        this.companyName = Utility.getElement("CompanyName", xml);
        this.companyAddress1 = Utility.getElement("CompanyAddress1", xml);
        this.companyAddress2 = Utility.getElement("CompanyAddress2", xml);
        this.companyCity = Utility.getElement("CompanyCity", xml);
        this.companyState = Utility.getElement("CompanyState", xml);
        this.companyZip = Utility.getElement("CompanyZip", xml);
        this.companyPhone = Utility.getElement("CompanyPhone", xml);
        this.companyFax = Utility.getElement("CompanyFax", xml);
        this.companyEmail = Utility.getElement("CompanyEmail", xml);
        this.savingsMessage = Utility.getElement("SavingsMessage", xml);
        this.invoiceMessage = Utility.getElement("InvoiceMessage", xml);
        this.printSKU = Utility.getBooleanElement("PrintSKU", xml);
        this.printCompanyName = Utility.getBooleanElement("PrintCompanyName", xml);
        this.printCustomerCode = Utility.getBooleanElement("PrintCustomerCode", xml);
        this.printCustomerName = Utility.getBooleanElement("PrintCustomerName", xml);
        this.printCustomerContact = Utility.getBooleanElement("PrintCustomerContact", xml);
        this.printCustomerAddress = Utility.getBooleanElement("PrintCustomerAddress", xml);
        this.printCustomerPhone = Utility.getBooleanElement("PrintCustomerPhone", xml);
        this.printCustomerBalance = Utility.getBooleanElement("PrintCustomerBalance", xml);
        this.receiptEmailFlag = Utility.getBooleanElement("EmailFlag", xml);
        this.receiptEmailAccount = Utility.getElement("EmailAccount", xml);
        this.receiptEmailSMTPServer = Utility.getElement("EmailSMTPServer", xml);
        this.receiptEmailSMTPPort = Utility.getElement("EmailSMTPPort", xml);
        this.receiptEmailPassword = Utility.getElement("EmailPassword", xml);
        this.receiptEmailSubject = Utility.getElement("EmailSubject", xml);
        this.receiptDateTimeFormat = Utility.getElement("ReceiptDateTimeFormat", xml);
    }

    public ReceiptPrintSetup(JSONString jsonString) {
        this.companyName = Utility.getJSONString(jsonString.toString(), "name");
        this.companyName = Utility.translateSpecial(this.companyName);
        this.companyAddress1 = Utility.getJSONString(jsonString.toString(), "addressLine1");
        this.companyAddress1 = Utility.translateSpecial(this.companyAddress1);
        this.companyAddress2 = Utility.getJSONString(jsonString.toString(), "addressLine2");
        this.companyAddress2 = Utility.translateSpecial(this.companyAddress2);
        this.companyCity = Utility.getJSONString(jsonString.toString(), "city");
        this.receiptDateTimeFormat = Utility.getJSONString(jsonString.toString(), "dateTimeFormat");
        this.companyState = Utility.getJSONString(jsonString.toString(), "state");
        this.companyZip = Utility.getJSONString(jsonString.toString(), "zip");
        this.companyPhone = Utility.getJSONString(jsonString.toString(), "telephone");
        this.companyFax = Utility.getJSONString(jsonString.toString(), "faxNumber");
        this.companyEmail = Utility.getJSONString(jsonString.toString(), "emailOrWebsite");
        this.savingsMessage = Utility.getJSONString(jsonString.toString(), "savingMessage");
        this.invoiceMessage = Utility.getJSONString(jsonString.toString(), "invoiceMessage");
        this.invoiceMessage = Utility.translateSpecial(this.invoiceMessage);
        this.printSKU = Utility.getJSONBoolean(jsonString.toString(), "printItemDescriptionAndSku");
        this.printCustomerBalance = Utility.getJSONBoolean(jsonString.toString(), "printCustomerBalance");
        this.printCompanyName = Utility.getJSONBoolean(jsonString.toString(), "customerCompanyName");
        this.printCustomerCode = Utility.getJSONBoolean(jsonString.toString(), "customerCode");
        this.printCustomerName = Utility.getJSONBoolean(jsonString.toString(), "customerName");
        this.printCustomerContact = Utility.getJSONBoolean(jsonString.toString(), "customerContact");
        this.printCustomerAddress = Utility.getJSONBoolean(jsonString.toString(), "customerAddress");
        this.printCustomerPhone = Utility.getJSONBoolean(jsonString.toString(), "customerPhone");
        this.receiptEmailFlag = Utility.getJSONBoolean(jsonString.toString(), "offerEmail");
        this.receiptEmailAccount = Utility.getJSONString(jsonString.toString(), "emailAccount");
        this.receiptEmailSMTPServer = Utility.getJSONString(jsonString.toString(), "emailServer");
        this.receiptEmailSMTPPort = Utility.getJSONString(jsonString.toString(), "emailPort");
        this.receiptEmailPassword = Utility.getJSONString(jsonString.toString(), "emailPassword");
        this.receiptEmailSubject = Utility.getJSONString(jsonString.toString(), "emailSubject");
        this.receiptCurrencyDecimalNumber = Utility.getJSONInt(jsonString.toString(), "currencyDecimals");
        this.receiptQuantityDecimalNumber = Utility.getJSONInt(jsonString.toString(), "quantityDecimals");
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<ReceiptPrintSetup>");
        xml.append("<CompanyName>" + this.companyName + "</CompanyName>");
        xml.append("<CompanyAddress1>" + this.companyAddress1 + "</CompanyAddress1>");
        xml.append("<CompanyAddress2>" + this.companyAddress2 + "</CompanyAddress2>");
        xml.append("<CompanyCity>" + this.companyCity + "</CompanyCity>");
        xml.append("<CompanyState>" + this.companyState + "</CompanyState>");
        xml.append("<CompanyZip>" + this.companyZip + "</CompanyZip>");
        xml.append("<CompanyPhone>" + this.companyPhone + "</CompanyPhone>");
        xml.append("<CompanyFax>" + this.companyFax + "</CompanyFax>");
        xml.append("<CompanyEmail>" + this.companyEmail + "</CompanyEmail>");
        xml.append("<SavingsMessage>" + this.savingsMessage + "</SavingsMessage>");
        xml.append("<InvoiceMessage>" + this.invoiceMessage + "</InvoiceMessage>");
        xml.append("<PrintSKU>" + this.printSKU + "</PrintSKU>");
        xml.append("<PrintCompanyName>" + this.printCompanyName + "</PrintCompanyName>");
        xml.append("<PrintCustomerCode>" + this.printCustomerCode + "</PrintCustomerCode>");
        xml.append("<PrintCustomerName>" + this.printCustomerName + "</PrintCustomerName>");
        xml.append("<PrintCustomerContact>" + this.printCustomerContact + "</PrintCustomerContact>");
        xml.append("<PrintCustomerAddress>" + this.printCustomerAddress + "</PrintCustomerAddress>");
        xml.append("<PrintCustomerPhone>" + this.printCustomerPhone + "</PrintCustomerPhone>");
        xml.append("<PrintCustomerBalance>" + this.printCustomerBalance + "</PrintCustomerBalance>");
        xml.append("<ReceiptCurrencyDecimals>" + this.receiptCurrencyDecimalNumber + "</ReceiptCurrencyDecimals>");
        xml.append("<ReceiptQuantityDecimals>" + this.receiptQuantityDecimalNumber + "</ReceiptQuantityDecimals>");
        xml.append("<ReceiptDateTimeFormat>" + this.receiptDateTimeFormat + "</ReceiptDateTimeFormat>");
        xml.append("<EmailFlag>" + this.receiptEmailFlag + "</EmailFlag>");
        xml.append("<EmailAccount>" + this.receiptEmailAccount + "</EmailAccount>");
        xml.append("<EmailSMTPServer>" + this.receiptEmailSMTPServer + "</EmailSMTPServer>");
        xml.append("<EmailSMTPPort>" + this.receiptEmailSMTPPort + "</EmailSMTPPort>");
        xml.append("<EmailPassword>" + this.receiptEmailPassword + "</EmailPassword>");
        xml.append("<EmailSubject>" + this.receiptEmailSubject + "</EmailSubject>");
        xml.append("</ReceiptPrintSetup>");
        return xml.toString();
    }

    public String toString() {
        return this.companyName + " " + this.companyAddress1 + " " + this.companyAddress2 + " " + this.companyCity + " " + this.companyState + " " + this.companyZip + " " + this.companyPhone + " " + this.companyFax + " " + this.companyEmail + " " + this.savingsMessage + " " + this.invoiceMessage + " " + this.printSKU + " " + this.printCompanyName + " " + this.printCustomerName + " " + this.printCustomerContact + " " + this.printCustomerAddress + " " + this.printCustomerPhone + " " + this.receiptEmailFlag + " " + this.receiptEmailAccount + " " + this.receiptEmailSMTPServer + " " + this.receiptEmailSMTPPort + " " + this.receiptEmailPassword + " " + this.receiptEmailSubject + " " + this.printCustomerBalance;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONObject receiptInfo = new JSONObject();
        JSONObject emailReceipts = new JSONObject();
        JSONObject customerInfo = new JSONObject();
        try {
            receiptInfo.put("name", (Object)this.companyName);
            receiptInfo.put("addressLine1", (Object)this.companyAddress1);
            receiptInfo.put("addressLine2", (Object)this.companyAddress2);
            receiptInfo.put("city", (Object)this.companyCity);
            receiptInfo.put("state", (Object)this.companyState);
            receiptInfo.put("telephone", (Object)this.companyPhone);
            receiptInfo.put("emailOrWebsite", (Object)(this.companyEmail == null ? "" : this.companyEmail));
            receiptInfo.put("zip", (Object)this.companyZip);
            receiptInfo.put("faxNumber", (Object)this.companyFax);
            receiptInfo.put("invoiceMessage", (Object)this.invoiceMessage);
            receiptInfo.put("savingMessage", (Object)this.savingsMessage);
            receiptInfo.put("dateTimeFormat", (Object)this.receiptDateTimeFormat);
            receiptInfo.put("printItemDescriptionAndSku", this.printSKU);
            receiptInfo.put("printCustomerBalance", this.printCustomerBalance);
            receiptInfo.put("currencyDecimals", this.receiptCurrencyDecimalNumber);
            receiptInfo.put("quantityDecimals", this.receiptQuantityDecimalNumber);
            jsonObject.put("receipt_info", (Object)receiptInfo);
            emailReceipts.put("offerEmail", this.receiptEmailFlag);
            emailReceipts.put("emailServer", (Object)this.receiptEmailSMTPServer);
            emailReceipts.put("emailAccount", (Object)this.receiptEmailAccount);
            emailReceipts.put("emailPort", (Object)this.receiptEmailSMTPPort);
            emailReceipts.put("emailSubject", (Object)this.receiptEmailSubject);
            emailReceipts.put("emailPassword", (Object)this.receiptEmailPassword);
            jsonObject.put("email_receipts", (Object)emailReceipts);
            customerInfo.put("customerCompanyName", this.printCompanyName);
            customerInfo.put("customerCode", this.printCustomerCode);
            customerInfo.put("customerName", this.printCustomerName);
            customerInfo.put("customerContact", this.printCustomerContact);
            customerInfo.put("customerPhone", this.printCustomerPhone);
            customerInfo.put("customerAddress", this.printCustomerAddress);
            jsonObject.put("customer_info", (Object)customerInfo);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

