/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.awt.Color;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class MenuKey {
    public int id = 0;
    public String name = "";
    public int row = 1;
    public int column = 1;
    public int width = 1;
    public int height = 1;
    public String imageName = "";
    public Color textColor;
    public String type = "";
    public String text = "";
    public boolean cr = false;
    public String keysetName = "";
    public String page = "";
    public boolean noRepeat = false;
    public int keyNumber = 0;
    public Color buttonColor;
    public boolean noSync = false;
    public Timestamp lastChanged;
    public boolean isActive = true;
    public String imageUrl = "";
    public String detailedDescription = "";
    public Timestamp imageCreated = null;
    public double price = 0.0;

    public MenuKey() {
    }

    public MenuKey(String xml) {
        this.id = Utility.getIntElement("Id", xml);
        this.name = Utility.getElement("Name", xml);
        this.page = Utility.getElement("Page", xml);
        this.row = Utility.getIntElement("Row", xml);
        this.column = Utility.getIntElement("Column", xml);
        this.width = Utility.getIntElement("Width", xml);
        this.height = Utility.getIntElement("Height", xml);
        this.imageName = Utility.getElement("ImageName", xml);
        this.textColor = Utility.colorFromXml(Utility.getElement("TextColor", xml));
        this.type = Utility.getElement("Type", xml);
        this.text = Utility.getElement("Text", xml);
        this.keysetName = Utility.getElement("Keyset", xml);
        this.cr = Utility.getBooleanElement("PartialText", xml);
        this.noRepeat = Utility.getBooleanElement("NoRepeat", xml);
        this.keyNumber = Utility.getIntElement("KeyNumber", xml);
        this.buttonColor = Utility.colorFromXml(Utility.getElement("ButtonColor", xml));
        this.noSync = Utility.getBooleanElement("NoSync", xml);
        long lastChangedValue = Utility.getLongElement("LastChanged", xml);
        if (lastChangedValue > 0L) {
            this.lastChanged = new Timestamp(lastChangedValue);
        }
        this.isActive = Utility.getBooleanElement("IsActive", xml);
        this.imageUrl = Utility.getElement("ImageUrl", xml);
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("  <Button>\n");
        xml.append("    <Id>" + this.id + "</Id>\n");
        xml.append("    <Name>" + this.name + "</Name>\n");
        xml.append("    <Page>" + this.page + "</Page>\n");
        xml.append("    <Row>" + this.row + "</Row>\n");
        xml.append("    <Column>" + this.column + "</Column>\n");
        xml.append("    <Width>" + this.width + "</Width>\n");
        xml.append("    <Height>" + this.height + "</Height>\n");
        xml.append("    <ImageName>" + this.imageName + "</ImageName>\n");
        xml.append("    <TextColor>" + Utility.getColorXml(this.textColor) + "</TextColor>\n");
        xml.append("    <Type>" + this.type + "</Type>\n");
        xml.append("    <Text>" + this.text + "</Text>\n");
        xml.append("    <Keyset>" + this.keysetName + "</Keyset>\n");
        if (this.cr) {
            xml.append("    <PartialText>FALSE</PartialText>\n");
        } else {
            xml.append("    <PartialText>TRUE</PartialText>\n");
        }
        xml.append("    <NoRepeat>" + this.noRepeat + "</NoRepeat>\n");
        xml.append("    <KeyNumber>" + this.keyNumber + "</KeyNumber>\n");
        xml.append("    <NoSync>" + this.noSync + "</NoSync>\n");
        if (this.lastChanged != null) {
            xml.append("<LastChanged>" + this.lastChanged.getTime() + "</LastChanged>\r\n");
        }
        xml.append("    <IsActive>" + this.isActive + "</IsActive>\n");
        xml.append("    <ImageUrl>" + this.imageUrl + "</ImageUrl>\n");
        xml.append("    <DetailedDescription>" + this.detailedDescription + "</DetailedDescription>\n");
        xml.append("    <ImageCreated>" + this.imageCreated + "</ImageCreated>");
        xml.append("    <Price>" + decimal.format(this.price) + "</Price>\n");
        xml.append("  </Button>\n");
        return xml.toString();
    }

    public JSONObject toJson() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        JSONObject keyJsonObject = new JSONObject();
        try {
            keyJsonObject.put("id", this.id);
            keyJsonObject.put("name", (Object)this.name);
            keyJsonObject.put("page", (Object)this.page);
            keyJsonObject.put("row", this.row);
            keyJsonObject.put("column", this.column);
            keyJsonObject.put("width", this.width);
            keyJsonObject.put("height", this.height);
            keyJsonObject.put("imageName", (Object)this.imageName);
            keyJsonObject.put("type", (Object)this.type);
            keyJsonObject.put("text", (Object)this.text);
            keyJsonObject.put("keysetName", (Object)this.keysetName);
            keyJsonObject.put("cr", this.cr);
            keyJsonObject.put("noRepeat", this.noRepeat);
            keyJsonObject.put("keyNumber", this.keyNumber);
            keyJsonObject.put("noSync", this.noSync);
            keyJsonObject.put("imageUrl", (Object)this.imageUrl);
            keyJsonObject.put("lastChanged", this.lastChanged != null ? Long.valueOf(this.lastChanged.getTime()) : JSONObject.NULL);
            keyJsonObject.put("isActive", this.isActive);
            keyJsonObject.put("textColor", (Object)this.translateColor(this.textColor));
            keyJsonObject.put("buttonColor", (Object)this.translateColor(this.buttonColor));
            keyJsonObject.put("price", (Object)decimal.format(this.price));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return keyJsonObject;
    }

    private String translateColor(Color colorValue) {
        String hexColor = String.format("#%02X%02X%02X", colorValue.getRed(), colorValue.getGreen(), colorValue.getBlue());
        return hexColor;
    }

    public MenuKey(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.name = Utility.getJSONString(jsonString.toString(), "name");
        this.row = Utility.getJSONInt(jsonString.toString(), "row");
        this.column = Utility.getJSONInt(jsonString.toString(), "column");
        this.width = Utility.getJSONInt(jsonString.toString(), "width");
        this.height = Utility.getJSONInt(jsonString.toString(), "height");
        this.imageName = Utility.getJSONString(jsonString.toString(), "imageName");
        this.imageUrl = Utility.getJSONString(jsonString.toString(), "imageUrl");
        this.type = Utility.getJSONString(jsonString.toString(), "type");
        this.text = Utility.getJSONString(jsonString.toString(), "text");
        this.cr = Utility.getJSONBoolean(jsonString.toString(), "cr");
        this.keysetName = Utility.getJSONString(jsonString.toString(), "keysetName");
        this.page = Utility.getJSONString(jsonString.toString(), "page");
        this.noRepeat = Utility.getJSONBoolean(jsonString.toString(), "noRepeat");
        this.keyNumber = Utility.getJSONInt(jsonString.toString(), "keyNumber");
        this.noSync = Utility.getJSONBoolean(jsonString.toString(), "noSync");
        this.isActive = Utility.getJSONBoolean(jsonString.toString(), "isActive");
        String jsonTextColor = Utility.getJSONString(jsonString.toString(), "textColor");
        this.textColor = jsonTextColor.equals("White") ? new Color(255, 255, 255) : new Color(0, 0, 0);
        this.buttonColor = new Color(0, 0, 0);
        this.lastChanged = new Timestamp(System.currentTimeMillis());
    }

    public MenuKey(JSONObject json) {
        try {
            this.id = json.getInt("id");
            this.name = json.getString("name");
            this.row = json.getInt("row");
            this.column = json.getInt("column");
            this.width = json.getInt("width");
            this.height = json.getInt("height");
            this.imageName = json.getString("imageName");
            this.imageUrl = json.optString("imageUrl");
            this.type = json.getString("type");
            this.text = json.getString("text");
            this.cr = json.getBoolean("cr");
            this.keysetName = json.getString("keysetName");
            this.page = json.getString("page");
            this.noRepeat = json.getBoolean("noRepeat");
            this.keyNumber = json.getInt("keyNumber");
            this.noSync = json.getBoolean("noSync");
            this.isActive = json.getBoolean("isActive");
            String jsonTextColor = json.getString("textColor");
            this.textColor = jsonTextColor.equals("White") ? new Color(255, 255, 255) : new Color(0, 0, 0);
            this.buttonColor = new Color(0, 0, 0);
            this.lastChanged = new Timestamp(System.currentTimeMillis());
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
    }
}

