/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.Choice;
import POSDataObjects.DataChange;
import POSDataObjects.ItemChoice;
import POSDataObjects.Tax;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;

public class LineItem {
    public int id = 0;
    public String itemId = null;
    public String itemDescription = null;
    public String altDescription = null;
    public double quantity = 0.0;
    public double price = 0.0;
    public double originalPrice = 0.0;
    public double list = 0.0;
    public double total = 0.0;
    public Tax tax = new Tax();
    public String userId = null;
    public Vector choices = null;
    public boolean displayOnRemote = false;
    public boolean newLine = true;
    public boolean doNotPrint = false;
    public boolean carryOut = false;
    public int sort = 1;
    public boolean noDiscount = false;
    public String changedPrice = "";
    public double cost = 0.0;
    public boolean taxable = true;
    public String till = "";
    public int sequence = 0;
    public String itemType = "";
    public double vatTax1 = 0.0;
    public double vatTax2 = 0.0;
    public double vatGross = 0.0;
    public String taxCode = "";
    public String serialNumber = "";
    public String compReason = "";
    public String discountReason = "";
    public double compAmount = 0.0;
    public Timestamp invoiced = null;
    public int transaction = 0;
    public long created = 0L;
    public long changed = 0L;
    public String itemName = "";
    public String choiceGroup = "";
    public boolean isStock = false;
    public String glSalesAccount = "";
    public boolean serialized = false;
    public String taxType = "";
    public boolean isGroup = false;
    public String manager = "";
    public boolean isAppetizer = false;
    public String status = "";
    public boolean isGiftCard = false;
    public boolean isScale = false;
    public boolean noPartialQuantity = false;
    public int masterItem = 0;
    public boolean loyaltyRedeemable = false;
    public String changedQuantity = "";
    public boolean changedDescription = false;
    public boolean isBundle = false;
    public boolean isSalePrice = false;
    public String itemCategory = "";
    public String locationCode = "";
    public String comoRedemptionCode = "";
    public double tare = 0.0;
    public int flexGroupMasterItem = 0;
    public String processStatus = "";
    public long completed = 0L;
    public int ticketNumber = 0;
    public boolean isChoice = false;
    public String courseName = "";
    public boolean lineFired = false;
    public int movedFrom = 0;
    public Vector lineChanges = null;

    public LineItem() {
    }

    public LineItem(String xml) {
        if (xml.contains("<LineItem>")) {
            xml = Utility.getElement("LineItem", xml);
        }
        Hashtable lineItemElements = Utility.getElements(xml);
        this.id = Utility.getIntElement("Id", lineItemElements);
        this.itemId = Utility.getElement("ItemId", lineItemElements);
        this.itemDescription = Utility.getElement("ItemDescription", lineItemElements);
        this.altDescription = Utility.getElement("AltDescription", lineItemElements);
        this.quantity = Utility.getDoubleElement("Quantity", lineItemElements);
        this.price = Utility.getDoubleElement("Price", lineItemElements);
        this.originalPrice = Utility.getDoubleElement("OriginalPrice", lineItemElements);
        this.changedPrice = Utility.getElement("PriceChangedBy", lineItemElements);
        this.list = Utility.getDoubleElement("List", lineItemElements);
        this.total = Utility.getDoubleElement("Total", lineItemElements);
        this.userId = Utility.getElement("User", lineItemElements);
        String taxXml = Utility.getElement("Tax", lineItemElements);
        this.tax = new Tax(taxXml);
        this.doNotPrint = Utility.getBooleanElement("DoNotPrint", lineItemElements);
        this.displayOnRemote = Utility.getBooleanElement("DisplayOnRemote", lineItemElements);
        this.compReason = Utility.getElement("CompReason", lineItemElements);
        this.compAmount = Utility.getDoubleElement("CompAmount", lineItemElements);
        this.discountReason = Utility.getElement("DiscountReason", lineItemElements);
        this.sort = Utility.getIntElement("Sort", lineItemElements);
        String choicesXml = Utility.getElement("Choices", lineItemElements);
        String newLineText = Utility.getElement("NewLine", lineItemElements);
        this.newLine = newLineText.compareToIgnoreCase("TRUE") == 0;
        Vector choicesList = Utility.getElementList("Choice", choicesXml);
        int choicesLen = choicesList.size();
        if (choicesLen > 0) {
            this.choices = new Vector();
            for (int c = 0; c < choicesLen; ++c) {
                String thisChoiceXml = (String)choicesList.get(c);
                ItemChoice thisChoice = new ItemChoice(thisChoiceXml);
                this.choices.add(thisChoice);
            }
        }
        this.itemType = Utility.getElement("ItemType", lineItemElements);
        this.itemCategory = Utility.getElement("ItemCategory", lineItemElements);
        this.taxable = Utility.getBooleanElement("LineItemTaxable", lineItemElements);
        this.vatTax1 = Utility.getDoubleElement("VatTax1", lineItemElements);
        this.vatTax2 = Utility.getDoubleElement("VatTax2", lineItemElements);
        this.vatGross = Utility.getDoubleElement("VatGross", lineItemElements);
        this.taxCode = Utility.getElement("TaxCode", lineItemElements);
        this.carryOut = Utility.getBooleanElement("CarryOut", lineItemElements);
        long invoiceLong = Utility.getLongElement("Invoiced", lineItemElements);
        this.invoiced = invoiceLong > 0L ? new Timestamp(invoiceLong) : null;
        this.noDiscount = Utility.getBooleanElement("NoDiscount", lineItemElements);
        this.manager = Utility.getElement("Manager", lineItemElements);
        this.isAppetizer = Utility.getBooleanElement("IsAppetizer", lineItemElements);
        this.status = Utility.getElement("LineStatus", lineItemElements);
        this.created = Utility.getLongElement("Created", lineItemElements);
        this.changed = Utility.getLongElement("Changed", lineItemElements);
        this.isGiftCard = Utility.getBooleanElement("IsGiftCard", lineItemElements);
        this.isScale = Utility.getBooleanElement("IsScale", lineItemElements);
        this.masterItem = Utility.getIntElement("MasterItem", lineItemElements);
        this.loyaltyRedeemable = Utility.getBooleanElement("LoyaltyRedeemable", lineItemElements);
        this.serialNumber = Utility.getElement("SerialNumber", lineItemElements);
        this.changedQuantity = Utility.getElement("QuantityChangedBy", lineItemElements);
        this.noPartialQuantity = Utility.getBooleanElement("NoPartialQuantity", lineItemElements);
        this.changedDescription = Utility.getBooleanElement("ChangedDescription", lineItemElements);
        this.isBundle = Utility.getBooleanElement("IsBundle", lineItemElements);
        this.isSalePrice = Utility.getBooleanElement("IsSalePrice", lineItemElements);
        this.comoRedemptionCode = Utility.getElement("ComoRedemptionCode", xml);
        this.flexGroupMasterItem = Utility.getIntElement("FlexGroupMasterItem", lineItemElements);
        this.tare = Utility.getDoubleElement("Tare", lineItemElements);
        this.processStatus = Utility.getElement("ProcessStatus", lineItemElements);
        this.isChoice = Utility.getBooleanElement("IsChoice", lineItemElements);
        this.courseName = Utility.getElement("CourseName", lineItemElements);
        this.lineFired = Utility.getBooleanElement("LineFired", lineItemElements);
        this.movedFrom = Utility.getIntElement("MovedFrom", lineItemElements);
        this.lineChanges = new Vector();
        String lineChangesXml = Utility.getElement("LineChanges", xml);
        Vector lineChangesListXml = Utility.getElementList("DataChange", lineChangesXml);
        int len = lineChangesListXml.size();
        for (int i = 0; i < len; ++i) {
            String thisLineChangeXml = (String)lineChangesListXml.get(i);
            DataChange thisLineChange = new DataChange(thisLineChangeXml);
            this.lineChanges.add(thisLineChange);
        }
    }

    public void addChoice(Choice choice) {
        if (this.choices == null) {
            this.choices = new Vector();
        }
        this.choices.add(choice);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        boolean result = false;
        if (this.id != 0 && this.id == ((LineItem)obj).id) {
            result = true;
        }
        if (!result && this.created != 0L && this.created == ((LineItem)obj).created) {
            result = this.itemId.equalsIgnoreCase(((LineItem)obj).itemId);
        }
        return result;
    }

    public String toXml() {
        String choicesXml = "<Choices>";
        if (this.choices != null) {
            int choicesLen = this.choices.size();
            for (int c = 0; c < choicesLen; ++c) {
                ItemChoice choice = (ItemChoice)this.choices.get(c);
                choicesXml = choicesXml + choice.toXml();
            }
        }
        choicesXml = choicesXml + "</Choices>";
        StringBuilder lineChangesXml = new StringBuilder();
        if (this.lineChanges != null) {
            int len = this.lineChanges.size();
            for (int i = 0; i < len; ++i) {
                DataChange thisLine = (DataChange)this.lineChanges.get(i);
                String thisLineChangesXml = thisLine.toXml();
                lineChangesXml.append(thisLineChangesXml);
            }
        }
        String display = "FALSE";
        if (this.displayOnRemote) {
            display = "TRUE";
        }
        String newLineText = "FALSE";
        if (this.newLine) {
            newLineText = "TRUE";
        }
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        DecimalFormat totalDecimal = new DecimalFormat("####0.00;-####0.00");
        StringBuffer xml = new StringBuffer();
        xml.append("<LineItem>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<ItemId>" + this.itemId + "</ItemId>");
        xml.append("<ItemDescription>" + this.itemDescription + "</ItemDescription>");
        xml.append("<AltDescription>" + this.altDescription + "</AltDescription>");
        xml.append("<Quantity>" + decimal.format(this.quantity) + "</Quantity>");
        xml.append("<OriginalPrice>" + decimal.format(this.originalPrice) + "</OriginalPrice>");
        xml.append("<PriceChangedBy>" + this.changedPrice + "</PriceChangedBy>");
        xml.append("<Price>" + decimal.format(this.price) + "</Price>");
        xml.append("<List>" + decimal.format(this.list) + "</List>");
        xml.append("<Total>" + decimal.format(this.total) + "</Total>");
        xml.append("<User>" + this.userId + "</User>");
        xml.append(this.tax.toXml());
        xml.append("<DisplayOnRemote>" + display + "</DisplayOnRemote>");
        xml.append("<DoNotPrint>" + this.doNotPrint + "</DoNotPrint>");
        xml.append("<NewLine>" + newLineText + "</NewLine>");
        xml.append("<CompReason>" + this.compReason + "</CompReason>");
        xml.append("<CompAmount>" + this.compAmount + "</CompAmount>");
        xml.append("<DiscountReason>" + this.discountReason + "</DiscountReason>");
        xml.append(choicesXml);
        xml.append("<ItemType>" + this.itemType + "</ItemType>");
        xml.append("<ItemCategory>" + this.itemCategory + "</ItemCategory>");
        xml.append("<LineItemTaxable>" + this.taxable + "</LineItemTaxable>");
        xml.append("<VatTax1>" + this.vatTax1 + "</VatTax1>");
        xml.append("<VatTax2>" + this.vatTax2 + "</VatTax2>");
        xml.append("<VatGross>" + this.vatGross + "</VatGross>");
        xml.append("<TaxCode>" + this.taxCode + "</TaxCode>");
        xml.append("<CarryOut>" + this.carryOut + "</CarryOut>");
        xml.append("<Sort>" + this.sort + "</Sort>");
        xml.append("<Invoiced>" + this.invoiced + "</Invoiced>");
        xml.append("<NoDiscount>" + Boolean.toString(this.noDiscount) + "</NoDiscount>");
        xml.append("<Manager>" + this.manager + "</Manager>");
        xml.append("<IsAppetizer>" + this.isAppetizer + "</IsAppetizer>");
        xml.append("<LineStatus>" + this.status + "</LineStatus>");
        xml.append("<Created>" + this.created + "</Created>");
        xml.append("<Changed>" + this.changed + "</Changed>");
        xml.append("<IsGiftCard>" + this.isGiftCard + "</IsGiftCard>");
        xml.append("<IsScale>" + this.isScale + "</IsScale>");
        xml.append("<MasterItem>" + this.masterItem + "</MasterItem>");
        xml.append("<LoyaltyRedeemable>" + this.loyaltyRedeemable + "</LoyaltyRedeemable>");
        xml.append("<SerialNumber>" + this.serialNumber + "</SerialNumber>");
        xml.append("<QuantityChangedBy>" + this.changedQuantity + "</QuantityChangedBy>");
        xml.append("<NoPartialQuantity>" + this.noPartialQuantity + "</NoPartialQuantity>");
        xml.append("<ChangedDescription>" + this.changedDescription + "</ChangedDescription>");
        xml.append("<IsBundle>" + this.isBundle + "</IsBundle>");
        xml.append("<IsSalePrice>" + this.isSalePrice + "</IsSalePrice>");
        xml.append("<ComoRedemptionCode>" + this.comoRedemptionCode + "</ComoRedemptionCode>");
        xml.append("<FlexGroupMasterItem>" + this.flexGroupMasterItem + "</FlexGroupMasterItem>");
        xml.append("<Tare>" + this.tare + "</Tare>");
        xml.append("<ProcessStatus>" + this.processStatus + "</ProcessStatus>\r\n");
        xml.append("<IsChoice>" + this.isChoice + "</IsChoice>");
        xml.append("<CourseName>" + this.courseName + "</CourseName>");
        xml.append("<LineFired>" + this.lineFired + "</LineFired>");
        xml.append("<MovedFrom>" + this.movedFrom + "</MovedFrom>");
        xml.append("<LineChanges>" + lineChangesXml + "</LineChanges>");
        xml.append("</LineItem>\r\n");
        return xml.toString();
    }
}

