/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.GiftCardTransaction;
import java.util.Vector;

public class GiftCardDetail {
    public String accountNumber = "";
    public String merchant = "";
    public double balance = 0.0;
    public Vector transactionList = null;

    public GiftCardDetail() {
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        StringBuffer transXml = new StringBuffer();
        int len = 0;
        if (this.transactionList != null) {
            len = this.transactionList.size();
        }
        for (int i = 0; i < len; ++i) {
            GiftCardTransaction thisTransaction = (GiftCardTransaction)this.transactionList.get(i);
            transXml.append(thisTransaction.toXml());
        }
        xml.append("<GiftCardDetail>\r\n");
        xml.append("  <Merchant>" + this.merchant + "</Merchant>\r\n");
        xml.append("  <AccountNumber>" + this.accountNumber + "</AccountNumber>\r\n");
        xml.append("  <Balance>" + this.balance + "</Balance>\r\n");
        xml.append("  <TransactionList>" + transXml + "</TransactionList>\r\n");
        xml.append("</GiftCardDetail>");
        return xml.toString();
    }

    public GiftCardDetail(String summaryXml) {
        this.merchant = Utility.getElement("Merchant", summaryXml);
        this.accountNumber = Utility.getElement("AccountNumber", summaryXml);
        this.balance = Utility.getDoubleElement("Balance", summaryXml);
        String transXml = Utility.getElement("TransactionList", summaryXml);
        Vector transListXml = Utility.getElementList("GiftCardTransaction", transXml);
        int len = transListXml.size();
        this.transactionList = new Vector();
        for (int i = 0; i < len; ++i) {
            String thisTransXml = (String)transListXml.get(i);
            GiftCardTransaction thisTransaction = new GiftCardTransaction(thisTransXml);
            this.transactionList.add(thisTransaction);
        }
    }
}

