/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class FlexGroupDetail {
    public String masterItemId = null;
    public String detailItemId = null;
    public String detailType = null;
    public int subGroup = 0;
    public double flexDetailPrice = 0.0;
    public String flexDetailDescription = "";

    public FlexGroupDetail() {
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("<FlexGroupDetail>");
        xml.append("<MasterItemId>" + this.masterItemId + "</MasterItemId>");
        xml.append("<DetailItemId>" + this.detailItemId + "</DetailItemId>");
        xml.append("<DetailType>" + this.detailType + "</DetailType>");
        xml.append("<SubGroup>" + this.subGroup + "</SubGroup>");
        xml.append("<FlexDetailPrice>" + decimal.format(this.flexDetailPrice) + "</FlexDetailPrice>");
        xml.append("<FlexDetailDescription>" + this.flexDetailDescription + "</FlexDetailDescription>");
        xml.append("</FlexGroupDetail>");
        return xml.toString();
    }

    public FlexGroupDetail(String masterItemId, String detailItemId, int subGroup, double flexDetailPrice) {
        this.masterItemId = masterItemId;
        this.detailItemId = detailItemId;
        this.subGroup = subGroup;
        this.flexDetailPrice = flexDetailPrice;
    }

    public FlexGroupDetail(String masterItemId, String detailItemId, String detailType, int subGroup, double flexDetailPrice) {
        this.masterItemId = masterItemId;
        this.detailItemId = detailItemId;
        this.detailType = detailType;
        this.subGroup = subGroup;
        this.flexDetailPrice = flexDetailPrice;
    }

    public FlexGroupDetail(String flexDetailXml) {
        this.masterItemId = Utility.getElement("MasterItemId", flexDetailXml);
        this.detailItemId = Utility.getElement("DetailItemId", flexDetailXml);
        this.detailType = Utility.getElement("DetailType", flexDetailXml);
        this.subGroup = Utility.getIntElement("SubGroup", flexDetailXml);
        this.flexDetailPrice = Utility.getDoubleElement("FlexDetailPrice", flexDetailXml);
        this.flexDetailDescription = Utility.getElement("FlexDetailDescription", flexDetailXml);
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        try {
            jsonObject.put("masterItemId", (Object)this.masterItemId);
            jsonObject.put("detailItemId", (Object)this.detailItemId);
            jsonObject.put("detailType", (Object)this.detailType);
            jsonObject.put("subGroup", this.subGroup);
            jsonObject.put("flexDetailPrice", (Object)decimal.format(this.flexDetailPrice));
            jsonObject.put("flexDetailDescription", (Object)this.flexDetailDescription);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public FlexGroupDetail(JSONString jsonString) {
        this.masterItemId = Utility.getJSONString(jsonString.toString(), "masterItemId");
        this.detailItemId = Utility.getJSONString(jsonString.toString(), "detailItemId");
        this.detailType = Utility.getJSONString(jsonString.toString(), "detailType");
        this.subGroup = Utility.getJSONInt(jsonString.toString(), "subGroup");
        this.flexDetailPrice = Utility.getJSONDouble(jsonString.toString(), "flexDetailPrice");
        this.flexDetailDescription = Utility.getJSONString(jsonString.toString(), "flexDetailDescription");
    }
}

