/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomerDiscountInfo {
    public String itemId = "";
    public String itemDescription = "";
    public double percent = 0.0;
    public boolean selectedFlag = false;

    public CustomerDiscountInfo(String itemId, String itemDescription, double percent, boolean selectedFlag) {
        this.itemId = itemId;
        this.itemDescription = itemDescription;
        this.percent = percent;
        this.selectedFlag = selectedFlag;
    }

    public CustomerDiscountInfo(String xml) {
        this.itemId = Utility.getElement("ItemId", xml);
        this.itemDescription = Utility.getElement("Description", xml);
        this.percent = Utility.getDoubleElement("Percent", xml);
    }

    public CustomerDiscountInfo(JSONString jsonString) {
        this.itemId = Utility.getJSONString(jsonString.toString(), "id");
        this.itemDescription = Utility.getJSONString(jsonString.toString(), "description");
        this.percent = Utility.getJSONDouble(jsonString.toString(), "percent");
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<CustomerDiscount>");
        xml.append("<ItemId>" + this.itemId + "</ItemId>");
        xml.append("<Description>" + this.itemDescription + "</Description>");
        xml.append("<Percent>" + this.percent + "</Percent>");
        xml.append("</CustomerDiscount>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.itemId);
            jsonObject.put("description", (Object)this.itemDescription);
            jsonObject.put("percent", this.percent);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

