/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class CardsSetup {
    public String merchantId = "";
    public String merchantPassword = "";
    public String giftCardUserId = "";
    public String giftCardPassword = "";
    public String emailAddress = "";
    public boolean processPostAuth = false;
    public boolean processGratuities = false;
    public boolean debugLogging = false;
    public boolean isOpen247 = false;
    public boolean sendTransNumber = false;
    public String alternateHost = "";
    public String gateway = "";
    public String giftGateway = "";
    public String giftCardGroup = "";
    public String roomChargeOutlet = "";
    public String shvaDataPath = "";
    public String heartlandLicenseId = "";
    public String heartlandSiteId = "";
    public String heartlandDeviceId = "";
    public boolean isShvaUSD = false;
    public String merchantUser = "";
    public String triPosAcceptor = "";
    public String triPosToken = "";

    public CardsSetup() {
    }

    public CardsSetup(JSONString jsonString) {
        this.gateway = Utility.getJSONString(jsonString.toString(), "gateway");
        this.emailAddress = Utility.getJSONString(jsonString.toString(), "emailAddress");
        this.merchantPassword = Utility.getJSONString(jsonString.toString(), "merchantPassword");
        this.debugLogging = Utility.getJSONBoolean(jsonString.toString(), "debugLogging");
        this.processGratuities = Utility.getJSONBoolean(jsonString.toString(), "processGratuities");
        this.processPostAuth = Utility.getJSONBoolean(jsonString.toString(), "processPostAuth");
        this.giftGateway = Utility.getJSONString(jsonString.toString(), "giftGateway");
        this.giftCardPassword = Utility.getJSONString(jsonString.toString(), "giftCardPassword");
        this.giftCardUserId = Utility.getJSONString(jsonString.toString(), "giftCardUserId");
        this.giftCardGroup = Utility.getJSONString(jsonString.toString(), "giftCardGroup");
        this.merchantId = Utility.getJSONString(jsonString.toString(), "merchantId");
        this.isOpen247 = Utility.getJSONBoolean(jsonString.toString(), "isOpen247");
        this.sendTransNumber = Utility.getJSONBoolean(jsonString.toString(), "sendTransNumber");
        this.alternateHost = Utility.getJSONString(jsonString.toString(), "alternateHost");
        this.roomChargeOutlet = Utility.getJSONString(jsonString.toString(), "roomChargeOutlet");
        this.shvaDataPath = Utility.getJSONString(jsonString.toString(), "shvaDataPath");
        this.heartlandLicenseId = Utility.getJSONString(jsonString.toString(), "heartlandLicenseId");
        this.heartlandSiteId = Utility.getJSONString(jsonString.toString(), "heartlandSiteId");
        this.heartlandDeviceId = Utility.getJSONString(jsonString.toString(), "heartlandDeviceId");
        this.merchantUser = Utility.getJSONString(jsonString.toString(), "merchantUser");
        this.isShvaUSD = Utility.getJSONBoolean(jsonString.toString(), "isShvaUSD");
        this.triPosAcceptor = Utility.getJSONString(jsonString.toString(), "triPosAcceptor");
        this.triPosToken = Utility.getJSONString(jsonString.toString(), "triPosToken");
    }

    public CardsSetup(String xml) {
        if (xml != null && !xml.isEmpty()) {
            this.merchantId = Utility.getElement("MerchantId", xml);
            this.merchantPassword = Utility.getElement("MerchantPassword", xml);
            this.giftCardUserId = Utility.getElement("GiftCardUser", xml);
            this.giftCardPassword = Utility.getElement("GiftCardPassword", xml);
            this.emailAddress = Utility.getElement("EmailAddress", xml);
            this.processPostAuth = Utility.getBooleanElement("ProcessPostAuth", xml);
            this.processGratuities = Utility.getBooleanElement("Gratutity", xml);
            this.debugLogging = Utility.getBooleanElement("DebugLogging", xml);
            this.isOpen247 = Utility.getBooleanElement("IsOpen247", xml);
            this.sendTransNumber = Utility.getBooleanElement("SendTransNumber", xml);
            this.alternateHost = Utility.getElement("AlternateHost", xml);
            this.gateway = Utility.getElement("Gateway", xml);
            this.giftGateway = Utility.getElement("GiftGateway", xml);
            this.giftCardGroup = Utility.getElement("GiftCardGroup", xml);
            this.roomChargeOutlet = Utility.getElement("RoomChargeOutlet", xml);
            this.shvaDataPath = Utility.getElement("SHVADataPath", xml);
            this.heartlandLicenseId = Utility.getElement("HeartlandLicenseId", xml);
            this.heartlandSiteId = Utility.getElement("HeartlandSiteId", xml);
            this.heartlandDeviceId = Utility.getElement("HeartlandDeviceId", xml);
            this.isShvaUSD = Utility.getBooleanElement("IsShvaUSD", xml);
            this.merchantUser = Utility.getElement("MerchantUserName", xml);
            this.triPosAcceptor = Utility.getElement("TPA", xml);
            this.triPosToken = Utility.getElement("TPT", xml);
        }
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<CardsSetup>\r\n");
        xml.append("  <MerchantId>" + this.merchantId + "</MerchantId>\r\n");
        xml.append("  <MerchantPassword>" + this.merchantPassword + "</MerchantPassword>\r\n");
        xml.append("  <GiftCardUser>" + this.giftCardUserId + "</GiftCardUser>\r\n");
        xml.append("  <GiftCardPassword>" + this.giftCardPassword + "</GiftCardPassword>\r\n");
        xml.append("  <EmailAddress>" + this.emailAddress + "</EmailAddress>\r\n");
        xml.append("  <ProcessPostAuth>" + this.processPostAuth + "</ProcessPostAuth>\r\n");
        xml.append("  <Gratutity>" + this.processGratuities + "</Gratutity>\r\n");
        xml.append("  <DebugLogging>" + this.debugLogging + "</DebugLogging>\r\n");
        xml.append("  <IsOpen247>" + this.isOpen247 + "</IsOpen247>\r\n");
        xml.append("  <SendTransNumber>" + this.sendTransNumber + "</SendTransNumber>\r\n");
        xml.append("  <AlternateHost>" + this.alternateHost + "</AlternateHost>\r\n");
        xml.append("  <Gateway>" + this.gateway + "</Gateway>\r\n");
        xml.append("  <GiftGateway>" + this.giftGateway + "</GiftGateway>\r\n");
        xml.append("  <GiftCardGroup>" + this.giftCardGroup + "</GiftCardGroup>\r\n");
        xml.append("  <RoomChargeOutlet>" + this.roomChargeOutlet + "</RoomChargeOutlet>\r\n");
        xml.append("  <SHVADataPath>" + this.shvaDataPath + "</SHVADataPath>\r\n");
        xml.append("  <HeartlandLicenseId>" + this.heartlandLicenseId + "</HeartlandLicenseId>\r\n");
        xml.append("  <HeartlandSiteId>" + this.heartlandSiteId + "</HeartlandSiteId>\r\n");
        xml.append("  <HeartlandDeviceId>" + this.heartlandDeviceId + "</HeartlandDeviceId>\r\n");
        xml.append("  <IsShvaUSD>" + this.isShvaUSD + "</IsShvaUSD>\r\n");
        xml.append("  <MerchantUserName>" + this.merchantUser + "</MerchantUserName>\r\n");
        xml.append("  <TPA>" + this.triPosAcceptor + "</TPA>\r\n");
        xml.append("  <TPT>" + this.triPosToken + "</TPT>\r\n");
        xml.append("</CardsSetup>\r\n");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONObject cardSetup = new JSONObject();
        try {
            cardSetup.put("emailAddress", (Object)this.emailAddress);
            cardSetup.put("processPostAuth", this.processPostAuth);
            cardSetup.put("processGratuities", this.processGratuities);
            cardSetup.put("debugLogging", this.debugLogging);
            cardSetup.put("giftGateway", (Object)this.giftGateway);
            cardSetup.put("giftCardGroup", (Object)this.giftCardGroup);
            cardSetup.put("giftCardUserId", (Object)this.giftCardUserId);
            cardSetup.put("giftCardPassword", (Object)this.giftCardPassword);
            cardSetup.put("merchantPassword", (Object)this.merchantPassword);
            cardSetup.put("gateway", (Object)this.gateway);
            cardSetup.put("isOpen247", this.isOpen247);
            cardSetup.put("sendTransNumber", this.sendTransNumber);
            cardSetup.put("alternateHost", (Object)this.alternateHost);
            cardSetup.put("roomChargeOutlet", (Object)this.roomChargeOutlet);
            cardSetup.put("shvaDataPath", (Object)this.shvaDataPath);
            cardSetup.put("heartlandLicenseId", (Object)this.heartlandLicenseId);
            cardSetup.put("heartlandSiteId", (Object)this.heartlandSiteId);
            cardSetup.put("heartlandDeviceId", (Object)this.heartlandDeviceId);
            cardSetup.put("merchantUser", (Object)this.merchantUser);
            cardSetup.put("isShvaUSD", this.isShvaUSD);
            jsonObject.put("card_setup", (Object)cardSetup);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

