/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;

public class XmlRequest {
    private String action = "";
    private String site = null;
    private String serialNumber = null;
    private String version = null;
    private String dataFilePath = null;

    public XmlRequest(String action, String site, String serialNumber, String version, String dataFilePath) {
        this.action = action;
        this.site = site;
        this.serialNumber = serialNumber;
        this.version = version;
        this.dataFilePath = dataFilePath;
    }

    public XmlRequest() {
    }

    public XmlRequest(String xmlString) {
        this.action = Utility.getElement("action", xmlString);
        this.site = Utility.getElement("site", xmlString);
        this.serialNumber = Utility.getElement("serialNumber", xmlString);
        this.version = Utility.getElement("version", xmlString);
        this.dataFilePath = Utility.getElement("dataFilePath", xmlString);
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<Request>");
        xml.append("<action>" + this.action + "</action>");
        if (this.site != null) {
            xml.append("<site>" + this.site + "</site>");
        }
        if (this.dataFilePath != null) {
            xml.append("<dataFilePath>" + this.dataFilePath + "</dataFilePath>");
        }
        if (this.serialNumber != null) {
            xml.append("<serialNumber>" + this.serialNumber + "</serialNumber>");
        }
        if (this.version != null) {
            xml.append("<version>" + this.version + "</version>");
        }
        xml.append("</Request>");
        return xml.toString();
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDataFilePath(String dataFilePath) {
        this.dataFilePath = dataFilePath;
    }

    public String getAction() {
        return this.action;
    }

    public String getSite() {
        return this.site;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDataFilePath() {
        return this.dataFilePath;
    }
}

