/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlReceiptItem;
import java.util.ArrayList;
import java.util.Vector;

public class XmlReceiptList {
    private String vendorId;
    private String purchaseOrder;
    private ArrayList<XmlReceiptItem> items;

    public XmlReceiptList(String vendorId, String purchaseOrder, ArrayList<XmlReceiptItem> items) {
        this.vendorId = vendorId;
        this.purchaseOrder = purchaseOrder;
        this.items = items;
    }

    public XmlReceiptList(String xmlString) {
        this.vendorId = Utility.getElement("vendorId", xmlString);
        this.purchaseOrder = Utility.getElement("purchaseOrder", xmlString);
        String itemsXml = Utility.getElement("items", xmlString);
        Vector itemsListStrings = Utility.getElementList("itemsList", itemsXml);
        ArrayList<XmlReceiptItem> itemsList = new ArrayList<XmlReceiptItem>();
        int numReceiptItems = 0;
        if (itemsListStrings != null && !itemsListStrings.isEmpty()) {
            numReceiptItems = itemsListStrings.size();
        }
        for (int i = 0; i < numReceiptItems; ++i) {
            String thisReceiptItemXml = (String)itemsListStrings.get(i);
            XmlReceiptItem thisReceiptItem = new XmlReceiptItem(thisReceiptItemXml);
            itemsList.add(thisReceiptItem);
        }
        this.items = itemsList;
    }

    public XmlReceiptList() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<receiptsList>");
        xml.append("<vendorId>" + this.vendorId + "</vendorId>");
        if (this.purchaseOrder != null) {
            xml.append("<purchaseOrder>" + this.purchaseOrder + "</purchaseOrder>");
        }
        if (this.items != null) {
            xml.append("<items>");
            for (XmlReceiptItem item : this.items) {
                xml.append(item.toXml());
            }
            xml.append("</items>");
        }
        xml.append("</receiptsList>");
        return xml.toString();
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public void setItems(ArrayList items) {
        this.items = items;
    }

    public void setPurchaseOrder(String purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public String getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public ArrayList<XmlReceiptItem> getItems() {
        return this.items;
    }
}

