/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlReceiptList;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class XmlInventoryReceipts {
    private String glClass;
    private GregorianCalendar date;
    private ArrayList<XmlReceiptList> receipts;
    public final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    public XmlInventoryReceipts(String glClass, GregorianCalendar date, ArrayList<XmlReceiptList> receipts) {
        this.glClass = glClass;
        this.date = date;
        this.receipts = receipts;
    }

    public XmlInventoryReceipts(String xmlString) {
        this.glClass = Utility.getElement("glClass", xmlString);
        GregorianCalendar cal = new GregorianCalendar();
        try {
            Date dateObject = this.dateFormat.parse(Utility.getElement("date", xmlString));
            cal.setTime(dateObject);
            this.date = cal;
        }
        catch (ParseException ex) {
            this.date = null;
        }
        Vector receiptsListStrings = Utility.getElementList("receiptsList", xmlString);
        ArrayList<XmlReceiptList> receiptList = new ArrayList<XmlReceiptList>();
        int numReceipts = 0;
        if (receiptsListStrings != null && !receiptsListStrings.isEmpty()) {
            numReceipts = receiptsListStrings.size();
        }
        for (int i = 0; i < numReceipts; ++i) {
            String thisReceiptsXml = (String)receiptsListStrings.get(i);
            XmlReceiptList thisReceiptList = new XmlReceiptList(thisReceiptsXml);
            receiptList.add(thisReceiptList);
        }
        this.receipts = receiptList;
    }

    public XmlInventoryReceipts() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<InventoryReceipts>");
        xml.append("<glClass>" + this.glClass + "</glClass>");
        xml.append("<date>" + this.dateFormat.format(this.date.getTime()) + "</date>");
        if (this.receipts != null && !this.receipts.isEmpty()) {
            xml.append("<receipts>");
            for (XmlReceiptList receiptList : this.receipts) {
                xml.append(receiptList.toXml());
            }
            xml.append("</receipts>");
        }
        xml.append("</InventoryReceipts>");
        return xml.toString();
    }

    public void setGlClass(String glClass) {
        this.glClass = glClass;
    }

    public void setDate(GregorianCalendar date) {
        this.date = date;
    }

    public void setReceipts(ArrayList receiptsList) {
        this.receipts = receiptsList;
    }

    public String getGlClass() {
        return this.glClass;
    }

    public GregorianCalendar getDate() {
        return this.date;
    }

    public ArrayList<XmlReceiptList> getReceipts() {
        return this.receipts;
    }
}

