/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlEmployeeTime;
import java.util.ArrayList;
import java.util.Vector;

public class XmlEmployeeTimes {
    private ArrayList employeeTimes = new ArrayList();

    public XmlEmployeeTimes(ArrayList<XmlEmployeeTime> employeeTimes) {
        this.employeeTimes = employeeTimes;
    }

    public XmlEmployeeTimes(String xmlString) {
        String employeeTimesXml = Utility.getElement("employeeTimes", xmlString);
        Vector employeeTimesStrings = Utility.getElementList("employeeTime", employeeTimesXml);
        ArrayList<XmlEmployeeTime> employeeTimesList = new ArrayList<XmlEmployeeTime>();
        int numEmployeeTimes = 0;
        if (employeeTimesStrings != null && !employeeTimesStrings.isEmpty()) {
            numEmployeeTimes = employeeTimesStrings.size();
        }
        for (int i = 0; i < numEmployeeTimes; ++i) {
            String thisEmployeeTimeXml = (String)employeeTimesStrings.get(i);
            XmlEmployeeTime thisEmployeeTime = new XmlEmployeeTime(thisEmployeeTimeXml);
            employeeTimesList.add(thisEmployeeTime);
        }
        this.employeeTimes = employeeTimesList;
    }

    public XmlEmployeeTimes() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<employeeTimes>");
        int numEmployeeTimes = 0;
        if (this.employeeTimes != null && !this.employeeTimes.isEmpty()) {
            numEmployeeTimes = this.employeeTimes.size();
        }
        for (int i = 0; i < numEmployeeTimes; ++i) {
            XmlEmployeeTime thisEmployeeTime = (XmlEmployeeTime)this.employeeTimes.get(i);
            xml.append(thisEmployeeTime.toXml());
        }
        xml.append("</employeeTimes>");
        return xml.toString();
    }

    public void setEmployeeTimes(ArrayList employeeTimes) {
        this.employeeTimes = employeeTimes;
    }

    public ArrayList getEmployeeTimes() {
        return this.employeeTimes;
    }

    public boolean isEmpty() {
        return this.employeeTimes.isEmpty();
    }
}

