/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class XmlEmployeeTime {
    private String employeeId = "";
    private int payLevel = 0;
    private String employeeClass = "";
    private GregorianCalendar clockIn = null;
    private GregorianCalendar clockOut = null;
    private long total = 0L;
    public final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    public XmlEmployeeTime(String employeeId, int payLevel, String employeeClass, GregorianCalendar clockIn, GregorianCalendar clockOut, long total) {
        this.employeeId = employeeId;
        this.payLevel = payLevel;
        this.employeeClass = employeeClass;
        this.clockIn = clockIn;
        this.clockOut = clockOut;
        this.total = total;
    }

    public XmlEmployeeTime(String xmlString) {
        Date date;
        this.employeeId = Utility.insertSpecial(Utility.getElement("employeeId", xmlString));
        this.payLevel = Utility.getIntElement("payLevel", xmlString);
        this.employeeClass = Utility.insertSpecial(Utility.getElement("employeeClass", xmlString));
        GregorianCalendar cal = new GregorianCalendar();
        try {
            date = this.dateFormat.parse(Utility.getElement("clockIn", xmlString));
            cal.setTime(date);
            this.clockIn = cal;
        }
        catch (ParseException ex) {
            this.clockIn = null;
        }
        try {
            date = this.dateFormat.parse(Utility.getElement("clockIn", xmlString));
            cal.setTime(date);
            this.clockOut = cal;
        }
        catch (ParseException ex) {
            this.clockOut = null;
        }
        this.total = Utility.getLongElement("total", xmlString);
    }

    public XmlEmployeeTime() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<employeeTime>");
        xml.append("<employeeId>" + this.employeeId + "</employeeId>");
        xml.append("<payLevel>" + this.payLevel + "</payLevel>");
        xml.append("<employeeClass>" + this.employeeClass + "</employeeClass>");
        xml.append("<clockIn>" + this.dateFormat.format(this.clockIn.getTime()) + "</clockIn>");
        xml.append("<clockOut>" + this.dateFormat.format(this.clockOut.getTime()) + "</clockOut>");
        xml.append("<total>" + this.total + "</total>");
        xml.append("</employeeTime>");
        return xml.toString();
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public void setPayLevel(int payLevel) {
        this.payLevel = payLevel;
    }

    public void setEmployeeClass(String employeeClass) {
        this.employeeClass = employeeClass;
    }

    public void setClockIn(GregorianCalendar clockIn) {
        this.clockIn = clockIn;
    }

    public void setClockOut(GregorianCalendar clockOut) {
        this.clockOut = clockOut;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public int getPayLevel() {
        return this.payLevel;
    }

    public String getEmployeeClass() {
        return this.employeeClass;
    }

    public GregorianCalendar getClockIn() {
        return this.clockIn;
    }

    public GregorianCalendar getClockOut() {
        return this.clockOut;
    }

    public long getTotal() {
        return this.total;
    }
}

