/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QboJournalEntry {
    public String id;
    public Date transactionDate;
    public double debitAmount;
    public String debitDescription;
    public String debitAccountRef;
    public String debitAccountName;
    public String debitCustomerName;
    public String debitCustomerRef;
    public double creditAmount;
    public String creditDescription;
    public String creditAccountRef;
    public String creditAccountName;
    public String creditCustomerName;
    public String creditCustomerRef;

    public QboJournalEntry() {
    }

    public QboJournalEntry(String xmlString) {
        this.id = Utility.getElement("Id", xmlString);
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        xml.append("<JournalEntry xmlns=\"http://schema.intuit.com/finance/v3\" domain=\"QBO\">");
        if (this.transactionDate == null) {
            this.transactionDate = new Date();
        }
        xml.append("<TxnDate>" + dateFormat.format(this.transactionDate) + "</TxnDate>");
        xml.append("<Adjustment>false</Adjustment>");
        xml.append("<Line>");
        xml.append("<Description>" + this.debitDescription + "</Description>");
        xml.append("<Amount>" + this.debitAmount + "</Amount>");
        xml.append("<DetailType>JournalEntryLineDetail</DetailType>");
        xml.append("<JournalEntryLineDetail>");
        if (this.debitAccountName != null && !this.debitAccountName.isEmpty()) {
            xml.append("<AccountRef name=\"" + this.debitAccountName + "\">" + this.debitAccountRef + "</AccountRef>");
        } else {
            xml.append("<AccountRef>" + this.debitAccountRef + "</AccountRef>");
        }
        if (this.debitCustomerName != null && !this.debitCustomerName.isEmpty()) {
            xml.append("<Entity>");
            xml.append("<EntityRef name=\"" + this.debitCustomerName + "\">" + this.debitCustomerRef + "</EntityRef>");
            xml.append("<Type>Customer</Type>");
            xml.append("</Entity>");
        }
        xml.append("<PostingType>Debit</PostingType>");
        xml.append("</JournalEntryLineDetail>");
        xml.append("</Line>");
        xml.append("<Line>");
        xml.append("<Description>" + this.creditDescription + "</Description>");
        xml.append("<Amount>" + this.creditAmount + "</Amount>");
        xml.append("<DetailType>JournalEntryLineDetail</DetailType>");
        xml.append("<JournalEntryLineDetail>");
        if (this.creditAccountName != null && !this.creditAccountName.isEmpty()) {
            xml.append("<AccountRef name=\"" + this.creditAccountName + "\">" + this.creditAccountRef + "</AccountRef>");
        } else {
            xml.append("<AccountRef>" + this.creditAccountRef + "</AccountRef>");
        }
        if (this.creditCustomerName != null && !this.creditCustomerName.isEmpty()) {
            xml.append("<Entity>");
            xml.append("<EntityRef name=\"" + this.creditCustomerName + "\">" + this.debitCustomerRef + "</EntityRef>");
            xml.append("<Type>Customer</Type>");
            xml.append("</Entity>");
        }
        xml.append("<PostingType>Credit</PostingType>");
        xml.append("</JournalEntryLineDetail>");
        xml.append("</Line>");
        xml.append("</JournalEntry>");
        return xml.toString();
    }
}

