/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class QboItem {
    public String id;
    public int syncToken;
    public boolean active;
    public String fullyQualifiedName;
    public String sku;
    public String type;
    public String description;
    public double unitPrice;
    public String purchaseDesc;
    public double purchaseCost;
    public boolean trackQtyOnHand;
    public double qtyOnHand;
    public boolean taxable;
    public boolean subItem;
    public String parentRef;
    public String parentName;
    public boolean salesTaxIncluded;
    public String salesTaxCode;
    public String salesTaxCodeRef;
    public String incomeAccount;
    public String incomeRef;
    public String assetAccount;
    public String assetRef;
    public String cogsAccount;
    public String cogsRef;
    public String expenseAccount;
    public String expenseRef;
    public Timestamp invStartDate;

    public QboItem() {
    }

    public QboItem(String xmlString) {
        this.id = Utility.getElement("Id", xmlString);
        this.syncToken = Utility.getIntElement("SyncToken", xmlString);
        this.active = Utility.getBooleanElement("Active", xmlString);
        this.taxable = Utility.getBooleanElement("Taxable", xmlString);
        this.fullyQualifiedName = Utility.getElement("FullyQualifiedName", xmlString);
        this.sku = Utility.getElement("Sku", xmlString);
        this.type = Utility.getElement("Type", xmlString);
        this.purchaseDesc = Utility.getElement("PurchaseDesc", xmlString);
        this.purchaseCost = Utility.getDoubleElement("PurchaseCost", xmlString);
        this.description = Utility.getElement("Description", xmlString);
        this.unitPrice = Utility.getDoubleElement("UnitPrice", xmlString);
        this.trackQtyOnHand = Utility.getBooleanElement("TrackQtyOnHand", xmlString);
        this.qtyOnHand = Utility.getDoubleElement("QtyOnHand", xmlString);
        this.taxable = Utility.getBooleanElement("Taxable", xmlString);
        this.salesTaxIncluded = Utility.getBooleanElement("SalesTaxIncluded", xmlString);
        this.subItem = Utility.getBooleanElement("SubItem", xmlString);
        Hashtable parentRefParameters = new Hashtable();
        this.parentRef = Utility.getElement("ParentRef", xmlString, parentRefParameters);
        this.parentName = (String)parentRefParameters.get("name");
        this.parentName = Utility.removeDoubleQuotes(this.parentName);
        Hashtable salesTaxCodeParameters = new Hashtable();
        this.salesTaxCodeRef = Utility.getElement("SalesTaxCodeRef", xmlString, salesTaxCodeParameters);
        this.salesTaxCode = (String)salesTaxCodeParameters.get("name");
        this.salesTaxCode = Utility.removeDoubleQuotes(this.salesTaxCode);
        Hashtable incomeAccountParameters = new Hashtable();
        this.incomeRef = Utility.getElement("IncomeAccountRef", xmlString, incomeAccountParameters);
        this.incomeAccount = (String)incomeAccountParameters.get("name");
        this.incomeAccount = Utility.removeDoubleQuotes(this.incomeAccount);
        Hashtable assetAccountParameters = new Hashtable();
        this.assetRef = Utility.getElement("AssetAccountRef", xmlString, assetAccountParameters);
        this.assetAccount = (String)assetAccountParameters.get("name");
        this.assetAccount = Utility.removeDoubleQuotes(this.assetAccount);
        Hashtable cogsAccountParameters = new Hashtable();
        this.cogsRef = Utility.getElement("COGSAccountRef", xmlString, cogsAccountParameters);
        this.cogsAccount = (String)cogsAccountParameters.get("name");
        this.cogsAccount = Utility.removeDoubleQuotes(this.cogsAccount);
        Hashtable expenseAccountParameters = new Hashtable();
        this.expenseRef = Utility.getElement("ExpenseAccountRef", xmlString, expenseAccountParameters);
        this.expenseAccount = (String)expenseAccountParameters.get("name");
        this.expenseAccount = Utility.removeDoubleQuotes(this.expenseAccount);
    }

    public String toXml() {
        return this.toXml(false);
    }

    public String toXml(boolean forUpdate) {
        StringBuilder xml = new StringBuilder();
        xml.append("<Item xmlns=\"http://schema.intuit.com/finance/v3\" domain=\"QBO\" sparse=\"true\">");
        if (forUpdate) {
            xml.append("<Id>" + this.id + "</Id>");
            xml.append("<SyncToken>" + this.syncToken + "</SyncToken>");
        }
        xml.append("<Active>" + this.active + "</Active>");
        xml.append("<Taxable>" + this.taxable + "</Taxable>");
        xml.append("<Name>" + Utility.encodeString(this.fullyQualifiedName) + "</Name>");
        xml.append("<Sku>" + Utility.encodeString(this.sku) + "</Sku>");
        xml.append("<Type>" + Utility.encodeString(this.type) + "</Type>");
        xml.append("<PurchaseDesc>" + Utility.encodeString(this.purchaseDesc) + "</PurchaseDesc>");
        xml.append("<PurchaseCost>" + this.purchaseCost + "</PurchaseCost>");
        xml.append("<Description>" + Utility.encodeString(this.description) + "</Description>");
        xml.append("<UnitPrice>" + this.unitPrice + "</UnitPrice>");
        xml.append("<TrackQtyOnHand>" + this.trackQtyOnHand + "</TrackQtyOnHand>");
        xml.append("<QtyOnHand>" + this.qtyOnHand + "</QtyOnHand>");
        xml.append("<Taxable>" + this.taxable + "</Taxable>");
        xml.append("<SubItem>" + this.subItem + "</SubItem>");
        if (this.parentName != null && !this.parentName.isEmpty() && this.parentRef != null && !this.parentRef.isEmpty()) {
            xml.append("<ParentRef name=\"" + this.parentName + "\">" + this.parentRef + "</ParentRef>");
        }
        if (this.salesTaxCode == null || this.salesTaxCode.isEmpty()) {
            xml.append("<SalesTaxIncluded>false</SalesTaxIncluded>");
        } else {
            if (this.salesTaxIncluded) {
                xml.append("<SalesTaxIncluded>" + this.salesTaxIncluded + "</SalesTaxIncluded>");
            }
            xml.append("<SalesTaxCodeRef name=\"" + this.salesTaxCode + "\">" + this.salesTaxCodeRef + "</SalesTaxCodeRef>");
        }
        if (this.incomeAccount != null && !this.incomeAccount.isEmpty() && this.incomeRef != null && !this.incomeRef.isEmpty()) {
            xml.append("<IncomeAccountRef name=\"" + this.incomeAccount + "\">" + this.incomeRef + "</IncomeAccountRef>");
        }
        if (this.assetAccount != null && !this.assetAccount.isEmpty() && this.assetRef != null && !this.assetRef.isEmpty()) {
            xml.append("<AssetAccountRef name=\"" + this.assetAccount + "\">" + this.assetRef + "</AssetAccountRef>");
        }
        if (this.cogsAccount != null && !this.cogsAccount.isEmpty() && this.cogsRef != null && !this.cogsRef.isEmpty()) {
            xml.append("<COGSAccountRef name=\"" + this.cogsAccount + "\">" + this.cogsRef + "</COGSAccountRef>");
        }
        if (this.expenseAccount != null && !this.expenseAccount.isEmpty() && this.expenseRef != null && !this.expenseRef.isEmpty()) {
            xml.append("<ExpenseAccountRef name=\"" + this.expenseAccount + "\">" + this.expenseRef + "</ExpenseAccountRef>");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSS'Z'");
        xml.append("<QtyOnHand>" + this.qtyOnHand + "</QtyOnHand>");
        if (this.invStartDate == null) {
            Date today = new Date();
            this.invStartDate = new Timestamp(today.getTime());
        }
        xml.append("<InvStartDate>" + dateFormat.format(this.invStartDate) + "</InvStartDate>");
        xml.append("</Item>");
        return xml.toString();
    }
}

