/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;

public class QboCustomer {
    public String id;
    public boolean active;
    public boolean taxable;
    public String fullyQualifiedName;
    public String contactName;
    public String addressId;
    public String address1;
    public String address2;
    public String city;
    public String state;
    public String zip;
    public String country;
    public String altContactName;
    public String companyName;
    public String firstName;
    public String middleName;
    public String lastName;
    public String emailAddress;
    public String phone;
    public String fax;
    public String customerType;
    public String customerTypeRef;
    public String taxCodeRef;
    public double balance;
    public String salesTermRef;
    public int syncToken;

    public QboCustomer() {
    }

    public QboCustomer(String xmlString) {
        this.id = Utility.getElement("Id", xmlString);
        this.active = Utility.getBooleanElement("Active", xmlString);
        this.taxable = Utility.getBooleanElement("Taxable", xmlString);
        this.fullyQualifiedName = Utility.getElement("FullyQualifiedName", xmlString);
        this.companyName = Utility.getElement("CompanyName", xmlString);
        this.contactName = Utility.getElement("ContactName", xmlString);
        String billingAddressXml = Utility.getElement("BillAddr", xmlString);
        this.addressId = Utility.getElement("Id", billingAddressXml);
        this.address1 = Utility.getElement("Line1", billingAddressXml);
        this.address2 = Utility.getElement("Line2", billingAddressXml);
        this.city = Utility.getElement("City", billingAddressXml);
        this.state = Utility.getElement("CountrySubDivisionCode", billingAddressXml);
        this.zip = Utility.getElement("PostalCode", billingAddressXml);
        this.country = Utility.getElement("Country", billingAddressXml);
        this.firstName = Utility.getElement("GivenName", xmlString);
        this.middleName = Utility.getElement("MiddleName", xmlString);
        this.lastName = Utility.getElement("FamilyName", xmlString);
        String primaryEmailAddressXml = Utility.getElement("PrimaryEmailAddr", xmlString);
        this.emailAddress = Utility.getElement("Address", primaryEmailAddressXml);
        String primaryPhoneXml = Utility.getElement("PrimaryPhone", xmlString);
        this.phone = Utility.getElement("FreeFormNumber", primaryPhoneXml);
        String primaryFaxXml = Utility.getElement("Fax", xmlString);
        this.fax = Utility.getElement("FreeFormNumber", primaryFaxXml);
        this.customerTypeRef = Utility.getElement("CustomerTypeRef", xmlString);
        this.taxCodeRef = Utility.getElement("DefaultTaxCodeRef", xmlString);
        this.balance = Utility.getDoubleElement("Balance", xmlString);
        this.salesTermRef = Utility.getElement("SalesTermRef", xmlString);
        this.syncToken = Utility.getIntElement("SyncToken", xmlString);
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<Customer xmlns=\"http://schema.intuit.com/finance/v3\" domain=\"QBO\" sparse=\"true\">");
        if (this.id != null && !this.id.isEmpty()) {
            xml.append("<Id>" + this.id + "</Id>");
        }
        xml.append("<DisplayName>" + this.fullyQualifiedName + "</DisplayName>");
        xml.append("<Active>" + this.active + "</Active>");
        xml.append("<Taxable>" + this.taxable + "</Taxable>");
        xml.append("<CompanyName>" + this.companyName + "</CompanyName>");
        xml.append("<ContactName>" + this.contactName + "</ContactName>");
        xml.append("<BillAddr>");
        if (this.addressId != null && !this.addressId.isEmpty()) {
            xml.append("<Id>" + this.addressId + "</Id>");
        }
        xml.append("<Line1>" + this.address1 + "</Line1>");
        xml.append("<Line2>" + this.address2 + "</Line2>");
        xml.append("<City>" + this.city + "</City>");
        xml.append("<CountrySubDivisionCode>" + this.state + "</CountrySubDivisionCode>");
        xml.append("<PostalCode>" + this.zip + "</PostalCode>");
        xml.append("<Country>" + this.country + "</Country>");
        xml.append("</BillAddr>");
        xml.append("<GivenName>" + this.firstName + "</GivenName>");
        xml.append("<MiddleName>" + this.middleName + "</MiddleName>");
        xml.append("<FamilyName>" + this.lastName + "</FamilyName>");
        xml.append("<PrimaryEmailAddr><Address>" + this.emailAddress + "</Address></PrimaryEmailAddr>");
        xml.append("<PrimaryPhone><FreeFormNumber>" + this.phone + "</FreeFormNumber></PrimaryPhone>");
        xml.append("<Fax><FreeFormNumber>" + this.fax + "</FreeFormNumber></Fax>");
        xml.append("<DefaultTaxCodeRef>" + this.taxCodeRef + "</DefaultTaxCodeRef>");
        xml.append("<Balance>" + this.balance + "</Balance>");
        xml.append("<SalesTermRef>" + this.salesTermRef + "</SalesTermRef>");
        if (this.customerTypeRef != null && !this.customerTypeRef.isEmpty()) {
            xml.append("<CustomerTypeRef>" + this.customerTypeRef + "</CustomerTypeRef>");
        }
        if (this.syncToken > -1) {
            xml.append("<SyncToken>" + this.syncToken + "</SyncToken>");
        }
        xml.append("</Customer>");
        return xml.toString();
    }
}

