/*
 * Decompiled with CFR 0.152.
 */
package AccuServerBase;

import AccuServerBase.ByteVector;
import AccuServerBase.RegionalDecimalFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Utility {
    public static StringBuffer log = null;

    public static Class getDataObjectClass(String name) {
        Class<?> result = null;
        try {
            result = Class.forName("POSDataObjects." + name);
        }
        catch (ClassNotFoundException ex) {
            try {
                result = Class.forName("AccuShiftDataObjects." + name);
            }
            catch (ClassNotFoundException ex1) {
                try {
                    result = Class.forName("AccuCountDataObjects." + name);
                }
                catch (ClassNotFoundException ex2) {
                    result = null;
                }
            }
        }
        return result;
    }

    public static String getExceptionText(Exception e) {
        StackTraceElement[] traces = e.getStackTrace();
        int len = traces.length;
        String logText = e.getLocalizedMessage() + "\r\n";
        for (int i = 0; i < len; ++i) {
            logText = logText + traces[i] + "\n";
        }
        return logText;
    }

    public static Image readImageFromJar(String imageName) {
        BufferedImage image = null;
        try {
            String jarFileName = System.getProperty("user.dir") + System.getProperty("file.separator") + "AccuServer.jar";
            JarFile jarFile = new JarFile(jarFileName);
            JarEntry entry = jarFile.getJarEntry(imageName);
            InputStream input = jarFile.getInputStream(entry);
            image = ImageIO.read(input);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static Font pickFont(Component component, String[] lines) {
        Graphics g = component.getGraphics();
        Font thisFont = component.getFont();
        FontMetrics fontMetrics = g.getFontMetrics();
        int high = fontMetrics.getHeight();
        double thisHigh = (double)component.getHeight() * (1.0 / (double)lines.length) * 0.8;
        double thisWide = (double)component.getWidth() * 0.7;
        int wide = 0;
        int thisWideReference = 0;
        for (int l = 0; l < lines.length; ++l) {
            int thisWidth = fontMetrics.stringWidth(lines[l]);
            if (wide >= thisWidth) continue;
            wide = thisWidth;
            thisWideReference = l;
        }
        float size = thisFont.getSize();
        while ((double)high < thisHigh && size < 72.0f && (double)wide < thisWide) {
            thisFont = thisFont.deriveFont(size += 1.0f);
            component.setFont(thisFont);
            g.setFont(thisFont);
            fontMetrics = g.getFontMetrics();
            high = fontMetrics.getHeight();
            wide = fontMetrics.stringWidth(lines[thisWideReference]);
        }
        while ((double)high > thisHigh && size > 6.0f && (double)wide > thisWide) {
            thisFont = thisFont.deriveFont(size -= 1.0f);
            component.setFont(thisFont);
            g.setFont(thisFont);
            fontMetrics = g.getFontMetrics();
            high = fontMetrics.getHeight();
            wide = fontMetrics.stringWidth(lines[thisWideReference]);
        }
        return thisFont;
    }

    public static String[] wrapText(String text, Graphics g, Font font, double width, double[] lineHeight) {
        Vector<String> result = new Vector<String>();
        FontMetrics metrics = g.getFontMetrics(font);
        lineHeight[0] = 10.0;
        int len = text.length();
        String line = "";
        String word = "";
        String temp = "";
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            temp = word + c;
            Rectangle2D rectangle = metrics.getStringBounds(temp, g);
            if (rectangle.getHeight() > lineHeight[0]) {
                lineHeight[0] = (float)rectangle.getHeight();
            }
            if (rectangle.getWidth() > width) {
                result.add(word);
                word = "";
            }
            word = word + c;
            temp = line + word;
            rectangle = metrics.getStringBounds(temp, g);
            if (rectangle.getHeight() > lineHeight[0]) {
                lineHeight[0] = (float)rectangle.getHeight();
            }
            if (rectangle.getWidth() > width) {
                if (line.length() > 0) {
                    result.add(line);
                }
                line = "";
            } else if (c == '\n') {
                line = line + word;
                word = "";
                String thisLine = line.trim();
                if (thisLine != null && thisLine.length() > 0) {
                    result.add(line);
                }
                line = "";
            }
            if (c != ' ') continue;
            line = line + word;
            word = "";
        }
        if (word.length() > 0) {
            line = line + word;
        }
        if (line.length() > 0) {
            result.add(line);
        }
        len = result.size();
        String[] returnValue = new String[len];
        for (int i = 0; i < len; ++i) {
            returnValue[i] = ((String)result.get(i)).trim();
        }
        return returnValue;
    }

    public static void showMessage(Component program, String message) {
        JOptionPane.showMessageDialog(program, message);
    }

    public static boolean confirmMessage(Component program, String message) {
        int result = JOptionPane.showConfirmDialog(program, message);
        return result == 0;
    }

    public static Image getImage(String imageName) {
        Image image = null;
        String userDir = System.getProperty("user.dir");
        String imageFilename = userDir + "\\" + imageName;
        image = Toolkit.getDefaultToolkit().getImage(imageFilename);
        return image;
    }

    public static void writeXml(String filename, String xml) throws IOException {
        Utility.writeXml(filename, xml, "UTF-8", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXml(String filename, String xml, String encoding, boolean append) throws IOException {
        File outFile = new File(filename);
        FileOutputStream fileStream = new FileOutputStream(outFile, append);
        OutputStreamWriter outStream = new OutputStreamWriter((OutputStream)fileStream, encoding);
        BufferedWriter out = new BufferedWriter(outStream);
        try {
            if (append) {
                out.append(xml);
            } else {
                out.write(xml);
            }
        }
        finally {
            out.close();
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        long length = 1L;
        FileInputStream is = null;
        if (!file.exists()) {
            return new byte[1];
        }
        is = new FileInputStream(file);
        length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        if (is != null) {
            ((InputStream)is).close();
        }
        return bytes;
    }

    public static Color colorFromXml(String xml) {
        int red = Utility.getIntElement("Red", xml);
        int green = Utility.getIntElement("Green", xml);
        int blue = Utility.getIntElement("Blue", xml);
        Color result = new Color(red, green, blue);
        return result;
    }

    public static String getColorXml(Color color) {
        String xml = "<Red>" + color.getRed() + "</Red><Green>" + color.getGreen() + "</Green><Blue>" + color.getBlue() + "</Blue>";
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXml(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        StringBuffer xml = new StringBuffer();
        FileInputStream fstream = null;
        try {
            String strLine;
            fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            while ((strLine = br.readLine()) != null) {
                xml.append(strLine + "\r\n");
            }
            br.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fstream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return xml.toString();
    }

    public static String getElement(String name, String xml, Hashtable parameters) {
        String result = "";
        String startTag = "<" + name;
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String lastName = "";
        String parametersText = xml.substring(startPos + startTag.length(), startTagEnd);
        String[] pairs = parametersText.split(" ");
        for (int i = 0; i < pairs.length; ++i) {
            String[] thisPair = pairs[i].split("=");
            if (thisPair.length > 1) {
                lastName = thisPair[0].trim();
                if (thisPair[1].contains("N/A") || thisPair[1].contains("n/a")) continue;
                parameters.put(lastName, thisPair[1]);
                continue;
            }
            if (lastName == null || lastName.length() <= 0) continue;
            String value = (String)parameters.get(lastName);
            if ((value = value + " " + thisPair[0]).contains("N/A") || value.contains("n/a")) continue;
            parameters.put(lastName, value.trim());
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            result = xml.substring(++startTagEnd, endPos);
        }
        return result;
    }

    public static int getIntElement(String name, String xml) {
        int result = 0;
        try {
            String intText = Utility.getElement(name, xml);
            if (intText != null && intText.length() > 0 && intText.compareToIgnoreCase("null") != 0) {
                result = Integer.parseInt(intText);
            }
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public static long getLongElement(String name, String xml) {
        long result = 0L;
        try {
            String longText = Utility.getElement(name, xml);
            if (longText != null && longText.length() > 0) {
                result = Long.parseLong(longText);
            }
        }
        catch (Exception e) {
            result = 0L;
        }
        return result;
    }

    public static boolean getBooleanElement(String name, String xml) {
        return Utility.getBooleanElement(name, xml, false);
    }

    public static boolean getBooleanElement(String name, String xml, boolean defaultValue) {
        String booleanText = Utility.getElement(name, xml);
        if (booleanText == null || booleanText.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(booleanText);
    }

    public static double getDoubleElement(String name, String xml) {
        double result = 0.0;
        String doubleText = Utility.getElement(name, xml);
        if (doubleText != null && doubleText.length() > 0) {
            try {
                RegionalDecimalFormat df = new RegionalDecimalFormat("0.00###");
                result = df.convertRegionalTextToDecimal(df, doubleText);
            }
            catch (Exception ex) {
                result = 0.0;
            }
        }
        return result;
    }

    public static String getElement(String name, String xml) {
        String result = "";
        String startTag = "<" + name + ">";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "<" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            startPos += name.length() + 2;
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }

    public static int getIntElement(String name, Hashtable elements) {
        int resultInt = 0;
        String resultString = (String)elements.get(name);
        if (resultString != null && !resultString.isEmpty()) {
            try {
                resultInt = Integer.parseInt(resultString);
            }
            catch (NumberFormatException e) {
                resultInt = 0;
            }
        }
        return resultInt;
    }

    public static double getDoubleElement(String name, Hashtable elements) {
        double resultDouble = 0.0;
        String resultString = (String)elements.get(name);
        if (resultString != null && !resultString.isEmpty()) {
            try {
                resultDouble = Double.parseDouble(resultString);
            }
            catch (NumberFormatException e) {
                resultDouble = 0.0;
            }
        }
        return resultDouble;
    }

    public static long getLongElement(String name, Hashtable elements) {
        long resultLong = 0L;
        String resultString = (String)elements.get(name);
        if (resultString != null && !resultString.isEmpty()) {
            try {
                resultLong = Long.parseLong(resultString);
            }
            catch (NumberFormatException e) {
                resultLong = 0L;
            }
        }
        return resultLong;
    }

    public static boolean getBooleanElement(String name, Hashtable elements) {
        boolean resultBoolean = false;
        String resultString = (String)elements.get(name);
        if (resultString != null && !resultString.isEmpty()) {
            try {
                resultBoolean = Boolean.parseBoolean(resultString);
            }
            catch (NumberFormatException e) {
                resultBoolean = false;
            }
        }
        return resultBoolean;
    }

    public static String getElement(String name, Hashtable elements) {
        String resultString = (String)elements.get(name);
        if (resultString == null) {
            resultString = "";
        }
        return resultString;
    }

    public static Hashtable getElements(String xml) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        int len = xml.length();
        String currentTag = "";
        String currentData = "";
        boolean isReadingData = false;
        boolean isReadingTagName = false;
        for (int i = 0; i < len; ++i) {
            char thisChar = xml.charAt(i);
            if (isReadingData) {
                if (thisChar == '<') {
                    if (!currentData.isEmpty()) {
                        result.put(currentTag, currentData);
                    } else {
                        String endTag = "</" + currentTag + ">";
                        int pos = xml.indexOf(endTag, i);
                        if (pos >= 0) {
                            String innerData = xml.substring(i, pos);
                            result.put(currentTag, innerData);
                            i += innerData.length();
                        }
                    }
                    isReadingData = false;
                    isReadingTagName = true;
                    currentData = "";
                    currentTag = "";
                    continue;
                }
                currentData = currentData + thisChar;
                continue;
            }
            if (isReadingTagName) {
                if (thisChar == '>') {
                    isReadingTagName = false;
                    isReadingData = true;
                    continue;
                }
                currentTag = currentTag + thisChar;
                continue;
            }
            if (thisChar == '<') {
                isReadingTagName = true;
                continue;
            }
            if (thisChar != '/') continue;
            isReadingTagName = false;
            isReadingData = false;
            currentTag = "";
            currentData = "";
        }
        return result;
    }

    public static String getTag(String name, String xml) {
        String result = "";
        String startTag = "{" + name + "}";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "{" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf("}", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "{/" + name + "}";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            startPos += name.length() + 2;
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }

    public static String getXmlBlock(String name, String xml) {
        String result = "";
        String startTag = "<" + name + ">";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "<" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag) + endTag.length();
        if (endPos > startPos) {
            result = xml.substring(startPos, endPos);
        }
        return result;
    }

    public static String getDataBlock(String name, String xml, Hashtable parameters) {
        String result = "";
        String startTag = "{" + name + "}";
        int startPos = xml.indexOf(startTag);
        if (startPos > -1) {
            return Utility.getDataBlock(name, xml);
        }
        startTag = "{" + name + " ";
        startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf("}", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String lastName = "";
        String parametersText = xml.substring(startPos + startTag.length(), startTagEnd);
        String[] pairs = parametersText.split(" ");
        for (int i = 0; i < pairs.length; ++i) {
            String[] thisPair = pairs[i].split("=");
            if (thisPair.length > 1) {
                lastName = thisPair[0].trim();
                if (thisPair[1].contains("N/A") || thisPair[1].contains("n/a")) continue;
                parameters.put(lastName, thisPair[1]);
                continue;
            }
            if (lastName == null || lastName.length() <= 0) continue;
            String value = (String)parameters.get(lastName);
            if ((value = value + " " + thisPair[0]).contains("N/A") || value.contains("n/a")) continue;
            parameters.put(lastName, value.trim());
        }
        String endTag = "{/" + name + "}";
        int endPos = xml.indexOf(endTag) + endTag.length();
        if (endPos > startPos) {
            result = xml.substring(startPos, endPos);
        }
        return result;
    }

    public static String getDataBlock(String name, String xml) {
        String result = "";
        String startTag = "{" + name + "}";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "{" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf("}", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "{/" + name + "}";
        int endPos = xml.indexOf(endTag) + endTag.length();
        if (endPos > startPos) {
            result = xml.substring(startPos, endPos);
        }
        return result;
    }

    public static String getDataBlockContents(String name, String xml) {
        String result = "";
        String startTag = "{" + name + "}";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "{" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf("}", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "{/" + name + "}";
        int endPos = xml.indexOf(endTag) + endTag.length();
        if ((endPos -= endTag.length()) > startPos) {
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }

    public static String replaceXmlDataTag(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "<" + tag + ">";
        int start = source.indexOf(startTag);
        int end = start + startTag.length();
        if (start < 0) {
            return source;
        }
        result.append(source.substring(0, start));
        result.append(replacement);
        result.append(source.substring(end));
        String reply = new String(result);
        int secondStart = source.indexOf(startTag);
        if (secondStart >= 0) {
            reply = Utility.replaceDataTag(reply, tag, replacement);
        }
        return reply;
    }

    public static String replaceXmlBlock(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "<" + tag;
        String endTag = "</" + tag + ">";
        int start = source.indexOf(startTag);
        if (start < 0) {
            return source;
        }
        int end = source.indexOf(endTag, start);
        result.append(source.substring(0, start));
        result.append(replacement);
        String endText = source.substring(end += endTag.length());
        result.append(endText);
        return new String(result);
    }

    public static String getBlock(String name, String xml) {
        String result = "";
        String startTag = "{" + name + "}";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "{" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return "";
        }
        int startTagEnd = xml.indexOf("}", startPos);
        if (startTagEnd < startPos) {
            return "";
        }
        String endTag = "{/" + name + "}";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            startPos += name.length() + 2;
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }

    public static String replaceDataTag(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "{" + tag + "}";
        int start = source.indexOf(startTag);
        int end = start + startTag.length();
        if (start < 0) {
            return source;
        }
        result.append(source.substring(0, start));
        result.append(replacement);
        result.append(source.substring(end));
        String reply = new String(result);
        int secondStart = source.indexOf(startTag);
        if (secondStart >= 0) {
            reply = Utility.replaceDataTag(reply, tag, replacement);
        }
        return reply;
    }

    public static String replaceBlock(String source, String tag, String replacement) {
        StringBuffer result = new StringBuffer();
        String startTag = "{" + tag + "}";
        String endTag = "{/" + tag + "}";
        int start = source.indexOf(startTag);
        if (start < 0) {
            startTag = "{" + tag;
            start = source.indexOf(startTag);
        }
        if (start < 0) {
            return source;
        }
        int end = source.indexOf(endTag, start);
        result.append(source.substring(0, start));
        result.append(replacement);
        String endText = source.substring(end += endTag.length());
        result.append(endText);
        return new String(result);
    }

    public static Vector getElementList(String name, String xml) {
        Vector<String> result = new Vector<String>();
        int blockStart = 0;
        int blockEnd = 0;
        boolean done = false;
        while (!done) {
            blockStart = xml.indexOf("<" + name, blockEnd);
            int startTagEnd = xml.indexOf(">", blockStart);
            blockEnd = xml.indexOf("</" + name + ">", blockStart);
            if (startTagEnd > blockStart && blockStart >= 0 && blockEnd > blockStart) {
                int dataStart = startTagEnd + 1;
                int dataEnd = blockEnd;
                String temp = xml.substring(dataStart, dataEnd);
                result.add(temp);
                continue;
            }
            done = true;
        }
        return result;
    }

    public static Vector getTaggedList(String name, String xml) {
        Vector<String> result = new Vector<String>();
        int blockStart = 0;
        int blockEnd = 0;
        boolean done = false;
        while (!done) {
            blockStart = xml.indexOf("{" + name, blockEnd);
            int startTagEnd = xml.indexOf("}", blockStart);
            blockEnd = xml.indexOf("{/" + name + "}", blockStart);
            if (startTagEnd > blockStart && blockStart >= 0 && blockEnd > blockStart) {
                int dataStart = startTagEnd + 1;
                int dataEnd = blockEnd;
                String temp = xml.substring(dataStart, dataEnd);
                result.add(temp);
                continue;
            }
            done = true;
        }
        return result;
    }

    public static Vector getElementList(String name, String xml, Vector parameters) {
        Vector<String> result = new Vector<String>();
        int blockStart = 0;
        int blockEnd = 0;
        boolean done = false;
        while (!done) {
            blockStart = xml.indexOf("<" + name, blockEnd);
            blockEnd = xml.indexOf("</" + name + ">", blockStart);
            if (blockStart >= 0 && blockEnd > blockStart) {
                int dataEnd = blockEnd;
                int startTagEnd = xml.indexOf(">", blockStart);
                if (startTagEnd <= blockStart) continue;
                Hashtable<String, String> theseParameters = new Hashtable<String, String>();
                String lastName = "";
                String parametersText = xml.substring(blockStart + name.length() + 1, startTagEnd);
                String[] pairs = parametersText.split(" ");
                for (int i = 0; i < pairs.length; ++i) {
                    String[] thisPair = pairs[i].split("=");
                    if (thisPair.length > 1) {
                        lastName = thisPair[0].trim();
                        if (thisPair[1].contains("N/A") || thisPair[1].contains("n/a")) continue;
                        theseParameters.put(lastName, thisPair[1]);
                        continue;
                    }
                    if (lastName == null || lastName.length() <= 0) continue;
                    String value = (String)theseParameters.get(lastName);
                    if ((value = value + " " + thisPair[0]).contains("N/A") || value.contains("n/a")) continue;
                    theseParameters.put(lastName, value.trim());
                }
                parameters.add(theseParameters);
                String temp = xml.substring(startTagEnd + 1, dataEnd);
                result.add(temp);
                continue;
            }
            done = true;
        }
        return result;
    }

    public String readSocketBytes(Socket socket, String tag) throws Exception {
        StringBuffer replyString = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        try {
            String readLine;
            while ((readLine = reader.readLine()) != null) {
                replyString.append(readLine + "\n");
            }
        }
        catch (Exception e) {
            reader.close();
            return null;
        }
        reader.close();
        return replyString.toString();
    }

    public byte[] zip(byte[] zipData) {
        if (zipData == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(out);
            ZipEntry entry = new ZipEntry("data");
            zipOut.putNextEntry(entry);
            zipOut.write(zipData);
            zipOut.closeEntry();
            zipOut.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return out.toByteArray();
    }

    public byte[] unzip(byte[] zipData) {
        if (zipData == null) {
            return null;
        }
        byte[] data = null;
        byte[] result = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(zipData);
            ZipInputStream zipIn = new ZipInputStream(in);
            ZipEntry entry = zipIn.getNextEntry();
            System.out.println(" zip entry name " + entry.getName());
            if (!entry.isDirectory()) {
                long size = entry.getSize();
                size = 32000L;
                data = new byte[(int)size];
                while (zipIn.available() > 0) {
                    data = new byte[(int)size];
                    int count = zipIn.read(data, 0, (int)size);
                    if (count <= -1) continue;
                    System.out.println(new String(data));
                    if (result == null) {
                        result = new byte[count];
                        System.arraycopy(data, 0, result, 0, count);
                        continue;
                    }
                    int newSize = result.length + count;
                    byte[] newResult = new byte[newSize];
                    System.arraycopy(result, 0, newResult, 0, result.length);
                    System.arraycopy(data, 0, newResult, result.length, count);
                    result = newResult;
                }
                return result;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void postTime() {
        Date now = new Date();
        System.out.println(now.getTime());
    }

    public String sendRequest(Socket socket, String request) throws Exception {
        BufferedOutputStream bout = new BufferedOutputStream(socket.getOutputStream());
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF8");
        out.write(request);
        out.flush();
        Utility utility = new Utility();
        String replyString = utility.readSocketBytes(socket, "POSServerRequest");
        out.close();
        return replyString;
    }

    public static void sendReply(Socket socket, String reply, String status) throws IOException {
        String replyXML = "<POSReply>\n";
        replyXML = replyXML + "    <Status>" + status + "</Status>\n";
        replyXML = replyXML + "    <Message>" + reply + "</Message>\n";
        replyXML = replyXML + "</POSReply>\n";
        PrintStream ps = new PrintStream(socket.getOutputStream());
        ps.println(replyXML);
        ps.flush();
        ps.close();
    }

    public static int convertColor(Color colorValue) {
        int red = colorValue.getRed();
        int green = colorValue.getGreen();
        int blue = colorValue.getBlue();
        int result = blue * 65536 + green * 256 + red;
        return result;
    }

    public static Color translateColor(int colorValue) {
        if (colorValue < 0) {
            return new Color(192, 192, 192);
        }
        int red = colorValue & 0xFF;
        int green = colorValue & 0xFF00;
        int blue = colorValue & 0xFF0000;
        return new Color(red, green /= 256, blue /= 65536);
    }

    public static boolean writeZipFile(String zipFilename, String sourceFilename) {
        boolean result = false;
        try {
            int len;
            String outFilename = zipFilename;
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
            byte[] buf = new byte[1024];
            out.putNextEntry(new ZipEntry(sourceFilename));
            FileInputStream in = new FileInputStream(sourceFilename);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            out.close();
            in.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean readZipFile(String zipFilename, String path) {
        boolean result = false;
        try {
            int len;
            String inFilename = zipFilename;
            ZipInputStream in = new ZipInputStream(new FileInputStream(inFilename));
            ZipEntry entry = in.getNextEntry();
            String outFilename = path;
            System.out.println("archive=" + entry.getName() + ", output=" + outFilename);
            FileOutputStream out = new FileOutputStream(outFilename);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String insertSpecial(String source) {
        String result = source;
        if (source == null) {
            return "";
        }
        int len = result.length();
        String result2 = "";
        for (int i = 0; i < len; ++i) {
            char thisChar = result.charAt(i);
            char val = thisChar;
            if (val > '\u0080') {
                result2 = result2 + "&#";
                result2 = result2 + new Integer(val).toString();
                result2 = result2 + ';';
                continue;
            }
            result2 = result2 + thisChar;
        }
        return result2;
    }

    public static String encodeString(String encodeString) {
        try {
            encodeString = encodeString.replaceAll("&amp;", "&");
            encodeString = encodeString.replaceAll("&apos;", "'");
            encodeString = encodeString.replaceAll("&quot;", "\"");
            encodeString = encodeString.replaceAll("&", "&amp;");
            encodeString = encodeString.replaceAll("<", "&lt;");
            encodeString = encodeString.replaceAll(">", "&gt;");
            encodeString = encodeString.replaceAll("'", "&apos;");
            encodeString = encodeString.replaceAll("\"", "&quot;");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encodeString;
    }

    public static String fixString(String source) {
        if (source == null) {
            return " ";
        }
        if (source.length() == 0) {
            return " ";
        }
        return source;
    }

    public static String removeDoubleQuotes(String source) {
        if (source == null) {
            return "";
        }
        if (source.length() == 0) {
            return "";
        }
        source = source.replace("\"", "");
        return source;
    }

    public static double roundDoubleToPennies(double source) {
        long number = Math.round(source * 100.0);
        double result = new Double(number) / 100.0;
        return result;
    }

    public static double roundDoubleToFourPlaces(double source) {
        long number = Math.round(source * 100000.0);
        double result = new Double(number) / 100000.0;
        return result;
    }

    public static String fixStringNoPad(String source) {
        if (source == null) {
            return "";
        }
        if (source.length() == 0) {
            return "";
        }
        return source;
    }

    public static String getLiteralElement(String name, String xml) {
        String result = null;
        String startTag = "<" + name + ">";
        int startPos = xml.indexOf(startTag);
        if (startPos < 0) {
            startTag = "<" + name + " ";
            startPos = xml.indexOf(startTag);
        }
        if (startPos < 0) {
            return null;
        }
        int startTagEnd = xml.indexOf(">", startPos);
        if (startTagEnd < startPos) {
            return null;
        }
        String endTag = "</" + name + ">";
        int endPos = xml.indexOf(endTag);
        if (endPos > startPos) {
            startPos += name.length() + 2;
            result = xml.substring(startTagEnd + 1, endPos);
        }
        return result;
    }

    public static byte[] getFileSegment(String filename, int segmentSize, int segmentNumber) {
        ByteVector bytes = new ByteVector();
        File file = new File(System.getProperty("user.dir") + "/" + filename);
        long fileSegments = file.length() / (long)segmentSize;
        if ((long)segmentNumber <= fileSegments) {
            try {
                byte[] buffer = new byte[segmentSize];
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
                stream.skip(segmentNumber * segmentSize);
                int count = stream.read(buffer);
                bytes.appendBytes(buffer, count);
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bytes.toBytes();
    }

    public String sendTerminalRequest(Socket socket, String request) throws Exception {
        BufferedOutputStream bout = new BufferedOutputStream(socket.getOutputStream());
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF8");
        out.write(request);
        out.flush();
        String replyBytes = this.readSocketBytes(socket, "CustomerTerminalReply");
        return replyBytes;
    }

    public static String getJSONString(String jsonSource, String fieldName) {
        String result = "";
        if (jsonSource == null || jsonSource.isEmpty()) {
            return result;
        }
        String startString = "\"" + fieldName + "\":";
        int fieldStart = jsonSource.indexOf(startString);
        if (fieldStart == -1) {
            return result;
        }
        fieldStart = fieldStart + startString.length() + 1;
        int fieldEnd = jsonSource.indexOf("\"", fieldStart);
        int objEnd = jsonSource.indexOf("}", fieldStart);
        if ((fieldEnd == -1 || fieldEnd > objEnd) && objEnd != -1) {
            fieldEnd = objEnd;
        }
        if (fieldEnd == -1) {
            fieldEnd = jsonSource.length();
        }
        if ((result = jsonSource.substring(fieldStart, fieldEnd)).compareToIgnoreCase("null") == 0 || result.compareToIgnoreCase("ull,") == 0) {
            result = "";
        }
        return result;
    }

    public static double getJSONDouble(String jsonSource, String fieldName) {
        double result = 0.0;
        if (jsonSource == null || jsonSource.isEmpty()) {
            return result;
        }
        String startString = "\"" + fieldName + "\":";
        int fieldStart = jsonSource.indexOf(startString);
        if (fieldStart == -1) {
            return result;
        }
        int fieldEnd = jsonSource.indexOf(",", fieldStart += startString.length());
        int objEnd = jsonSource.indexOf("}", fieldStart);
        if ((fieldEnd == -1 || fieldEnd > objEnd) && objEnd != -1) {
            fieldEnd = objEnd;
        }
        if (fieldEnd == -1) {
            fieldEnd = jsonSource.length();
        }
        String jsonString = jsonSource.substring(fieldStart, fieldEnd);
        jsonString = jsonString.replaceAll("\"", "");
        try {
            result = Double.parseDouble(jsonString);
        }
        catch (Exception e) {
            result = 0.0;
        }
        return result;
    }

    public static long getJSONLong(String jsonSource, String fieldName) {
        long result = 0L;
        if (jsonSource == null || jsonSource.isEmpty()) {
            return result;
        }
        String startString = "\"" + fieldName + "\":";
        int fieldStart = jsonSource.indexOf(startString);
        if (fieldStart == -1) {
            return result;
        }
        int fieldEnd = jsonSource.indexOf(",", fieldStart += startString.length());
        int objEnd = jsonSource.indexOf("}", fieldStart);
        if ((fieldEnd == -1 || fieldEnd > objEnd) && objEnd != -1) {
            fieldEnd = objEnd;
        }
        if (fieldEnd == -1) {
            fieldEnd = jsonSource.length();
        }
        String jsonString = jsonSource.substring(fieldStart, fieldEnd);
        jsonString = jsonString.replaceAll("\"", "");
        try {
            result = Long.parseLong(jsonString);
        }
        catch (Exception e) {
            result = 0L;
        }
        return result;
    }

    public static int getJSONInt(String jsonSource, String fieldName) {
        int result = 0;
        if (jsonSource == null || jsonSource.isEmpty()) {
            return result;
        }
        String startString = "\"" + fieldName + "\":";
        int fieldStart = jsonSource.indexOf(startString);
        if (fieldStart == -1) {
            return result;
        }
        int fieldEnd = jsonSource.indexOf(",", fieldStart += startString.length());
        int objEnd = jsonSource.indexOf("}", fieldStart);
        if ((fieldEnd == -1 || fieldEnd > objEnd) && objEnd != -1) {
            fieldEnd = objEnd;
        }
        if (fieldEnd == -1) {
            fieldEnd = jsonSource.length();
        }
        String intString = jsonSource.substring(fieldStart, fieldEnd);
        intString = intString.replaceAll("\"", "");
        try {
            result = Integer.parseInt(intString);
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public static boolean getJSONBoolean(String jsonSource, String fieldName) {
        boolean result = false;
        if (jsonSource == null || jsonSource.isEmpty()) {
            return result;
        }
        String startString = "\"" + fieldName + "\":";
        int fieldStart = jsonSource.indexOf(startString);
        if (fieldStart == -1) {
            return result;
        }
        int fieldEnd = jsonSource.indexOf(",", fieldStart += startString.length());
        int objEnd = jsonSource.indexOf("}", fieldStart);
        if ((fieldEnd == -1 || fieldEnd > objEnd) && objEnd != -1) {
            fieldEnd = objEnd;
        }
        if (fieldEnd == -1) {
            fieldEnd = jsonSource.length();
        }
        String jsonString = jsonSource.substring(fieldStart, fieldEnd);
        jsonString = jsonString.replaceAll("\"", "");
        try {
            result = Boolean.parseBoolean(jsonString);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static String[] getJSONArray(String jsonString, String fieldName) {
        String[] result = new String[]{};
        if (jsonString == null || jsonString.isEmpty()) {
            return result;
        }
        String startString = "\"" + fieldName + "\":[";
        int arrayStart = jsonString.indexOf(startString);
        if (arrayStart == -1) {
            return result;
        }
        int arrayEnd = Utility.findJSONArrayEnd(jsonString, arrayStart);
        String jsonArray = jsonString.substring(arrayStart += startString.length(), arrayEnd);
        jsonArray = jsonArray.replaceAll("\"", "");
        result = jsonArray.split(",");
        return result;
    }

    public static Vector getJSONElementList(String jsonString, String fieldName) {
        Vector<String> result = new Vector<String>();
        if (jsonString == null || jsonString.isEmpty()) {
            return result;
        }
        String startString = "\"" + fieldName + "\":[";
        int arrayStart = jsonString.indexOf(startString);
        if (arrayStart == -1) {
            return result;
        }
        int arrayEnd = Utility.findJSONArrayEnd(jsonString, arrayStart);
        boolean done = false;
        String jsonArray = jsonString.substring(arrayStart += startString.length(), arrayEnd);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return result;
        }
        int objStart = jsonArray.indexOf("{");
        while (!done) {
            int objEnd = Utility.findJSONObjectEnd(jsonArray, objStart);
            String jsonObject = jsonArray.substring(++objStart, objEnd);
            result.add(jsonObject);
            objStart = jsonArray.indexOf("{", objEnd);
            if (objStart != -1 && objStart <= arrayEnd) continue;
            done = true;
        }
        return result;
    }

    public static int findJSONArrayEnd(String jsonString, int start) {
        int nextObjectStart;
        if (jsonString == null || jsonString.isEmpty()) {
            return -1;
        }
        int startIndex = start;
        int nextObjectEnd = jsonString.indexOf("]", startIndex);
        if (nextObjectEnd < 0) {
            return -1;
        }
        int numObjects = 0;
        while (startIndex < nextObjectEnd && (nextObjectStart = jsonString.indexOf("[", startIndex)) != -1 && nextObjectStart < nextObjectEnd) {
            ++numObjects;
            startIndex = nextObjectStart + 1;
        }
        if (numObjects == 1) {
            return nextObjectEnd;
        }
        int objectsFound = 0;
        while (objectsFound < numObjects) {
            int thisObjectEnd = jsonString.indexOf("]", startIndex);
            int nestedObjectStart = jsonString.indexOf("[", startIndex);
            if (thisObjectEnd == -1) continue;
            if (nestedObjectStart > -1 && nestedObjectStart < thisObjectEnd) {
                startIndex = jsonString.indexOf("]", nestedObjectStart);
                ++startIndex;
                continue;
            }
            ++objectsFound;
            startIndex = thisObjectEnd + 1;
            nextObjectEnd = thisObjectEnd;
        }
        return nextObjectEnd;
    }

    public static int findJSONObjectEnd(String jsonString, int start) {
        int nextObjectStart;
        if (jsonString == null || jsonString.isEmpty()) {
            return -1;
        }
        int startIndex = start;
        int nextObjectEnd = jsonString.indexOf("}", startIndex);
        if (nextObjectEnd < 0) {
            return -1;
        }
        int numObjects = 0;
        while (startIndex < nextObjectEnd && (nextObjectStart = jsonString.indexOf("{", startIndex)) != -1 && nextObjectStart < nextObjectEnd) {
            ++numObjects;
            startIndex = nextObjectStart + 1;
        }
        if (numObjects == 1) {
            return nextObjectEnd;
        }
        int objectsFound = 0;
        while (objectsFound < numObjects) {
            int thisObjectEnd = jsonString.indexOf("}", startIndex);
            int nestedObjectStart = jsonString.indexOf("{", startIndex);
            if (thisObjectEnd == -1) continue;
            if (nestedObjectStart > -1 && nestedObjectStart < thisObjectEnd) {
                startIndex = jsonString.indexOf("}", nestedObjectStart);
                ++startIndex;
                continue;
            }
            ++objectsFound;
            startIndex = thisObjectEnd + 1;
            nextObjectEnd = thisObjectEnd;
        }
        return nextObjectEnd;
    }

    public static String validateString(String data) {
        String result = "";
        if (data == null || data.trim().isEmpty()) {
            if (data == null) {
                result = data;
            }
            return result;
        }
        String iChars = "`~!@$%^&*()_+=[]{};,<>/?*\\'\"";
        int dataLength = data.length();
        for (int i = 0; i < dataLength; ++i) {
            if (iChars.indexOf(data.charAt(i)) == -1) continue;
            return result;
        }
        result = data;
        return result;
    }

    public static String translateSpecial(String source) {
        if (source == null) {
            return "";
        }
        String result = source;
        result = result.replaceAll("&lt;", "<");
        result = result.replaceAll("&gt;", ">");
        result = result.replaceAll("&apos;", "'");
        result = result.replaceAll("&quot;", "\"");
        result = result.replaceAll("&amp;", "&");
        result = result.replaceAll("&com;", ",");
        result = result.replaceAll("&ret;", "\n");
        int pos = 0;
        while (pos > -1) {
            if ((pos = result.indexOf("&#", pos)) <= -1 || result.length() <= 4) continue;
            int end = result.indexOf(59, pos);
            if (end > -1 && end < result.length()) {
                char firstChar;
                char newChar;
                String code = result.substring(pos + 2, end);
                int charInt = new Integer(code);
                char thisInt = newChar = (char)charInt;
                String alt = "&#" + code + ";";
                String replacement = "" + newChar;
                char firstInt = firstChar = replacement.charAt(0);
                result = result.replaceAll(alt, replacement);
                continue;
            }
            ++pos;
        }
        return result;
    }
}

