var ReceiptSettingsFormView = Backbone.View.extend({
    initialize: function (options) {
        this.options = options;
        this.template = _.template(options.template);
        this.model = options.model;
    },

    render: function () {
        var that = this;
        this.$el.detach();
        this.$el.html(this.template({
            receiptSettings: this.model.toJSON(),
        }));
        $(document).ready(function () {
            that.$el.find('select').formSelect();
            that.$el.find('input[type="text"],input[type="number"],input[type="email"],input[type="password"]').each(function () {
                var element = $(this);
                var value = $(element).val();
                if (value !== '') {
                    $(element).siblings('label').addClass('active');
                }
            });
        });
        
        return this;
    }
});