var ProductLineFormView = Backbone.View.extend({
    
    events: {
        'change #item-type' : 'createNewItemType',
        'change #item-category' : 'createNewItemCategory',
        'change #menu-page' : 'checkToAddMenuPage',
        'change #key-set' : 'checkToAddMenuKeySet'
    },

    initialize: function (options) {
        this.options = options;
        this.template = _.template(options.template);
        this.model = options.model;
        this.productLines = options.productLines;
        this.itemTypes = options.itemTypes;
        this.category = options.category;
        this.salesAccounts = options.salesAccounts;
        this.vatCode = options.vatCode;
        this.menuPages = options.menuPages;
        this.menuKeySets= options.menuKeySets;
        this.choiceGroup = options.choiceGroup;
        this.israCardBuild = options.israCardBuild;
    },

    render: function () {
        var that = this;
        this.$el.detach();
        this.$el.html(this.template({
            productLine: this.model.toJSON(),
            itemTypes: this.itemTypes,
            category: this.category,
            salesAccounts: this.salesAccounts,
            menuPages: this.menuPages,
            menuKeySets: this.menuKeySets,
            choiceGroup: this.choiceGroup,
            vatCode: this.vatCode,
            israCardBuild: this.israCardBuild
        }));
        $(document).ready(function() {
            $('.tooltipped').tooltip();
            $('select').formSelect();
        });

        return this;
    },

    createNewItemType: function (e) {
        var action = e.target.selectedOptions[0].dataset.action;

        if (action == "Create New Item Type") {
            var formModal = this.$el.find('#item-type-form-modal').modal();
            formModal.modal('open');
        }
    },

    createNewItemCategory: function (e) {
        var action = e.target.selectedOptions[0].dataset.action;
        if (action == "Create New Item Category") {
            var formModal = this.$el.find('#item-category-form-modal').modal();
            formModal.modal('open');
        }
    },

    checkToAddMenuPage: function (e) {
        var action = e.target.selectedOptions[0].dataset.action;

        if (action == "Create New Menu Page") {
            $("#button-color").show();
            var formModal = this.$el.find('#menu-page-form-modal').modal();
            formModal.modal('open');
        }
        else if (action == "noMenuButton") {
            $("#button-color").hide();
        }
        else {
            $("#button-color").show();
        }
    },

    checkToAddMenuKeySet: function (e) {
        var action = e.target.selectedOptions[0].dataset.action;
        
        if (action == "Create New Key Set") {
            var formModal = this.$el.find('#key-set-form-modal').modal();
            formModal.modal('open');
        }
    }
});
