var ImportExportDataView = Backbone.View.extend({
    breadcrumb: {},
    data: {},

    events: {
        'click .tab': 'onSelectTab',
        'click .export': 'onSelectCard',
        'click .import': 'importExport',
        'change .file': 'import',
        'click .export-file': 'export',
        'click #categoriesBtn': 'openCategoriesModal',
        'click .deliScaleCard': 'selectUnselectDeliScaleCategories',
    },

    initialize: function (options) {
        this.options = options;
        this.template = _.template(options.template);
        this.breadcrumb = options.breadcrumb;
        this.model = options.model;
        this.listenTo(this.model, 'change', this.render);
    },

    render: function () {        
        var that = this;

        App.breadCrumbToolTip = "{Literal}Import and export Data like items{/Literal}";
        that.$el.html(that.template({
            itemCategories: that.itemCategories,
            // backups: that.model.toJSON(),
            // lastBackup: that.lastBackup
        }));
        App.setBreadcrumbs(this.breadcrumb);  

        $(document).ready(function(){
            that.getItemCategories();

            $('select').formSelect();
            $('.modal').modal();
            $('.tooltipped').tooltip({delay: 0});
          });
        return this;
    },

    getCookie: function() {
        var nameEQ = "sessionCookie" + "=";
        var ca = document.cookie.split(';');
        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
        }
    },

    importExport: function (e) {
        if(this.getActiveTab() == "export")
            this.export(e);
        else {
            const file = e.currentTarget.getElementsByTagName("input")[0];//?.files[0];
            file.click();
        }
            // this.import(e);
    },

    export: function (e) {
        var params = {
            actionType: this.getActiveTab(),
            exportEmpty: false,
            // encoding: encoding,
            action: e.currentTarget.parentElement.dataset["action"],
            token: this.getCookie()
        };

        var url = '/data/import-export-data';
        var exportEmptyCheckbox = e.currentTarget.parentElement.parentElement.querySelector('.exportEmpty');
        if(exportEmptyCheckbox != null)
            params.exportEmpty = exportEmptyCheckbox.checked;
        // var encoding = this.$el.find("#encoding-dropdown").val();

        
        var winName='AccuPOS File';
        var windowoption='resizable=yes,height=768,width=1024,location=0,menubar=0,scrollbars=1';
        var form = document.createElement("form");
        var sessionToken = this.getCookie();
        form.setAttribute("method", "post");
        form.setAttribute("token", sessionToken);
        form.setAttribute("action", url);
        form.setAttribute("target", winName);  
        for (var i in params) {
            var input = document.createElement('input');
            input.type = 'text';
            input.name = i;
            input.value = params[i];
            form.appendChild(input);
        }
        document.body.appendChild(form);
        window.open('', winName, windowoption);
        form.target = winName;
        form.submit();

        document.body.removeChild(form);
    },

    showSelectedFile: function(e) {
        var that = this;
        const input = document.querySelectorAll("#image input")[0];
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            
            reader.onload = function (e) {
                that.$el.find('#image img')
                    .attr('src', e.target.result)
                    .removeClass("item-image-placeholder");
            };

            reader.readAsDataURL(input.files[0]);
        }
    },

    import: function(e) {
        // const file = e.currentTarget.getElementsByTagName("input")[0]?.files[0];
        const file = e.currentTarget.files[0];
        var that = this;
        var sessionToken = this.getCookie();
        var actionType = this.getActiveTab();
        var action = e.currentTarget.parentElement.parentElement.dataset["action"];

        if(!file)
        {
            return;
        }
        var data = new FormData();
        data.append('token', sessionToken);
        data.append('actionType', actionType);
        data.append('action', action);
        data.append('fileSize:' + file.size, file);

        $.ajax({
            url: '/data/import-export-data',
            data: data,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: () => {
                that.$el.find('.signature-modal-trigger-preloader').addClass('active');
            },
            success: data => {
                if(!data.success){
                    M.toast({ html: '{Literal}Error: File was not imported!{/Literal}' });
                    that.showImportErrors(data.errors);
                }
                else {
                    that.showImportMessage(data.successMsg)
                    M.toast({ html: '{Literal}File imported{/Literal}' });
                }
            },

            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                } else if (e.status == 500) {
                    that.showImportMessage(e.responseJSON.errorMsg);
                }
            },
            complete: () => {
                document.querySelector('#import-export-data-form-content form').reset();
                that.$el.find('.signature-modal-trigger-preloader').removeClass('active');
            }
        });
    },

    showImportMessage: function(importMsg) {
        document.getElementById("importMsg").innerText = importMsg;
        var importErrorsModalElement = document.getElementById("import-message-modal");
        var modalInstance = M.Modal.init(importErrorsModalElement, {});
        modalInstance.open();
    },

    showImportErrors: function(errors){
        var theadList = Object.keys(errors[0]);
        var headElement = document.querySelector("#import-errors-modal thead tr");
        var headRow = "";
        theadList.forEach(head => {
            headRow += `<th>${head}</th>\n`
        });
        headElement.innerHTML = headRow;

        var bodyElement = document.querySelector("#import-errors-modal tbody");
        var rows = "";
        errors.forEach(error => {
            var errorValues = Object.values(error);
            rows += "<tr>";
            errorValues.forEach(value => rows += `<td>${value}</td>\n`);
            rows += "</tr>";
        });
        bodyElement.innerHTML = rows;

        var importErrorsModalElement = document.getElementById("import-errors-modal");
        var modalInstance = M.Modal.init(importErrorsModalElement, {});
        modalInstance.open();
    },

 
    validateForm: function () {
        var valid = true;


        return valid;
    },

    getActiveTab: function() {
        if(document.getElementById("export").childNodes[0].classList.contains("active"))
            return "export";
        else
            return "import";
    },


    onSelectTab: function (e) {
        var element = e.currentTarget.childNodes[0];

        if(!element.classList.contains("active")){
            var elements = document.getElementsByClassName("tab-content");
            elements[0].classList.toggle("hide");
            elements[1].classList.toggle("hide");
            var activeClasses = ["active", "waves-effect", "waves-light", "btn"];
            var inActiveClasses = ["waves-effect", "waves-teal", "btn-flat", "teal", "lighten-5", "center"];
            var tab = document.querySelectorAll(".tab")[0].childNodes[0];
            if(tab.classList.contains("active")){
                tab.classList = [];
                tab.classList.add(...inActiveClasses);
                tab = document.querySelectorAll(".tab")[1].childNodes[0];
                tab.classList = [];
                tab.classList.add(...activeClasses);
            }
            else {
                tab.classList = [];
                tab.classList.add(...activeClasses);
                tab = document.querySelectorAll(".tab")[1].childNodes[0];
                tab.classList = [];
                tab.classList.add(...inActiveClasses);
            }
        }
    },

    onSelectCard: function (e) {
        var elements = document.querySelectorAll('.export-card .card-panel');
        for (let i = 0; i < elements.length; i++) {
            elements[i].classList.remove('active');
        }

        e.currentTarget.classList.add('active');
    },

    getItemCategories: function () {
        var that = this;
        var sessionToken = this.getCookie();
        return $.ajax({
            url: '/data/get-deli-scale-categories',
            data: {
                token: sessionToken
            },
            dataType: 'json',
            type: 'POST',
            success: function (data) {
                that.itemCategories = data.categories;
                that.deliScaleCategories = data.deliScaleCategories;
                var html = '<div class="row">';
                const categoriesDiv = document.getElementById('categories-content');
                for (let i = 0; i < that.itemCategories.length; i++) {
                    const category = that.itemCategories[i];
                    const isSelected = that.deliScaleCategories.includes(category);
                    var selectedStyle = 'style="background-color: #ffffff; color: #3970b7;"';
                    if(isSelected)
                        selectedStyle =  'style="background-color: #3970b7;color: #fff;"';

                    html += ` <div id ="salesCards">
                    <div class="col s12 m4 xl4">
                        <div class="card-panel card-panel-entity z-depth-1 sequence-card hoverable waves-effect waves-light deliScaleCard" `+ selectedStyle +` data-name="`+ category +`" data-selected='` + (isSelected ? '1' : '0')+`'>
                            <div class="row description truncate" style="position: relative; right: -5px; height: 48px;">
                                &nbsp;&nbsp;` + category + `
                            </div>
                        </div>
                    </div>
                </div>`
                    // html += `<label class="col s12 m3">`;
                    // html +=`<input type="checkbox" class="filled-in" data-name="` + category.name +`"><span>` + category.name + `</span></label>`
                }

                html += '</div>'
               categoriesDiv.innerHTML = html;
            },
            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else {
                    M.toast({
                        html: '{Literal}There was a problem fetching data from the server{/Literal}'
                    });
                }
            }
        });
    },

    saveCategory: function(category, action){
        var that = this;
        var sessionToken = this.getCookie();

        return $.ajax({
            url: '/data/save-deli-scale-categories',
            data: {
                token: sessionToken,
                category: category,
                action: action
    },
            dataType: 'json',
            type: 'POST',
            success: function (data) {
                M.toast({html: '{Literal}Saved{/Literal}'})

            },
            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else {
                    M.toast({
                        html: '{Literal}There was a problem saving data into the server{/Literal}'
                    });
        }
            }
        });
    },

    selectUnselectDeliScaleCategories: function (e) {
        var action = '';
        if(e.currentTarget.dataset.selected == 1) {
            e.currentTarget.style = 'background-color: #ffffff; color: #3970b7;';
            e.currentTarget.dataset.selected = 0;
            action = 'remove';
    }
        else {
            e.currentTarget.style = 'background-color: #3970b7;color: #fff;'
            e.currentTarget.dataset.selected = 1;
            action = 'add';
        }

        
        this.saveCategory(e.currentTarget.dataset.name, action);
    },

    openCategoriesModal: function () {
        M.Modal.getInstance($("#categories-modal")).open();
    },
});