/*
 * Decompiled with CFR 0.152.
 */
package AccuServerBase;

import java.util.List;
import java.util.Vector;

public class ByteVector
extends Vector {
    public ByteVector() {
    }

    public ByteVector(List list) {
        super(list);
    }

    @Override
    public String toString() {
        int len = this.size();
        byte[] bytes = new byte[len];
        Object[] objects = this.toArray();
        String result = "";
        for (int i = 0; i < len; ++i) {
            Byte thisByte = (Byte)objects[i];
            bytes[i] = thisByte;
        }
        result = new String(bytes);
        return result;
    }

    public byte[] toBytes() {
        int len = this.size();
        byte[] bytes = new byte[len];
        Object[] objects = this.toArray();
        for (int i = 0; i < len; ++i) {
            Byte thisByte = (Byte)objects[i];
            bytes[i] = thisByte;
        }
        return bytes;
    }

    public void replace(String target, String text) {
        int at;
        int textLen = text.length();
        int targetLen = target.length();
        byte[] targetBytes = target.getBytes();
        byte[] textBytes = text.getBytes();
        int len = this.size() - targetLen;
        boolean found = false;
        for (at = 0; !found && at < len; ++at) {
            Byte thisByte = (Byte)this.get(at);
            if (thisByte != targetBytes[0]) continue;
            boolean match = true;
            for (int i = 1; i < targetLen; ++i) {
                Byte listByte = (Byte)this.get(at + i);
                if (listByte == targetBytes[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            found = true;
        }
        if (found) {
            this.removeRange(--at, at + targetLen);
            for (int i = at; i < at + textLen; ++i) {
                this.add(i, new Byte(textBytes[i - at]));
            }
        }
    }

    public byte[] getElement(String name) {
        byte[] result = null;
        String startTag = "<" + name + ">";
        int start = this.find(startTag);
        if (start > -1) {
            String endTag = "</" + name + ">";
            int end = this.find(endTag);
            int nameLen = name.length();
            if ((end -= nameLen + 3) > (start += nameLen + 2)) {
                int len = end - start;
                result = new byte[len];
                for (int i = start; i < end; ++i) {
                    Byte listByte = (Byte)this.get(i);
                    result[i - start] = listByte;
                }
            }
        }
        return result;
    }

    public int find(String target) {
        int targetLen = target.length();
        byte[] targetBytes = target.getBytes();
        int len = this.size() - targetLen;
        boolean found = false;
        int at = 0;
        if (++len > 300) {
            at = len - 200;
        }
        while (!found && at < len) {
            Byte thisByte = (Byte)this.get(at);
            if (thisByte == targetBytes[0]) {
                boolean match = true;
                for (int i = 1; i < targetLen; ++i) {
                    Byte listByte = (Byte)this.get(at + i);
                    if (listByte == targetBytes[i]) continue;
                    match = false;
                    break;
                }
                if (match) {
                    found = true;
                }
            }
            ++at;
        }
        at = found ? --at : -1;
        return at;
    }

    public void appendString(String text) {
        int len = text.length();
        byte[] bytes = text.getBytes();
        for (int i = 0; i < len; ++i) {
            this.add(new Byte(bytes[i]));
            if (i % 100000 != 0) continue;
            System.out.println("completed " + i);
            Runtime.getRuntime().gc();
        }
    }

    public void appendBytes(byte[] bytes) {
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            this.add(bytes[i]);
        }
    }

    public void appendBytes(byte[] bytes, int count) {
        int len = bytes.length;
        if (len > count) {
            len = count;
        }
        for (int i = 0; i < len; ++i) {
            this.add(bytes[i]);
        }
    }

    public void appendBytes(byte[] bytes, int start, int count) {
        if (bytes == null) {
            return;
        }
        int len = start + count;
        if (len > bytes.length) {
            len = bytes.length;
        }
        for (int i = start; i < len; ++i) {
            this.add(bytes[i]);
        }
    }
}

