/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftDataAccess;

import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import AccuShiftBase.AccuShiftData;
import AccuShiftDataObjects.CompanyInfo;
import AccuShiftDataObjects.Employee;
import AccuShiftDataObjects.PayPeriodInfo;
import AccuShiftDataObjects.TimeDetail;
import POSDataObjects.POSDataContainer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class AccuShiftDataAccess
implements AccuShiftData,
ServerObject,
Runnable {
    private String path;
    ServerCore core = null;
    private String command = "";
    static int c;
    String dbDriver;
    String host = "localhost";
    String user = "";
    String password = "";
    String databaseName = "AccuPOS";
    Connection oneConnection = null;
    boolean isResetting = false;
    boolean blockConnection = false;

    @Override
    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public void run() {
        String employeeId;
        String employeeXml;
        String action = Utility.getElement("Action", this.command);
        if (action.compareToIgnoreCase("GetEmployeeInfo") == 0) {
            try {
                employeeXml = Utility.getElement("Employee", this.command);
                employeeId = Utility.getElement("EmployeeId", employeeXml);
                this.getEmployeeInfo(employeeId);
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        }
        if (action.compareToIgnoreCase("EmployeeClockIn") == 0) {
            try {
                employeeXml = Utility.getElement("Employee", this.command);
                employeeId = Utility.getElement("EmployeeId", employeeXml);
                String payLevelNumber = Utility.getElement("PayLevelNumber", employeeXml);
                this.setEmployeeClockIn(employeeId, Integer.parseInt(payLevelNumber), 0);
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        }
        if (action.compareToIgnoreCase("EmployeeClockOut") == 0) {
            try {
                employeeXml = Utility.getElement("Employee", this.command);
                employeeId = Utility.getElement("EmployeeId", employeeXml);
                this.setEmployeeClockOut(employeeId);
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        }
        this.command = "";
    }

    @Override
    public void shutDown() {
        if (this.oneConnection != null) {
            try {
                this.blockConnection = true;
                this.oneConnection.close();
                this.oneConnection = null;
            }
            catch (SQLException ex) {
                this.core.raiseException(ex);
            }
        }
    }

    public Connection getOneConnection() throws Exception {
        Connection thisConnection = null;
        if (this.dbDriver.equalsIgnoreCase("jadoZoom")) {
            Class.forName("com.inzoom.jdbcado.Driver");
            String url = "jdbc:izmado:Provider=MSDASQL;Driver={Microsoft Access Driver (*.mdb)};IzmRoyaltyFree=643120950;Dbq=" + this.path;
            thisConnection = DriverManager.getConnection(url);
        } else if (this.dbDriver.equalsIgnoreCase("sqlexpress")) {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            String url = "jdbc:sqlserver://" + this.host + ";databaseName=" + this.databaseName;
            thisConnection = DriverManager.getConnection(url, this.user, this.password);
        } else {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + this.path;
            thisConnection = DriverManager.getConnection(url);
        }
        return thisConnection;
    }

    public Connection getDatabaseConnection() throws Exception {
        if (this.blockConnection) {
            return null;
        }
        if (this.isResetting) {
            for (int trys = 10; this.isResetting && trys > 0; --trys) {
                Thread.sleep(500L);
            }
        }
        this.isResetting = false;
        int mainTrys = 3;
        do {
            if (this.oneConnection == null) {
                this.oneConnection = this.getOneConnection();
                continue;
            }
            if (this.databaseConnectionIsValid(this.oneConnection)) continue;
            this.isResetting = true;
            try {
                this.oneConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Thread.sleep(500L);
            this.oneConnection = null;
            this.oneConnection = this.getOneConnection();
            this.isResetting = false;
        } while (this.oneConnection == null && --mainTrys > 0);
        return this.oneConnection;
    }

    public boolean databaseConnectionIsValid(Connection connection) {
        boolean result = true;
        if (connection == null) {
            return false;
        }
        try {
            if (connection.isClosed()) {
                return false;
            }
            Statement thisStatement = connection.createStatement();
            thisStatement.close();
            result = true;
        }
        catch (SQLException ex) {
            result = false;
        }
        return result;
    }

    @Override
    public void initialize(ServerCore core, Hashtable parameters) {
        this.core = core;
        if (parameters != null && parameters.size() > 0) {
            String dbName;
            this.path = (String)parameters.get("path");
            core.input("AccuShift DB: " + this.path);
            this.dbDriver = (String)parameters.get("dbDriver");
            if (this.dbDriver == null || this.dbDriver.isEmpty()) {
                this.dbDriver = "Standard";
            }
            this.host = (String)parameters.get("Host");
            if (this.host == null || this.host.isEmpty()) {
                this.host = "localhost";
            }
            String userText = (String)parameters.get("User");
            String passwordText = (String)parameters.get("Password");
            if (userText != null && !userText.isEmpty()) {
                this.user = userText;
            }
            if (passwordText != null && !passwordText.isEmpty()) {
                this.password = passwordText;
            }
            if ((dbName = (String)parameters.get("DatabaseName")) != null && !dbName.isEmpty()) {
                this.databaseName = dbName;
            }
            core.setLocalDataHandler(this);
        }
    }

    public int getType() {
        return 4;
    }

    @Override
    public void output(String output) {
    }

    private ArrayList getAllPayLevelNames() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = this.getDatabaseConnection();
        if (conn == null) {
            return result;
        }
        String query = "Select * from control";
        stmt = conn.createStatement();
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            result.add(rs.getString("payLevel1"));
            result.add(rs.getString("payLevel2"));
            result.add(rs.getString("payLevel3"));
            result.add(rs.getString("payLevel4"));
            result.add(rs.getString("payLevel5"));
            result.add(rs.getString("payLevel6"));
            result.add(rs.getString("payLevel7"));
            result.add(rs.getString("payLevel8"));
            result.add(rs.getString("payLevel9"));
            result.add(rs.getString("payLevel10"));
            result.add(rs.getString("payLevel11"));
            result.add(rs.getString("payLevel12"));
            result.add(rs.getString("payLevel13"));
            result.add(rs.getString("payLevel14"));
            result.add(rs.getString("payLevel15"));
            result.add(rs.getString("payLevel16"));
            result.add(rs.getString("payLevel17"));
            result.add(rs.getString("payLevel18"));
            result.add(rs.getString("payLevel19"));
            result.add(rs.getString("payLevel20"));
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return result;
    }

    @Override
    public Employee getEmployeeInfo(String employeeId, boolean useAccountingId) throws Exception {
        return this.getEmployeeInfo(employeeId);
    }

    @Override
    public Employee getEmployeeInfo(String employeeId) throws Exception {
        String accountingId = "";
        Employee result = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection conn = this.getDatabaseConnection();
        if (conn == null) {
            return result;
        }
        ArrayList payLevelNames = new ArrayList();
        payLevelNames = this.getAllPayLevelNames();
        stmt = conn.prepareStatement("Select * from Employees where Id = ?");
        stmt.setString(1, employeeId);
        rs = stmt.executeQuery();
        if (rs.next()) {
            accountingId = rs.getString("accountingId");
            String nameText = rs.getString("name");
            boolean payLevelFlag = false;
            String payLevel1 = "";
            String payLevel2 = "";
            String payLevel3 = "";
            String payLevel4 = "";
            String payLevel5 = "";
            String payLevel6 = "";
            String payLevel7 = "";
            String payLevel8 = "";
            String payLevel9 = "";
            String payLevel10 = "";
            String payLevel11 = "";
            String payLevel12 = "";
            String payLevel13 = "";
            String payLevel14 = "";
            String payLevel15 = "";
            String payLevel16 = "";
            String payLevel17 = "";
            String payLevel18 = "";
            String payLevel19 = "";
            String payLevel20 = "";
            payLevelFlag = rs.getBoolean("PayLevel1");
            if (payLevelFlag) {
                payLevel1 = (String)payLevelNames.get(0);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel2")) {
                payLevel2 = (String)payLevelNames.get(1);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel3")) {
                payLevel3 = (String)payLevelNames.get(2);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel4")) {
                payLevel4 = (String)payLevelNames.get(3);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel5")) {
                payLevel5 = (String)payLevelNames.get(4);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel6")) {
                payLevel6 = (String)payLevelNames.get(5);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel7")) {
                payLevel7 = (String)payLevelNames.get(6);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel8")) {
                payLevel8 = (String)payLevelNames.get(7);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel9")) {
                payLevel9 = (String)payLevelNames.get(8);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel10")) {
                payLevel10 = (String)payLevelNames.get(9);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel11")) {
                payLevel11 = (String)payLevelNames.get(10);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel12")) {
                payLevel12 = (String)payLevelNames.get(11);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel13")) {
                payLevel13 = (String)payLevelNames.get(12);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel14")) {
                payLevel14 = (String)payLevelNames.get(13);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel15")) {
                payLevel15 = (String)payLevelNames.get(14);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel16")) {
                payLevel16 = (String)payLevelNames.get(15);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel17")) {
                payLevel17 = (String)payLevelNames.get(16);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel18")) {
                payLevel18 = (String)payLevelNames.get(17);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel19")) {
                payLevel19 = (String)payLevelNames.get(18);
            }
            if (payLevelFlag = rs.getBoolean("PayLevel20")) {
                payLevel20 = (String)payLevelNames.get(19);
            }
            boolean manager = rs.getBoolean("Manager");
            Employee employee = new Employee(accountingId, nameText, payLevel1, payLevel2, payLevel3, payLevel4, payLevel5, payLevel6, payLevel7, payLevel8, payLevel9, payLevel10, payLevel11, payLevel12, payLevel13, payLevel14, payLevel15, payLevel16, payLevel17, payLevel18, payLevel19, payLevel20, manager, false);
            employee.currentHours = this.getEmployeePayPeriodTime(employeeId);
            result = employee;
        }
        stmt = conn.prepareStatement("Select * from times where employeeid = ? AND out Is Null");
        stmt.setString(1, accountingId);
        rs = stmt.executeQuery();
        if (rs.next()) {
            result.isClockedIn = true;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return result;
    }

    @Override
    public boolean setEmployeeClockIn(String employeeId, int payLevelNumber, int breakId) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        GregorianCalendar nowCalendar = new GregorianCalendar();
        nowCalendar.set(13, 0);
        Timestamp now = new Timestamp(nowCalendar.getTime().getTime());
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return false;
        }
        stmt = conn.prepareStatement("INSERT into times (\"EmployeeId\",\"PayLevel\",\"In\") Values (?,?,?)");
        stmt.setString(1, employeeId);
        stmt.setInt(2, payLevelNumber);
        stmt.setTimestamp(3, now);
        stmt.executeUpdate();
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return true;
    }

    @Override
    public boolean setEmployeeClockOut(String employeeId) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        GregorianCalendar nowCalendar = new GregorianCalendar();
        nowCalendar.set(13, 0);
        Timestamp now = new Timestamp(nowCalendar.getTime().getTime());
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return false;
        }
        stmt = conn.prepareStatement("Select * from times where not canceled and employeeId = ? order by [in] DESC ");
        stmt.setString(1, employeeId);
        rs = stmt.executeQuery();
        while (rs.next()) {
            Timestamp outTime = rs.getTimestamp("out");
            if (outTime != null && outTime.getTime() >= 100000L) continue;
            Timestamp inTime = rs.getTimestamp("in");
            long elapsed = now.getTime() - inTime.getTime();
            if (elapsed >= 54000000L) continue;
            int id = rs.getInt("id");
            stmt = conn.prepareStatement("UPDATE times set out = ?, total = ? where id = ?");
            stmt.setTimestamp(1, now);
            stmt.setInt(2, (int)elapsed);
            stmt.setInt(3, id);
            stmt.executeUpdate();
            break;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return true;
    }

    @Override
    public Timestamp getClockInTime(String employeeId, int payLevel) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return null;
        }
        stmt = conn.prepareStatement("Select * from times where employeeId = ? AND payLevel = ? AND out Is Null");
        stmt.setString(1, employeeId);
        stmt.setInt(2, payLevel);
        rs = stmt.executeQuery();
        Timestamp clockIn = null;
        if (rs.next()) {
            clockIn = rs.getTimestamp("in");
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return clockIn;
    }

    @Override
    public boolean isClockedIntoBreak(String employeeId) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return false;
        }
        boolean isClockedIntoBreak = false;
        stmt = conn.prepareStatement("Select * from times where employeeId = ? AND [out] Is Null AND [in] Is Not Null Order By [in] DESC");
        stmt.setString(1, employeeId);
        rs = stmt.executeQuery();
        Object clockIn = null;
        if (rs.next()) {
            isClockedIntoBreak = true;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return isClockedIntoBreak;
    }

    @Override
    public int getClockInPayLevel(String employeeId) throws Exception {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return 0;
        }
        stmt = conn.prepareStatement("Select * from times where employeeId = ? AND out Is Null");
        stmt.setString(1, employeeId);
        rs = stmt.executeQuery();
        int payLevel = 0;
        if (rs.next()) {
            payLevel = rs.getInt("payLevel");
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return payLevel;
    }

    @Override
    public long getEmployeePayPeriodTime(String employeeId) throws Exception {
        Connection conn = null;
        PreparedStatement controlStmt = null;
        PreparedStatement timesStmt = null;
        ResultSet rs = null;
        Timestamp payPeriodEnd = null;
        int periodDays = 0;
        conn = this.getDatabaseConnection();
        if (conn == null) {
            return 0L;
        }
        controlStmt = conn.prepareStatement("Select * from control");
        rs = controlStmt.executeQuery();
        if (rs.next()) {
            payPeriodEnd = rs.getTimestamp("periodEnd");
            periodDays = rs.getInt("periodDuration");
        }
        long periodMilliSec = (long)periodDays * 24L * 60L * 60L * 1000L;
        Timestamp payPeriodStart = new Timestamp(payPeriodEnd.getTime() - periodMilliSec);
        timesStmt = conn.prepareStatement("Select * from times WHERE employeeId = ? AND (out >= ? AND out <= ?)");
        timesStmt.setString(1, employeeId);
        timesStmt.setTimestamp(2, payPeriodStart);
        timesStmt.setTimestamp(3, payPeriodEnd);
        rs = timesStmt.executeQuery();
        long payPeriodTime = 0L;
        while (rs.next()) {
            boolean canceled = rs.getBoolean("canceled");
            if (canceled) continue;
            payPeriodTime += rs.getLong("total");
        }
        if (rs != null) {
            rs.close();
        }
        if (controlStmt != null) {
            controlStmt.close();
        }
        if (timesStmt != null) {
            timesStmt.close();
        }
        return payPeriodTime;
    }

    @Override
    public void removeEmployee(String employeeId) throws Exception {
    }

    @Override
    public POSDataContainer getTimesExports() throws Exception {
        return null;
    }

    @Override
    public ArrayList getEmployees() throws Exception {
        return null;
    }

    @Override
    public CompanyInfo getCompanyInformation() throws Exception {
        return null;
    }

    @Override
    public void saveCompanyInformation(CompanyInfo companyInfo) throws Exception {
    }

    @Override
    public String getSiteName() throws Exception {
        return null;
    }

    @Override
    public void advancePeriodEnd() throws Exception {
    }

    @Override
    public String[] getPaytypes() throws Exception {
        return null;
    }

    @Override
    public void savePayTypes(String[] payTypes) throws Exception {
    }

    @Override
    public PayPeriodInfo getPayPeriodInfo() throws Exception {
        return null;
    }

    @Override
    public void savePayPeriod(PayPeriodInfo payPeriodInfo) throws Exception {
    }

    @Override
    public void removeEmployeeData() throws Exception {
    }

    @Override
    public void removeTimesData() throws Exception {
    }

    @Override
    public void updateEmployee(Employee employee) throws Exception {
    }

    @Override
    public void updateEmployees(ArrayList employeesList, boolean updatePaytypes) throws Exception {
    }

    @Override
    public String getPassword() throws Exception {
        return null;
    }

    @Override
    public void updatePassword(String password) throws Exception {
    }

    @Override
    public void getEmployeePeriodDetail(Employee employee) throws Exception {
    }

    @Override
    public Employee getEmployeePeriodDetailFromTimeRange(Employee employee, Timestamp startDate, Timestamp endDate) throws Exception {
        return null;
    }

    @Override
    public void updatePayTypeNames(String payTypeNamesXml) throws Exception {
    }

    @Override
    public ArrayList getEmployeesWithOpenDetail() throws Exception {
        return this.getEmployeesWithOpenDetail(true);
    }

    @Override
    public ArrayList getEmployeesWithOpenDetail(boolean includeBreaks) throws Exception {
        return null;
    }

    @Override
    public ArrayList getEmployeesWithOpenDetailFromTimeRange(Timestamp startDate, Timestamp endDate) throws Exception {
        return null;
    }

    @Override
    public void updateEmployeeTime(String accountingId, TimeDetail detail) throws Exception {
    }

    @Override
    public ArrayList getTimesSent() throws Exception {
        return null;
    }

    @Override
    public ArrayList getEmployeeTimesSent(ArrayList timesSent) throws Exception {
        return null;
    }

    @Override
    public ArrayList getEmployeesTimeFromDateRange(Timestamp startDate, Timestamp endDate) throws Exception {
        return null;
    }

    @Override
    public void getCurrentPeriodCompletedDetail(Employee employee) throws Exception {
    }

    @Override
    public ArrayList getBreaks() throws Exception {
        return null;
    }

    @Override
    public void removeBreak(int id) throws Exception {
    }

    @Override
    public void updateBreaks(ArrayList breaksList) throws Exception {
    }

    @Override
    public void deleteEmployeeTime(long timeId) throws Exception {
    }

    @Override
    public void getEmployeeTimesSent(Employee employee) throws Exception {
    }

    @Override
    public boolean updateHolidays(POSDataContainer holidays) throws Exception {
        return false;
    }

    @Override
    public POSDataContainer getHolidays(Timestamp startDate, Timestamp endDate) throws Exception {
        return null;
    }

    @Override
    public boolean deleteHolidaysByIds(int[] ids) throws Exception {
        return false;
    }

    @Override
    public String getTCControlXml() throws Exception {
        return "";
    }
}

