/*
 * Decompiled with CFR 0.152.
 */
package DataHandlers;

import AccuServerBase.OnlineOrdersHandlerBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import POSDataObjects.Customer;
import POSDataObjects.Item;
import POSDataObjects.ItemChoice;
import POSDataObjects.LineItem;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.Tax;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Till;
import POSDataObjects.User;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BiteDataHandler
implements ServerObject,
OnlineOrdersHandlerBase {
    ServerCore core = null;
    String baseURL = "https://api.bite-tech.co.il/AccuposCashregister/";
    int timeOut = 10000;
    String till = "Bite";
    String posUser = "Bite";
    boolean debug = false;
    int retryMinutes = 5;
    Timer ordersDownloadTimer = null;
    String posId;
    String restId;
    boolean isFullDayFetch = true;
    Calendar lastTimeChecked = null;
    final SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    List acceptedPayCodes;

    public void initialize(ServerCore core, Hashtable parameters) {
        String retryMinutesText;
        String testText;
        String debugText;
        this.core = core;
        String timeOutText = (String)parameters.get("TimeOut");
        if (timeOutText != null && !timeOutText.isEmpty()) {
            try {
                this.timeOut = Integer.parseInt(timeOutText);
            }
            catch (NumberFormatException numberFormatException) {
                this.timeOut = 10000;
            }
        }
        if ((debugText = (String)parameters.get("Debug")) != null && !debugText.isEmpty()) {
            try {
                this.debug = Boolean.parseBoolean(debugText);
            }
            catch (Exception e) {
                this.debug = false;
            }
        }
        if ((testText = (String)parameters.get("Url")) != null && !testText.isEmpty()) {
            this.baseURL = testText;
        }
        if ((retryMinutesText = (String)parameters.get("RetryMinutes")) != null && !retryMinutesText.isEmpty()) {
            try {
                this.retryMinutes = Integer.parseInt(retryMinutesText);
            }
            catch (Exception e) {
                this.retryMinutes = 5;
            }
        }
        core.input(core.getLiteral("Bite Data Handler Retry set to ") + this.retryMinutes + " " + core.getLiteral("minutes"));
        this.restId = (String)parameters.get("RestId");
        if (this.restId == null || this.restId.isEmpty()) {
            core.input("RestId not found.\nClosing Bite Data Handler!");
            return;
        }
        this.posId = (String)parameters.get("PosId");
        if (this.posId == null || this.posId.isEmpty()) {
            core.input("PosId not found.\nClosing Bite Data Handler!");
            return;
        }
        this.verifyHandlerData();
        this.acceptedPayCodes = new ArrayList();
        POSDataContainer tenderCodes = core.getTenderCodesList();
        int len = tenderCodes.size();
        for (int i = 0; i < len; ++i) {
            TenderCode tenderCode = (TenderCode)tenderCodes.get(i);
            this.acceptedPayCodes.add(tenderCode.code);
        }
        this.ordersDownloadTimer = new Timer();
        this.retryMinutes = this.retryMinutes * 60 * 1000;
        this.ordersDownloadTimer.schedule((TimerTask)new OrdersDownloadTimer(), 10000L, (long)this.retryMinutes);
        core.setBiteDataHandler((OnlineOrdersHandlerBase)this);
        core.input(core.getLiteral("Bite Data Handler Successfully Started"));
    }

    private void verifyHandlerData() {
        Item item;
        Till till;
        while (this.core.isBlockLogin()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.core.getUser(this.posUser) == null) {
            Random random = new Random();
            int password = random.nextInt(100000000) + 10000000;
            User user = new User(this.posUser, password + "", "ADMIN", 0L, this.till);
            POSDataContainer users = this.core.getUserList();
            users.add((Object)user);
            this.core.updateUsers(users);
        }
        if (this.core.getTenderCode("BI") == null) {
            TenderCode tc = new TenderCode("BI", this.posUser, "H", "", this.posUser, false, 0.0, "", "", "", "");
            this.core.updateTenderCode(tc);
        }
        if ((till = this.core.getTillByName(this.till)) == null || !till.name.equals(this.till)) {
            till = new Till();
            till.active = true;
            till.name = this.till;
            this.core.updateTill(till);
        }
        POSDataContainer itemsList = new POSDataContainer();
        if (this.core.getItemByCode("UndefinedChoice") == null) {
            item = new Item();
            item.code = "UndefinedChoice";
            item.description = "Undefined Choice";
            item.type = "";
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (this.core.getItemByCode("Undefined") == null) {
            item = new Item();
            item.code = "Undefined";
            item.description = "Undefined";
            item.type = "";
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (this.core.getItemByCode("Delivery") == null) {
            item = new Item();
            item.code = "Delivery";
            item.description = "Delivery";
            item.type = "";
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (itemsList.size() > 0) {
            this.core.saveAllItems(itemsList, true);
        }
    }

    private JSONObject sendHttpGet(String action, String params, int timeout) throws IOException, NoSuchAlgorithmException, KeyManagementException, JSONException {
        JSONObject jSONObject;
        String baseParams = "?restId=" + this.restId + "&posId=" + this.posId;
        String url = this.baseURL + action + baseParams;
        if (params != null && !params.isEmpty()) {
            url = url + "&" + params;
        }
        if (this.debug) {
            System.out.println("URL: " + url);
        }
        OutputStream ostream = null;
        BufferedReader istream = null;
        ByteArrayOutputStream baos = null;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, null, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            URL theUrl = new URL(url);
            System.out.println("Attempting to connect ");
            HttpsURLConnection conn = (HttpsURLConnection)theUrl.openConnection();
            System.out.println("Connected ");
            conn.setReadTimeout(timeout);
            conn.setConnectTimeout(timeout);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("accept", "application/json");
            istream = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuilder replyText = new StringBuilder();
            do {
                String reply = istream.readLine();
                replyText.append(reply);
            } while (istream.ready());
            String sResult = replyText.toString();
            if (this.debug) {
                System.out.println("Receive from host:\r\n" + sResult);
            }
            if (action.equalsIgnoreCase("setOrderStatus")) {
                JSONObject jSONObject2 = null;
                return jSONObject2;
            }
            jSONObject = new JSONObject(sResult);
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (Exception exception) {}
        }
        return jSONObject;
    }

    public boolean setOrderStatus(int i, String string) {
        return true;
    }

    public void orderNotice(String string) {
    }

    public void output(String output) {
        System.out.println(output);
        if (this.debug) {
            this.core.input(output);
        }
    }

    public String fixQuotes(String requestString) {
        String editedString = requestString.replaceAll("\"", "\\\\\"");
        return editedString;
    }

    public void getOpenOrders() {
        block56: {
            JSONArray purchasesList = new JSONArray();
            JSONObject response = new JSONObject();
            try {
                response = this.sendHttpGet("getOpenOrders", null, this.timeOut);
                if (response.has("purchases")) {
                    purchasesList = response.getJSONArray("purchases");
                }
                this.output("Bite Get Open Orders Response Data: " + response);
            }
            catch (Exception e) {
                this.core.input("Error Requesting Bite Open Orders");
                this.core.input("Exception:" + e.toString() + " " + response);
                return;
            }
            try {
                if (purchasesList == null || purchasesList.length() <= 0) break block56;
                int numPurchases = purchasesList.length();
                this.core.input("Proccecing " + numPurchases + " Bite Orders...");
                for (int p = 0; p < numPurchases; ++p) {
                    JSONObject thisPurchase = purchasesList.getJSONObject(p);
                    String createdString = thisPurchase.getString("created_at");
                    JSONObject delivery = thisPurchase.getJSONObject("delivery");
                    String deliveryType = delivery.getString("type");
                    String orderId = thisPurchase.getString("order_number");
                    if (this.orderExists(orderId)) {
                        this.sendHttpGet("setOrderStatus", "orderId=" + orderId + "&status=accepted", this.timeOut);
                        this.output("Remote Order: " + orderId + " - has already been imported\r\n");
                        continue;
                    }
                    JSONArray items = thisPurchase.getJSONArray("items");
                    String comment = "";
                    if (thisPurchase.has("consumer_comment")) {
                        comment = thisPurchase.getString("consumer_comment");
                        comment = comment.replace("\n", " ");
                    }
                    long modified = 0L;
                    if (thisPurchase.has("modified")) {
                        modified = thisPurchase.getLong("modified");
                    }
                    JSONObject deliveryAddressJSON = thisPurchase.getJSONObject("delivery_address");
                    if (this.debug) {
                        this.output("Processing Remote Order: " + orderId + "\r\n");
                    }
                    int nextLineNumber = 1;
                    Order newOrder = new Order();
                    newOrder.orderId = orderId;
                    long created = System.currentTimeMillis();
                    newOrder.created = new Timestamp(created);
                    newOrder.nextLineNumber = nextLineNumber;
                    if (deliveryType.equals("homedelivery")) {
                        newOrder.delivery = true;
                        newOrder.carryOut = false;
                    } else if (deliveryType.equals("takeaway")) {
                        newOrder.delivery = false;
                        newOrder.carryOut = true;
                    } else if (deliveryType.equals("eatin")) {
                        newOrder.delivery = false;
                        newOrder.carryOut = false;
                    }
                    newOrder.displayOnRemote = true;
                    Customer remoteOrderCustomer = new Customer();
                    String firstName = thisPurchase.getString("consumer_name");
                    String phone = thisPurchase.optString("customer_phone");
                    String city = deliveryAddressJSON.optString("city");
                    String street = deliveryAddressJSON.optString("street");
                    String apartement = deliveryAddressJSON.optString("apartement");
                    String floor = deliveryAddressJSON.optString("floor");
                    String entrance = deliveryAddressJSON.optString("entrance");
                    remoteOrderCustomer.code = !remoteOrderCustomer.phone.isEmpty() ? phone : firstName;
                    remoteOrderCustomer.first = firstName;
                    if (deliveryType.equals("eatin")) {
                        remoteOrderCustomer.first = remoteOrderCustomer.first + " " + comment.replace("|", "").trim();
                    }
                    remoteOrderCustomer.phone = phone;
                    remoteOrderCustomer.city = city;
                    remoteOrderCustomer.address1 = street;
                    remoteOrderCustomer.address2 = this.core.getLiteral("Apt") + " " + apartement;
                    if (!floor.isEmpty()) {
                        remoteOrderCustomer.address2 = remoteOrderCustomer.address2 + " - " + this.core.getLiteral("Floor") + " " + floor;
                    }
                    if (!entrance.isEmpty()) {
                        remoteOrderCustomer.address2 = remoteOrderCustomer.address2 + " - " + this.core.getLiteral("Entrance") + " " + entrance;
                    }
                    remoteOrderCustomer.deliveryNotes = comment;
                    boolean saved = false;
                    if (remoteOrderCustomer.code != null && !remoteOrderCustomer.code.isEmpty()) {
                        saved = this.core.updateCustomer(remoteOrderCustomer);
                    }
                    if (saved) {
                        newOrder.customer = remoteOrderCustomer;
                    }
                    Vector<Object> newLineItems = new Vector<Object>();
                    int numLines = 0;
                    if (items != null && items.length() > 0) {
                        numLines = items.length();
                        for (int i = 0; i < numLines; ++i) {
                            ItemChoice newItemChoice;
                            String taxCode;
                            Item thisItem;
                            JSONObject thisLine = items.getJSONObject(i);
                            String itemId = "";
                            try {
                                itemId = thisLine.optString("pos_id");
                            }
                            catch (Exception ex) {
                                this.output(this.core.getLiteral("Error Importing Bite Open Order - #") + orderId + " " + this.core.getLiteral("Item Id not received - Setting to Undefined"));
                                itemId = "Undefined";
                            }
                            String description = thisLine.getString("name");
                            JSONObject basePrice = thisLine.getJSONObject("base_price");
                            double price = basePrice.getInt("amount");
                            price /= 100.0;
                            double itemQty = thisLine.getDouble("count");
                            String itemForName = "";
                            String itemKitchenNotes = "";
                            if (thisLine.has("comment")) {
                                String linecomment = thisLine.getString("comment");
                                String[] temp = new String[2];
                                temp = linecomment.split("\r\n");
                                if (temp != null) {
                                    if (temp.length == 2) {
                                        itemKitchenNotes = temp[0];
                                        itemForName = temp[1];
                                    } else {
                                        itemForName = temp[0];
                                    }
                                }
                            }
                            if ((thisItem = this.core.getItemByCode(itemId)) == null) {
                                this.output(this.core.getLiteral("Error Importing Bite Open Order - #") + " " + this.core.getLiteral("Item Id") + " " + itemId + " " + this.core.getLiteral("not found - Setting to Undefined"));
                                thisItem = this.core.getItemByCode("Undefined");
                                if (thisItem == null) {
                                    this.output("Error Importing Bite Open Order - #" + orderId + " Item: " + itemId + " not found");
                                    continue;
                                }
                                itemId = "Undefined";
                            }
                            if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                                taxCode = thisItem.vatCode;
                            }
                            double priceWithVatRemoved = this.core.getPriceWithVatRemoved(price, taxCode);
                            LineItem newLineItem = new LineItem();
                            newLineItem.itemId = itemId;
                            newLineItem.itemDescription = description;
                            newLineItem.price = price;
                            newLineItem.quantity = itemQty;
                            newLineItem.displayOnRemote = true;
                            newLineItem.altDescription = thisItem.alternateDescription;
                            newLineItem.list = thisItem.list;
                            newLineItem.originalPrice = thisItem.price;
                            if (newLineItem.tax == null) {
                                newLineItem.tax = new Tax();
                            }
                            newLineItem.tax.taxable = thisItem.taxable;
                            newLineItem.taxable = thisItem.taxable;
                            newLineItem.isAppetizer = thisItem.isAppetizer;
                            newLineItem.itemType = thisItem.type;
                            newLineItem.noPartialQuantity = thisItem.noPartialQuantity;
                            newLineItem.carryOut = !newOrder.delivery;
                            newLineItem.userId = this.posUser;
                            newLineItem.total = newLineItem.quantity * priceWithVatRemoved;
                            newLineItem.vatGross = newLineItem.quantity * price;
                            newLineItem.vatTax1 = (double)Math.round((newLineItem.vatGross - priceWithVatRemoved * Math.abs(newLineItem.quantity)) * 1000.0) / 1000.0;
                            newLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                            ++newOrder.nextLineNumber;
                            newLineItem.changedPrice = "Bite";
                            JSONArray choices = thisLine.getJSONArray("options");
                            Vector<ItemChoice> newChoices = new Vector<ItemChoice>();
                            if (itemForName != null && !itemForName.isEmpty()) {
                                newItemChoice = new ItemChoice();
                                newItemChoice.text = itemForName;
                                newChoices.add(newItemChoice);
                            }
                            if (itemKitchenNotes != null && !itemKitchenNotes.isEmpty()) {
                                newItemChoice = new ItemChoice();
                                newItemChoice.text = itemKitchenNotes;
                                newChoices.add(newItemChoice);
                            }
                            Vector<LineItem> newOptionalItems = new Vector<LineItem>();
                            if (choices != null && choices.length() > 0) {
                                int numChoices = choices.length();
                                for (int c = 0; c < numChoices; ++c) {
                                    ItemChoice newItemChoice2;
                                    JSONObject thisChoice = choices.getJSONObject(c);
                                    String thisChoiceDescription = thisChoice.optString("name");
                                    double thisChoiceQty = thisChoice.getDouble("count");
                                    if (thisChoice.isNull("name") && thisChoiceQty == 0.0) continue;
                                    String thisChoiceId = "";
                                    try {
                                        thisChoiceId = thisChoice.optString("value_pos_id");
                                    }
                                    catch (Exception ex) {
                                        this.output(this.core.getLiteral("Error Importing Bite Open Order - #") + orderId + " " + this.core.getLiteral("Choice Item Id not received - Setting to UndefinedChoice"));
                                        thisChoiceId = "UndefinedChoice";
                                    }
                                    JSONObject choicePrice = thisChoice.getJSONObject("price");
                                    double thisChoicePrice = choicePrice.optDouble("amount");
                                    if ((thisChoicePrice /= 100.0) == 0.0) {
                                        newItemChoice2 = new ItemChoice();
                                        newItemChoice2.itemCode = thisChoiceId;
                                        newItemChoice2.display = thisChoiceDescription;
                                        newItemChoice2.text = thisChoiceDescription;
                                        newItemChoice2.cr = true;
                                        newChoices.add(newItemChoice2);
                                        continue;
                                    }
                                    newItemChoice2 = new ItemChoice();
                                    newItemChoice2.itemCode = "";
                                    newItemChoice2.display = thisChoiceDescription;
                                    newItemChoice2.text = thisChoiceDescription;
                                    newItemChoice2.cr = true;
                                    newChoices.add(newItemChoice2);
                                    LineItem newOptionalItem = new LineItem();
                                    Item thisOptionalItem = this.core.getItemByCode(thisChoiceId);
                                    if (thisOptionalItem == null) {
                                        this.output(this.core.getLiteral("Error Importing Bite Open Order - #") + " " + this.core.getLiteral("Choice Item Id") + " " + thisChoiceId + " " + this.core.getLiteral("not found - Setting to UndefinedChoice"));
                                        thisOptionalItem = this.core.getItemByCode("UndefinedChoice");
                                        if (thisOptionalItem == null) {
                                            this.output("Error Importing Bite Open Order - #" + orderId + " Optional Item: " + thisChoiceId + " not found");
                                            continue;
                                        }
                                        thisChoiceId = "UndefinedChoice";
                                    }
                                    if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                                        taxCode = thisItem.vatCode;
                                    }
                                    double optionalItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(thisChoicePrice, taxCode);
                                    newOptionalItem.itemId = thisChoiceId;
                                    newOptionalItem.itemDescription = thisChoiceDescription;
                                    newOptionalItem.price = thisChoicePrice;
                                    newOptionalItem.quantity = thisChoiceQty * itemQty;
                                    newOptionalItem.displayOnRemote = true;
                                    newOptionalItem.altDescription = thisOptionalItem.alternateDescription;
                                    newOptionalItem.list = thisOptionalItem.list;
                                    newOptionalItem.originalPrice = thisOptionalItem.price;
                                    if (newOptionalItem.tax == null) {
                                        newOptionalItem.tax = new Tax();
                                    }
                                    newOptionalItem.tax.taxable = thisOptionalItem.taxable;
                                    newOptionalItem.taxable = thisOptionalItem.taxable;
                                    newOptionalItem.isAppetizer = thisOptionalItem.isAppetizer;
                                    newOptionalItem.itemType = thisOptionalItem.type;
                                    newOptionalItem.noPartialQuantity = thisOptionalItem.noPartialQuantity;
                                    newOptionalItem.carryOut = !newOrder.delivery;
                                    newOptionalItem.userId = this.posUser;
                                    newOptionalItem.total = newOptionalItem.quantity * optionalItemPriceWithVatRemoved;
                                    newOptionalItem.vatGross = newOptionalItem.quantity * thisChoicePrice;
                                    newOptionalItem.vatTax1 = (double)Math.round((newOptionalItem.vatGross - optionalItemPriceWithVatRemoved * Math.abs(newOptionalItem.quantity)) * 1000.0) / 1000.0;
                                    newOptionalItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                                    ++newOrder.nextLineNumber;
                                    newOptionalItem.changedPrice = "Bite";
                                    newOptionalItems.add(newOptionalItem);
                                }
                            }
                            newLineItem.choices = newChoices;
                            newLineItems.add(newLineItem);
                            if (newOptionalItems == null || newOptionalItems.isEmpty()) continue;
                            newLineItems.addAll(newOptionalItems);
                        }
                    }
                    boolean numCharges = false;
                    if (!delivery.isNull("fee")) {
                        JSONObject deliveryFee = delivery.getJSONObject("fee");
                        double chargeAmount = deliveryFee.getDouble("amount");
                        double chargeQty = 0.0;
                        String chargeItemId = "";
                        chargeItemId = "Delivery";
                        chargeAmount /= 100.0;
                        chargeQty = 1.0;
                        Item thisChargeItem = this.core.getItemByCode(chargeItemId);
                        if (thisChargeItem == null && (thisChargeItem = this.core.getItemByCode("Undefined")) == null) {
                            this.output("Error Importing Bite Open Order - #" + orderId + " Item: " + chargeItemId + " not found");
                            continue;
                        }
                        LineItem newChargeLineItem = new LineItem();
                        newChargeLineItem.itemId = chargeItemId;
                        String taxCode = this.core.getCarryOutTaxCode();
                        if (taxCode == null || taxCode.isEmpty()) {
                            taxCode = thisChargeItem.vatCode;
                        }
                        double chargeItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(chargeAmount, taxCode);
                        newChargeLineItem.itemDescription = thisChargeItem.description;
                        newChargeLineItem.price = chargeAmount;
                        newChargeLineItem.quantity = chargeQty;
                        newChargeLineItem.noDiscount = true;
                        newChargeLineItem.displayOnRemote = true;
                        newChargeLineItem.altDescription = thisChargeItem.alternateDescription;
                        newChargeLineItem.list = thisChargeItem.list;
                        newChargeLineItem.originalPrice = thisChargeItem.price;
                        if (newChargeLineItem.tax == null) {
                            newChargeLineItem.tax = new Tax();
                        }
                        newChargeLineItem.tax.taxable = thisChargeItem.taxable;
                        newChargeLineItem.taxable = thisChargeItem.taxable;
                        newChargeLineItem.isAppetizer = thisChargeItem.isAppetizer;
                        newChargeLineItem.itemType = thisChargeItem.type;
                        newChargeLineItem.noPartialQuantity = thisChargeItem.noPartialQuantity;
                        newChargeLineItem.carryOut = !newOrder.delivery;
                        newChargeLineItem.userId = this.posUser;
                        newChargeLineItem.total = newChargeLineItem.quantity * chargeItemPriceWithVatRemoved;
                        newChargeLineItem.vatGross = newChargeLineItem.quantity * chargeAmount;
                        newChargeLineItem.vatTax1 = (double)Math.round((newChargeLineItem.vatGross - chargeItemPriceWithVatRemoved * Math.abs(newChargeLineItem.quantity)) * 1000.0) / 1000.0;
                        newChargeLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                        newChargeLineItem.changedPrice = "Bite";
                        newLineItems.add(newChargeLineItem);
                    }
                    newOrder.lineItems = newLineItems;
                    newOrder.user = this.posUser;
                    if (this.debug) {
                        String lineItemIds = "itemIds:";
                        for (int i = 0; i < newLineItems.size(); ++i) {
                            LineItem li = (LineItem)newLineItems.get(i);
                            lineItemIds = lineItemIds + " " + li.itemId;
                        }
                        this.output(lineItemIds);
                    }
                    String savedOrderXml = this.core.saveEMVOrder(newOrder.user, this.till, newOrder.toXml());
                    newOrder = new Order(savedOrderXml, true);
                    String resultXml = "";
                    JSONArray payments = null;
                    if (thisPurchase.has("payments")) {
                        payments = thisPurchase.getJSONArray("payments");
                    } else {
                        payments = new JSONArray();
                        payments.put((Object)thisPurchase.getJSONObject("price"));
                    }
                    int len = payments.length();
                    for (int i = 0; i < len; ++i) {
                        JSONObject thisPayment = payments.getJSONObject(i);
                        double amount = thisPayment.optDouble("amount");
                        String payCode = thisPayment.getString("pay_code");
                        Tender newTender = new Tender();
                        newTender.amount = amount /= 100.0;
                        if (!this.acceptedPayCodes.contains(payCode)) {
                            payCode = "VI";
                        }
                        if (!payCode.equals("CS")) {
                            TenderCode tenderCode = this.core.getTenderCode(payCode);
                            if (tenderCode == null) {
                                this.core.input("Bite: error - tender code " + payCode + " not found!");
                            } else {
                                newTender.description = tenderCode.description;
                            }
                            newTender.approval = "";
                            newTender.newTender = true;
                            newTender.code = payCode;
                            newTender.user = this.posUser;
                            resultXml = this.core.processOtherTender(this.posUser, this.till, newOrder.toXml(), newTender.code, amount, "", created, "");
                            String orderXml = Utility.getElement((String)"Order", (String)resultXml);
                            if (orderXml == null || orderXml.isEmpty()) continue;
                            Order currentOrder = new Order(orderXml, true);
                            currentOrder.status = "Accepted";
                            this.tenderAdded(currentOrder, orderId);
                            continue;
                        }
                        this.core.saveOrder(newOrder.toXml(), this.posUser, this.till);
                    }
                    this.sendHttpGet("setOrderStatus", "orderId=" + orderId + "&status=accepted", this.timeOut);
                    Thread.sleep(2000L);
                }
            }
            catch (Exception e) {
                this.output(e.toString());
                this.core.logText(this.till);
                this.core.raiseException(e);
            }
        }
        this.output("Bite Get Open Orders Completed");
    }

    public void tenderAdded(Order currentOrder, String orderId) {
        boolean result;
        double balance = (double)Math.round((currentOrder.total - this.getTenderTotal(currentOrder)) * 100.0) / 100.0;
        boolean hasChange = false;
        if (balance < -0.009 && currentOrder.total > 1.0E-4) {
            hasChange = true;
        }
        if ((balance > -1.0E-4 && balance < 1.0E-4 || balance < 1.0E-4 && hasChange) && !(result = this.core.invoiceOrder(currentOrder.toXml(), currentOrder.user, currentOrder.shift, "", ""))) {
            this.output("Error Invoicing Bite Order - Order Id:" + currentOrder.orderId);
        }
    }

    public double getTenderTotal(Order currentOrder) {
        double result = 0.0;
        if (currentOrder != null && currentOrder.tenderings != null) {
            int len = currentOrder.tenderings.size();
            for (int i = 0; i < len; ++i) {
                Tender thisTender = (Tender)currentOrder.tenderings.get(i);
                result += thisTender.amount;
            }
        }
        return result;
    }

    public boolean orderExists(String orderId) {
        boolean exists = true;
        Vector openOrders = this.core.getOrdersByOrderId(orderId);
        if (openOrders != null && openOrders.isEmpty()) {
            exists = false;
        }
        return exists;
    }

    class OrdersDownloadTimer
    extends TimerTask {
        OrdersDownloadTimer() {
        }

        @Override
        public void run() {
            if (!BiteDataHandler.this.core.isBlockLogin()) {
                BiteDataHandler.this.getOpenOrders();
            }
        }
    }
}

