/*
 * Decompiled with CFR 0.152.
 */
package DataHandlers;

import AccuServerBase.Ad2POSClientBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import POSDataObjects.AdInfo;
import WebServices.Ad2POSWebService;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;

public class Ad2POSWebServiceClient
implements ServerObject,
Ad2POSClientBase {
    URL url = null;
    QName qname = null;
    ServerCore core = null;
    String merchantId = "";
    boolean test = false;

    public void initialize(ServerCore core, Hashtable parameters) {
        try {
            this.core = core;
            String thisMerchant = (String)parameters.get("MerchantId");
            String testText = (String)parameters.get("Test");
            if (testText != null && testText.equalsIgnoreCase("True")) {
                this.test = true;
            }
            if (thisMerchant != null && !thisMerchant.isEmpty()) {
                this.merchantId = thisMerchant;
                this.url = this.test ? new URL("http://webservice.ad2pos.com:9877/Ad2POSWebServer?wsdl") : new URL("http://webservice.ad2pos.com:9876/Ad2POSWebServer?wsdl");
                this.qname = new QName("http://WebServices/", "Ad2POSWebServiceImplService");
                core.setAd2POSClient((Ad2POSClientBase)this);
            }
        }
        catch (MalformedURLException ex) {
            core.raiseException((Exception)ex);
        }
    }

    public AdInfo getNextAd(String adType, String reference) {
        AdInfo adInfo = null;
        try {
            Service service = Service.create((URL)this.url, (QName)this.qname);
            Ad2POSWebService eif = (Ad2POSWebService)service.getPort(Ad2POSWebService.class);
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyy/MM/dd hh:mm:ss");
            System.out.println(" getting ad ");
            String reply = eif.getNextAd(this.merchantId, adType, reference, dateFormat.format(now));
            System.out.println(" reply for ad " + reply);
            adInfo = new AdInfo(reply);
        }
        catch (Exception e) {
            adInfo = new AdInfo();
            adInfo.description = "Exception";
            this.core.raiseException(e);
        }
        return adInfo;
    }

    public void useAd(AdInfo adInfo) {
        try {
            Service service = Service.create((URL)this.url, (QName)this.qname);
            Ad2POSWebService eif = (Ad2POSWebService)service.getPort(Ad2POSWebService.class);
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyy/MM/dd hh:mm:ss");
            if (adInfo.id > 0) {
                String string = eif.useAd(this.merchantId, adInfo.id, dateFormat.format(now));
            }
        }
        catch (Exception e) {
            this.core.raiseException(e);
        }
    }

    public int getType() {
        return 0;
    }

    public void output(String output) {
    }
}

