/*
 * Decompiled with CFR 0.152.
 */
package CardHandlers;

import AccuServerBase.MoneyCardHandlerBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TenbisCardHandler
implements ServerObject,
MoneyCardHandlerBase {
    ServerCore core = null;
    String hostUrl = "https://www.10bis.co.il/api/reshome/v2/reshomeservice.svc/";
    String userName = "";
    String userPassword = "";
    String resId = "";
    String vendor = "";
    boolean debug = false;
    boolean waitingOnResponse = false;
    String postResponse = "";
    String token = "";
    long tokenTime = 0L;
    boolean six = false;
    DecimalFormat decimal = new DecimalFormat("####0.00;-####0.00");

    public void initialize(ServerCore core, Hashtable parameters) {
        this.core = core;
        String parameter = (String)parameters.get("UserName");
        if (parameter != null && parameter.length() > 0) {
            this.userName = parameter;
        }
        if ((parameter = (String)parameters.get("UserPassword")) != null && parameter.length() > 0) {
            this.userPassword = parameter;
        }
        if ((parameter = (String)parameters.get("ResId")) != null && parameter.length() > 0) {
            this.resId = parameter;
        }
        if ((parameter = (String)parameters.get("Vendor")) != null && parameter.length() > 0) {
            this.vendor = parameter;
        }
        if ((parameter = (String)parameters.get("Debug")) != null && parameter.length() > 0) {
            this.debug = parameter.equalsIgnoreCase("true");
        }
        if ((parameter = (String)parameters.get("Six")) != null && parameter.length() > 0) {
            this.six = parameter.equalsIgnoreCase("true");
        }
        this.core.setTenbisCardHandler((MoneyCardHandlerBase)this);
    }

    public void output(String output) {
        this.core.input(output);
    }

    public String processMoneyCard(String cardNumber, double amount, int companyCode) {
        String loginResult = "";
        String result = "";
        loginResult = this.checkForValidToken();
        if (loginResult.isEmpty()) {
            StringBuilder urlRequest = new StringBuilder();
            urlRequest.append(this.hostUrl);
            urlRequest.append("DebitMoneycard/");
            urlRequest.append(this.vendor + "/");
            urlRequest.append(this.resId + "/");
            urlRequest.append(cardNumber + "/");
            urlRequest.append("false/");
            urlRequest.append("none/");
            urlRequest.append("12345/");
            urlRequest.append(this.decimal.format(amount) + "/");
            urlRequest.append(this.token + "/");
            urlRequest.append("Auto");
            result = this.sendUrlRequest(urlRequest.toString(), "POST");
            String approved = Utility.getElement((String)"RESULT", (String)result);
            if (approved.equalsIgnoreCase("APPROVED")) {
                double balance = -1.0;
                String cardLimit = Utility.getElement((String)"DebitLimitSum", (String)result);
                try {
                    balance = Double.valueOf(cardLimit);
                }
                catch (NumberFormatException ex) {
                    balance = -1.0;
                }
                if (balance >= 0.0) {
                    result = result + "<MESSAGE>" + this.core.getLiteral("Money Card Balance") + ": " + this.decimal.format(balance -= amount) + "</MESSAGE>";
                }
            }
        } else {
            result = "<RESULT>" + loginResult + "</RESULT>\n";
        }
        return result;
    }

    public String processMoneyCardVoid(String cardNumber, double amount) {
        String loginResult = "";
        String result = "";
        loginResult = this.checkForValidToken();
        if (loginResult.isEmpty()) {
            StringBuilder urlRequest = new StringBuilder();
            urlRequest.append(this.hostUrl);
            urlRequest.append("RefundMoneycard/");
            urlRequest.append(this.vendor + "/");
            urlRequest.append(this.resId + "/");
            urlRequest.append(cardNumber + "/");
            urlRequest.append("12345/");
            urlRequest.append(this.decimal.format(amount) + "/");
            urlRequest.append(this.token + "/");
            urlRequest.append("Auto");
            result = this.sendUrlRequest(urlRequest.toString(), "POST");
        } else {
            result = "<RESULT>" + loginResult + "</RESULT>\n";
        }
        return result;
    }

    public String processMoneyCardBalance(String cardNumber) {
        String loginResult = "";
        StringBuilder result = new StringBuilder();
        loginResult = this.checkForValidToken();
        if (loginResult.isEmpty()) {
            StringBuilder urlRequest = new StringBuilder();
            urlRequest.append(this.hostUrl);
            urlRequest.append("GetMoneycardDebitLimit/");
            urlRequest.append(cardNumber + "/");
            urlRequest.append(this.resId + "/");
            urlRequest.append(this.token);
            String requestResult = this.sendUrlRequest(urlRequest.toString(), "GET");
            String success = Utility.getElement((String)"RESULT", (String)requestResult);
            if (success != null && success.equalsIgnoreCase("APPROVED")) {
                result.append("<RESULT>" + success + "</RESULT>\n");
                String cardLimit = Utility.getElement((String)"a:Limit", (String)requestResult);
                if (cardLimit != null && !cardLimit.isEmpty()) {
                    double balance = -1.0;
                    try {
                        balance = Double.valueOf(cardLimit);
                    }
                    catch (NumberFormatException ex) {
                        balance = -1.0;
                    }
                    if (balance >= 0.0) {
                        result.append("<BALANCE>" + this.decimal.format(balance) + "</BALANCE>\n");
                    } else {
                        result.append("<BALANCE>0.00</BALANCE>\n");
                    }
                } else {
                    result.append("<BALANCE>0.00</BALANCE>\n");
                }
            } else {
                result.append(requestResult);
            }
        } else {
            result.append("<RESULT>" + loginResult + "</RESULT>\n");
        }
        return result.toString();
    }

    private String loginTenbis() {
        String result = this.core.getLiteral("UNKNOWN LOGIN ERROR");
        StringBuilder urlRequest = new StringBuilder();
        urlRequest.append(this.hostUrl);
        urlRequest.append("Login/");
        urlRequest.append(this.userName + "/");
        urlRequest.append(this.userPassword + "/");
        urlRequest.append(this.resId + "/");
        urlRequest.append("12345");
        this.waitingOnResponse = true;
        SendHttpsPost post = new SendHttpsPost(urlRequest.toString(), "GET");
        post.start();
        while (this.waitingOnResponse) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.core.raiseException((Exception)ex);
            }
        }
        if (this.postResponse != null) {
            String success = Utility.getElement((String)"Success", (String)this.postResponse);
            if (success != null && success.equalsIgnoreCase("true")) {
                String tokenValue = Utility.getElement((String)"Token", (String)this.postResponse);
                if (tokenValue != null && !tokenValue.isEmpty()) {
                    this.token = tokenValue;
                    result = "";
                }
            } else {
                String errorDesc = Utility.getElement((String)"a:ErrorDesc", (String)this.postResponse);
                if (errorDesc != null && !errorDesc.isEmpty()) {
                    result = errorDesc;
                }
            }
        } else {
            result = this.core.getLiteral("Could not connect") + "\n\n" + this.core.getLiteral("Check connection and try again");
        }
        return result;
    }

    private String sendUrlRequest(String urlRequest, String getPostRequest) {
        StringBuilder result = new StringBuilder();
        this.waitingOnResponse = true;
        SendHttpsPost post = new SendHttpsPost(urlRequest, getPostRequest);
        post.start();
        while (this.waitingOnResponse) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.core.raiseException((Exception)ex);
            }
        }
        if (this.postResponse != null) {
            String success = Utility.getElement((String)"Success", (String)this.postResponse);
            if (success != null && success.equalsIgnoreCase("true")) {
                String dataValue = Utility.getElement((String)"Data", (String)this.postResponse);
                result.append("<RESULT>APPROVED</RESULT>\n");
                result.append("<DATA>" + dataValue + "</DATA>\n");
            } else {
                String errorCode = Utility.getElement((String)"a:ErrorCode", (String)this.postResponse);
                if (errorCode != null && errorCode.equalsIgnoreCase("704")) {
                    this.token = "";
                    String errorDesc = this.core.getLiteral("Login token has expired, Please try again.");
                    result.append("<RESULT>" + errorDesc + "</RESULT>\n");
                } else {
                    String errorDesc = Utility.getElement((String)"a:ErrorDesc", (String)this.postResponse);
                    if (errorDesc != null) {
                        result.append("<RESULT>" + errorDesc + "</RESULT>\n");
                    } else {
                        result.append("<RESULT>" + this.core.getLiteral("Unknown Error") + "</RESULT>\n");
                    }
                }
            }
        }
        return result.toString();
    }

    private String checkForValidToken() {
        String loginResult = "";
        if (this.tokenTime > 0L) {
            long twoHours = 0x6DDD00L;
            long now = System.currentTimeMillis();
            if (now - this.tokenTime >= twoHours) {
                this.token = "";
                this.tokenTime = now;
                if (this.debug) {
                    System.out.println("\nLogin token older than 2 hours, new token requested\n");
                }
            }
        } else {
            this.tokenTime = System.currentTimeMillis();
        }
        if (this.token == null || this.token.isEmpty()) {
            loginResult = this.loginTenbis();
        }
        return loginResult;
    }

    public String processMoneyCardVoid(String reference) {
        return "";
    }

    public class SendHttpsPost
    extends Thread {
        String urlRequest = "";
        String getPostRequest = "";

        public SendHttpsPost(String urlRequest, String getPostRequest) {
            this.urlRequest = urlRequest;
            this.getPostRequest = getPostRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TenbisCardHandler.this.postResponse = null;
            BufferedReader reader = null;
            InputStreamReader isr = null;
            if (TenbisCardHandler.this.debug) {
                System.out.println("urlRequest:\r\n" + this.urlRequest);
                TenbisCardHandler.this.core.debugLog("TENBIS REQUEST:\r\n" + this.urlRequest);
            }
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = null;
                sc = TenbisCardHandler.this.six ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLSv1.2");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                URL theUrl = new URL(this.urlRequest);
                HttpsURLConnection conn = (HttpsURLConnection)theUrl.openConnection();
                conn.setRequestMethod(this.getPostRequest);
                conn.setRequestProperty("Accept", "application/xml");
                conn.setRequestProperty("Content-Type", "application/xml; charset=utf-8");
                conn.setDoInput(true);
                conn.setUseCaches(false);
                if (this.getPostRequest.equalsIgnoreCase("POST")) {
                    conn.setDoOutput(true);
                    conn.setChunkedStreamingMode(0);
                }
                StringBuilder sb = new StringBuilder();
                int code = conn.getResponseCode();
                if (TenbisCardHandler.this.debug) {
                    System.out.println("responseCode=" + code);
                    TenbisCardHandler.this.core.debugLog("TENBIS HTTP RESPONSE CODE = " + code + "\r\nRESPONSE DATA:\r\n" + sb.toString());
                }
                if (code == 200) {
                    isr = new InputStreamReader(conn.getInputStream(), "UTF-8");
                    reader = new BufferedReader(isr);
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    TenbisCardHandler.this.postResponse = sb.toString();
                    if (TenbisCardHandler.this.debug) {
                        System.out.println("Receive from host:\r\n" + TenbisCardHandler.this.postResponse);
                        TenbisCardHandler.this.core.debugLog("TENBIS RESPONSE:\r\n" + TenbisCardHandler.this.postResponse);
                    }
                } else {
                    sb.append("<a:ErrorCode>" + code + "</a:ErrorCode>");
                    sb.append("<a:ErrorDesc>HTTP Result Code: " + code + "</a:ErrorDesc>");
                    TenbisCardHandler.this.postResponse = sb.toString();
                }
            }
            catch (Exception ex) {
                TenbisCardHandler.this.core.raiseException(ex);
            }
            finally {
                try {
                    if (isr != null) {
                        isr.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
            }
            TenbisCardHandler.this.waitingOnResponse = false;
        }
    }
}

