/*
 * Decompiled with CFR 0.152.
 */
package AccuServerWebServers;

import AccuServerBase.ServerCore;
import AccuServerBase.Utility;
import AccuServerBase.WebSocketClientBase;
import AccuServerWebServers.HttpClient;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Vector;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONObject;

public class WebSocketProxyClient
extends WebSocketClient
implements WebSocketClientBase {
    private ServerCore core;
    private int webServerPort = 2147;
    private boolean webServerSecure = false;
    private boolean debug = true;

    public WebSocketProxyClient(URI serverUri, ServerCore core) {
        super(serverUri);
        this.core = core;
        if (core.getWebServer() != null) {
            this.webServerPort = core.getWebServer().getPort();
            this.webServerSecure = core.getWebServer().isSecure();
        }
    }

    public void onOpen(ServerHandshake handshakedata) {
        System.out.println("Connected");
        this.core.input("Connected to proxy server");
    }

    public void onMessage(String message) {
        HttpClient httpClient;
        String request = Utility.getElement((String)"ProxyServerIncomingRequest", (String)message);
        String requestHash = Utility.getElement((String)"requestHash", (String)request);
        String requestMethod = Utility.getElement((String)"method", (String)request);
        String requestBody = Utility.getElement((String)"body", (String)request);
        String path = Utility.getElement((String)"data", (String)request);
        String postParametersString = Utility.getElement((String)"postParameters", (String)request);
        Vector postParametersVector = Utility.getElementList((String)"parameter", (String)postParametersString);
        HashMap<String, String> postParametersHashMap = new HashMap<String, String>();
        for (String postParameter : postParametersVector) {
            String key = Utility.getElement((String)"key", (String)postParameter);
            String value = Utility.getElement((String)"value", (String)postParameter);
            postParametersHashMap.put(key, value);
        }
        if (requestBody != null && !requestBody.trim().equals("")) {
            httpClient = new HttpClient(this.core);
            httpClient.withCustomBody(requestBody);
        } else {
            httpClient = new HttpClient(this.core);
        }
        String httpClientResponse = "";
        if (path.toLowerCase().endsWith(".gz")) {
            path = path.substring(0, path.length() - 3);
        }
        String pattern = "(.*)(.)(png|ico|jpg|jpeg|gif|bmp|woff2|woff|ttf)";
        boolean isStaticFile = path.trim().toLowerCase().matches(pattern);
        try {
            if (path.contains("?")) {
                path = path.substring(0, path.indexOf("?"));
            }
            if (!isStaticFile) {
                String protocol;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                String string = protocol = this.webServerSecure ? "https" : "http";
                if (requestMethod.equalsIgnoreCase("GET")) {
                    String thisRequest = String.format("%s://localhost:%s/%s", protocol, this.webServerPort, path);
                    httpClientResponse = httpClient.get(thisRequest, this.webServerSecure);
                } else if (requestMethod.equalsIgnoreCase("POST")) {
                    if (!postParametersHashMap.isEmpty()) {
                        httpClient = httpClient.withParameters(postParametersHashMap);
                    }
                    String thisRequest = String.format("%s://localhost:%s/%s", protocol, this.webServerPort, path);
                    httpClientResponse = httpClient.post(thisRequest, this.webServerSecure);
                }
            } else {
                File file = new File(System.getProperty("user.dir") + "/AccuServerHtmlNew/" + path);
                if (file.exists()) {
                    try {
                        byte[] response = Utility.getBytesFromFile((File)file);
                        httpClientResponse = this.getImageResponse(response);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (httpClientResponse.toLowerCase().contains("<h1>Page Not Found</h1>")) {
                httpClientResponse = "";
            }
            JSONObject responseJson = new JSONObject();
            responseJson.put("hash", (Object)requestHash);
            responseJson.put("data", (Object)httpClientResponse);
            responseJson.put("type", (Object)(isStaticFile ? "static_file" : "text"));
            this.core.sendMessageToProxyServer(responseJson.toString());
        }
        catch (Exception e) {
            int n = 9;
        }
        if (this.debug) {
            this.core.input(String.format("Proxy server says: %s %s", requestMethod, path));
        }
    }

    public String getImageResponse(byte[] data) {
        try {
            StringBuilder out = new StringBuilder();
            out.append(new String(Base64.encode(data)));
            return out.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public void onClose(int code, String reason, boolean remote) {
    }

    public void onError(Exception ex) {
    }

    public void setPort(int port) {
        this.webServerPort = port;
    }
}

