/*
 * Decompiled with CFR 0.152.
 */
package AccuServerWebServers;

import AccuServerBase.ReportObject;
import AccuServerBase.ServerCore;
import AccuServerBase.Utility;
import POSDataObjects.DataChange;
import POSDataObjects.Item;
import POSDataObjects.LineItem;
import POSDataObjects.ReceiptPrintSetup;
import POSDataObjects.Reset;
import POSDataObjects.Taxes;
import POSDataObjects.Tender;
import POSDataObjects.Transaction;
import POSDataObjects.TransactionReportOptions;
import java.io.IOException;
import java.net.Socket;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;

public class TransactionsLogReport
implements ReportObject {
    ServerCore core = null;
    Socket socket = null;
    ReceiptPrintSetup companyInfo = null;
    Vector transactions = null;
    boolean byReset = false;
    Timestamp fromDate = null;
    Timestamp thruDate = null;
    Reset reset = null;
    String html = "";
    boolean export = false;
    String reportFileName = "";
    String till = "";
    String employee = "";
    String customer = "";
    String tender = "";
    double fromAmount = 0.0;
    double toAmount = 0.0;
    boolean filterByAmount;
    String template = "transaction_logs";
    private String discountColor;
    private String positiveColor;
    private String increaseColor;
    private String onTheHouseColor;
    private String editedColor;
    private String editedTextColor;
    private String movedFromColor;
    private String movedToColor;
    private String userManager;
    private String negativeColor;
    SimpleDateFormat dateFormat = null;
    SimpleDateFormat dayFormat = null;
    SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    DecimalFormat currencyFormat = null;
    DecimalFormat quantityFormat = null;
    DecimalFormat priceFormat = null;
    String countryCode = null;
    String tipString = null;
    String taxableString = "";
    String nontaxableString = "";

    public void initialize(ServerCore core, Socket socket, boolean export) {
        this.core = core;
        this.socket = socket;
        this.export = export;
        this.countryCode = core.getCountry();
        this.tipString = " (" + core.getLiteral("Tip") + ")";
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setByReset(Reset thisReset) {
        this.reset = thisReset;
        this.fromDate = thisReset.start;
        this.thruDate = thisReset.end;
        this.byReset = true;
    }

    public void setByDates(Timestamp fromDate, Timestamp thruDate) {
        this.fromDate = fromDate;
        this.thruDate = thruDate;
        this.byReset = false;
    }

    public void setTill(String till) {
        this.till = till;
    }

    public void setCustomer(String customer) {
        this.customer = customer.trim();
    }

    public void setTender(String tender) {
        this.tender = tender;
    }

    public void setFilterByAmount(boolean filterByAmount) {
        this.filterByAmount = filterByAmount;
    }

    public void loadData() {
        this.companyInfo = this.core.getReceiptPrintSetup();
        TransactionReportOptions reportOptions = new TransactionReportOptions();
        reportOptions.fromDate = this.fromDate;
        reportOptions.thruDate = this.thruDate;
        reportOptions.reset = this.reset;
        this.transactions = this.core.getTransactionData(reportOptions);
        if (this.transactions != null && !this.transactions.isEmpty()) {
            Collections.sort(this.transactions, new TransactionDateInvoicedCompare());
        }
    }

    public void loadDataWithFilters(TransactionReportOptions reportOptions) {
        this.companyInfo = this.core.getReceiptPrintSetup();
        if (reportOptions.employees.size() > 0) {
            this.employee = (String)reportOptions.employees.get(0);
        }
        this.fromAmount = reportOptions.transactionFromAmount;
        this.toAmount = reportOptions.transactionToAmount;
        reportOptions.fromDate = this.fromDate;
        reportOptions.thruDate = this.thruDate;
        reportOptions.reset = this.reset;
        reportOptions.includeOpenSales = true;
        try {
            this.transactions = this.core.getTransactionReportData(reportOptions);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.transactions != null && !this.transactions.isEmpty()) {
            Collections.sort(this.transactions, new TransactionDateInvoicedCompare());
        }
    }

    public boolean getReportHtml() {
        String errors = "";
        if (this.transactions == null || this.transactions.isEmpty()) {
            this.transactions = new Vector();
        }
        this.html = this.export ? this.core.getWebServer().getTemplateHtml(this.template + ".tml") : this.core.getWebServer().getTemplateHtml(this.template + ".tmpl");
        if (this.html == null) {
            this.core.getWebServer().sendResponse(this.socket, "Error: report template not found.");
            return false;
        }
        if (this.reset != null && this.reset.sequence < 0) {
            this.core.getWebServer().sendResponse(this.socket, "Error: Sequence number cannot be " + this.reset.sequence);
            return false;
        }
        this.reportFileName = this.export ? this.core.getWebServer().getReportPath() + this.template + ".xml" : this.core.getWebServer().getReportPath() + this.template + ".html";
        try {
            Utility.writeXml((String)this.reportFileName, (String)"");
        }
        catch (IOException ex) {
            this.core.raiseException((Exception)ex);
        }
        String headerBlock = Utility.getDataBlockContents((String)"HeaderBlock", (String)this.html);
        String footerBlock = Utility.getDataBlockContents((String)"FooterBlock", (String)this.html);
        if (this.export) {
            String reportStylesXml = this.core.getWebServer().getReportStylesXml();
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"ReportStylesBlock", (String)reportStylesXml);
        }
        SimpleDateFormat titleFormat = new SimpleDateFormat(this.core.getWebServer().getDateFormat());
        String runTime = titleFormat.format(new Date());
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"DateRun", (String)runTime);
        String ranges = "";
        SimpleDateFormat rangeDate = new SimpleDateFormat(this.core.getWebServer().getDateTimeFormat());
        ranges = this.byReset ? this.core.getLiteral("For Till") + " " + this.reset.till + " " + this.core.getLiteral("Sequence") + " " + this.reset.sequence : this.core.getLiteral("From") + " " + rangeDate.format(this.fromDate) + " " + this.core.getLiteral("Through") + " " + rangeDate.format(this.thruDate);
        headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"Range", (String)ranges);
        String country = this.core.getCountry();
        String lineItemsBlock = Utility.getDataBlockContents((String)"LineItemsBlock", (String)this.html);
        String transactionHeaderBlock = Utility.getDataBlockContents((String)"TransactionHeaderBlock", (String)this.html);
        String tenderingSheetBlock = Utility.getDataBlockContents((String)"TenderingSheetBlock", (String)this.html);
        String tenderingBlock = Utility.getDataBlockContents((String)"TenderingBlock", (String)this.html);
        String tenderingSheetFooterBlock = Utility.getDataBlockContents((String)"TenderingSheetFooterBlock", (String)this.html);
        String taxesBlock = Utility.getDataBlockContents((String)"TaxesBlock", (String)lineItemsBlock);
        String dateFormatString = Utility.getTag((String)"DateFormat", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"DateFormat", (String)"");
        String dayFormatString = Utility.getTag((String)"DayFormat", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"DayFormat", (String)"");
        String hourFormatString = Utility.getTag((String)"HourFormat", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"HourFormat", (String)"");
        String currencyFormatString = Utility.getTag((String)"CurrencyFormat", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"CurrencyFormat", (String)"");
        String priceFormatString = Utility.getTag((String)"PriceFormat", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"PriceFormat", (String)"");
        String quantityFormatString = Utility.getTag((String)"QuantityFormat", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"QuantityFormat", (String)"");
        this.negativeColor = Utility.getDataBlockContents((String)"NegativeColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"NegativeColor", (String)"");
        this.discountColor = Utility.getDataBlockContents((String)"DiscountColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"DiscountColor", (String)"");
        this.positiveColor = Utility.getDataBlockContents((String)"PositiveColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"PositiveColor", (String)"");
        this.increaseColor = Utility.getDataBlockContents((String)"IncreaseColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"IncreaseColor", (String)"");
        this.onTheHouseColor = Utility.getDataBlockContents((String)"OnTheHouseColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"OnTheHouseColor", (String)"");
        this.editedColor = Utility.getDataBlockContents((String)"EditedColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"EditedColor", (String)"");
        this.editedTextColor = Utility.getDataBlockContents((String)"EditedTextColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"EditedTextColor", (String)"");
        this.movedFromColor = Utility.getDataBlockContents((String)"MovedFromColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"MovedFromColor", (String)"");
        this.movedToColor = Utility.getDataBlockContents((String)"MovedToColor", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"MovedToColor", (String)"");
        this.userManager = Utility.getDataBlockContents((String)"UserManager", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"UserManager", (String)"");
        this.taxableString = Utility.getTag((String)"TaxableText", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"TaxableText", (String)"");
        this.nontaxableString = Utility.getTag((String)"NontaxableText", (String)footerBlock);
        footerBlock = Utility.replaceBlock((String)footerBlock, (String)"NontaxableText", (String)"");
        if (this.companyInfo != null) {
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyName", (String)this.companyInfo.companyName);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyAddress1", (String)this.companyInfo.companyAddress1);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyAddress2", (String)this.companyInfo.companyAddress2);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyCity", (String)this.companyInfo.companyCity);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyState", (String)this.companyInfo.companyState);
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyZip", (String)this.companyInfo.companyZip);
        } else {
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyName", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyAddress1", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyAddress2", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyCity", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyState", (String)"");
            headerBlock = Utility.replaceDataTag((String)headerBlock, (String)"CompanyZip", (String)"");
        }
        headerBlock = country.equals("IL") ? Utility.replaceDataTag((String)headerBlock, (String)"RightToLeftExcel", (String)"ss:RightToLeft=\"1\"") : Utility.replaceDataTag((String)headerBlock, (String)"RightToLeftExcel", (String)"");
        this.core.getWebServer().writeFileAppend(this.reportFileName, headerBlock);
        this.dateFormat = new SimpleDateFormat(this.core.getWebServer().getDateFormat());
        this.dayFormat = new SimpleDateFormat(dayFormatString);
        this.currencyFormat = new DecimalFormat(currencyFormatString);
        this.quantityFormat = new DecimalFormat(quantityFormatString);
        this.priceFormat = new DecimalFormat(priceFormatString);
        int len = this.transactions.size();
        for (int t = 0; t < len; ++t) {
            ReportLine reportLine;
            String thisLineItemsBlock;
            int i;
            Transaction thisTransaction = (Transaction)this.transactions.get(t);
            if (!this.employee.isEmpty() && !this.employee.equals(thisTransaction.server) || !this.till.isEmpty() && !this.till.equals(thisTransaction.till) || !this.customer.isEmpty() && !this.customer.equals(thisTransaction.customerCode)) continue;
            if (!this.tender.isEmpty()) {
                Vector creditCardCodes = new Vector();
                if (this.tender.contains("allCredit")) {
                    Collections.addAll(creditCardCodes, this.tender.split(";"));
                }
                int tenderLen = thisTransaction.tendering.size();
                boolean tenderExists = false;
                for (i = 0; i < tenderLen; ++i) {
                    Tender thisTender = (Tender)thisTransaction.tendering.get(i);
                    if (!this.tender.equals(thisTender.code) && !creditCardCodes.contains(thisTender.code)) continue;
                    tenderExists = true;
                    break;
                }
                if (!tenderExists) continue;
            }
            if (this.filterByAmount) {
                double total = 0.0;
                int tenderLen = thisTransaction.tendering.size();
                for (i = 0; i < tenderLen; ++i) {
                    Tender tender = (Tender)thisTransaction.tendering.get(i);
                    if (tender.status.equals("V")) continue;
                    total += tender.amount;
                }
                if (!(this.fromAmount <= total) || !(this.toAmount >= total)) continue;
            }
            double taxable = 0.0;
            double nonTaxable = 0.0;
            double tax = 0.0;
            double vatTax = 0.0;
            double vat1Total = 0.0;
            double vat2Total = 0.0;
            double vatGrossTotal = 0.0;
            String thisTransactionBlock = transactionHeaderBlock;
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"TransactionNumber", (String)("" + thisTransaction.transaction));
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"InvoiceNumber", (String)("" + thisTransaction.invoice));
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"DateCreated", (String)this.timestampFormat.format(thisTransaction.dateEntered));
            if (thisTransaction.dateInvoiced != null) {
                thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"DateInvoiced", (String)this.timestampFormat.format(thisTransaction.dateInvoiced));
                thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"InvoiceDay", (String)this.timestampFormat.format(thisTransaction.dateInvoiced));
                thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"InvoiceHour", (String)this.timestampFormat.format(thisTransaction.dateInvoiced));
            } else {
                thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"DateInvoiced", (String)"");
                thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"InvoiceDay", (String)"");
                thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"InvoiceHour", (String)"");
            }
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"Till", (String)thisTransaction.till);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"Sequence", (String)("" + thisTransaction.sequence));
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"CustomerCompanyName", (String)thisTransaction.companyName);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"CustomerCode", (String)thisTransaction.customerCode);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"FirstName", (String)thisTransaction.first);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"MiddleName", (String)thisTransaction.middle);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"LastName", (String)thisTransaction.last);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"ContactName", (String)thisTransaction.contact);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"Address1", (String)thisTransaction.address1);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"Address2", (String)thisTransaction.address2);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"Address3", (String)thisTransaction.address3);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"Phone", (String)thisTransaction.phone);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"Fax", (String)thisTransaction.fax);
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"Email", (String)thisTransaction.email);
            this.core.getWebServer().writeFileAppend(this.reportFileName, thisTransactionBlock);
            int movedItemsLen = thisTransaction.movedLineItems.size();
            for (int i2 = 0; i2 < movedItemsLen; ++i2) {
                LineItem thisLineItem = (LineItem)thisTransaction.movedLineItems.get(i2);
                thisLineItem.movedFrom *= -1;
                thisTransaction.lineItems.add(thisLineItem);
            }
            int itemsLen = thisTransaction.lineItems.size();
            for (int lineItemNumber = 0; lineItemNumber < itemsLen; ++lineItemNumber) {
                Taxes thisTaxes;
                int x;
                int taxLen;
                Vector dataChanges;
                boolean lineTaxInserted = false;
                thisLineItemsBlock = lineItemsBlock;
                LineItem thisLineItem = (LineItem)thisTransaction.lineItems.get(lineItemNumber);
                thisLineItem.changedPrice = thisLineItem.changedPrice.trim();
                thisLineItem.changedQuantity = thisLineItem.changedQuantity.trim();
                this.addLine(thisLineItemsBlock, thisLineItem, thisTransaction);
                if (thisLineItem.movedFrom > 0) {
                    reportLine = new ReportLine(thisLineItem, thisTransaction);
                    this.addLine(thisLineItemsBlock, reportLine);
                }
                if ((dataChanges = this.core.searchDataChanges("All", thisLineItem.id + "", this.fromDate, this.thruDate)) != null) {
                    int changesLen = dataChanges.size();
                    for (int i3 = 0; i3 < changesLen; ++i3) {
                        DataChange dataChanged = (DataChange)dataChanges.get(i3);
                        ReportLine reportLine2 = new ReportLine(thisLineItem, thisTransaction);
                        reportLine2.changedFrom = dataChanged.changedFrom;
                        reportLine2.changedTo = dataChanged.changedTo;
                        reportLine2.user = dataChanged.changedBy;
                        reportLine2.changed = dataChanged.dateChanged.getTime();
                        if (dataChanged.fieldChanged.equals("price")) {
                            reportLine2.changeType = this.core.getLiteral("Changed Price");
                        } else if (dataChanged.fieldChanged.equals("quantity")) {
                            reportLine2.changeType = this.core.getLiteral("Changed Quantity");
                        } else if (dataChanged.fieldChanged.equals("price (comp)")) {
                            reportLine2.changeType = this.core.getLiteral("price (comp)");
                        }
                        this.addLine(thisLineItemsBlock, reportLine2);
                    }
                }
                if (thisLineItem.movedFrom < 0) {
                    ReportLine reportLine3 = new ReportLine(thisLineItem, thisTransaction);
                    this.addLine(thisLineItemsBlock, reportLine3);
                }
                if (thisLineItem.status.equals("V") && thisLineItem.changed > 0L) {
                    ReportLine reportLine4 = new ReportLine(thisLineItem, thisTransaction);
                    this.addLine(thisLineItemsBlock, reportLine4);
                }
                int tenderLen = thisTransaction.tendering.size();
                String itemTenderCode = "";
                double itemTenderAmount = 0.0;
                if (lineItemNumber == 0) {
                    for (int n = 0; n < tenderLen; ++n) {
                        Tender thisTender = (Tender)thisTransaction.tendering.get(n);
                        if (!itemTenderCode.contains(thisTender.description)) {
                            boolean hasTip = thisTender.status.equalsIgnoreCase("T");
                            if (itemTenderCode.length() == 0) {
                                itemTenderCode = thisTender.description;
                                if (hasTip) {
                                    itemTenderCode = itemTenderCode + this.tipString;
                                }
                            } else {
                                thisTender.code = thisTender.code + "/" + thisTender.description;
                                if (hasTip) {
                                    thisTender.description = thisTender.description + this.tipString;
                                }
                            }
                        }
                        itemTenderAmount += thisTender.amount;
                    }
                }
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TenderDescription", (String)("" + itemTenderCode));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TenderAmount", (String)("" + this.currencyFormat.format(itemTenderAmount)));
                double lineTax = 0.0;
                double lineTaxable = 0.0;
                double lineNonTaxable = 0.0;
                if (this.countryCode.equals("IL")) {
                    if (thisLineItem.taxCode.equals("\u05de\u05e2\u05de")) {
                        if (!lineTaxInserted) {
                            taxLen = thisTransaction.taxes.size();
                            for (x = 0; x < taxLen; ++x) {
                                thisTaxes = (Taxes)thisTransaction.taxes.get(x);
                                lineTax = thisTaxes.amount;
                            }
                        }
                        lineTaxable = thisLineItem.total;
                    } else {
                        lineNonTaxable = thisLineItem.total;
                    }
                } else if (thisLineItem.taxable) {
                    if (!lineTaxInserted) {
                        taxLen = thisTransaction.taxes.size();
                        for (x = 0; x < taxLen; ++x) {
                            thisTaxes = (Taxes)thisTransaction.taxes.get(x);
                            lineTax = thisTaxes.amount;
                        }
                    }
                    lineTaxable = thisLineItem.total;
                } else {
                    lineNonTaxable = thisLineItem.total;
                }
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TaxableTotal", (String)this.currencyFormat.format(lineTaxable));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"NontaxableTotal", (String)this.currencyFormat.format(lineNonTaxable));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Vat1Total", (String)this.currencyFormat.format(thisLineItem.vatTax1));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Vat2Total", (String)this.currencyFormat.format(thisLineItem.vatTax2));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"VatGrossTotal", (String)this.currencyFormat.format(thisLineItem.vatGross));
                if (this.countryCode.equals("IL")) {
                    if (thisLineItem.taxCode.equals("\u05de\u05e2\u05de") && !lineTaxInserted) {
                        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TaxTotal", (String)this.currencyFormat.format(lineTax));
                        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TransactionTotal", (String)this.currencyFormat.format(lineTaxable + lineNonTaxable + lineTax + thisLineItem.vatGross));
                        lineTaxInserted = true;
                        continue;
                    }
                    thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TaxTotal", (String)"");
                    thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TransactionTotal", (String)this.currencyFormat.format(lineTaxable + lineNonTaxable + thisLineItem.vatGross));
                    continue;
                }
                if (thisLineItem.taxable && !lineTaxInserted) {
                    thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TaxTotal", (String)this.currencyFormat.format(lineTax));
                    thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TransactionTotal", (String)this.currencyFormat.format(lineTaxable + lineNonTaxable + lineTax + thisLineItem.vatGross));
                    lineTaxInserted = true;
                    continue;
                }
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TaxTotal", (String)"");
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TransactionTotal", (String)this.currencyFormat.format(lineTaxable + lineNonTaxable + thisLineItem.vatGross));
            }
            int tenderLen = thisTransaction.tendering.size();
            for (int n = 0; n < tenderLen; ++n) {
                thisLineItemsBlock = lineItemsBlock;
                Tender thisTender = (Tender)thisTransaction.tendering.get(n);
                reportLine = new ReportLine(thisTender, thisTransaction);
                this.addLine(thisLineItemsBlock, reportLine);
            }
            this.core.getWebServer().writeFileAppend(this.reportFileName, "<Row><Cell><Data ss:Type=\"String\"></Data></Cell></Row>");
            int taxLen = thisTransaction.taxes.size();
            StringBuilder taxesText = new StringBuilder();
            for (int x = 0; x < taxLen; ++x) {
                String thisTaxesBlock = taxesBlock;
                Taxes thisTaxes = (Taxes)thisTransaction.taxes.get(x);
                thisTaxesBlock = Utility.replaceDataTag((String)thisTaxesBlock, (String)"TaxAuthorityCode", (String)thisTaxes.authority);
                thisTaxesBlock = Utility.replaceDataTag((String)thisTaxesBlock, (String)"TaxAmount", (String)this.currencyFormat.format(thisTaxes.amount));
                taxesText.append(thisTaxesBlock);
                tax += thisTaxes.amount;
            }
            String transactionColor = this.positiveColor;
            if (thisTransaction.total < -1.0E-4) {
                transactionColor = this.negativeColor;
            }
            thisTransactionBlock = Utility.replaceDataTag((String)thisTransactionBlock, (String)"TransactionColor", (String)transactionColor);
            thisTransactionBlock = thisTransactionBlock.replaceAll("\\s{2,}", " ");
            if (this.export) continue;
            this.core.getWebServer().sendHtmlResponse(this.socket, thisTransactionBlock, false, false, true);
        }
        this.core.getWebServer().writeFileAppend(this.reportFileName, footerBlock);
        footerBlock = Utility.replaceDataTag((String)footerBlock, (String)"Errors", (String)errors);
        if (!this.export) {
            this.core.getWebServer().sendHtmlResponse(this.socket, footerBlock, false, true, true);
        } else {
            this.core.getWebServer().sendHtmlExportFile(this.socket, this.reportFileName, "");
        }
        return true;
    }

    void addLine(String thisLineItemsBlock, ReportLine reportLine) {
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Created", (String)this.timestampFormat.format(reportLine.created));
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ItemCode", (String)reportLine.itemCode);
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ChangeType", (String)reportLine.changeType);
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ChangedFrom", (String)reportLine.changedFrom);
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ChangedTo", (String)reportLine.changedTo);
        thisLineItemsBlock = reportLine.changed > 0L ? Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ModifiedTime", (String)this.timestampFormat.format(new Date(reportLine.changed))) : Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ModifiedTime", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"LineItemId", (String)reportLine.lineItemId);
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Quantity", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Price", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"User", (String)reportLine.user);
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Tax", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"VatGross", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"PriceVatIncluded", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Description", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TransactionNumber", (String)("" + reportLine.transaction));
        thisLineItemsBlock = reportLine.transactionDateInvoiced != null ? Utility.replaceDataTag((String)thisLineItemsBlock, (String)"DateInvoiced", (String)this.timestampFormat.format(reportLine.transactionDateInvoiced)) : Utility.replaceDataTag((String)thisLineItemsBlock, (String)"DateInvoiced", (String)"");
        thisLineItemsBlock = !reportLine.changeType.equals(this.core.getLiteral("Payment")) ? Utility.replaceDataTag((String)thisLineItemsBlock, (String)"XmlExtentionColor", (String)"negativeColor") : Utility.replaceDataTag((String)thisLineItemsBlock, (String)"XmlExtentionColor", (String)"");
        this.core.getWebServer().writeFileAppend(this.reportFileName, thisLineItemsBlock);
    }

    void addLine(String thisLineItemsBlock, LineItem lineItem, Transaction transaction) {
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Created", (String)this.timestampFormat.format(lineItem.created));
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ItemCode", (String)lineItem.itemId);
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ChangeType", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ChangedFrom", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ChangedTo", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ModifiedTime", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Price", (String)this.currencyFormat.format(lineItem.price));
        Item item = this.core.getItemByCode(lineItem.itemId);
        String description = "";
        if (item != null) {
            description = item.description;
        }
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Description", (String)description);
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Quantity", (String)this.quantityFormat.format(lineItem.quantity));
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"User", (String)lineItem.userId);
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Tax", (String)this.currencyFormat.format(lineItem.vatTax1));
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"VatGross", (String)this.currencyFormat.format(lineItem.vatGross));
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"PriceVatIncluded", (String)this.currencyFormat.format(lineItem.vatGross / lineItem.quantity));
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TransactionNumber", (String)("" + transaction.transaction));
        thisLineItemsBlock = transaction.dateInvoiced != null ? Utility.replaceDataTag((String)thisLineItemsBlock, (String)"DateInvoiced", (String)this.timestampFormat.format(transaction.dateInvoiced)) : Utility.replaceDataTag((String)thisLineItemsBlock, (String)"DateInvoiced", (String)"");
        thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"XmlExtentionColor", (String)"positiveColor");
        this.core.getWebServer().writeFileAppend(this.reportFileName, thisLineItemsBlock);
    }

    DataChange getChange(Vector dataChanges, String objectId, String fieldChanged) {
        DataChange dataChange = null;
        int changesLen = dataChanges.size();
        for (int i = 0; i < changesLen; ++i) {
            DataChange thisChange = (DataChange)dataChanges.get(i);
            if (!thisChange.objectId.equals(objectId) || !thisChange.fieldChanged.equals(fieldChanged)) continue;
            dataChange = thisChange;
            break;
        }
        return dataChange;
    }

    class TransactionDateInvoicedCompare
    implements Comparator<Transaction> {
        TransactionDateInvoicedCompare() {
        }

        @Override
        public int compare(Transaction o1, Transaction o2) {
            int result = o1.dateEntered.compareTo(o2.dateEntered);
            if ((result *= -1) == 0) {
                result = o1.transaction > o2.transaction ? 1 : (o1.transaction < o2.transaction ? -1 : 0);
            }
            return result;
        }
    }

    class ReportLine {
        String changeType;
        String lineItemId;
        long transaction;
        long changed;
        long created;
        String user;
        Date transactionDateEntered;
        Date transactionDateInvoiced;
        String till;
        String itemCode;
        String changedFrom;
        String changedTo;
        int movedFrom;

        ReportLine(LineItem lineItem, Transaction transaction) {
            this.lineItemId = lineItem.id + "";
            this.changedFrom = "";
            this.changedTo = "";
            this.transaction = lineItem.transaction;
            this.changed = lineItem.changed;
            this.created = lineItem.created;
            this.user = lineItem.userId;
            this.movedFrom = lineItem.movedFrom;
            this.changeType = "";
            if (lineItem.status.equals("V")) {
                this.changeType = TransactionsLogReport.this.core.getLiteral("Void");
            } else if (lineItem.movedFrom > 0) {
                this.changed = this.created;
                this.changedTo = TransactionsLogReport.this.core.getLiteral("Moved From") + " " + lineItem.movedFrom;
            } else if (lineItem.movedFrom < 0) {
                this.changedTo = TransactionsLogReport.this.core.getLiteral("Moved To") + " " + lineItem.movedFrom;
            }
            this.transactionDateEntered = transaction.dateEntered;
            this.transactionDateInvoiced = transaction.dateInvoiced;
            this.till = lineItem.till;
            this.itemCode = lineItem.itemId;
        }

        ReportLine(Tender tender, Transaction transaction) {
            this.changedFrom = "";
            this.changedTo = TransactionsLogReport.this.currencyFormat.format(tender.amount);
            this.lineItemId = "";
            this.changeType = TransactionsLogReport.this.core.getLiteral("Payment");
            this.transaction = transaction.transaction;
            this.changed = 0L;
            this.created = tender.created;
            this.user = tender.user;
            this.transactionDateEntered = transaction.dateEntered;
            this.transactionDateInvoiced = transaction.dateInvoiced;
            this.till = tender.till;
            this.itemCode = "";
        }
    }
}

