/*
 * Decompiled with CFR 0.152.
 */
package AccuServerWebServers;

import AccuServerBase.ItemReportObject;
import AccuServerBase.ServerCore;
import AccuServerBase.Utility;
import POSDataObjects.Item;
import POSDataObjects.POSDataContainer;
import POSDataObjects.ReceiptPrintSetup;
import POSDataObjects.ReportItemSold;
import POSDataObjects.Reset;
import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class GrossMargin
implements ItemReportObject {
    ServerCore core = null;
    Socket socket = null;
    ReceiptPrintSetup companyInfo = null;
    POSDataContainer itemsSold = null;
    POSDataContainer itemsList = null;
    boolean byReset = false;
    Timestamp fromDate = null;
    Timestamp thruDate = null;
    Reset reset = null;
    String html = "";
    boolean export = false;
    String reportFileName = "";
    String[] itemList = null;
    String userName = "";
    static final String template = "gross_margin";

    public void initialize(ServerCore core, Socket socket, boolean export) {
        this.core = core;
        this.socket = socket;
        this.export = export;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setByReset(Reset thisReset) {
        this.reset = thisReset;
        this.byReset = true;
    }

    public void setByDates(Timestamp fromDate, Timestamp thruDate) {
        this.fromDate = fromDate;
        this.thruDate = thruDate;
        this.byReset = false;
    }

    public void setItemList(String itemList) {
        this.itemList = itemList != null && !itemList.isEmpty() ? itemList.split(";") : null;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void loadData() {
        this.companyInfo = this.core.getReceiptPrintSetup();
        ArrayList<String> itemSelectedList = null;
        if (this.itemList != null) {
            itemSelectedList = new ArrayList<String>(Arrays.asList(this.itemList));
        }
        try {
            this.itemsSold = this.reset != null ? this.getItemSoldData(this.userName, this.reset.till, this.reset.sequence, null, null, itemSelectedList) : this.getItemSoldData(this.userName, "", 0, this.fromDate, this.thruDate, itemSelectedList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.itemsList = this.core.getItemList();
    }

    public boolean getReportHtml() {
        SimpleDateFormat dateFormat = null;
        DecimalFormat currencyFormat = null;
        DecimalFormat quantityFormat = null;
        DecimalFormat priceFormat = null;
        String errors = "";
        if (this.itemsSold == null || this.itemsSold.isEmpty()) {
            this.itemsSold = new POSDataContainer();
        }
        this.html = this.export ? this.core.getWebServer().getTemplateHtml("gross_margin.tml") : this.core.getWebServer().getTemplateHtml("gross_margin.tmpl");
        if (this.html == null) {
            return false;
        }
        if (this.export) {
            String reportStylesXml = this.core.getWebServer().getReportStylesXml();
            this.html = Utility.replaceDataTag((String)this.html, (String)"ReportStylesBlock", (String)reportStylesXml);
        }
        SimpleDateFormat titleFormat = new SimpleDateFormat(this.core.getWebServer().getDateFormat());
        String runTime = titleFormat.format(new Date());
        this.html = Utility.replaceDataTag((String)this.html, (String)"DateRun", (String)runTime);
        String ranges = "";
        SimpleDateFormat rangeDate = new SimpleDateFormat(this.core.getWebServer().getDateTimeFormat());
        ranges = this.byReset ? "For Till " + this.reset.till + " Sequence " + this.reset.sequence : " " + this.core.getLiteral("From") + " " + rangeDate.format(this.fromDate) + " " + this.core.getLiteral("Through") + " " + rangeDate.format(this.thruDate);
        this.html = Utility.replaceDataTag((String)this.html, (String)"Range", (String)ranges);
        if (this.userName.isEmpty()) {
            this.html = Utility.replaceBlock((String)this.html, (String)"UserNameBlock", (String)"");
        } else {
            String userNameBlock = Utility.getDataBlockContents((String)"UserNameBlock", (String)this.html);
            userNameBlock = Utility.replaceDataTag((String)userNameBlock, (String)"UserName", (String)this.userName);
            this.html = Utility.replaceBlock((String)this.html, (String)"UserNameBlock", (String)userNameBlock);
        }
        String itemSoldBlock = Utility.getDataBlockContents((String)"ItemSoldBlock", (String)this.html);
        String lineItemsBlock = Utility.getDataBlockContents((String)"LineItemsBlock", (String)this.html);
        String dateFormatString = Utility.getDataBlockContents((String)"DateFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"DateFormat", (String)"");
        String currencyFormatString = Utility.getDataBlockContents((String)"CurrencyFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"CurrencyFormat", (String)"");
        String priceFormatString = Utility.getDataBlockContents((String)"PriceFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"PriceFormat", (String)"");
        String quantityFormatString = Utility.getDataBlockContents((String)"QuantityFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"QuantityFormat", (String)"");
        if (this.companyInfo != null) {
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyName", (String)this.companyInfo.companyName);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress1", (String)this.companyInfo.companyAddress1);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress2", (String)this.companyInfo.companyAddress2);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyCity", (String)this.companyInfo.companyCity);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyState", (String)this.companyInfo.companyState);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyZip", (String)this.companyInfo.companyZip);
        } else {
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyName", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress1", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress2", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyCity", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyState", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyZip", (String)"");
        }
        dateFormat = new SimpleDateFormat(dateFormatString);
        currencyFormat = new DecimalFormat(currencyFormatString);
        quantityFormat = new DecimalFormat(quantityFormatString);
        priceFormat = new DecimalFormat(priceFormatString);
        StringBuilder itemUserText = new StringBuilder();
        String thisItemSold = itemSoldBlock;
        StringBuilder lineItemsText = new StringBuilder();
        double grossMarginTotal = 0.0;
        int itemsLen = this.itemsSold.size();
        for (int i = 0; i < itemsLen; ++i) {
            ReportItemSold itemSold = (ReportItemSold)this.itemsSold.get(i);
            Item thisItem = this.getItemByCode(itemSold.itemId);
            if (thisItem != null && thisItem.isStock) {
                String thisLineItemsBlock = lineItemsBlock;
                double priceAverage = itemSold.amount / itemSold.quantity;
                double costAverage = itemSold.costAmount / itemSold.quantity;
                double grossMargin = itemSold.amount - itemSold.costAmount;
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ItemCode", (String)itemSold.itemId);
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"AccountingId", (String)itemSold.accountingId);
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"ItemDescription", (String)itemSold.description);
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Quantity", (String)quantityFormat.format(itemSold.quantity));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Price", (String)currencyFormat.format(priceAverage));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"Cost", (String)currencyFormat.format(costAverage));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TotalIncome", (String)currencyFormat.format(itemSold.amount));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"TotalCost", (String)currencyFormat.format(itemSold.costAmount));
                thisLineItemsBlock = Utility.replaceDataTag((String)thisLineItemsBlock, (String)"GrossMargin", (String)currencyFormat.format(grossMargin));
                lineItemsText.append(thisLineItemsBlock);
                grossMarginTotal += grossMargin;
                continue;
            }
            this.core.input("Item code " + thisItem.code + " Not found.");
        }
        thisItemSold = Utility.replaceDataTag((String)thisItemSold, (String)"GrossMarginTotal", (String)currencyFormat.format(grossMarginTotal));
        thisItemSold = Utility.replaceBlock((String)thisItemSold, (String)"LineItemsBlock", (String)lineItemsText.toString());
        itemUserText.append(thisItemSold);
        this.html = Utility.replaceBlock((String)this.html, (String)"ItemSoldBlock", (String)itemUserText.toString());
        this.html = Utility.replaceDataTag((String)this.html, (String)"Errors", (String)errors);
        if (!this.export) {
            this.core.getWebServer().sendHtmlResponse(this.socket, this.html, true, true);
        }
        this.reportFileName = this.export ? this.core.getWebServer().getReportPath() + template + ".xml" : this.core.getWebServer().getReportPath() + template + ".html";
        try {
            Utility.writeXml((String)this.reportFileName, (String)this.html);
        }
        catch (IOException ex) {
            this.core.raiseException((Exception)ex);
        }
        return true;
    }

    private Item getItemByCode(String itemId) {
        int len = this.itemsList.size();
        Item item = null;
        for (int i = 0; i < len; ++i) {
            Item thisItem = (Item)this.itemsList.get(i);
            if (!thisItem.code.equals(itemId)) continue;
            item = thisItem;
            break;
        }
        return item;
    }

    public POSDataContainer getItemSoldData(String user, String till, int sequence, Timestamp fromDate, Timestamp thruDate, ArrayList itemList) throws Exception {
        Hashtable<String, ReportItemSold> itemSoldTable = null;
        POSDataContainer result = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Statement linesStatement = null;
        ResultSet linesResultSet = null;
        try {
            itemSoldTable = new Hashtable<String, ReportItemSold>();
            result = new POSDataContainer();
            connection = this.getDatabaseConnection();
            if (connection == null) {
                POSDataContainer pOSDataContainer = result;
                return pOSDataContainer;
            }
            if (!user.isEmpty()) {
                statement = connection.prepareStatement("Select * from apcshead where serverId = ? and DateInvoiced >= ? and DateInvoiced <= ?");
                statement.setString(1, user);
                statement.setTimestamp(2, fromDate);
                statement.setTimestamp(3, thruDate);
            } else if (!till.isEmpty()) {
                statement = connection.prepareStatement("Select * from apcshead where ZTill = ? and Znum = ?");
                statement.setString(1, till);
                statement.setInt(2, sequence);
            } else {
                statement = connection.prepareStatement("Select * from apcshead where DateInvoiced >= ? and DateInvoiced <= ?");
                statement.setTimestamp(1, fromDate);
                statement.setTimestamp(2, thruDate);
            }
            resultSet = statement.executeQuery();
            linesStatement = connection.createStatement();
            String transactions = "";
            while (resultSet.next()) {
                int transaction = resultSet.getInt("Key");
                transactions = transactions + transaction + ",";
            }
            if (!(transactions = transactions.substring(0, transactions.length() - 1)).isEmpty()) {
                String linesQuery = "Select * from apcsitem where headKey In ( " + transactions + ")";
                linesResultSet = linesStatement.executeQuery(linesQuery);
                while (linesResultSet.next()) {
                    ReportItemSold itemSold;
                    String itemId = linesResultSet.getString("ItemId");
                    if (itemList != null && !itemList.isEmpty() && !itemList.contains(itemId)) continue;
                    double quantity = linesResultSet.getDouble("Quantity");
                    double total = linesResultSet.getDouble("Ext");
                    double cost = linesResultSet.getDouble("Cost");
                    double costAmount = cost * quantity;
                    if (!itemSoldTable.containsKey(itemId)) {
                        itemSold = new ReportItemSold();
                        itemSold.itemId = itemId;
                        itemSold.quantity = quantity;
                        itemSold.amount = total;
                        itemSold.costAmount = costAmount;
                        itemSoldTable.put(itemId, itemSold);
                        continue;
                    }
                    itemSold = (ReportItemSold)itemSoldTable.get(itemId);
                    itemSold.quantity += quantity;
                    itemSold.amount += total;
                    itemSold.costAmount += costAmount;
                    itemSoldTable.put(itemId, itemSold);
                }
            }
            if (!itemSoldTable.isEmpty()) {
                Enumeration e = itemSoldTable.elements();
                while (e.hasMoreElements()) {
                    ReportItemSold itemSold = (ReportItemSold)e.nextElement();
                    Item thisItem = this.core.getItemByCode(itemSold.itemId);
                    if (thisItem != null) {
                        itemSold.description = thisItem.description;
                        itemSold.accountingId = thisItem.accountingCode;
                    } else {
                        itemSold.description = "Not Found";
                        itemSold.accountingId = itemSold.itemId;
                    }
                    result.add((Object)itemSold);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (linesResultSet != null) {
                linesResultSet.close();
            }
            if (linesStatement != null) {
                linesStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return result;
    }

    public Connection getDatabaseConnection() {
        return this.core.getDatabaseConnection();
    }
}

