/*
 * Decompiled with CFR 0.152.
 */
package AccuServerTaxCalculator;

import AccuServerBase.ServerCore;
import POSDataObjects.FlexGroup;
import POSDataObjects.FlexGroupDetail;
import POSDataObjects.Item;
import POSDataObjects.LineItem;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.Tax;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class FlexGroupPriceAdjuster {
    ServerCore core = null;
    Hashtable flexGroups = null;
    Hashtable flexGroupDetail = null;

    public FlexGroupPriceAdjuster(ServerCore core) {
        this.core = core;
    }

    public void updateFlexGroupPrices(Vector lineItems) {
        int i;
        this.flexGroups = this.core.getFlexGroups();
        this.flexGroupDetail = this.core.getFlexGroupDetail();
        if (this.flexGroups == null || this.flexGroupDetail == null) {
            return;
        }
        Vector<LineItem> flexMasters = new Vector<LineItem>();
        int len = lineItems.size();
        for (i = 0; i < len; ++i) {
            LineItem thisItem = (LineItem)lineItems.get(i);
            FlexGroup thisGroup = (FlexGroup)this.flexGroups.get(thisItem.itemId);
            if (thisGroup == null || thisItem.status.equalsIgnoreCase("V") || thisItem.flexGroupMasterItem != 0 && thisItem.id != thisItem.flexGroupMasterItem || !this.flexGroupInEffect(thisGroup, thisItem.created)) continue;
            thisItem.total = (double)Math.round(thisItem.quantity * thisItem.price * 100.0) / 100.0;
            thisItem.changedPrice = "FlexGroup";
            flexMasters.add(thisItem);
        }
        if (flexMasters.size() == 0) {
            return;
        }
        len = lineItems.size();
        for (i = 0; i < len; ++i) {
            FlexGroupDetail thisGroupDetail;
            int d;
            int numDetails;
            Vector detailList;
            LineItem thisMaster;
            int m;
            int numMasters;
            LineItem thisLine = (LineItem)lineItems.get(i);
            if (!thisLine.status.equalsIgnoreCase("V") && thisLine.flexGroupMasterItem == 0) {
                numMasters = flexMasters.size();
                block2: for (m = 0; m < numMasters; ++m) {
                    thisMaster = (LineItem)flexMasters.get(m);
                    if (thisLine.masterItem > 0 && thisLine.masterItem != thisMaster.id) continue;
                    detailList = (Vector)this.flexGroupDetail.get(thisMaster.itemId + ";" + thisLine.itemId);
                    numDetails = -1;
                    if (detailList != null) {
                        numDetails = detailList.size();
                    }
                    for (d = 0; d < numDetails; ++d) {
                        boolean isFit;
                        thisGroupDetail = (FlexGroupDetail)detailList.get(d);
                        if (thisGroupDetail == null || !(isFit = this.checkMasterForFit(lineItems, thisMaster, thisGroupDetail.subGroup))) continue;
                        thisLine.price = thisGroupDetail.flexDetailPrice > 1.0E-4 ? thisGroupDetail.flexDetailPrice : 0.0;
                        if (!this.core.printZeroFlexGroupItems() && thisLine.price == 0.0) {
                            thisLine.doNotPrint = true;
                        }
                        thisLine.total = (double)Math.round(thisLine.quantity * thisLine.price * 100.0) / 100.0;
                        thisLine.changedPrice = "FlexGroup";
                        thisLine.masterItem = thisMaster.id;
                        thisLine.flexGroupMasterItem = thisMaster.id;
                        continue block2;
                    }
                }
                continue;
            }
            if (thisLine.status.equalsIgnoreCase("V") || thisLine.flexGroupMasterItem == 0 || thisLine.changedPrice.contains("FlexGroup")) continue;
            numMasters = flexMasters.size();
            block4: for (m = 0; m < numMasters; ++m) {
                thisMaster = (LineItem)flexMasters.get(m);
                if (thisLine.masterItem > 0 && thisLine.masterItem != thisMaster.id || thisLine.flexGroupMasterItem != thisMaster.id) continue;
                detailList = (Vector)this.flexGroupDetail.get(thisMaster.itemId + ";" + thisLine.itemId);
                numDetails = -1;
                if (detailList != null) {
                    numDetails = detailList.size();
                }
                for (d = 0; d < numDetails; ++d) {
                    thisGroupDetail = (FlexGroupDetail)detailList.get(d);
                    if (thisGroupDetail == null) continue;
                    thisLine.price = thisGroupDetail.flexDetailPrice > 1.0E-4 ? thisGroupDetail.flexDetailPrice : 0.0;
                    if (!this.core.printZeroFlexGroupItems() && thisLine.price == 0.0) {
                        thisLine.doNotPrint = true;
                    }
                    thisLine.total = (double)Math.round(thisLine.quantity * thisLine.price * 100.0) / 100.0;
                    thisLine.changedPrice = "FlexGroup";
                    thisLine.masterItem = thisMaster.id;
                    thisLine.flexGroupMasterItem = thisMaster.id;
                    continue block4;
                }
            }
        }
    }

    private boolean flexGroupInEffect(FlexGroup thisFlexGroup, long createdTime) {
        boolean inEffect = false;
        long localTime = new Date().getTime();
        if (thisFlexGroup != null && thisFlexGroup.startDate != null && thisFlexGroup.endDate != null && thisFlexGroup.startDate.getTime() <= localTime && thisFlexGroup.endDate.getTime() >= localTime) {
            GregorianCalendar now = new GregorianCalendar();
            now.setTimeInMillis(createdTime);
            int dayOfWeek = now.get(7);
            int minuteInDay = now.get(11) * 60 + now.get(12);
            if (thisFlexGroup.fromMinutes <= minuteInDay && thisFlexGroup.thruMinutes >= minuteInDay) {
                if (thisFlexGroup.sunday && dayOfWeek == 1) {
                    inEffect = true;
                }
                if (thisFlexGroup.monday && dayOfWeek == 2) {
                    inEffect = true;
                }
                if (thisFlexGroup.tuesday && dayOfWeek == 3) {
                    inEffect = true;
                }
                if (thisFlexGroup.wednesday && dayOfWeek == 4) {
                    inEffect = true;
                }
                if (thisFlexGroup.thursday && dayOfWeek == 5) {
                    inEffect = true;
                }
                if (thisFlexGroup.friday && dayOfWeek == 6) {
                    inEffect = true;
                }
                if (thisFlexGroup.saturday && dayOfWeek == 7) {
                    inEffect = true;
                }
            }
        }
        return inEffect;
    }

    private boolean checkMasterForFit(Vector lineItems, LineItem masterItem, int subGroup) {
        boolean isFit = false;
        Boolean[] masterGroups = this.getOccupiedSubGroups(lineItems, masterItem);
        isFit = masterGroups[subGroup] == null || masterGroups[subGroup] != true;
        return isFit;
    }

    private Boolean[] getOccupiedSubGroups(Vector lineItems, LineItem masterItem) {
        Object[] masterGroups = new Boolean[10];
        Arrays.fill(masterGroups, Boolean.FALSE);
        int len = lineItems.size();
        Vector detailList = null;
        block0: for (int i = 0; i < len; ++i) {
            LineItem thisItem = (LineItem)lineItems.get(i);
            if (thisItem.status.equalsIgnoreCase("V") || thisItem.flexGroupMasterItem != masterItem.id) continue;
            detailList = (Vector)this.flexGroupDetail.get(masterItem.itemId + ";" + thisItem.itemId);
            int numDetails = -1;
            if (detailList != null) {
                numDetails = detailList.size();
            }
            for (int d = 0; d < numDetails; ++d) {
                FlexGroupDetail currentGroupDetail = (FlexGroupDetail)detailList.get(d);
                if (((Boolean)masterGroups[currentGroupDetail.subGroup]).booleanValue() || currentGroupDetail == null) continue;
                masterGroups[currentGroupDetail.subGroup] = true;
                continue block0;
            }
        }
        return masterGroups;
    }

    public void checkFlexGroupItem(Item thisItem, long localTime) {
        FlexGroup thisFlexGroup;
        this.flexGroups = this.core.getFlexGroups();
        if (this.flexGroups != null && (thisFlexGroup = (FlexGroup)this.flexGroups.get(thisItem.code)) != null && !this.flexGroupInEffect(thisFlexGroup, localTime)) {
            thisItem.code = "*Item_Invalid*";
            thisItem.description = this.core.getLiteral("FlexGroup Item not in effect");
        }
    }

    public void checkForComboFlexItems(Order order) {
        this.flexGroups = this.core.getFlexGroups();
        this.flexGroupDetail = this.core.getFlexGroupDetail();
        if (this.flexGroups == null || this.flexGroupDetail == null) {
            return;
        }
        int len = order.lineItems.size();
        block0: for (int i = 0; i < len; ++i) {
            Vector possibleMasters;
            LineItem thisItem = (LineItem)order.lineItems.get(i);
            if (thisItem.changedPrice.contains("FlexGroup") || (possibleMasters = this.getPossibleComboFlexMasters(thisItem.itemId)) == null || possibleMasters.isEmpty()) continue;
            int numPossibleMasters = possibleMasters.size();
            for (int m = 0; m < numPossibleMasters; ++m) {
                boolean allSelected;
                boolean foundMaster = false;
                String thisPossibleMaster = (String)possibleMasters.get(m);
                FlexGroup thisMaster = (FlexGroup)this.flexGroups.get(thisPossibleMaster);
                LineItem thisFoundMaster = null;
                for (int l = 0; l < len; ++l) {
                    boolean hasSubDetails;
                    LineItem lineItem = (LineItem)order.lineItems.get(l);
                    if (lineItem.itemId.compareToIgnoreCase(thisMaster.masterItemId) != 0 || (hasSubDetails = this.checkMasterLineHasSubDetails(order.lineItems, lineItem, thisMaster))) continue;
                    thisFoundMaster = lineItem;
                    foundMaster = true;
                    break;
                }
                if (foundMaster || !(allSelected = this.checkAllSubGroupsSelected(order.lineItems, thisMaster))) continue;
                System.out.println("All Details Found - adding Flex Master");
                LineItem masterLine = new LineItem();
                Item masterItem = this.core.findItemByCode(thisMaster.masterItemId);
                masterLine.id = order.getNextLineNumber();
                masterLine.itemId = masterItem.code;
                Date now = new Date();
                masterLine.created = now.getTime();
                masterLine.displayOnRemote = true;
                masterLine.itemDescription = masterItem.description;
                masterLine.altDescription = masterItem.alternateDescription;
                masterLine.list = masterItem.list;
                masterLine.price = masterItem.price;
                masterLine.originalPrice = masterItem.price;
                masterLine.noDiscount = masterItem.noDiscount;
                if (masterLine.tax == null) {
                    masterLine.tax = new Tax();
                }
                masterLine.taxable = masterLine.tax.taxable = masterItem.taxable;
                masterLine.isAppetizer = masterItem.isAppetizer;
                masterLine.itemType = masterItem.type;
                masterLine.itemCategory = masterItem.itemCategory;
                masterLine.noPartialQuantity = masterItem.noPartialQuantity;
                masterLine.quantity = 1.0;
                masterLine.total = (double)Math.round(masterLine.price * masterLine.quantity * 100.0) / 100.0;
                masterLine.newLine = true;
                masterLine.userId = thisItem.userId;
                order.lineItems.add(masterLine);
                this.updateFlexGroupPrices(order.lineItems);
                continue block0;
            }
        }
    }

    public Vector getPossibleComboFlexMasters(String itemCode) {
        Vector<String> possibleMasters = new Vector<String>();
        POSDataContainer flexGroupDetailList = this.core.getAllFlexGroupDetail();
        int numDetails = flexGroupDetailList.size();
        for (int i = 0; i < numDetails; ++i) {
            FlexGroupDetail thisFlexGroupDetail = (FlexGroupDetail)flexGroupDetailList.get(i);
            if (thisFlexGroupDetail.detailItemId.compareToIgnoreCase(itemCode) != 0) continue;
            Date now = new Date();
            FlexGroup thisFlexMaster = (FlexGroup)this.flexGroups.get(thisFlexGroupDetail.masterItemId);
            boolean inEffect = this.flexGroupInEffect(thisFlexMaster, now.getTime());
            if (!inEffect) continue;
            possibleMasters.add(thisFlexGroupDetail.masterItemId);
        }
        return possibleMasters;
    }

    private boolean checkAllSubGroupsSelected(Vector lineItems, FlexGroup thisMaster) {
        boolean allSelected = true;
        Object[] masterGroups = new Boolean[10];
        Arrays.fill(masterGroups, Boolean.FALSE);
        int len = lineItems.size();
        block0: for (int i = 0; i < len; ++i) {
            LineItem thisItem = (LineItem)lineItems.get(i);
            if (thisItem.status.equalsIgnoreCase("V") || thisItem.changedPrice.contains("FlexGroup")) continue;
            Vector detailList = (Vector)this.flexGroupDetail.get(thisMaster.masterItemId + ";" + thisItem.itemId);
            int numDetails = -1;
            if (detailList != null) {
                numDetails = detailList.size();
            }
            for (int d = 0; d < numDetails; ++d) {
                FlexGroupDetail currentGroupDetail = (FlexGroupDetail)detailList.get(d);
                if (((Boolean)masterGroups[currentGroupDetail.subGroup - 1]).booleanValue() || currentGroupDetail == null) continue;
                masterGroups[currentGroupDetail.subGroup - 1] = true;
                continue block0;
            }
        }
        for (int g = 0; g < thisMaster.numSubGroups; ++g) {
            if (((Boolean)masterGroups[g]).booleanValue()) continue;
            allSelected = false;
            break;
        }
        return allSelected;
    }

    private boolean checkMasterLineHasSubDetails(Vector lineItems, LineItem thisFoundMaster, FlexGroup thisMaster) {
        int g;
        boolean hasSubDetails = false;
        Object[] masterGroups = new Boolean[10];
        Arrays.fill(masterGroups, Boolean.FALSE);
        for (g = 1; g < thisMaster.numSubGroups + 1; ++g) {
            boolean isFit = this.checkMasterForFit(lineItems, thisFoundMaster, g);
            if (((Boolean)masterGroups[g]).booleanValue() || isFit) continue;
            masterGroups[g] = true;
            break;
        }
        for (g = 0; g < thisMaster.numSubGroups; ++g) {
            if (!((Boolean)masterGroups[g]).booleanValue()) continue;
            hasSubDetails = true;
            break;
        }
        return hasSubDetails;
    }
}

