/*
 * Decompiled with CFR 0.152.
 */
package AccuServerMonitor;

import AccuServerBase.ServerCore;
import POSDataObjects.PrinterConfigSetup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class EditPrinterSetupScreen
extends JDialog {
    ServerCore core = null;
    int width = 0;
    int height = 0;
    boolean isOrderPrinter = true;
    PrinterConfigSetup printerSetup = null;
    CompoundBorder editBorder = null;
    Font labelFont = null;
    Font titleFont = null;
    Font editFont = null;
    Font boldFont = null;
    FontMetrics fontMetrics = null;
    JComboBox printerTypeBox = null;
    JTextField posPrinterNameEdit = null;
    JTextField printerNameEdit = null;
    JComboBox printerPOSTypeBox = null;
    JTextField printerTemplateEdit = null;
    JTextField printWidthEdit = null;
    JTextField printLengthEdit = null;
    JCheckBox summarizeItemsCheckBox = null;
    JCheckBox summarizeTaxesCheckBox = null;
    JTextField adDelayEdit = null;
    JTextField[] tipPercentagesEdit = null;
    JButton removeButton = null;
    JTextField serverTemplateEdit = null;
    JTextField resetTemplateEdit = null;
    private JPanel mainPanel;

    public EditPrinterSetupScreen(Frame parent, boolean modal, ServerCore core, int width, int height) {
        super((Frame)new JFrame(), modal);
        this.initComponents();
        this.core = core;
        this.width = width;
        this.height = height;
    }

    public void isOrderPrinter(boolean isOrderPrinter) {
        this.isOrderPrinter = isOrderPrinter;
    }

    public void setPrinterConfigSetup(PrinterConfigSetup printerSetup) {
        this.printerSetup = printerSetup;
    }

    public PrinterConfigSetup getPrinterConfigSetup() {
        return this.printerSetup;
    }

    public void displayScreen() {
        this.loadFields();
        this.loadData();
        this.toFront();
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    private void loadFields() {
        this.labelFont = new Font("Arial", 1, 16);
        this.titleFont = new Font("Arial", 1, 20);
        this.editFont = new Font("Arial", 1, 12);
        this.editBorder = new CompoundBorder(new LineBorder(Color.darkGray, 1), new EmptyBorder(0, 5, 0, 0));
        this.setSize(new Dimension(this.width, this.height));
        this.mainPanel = new JPanel();
        this.mainPanel.setBounds(0, 0, this.width, this.height);
        this.mainPanel.setBorder(new LineBorder(Color.blue, 2));
        this.mainPanel.setLayout(null);
        this.add(this.mainPanel);
        int xOffset = (int)((double)this.width * 0.025);
        int yOffset = (int)((double)this.height * 0.05);
        JLabel sectionLabel = new JLabel();
        sectionLabel = new JLabel();
        this.mainPanel.add(sectionLabel);
        if (this.isOrderPrinter) {
            sectionLabel.setText(this.core.getLiteral("Order Printer Options"));
        } else {
            sectionLabel.setText(this.core.getLiteral("Shift Printer Options"));
        }
        sectionLabel.setForeground(Color.gray);
        sectionLabel.setFont(this.titleFont);
        sectionLabel.setHorizontalAlignment(2);
        sectionLabel.setBounds(xOffset, yOffset, this.width - xOffset, 25);
        xOffset = (int)((double)this.width * 0.05);
        yOffset += (int)((double)this.height * 0.075);
        JLabel label = new JLabel();
        this.mainPanel.add(label);
        label.setText(this.core.getLiteral("Printer Type:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        int labelWidth = (int)((double)this.width * 0.2);
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        int xOffset2 = (int)((double)this.width * 0.25) + 10;
        this.printerTypeBox = new JComboBox();
        this.mainPanel.add(this.printerTypeBox);
        this.printerTypeBox.setFont(this.editFont);
        this.printerTypeBox.setBorder(null);
        int boxWidth = (int)((double)this.width * 0.2);
        this.printerTypeBox.setBounds(xOffset2, yOffset, boxWidth, 20);
        if (this.isOrderPrinter) {
            this.printerTypeBox.addItem("ClientOrderPrinter");
            this.printerTypeBox.addItem("ClientOrderPrinterVat");
        } else {
            this.printerTypeBox.addItem("ShiftReportPrinter");
            this.printerTypeBox.addItem("ShiftReportPrinterVat");
        }
        xOffset = (int)((double)this.width * 0.05);
        yOffset += (int)((double)this.height * 0.075);
        label = new JLabel();
        this.mainPanel.add(label);
        label.setText(this.core.getLiteral("Name (POS name):"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.posPrinterNameEdit = new JTextField();
        this.posPrinterNameEdit.setHorizontalAlignment(2);
        this.mainPanel.add(this.posPrinterNameEdit);
        this.posPrinterNameEdit.setFont(this.editFont);
        this.posPrinterNameEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)this.width * 0.2);
        this.posPrinterNameEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
        this.posPrinterNameEdit.addFocusListener(new MyFocusListener());
        this.posPrinterNameEdit.addKeyListener(new MyKeyListener());
        xOffset = (int)((double)this.width * 0.05);
        yOffset += (int)((double)this.height * 0.075);
        label = new JLabel();
        this.mainPanel.add(label);
        label.setText(this.core.getLiteral("Printer Name:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.printerNameEdit = new JTextField();
        this.printerNameEdit.setHorizontalAlignment(2);
        this.mainPanel.add(this.printerNameEdit);
        this.printerNameEdit.setFont(this.editFont);
        this.printerNameEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)this.width * 0.2);
        this.printerNameEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
        this.printerNameEdit.addFocusListener(new MyFocusListener());
        this.printerNameEdit.addKeyListener(new MyKeyListener());
        xOffset = (int)((double)this.width * 0.05);
        yOffset += (int)((double)this.height * 0.075);
        label = new JLabel();
        this.mainPanel.add(label);
        label.setText(this.core.getLiteral("POS Type:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.printerPOSTypeBox = new JComboBox();
        this.mainPanel.add(this.printerPOSTypeBox);
        this.printerPOSTypeBox.setFont(this.editFont);
        this.printerPOSTypeBox.setBorder(null);
        boxWidth = (int)((double)this.width * 0.1);
        this.printerPOSTypeBox.setBounds(xOffset2, yOffset, boxWidth, 20);
        this.printerPOSTypeBox.addItem("PC");
        this.printerPOSTypeBox.addItem("Mobile");
        this.printerPOSTypeBox.addItem("Server");
        this.printerPOSTypeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (EditPrinterSetupScreen.this.printerSetup != null) {
                    EditPrinterSetupScreen.this.printerSetup.changed = true;
                }
            }
        });
        xOffset = (int)((double)this.width * 0.05);
        yOffset += (int)((double)this.height * 0.075);
        if (this.isOrderPrinter) {
            label = new JLabel();
            this.mainPanel.add(label);
            label.setText(this.core.getLiteral("Receipt Template:"));
            label.setForeground(Color.gray);
            label.setFont(this.editFont);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(4);
            label.setBounds(xOffset, yOffset, labelWidth, 20);
            this.printerTemplateEdit = new JTextField();
            this.printerTemplateEdit.setHorizontalAlignment(2);
            this.mainPanel.add(this.printerTemplateEdit);
            this.printerTemplateEdit.setFont(this.editFont);
            this.printerTemplateEdit.setBorder(this.editBorder);
            boxWidth = (int)((double)this.width * 0.2);
            this.printerTemplateEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
            this.printerTemplateEdit.addFocusListener(new MyFocusListener());
            this.printerTemplateEdit.addKeyListener(new MyKeyListener());
        } else {
            label = new JLabel();
            this.mainPanel.add(label);
            label.setText(this.core.getLiteral("Server Report Template:"));
            label.setForeground(Color.gray);
            label.setFont(this.editFont);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(4);
            label.setBounds(xOffset, yOffset, labelWidth, 20);
            this.serverTemplateEdit = new JTextField();
            this.serverTemplateEdit.setHorizontalAlignment(2);
            this.mainPanel.add(this.serverTemplateEdit);
            this.serverTemplateEdit.setFont(this.editFont);
            this.serverTemplateEdit.setBorder(this.editBorder);
            boxWidth = (int)((double)this.width * 0.2);
            this.serverTemplateEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
            this.serverTemplateEdit.addFocusListener(new MyFocusListener());
            this.serverTemplateEdit.addKeyListener(new MyKeyListener());
            xOffset = (int)((double)this.width * 0.05);
            yOffset += (int)((double)this.height * 0.075);
            label = new JLabel();
            this.mainPanel.add(label);
            label.setText(this.core.getLiteral("Reset Report Template:"));
            label.setForeground(Color.gray);
            label.setFont(this.editFont);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(4);
            label.setBounds(xOffset, yOffset, labelWidth, 20);
            this.resetTemplateEdit = new JTextField();
            this.resetTemplateEdit.setHorizontalAlignment(2);
            this.mainPanel.add(this.resetTemplateEdit);
            this.resetTemplateEdit.setFont(this.editFont);
            this.resetTemplateEdit.setBorder(this.editBorder);
            boxWidth = (int)((double)this.width * 0.2);
            this.resetTemplateEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
            this.resetTemplateEdit.addFocusListener(new MyFocusListener());
            this.resetTemplateEdit.addKeyListener(new MyKeyListener());
        }
        xOffset = (int)((double)this.width * 0.05);
        yOffset += (int)((double)this.height * 0.075);
        label = new JLabel();
        this.mainPanel.add(label);
        label.setText(this.core.getLiteral("Print Width:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.printWidthEdit = new JTextField();
        this.printWidthEdit.setDocument(new JNumberFieldLimit(5));
        this.printWidthEdit.setHorizontalAlignment(2);
        this.mainPanel.add(this.printWidthEdit);
        this.printWidthEdit.setFont(this.editFont);
        this.printWidthEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)this.width * 0.05);
        this.printWidthEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
        this.printWidthEdit.addFocusListener(new MyFocusListener());
        this.printWidthEdit.addKeyListener(new MyKeyListener());
        xOffset = (int)((double)this.width * 0.05);
        yOffset += (int)((double)this.height * 0.075);
        label = new JLabel();
        this.mainPanel.add(label);
        label.setText(this.core.getLiteral("Print Length:"));
        label.setForeground(Color.gray);
        label.setFont(this.editFont);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(4);
        label.setBounds(xOffset, yOffset, labelWidth, 20);
        this.printLengthEdit = new JTextField();
        this.printLengthEdit.setDocument(new JNumberFieldLimit(5));
        this.printLengthEdit.setHorizontalAlignment(2);
        this.mainPanel.add(this.printLengthEdit);
        this.printLengthEdit.setFont(this.editFont);
        this.printLengthEdit.setBorder(this.editBorder);
        boxWidth = (int)((double)this.width * 0.05);
        this.printLengthEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
        this.printLengthEdit.addFocusListener(new MyFocusListener());
        this.printLengthEdit.addKeyListener(new MyKeyListener());
        if (this.isOrderPrinter) {
            xOffset = (int)((double)this.width * 0.05);
            yOffset += (int)((double)this.height * 0.075);
            label = new JLabel();
            this.mainPanel.add(label);
            label.setText(this.core.getLiteral("Ad Delay:"));
            label.setForeground(Color.gray);
            label.setFont(this.editFont);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(4);
            label.setBounds(xOffset, yOffset, labelWidth, 20);
            this.adDelayEdit = new JTextField();
            this.adDelayEdit.setDocument(new JNumberFieldLimit(5));
            this.adDelayEdit.setHorizontalAlignment(2);
            this.mainPanel.add(this.adDelayEdit);
            this.adDelayEdit.setFont(this.editFont);
            this.adDelayEdit.setBorder(this.editBorder);
            boxWidth = (int)((double)this.width * 0.05);
            this.adDelayEdit.setBounds(xOffset2, yOffset, boxWidth, 20);
            this.adDelayEdit.addFocusListener(new MyFocusListener());
            this.adDelayEdit.addKeyListener(new MyKeyListener());
            xOffset = (int)((double)this.width * 0.05);
            yOffset += (int)((double)this.height * 0.075);
            this.summarizeItemsCheckBox = new JCheckBox();
            this.mainPanel.add(this.summarizeItemsCheckBox);
            this.summarizeItemsCheckBox.setContentAreaFilled(false);
            this.summarizeItemsCheckBox.setText(this.core.getLiteral("Summarize Items"));
            this.summarizeItemsCheckBox.setFont(this.editFont);
            this.summarizeItemsCheckBox.setBorder(null);
            this.summarizeItemsCheckBox.setForeground(Color.gray);
            this.fontMetrics = this.summarizeItemsCheckBox.getFontMetrics(this.editFont);
            boxWidth = this.fontMetrics.stringWidth(this.summarizeItemsCheckBox.getText()) + 20;
            this.summarizeItemsCheckBox.setBounds(xOffset2, yOffset, boxWidth, 20);
            this.summarizeItemsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditPrinterSetupScreen.this.printerSetup != null) {
                        EditPrinterSetupScreen.this.printerSetup.changed = true;
                    }
                }
            });
            if (this.printerSetup != null && this.printerSetup.printerType.equalsIgnoreCase("ClientOrderPrinter")) {
                yOffset += (int)((double)this.height * 0.075);
                this.summarizeTaxesCheckBox = new JCheckBox();
                this.mainPanel.add(this.summarizeTaxesCheckBox);
                this.summarizeTaxesCheckBox.setContentAreaFilled(false);
                this.summarizeTaxesCheckBox.setText(this.core.getLiteral("Summarize Taxes"));
                this.summarizeTaxesCheckBox.setFont(this.editFont);
                this.summarizeTaxesCheckBox.setBorder(null);
                this.summarizeTaxesCheckBox.setForeground(Color.gray);
                this.fontMetrics = this.summarizeTaxesCheckBox.getFontMetrics(this.editFont);
                boxWidth = this.fontMetrics.stringWidth(this.summarizeTaxesCheckBox.getText()) + 20;
                this.summarizeTaxesCheckBox.setBounds(xOffset2, yOffset, boxWidth, 20);
                this.summarizeTaxesCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (EditPrinterSetupScreen.this.printerSetup != null) {
                            EditPrinterSetupScreen.this.printerSetup.changed = true;
                        }
                    }
                });
            }
            xOffset = (int)((double)this.width * 0.6);
            yOffset = (int)((double)this.height * 0.125);
            JPanel tipsPctPanel = new JPanel();
            tipsPctPanel.setBounds(xOffset, yOffset, (int)((double)this.width * 0.175), (int)((double)this.height * 0.4));
            tipsPctPanel.setBorder(new LineBorder(Color.DARK_GRAY, 1));
            tipsPctPanel.setLayout(null);
            this.mainPanel.add(tipsPctPanel);
            yOffset = 20;
            this.tipPercentagesEdit = new JTextField[]{new JTextField(), new JTextField(), new JTextField(), new JTextField(), new JTextField()};
            for (int i = 0; i < 5; ++i) {
                xOffset = 20;
                label = new JLabel();
                tipsPctPanel.add(label);
                label.setText(this.core.getLiteral("Tip Pct") + " " + (i + 1) + ":");
                label.setForeground(Color.gray);
                label.setFont(this.editFont);
                label.setVerticalAlignment(0);
                label.setHorizontalAlignment(4);
                labelWidth = this.fontMetrics.stringWidth(label.getText());
                label.setBounds(xOffset, yOffset, labelWidth, 20);
                xOffset += labelWidth + 5;
                this.tipPercentagesEdit[i].setHorizontalAlignment(2);
                this.tipPercentagesEdit[i].setDocument(new JNumberFieldLimit(4));
                tipsPctPanel.add(this.tipPercentagesEdit[i]);
                this.tipPercentagesEdit[i].setFont(this.editFont);
                this.tipPercentagesEdit[i].setBorder(this.editBorder);
                boxWidth = (int)((double)this.width * 0.05);
                this.tipPercentagesEdit[i].setBounds(xOffset, yOffset, boxWidth, 20);
                this.tipPercentagesEdit[i].addFocusListener(new MyFocusListener());
                this.tipPercentagesEdit[i].addKeyListener(new MyKeyListener());
                label = new JLabel();
                tipsPctPanel.add(label);
                label.setText(this.core.getLiteral("%"));
                label.setForeground(Color.gray);
                label.setFont(this.editFont);
                label.setVerticalAlignment(0);
                label.setHorizontalAlignment(4);
                label.setBounds(xOffset + boxWidth + 2, yOffset, 10, 20);
                yOffset += (int)((double)this.height * 0.075);
            }
        }
        ImageIcon buttonImage = new ImageIcon(this.core.getImage("exit-rect-106-but.aci"));
        JButton exitButton = new JButton(buttonImage);
        this.mainPanel.add(exitButton);
        exitButton.setEnabled(true);
        exitButton.setBounds((int)((double)this.width * 0.85), (int)((double)this.height * 0.95), 106, 20);
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (EditPrinterSetupScreen.this.saveData()) {
                    EditPrinterSetupScreen.this.exitScreen();
                }
            }
        });
        buttonImage = new ImageIcon(this.core.getImage("cancel-button-106x20.aci"));
        JButton cancelButton = new JButton(buttonImage);
        this.mainPanel.add(cancelButton);
        cancelButton.setEnabled(true);
        cancelButton.setBounds((int)((double)this.width * 0.7), (int)((double)this.height * 0.95), 106, 20);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (EditPrinterSetupScreen.this.printerSetup != null) {
                    EditPrinterSetupScreen.this.printerSetup.changed = false;
                    EditPrinterSetupScreen.this.printerSetup.remove = false;
                }
                EditPrinterSetupScreen.this.exitScreen();
            }
        });
        buttonImage = new ImageIcon(this.core.getImage("remove-button-106.aci"));
        this.removeButton = new JButton(buttonImage);
        this.mainPanel.add(this.removeButton);
        this.removeButton.setEnabled(true);
        this.removeButton.setBounds(10, (int)((double)this.height * 0.95), 106, 20);
        this.removeButton.setVisible(true);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (EditPrinterSetupScreen.this.printerSetup != null) {
                    EditPrinterSetupScreen.this.printerSetup.changed = true;
                    EditPrinterSetupScreen.this.printerSetup.remove = true;
                }
                EditPrinterSetupScreen.this.exitScreen();
            }
        });
        this.invalidate();
        this.repaint();
    }

    private void loadData() {
        if (this.printerSetup != null) {
            this.printerTypeBox.setSelectedItem(this.printerSetup.printerType);
            this.posPrinterNameEdit.setText(this.printerSetup.printerPOSName);
            this.printerNameEdit.setText(this.printerSetup.printerName);
            this.printerPOSTypeBox.setSelectedItem(this.printerSetup.printerPOSType);
            if (this.printerSetup.printerPrintWidth > 0) {
                this.printWidthEdit.setText("" + this.printerSetup.printerPrintWidth);
            }
            if (this.printerSetup.printerPrintLength > 0) {
                this.printLengthEdit.setText("" + this.printerSetup.printerPrintLength);
            }
            if (this.isOrderPrinter) {
                this.printerTemplateEdit.setText(this.printerSetup.printerReceiptTemplate);
                if (this.printerSetup.printerAdDelay > 0) {
                    this.adDelayEdit.setText("" + this.printerSetup.printerAdDelay);
                }
                this.summarizeItemsCheckBox.setSelected(this.printerSetup.printerSummarizeItems);
                if (this.summarizeTaxesCheckBox != null) {
                    this.summarizeTaxesCheckBox.setSelected(this.printerSetup.printerSummarizeTaxes);
                }
                for (int i = 0; i < 5; ++i) {
                    if (this.printerSetup.printerTipPercentage[i] == null) continue;
                    this.tipPercentagesEdit[i].setText(this.printerSetup.printerTipPercentage[i]);
                }
            } else {
                this.serverTemplateEdit.setText(this.printerSetup.printerServerReportTemplate);
                this.resetTemplateEdit.setText(this.printerSetup.printerResetReportTemplate);
            }
        } else {
            this.removeButton.setVisible(false);
        }
    }

    private boolean saveData() {
        if (this.printerSetup == null) {
            this.printerSetup = new PrinterConfigSetup();
            this.printerSetup.changed = true;
        }
        this.printerSetup.remove = false;
        if (this.posPrinterNameEdit.getText().trim().isEmpty()) {
            String configTitle = this.core.getLiteral("Printer Config");
            String configMsg = this.core.getLiteral("Printer POS Name must be defined.");
            JOptionPane.showMessageDialog(this, configMsg + "\n\n", configTitle, 0);
            return false;
        }
        if (this.printerNameEdit.getText().trim().isEmpty()) {
            String configTitle = this.core.getLiteral("Printer Config");
            String configMsg = this.core.getLiteral("Printer Name must be defined.");
            JOptionPane.showMessageDialog(this, configMsg + "\n\n", configTitle, 0);
            return false;
        }
        if (this.isOrderPrinter) {
            if (this.printerTemplateEdit.getText().trim().isEmpty()) {
                String configTitle = this.core.getLiteral("Printer Config");
                String configMsg = this.core.getLiteral("Order Printer Receipt config file must be defined.");
                JOptionPane.showMessageDialog(this, configMsg + "\n\n", configTitle, 0);
                return false;
            }
        } else {
            if (this.serverTemplateEdit.getText().trim().isEmpty()) {
                String configTitle = this.core.getLiteral("Printer Config");
                String configMsg = this.core.getLiteral("Shift Printer Server Report config file must be defined.");
                JOptionPane.showMessageDialog(this, configMsg + "\n\n", configTitle, 0);
                return false;
            }
            if (this.resetTemplateEdit.getText().trim().isEmpty()) {
                String configTitle = this.core.getLiteral("Printer Config");
                String configMsg = this.core.getLiteral("Shift Printer Reset Report config file must be defined.");
                JOptionPane.showMessageDialog(this, configMsg + "\n\n", configTitle, 0);
                return false;
            }
        }
        this.printerSetup.printerType = ((String)this.printerTypeBox.getSelectedItem()).trim();
        this.printerSetup.printerPOSName = this.posPrinterNameEdit.getText().trim();
        this.printerSetup.printerName = this.printerNameEdit.getText().trim();
        this.printerSetup.printerPOSType = ((String)this.printerPOSTypeBox.getSelectedItem()).trim();
        if (this.printWidthEdit.getText().trim().length() > 0) {
            this.printerSetup.printerPrintWidth = Integer.valueOf(this.printWidthEdit.getText().trim());
        }
        if (this.printLengthEdit.getText().trim().length() > 0) {
            this.printerSetup.printerPrintLength = Integer.valueOf(this.printLengthEdit.getText().trim());
        }
        if (this.isOrderPrinter) {
            this.printerSetup.printerReceiptTemplate = this.printerTemplateEdit.getText().trim();
            if (this.adDelayEdit.getText().trim().length() > 0) {
                this.printerSetup.printerAdDelay = Integer.valueOf(this.adDelayEdit.getText().trim());
            }
            this.printerSetup.printerSummarizeItems = this.summarizeItemsCheckBox.isSelected();
            if (this.summarizeTaxesCheckBox != null) {
                this.printerSetup.printerSummarizeTaxes = this.summarizeTaxesCheckBox.isSelected();
            }
            for (int i = 0; i < 5; ++i) {
                if (this.tipPercentagesEdit[i].getText().trim().isEmpty()) continue;
                this.printerSetup.printerTipPercentage[i] = this.tipPercentagesEdit[i].getText().trim();
            }
        } else {
            this.printerSetup.printerServerReportTemplate = this.serverTemplateEdit.getText().trim();
            this.printerSetup.printerResetReportTemplate = this.resetTemplateEdit.getText().trim();
        }
        return true;
    }

    private void exitScreen() {
        this.dispose();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.mainPanel.setPreferredSize(new Dimension(0, 0));
        this.mainPanel.setLayout(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPrinterSetupScreen dialog = new EditPrinterSetupScreen(new JFrame(), true, null, 400, 600);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public class JNumberFieldLimit
    extends PlainDocument {
        private int limit;

        JNumberFieldLimit(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null || str.equals("")) {
                return;
            }
            if (str.length() == 1 && !str.matches("[0-9.]")) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (EditPrinterSetupScreen.this.printerSetup != null) {
                EditPrinterSetupScreen.this.printerSetup.changed = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    class MyFocusListener
    extends FocusAdapter {
        MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            JTextComponent textField = (JTextComponent)evt.getSource();
            textField.requestFocus();
            textField.selectAll();
        }
    }
}

