/*
 * Decompiled with CFR 0.152.
 */
package AccuServerLogger;

import AccuServerBase.ServerCore;
import AccuServerLogger.AuditTrailFormatter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public class AccuServerTransactionLogger {
    private Logger logger;
    private static AccuServerTransactionLogger thisInstance = null;
    private static ServerCore core = null;
    private static String version = "";
    boolean noLog = false;

    public static AccuServerTransactionLogger getInstance(ServerCore core) {
        if (thisInstance == null) {
            thisInstance = new AccuServerTransactionLogger(core);
        }
        return thisInstance;
    }

    public AccuServerTransactionLogger(ServerCore core) {
        try {
            AccuServerTransactionLogger.core = core;
            version = core.getVersion();
            boolean append = true;
            FileHandler handler = new FileHandler("accuServerTransactionLog.xml", 65536, 1, append);
            handler.setFormatter(new AuditTrailFormatter());
            this.logger = Logger.getLogger("accuServerTransactionLog");
            this.logger.addHandler(handler);
            this.log("startup of logger");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setNoLog() {
        this.noLog = true;
    }

    public void log(String text) {
        if (this.noLog) {
            return;
        }
        Date now = new Date();
        StringBuilder msg = new StringBuilder();
        msg.append(now.toString() + " - ");
        msg.append(text + "\n");
        this.logger.info(msg.toString());
    }
}

