/*
 * Decompiled with CFR 0.152.
 */
package AccuServerLogger;

import AccuServerBase.ServerCore;
import java.io.IOException;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public class AccuServerLogger {
    private Logger logger;
    private static AccuServerLogger thisInstance = null;
    private static ServerCore core = null;
    private static String version = "";
    boolean noLog = false;

    public static AccuServerLogger getInstance(ServerCore core) {
        if (thisInstance == null) {
            thisInstance = new AccuServerLogger(core);
        }
        return thisInstance;
    }

    public AccuServerLogger(ServerCore core) {
        try {
            AccuServerLogger.core = core;
            version = core.getVersion();
            boolean append = true;
            FileHandler handler = new FileHandler("accuServerLog.xml", 65536, 2, append);
            this.logger = Logger.getLogger("accuServerLog");
            this.logger.addHandler(handler);
            this.log("startup of logger");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setNoLog() {
        this.noLog = true;
    }

    public void log(String text) {
        if (this.noLog) {
            return;
        }
        Date now = new Date();
        StringBuilder msg = new StringBuilder();
        msg.append("\nVersion - " + version + " thread count " + core.getThreadCount() + "\n");
        msg.append(now.toString() + "\n");
        msg.append(text + "\n");
        this.logger.info(msg.toString());
    }
}

