/*
 * Decompiled with CFR 0.152.
 */
package AccuServerIntegrator;

import AccuCountDataObjects.AdjustmentSession;
import AccuServerBase.AccuServerIntegratorBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import AccuServerIntegrator.AccuServerIntegratorLogger;
import AccuServerIntegrator.IntegratorStatusLogger;
import POSDataObjects.CompanySetupInfo;
import POSDataObjects.Customer;
import POSDataObjects.Item;
import POSDataObjects.LineItem;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.Reset;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Till;
import POSDataObjects.Transaction;
import POSDataObjects.TransactionReportOptions;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccuServerPriorityIntegrator
implements ServerObject,
AccuServerIntegratorBase {
    private AccuServerIntegratorLogger logger;
    private IntegratorStatusLogger statusLogger;
    ServerCore core = null;
    private CompanySetupInfo companyInfo;
    private String siteName;
    private String cashCustomerId = "";
    private String changeRoundingAccount = "";
    private POSDataContainer tenderCodes = null;
    private Transaction summaryTransaction = null;
    private LineItem summaryLine;
    private Tender summaryTender;
    Timestamp today = new Timestamp(new Date().getTime());
    private boolean importingInventory = false;
    private boolean importingCustomers = false;
    private boolean exportingSales = false;
    private boolean itemPriceUpdate = true;
    private boolean summarizeAllCashSales = true;
    private boolean debug = false;
    private boolean liveAccounting = false;
    private boolean isExportingLive = false;
    private Timestamp liveAccountingStartDate;
    private String tillSequence;
    private final DecimalFormat decimal = new DecimalFormat("00.0##");
    private final DecimalFormat decimalPercent = new DecimalFormat("00.0%");
    private final SimpleDateFormat invoiceDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String authBase64 = "";
    private String baseURL = "";
    private final String appId = "APP008";
    private final String appKey = "50DA78AB2052410AB62498D70056D8D5";
    private boolean paramsValid = true;

    public void initialize(ServerCore core, Hashtable parameters) {
        this.core = core;
        this.logger = AccuServerIntegratorLogger.getInstance((String)this.getApVersion());
        this.statusLogger = new IntegratorStatusLogger(core);
        this.pause(500L);
        this.updateParameters(parameters);
        this.getCashCustomerId();
        if (this.paramsValid) {
            core.setIntegratorHandler((AccuServerIntegratorBase)this);
            core.input(core.getLiteral("\nPriority Integrator started...\n"));
        } else {
            core.input(core.getLiteral("\nPriority Integrator NOT started\n"));
        }
    }

    public void updateParameters(Hashtable parameters) {
        String userString;
        this.baseURL = (String)parameters.get("ServerUrl");
        if (this.baseURL == null || this.baseURL.length() == 0) {
            this.baseURL = (String)parameters.get("serverUrl");
            if (this.baseURL == null && this.baseURL.length() == 0) {
                this.paramsValid = false;
                this.output("Priority Integrator: Error, ServerUrl not found.");
                return;
            }
        }
        if (!this.baseURL.startsWith("https://")) {
            this.baseURL = "https://" + this.baseURL;
        }
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
        if (!((userString = (String)parameters.get("user")) != null && userString.length() != 0 || (userString = (String)parameters.get("User")) != null && userString.length() != 0)) {
            this.paramsValid = false;
            this.output("Priority Integrator: Error, user not found.");
            return;
        }
        String passwordString = (String)parameters.get("password");
        if ((passwordString == null || passwordString.length() == 0) && (passwordString = (String)parameters.get("Password")) == null && passwordString.length() == 0) {
            this.paramsValid = false;
            this.output("Priority Integrator: Error, password not found.");
            return;
        }
        String userAndPassword = userString + ":" + passwordString;
        this.authBase64 = new String(Base64.encode(userAndPassword.getBytes()));
        String itemUpdateString = (String)parameters.get("ItemUpdate");
        if (itemUpdateString == null && itemUpdateString.length() == 0) {
            itemUpdateString = (String)parameters.get("itemUpdate");
        }
        this.itemPriceUpdate = itemUpdateString == null || itemUpdateString.length() == 0 ? true : Boolean.parseBoolean(itemUpdateString);
        String summarize = (String)parameters.get("SummarizeAllCashSales");
        this.summarizeAllCashSales = summarize == null || summarize.length() == 0 ? false : Boolean.parseBoolean(summarize);
        String debugString = (String)parameters.get("Debug");
        this.debug = debugString == null || debugString.length() == 0 ? false : Boolean.parseBoolean(debugString);
        String startDateString = (String)parameters.get("StartDate");
        try {
            int day = Integer.valueOf(startDateString.substring(0, 2));
            int month = Integer.valueOf(startDateString.substring(2, 4));
            int year = Integer.valueOf(startDateString.substring(4, 8));
            GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
            this.liveAccountingStartDate = new Timestamp(cal.getTimeInMillis());
        }
        catch (Exception e) {
            this.output("Priority Integrator: Error, StartDate not found.");
            this.liveAccountingStartDate = new Timestamp(Calendar.getInstance().getTimeInMillis());
        }
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        this.output("Priority Integrator: StartDate " + dateTimeFormat.format(this.liveAccountingStartDate));
        String liveAccountingString = (String)parameters.get("LiveAccounting");
        this.liveAccounting = liveAccountingString == null || liveAccountingString.length() == 0 ? false : Boolean.parseBoolean(liveAccountingString);
        this.siteName = this.core.getSiteName();
        int logLimit = 100;
        String actionLogLimit = (String)parameters.get("ActionLogLimit");
        if (actionLogLimit != null) {
            try {
                logLimit = Integer.valueOf(actionLogLimit);
            }
            catch (Exception ex) {
                logLimit = 100;
            }
        }
        this.statusLogger.setActionLogLimit(logLimit);
        this.core.input(this.core.getLiteral("\nPriority Integrator Parameters updated.\n"));
    }

    public JSONArray sendQuery(String queryString, String payload) {
        JSONArray value = new JSONArray();
        try {
            StringBuffer requestData = new StringBuffer();
            queryString = queryString.replace(" ", "%20");
            queryString = queryString.replace("'", "%27");
            String urlString = this.baseURL + queryString;
            SSLContext ssl_ctx = SSLContext.getInstance("TLSv1.2");
            SSLContext.setDefault(ssl_ctx);
            ssl_ctx.init(null, null, null);
            SSLSocketFactory socketFactory = ssl_ctx.getSocketFactory();
            String response = "";
            boolean done = false;
            while (!done) {
                String line;
                BufferedReader br;
                URL url = new URL(urlString);
                HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
                urlConnection.setSSLSocketFactory(socketFactory);
                urlConnection.setRequestProperty("Authorization", "Basic " + this.authBase64);
                if (!queryString.contains("LOGPART")) {
                    urlConnection.setRequestProperty("X-App-Id", "APP008");
                    urlConnection.setRequestProperty("X-App-Key", "50DA78AB2052410AB62498D70056D8D5");
                }
                if (payload != null) {
                    this.output("Request:");
                    this.output(payload);
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestProperty("Accept", "*/*");
                    urlConnection.setRequestProperty("Content-Type", "application/json;odata.metadata=minimal");
                    OutputStream os = urlConnection.getOutputStream();
                    os.write(payload.getBytes("UTF-8"));
                    os.close();
                } else {
                    urlConnection.setRequestMethod("GET");
                    urlConnection.setRequestProperty("Content-Type", "application/json");
                }
                StringBuilder sb = new StringBuilder();
                int HttpResult = urlConnection.getResponseCode();
                if (HttpResult == 200 || HttpResult == 201) {
                    br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8"));
                    line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    response = response + sb.toString();
                    JSONObject json = new JSONObject(response);
                    if (json.has("value")) {
                        value = json.getJSONArray("value");
                    } else {
                        value.put((Object)json);
                    }
                    this.output("Response:");
                    this.output(response);
                } else {
                    if (HttpResult == 401) {
                        this.output("Priority Integrator: Credentials Invalid");
                        done = true;
                    } else {
                        this.output("" + urlConnection.getResponseMessage());
                        br = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), "utf-8"));
                        line = null;
                        while ((line = br.readLine()) != null) {
                            sb.append(line + "\n");
                        }
                        this.output(sb.toString());
                        br.close();
                        this.output("" + sb.toString());
                    }
                    done = true;
                }
                if (response == null || response.isEmpty()) continue;
                done = true;
            }
            this.pause(2000L);
        }
        catch (Exception e) {
            this.output(e);
        }
        return value;
    }

    private LineItem getSummaryLineItem(LineItem lineItem) {
        LineItem foundLine = null;
        int linesLen = this.summaryTransaction.lineItems.size();
        for (int i = 0; i < linesLen; ++i) {
            LineItem thisLine = (LineItem)this.summaryTransaction.lineItems.get(i);
            if (!thisLine.itemId.equals(lineItem.itemId)) continue;
            foundLine = thisLine;
            break;
        }
        if (foundLine == null) {
            foundLine = new LineItem();
            foundLine.itemId = lineItem.itemId;
            foundLine.itemName = lineItem.itemName;
            foundLine.itemDescription = lineItem.itemDescription;
            this.summaryTransaction.lineItems.add(foundLine);
        }
        return foundLine;
    }

    private Tender getSummaryTender(Tender tender) {
        Tender foundTender = null;
        int linesLen = this.summaryTransaction.tendering.size();
        for (int i = 0; i < linesLen; ++i) {
            Tender thisTender = (Tender)this.summaryTransaction.tendering.get(i);
            if (!thisTender.code.equals(tender.code)) continue;
            foundTender = thisTender;
            break;
        }
        if (foundTender == null) {
            foundTender = new Tender();
            foundTender.code = tender.code;
            foundTender.description = tender.description;
            foundTender.glAccountNumber = tender.glAccountNumber;
            this.summaryTransaction.tendering.add(foundTender);
        }
        return foundTender;
    }

    public boolean prepareSalesExport(int sequence, String till, boolean isResend) {
        int i;
        this.core.input(this.core.getLiteral("\nPriority Integrator - Starting Sales Export"));
        this.tillSequence = till + sequence;
        POSDataContainer transactions = null;
        this.getCashCustomerId();
        this.companyInfo = this.core.getCompanySetup();
        ArrayList<String> invoicesToSend = new ArrayList<String>();
        this.summaryTransaction = new Transaction();
        Reset reset = this.core.getReset(till, sequence);
        boolean success = false;
        try {
            block18: {
                block17: {
                    try {
                        this.logger.log("get export sales transactions from the db");
                        transactions = this.core.getExportSales(sequence, till);
                    }
                    catch (Exception ex) {
                        if (!ex.getMessage().contains("Missing")) break block17;
                        this.core.input(this.core.getLiteral("\nPriority Integrator - Missing items/customers, export aborted (see Missing" + till + sequence + ".log file)"));
                        this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("Missing items/customers, Export Sales aborted...") + "(see Missing" + till + sequence + ".log file)");
                        return success;
                    }
                }
                try {
                    this.tenderCodes = this.core.getTenderCodesList();
                }
                catch (Exception ex) {
                    if (!ex.getMessage().contains("Missing")) break block18;
                    this.core.input(this.core.getLiteral("\nnPriority Integrator - Missing items/customers, export aborted (see Missing") + till + sequence + this.core.getLiteral(".log file)"));
                    this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("Missing items/customers, Export Sales aborted...") + "(see Missing" + till + sequence + ".log file)");
                    return success;
                }
            }
            this.logger.log("starting to convert sales");
            int transLen = 0;
            if (transactions != null) {
                // empty if block
            }
            transLen = transactions.size();
            for (i = 0; i < transLen; ++i) {
                Transaction thisTransaction = (Transaction)transactions.get(i);
                boolean isCash = false;
                isCash = thisTransaction.customerCode == null || thisTransaction.customerCode.isEmpty();
                this.logger.log("processing transaction :" + thisTransaction.invoice);
                boolean hasAR = false;
                boolean hasCP = false;
                int tendersLen = thisTransaction.tendering.size();
                for (int j = 0; j < tendersLen; ++j) {
                    String thisInvoice;
                    Tender thisTender = (Tender)thisTransaction.tendering.get(j);
                    TenderCode tenderCode = this.core.getTenderCode(thisTender.code);
                    if (tenderCode.tenderType.equals("A")) {
                        hasAR = true;
                        thisInvoice = this.createOrder(thisTransaction, reset, isCash, hasAR, "0005");
                        invoicesToSend.add(thisInvoice);
                        continue;
                    }
                    if (!tenderCode.tenderType.equals("Y")) continue;
                    hasCP = true;
                    thisInvoice = this.createOrder(thisTransaction, reset, isCash, hasAR, "0007");
                    invoicesToSend.add(thisInvoice);
                }
                if (isCash || this.summarizeAllCashSales && !hasAR) {
                    int j;
                    this.summaryTransaction.total += thisTransaction.total;
                    int linesLen = thisTransaction.lineItems.size();
                    for (j = 0; j < linesLen; ++j) {
                        LineItem thisLine = (LineItem)thisTransaction.lineItems.get(j);
                        this.summaryLine = this.getSummaryLineItem(thisLine);
                        this.summaryLine.vatGross += thisLine.vatGross;
                        this.summaryLine.quantity += thisLine.quantity;
                        this.summaryLine.vatTax1 += thisLine.vatTax1;
                        this.summaryLine.vatTax2 += thisLine.vatTax2;
                    }
                    for (j = 0; j < tendersLen; ++j) {
                        Tender thisTender = (Tender)thisTransaction.tendering.get(j);
                        this.summaryTender = this.getSummaryTender(thisTender);
                        this.summaryTender.amount += thisTender.amount;
                    }
                    continue;
                }
                if (hasAR && tendersLen > 1) {
                    String thisInvoice = this.createOrder(thisTransaction, reset, isCash, hasAR, "0007");
                    invoicesToSend.add(thisInvoice);
                }
                if (hasCP || hasAR) continue;
                String thisInvoice = this.createOrder(thisTransaction, reset, isCash, hasAR, "0001");
                invoicesToSend.add(thisInvoice);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (transactions == null || transactions.size() == 0) {
            this.core.input(this.core.getLiteral("\nPriority Integrator - No sales records found to export"));
            this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("No sales records found to export, Export Sales aborted..."));
            return false;
        }
        this.core.input(this.core.getLiteral("\nPriority Integrator - Exporting Sales for Till " + till + " Sequence " + sequence));
        if (this.summaryTransaction.lineItems.size() > 0) {
            String summaryInvoice = this.createOrder(this.summaryTransaction, reset, true, false, "0001");
            JSONArray responseArray = this.sendQuery("PRIT_LOADDOC", summaryInvoice);
            this.isSuccess(responseArray);
        }
        int invoicesLen = invoicesToSend.size();
        for (i = 0; i < invoicesLen; ++i) {
            String thisInvoice = (String)invoicesToSend.get(i);
            JSONArray responseArray = this.sendQuery("PRIT_LOADDOC", thisInvoice.toString());
            this.isSuccess(responseArray);
        }
        this.core.input(this.core.getLiteral("\nPriority Integrator - Finished Sales Export for Till " + till + " Sequence " + sequence));
        this.statusLogger.log(this.core.getLiteral("ExportSales"), "Completed", this.core.getLiteral("Completed, Export Sales for Sequence:") + " " + sequence + ", " + this.core.getLiteral("Till:") + " " + till);
        return success;
    }

    public String createOrder(Transaction thisTransaction, Reset reset, boolean isCash, boolean hasARTender, String loadCode) {
        this.output("\nPriority Integration - Adding Invoice for Transaction " + thisTransaction.transaction);
        JSONObject jsonInvoice = new JSONObject();
        String jsonStringInvoice = "";
        try {
            jsonInvoice.put("DOCDATE", (Object)this.invoiceDateFormat.format(reset.start));
            jsonInvoice.put("CASHNAME", (Object)this.companyInfo.tenderSummaryAcct);
            jsonInvoice.put("STATDES", (Object)"\u05d8\u05d9\u05d5\u05d8\u05d0");
            jsonInvoice.put("CURCODE", (Object)"");
            jsonInvoice.put("BRANCHNAME", (Object)"");
            jsonInvoice.put("LOCNAME", (Object)"0");
            if (this.companyInfo.qbClassExports != null) {
                jsonInvoice.put("WARHSNAME", (Object)this.companyInfo.qbClassExports);
            }
            Till till = this.core.getTillByName(reset.till);
            if (!loadCode.equals("0007")) {
                this.addItems(new Vector(thisTransaction.lineItems), jsonInvoice, till);
            }
            if (!loadCode.equals("0005")) {
                this.addPayments(new Vector(thisTransaction.tendering), jsonInvoice);
            }
            if (isCash || this.summarizeAllCashSales && !hasARTender) {
                jsonInvoice.put("BOOKNUM", (Object)this.tillSequence);
                jsonInvoice.put("SHAREDCUST", (Object)"\u05dc\u05e7\u05d5\u05d7\u05de\u05d6\u05d3\u05de\u05df");
                jsonInvoice.put("CUSTDES", (Object)"\u05dc\u05e7\u05d5\u05d7 \u05de\u05d6\u05d3\u05de\u05df");
            } else {
                jsonInvoice.put("BOOKNUM", (Object)String.valueOf(thisTransaction.invoice));
                Customer customer = this.core.getCustomerByCode(thisTransaction.customerCode);
                String phone = customer.phone.replaceAll("[^\\d.]", "");
                jsonInvoice.put("SHAREDCUST", (Object)customer.code);
                String name = customer.first.trim();
                name = name + (customer.middle.trim().isEmpty() ? "" : " " + customer.middle.trim());
                name = name + (customer.last.trim().isEmpty() ? "" : " " + customer.last.trim());
                jsonInvoice.put("CUSTDES", (Object)name);
                jsonInvoice.put("FIRMNAME", (Object)customer.companyName);
                jsonInvoice.put("ADDRESS", (Object)customer.address1);
                jsonInvoice.put("ADDRESS2", (Object)customer.address2);
                jsonInvoice.put("CITY", (Object)customer.city);
                jsonInvoice.put("PHONE1", (Object)phone);
                jsonInvoice.put("EMAIL", (Object)customer.email);
                jsonInvoice.put("ZIP", (Object)customer.zip);
                jsonInvoice.put("PHONE2", (Object)customer.fax);
                if (!customer.note.isEmpty()) {
                    JSONArray textJsonArray = new JSONArray();
                    JSONObject textJsonObject = new JSONObject();
                    textJsonObject.put("TEXT", (Object)customer.note);
                    textJsonArray.put((Object)textJsonObject);
                    jsonInvoice.put("PRIT_CUSTTEXT_SUBFORM", (Object)textJsonArray);
                }
            }
            jsonInvoice.put("LOADCODE", (Object)loadCode);
            jsonStringInvoice = this.addPritInterfaceSubform(jsonInvoice.toString());
        }
        catch (Exception ex) {
            this.output(ex);
        }
        return jsonStringInvoice;
    }

    public void exportLiveAccountingUpdate() {
        if (this.liveAccounting) {
            ExportLiveThread syncThread = new ExportLiveThread();
            syncThread.start();
        }
    }

    public Vector getCompanyInfoList() {
        return null;
    }

    private boolean isSuccess(JSONArray responseArray) {
        String successString = "";
        boolean success = false;
        try {
            if (responseArray.length() > 0) {
                success = responseArray.getJSONObject(0).has("SUCCESS") ? !(successString = responseArray.getJSONObject(0).getString("SUCCESS")).equalsIgnoreCase("N") : true;
            }
        }
        catch (Exception e) {
            this.output(e);
        }
        return success;
    }

    public String createRemoteOrderAccountsReceivable(Order order) {
        this.output("\nPriority Integration - Adding Invoice number " + order.receiptNumber);
        JSONObject jsonInvoice = new JSONObject();
        String loadCode = "0005";
        String jsonStringInvoice = "";
        Till till = this.core.getTillByName(((Tender)order.tenderings.get((int)0)).till);
        try {
            jsonInvoice.put("DOCDATE", (Object)this.invoiceDateFormat.format(order.dateInvoiced));
            jsonInvoice.put("CASHNAME", (Object)this.companyInfo.tenderSummaryAcct);
            jsonInvoice.put("STATDES", (Object)"\u05d8\u05d9\u05d5\u05d8\u05d0");
            jsonInvoice.put("CURCODE", (Object)"");
            jsonInvoice.put("BRANCHNAME", (Object)"");
            jsonInvoice.put("LOCNAME", (Object)"0");
            if (this.companyInfo.qbClassExports != null) {
                jsonInvoice.put("WARHSNAME", (Object)this.companyInfo.qbClassExports);
            }
            this.addItems(order.lineItems, jsonInvoice, till);
            this.addCustomer(order.customer, jsonInvoice);
            jsonInvoice.put("BOOKNUM", (Object)String.valueOf(order.receiptNumber));
            jsonInvoice.put("LOADCODE", (Object)loadCode);
            jsonStringInvoice = this.addPritInterfaceSubform(jsonInvoice.toString());
        }
        catch (Exception ex) {
            this.output(ex);
        }
        return jsonStringInvoice;
    }

    public String createRemoteDeliveryNote(Order order) {
        this.output("\nPriority Integration - Adding Invoice number " + order.receiptNumber);
        JSONObject jsonInvoice = new JSONObject();
        String loadCode = "0008";
        String jsonStringInvoice = "";
        TransactionReportOptions options = new TransactionReportOptions();
        options.fromDate = new Timestamp(order.dateInvoiced.getTime() - 1000L);
        options.thruDate = new Timestamp(order.dateInvoiced.getTime() + 1000L);
        options.invoiceNumber = order.receiptNumber;
        POSDataContainer transactions = this.core.getTransactionReportData(options);
        Transaction tran = (Transaction)transactions.get(0);
        Till till = this.core.getTillByName(tran.till);
        try {
            jsonInvoice.put("DOCDATE", (Object)this.invoiceDateFormat.format(order.dateInvoiced));
            jsonInvoice.put("STATDES", (Object)"\u05d8\u05d9\u05d5\u05d8\u05d0");
            jsonInvoice.put("CURCODE", (Object)"");
            jsonInvoice.put("BRANCHNAME", (Object)"");
            jsonInvoice.put("LOCNAME", (Object)"0");
            if (this.companyInfo.qbClassExports != null) {
                jsonInvoice.put("WARHSNAME", (Object)this.companyInfo.qbClassExports);
            }
            this.addItems(order.lineItems, jsonInvoice, till);
            this.addCustomer(order.customer, jsonInvoice);
            jsonInvoice.put("BOOKNUM", (Object)String.valueOf(order.receiptNumber));
            jsonInvoice.put("LOADCODE", (Object)loadCode);
            jsonStringInvoice = this.addPritInterfaceSubform(jsonInvoice.toString());
        }
        catch (Exception ex) {
            this.output(ex);
        }
        return jsonStringInvoice;
    }

    public String createRemoteOrderPayment(Order order) {
        this.output("\nPriority Integration - Adding Invoice number " + order.receiptNumber);
        JSONObject jsonInvoice = new JSONObject();
        String loadCode = "0007";
        String jsonStringInvoice = "";
        try {
            jsonInvoice.put("DOCDATE", (Object)this.invoiceDateFormat.format(order.dateInvoiced));
            jsonInvoice.put("CASHNAME", (Object)this.companyInfo.tenderSummaryAcct);
            jsonInvoice.put("STATDES", (Object)"\u05d8\u05d9\u05d5\u05d8\u05d0");
            jsonInvoice.put("CURCODE", (Object)"");
            jsonInvoice.put("BRANCHNAME", (Object)"");
            jsonInvoice.put("LOCNAME", (Object)"0");
            if (this.companyInfo.qbClassExports != null) {
                jsonInvoice.put("WARHSNAME", (Object)this.companyInfo.qbClassExports);
            }
            this.addPayments(order.tenderings, jsonInvoice);
            this.addCustomer(order.customer, jsonInvoice);
            jsonInvoice.put("BOOKNUM", (Object)String.valueOf(order.receiptNumber));
            jsonInvoice.put("LOADCODE", (Object)loadCode);
            jsonStringInvoice = this.addPritInterfaceSubform(jsonInvoice.toString());
        }
        catch (Exception ex) {
            this.output(ex);
        }
        return jsonStringInvoice;
    }

    public String createRemoteOrder(Order order) {
        this.output("\nPriority Integration - Adding Invoice number " + order.receiptNumber);
        JSONObject jsonInvoice = new JSONObject();
        String loadCode = "0001";
        String jsonStringInvoice = "";
        Till till = this.core.getTillByName(((Tender)order.tenderings.get((int)0)).till);
        try {
            jsonInvoice.put("DOCDATE", (Object)this.invoiceDateFormat.format(order.dateInvoiced));
            jsonInvoice.put("CASHNAME", (Object)this.companyInfo.tenderSummaryAcct);
            jsonInvoice.put("STATDES", (Object)"\u05d8\u05d9\u05d5\u05d8\u05d0");
            jsonInvoice.put("CURCODE", (Object)"");
            jsonInvoice.put("BRANCHNAME", (Object)"");
            jsonInvoice.put("LOCNAME", (Object)"0");
            if (this.companyInfo.qbClassExports != null) {
                jsonInvoice.put("WARHSNAME", (Object)this.companyInfo.qbClassExports);
            }
            this.addItems(order.lineItems, jsonInvoice, till);
            this.addPayments(order.tenderings, jsonInvoice);
            this.addCustomer(order.customer, jsonInvoice);
            jsonInvoice.put("BOOKNUM", (Object)String.valueOf(order.receiptNumber));
            jsonInvoice.put("LOADCODE", (Object)loadCode);
            jsonStringInvoice = this.addPritInterfaceSubform(jsonInvoice.toString());
        }
        catch (Exception ex) {
            this.output(ex);
        }
        return jsonStringInvoice;
    }

    private void addItems(Vector lineItems, JSONObject jsonInvoice, Till till) {
        try {
            JSONArray jsonItemsArray = new JSONArray();
            int itemsSize = lineItems.size();
            for (int i = 0; i < itemsSize; ++i) {
                JSONObject jsonItem = new JSONObject();
                LineItem thisItem = (LineItem)lineItems.get(i);
                Item item = this.core.getItemByCode(thisItem.itemId);
                String partName = item.accountingCode;
                if (partName == null || partName.isEmpty()) {
                    partName = thisItem.itemId;
                }
                jsonItem.put("PARTNAME", (Object)partName);
                jsonItem.put("QUANT", thisItem.quantity);
                double totalPrice = (long)(thisItem.vatGross * 100.0);
                jsonItem.put("TOTPRICE", totalPrice / 100.0);
                jsonItem.put("COSTCNAME", (Object)till.glDepartment);
                jsonItemsArray.put((Object)jsonItem);
            }
            jsonInvoice.put("PRIT_DOCLINE_SUBFORM", (Object)jsonItemsArray);
        }
        catch (Exception e) {
            this.output(e);
        }
    }

    private void addPayments(Vector tenderings, JSONObject jsonInvoice) {
        try {
            JSONArray jsonTendersArray = new JSONArray();
            JSONArray jsonTenders2Array = new JSONArray();
            double cashTotal = 0.0;
            int tendersLen = tenderings.size();
            for (int i = 0; i < tendersLen; ++i) {
                JSONObject jsonTender;
                Tender thisTender = (Tender)tenderings.get(i);
                TenderCode tenderCode = this.core.getTenderCode(thisTender.code);
                if (tenderCode.tenderType.equals("P") || tenderCode.tenderType.equals("X")) {
                    cashTotal = (cashTotal * 100.0 + thisTender.amount * 100.0) / 100.0;
                    continue;
                }
                if (tenderCode.tenderType.equals("$")) {
                    String check;
                    String account;
                    String branch;
                    jsonTender = new JSONObject();
                    Hashtable checkDetails = this.getCheckDetails(thisTender.responseData);
                    String date = (String)checkDetails.get("CheckDate");
                    date = date.replaceAll("/", "");
                    String day = date.substring(0, 2);
                    String month = date.substring(2, 4);
                    String year = "20" + date.substring(4, 6);
                    jsonTender.put("PAYDATE", (Object)(year + "-" + month + "-" + day));
                    String bank = (String)checkDetails.get("BankNumber");
                    if (bank != null && !bank.isEmpty()) {
                        jsonTender.put("BANK", (Object)bank);
                    }
                    if ((branch = (String)checkDetails.get("BranchNumber")) != null && !branch.isEmpty()) {
                        jsonTender.put("BANKBRANCH", (Object)branch);
                    }
                    if ((account = (String)checkDetails.get("AccountNumber")) != null && !account.isEmpty()) {
                        jsonTender.put("PAYACCOUNT", (Object)account);
                    }
                    if ((check = (String)checkDetails.get("CheckNumber")) != null && !check.isEmpty()) {
                        jsonTender.put("CARDNUM", (Object)check);
                    }
                    jsonTender.put("QPRICE", thisTender.amount);
                    jsonTender.put("PAYTYPE", (Object)tenderCode.glAccount);
                    jsonTenders2Array.put((Object)jsonTender);
                    continue;
                }
                if (tenderCode.tenderType.equals("X")) continue;
                jsonTender = new JSONObject();
                if (tenderCode.tenderType.equals("D")) {
                    String cardNum = this.getCreditCardDetail(thisTender.responseData, "\u05de\u05e1\u05e4\u05e8");
                    int curdNumLen = cardNum.length();
                    cardNum = "************" + cardNum.substring(curdNumLen - 4, curdNumLen);
                    jsonTender.put("CARDNUM", (Object)cardNum);
                    String paymentCodeString = this.getCreditCardDetail(thisTender.responseData, "NumberPayments");
                    try {
                        int paymentCode = Integer.valueOf(paymentCodeString);
                        jsonTender.put("PAYMENTNUM", paymentCode);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                jsonTender.put("PAYTYPE", (Object)tenderCode.glAccount);
                jsonTender.put("QPRICE", thisTender.amount);
                jsonTendersArray.put((Object)jsonTender);
            }
            if (cashTotal > 0.0) {
                jsonInvoice.put("SUM1", cashTotal);
                jsonInvoice.put("CASHEXCEPTFLAG", (Object)"Y");
            } else if (cashTotal < 0.0) {
                JSONObject jsonTender = new JSONObject();
                jsonTender.put("PAYTYPE", (Object)"01");
                jsonTender.put("PAYMENTNUM", 1);
                jsonTender.put("QPRICE", cashTotal);
                jsonTendersArray.put((Object)jsonTender);
            }
            jsonInvoice.put("PRIT_LOADPAY_SUBFORM", (Object)jsonTendersArray);
            jsonInvoice.put("PRIT_LOADPAY2_SUBFORM", (Object)jsonTenders2Array);
        }
        catch (Exception e) {
            this.output(e);
        }
    }

    private void addCustomer(Customer customer, JSONObject jsonInvoice) {
        try {
            if (customer == null) {
                jsonInvoice.put("SHAREDCUST", (Object)"\u05dc\u05e7\u05d5\u05d7\u05de\u05d6\u05d3\u05de\u05df");
                jsonInvoice.put("CUSTDES", (Object)"\u05dc\u05e7\u05d5\u05d7 \u05de\u05d6\u05d3\u05de\u05df");
            } else {
                jsonInvoice.put("SHAREDCUST", (Object)customer.code);
                String name = customer.first.trim();
                name = name + (customer.middle.trim().isEmpty() ? "" : " " + customer.middle.trim());
                name = name + (customer.last.trim().isEmpty() ? "" : " " + customer.last.trim());
                jsonInvoice.put("CUSTDES", (Object)name);
                jsonInvoice.put("FIRMNAME", (Object)customer.companyName);
                jsonInvoice.put("ADDRESS", (Object)customer.address1);
                jsonInvoice.put("ADDRESS2", (Object)customer.address2);
                jsonInvoice.put("CITY", (Object)customer.city);
                String phone = customer.phone.replaceAll("[^\\d.]", "");
                jsonInvoice.put("PHONE1", (Object)phone);
                jsonInvoice.put("EMAIL", (Object)customer.email);
                jsonInvoice.put("ZIP", (Object)customer.zip);
                jsonInvoice.put("PHONE2", (Object)customer.fax);
                if (!customer.note.isEmpty()) {
                    JSONArray textJsonArray = new JSONArray();
                    JSONObject textJsonObject = new JSONObject();
                    textJsonObject.put("TEXT", (Object)customer.note);
                    textJsonArray.put((Object)textJsonObject);
                    jsonInvoice.put("PRIT_CUSTTEXT_SUBFORM", (Object)textJsonArray);
                }
            }
        }
        catch (Exception e) {
            this.output(e);
        }
    }

    private Hashtable getCheckDetails(String xml) {
        String[] tenderFields = new String[]{Utility.getElement((String)"TenderField1", (String)xml), Utility.getElement((String)"TenderField2", (String)xml), Utility.getElement((String)"TenderField3", (String)xml), Utility.getElement((String)"TenderField4", (String)xml), Utility.getElement((String)"TenderField5", (String)xml)};
        Hashtable<String, String> values = new Hashtable<String, String>();
        for (int j = 0; j < 5; ++j) {
            String fieldName = Utility.getElement((String)"FieldName", (String)tenderFields[j]);
            if (fieldName.equalsIgnoreCase(this.core.getLiteral("BankNumber"))) {
                values.put("BankNumber", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
                continue;
            }
            if (fieldName.equalsIgnoreCase(this.core.getLiteral("BranchNumber"))) {
                values.put("BranchNumber", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
                continue;
            }
            if (fieldName.equalsIgnoreCase(this.core.getLiteral("AccountNumber"))) {
                values.put("AccountNumber", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
                continue;
            }
            if (fieldName.equalsIgnoreCase(this.core.getLiteral("CheckNumber"))) {
                values.put("CheckNumber", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
                continue;
            }
            if (!fieldName.equalsIgnoreCase(this.core.getLiteral("CheckDate"))) continue;
            values.put("CheckDate", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
        }
        return values;
    }

    private String getCreditCardDetail(String xml, String fieldName) {
        String value = "";
        xml = Utility.getElement((String)"PrintData", (String)xml);
        Vector receiptLines = Utility.getElementList((String)"ReceiptLine", (String)xml);
        int receiptLinesLen = receiptLines.size();
        for (int i = 0; i < receiptLinesLen; ++i) {
            String thisLine = (String)receiptLines.get(i);
            String thisLable = Utility.getElement((String)"ReceiptLabel", (String)thisLine);
            if (!thisLable.equals(fieldName)) continue;
            value = Utility.getElement((String)"ReceiptField", (String)thisLine);
            break;
        }
        return value;
    }

    private void createJournal() {
    }

    private boolean updateInventory(Order order) {
        boolean success = false;
        this.output("\nPriority Integration - Updating Inventory for Order Id " + order.orderId);
        JSONObject jsonInvoice = new JSONObject();
        try {
            jsonInvoice.put("LOADCODE", (Object)"0004");
            int itemsLen = order.lineItems.size();
            for (int i = 0; i < itemsLen; ++i) {
                LineItem thisLineItem = (LineItem)order.lineItems.get(i);
                Item item = this.core.getItemByCode(thisLineItem.itemId);
                jsonInvoice.put("", (Object)item.code);
                jsonInvoice.put("", item.onHand);
                jsonInvoice.put("", (Object)this.companyInfo.qbClassExports);
            }
            String jsonPayload = this.addPritInterfaceSubform(jsonInvoice.toString());
            JSONArray response = this.sendQuery("{query}", jsonPayload);
            success = this.isSuccess(response);
        }
        catch (Exception e) {
            this.output(e);
        }
        return success;
    }

    private String addPritInterfaceSubform(String jsonString) {
        String pritInterfaceSubform = ",\"PRIT_INTERFACE_SUBFORM\": [{\"EXECUTE\":\"Y\"}]";
        int index = jsonString.length() - 1;
        StringBuffer resString = new StringBuffer(jsonString);
        resString.insert(index, pritInterfaceSubform);
        return resString.toString();
    }

    public void output(String output) {
        System.out.println(output);
        if (this.debug) {
            this.logger.log(output);
            if (output.length() > 1000) {
                output = output.substring(0, 1000);
            }
            this.core.input(output);
        }
    }

    public void processHostAccountingRequest(String soapActionLine, String accountingRequest) {
    }

    public void processHostAccountingResponse(String action, String data) {
    }

    public void output(Exception ex) {
        this.logger.log(ex);
    }

    public int getType() {
        return 27;
    }

    public boolean checkExistingRequest() {
        if (this.debug) {
            String log = "importingInventory " + this.importingInventory + "\r\n" + "importingCustomers " + this.importingCustomers + "\r\n" + "exportingSales " + this.exportingSales + "\r\n";
            this.core.input(log);
            this.statusLogger.log("checkExistingRequest", "", log);
            this.statusLogger.log("checkExistingRequest", "", "Entering Method " + Thread.currentThread().getStackTrace()[1].getMethodName() + " called from " + Thread.currentThread().getStackTrace()[2].getMethodName());
        }
        return this.importingInventory || this.importingCustomers || this.exportingSales;
    }

    public boolean importInventory() {
        POSDataContainer items;
        System.out.println("Import Items");
        this.logger.log("Import Items");
        this.statusLogger.log(this.core.getLiteral("ImportItems"), "Started", this.core.getLiteral("Import Items Started"));
        if (this.importingInventory) {
            return false;
        }
        boolean success = false;
        this.importingInventory = true;
        String inventoryQuery = "LOGPART?$filter=PRIT_NOTFORSALECASH ne 'Y'&$select=PARTNAME,PARTDES,PRIT_PARTCASHREGDES,BARCODE,FTCODE,FTNAME,FAMILYNAME,FAMILYDES,PUNITNAME,PRIT_PUNITDES,PRIT_NOTFORSALECASH,BASEPLPRICE,SPEC1,SPEC2,SERNFLAG,STATDES,PRIT_TAXGROUPCODE,PRIT_PACKCODE,PRIT_PACKNAME,INACTIVE&$expand=PARTPACK_SUBFORM($select=PACKCODE,PACKNAME),LOGCOUNTERS_SUBFORM($select=BALANCE,DIFF),PRIT_PARTBALANCE_SUBFORM";
        JSONArray odata = this.sendQuery(inventoryQuery, null);
        success = this.isSuccess(odata);
        if (success && (items = this.getItems(odata)) != null) {
            this.core.saveAllItems(items, true);
        }
        this.importingInventory = false;
        return success;
    }

    public boolean importCustomers() {
        POSDataContainer customers;
        this.output("Requesting Customers...");
        boolean success = false;
        if (this.checkExistingRequest()) {
            return false;
        }
        this.importingCustomers = true;
        String query = "CUSTOMERS?$select=CUSTNAME,CUSTDES,PRIT_FIRMNAME,PHONE,FAX,EMAIL,ADDRESS,ADDRESS2,ADDRESS3,STATEA,ZIP,PRIT_BALANCE3,PRIT_CODE,PRIT_OBLIGO_DIFF,PRIT_OBCODE,STATDES,CTYPECODE&$expand=CUSTOMERSTEXT_SUBFORM";
        JSONArray odata = this.sendQuery(query, null);
        success = this.isSuccess(odata);
        if (success && (customers = this.getCustomers(odata)) != null) {
            this.core.saveAllCustomers(customers);
        }
        this.importingCustomers = false;
        return success;
    }

    private POSDataContainer getCustomers(JSONArray odata) {
        POSDataContainer customers = new POSDataContainer();
        JSONObject jsonCustomer = null;
        int length = odata.length();
        for (int i = 0; i < length; ++i) {
            try {
                jsonCustomer = (JSONObject)odata.get(i);
                String customerId = this.optString(jsonCustomer, "CUSTNAME");
                if (customerId == this.cashCustomerId) continue;
                Customer customer = new Customer();
                customer.code = this.optString(jsonCustomer, "CUSTNAME");
                customer.contact = customer.first = this.optString(jsonCustomer, "CUSTDES");
                customer.companyName = this.optString(jsonCustomer, "PRIT_FIRMNAME");
                customer.phone = this.optString(jsonCustomer, "PHONE");
                customer.email = this.optString(jsonCustomer, "EMAIL");
                customer.address1 = this.optString(jsonCustomer, "ADDRESS");
                customer.address2 = this.optString(jsonCustomer, "ADDRESS2");
                customer.city = this.optString(jsonCustomer, "STATEA");
                customer.zip = this.optString(jsonCustomer, "ZIP");
                customer.fax = this.optString(jsonCustomer, "FAX");
                customer.balance = jsonCustomer.optDouble("PRIT_BALANCE3");
                customer.creditLimit = jsonCustomer.optDouble("PRIT_OBLIGO_DIFF");
                customer.type = this.optString(jsonCustomer, "CTYPECODE");
                customer.uploaded = true;
                customers.add((Object)customer);
                continue;
            }
            catch (JSONException e) {
                this.output("Error importing customer");
                if (jsonCustomer != null) {
                    this.output(jsonCustomer.toString());
                }
                this.output((Exception)((Object)e));
            }
        }
        return customers;
    }

    private void getCashCustomerId() {
        if (this.debug) {
            this.core.input("Priority Integrator: Getting Cash Customer Id...");
        }
        try {
            JSONArray customersJson = this.sendQuery("CUSTOMERS?$filter=CUSTNAME eq '\u05dc\u05e7\u05d5\u05d7\u05de\u05d6\u05d3\u05de\u05df'", null);
            this.cashCustomerId = "";
            if (customersJson.length() > 0) {
                JSONObject thisCustomer = customersJson.getJSONObject(0);
                this.cashCustomerId = thisCustomer.optString("CUSTNAME");
            }
            if (this.cashCustomerId.isEmpty()) {
                JSONObject jsonCustomer = new JSONObject();
                jsonCustomer.put("LOADCODE", (Object)"3141");
                jsonCustomer.put("SHAREDCUST", (Object)"\u05dc\u05e7\u05d5\u05d7\u05de\u05d6\u05d3\u05de\u05df");
                jsonCustomer.put("CUSTDES", (Object)"\u05dc\u05e7\u05d5\u05d7 \u05de\u05d6\u05d3\u05de\u05df");
                String jsonPayload = this.addPritInterfaceSubform(jsonCustomer.toString());
                JSONArray jSONArray = this.sendQuery("PRIT_LOADDOC", jsonPayload);
            }
        }
        catch (JSONException ex) {
            this.output("Priority Integrator: Error Getting Cash Customer Id");
            this.output((Exception)((Object)ex));
        }
    }

    private POSDataContainer getItems(JSONArray odata) {
        POSDataContainer items = new POSDataContainer();
        JSONObject jsonItem = null;
        int length = odata.length();
        try {
            for (int i = 0; i < length; ++i) {
                jsonItem = (JSONObject)odata.get(i);
                String barcode = this.optString(jsonItem, "BARCODE", null);
                String partName = jsonItem.optString("PARTNAME");
                Item item = null;
                if (barcode != null) {
                    item = this.core.getItemByCode(barcode);
                }
                if (item == null) {
                    item = this.core.getItemByCode(partName);
                }
                boolean isNewItem = false;
                if (item == null) {
                    item = new Item();
                    isNewItem = true;
                }
                item.imported = true;
                item.changed = true;
                item.updated = this.today;
                if (isNewItem) {
                    if (barcode != null && !barcode.isEmpty()) {
                        item.code = barcode;
                        item.accountingCode = partName;
                    } else {
                        item.code = item.accountingCode = partName;
                    }
                }
                item.description = jsonItem.optString("PARTDES", "");
                item.alternateDescription = this.optString(jsonItem, "PRIT_PARTCASHREGDES");
                if (item.alternateDescription.isEmpty()) {
                    item.alternateDescription = item.description;
                }
                item.inactive = jsonItem.optString("INACTIVE").equals("Y");
                item.itemCategory = this.optString(jsonItem, "FTNAME");
                item.type = jsonItem.optString("FAMILYDES", "");
                item.cost = jsonItem.optDouble("COST");
                JSONArray logCountersSubform = jsonItem.getJSONArray("LOGCOUNTERS_SUBFORM");
                if (logCountersSubform != null && logCountersSubform.length() > 0) {
                    item.onHand = logCountersSubform.getJSONObject(0).optDouble("DIFF");
                }
                item.scale = jsonItem.optBoolean("SPEC1");
                item.noDiscount = !jsonItem.optBoolean("SPEC2", true);
                String string = item.vatCode = jsonItem.optString("PRIT_TAXGROUPCODE").equals("999") ? "\u05e4\u05d8\u05d5\u05e8" : "\u05de\u05e2\u05de";
                if (this.itemPriceUpdate || isNewItem) {
                    item.price4 = item.price5 = jsonItem.optDouble("BASEPLPRICE");
                    item.price3 = item.price5;
                    item.price2 = item.price5;
                    item.price1 = item.price5;
                    item.price = item.price5;
                }
                item.quantity = this.getInventory(jsonItem);
                items.add((Object)item);
            }
        }
        catch (JSONException e) {
            this.output("Error importing item");
            if (jsonItem != null) {
                this.output(jsonItem.toString());
            }
            this.output((Exception)((Object)e));
        }
        return items;
    }

    private double getInventory(JSONObject odata) {
        double value = 0.0;
        try {
            JSONArray jsonArray = odata.getJSONArray("LOGCOUNTERS_SUBFORM");
            if (jsonArray.length() > 0) {
                JSONObject jsonObject = (JSONObject)jsonArray.get(0);
                value = jsonObject.optDouble("BALANCE");
            }
        }
        catch (JSONException e) {
            this.output("Error getting inventory");
            this.output(odata.toString());
        }
        return value;
    }

    public boolean exportNewItems() {
        return false;
    }

    public boolean exportSales(int sequence, String till, boolean isResend) {
        if (this.liveAccounting) {
            this.exportLiveAccountingUpdate();
            return true;
        }
        System.out.println("Export Sales");
        this.logger.log("Exporting Sales");
        this.statusLogger.log(this.core.getLiteral("ExportSales"), "Started", this.core.getLiteral("Export Sales Started, Sequence:") + " " + sequence + ", " + this.core.getLiteral("Till:") + " " + till);
        if (this.checkExistingRequest()) {
            return false;
        }
        if (this.exportingSales) {
            return false;
        }
        this.exportingSales = true;
        ExportSalesThread export = new ExportSalesThread(sequence, till, isResend);
        export.start();
        return true;
    }

    public boolean exportItemAdjustments(AdjustmentSession as) {
        return false;
    }

    public boolean exportItemReceipts(Vector vector) {
        return false;
    }

    public void importReset() {
    }

    public void setSiteName(String string) {
    }

    public boolean importEmployees(boolean bln) {
        return false;
    }

    public boolean exportTimes(ArrayList al) {
        return false;
    }

    public String getEncryptKey() {
        return null;
    }

    public boolean isDisableCustomerBalance() {
        return false;
    }

    public void disconnectAuth() {
    }

    public String[] getIdAndSecret(String string) {
        return null;
    }

    private String getApVersion() {
        String version = this.decimal.format(this.core.getApVersion());
        return version;
    }

    private void pause(long delay) {
        try {
            Thread.currentThread();
            Thread.sleep(delay);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void handleException(Exception e) {
        this.core.raiseException(e);
    }

    private String optString(JSONObject json, String key) {
        String value = "";
        try {
            if (!json.isNull(key)) {
                value = json.getString(key);
            }
        }
        catch (JSONException e) {
            this.output((Exception)((Object)e));
        }
        return value;
    }

    private String optString(JSONObject json, String key, String defualtValue) {
        String value = defualtValue;
        try {
            if (!json.isNull(key)) {
                value = json.getString(key);
            }
        }
        catch (JSONException e) {
            this.output((Exception)((Object)e));
        }
        return value;
    }

    class ExportLiveThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AccuServerPriorityIntegrator.this.isExportingLive) {
                return;
            }
            try {
                AccuServerPriorityIntegrator.this.isExportingLive = true;
                AccuServerPriorityIntegrator.this.core.input("Priority Integration: Starting Export Live...");
                AccuServerPriorityIntegrator.this.companyInfo = AccuServerPriorityIntegrator.this.core.getCompanySetup();
                POSDataContainer updateOrders = AccuServerPriorityIntegrator.this.core.getLiveAccountingUpdateOrders(AccuServerPriorityIntegrator.this.liveAccountingStartDate);
                int numOrders = updateOrders.size();
                int exportedOrders = 0;
                for (int i = 0; i < numOrders; ++i) {
                    Order thisOrder = (Order)updateOrders.get(i);
                    if (thisOrder.originalInvoiceNumber > 0) continue;
                    try {
                        JSONArray responseArray;
                        boolean success = true;
                        int tendersLen = thisOrder.tenderings.size();
                        boolean hasAR = false;
                        boolean hasCP = false;
                        boolean hasCashReturn = false;
                        double orderTenderTotal = 0.0;
                        for (int j = 0; j < tendersLen; ++j) {
                            JSONArray responseArray2;
                            String remoteOrder;
                            Tender thisTender = (Tender)thisOrder.tenderings.get(j);
                            if (thisTender.status.equals("V")) continue;
                            if (thisTender.type.equals("A")) {
                                remoteOrder = AccuServerPriorityIntegrator.this.createRemoteOrderAccountsReceivable(thisOrder);
                                responseArray2 = AccuServerPriorityIntegrator.this.sendQuery("PRIT_LOADDOC", remoteOrder);
                                success = success && AccuServerPriorityIntegrator.this.isSuccess(responseArray2);
                                hasAR = true;
                                continue;
                            }
                            if (thisTender.type.equals("Y")) {
                                remoteOrder = AccuServerPriorityIntegrator.this.createRemoteOrderPayment(thisOrder);
                                responseArray2 = AccuServerPriorityIntegrator.this.sendQuery("PRIT_LOADDOC", remoteOrder);
                                success = success && AccuServerPriorityIntegrator.this.isSuccess(responseArray2);
                                hasCP = true;
                                continue;
                            }
                            if (thisTender.amount < 0.0 && thisTender.type.equals("P") && !thisTender.status.equals("X")) {
                                remoteOrder = AccuServerPriorityIntegrator.this.createRemoteOrderAccountsReceivable(thisOrder);
                                responseArray2 = AccuServerPriorityIntegrator.this.sendQuery("PRIT_LOADDOC", remoteOrder);
                                success = success && AccuServerPriorityIntegrator.this.isSuccess(responseArray2);
                                hasCashReturn = true;
                                continue;
                            }
                            orderTenderTotal += thisTender.amount;
                        }
                        if (hasAR && tendersLen > 1 || hasCashReturn) {
                            String remoteOrder = AccuServerPriorityIntegrator.this.createRemoteOrderPayment(thisOrder);
                            responseArray = AccuServerPriorityIntegrator.this.sendQuery("PRIT_LOADDOC", remoteOrder);
                            boolean bl = success = success && AccuServerPriorityIntegrator.this.isSuccess(responseArray);
                        }
                        if (!hasCP && !hasAR && !hasCashReturn && orderTenderTotal > 0.0) {
                            String remoteOrder = AccuServerPriorityIntegrator.this.createRemoteOrder(thisOrder);
                            responseArray = AccuServerPriorityIntegrator.this.sendQuery("PRIT_LOADDOC", remoteOrder);
                            boolean bl = success = success && AccuServerPriorityIntegrator.this.isSuccess(responseArray);
                        }
                        if (tendersLen == 0 || orderTenderTotal == 0.0) {
                            String remoteOrder = AccuServerPriorityIntegrator.this.createRemoteDeliveryNote(thisOrder);
                            responseArray = AccuServerPriorityIntegrator.this.sendQuery("PRIT_LOADDOC", remoteOrder);
                            boolean bl = success = success && AccuServerPriorityIntegrator.this.isSuccess(responseArray);
                        }
                        if (success) {
                            Date updateDate = new Date();
                            Timestamp updateTimestamp = new Timestamp(updateDate.getTime());
                            AccuServerPriorityIntegrator.this.core.updateLiveAccountingTimeStamp(thisOrder.orderNumber, updateTimestamp);
                            AccuServerPriorityIntegrator.this.output("Priority Integrator: invoice " + thisOrder.receiptNumber + " exported successfully.");
                            ++exportedOrders;
                            continue;
                        }
                        AccuServerPriorityIntegrator.this.output("Priority Integrator: error exporting invoice " + thisOrder.receiptNumber);
                        continue;
                    }
                    catch (Exception e) {
                        AccuServerPriorityIntegrator.this.output("Priority Integrator: Error exporting invoice " + thisOrder.receiptNumber);
                        AccuServerPriorityIntegrator.this.output(e);
                    }
                }
                AccuServerPriorityIntegrator.this.core.input("Total Exported " + exportedOrders + " Orders.");
            }
            catch (Exception e) {
                AccuServerPriorityIntegrator.this.output(e);
            }
            finally {
                AccuServerPriorityIntegrator.this.isExportingLive = false;
            }
        }
    }

    private class ExportSalesThread
    extends Thread {
        private int sequence;
        private String till;
        private boolean isResend;

        public ExportSalesThread(int sequence, String till, boolean isResend) {
            this.sequence = sequence;
            this.till = till;
            this.isResend = isResend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AccuServerPriorityIntegrator.this.prepareSalesExport(this.sequence, this.till, this.isResend);
            }
            catch (Exception ex) {
                AccuServerPriorityIntegrator.this.handleException(ex);
            }
            finally {
                AccuServerPriorityIntegrator.this.exportingSales = false;
            }
        }
    }
}

