/*
 * Decompiled with CFR 0.152.
 */
package AccuServerConnector;

import AccuServerBase.Utility;
import AccuServerConnector.WebSocketHost;
import POSDataObjects.DisplayOrder;
import POSDataObjects.DisplayPrinter;
import POSDataObjects.POSDataContainer;
import org.java_websocket.WebSocket;

public class WebSocketRequestHandler
extends Thread {
    WebSocketHost host = null;
    private WebSocket client;
    private String message;

    WebSocketRequestHandler(WebSocketHost host, WebSocket client, String message) {
        this.client = client;
        this.message = message;
        this.host = host;
    }

    @Override
    public void run() {
        String action = Utility.getElement((String)"Action", (String)this.message);
        System.out.println("Action " + action);
        if (action.equalsIgnoreCase("GetLiterals")) {
            String literalsXml = this.host.core.getLiterals();
            this.sendReply("GetLiterals", literalsXml, "OK");
        } else if (action.equalsIgnoreCase("GetRemoteDisplays")) {
            POSDataContainer remoteDisplays = this.host.core.getRemoteDisplays();
            String remoteDisplayString = "";
            int numDisplays = 0;
            if (remoteDisplays != null) {
                numDisplays = remoteDisplays.size();
            }
            for (int i = 0; i < numDisplays; ++i) {
                DisplayPrinter thisDisplayPrinter = (DisplayPrinter)remoteDisplays.get(i);
                remoteDisplayString = remoteDisplayString + thisDisplayPrinter.toXml();
            }
            this.sendReply("GetRemoteDisplays", remoteDisplayString.toString(), "OK");
        } else if (action.equalsIgnoreCase("GetRemoteOrders")) {
            String displayName = Utility.getElement((String)"DisplayName", (String)this.message);
            POSDataContainer remoteOrders = this.host.core.getRemoteDisplayOrders(displayName);
            String remoteOrdersString = "";
            int numOrders = 0;
            if (remoteOrders != null) {
                numOrders = remoteOrders.size();
            }
            for (int i = 0; i < numOrders; ++i) {
                DisplayOrder thisDisplayOrder = (DisplayOrder)remoteOrders.get(i);
                remoteOrdersString = remoteOrdersString + thisDisplayOrder.toXml();
            }
            this.sendReply("GetRemoteOrders", remoteOrdersString.toString(), "OK");
        } else if (action.equalsIgnoreCase("UpdateOrderProcessStatus")) {
            int orderNumber = Utility.getIntElement((String)"OrderNumber", (String)this.message);
            String processStatus = Utility.getElement((String)"ProcessStatus", (String)this.message);
            this.host.core.updateOrderProcessStatus(orderNumber, 0, processStatus);
        } else if (action.equalsIgnoreCase("UpdateLineItemProcessStatus")) {
            int orderNumber = Utility.getIntElement((String)"OrderNumber", (String)this.message);
            int lineNumber = Utility.getIntElement((String)"LineNumber", (String)this.message);
            String processStatus = Utility.getElement((String)"ProcessStatus", (String)this.message);
            this.host.core.updateLineItemProcessStatus(orderNumber, lineNumber, processStatus);
        } else if (action.equalsIgnoreCase("RegisterEMVTerminal")) {
            String terminalId = Utility.getElement((String)"TerminalId", (String)this.message);
            String terminalIpAddress = this.client.getRemoteSocketAddress().getAddress().getHostAddress();
            System.out.println("RegisterEMVTerminal Terminal ID: " + terminalId + " IP Address: " + terminalIpAddress);
            this.host.core.logText("RegisterEMVTerminal Terminal ID: " + terminalId + " IP Address: " + terminalIpAddress);
            this.host.core.registerTerminal(terminalId, terminalIpAddress);
        } else if (action.equalsIgnoreCase("AdapterResponse")) {
            this.host.core.processHostAccountingResponse(action, this.message);
        } else if (action.equalsIgnoreCase("Ping")) {
            this.sendReply("PingResponse", "PingResponse", "OK");
        }
    }

    public void sendReply(String action, String reply, String status) {
        try {
            StringBuffer replyXML = new StringBuffer();
            replyXML.append("<POSServerReply>\n");
            replyXML.append("  <Request>" + action + "</Request>\n");
            replyXML.append("  <Status>" + status + "</Status>\n");
            replyXML.append("  <Message>" + reply + "</Message>\n");
            replyXML.append("</POSServerReply>\n");
            this.client.send(replyXML.toString());
        }
        catch (Exception e) {
            this.host.core.raiseException(e);
        }
    }
}

