/*
 * Decompiled with CFR 0.152.
 */
package AccuServerConnector;

import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.WebSocketHostBase;
import AccuServerConnector.WebSocketConnector;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Hashtable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;

public class WebSocketHost
implements ServerObject,
WebSocketHostBase {
    ServerCore core = null;
    WebSocketConnector webSocket = null;
    Hashtable clientReplies = null;

    public void initialize(ServerCore core, Hashtable parameters) {
        this.core = core;
        StartWebSocketConnector connectorThread = new StartWebSocketConnector();
        connectorThread.start();
        core.setWebSocketHost((WebSocketHostBase)this);
    }

    public void output(String output) {
        this.core.input(output);
    }

    public void handleException(Exception e) {
    }

    public void startup() {
        System.out.println("WebSocketHost Starting");
        this.output("WebSocketHost Starting");
        this.webSocket = new WebSocketConnector(41000, this);
        try {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            FileInputStream trustStoreStream = new FileInputStream(System.getProperty("user.dir") + "/serverTrustStore.jks");
            trustStore.load(trustStoreStream, "abouttime".toCharArray());
            trustManagerFactory.init(trustStore);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            FileInputStream keyStoreStream = new FileInputStream(System.getProperty("user.dir") + "/server.jks");
            keyStore.load(keyStoreStream, "abouttime".toCharArray());
            keyManagerFactory.init(keyStore, "abouttime".toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            this.webSocket.setWebSocketFactory((WebSocketServerFactory)new DefaultSSLWebSocketServerFactory(sslContext));
            this.webSocket.start();
            this.webSocket.setConnectionLostTimeout(90);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getHash(String code) {
        return code;
    }

    public String getClientReply(String key) {
        if (this.clientReplies == null) {
            return null;
        }
        String reply = (String)this.clientReplies.get(key);
        this.clientReplies.remove(key);
        return reply;
    }

    public void setReply(String key, String data) {
        if (this.clientReplies == null) {
            this.clientReplies = new Hashtable();
        }
        this.clientReplies.put(key, data);
    }

    public String waitForReply(String tag) {
        String reply = "";
        boolean waiting = true;
        int timeout = 30;
        do {
            if ((reply = this.getClientReply(tag)) != null && !reply.isEmpty()) {
                waiting = false;
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (waiting);
        return reply;
    }

    public void sendMessage(String displayName, String action, String reply, String status) {
        try {
            StringBuffer replyXML = new StringBuffer();
            replyXML.append("<POSServerReply>\n");
            replyXML.append("  <Request>" + action + "</Request>\n");
            replyXML.append("  <Status>" + status + "</Status>\n");
            replyXML.append("  <Message>" + reply + "</Message>\n");
            replyXML.append("</POSServerReply>\n");
            this.webSocket.sendTo(displayName, replyXML.toString());
        }
        catch (Exception e) {
            this.core.raiseException(e);
        }
    }

    public void sendAllPOSMessage(String message) {
        try {
            StringBuffer replyXML = new StringBuffer();
            replyXML.append("<POSServerReply>\n");
            replyXML.append("  <Request>ShowMessage</Request>\n");
            replyXML.append("  <Status>OK</Status>\n");
            replyXML.append("  <Message>" + message + "</Message>\n");
            replyXML.append("</POSServerReply>\n");
            this.webSocket.sendAllPOSMessage(replyXML.toString());
        }
        catch (Exception e) {
            this.core.raiseException(e);
        }
    }

    public void sendAdapterMessage(String integratorMessage) {
        try {
            StringBuffer replyXML = new StringBuffer();
            replyXML.append("<POSServerReply>\n");
            replyXML.append("  <Message>" + integratorMessage + "</Message>\n");
            replyXML.append("</POSServerReply>\n");
            this.webSocket.sendAdapterMessage(replyXML.toString());
        }
        catch (Exception e) {
            this.core.raiseException(e);
        }
    }

    class StartWebSocketConnector
    extends Thread {
        @Override
        public void run() {
            WebSocketHost.this.startup();
        }
    }
}

